(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13096,        463]
NotebookOptionsPosition[      9951,        361]
NotebookOutlinePosition[     11403,        400]
CellTagsIndexPosition[     11318,        395]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/WordSeparators"], "NullWords" :> 
          Documentation`HelpLookup["paclet:ref/NullWords"], "RecordLists" :> 
          Documentation`HelpLookup["paclet:ref/RecordLists"], "Record" :> 
          Documentation`HelpLookup["paclet:ref/Record"], "StringSplit" :> 
          Documentation`HelpLookup["paclet:ref/StringSplit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WordSeparators\"\>", 
       2->"\<\"NullWords\"\>", 3->"\<\"RecordLists\"\>", 4->"\<\"Record\"\>", 
       5->"\<\"StringSplit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RecordSeparators", "ObjectName",
 CellID->10886],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RecordSeparators",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Find",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Find"]], "InlineFormula"],
     " and related functions which specifies the list of strings to be taken \
as delimiters for records. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"RecordSeparators", "->", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\[Backslash]n\>\"", ",", " ", "\"\<\\r\\n\>\"", ",", "\"\<\\r\>\""}],
     " ", "}"}]}]], "InlineFormula"],
 ". With this setting, each complete line of input on any computer system is \
considered as a record. "
}], "Notes",
 CellID->4816],

Cell["\<\
Strings used as record separators may contain several characters. \
\>", "Notes",
 CellID->30196],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NullRecords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullRecords"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", any number of record separators may appear between any two successive \
records. "
}], "Notes",
 CellID->14812],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RecordSeparators", "->", 
   RowBox[{"{", "}"}]}]], "InlineFormula"],
 " specifies that everything is to be included in a single record. "
}], "Notes",
 CellID->28890],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RecordSeparators", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["lsep", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["rsep", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies different left and right separators for records. When there are \
nested left and right separators, records are taken to be delimited by the \
innermost balanced pairs of separators. "
}], "Notes",
 CellID->9131],

Cell["\<\
Text that does not appear between left and right separators is discarded. \
\>", "Notes",
 CellID->14312]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121109434],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->3654861],

Cell[TextData[{
 "Use \"",
 Cell[BoxData["."], "InlineFormula"],
 "\"",
 " as a record separator:"
}], "ExampleText",
 CellID->507935061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<12.6754.23.42.342.242.43\>\"", "]"}], 
   ",", "Record", ",", 
   RowBox[{"RecordSeparators", "\[Rule]", "\"\<.\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43190332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"12\"\>", ",", "\<\"6754\"\>", ",", "\<\"23\"\>", 
   ",", "\<\"42\"\>", ",", "\<\"342\"\>", ",", "\<\"242\"\>", 
   ",", "\<\"43\"\>"}], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40616703]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134734833],

Cell[TextData[{
 "Use \"",
 Cell[BoxData["<"], "InlineFormula"],
 "\" as a left separator, and \"",
 Cell[BoxData[">"], "InlineFormula"],
 "\"",
 " as right separator:"
}], "ExampleText",
 CellID->743767998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<<x<aaa>yyy<<bbb>>>\>\"", "]"}], ",", 
   "Record", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "\"\<<\>\"", "}"}], ",", 
      RowBox[{"{", "\"\<>\>\"", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11113495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aaa\"\>", ",", "\<\"bbb\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210613406]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14499],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullWords"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RecordLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RecordLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Record",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Record"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24330],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->7268]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RecordSeparators - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 28.4542864}", "context" -> "System`", 
    "keywords" -> {
     "delimiters", "extracting", "filtering", "ignore data", "newlines", 
      "reading data containing brackets", "separators", "skip"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RecordSeparators is an option for Read, Find and related functions which \
specifies the list of strings to be taken as delimiters for records. ", 
    "synonyms" -> {"record separators"}, "title" -> "RecordSeparators", 
    "type" -> "Symbol", "uri" -> "ref/RecordSeparators"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5523, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->121109434]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11175, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1589, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2212, 63, 54, 1, 70, "ObjectName",
 CellID->10886],
Cell[2269, 66, 790, 24, 70, "Usage",
 CellID->20128]
}, Open  ]],
Cell[CellGroupData[{
Cell[3096, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3574, 112, 375, 11, 70, "Notes",
 CellID->4816],
Cell[3952, 125, 107, 3, 70, "Notes",
 CellID->30196],
Cell[4062, 130, 390, 13, 70, "Notes",
 CellID->14812],
Cell[4455, 145, 209, 6, 70, "Notes",
 CellID->28890],
Cell[4667, 153, 701, 21, 70, "Notes",
 CellID->9131],
Cell[5371, 176, 115, 3, 70, "Notes",
 CellID->14312]
}, Closed]],
Cell[CellGroupData[{
Cell[5523, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121109434],
Cell[CellGroupData[{
Cell[5908, 198, 146, 5, 70, "ExampleSection",
 CellID->3654861],
Cell[6057, 205, 137, 6, 70, "ExampleText",
 CellID->507935061],
Cell[CellGroupData[{
Cell[6219, 215, 271, 7, 28, "Input",
 CellID->43190332],
Cell[6493, 224, 328, 9, 36, "Output",
 CellID->40616703]
}, Open  ]],
Cell[6836, 236, 125, 3, 70, "ExampleDelimiter",
 CellID->134734833],
Cell[6964, 241, 207, 8, 70, "ExampleText",
 CellID->743767998],
Cell[CellGroupData[{
Cell[7196, 253, 373, 11, 70, "Input",
 CellID->11113495],
Cell[7572, 266, 223, 7, 36, "Output",
 CellID->210613406]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7856, 280, 311, 9, 70, "SeeAlsoSection",
 CellID->14499],
Cell[8170, 291, 1207, 44, 70, "SeeAlso",
 CellID->6900]
}, Open  ]],
Cell[CellGroupData[{
Cell[9414, 340, 314, 9, 70, "TutorialsSection",
 CellID->24330],
Cell[9731, 351, 148, 3, 70, "Tutorials",
 CellID->7268]
}, Open  ]],
Cell[9894, 357, 27, 0, 70, "History"],
Cell[9924, 359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

