(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95759,       2714]
NotebookOptionsPosition[     86396,       2392]
NotebookOutlinePosition[     87818,       2431]
CellTagsIndexPosition[     87732,       2426]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polygon" :> Documentation`HelpLookup["paclet:ref/Polygon"], 
          "Raster" :> Documentation`HelpLookup["paclet:ref/Raster"], "Cuboid" :> 
          Documentation`HelpLookup["paclet:ref/Cuboid"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"], "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "Rotate" :> 
          Documentation`HelpLookup["paclet:ref/Rotate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Polygon\"\>", 2->"\<\"Raster\"\>", 
       3->"\<\"Cuboid\"\>", 4->"\<\"Inset\"\>", 5->"\<\"GraphicsGrid\"\>", 
       6->"\<\"Rotate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Rectangle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rectangle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rectangle"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a two\[Hyphen]dimensional graphics primitive that \
represents a filled rectangle, oriented parallel to the axes. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rectangle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rectangle"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["min", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]corresponds to a unit square. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " can be used to specify coordinates. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19919],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to a suitable ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " with four corners. "
}], "Notes",
 CellID->27232],

Cell[TextData[{
 "Graphics directives such as ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " can be used to specify how rectangles should be drawn. "
}], "Notes",
 CellID->28592],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify separately how the interiors and boundaries of \
rectangles should be drawn. The default is that no explicit edge is drawn. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19502],

Cell[TextData[{
 "Coordinates and lists of coordinates in rectangles can be ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->14617],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21526]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43473608],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->31652120],

Cell["A unit square:", "ExampleText",
 CellID->177501753],

Cell[CellGroupData[{

Cell["Graphics[Rectangle[]]", "Input",
 CellLabel->"In[1]:=",
 CellID->464575169],

Cell[BoxData[
 GraphicsBox[RectangleBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->374256217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502201115],

Cell["Two squares:", "ExampleText",
 CellID->30710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", 
    RowBox[{"Rectangle", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "Blue", ",", 
    RowBox[{"Rectangle", "[", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19275],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{0, 0}]}, 
   {RGBColor[0, 0, 1], RectangleBox[{0.5, 0.5}]}}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->339474770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123211517],

Cell["Various rectangles:", "ExampleText",
 CellID->177668861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ",", "Blue", ",", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->637321948],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{0, 0}, {1, 3}]}, 
   {RGBColor[0, 0, 1], RectangleBox[{2, 1}, {4, 2}]}}]], "Output",
 ImageSize->{154, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->80458739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25742151],

Cell["Differently styled rectangles:", "ExampleText",
 CellID->449569243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "Pink", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", "Pink", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      "Pink", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169323049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[Large]], 
     RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{Small, Small}]], 
     RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
     Dashing[{Small, Small}]}], RectangleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->307712691]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6872],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Rectangle Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->132463176],

Cell["A unit square", "ExampleText",
 CellID->313723454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Rectangle", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164192133],

Cell[BoxData[
 GraphicsBox[RectangleBox[{1, 1}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->639377717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13858764],

Cell["A rectangle parallel to each axis:", "ExampleText",
 CellID->337319626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Rectangle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659097741],

Cell[BoxData[
 GraphicsBox[RectangleBox[{0, 0}, {2, 1}]]], "Output",
 ImageSize->{104, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->138605697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170708665],

Cell[TextData[{
 "Short form for a unit cube cornered at the origin: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21526,
  ButtonNote->"21526"]
}], "ExampleText",
 CellID->1005391678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->577218273],

Cell[BoxData[
 GraphicsBox[RectangleBox[{0, 0}],
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7847283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Rectangle Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->87241538],

Cell["Color directives specify the face colors of rectangles:", "ExampleText",
 CellID->548487152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131293861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], RectangleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->20173670]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify the styles of the interiors and boundaries: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19502,
  ButtonNote->"19502"]
}], "ExampleText",
 CellID->256826622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->661585738],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}], 
   FaceForm[RGBColor[1, 0.5, 0.5]], RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->12771789]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->379373147],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19919]
}], "ExampleText",
 CellID->56389194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382057945],

Cell[BoxData[
 GraphicsBox[RectangleBox[Scaled[{0, 0.4}], Scaled[{1, 0.6}]],
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->466349804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37715689],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->650862043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->630617136],

Cell[BoxData[
 GraphicsBox[RectangleBox[ImageScaled[{0, 0.4}], ImageScaled[{1, 0.6}]],
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->649476389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125464266],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19919]
}], "ExampleText",
 CellID->585085885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", 
         RowBox[{"-", "20"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->556921787],

Cell[BoxData[
 GraphicsBox[
  RectangleBox[Offset[{10, 20}, {0, 0}], Offset[{-10, -20}, {1, 1}]],
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->45328986]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27543],

Cell["A simple bar chart:", "ExampleText",
 CellID->375043476],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306299627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "Blue", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Rectangle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"i", "-", ".4"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"data", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
         "Red", ",", 
         RowBox[{"Rectangle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"i", "+", ".4"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"data", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298166574],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnc9u00AQxjeJK7W0qcqt4tIWqUIo9NQSOHCGEw8RVUjtAYFKEVfEe/A2
PAPibYzHf1Jn48SO7dTrnV+lbDLe9bcz3zee2I7tfpzd33z6PLu/vZ6dfrib
fb25vf52+v7LXbRoNDBm8MoY8+fYRJ/D6FP8kr+L6JV8XP3pMmqDaIU3Yo2y
NUPzOmqG6XJ5v4repXuY2kfx2le5tUwBStwfPNgmxl1csjxmaKGM48WvC7CD
QsT6c0ytpZdWfNMlnGnKx/Kc1Wa4Stefpvwuz1DV98uVvhVpW2+OzNu3Vm82
U/aejRuF+WyRoVVycjf14Vwoj61F38bW7PuWfVDSX2b7vv4AXrfIa5z0ySez
Y42YWLZdDTa1D6MmnXVBycAaJ81ZS2ODtDocp/ZxGmcTe5jilvk2yuz4Wy40
u9KMMsuYPWly44fW+D1r/K41Hvzu8avkqA9xgl8pD9ZUUx+iBL9KFuyivDp8
lNeKj/Ja8VFeKz7Ka8V/UF46fIgIfAv/4Vg+VZktXSM+NV4rPsprxUd5rfgo
rxUf5bXio7xWfJTXis/5G+/xOX8DfkiN14uP8lrxUV4rPsprxUd5rfgorxWf
o3jv8TmKBz+kxuvFR3mt+CivFR/lteKjvFb8RHnZ3ee+aX342f3zYscd5IFK
/CQP5mvmeoL88h5HCP5q/ORpKvNZbBRPogS/ah0gE8DnyTrg5/JglGSA/PFk
HX34nB/Qio/yWvFRXis+ymvF58oe7/G5sgf8kBqvFx/lteKjvFZ8lNeKj/Ja
8VFeKz7Ka8Xn/I33+Jy/AT+kxvuDP47MJyjsKf7hXD+2Zb/xUboJ/oHJXVnm
iJ8o2hzfYtIRf1EWZVHWZ2Wloz+Mt4cvRxNHjvlVqBznMZbwTxzzh1qKcl1H
gnIoh3Io54Zyc0/smRxlGiVR0ncleXZNO+rVOQNbXaVsqUln0fhckfa2MYv9
ltQKUqVSmQz3eruuWH77QrX+qcZeSF+V4xhueXzRHgSKdL/tFDOvSxn5XSRo
AQcFmjFXxgRKoESZEvI983QjxqUDpuvmfNL/rIhxp3/F9Zh3aot65qUK2ld6
wHBbDNuRwyzMwizMwizM1mdWOmC0BqMOHGd4ySs1AGZhFmZhFmZhFmZhtlNm
pQNGazDK8QE1AGZhFmZh1htmu7ymt4jlOncIOMRmp//LbnXWlsXZP14f494O
3/gMyNEt5qgsdKGC+sFm9r0kLay2xaowMTRs9T7umcIkTMIkTLrLpHT4yOD6
56GtYcrpM8rb4WvSakY9JlOnUbNvcneFqGfkHUzABEzABEx4wYR0qGDAgf2u
Ih7kt4/nCnO/WmRETuREno88+63UzwgnRNbzyLrdn2gnopfhJnsIdZ4A42K2
Jf2b3lsvkUhNuuiNx9/x1GFP612b1LnXNa+vwO92smT9lUGrvZXK9aOhVy+i
ZmerbCb9P51XvXU/t1IL2vayvdqKZ3jWV89GZt1+/+N4tNl+Oyr67Jkclf3q
zIPfzNzbmatUsqYz1q9UvrDMzC7PXPWMTr0Z/jZCFt/+5Xxc3HJl2Em4auuS
5mwl+sSypw3tw8WZFo66xtbYfcs+KOkvs31fH163zauweR5bZvAfA4bStg==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->218310801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->250842546],

Cell["Golden Rectangle:", "ExampleText",
 CellID->162910670],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", "0", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Phi]", "=", "GoldenRatio"}], ",", 
       RowBox[{"m", "=", 
        RowBox[{"Mod", "[", 
         RowBox[{"n", ",", "4"}], "]"}]}], ",", "a", ",", "b", ",", "c", ",", 
       "d"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "=", 
       RowBox[{"gr", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{"n", ",", "4"}], "]"}], ",", "0", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a", "+", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}], ",", 
            RowBox[{"d", "-", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}]}], "}"}]}], "}"}], ",", "1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", 
            RowBox[{"d", "+", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "+", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}], ",", "d"}], "}"}]}], "}"}], ",", "2", 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "-", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}], ",", 
            RowBox[{"b", "+", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"c", ",", "b"}], "}"}]}], "}"}], ",", "3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a", "-", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}], ",", "b"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", 
            RowBox[{"b", "-", 
             RowBox[{"\[Phi]", "^", 
              RowBox[{"-", "n"}]}]}]}], "}"}]}], "}"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->363065324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Opacity", "[", ".5", "]"}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ColorData", "[", 
         RowBox[{"24", ",", 
          RowBox[{"k", "+", "1"}]}], "]"}], ",", 
        RowBox[{"Rectangle", "@@", 
         RowBox[{"gr", "[", "k", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "8"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->465472184],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj1LQmEcxY89ktkbNIgOETbZK7QVFGgZNhUI4RANXSRQJBWTqEXu0BD0
KZoagiBoaIo+SEN7Q9AXsPNXcAgXrRY7cu7hQZ7f73/vBUEud9erF45PvHox
78V3al61UMyfxjOVGr9yASCwBOA5Bq6bXLUO+yzzaC97Ww2zH86Sq3Dr8Wn/
0IKSlfN9v2VuItjZCcet740yg3sro5pPawxKVqJEiRIlSpQoUaJEiRIlSpQo
UaJEiRIlStRgUPP7RwyiVi6ysDK1lWUwyUpflHsxZW9fGEStzDR7ecNgwspR
9/laYbBpJausssr6P6zbMwkGQ1ZmSaVS44tJhFnp/s0hmq829tqhmgw9CEdz
DTiqf37ufz/BjUViXe6ODRj5xSm8jsfGNQPXqoNkhnYbENKUQZzy/V8NxQyC
rNHef3V3bx8MElYuVz3v75xkkUUWWWSRRRZZZJFlQCydN3C5mcEcq/vTQ1v2
+64vAl/IZQpY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->496848994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55751473],

Cell["Square wheel:", "ExampleText",
 CellID->722904819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q", "=", 
        RowBox[{"Quotient", "[", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], ",", 
       RowBox[{"m", "=", 
        RowBox[{"Mod", "[", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightGray", ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Rectangle", "[", 
            RowBox[{"{", 
             RowBox[{"q", ",", "0"}], "}"}], "]"}], ",", 
           RowBox[{"-", "m"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"q", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"Axes", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".5"}], ",", "5.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
   RowBox[{"DefaultDuration", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367346177],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Theta]$$], 0, 2 Pi}}, Typeset`size$$ = {
    350., {56., 61.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Theta]$429645$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$429645$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`q = 
         Quotient[$CellContext`\[Theta]$$, Pi/2], $CellContext`m = 
         Mod[$CellContext`\[Theta]$$, Pi/2]}, 
        Graphics[{
          EdgeForm[Black], LightGray, 
          Rotate[
           
           Rectangle[{$CellContext`q, 0}], -$CellContext`m, {$CellContext`q + 
            1, 0}]}, Axes -> {True, False}, 
         PlotRange -> {{-0.5, 5.5}, {-0.5, 1.5}}, ImageSize -> 350]], 
      "Specifications" :> {{$CellContext`\[Theta]$$, 0, 2 Pi, 
         AnimationRunning -> False, AnimationDirection -> ForwardBackward, 
         DefaultDuration -> 2, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 4.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{396., {93., 98.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{400, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527539671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209306141],

Cell["The trajectory of the square wheel:", "ExampleText",
 CellID->69203279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
     RowBox[{"FaceForm", "[", "LightGray", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"q", "=", 
            RowBox[{"Quotient", "[", 
             RowBox[{"\[Theta]", ",", 
              RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], ",", 
           RowBox[{"m", "=", 
            RowBox[{"Mod", "[", 
             RowBox[{"\[Theta]", ",", 
              RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}]}], "}"}], ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Rectangle", "[", 
            RowBox[{"{", 
             RowBox[{"q", ",", "0"}], "}"}], "]"}], ",", 
           RowBox[{"-", "m"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"q", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"Pi", "/", "12"}]}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".5"}], ",", "5.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3305262],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[GrayLevel[0.85]], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{1, 0}, {0, 1}}, {0, 0}}], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.9659258262890682, 
     0.2588190451025207}, {-0.2588190451025207, 0.9659258262890682}}, {
     0.0340741737109318, 0.2588190451025207}}], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.8660254037844386, 0.5}, {-0.5, 
     0.8660254037844386}}, {0.1339745962155614, 0.5}}], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.7071067811865475, 
     0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}}, {
     0.29289321881345254`, 0.7071067811865475}}], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.5, 0.8660254037844386}, {-0.8660254037844386, 
     0.5}}, {0.5, 0.8660254037844386}}], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.2588190451025207, 
     0.9659258262890682}, {-0.9659258262890682, 0.2588190451025207}}, {
     0.7411809548974793, 0.9659258262890682}}], 
   GeometricTransformationBox[
    RectangleBox[{1, 0}], {{{1, 0}, {0, 1}}, {0, 0}}], 
   GeometricTransformationBox[
    RectangleBox[{1, 0}], {{{0.9659258262890682, 
     0.2588190451025207}, {-0.2588190451025207, 0.9659258262890682}}, {
     0.0681483474218636, 0.5176380902050414}}], 
   GeometricTransformationBox[
    RectangleBox[{1, 0}], {{{0.8660254037844386, 0.5}, {-0.5, 
     0.8660254037844386}}, {0.2679491924311228, 1}}], 
   GeometricTransformationBox[
    RectangleBox[{1, 0}], {{{0.7071067811865475, 
     0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}}, {
     0.5857864376269049, 1.4142135623730951`}}], 
   GeometricTransformationBox[
    RectangleBox[{1, 0}], {{{0.5, 0.8660254037844386}, {-0.8660254037844386, 
     0.5}}, {1, 1.7320508075688772`}}], 
   GeometricTransformationBox[
    RectangleBox[{1, 0}], {{{0.2588190451025207, 
     0.9659258262890682}, {-0.9659258262890682, 0.2588190451025207}}, {
     1.4823619097949585`, 1.9318516525781364`}}], 
   GeometricTransformationBox[
    RectangleBox[{2, 0}], {{{1, 0}, {0, 1}}, {0, 0}}], 
   GeometricTransformationBox[
    RectangleBox[{2, 0}], {{{0.9659258262890682, 
     0.2588190451025207}, {-0.2588190451025207, 0.9659258262890682}}, {
     0.1022225211327954, 0.776457135307562}}], 
   GeometricTransformationBox[
    RectangleBox[{2, 0}], {{{0.8660254037844386, 0.5}, {-0.5, 
     0.8660254037844386}}, {0.401923788646684, 1.5}}], 
   GeometricTransformationBox[
    RectangleBox[{2, 0}], {{{0.7071067811865475, 
     0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}}, {
     0.8786796564403576, 2.1213203435596424`}}], 
   GeometricTransformationBox[
    RectangleBox[{2, 0}], {{{0.5, 0.8660254037844386}, {-0.8660254037844386, 
     0.5}}, {1.5, 2.598076211353316}}], 
   GeometricTransformationBox[
    RectangleBox[{2, 0}], {{{0.2588190451025207, 
     0.9659258262890682}, {-0.9659258262890682, 0.2588190451025207}}, {
     2.223542864692438, 2.8977774788672046`}}], 
   GeometricTransformationBox[
    RectangleBox[{3, 0}], {{{1, 0}, {0, 1}}, {0, 0}}], 
   GeometricTransformationBox[
    RectangleBox[{3, 0}], {{{0.9659258262890682, 
     0.2588190451025207}, {-0.2588190451025207, 0.9659258262890682}}, {
     0.13629669484372675`, 1.035276180410083}}], 
   GeometricTransformationBox[
    RectangleBox[{3, 0}], {{{0.8660254037844386, 0.5}, {-0.5, 
     0.8660254037844386}}, {0.5358983848622456, 2}}], 
   GeometricTransformationBox[
    RectangleBox[{3, 0}], {{{0.7071067811865475, 
     0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}}, {
     1.1715728752538097`, 2.8284271247461903`}}], 
   GeometricTransformationBox[
    RectangleBox[{3, 0}], {{{0.5, 0.8660254037844386}, {-0.8660254037844386, 
     0.5}}, {2, 3.4641016151377544`}}], 
   GeometricTransformationBox[
    RectangleBox[{3, 0}], {{{0.2588190451025207, 
     0.9659258262890682}, {-0.9659258262890682, 0.2588190451025207}}, {
     2.964723819589917, 3.8637033051562732`}}], 
   GeometricTransformationBox[
    RectangleBox[{4, 0}], {{{1, 0}, {0, 1}}, {0, 0}}]},
  Axes->{True, False},
  ImageSize->350,
  PlotRange->{{-0.5, 5.5}, {-0.5, 1.5}}]], "Output",
 ImageSize->{354, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151219961]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24570],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 " to get all possible rectangles:"
}], "ExampleText",
 CellID->19774549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"30", "Degree"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283111600],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}, {4, 3}], {{{0.8660254037844386, -0.5}, {0.5, 
     0.8660254037844386}}, Center}]},
  Frame->True]], "Output",
 ImageSize->{154, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->85903685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516760770],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rectangle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rectangle"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->233193187],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377448371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "d"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7936952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RectangleBox[{1, 2}, {3, 4}],
    Frame->True], ",", 
   GraphicsBox[PolygonBox[{{1, 2}, {3, 2}, {3, 4}, {1, 4}}],
    Frame->True]}], "}"}]], "Output",
 ImageSize->{330, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->772627905]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9014],

Cell["Random square collections:", "ExampleText",
 CellID->327524129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Rectangle", "[", 
           RowBox[{"RandomReal", "[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"2", "Pi"}], "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", "20", "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27677],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], 
   {Hue[0.8399646814047568], 
    GeometricTransformationBox[
     RectangleBox[{0.7515690823169199, 0.5589840319979316}], \
{{{-0.99868445877398, 
      0.05127720549447336}, {-0.05127720549447336, -0.99868445877398}}, 
      Center}]}, 
   {Hue[0.7179044209967207], 
    GeometricTransformationBox[
     RectangleBox[{1.7739295510630688`, 1.599383638268538}], \
{{{-0.6357430322294934, 
      0.7719007688632324}, {-0.7719007688632324, -0.6357430322294934}}, 
      Center}]}, 
   {Hue[0.37216978254974475`], 
    GeometricTransformationBox[
     RectangleBox[{1.6344089115880385`, 0.15446713975744952`}], \
{{{-0.702518269623892, 
      0.7116657086333813}, {-0.7116657086333813, -0.702518269623892}}, 
      Center}]}, 
   {Hue[0.643133512852758], 
    GeometricTransformationBox[
     RectangleBox[{1.7888179792893188`, 0.09249585755859391}], \
{{{-0.375954678829012, 
      0.926638052028177}, {-0.926638052028177, -0.375954678829012}}, 
      Center}]}, 
   {Hue[0.44843068598066527`], 
    GeometricTransformationBox[
     RectangleBox[{1.208185778796227, 0.9763845120233356}], \
{{{-0.8863758632232925, -0.46296633689196354`}, {
      0.46296633689196354`, -0.8863758632232925}}, Center}]}, 
   {Hue[0.03145497615428772], 
    GeometricTransformationBox[
     RectangleBox[{0.034295166042563, 0.15589003837608706`}], {{{
      0.9007920280415171, -0.43425075960422993`}, {0.43425075960422993`, 
      0.9007920280415171}}, Center}]}, 
   {Hue[0.03872778903030527], 
    GeometricTransformationBox[
     RectangleBox[{1.595670636581568, 1.9678953483284216`}], \
{{{-0.7155696262050045, 
      0.6985414161328088}, {-0.6985414161328088, -0.7155696262050045}}, 
      Center}]}, 
   {Hue[0.6442748869968369], 
    GeometricTransformationBox[
     RectangleBox[{0.5211839006545103, 1.3990943281721666`}], \
{{{-0.9626926540476939, -0.27059721698976724`}, {
      0.27059721698976724`, -0.9626926540476939}}, Center}]}, 
   {Hue[0.8474308684402538], 
    GeometricTransformationBox[
     RectangleBox[{0.5609996765634468, 0.1328597591340266}], {{{
      0.9492222623318674, 0.3146062566027122}, {-0.3146062566027122, 
      0.9492222623318674}}, Center}]}, 
   {Hue[0.9515156773278004], 
    GeometricTransformationBox[
     RectangleBox[{1.492544231130633, 1.2958564276821147`}], \
{{{-0.828026419853707, -0.5606890832040985}, {
      0.5606890832040985, -0.828026419853707}}, Center}]}, 
   {Hue[0.17495751649939306`], 
    GeometricTransformationBox[
     RectangleBox[{1.5808250437828097`, 1.199579019240013}], {{{
      0.4985552685379283, -0.8668579146625324}, {0.8668579146625324, 
      0.4985552685379283}}, Center}]}, 
   {Hue[0.04881143988445502], 
    GeometricTransformationBox[
     RectangleBox[{1.2709402539940715`, 1.0902223548863086`}], \
{{{-0.9029312907371014, 
      0.4297849278509335}, {-0.4297849278509335, -0.9029312907371014}}, 
      Center}]}, 
   {Hue[0.3036647732710265], 
    GeometricTransformationBox[
     RectangleBox[{1.982157804471353, 0.9415812936950618}], \
{{{-0.9505136467845935, -0.3106828081440187}, {
      0.3106828081440187, -0.9505136467845935}}, Center}]}, 
   {Hue[0.48993298079391456`], 
    GeometricTransformationBox[
     RectangleBox[{1.9387354334683065`, 1.003821174290791}], {{{
      0.7192917146024013, 0.6947081612478276}, {-0.6947081612478276, 
      0.7192917146024013}}, Center}]}, 
   {Hue[0.7412739429784807], 
    GeometricTransformationBox[
     RectangleBox[{0.2942914496358844, 1.541219800462049}], {{{
      0.7056703918833008, 0.7085402585734057}, {-0.7085402585734057, 
      0.7056703918833008}}, Center}]}, 
   {Hue[0.7102739712528785], 
    GeometricTransformationBox[
     RectangleBox[{1.763630209184536, 0.13739881973808554`}], {{{
      0.9895970069240893, 0.14386717445923514`}, {-0.14386717445923514`, 
      0.9895970069240893}}, Center}]}, 
   {Hue[0.2937946987022433], 
    GeometricTransformationBox[
     RectangleBox[{0.47429794518967094`, 1.2249837351576067`}], {{{
      0.38634606391021525`, -0.9223539011144712}, {0.9223539011144712, 
      0.38634606391021525`}}, Center}]}, 
   {Hue[0.5894288187004186], 
    GeometricTransformationBox[
     RectangleBox[{0.9440199424751321, 0.2289578938650898}], \
{{{-0.5225978806921672, 
      0.8525792954887278}, {-0.8525792954887278, -0.5225978806921672}}, 
      Center}]}, 
   {Hue[0.8968812738459351], 
    GeometricTransformationBox[
     RectangleBox[{1.012320065000393, 1.272826562252214}], {{{
      0.39058077463379653`, -0.9205686603868629}, {0.9205686603868629, 
      0.39058077463379653`}}, Center}]}, 
   {Hue[0.13986173144852665`], 
    GeometricTransformationBox[
     RectangleBox[{1.4035912308683303`, 1.5356274927927762`}], \
{{{-0.6377939001231148, -0.7702070766785685}, {
      0.7702070766785685, -0.6377939001231148}}, Center}]}}]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72352552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235941495],

Cell["A color wheel:", "ExampleText",
 CellID->295179799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".5", "]"}], "]"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t", "+", "k"}], ")"}], "/", "20"}], ",", "1", ",", 
            ".9"}], "]"}], ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Rectangle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"Pi", "/", "20"}], "]"}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "+", 
                 RowBox[{"2", 
                  RowBox[{"Sin", "[", 
                   RowBox[{"Pi", "/", "20"}], "]"}]}]}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"Pi", "/", "20"}], "]"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"2", "Pi", " ", 
             RowBox[{"t", "/", "20"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "20"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54842079],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`k$$ = 5.9875, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`k$$], 1, 20}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`k$430841$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`k$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`k$$, $CellContext`k$430841$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         EdgeForm[
          Opacity[0.5]], 
         Table[{
           Hue[($CellContext`t + $CellContext`k$$)/20, 1, 0.9], 
           Rotate[
            Rectangle[{1, -Sin[Pi/20]}, {1 + 2 Sin[Pi/20], 
              Sin[Pi/20]}], (2 Pi) ($CellContext`t/20), {0, 
            0}]}, {$CellContext`t, 20}]}], 
      "Specifications" :> {{$CellContext`k$$, 1, 20, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {125., 130.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->865229318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282122593],

Cell["Digital petals:", "ExampleText",
 CellID->54371934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".6", "]"}], "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "+", "q", "+", 
          RowBox[{"10", " ", "r"}]}], ")"}], "/", "72"}], "]"}], ",", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", "=", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"q", "/", "12"}]}]}], "}"}], ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Rectangle", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8", "-", "r"}], ")"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "t", "]"}], ",", 
                 RowBox[{"Sin", "[", "t", "]"}]}], "}"}], "-", 
               RowBox[{"1", "/", "4"}]}], ")"}]}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8", "-", "r"}], ")"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "t", "]"}], ",", 
                 RowBox[{"Sin", "[", "t", "]"}]}], "}"}], "+", 
               RowBox[{"1", "/", "4"}]}], ")"}]}]}], "]"}], ",", 
          RowBox[{"t", "+", 
           RowBox[{"Pi", "/", "4"}]}]}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "12"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698775468],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59175154]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29911],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Raster",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Raster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid",
    ButtonNote->"ObsLink: GraphicsArray -> GraphicsGrid (Grid)"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Rectangle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Rectangle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->126238941],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->35070537],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->222766751],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->133664019]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rectangle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 32.6418936}", "context" -> "System`", 
    "keywords" -> {
     "graphics rectangle", "square", "rectangle", "graphics square", 
      "polygon"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Rectangle[{x_min, y_min}, {x_max, y_max}] is a two-dimensional graphics \
primitive that represents a filled rectangle, oriented parallel to the axes. \
Rectangle[{x_min, y_min}] corresponds to a unit square. ", "synonyms" -> {}, 
    "title" -> "Rectangle", "type" -> "Symbol", "uri" -> "ref/Rectangle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12193, 349, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43473608]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 87589, 2419}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2007, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2630, 70, 4193, 83, 70, "ObjectNameGrid"],
Cell[6826, 155, 1527, 48, 70, "Usage",
 CellID->2469]
}, Open  ]],
Cell[CellGroupData[{
Cell[8390, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8868, 225, 373, 13, 70, "Notes",
 CellID->19919],
Cell[9244, 240, 801, 30, 70, "Notes",
 CellID->27232],
Cell[10048, 272, 511, 18, 70, "Notes",
 CellID->28592],
Cell[10562, 292, 622, 17, 70, "Notes",
 CellID->19502],
Cell[11187, 311, 368, 11, 70, "Notes",
 CellID->14617],
Cell[11558, 324, 598, 20, 70, "Notes",
 CellID->21526]
}, Closed]],
Cell[CellGroupData[{
Cell[12193, 349, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43473608],
Cell[CellGroupData[{
Cell[12577, 363, 147, 5, 70, "ExampleSection",
 CellID->31652120],
Cell[12727, 370, 57, 1, 70, "ExampleText",
 CellID->177501753],
Cell[CellGroupData[{
Cell[12809, 375, 81, 2, 28, "Input",
 CellID->464575169],
Cell[12893, 379, 244, 7, 121, "Output",
 CellID->374256217]
}, Open  ]],
Cell[13152, 389, 125, 3, 70, "ExampleDelimiter",
 CellID->502201115],
Cell[13280, 394, 51, 1, 70, "ExampleText",
 CellID->30710],
Cell[CellGroupData[{
Cell[13356, 399, 358, 11, 70, "Input",
 CellID->19275],
Cell[13717, 412, 322, 9, 171, "Output",
 CellID->339474770]
}, Open  ]],
Cell[14054, 424, 125, 3, 70, "ExampleDelimiter",
 CellID->123211517],
Cell[14182, 429, 62, 1, 70, "ExampleText",
 CellID->177668861],
Cell[CellGroupData[{
Cell[14269, 434, 524, 17, 70, "Input",
 CellID->637321948],
Cell[14796, 453, 333, 9, 135, "Output",
 CellID->80458739]
}, Open  ]],
Cell[15144, 465, 124, 3, 70, "ExampleDelimiter",
 CellID->25742151],
Cell[15271, 470, 73, 1, 70, "ExampleText",
 CellID->449569243],
Cell[CellGroupData[{
Cell[15369, 475, 890, 26, 70, "Input",
 CellID->169323049],
Cell[16262, 503, 688, 19, 123, "Output",
 CellID->307712691]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16999, 528, 215, 7, 70, "ExampleSection",
 CellID->6872],
Cell[CellGroupData[{
Cell[17239, 539, 244, 7, 70, "ExampleSubsection",
 CellID->132463176],
Cell[17486, 548, 56, 1, 70, "ExampleText",
 CellID->313723454],
Cell[CellGroupData[{
Cell[17567, 553, 189, 6, 70, "Input",
 CellID->164192133],
Cell[17759, 561, 244, 7, 121, "Output",
 CellID->639377717]
}, Open  ]],
Cell[18018, 571, 124, 3, 70, "ExampleDelimiter",
 CellID->13858764],
Cell[18145, 576, 77, 1, 70, "ExampleText",
 CellID->337319626],
Cell[CellGroupData[{
Cell[18247, 581, 266, 9, 70, "Input",
 CellID->659097741],
Cell[18516, 592, 251, 7, 73, "Output",
 CellID->138605697]
}, Open  ]],
Cell[18782, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->170708665],
Cell[18910, 607, 216, 7, 70, "ExampleText",
 CellID->1005391678],
Cell[CellGroupData[{
Cell[19151, 618, 196, 6, 70, "Input",
 CellID->577218273],
Cell[19350, 626, 257, 8, 169, "Output",
 CellID->7847283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19656, 640, 237, 7, 70, "ExampleSubsection",
 CellID->87241538],
Cell[19896, 649, 98, 1, 70, "ExampleText",
 CellID->548487152],
Cell[CellGroupData[{
Cell[20019, 654, 387, 13, 70, "Input",
 CellID->131293861],
Cell[20409, 669, 516, 16, 123, "Output",
 CellID->20173670]
}, Open  ]],
Cell[20940, 688, 480, 16, 70, "ExampleText",
 CellID->256826622],
Cell[CellGroupData[{
Cell[21445, 708, 359, 10, 70, "Input",
 CellID->661585738],
Cell[21807, 720, 359, 9, 121, "Output",
 CellID->12771789]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22215, 735, 245, 7, 70, "ExampleSubsection",
 CellID->379373147],
Cell[22463, 744, 278, 11, 70, "ExampleText",
 CellID->56389194],
Cell[CellGroupData[{
Cell[22766, 759, 621, 20, 70, "Input",
 CellID->382057945],
Cell[23390, 781, 320, 9, 174, "Output",
 CellID->466349804]
}, Open  ]],
Cell[23725, 793, 124, 3, 70, "ExampleDelimiter",
 CellID->37715689],
Cell[23852, 798, 205, 8, 70, "ExampleText",
 CellID->650862043],
Cell[CellGroupData[{
Cell[24082, 810, 631, 20, 70, "Input",
 CellID->630617136],
Cell[24716, 832, 330, 9, 174, "Output",
 CellID->649476389]
}, Open  ]],
Cell[25061, 844, 125, 3, 70, "ExampleDelimiter",
 CellID->125464266],
Cell[25189, 849, 279, 11, 70, "ExampleText",
 CellID->585085885],
Cell[CellGroupData[{
Cell[25493, 864, 634, 21, 70, "Input",
 CellID->556921787],
Cell[26130, 887, 307, 9, 169, "Output",
 CellID->45328986]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26498, 903, 223, 7, 70, "ExampleSection",
 CellID->27543],
Cell[26724, 912, 62, 1, 70, "ExampleText",
 CellID->375043476],
Cell[26789, 915, 284, 10, 70, "Input",
 CellID->306299627],
Cell[CellGroupData[{
Cell[27098, 929, 1307, 39, 70, "Input",
 CellID->298166574],
Cell[28408, 970, 1912, 36, 70, "Output",
 Evaluatable->False,
 CellID->218310801]
}, Open  ]],
Cell[30335, 1009, 125, 3, 70, "ExampleDelimiter",
 CellID->250842546],
Cell[30463, 1014, 60, 1, 70, "ExampleText",
 CellID->162910670],
Cell[30526, 1017, 2805, 88, 70, "Input",
 CellID->363065324],
Cell[CellGroupData[{
Cell[33356, 1109, 587, 19, 70, "Input",
 CellID->465472184],
Cell[33946, 1130, 765, 17, 70, "Output",
 Evaluatable->False,
 CellID->496848994]
}, Open  ]],
Cell[34726, 1150, 124, 3, 70, "ExampleDelimiter",
 CellID->55751473],
Cell[34853, 1155, 56, 1, 70, "ExampleText",
 CellID->722904819],
Cell[CellGroupData[{
Cell[34934, 1160, 1755, 50, 70, "Input",
 CellID->367346177],
Cell[36692, 1212, 2399, 53, 70, "Output",
 CellID->527539671]
}, Open  ]],
Cell[39106, 1268, 125, 3, 70, "ExampleDelimiter",
 CellID->209306141],
Cell[39234, 1273, 77, 1, 70, "ExampleText",
 CellID->69203279],
Cell[CellGroupData[{
Cell[39336, 1278, 1643, 49, 70, "Input",
 CellID->3305262],
Cell[40982, 1329, 4375, 92, 138, "Output",
 CellID->151219961]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45406, 1427, 233, 7, 70, "ExampleSection",
 CellID->24570],
Cell[45642, 1436, 213, 8, 70, "ExampleText",
 CellID->19774549],
Cell[CellGroupData[{
Cell[45880, 1448, 500, 16, 70, "Input",
 CellID->283111600],
Cell[46383, 1466, 404, 12, 168, "Output",
 CellID->85903685]
}, Open  ]],
Cell[46802, 1481, 125, 3, 70, "ExampleDelimiter",
 CellID->516760770],
Cell[46930, 1486, 325, 12, 70, "ExampleText",
 CellID->233193187],
Cell[47258, 1500, 420, 16, 70, "Input",
 CellID->377448371],
Cell[CellGroupData[{
Cell[47703, 1520, 841, 27, 70, "Input",
 CellID->7936952],
Cell[48547, 1549, 391, 12, 171, "Output",
 CellID->772627905]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48987, 1567, 223, 7, 70, "ExampleSection",
 CellID->9014],
Cell[49213, 1576, 69, 1, 70, "ExampleText",
 CellID->327524129],
Cell[CellGroupData[{
Cell[49307, 1581, 671, 20, 70, "Input",
 CellID->27677],
Cell[49981, 1603, 4987, 114, 199, "Output",
 CellID->72352552]
}, Open  ]],
Cell[54983, 1720, 125, 3, 70, "ExampleDelimiter",
 CellID->235941495],
Cell[55111, 1725, 57, 1, 70, "ExampleText",
 CellID->295179799],
Cell[CellGroupData[{
Cell[55193, 1730, 1596, 45, 70, "Input",
 CellID->54842079],
Cell[56792, 1777, 2165, 49, 70, "Output",
 CellID->865229318]
}, Open  ]],
Cell[58972, 1829, 125, 3, 70, "ExampleDelimiter",
 CellID->282122593],
Cell[59100, 1834, 57, 1, 70, "ExampleText",
 CellID->54371934],
Cell[CellGroupData[{
Cell[59182, 1839, 1735, 51, 70, "Input",
 CellID->698775468],
Cell[60920, 1892, 21948, 364, 70, "Output",
 Evaluatable->False,
 CellID->59175154]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82929, 2263, 311, 9, 70, "SeeAlsoSection",
 CellID->29911],
Cell[83243, 2274, 1484, 54, 70, "SeeAlso",
 CellID->18132]
}, Open  ]],
Cell[CellGroupData[{
Cell[84764, 2333, 305, 8, 70, "RelatedLinksSection"],
Cell[85072, 2343, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85472, 2360, 319, 9, 70, "MoreAboutSection",
 CellID->126238941],
Cell[85794, 2371, 142, 3, 70, "MoreAbout",
 CellID->35070537],
Cell[85939, 2376, 162, 3, 70, "MoreAbout",
 CellID->222766751],
Cell[86104, 2381, 197, 4, 70, "MoreAbout",
 CellID->133664019]
}, Open  ]],
Cell[86316, 2388, 50, 0, 70, "History"],
Cell[86369, 2390, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

