(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61240,       2419]
NotebookOptionsPosition[     48027,       1947]
NotebookOutlinePosition[     49496,       1987]
CellTagsIndexPosition[     49410,       1982]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "PowerExpand" :> Documentation`HelpLookup["paclet:ref/PowerExpand"],
           "Assuming" :> Documentation`HelpLookup["paclet:ref/Assuming"], 
          "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Simplify\"\>", 
       2->"\<\"PowerExpand\"\>", 3->"\<\"Assuming\"\>", 
       4->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Formula Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Refine", "ObjectName",
 CellID->21123],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Refine",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Refine"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that would be obtained if symbols in it were replaced by explicit \
numerical expressions satisfying the assumptions ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Refine",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Refine"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses default assumptions specified by any enclosing ",
     Cell[BoxData[
      ButtonBox["Assuming",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
     " constructs. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22046]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Assumptions can consist of equations, inequalities, domain specifications \
such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 ", and logical combinations of these. "
}], "Notes",
 CellID->5914],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " can be used on equations, inequalities and domain specifications. "
}], "Notes",
 CellID->19817],

Cell["\<\
Quantities that appear algebraically in inequalities are always assumed to be \
real. \
\>", "Notes",
 CellID->26791],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " is one of the transformations tried by ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7838],

Cell["The following options can be given:", "Notes",
 CellID->141952712],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[TextData[{
     "default assumptions to append to ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TimeConstraint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeConstraint"], "30", Cell["\<\
for how many seconds to try doing any particular transformation\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->91715069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123164447],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->354781420],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " cannot be simplified for arbitrary complex ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->60818518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13356],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139760612]
}, Open  ]],

Cell[TextData[{
 "For explicit positive numeric expressions ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " evaluates to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->98866503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Pi", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150681204],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37032043]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " evaluates  ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", when a symbolic expression ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is assumed to be positive:"
}], "ExampleText",
 CellID->15797640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3987],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17591131]
}, Open  ]],

Cell["Weaker assumptions may result in a weaker simplification:", \
"ExampleText",
 CellID->416739716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27772],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->812014225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->379168361],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " to specify the same assumptions for several ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " calls:"
}], "ExampleText",
 CellID->421340568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "<", "0"}]}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"TrueQ", "[", 
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"x", "-", "y"}], ">", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}], ",", "0"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246183367],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598442863]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21408],

Cell["Nested powers:", "ExampleText",
 CellID->129729999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "^", "3"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], ",", 
   RowBox[{"x", "\[GreaterEqual]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59513951],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6126190]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "^", "b"}], ")"}], "^", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "b", "<", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46085108],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{"b", " ", "c"}]]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60705724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133302799],

Cell["Product of powers:", "ExampleText",
 CellID->379200585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "p"}], " ", 
    RowBox[{"b", "^", "p"}]}], ",", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1988791],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"a", " ", "b"}], ")"}], "p"]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->795597129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->684139381],

Cell["Logarithms:", "ExampleText",
 CellID->155914648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59541386],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"-", "x"}], "]"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145246708]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"x", "^", "p"}], "]"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "p", "<", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168973344],

Cell[BoxData[
 RowBox[{"p", " ", 
  RowBox[{"Log", "[", "x", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->603619839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64407269],

Cell["Trigonometric functions:", "ExampleText",
 CellID->199578985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "Pi"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"k", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83792698],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413405105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x", "+", 
     RowBox[{"k", " ", "Pi"}]}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"k", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->442376824],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "k"], " ", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50205386]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "Pi"}], "/", "2"}], "<", 
    RowBox[{"Re", "[", "x", "]"}], "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5389111],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->294474870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339069842],

Cell["Equations and inequalities:", "ExampleText",
 CellID->101947228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", 
     RowBox[{"b", "^", "2"}], "+", "1"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"a", "+", "b"}], "\[Equal]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751066038],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294050266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", 
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{"b", "^", "2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"a", "|", "b"}], ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202100658],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158916249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y", "-", "2"}], ")"}], "^", "2"}]}], "<", 
    RowBox[{"3", "/", "2"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2500458],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->423406831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->296709362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " statements:"
}], "ExampleText",
 CellID->157026059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", 
        RowBox[{"x", "^", "p"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"x", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"x", "+", "2"}], "]"}]}], ")"}]}], ",", "Reals"}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"p", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785329019],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456979928]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{"k", "^", "3"}], " ", 
      RowBox[{
       RowBox[{"Floor", "[", "x", "]"}], "^", "k"}]}], ",", "Integers"}], 
    "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"k", ",", "Integers"}], "]"}], "&&", 
    RowBox[{"k", ">", "0"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183182956],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400212608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143098895],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ceiling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ceiling"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->63545188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{
     RowBox[{"2", "a"}], "+", "1"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"a", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->784115894],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "a"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548999830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", "x", "]"}], ",", 
   RowBox[{"2", "<", "x", "\[LessEqual]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->753824324],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34626751]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", "a", "]"}], ",", 
   RowBox[{
    RowBox[{"a", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "1"}], "]"}], "\[Equal]", 
     RowBox[{"1", "/", "3"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->339106432],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", "3"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->802358212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->788610549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->33015946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{"a", ",", "4"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "3"}], ")"}], "/", "4"}], ",", "Integers"}], "]"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240458480],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33592346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362409897],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->34081567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "I"}]}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"a", "|", "b"}], ",", " ", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222855702],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434440270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"x", " ", "y"}], "+", 
     RowBox[{"y", "^", "2"}], "+", "1"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->349864651],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74358697]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23758],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12297],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " can be given both as an argument and as an option value:"
}], "ExampleText",
 CellID->565056155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "Pi"}], "]"}], "^", "m"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"k", ",", "Integers"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"m", ",", "2"}], "]"}], "\[Equal]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237031262],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565628870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53304432],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->279368443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Refine", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359819269],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171941064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53176702],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->268218531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192956252],

Cell[TextData[{
 "When assumptions are given as an argument, ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " are used as well:"
}], "ExampleText",
 CellID->373032043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"y", "<", "0"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71170035],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608906953]
}, Open  ]],

Cell[TextData[{
 "Specifying assumptions as an option value prevents ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " from using ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8600092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"y", "<", "0"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98179595],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], " ", "y"}]], "Output",
 ImageSize->{54, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432146381]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeConstraint",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2838],

Cell["\<\
Checking whether a condition follows from assumptions may take a long time:\
\>", "ExampleText",
 CellID->266086219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "4"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->600850587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"55.437`", ",", 
   RowBox[{
    SuperscriptBox["x", "6"], "+", 
    SuperscriptBox["y", "6"], "-", 
    RowBox[{"x", " ", "y", " ", "z"}], "+", 
    SuperscriptBox["z", "6"]}]}], "}"}]], "Output",
 ImageSize->{174, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38931476]
}, Open  ]],

Cell["\<\
If a condition does not follow from assumptions, checking this may still take \
a long time:\
\>", "ExampleText",
 CellID->494098244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30216502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34.90599999999999`", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     SuperscriptBox["x", "6"], "+", 
     SuperscriptBox["y", "6"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}], "+", 
     SuperscriptBox["z", "6"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272564746]
}, Open  ]],

Cell[TextData[{
 "The time spent on a single condition check is restricted by the value of ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->420586],

Cell[BoxData[
 RowBox[{"ClearSystemCache", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->136890207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22931155],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.110000000000013`", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     SuperscriptBox["x", "6"], "+", 
     SuperscriptBox["y", "6"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}], "+", 
     SuperscriptBox["z", "6"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{195, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->411929571]
}, Open  ]],

Cell[TextData[{
 "With a time constraint of 1 second ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " cannot prove that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     StyleBox["x", "TI"], "6"], "+", 
    SuperscriptBox[
     StyleBox["y", "TI"], "6"], "+", 
    SuperscriptBox[
     StyleBox["z", "TI"], "6"], "-", 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["y", "TI"], " ", 
     StyleBox["z", "TI"]}]}], "\[GreaterEqual]", "0"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->520300087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "4"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->126391231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.0939999999999905`", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     SuperscriptBox["x", "6"], "+", 
     SuperscriptBox["y", "6"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}], "+", 
     SuperscriptBox["z", "6"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{202, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->29337972]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10214],

Cell[TextData[{
 "Write code that uses assumptions; find the number of real roots of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["a", "TI"], " ", 
    SuperscriptBox[
     StyleBox["x", "TI"], "2"]}], "+", 
   RowBox[{
    StyleBox["b", "TI"], " ", 
    StyleBox["x", "TI"]}], "+", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->195830381],

Cell[BoxData[
 RowBox[{
  RowBox[{"numberOfRealRoots", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", "assum_"}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{"Assuming", "[", 
   RowBox[{"assum", ",", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{"a", "\[Equal]", "0"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Refine", "[", 
         RowBox[{"b", "\[Equal]", "0"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Refine", "[", 
           RowBox[{"c", "\[Equal]", "0"}], "]"}], ",", "Infinity", ",", "0", 
          ",", "Indeterminate"}], "]"}], ",", "\[IndentingNewLine]", "1", ",",
         "\[IndentingNewLine]", "Indeterminate"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
        RowBox[{"Refine", "[", 
         RowBox[{"Sign", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"4", "a", " ", "c"}]}], "]"}], "]"}], ",", 
        "\[IndentingNewLine]", "1", ",", "2", ",", "\[IndentingNewLine]", "0",
         ",", "1", ",", "\[IndentingNewLine]", 
        RowBox[{"-", "1"}], ",", "0", ",", "\[IndentingNewLine]", "_", ",", 
        "Indeterminate"}], "]"}], ",", "\[IndentingNewLine]", 
      "Indeterminate"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54559622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfRealRoots", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"a", ">", "b", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->426535775],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55526208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfRealRoots", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"b", ">", 
    RowBox[{"2", "a"}], ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->818536],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->343075333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfRealRoots", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"b", "!=", "0"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->286593832],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7051316]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->767],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " rules correspond to automatic simplification rules for numeric \
expressions:"
}], "ExampleText",
 CellID->412143078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Pi", "^", "E"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1617530],

Cell[BoxData[
 RowBox[{"\[ExponentialE]", " ", 
  RowBox[{"Log", "[", "\[Pi]", "]"}]}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141247077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"x", "^", "y"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"y", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->570684648],

Cell[BoxData[
 RowBox[{"y", " ", 
  RowBox[{"Log", "[", "x", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133865130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->711402502],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " to propagate assumptions:"
}], "ExampleText",
 CellID->165655667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", " ", ">", " ", "0"}], ",", " ", 
   RowBox[{"Refine", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28665],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18505102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73574952],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " for more simplification rules:"
}], "ExampleText",
 CellID->195834317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"2", "x", " ", "y"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28092876],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"2", " ", "x", " ", "y"}], "+", 
   SuperscriptBox["y", "2"]}]]], "Output",
 ImageSize->{101, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252133464]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"2", "x", " ", "y"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "+", "y"}], "\[GreaterEqual]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39679318],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125701392]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226214097],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " for special function simplification:"
}], "ExampleText",
 CellID->264789524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{
     RowBox[{"a", "+", "1"}], ",", "0"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215820139],

Cell[BoxData[
 FractionBox["1", "a"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105507110]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27340],

Cell["\<\
Expressions appearing algebraically in inequality assumptions are assumed to \
be real:\
\>", "ExampleText",
 CellID->519299667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "<", "x", "<", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1947090],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253863993]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9464827],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17391050]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20581],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->545]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18486],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->556762849],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->301172944]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Refine - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 39.1889362}", "context" -> "System`", 
    "keywords" -> {
     "assumptions", "evaluate using assumptions", "refine", 
      "refine using assumptions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Refine[expr, assum] gives the form of expr that would be obtained if \
symbols in it were replaced by explicit numerical expressions satisfying the \
assumptions assum. Refine[expr] uses default assumptions specified by any \
enclosing Assuming constructs. ", "synonyms" -> {}, "title" -> "Refine", 
    "type" -> "Symbol", "uri" -> "ref/Refine"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6701, 217, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->123164447]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49267, 1975}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2197, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2820, 79, 44, 1, 70, "ObjectName",
 CellID->21123],
Cell[2867, 82, 1258, 38, 70, "Usage",
 CellID->22046]
}, Open  ]],
Cell[CellGroupData[{
Cell[4162, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4640, 142, 367, 12, 70, "Notes",
 CellID->5914],
Cell[5010, 156, 230, 7, 70, "Notes",
 CellID->19817],
Cell[5243, 165, 127, 4, 70, "Notes",
 CellID->26791],
Cell[5373, 171, 328, 12, 70, "Notes",
 CellID->7838],
Cell[5704, 185, 72, 1, 70, "Notes",
 CellID->141952712],
Cell[5779, 188, 885, 24, 70, "3ColumnTableMod",
 CellID->91715069]
}, Closed]],
Cell[CellGroupData[{
Cell[6701, 217, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123164447],
Cell[CellGroupData[{
Cell[7086, 231, 148, 5, 70, "ExampleSection",
 CellID->354781420],
Cell[7237, 238, 274, 10, 70, "ExampleText",
 CellID->60818518],
Cell[CellGroupData[{
Cell[7536, 252, 119, 4, 28, "Input",
 CellID->13356],
Cell[7658, 258, 193, 7, 45, "Output",
 CellID->139760612]
}, Open  ]],
Cell[7866, 268, 291, 11, 70, "ExampleText",
 CellID->98866503],
Cell[CellGroupData[{
Cell[8182, 283, 124, 4, 28, "Input",
 CellID->150681204],
Cell[8309, 289, 161, 5, 36, "Output",
 CellID->37032043]
}, Open  ]],
Cell[8485, 297, 490, 18, 70, "ExampleText",
 CellID->15797640],
Cell[CellGroupData[{
Cell[9000, 319, 201, 7, 70, "Input",
 CellID->3987],
Cell[9204, 328, 157, 5, 36, "Output",
 CellID->17591131]
}, Open  ]],
Cell[9376, 336, 102, 2, 70, "ExampleText",
 CellID->416739716],
Cell[CellGroupData[{
Cell[9503, 342, 215, 7, 70, "Input",
 CellID->27772],
Cell[9721, 351, 187, 6, 36, "Output",
 CellID->812014225]
}, Open  ]],
Cell[9923, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->379168361],
Cell[10051, 365, 358, 13, 70, "ExampleText",
 CellID->421340568],
Cell[CellGroupData[{
Cell[10434, 382, 565, 19, 70, "Input",
 CellID->246183367],
Cell[11002, 403, 198, 7, 36, "Output",
 CellID->598442863]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11249, 416, 216, 7, 70, "ExampleSection",
 CellID->21408],
Cell[11468, 425, 57, 1, 70, "ExampleText",
 CellID->129729999],
Cell[CellGroupData[{
Cell[11550, 430, 288, 10, 70, "Input",
 CellID->59513951],
Cell[11841, 442, 156, 5, 36, "Output",
 CellID->6126190]
}, Open  ]],
Cell[CellGroupData[{
Cell[12034, 452, 253, 9, 70, "Input",
 CellID->46085108],
Cell[12290, 463, 203, 7, 36, "Output",
 CellID->60705724]
}, Open  ]],
Cell[12508, 473, 125, 3, 70, "ExampleDelimiter",
 CellID->133302799],
Cell[12636, 478, 61, 1, 70, "ExampleText",
 CellID->379200585],
Cell[CellGroupData[{
Cell[12722, 483, 272, 10, 70, "Input",
 CellID->1988791],
Cell[12997, 495, 228, 8, 36, "Output",
 CellID->795597129]
}, Open  ]],
Cell[13240, 506, 125, 3, 70, "ExampleDelimiter",
 CellID->684139381],
Cell[13368, 511, 54, 1, 70, "ExampleText",
 CellID->155914648],
Cell[CellGroupData[{
Cell[13447, 516, 179, 6, 70, "Input",
 CellID->59541386],
Cell[13629, 524, 268, 9, 36, "Output",
 CellID->145246708]
}, Open  ]],
Cell[CellGroupData[{
Cell[13934, 538, 235, 8, 70, "Input",
 CellID->168973344],
Cell[14172, 548, 210, 7, 36, "Output",
 CellID->603619839]
}, Open  ]],
Cell[14397, 558, 124, 3, 70, "ExampleDelimiter",
 CellID->64407269],
Cell[14524, 563, 67, 1, 70, "ExampleText",
 CellID->199578985],
Cell[CellGroupData[{
Cell[14616, 568, 248, 8, 70, "Input",
 CellID->83792698],
Cell[14867, 578, 158, 5, 36, "Output",
 CellID->413405105]
}, Open  ]],
Cell[CellGroupData[{
Cell[15062, 588, 275, 9, 70, "Input",
 CellID->442376824],
Cell[15340, 599, 277, 10, 36, "Output",
 CellID->50205386]
}, Open  ]],
Cell[CellGroupData[{
Cell[15654, 614, 327, 11, 70, "Input",
 CellID->5389111],
Cell[15984, 627, 158, 5, 36, "Output",
 CellID->294474870]
}, Open  ]],
Cell[16157, 635, 125, 3, 70, "ExampleDelimiter",
 CellID->339069842],
Cell[16285, 640, 70, 1, 70, "ExampleText",
 CellID->101947228],
Cell[CellGroupData[{
Cell[16380, 645, 299, 10, 70, "Input",
 CellID->751066038],
Cell[16682, 657, 162, 5, 36, "Output",
 CellID->294050266]
}, Open  ]],
Cell[CellGroupData[{
Cell[16881, 667, 366, 12, 70, "Input",
 CellID->202100658],
Cell[17250, 681, 161, 5, 36, "Output",
 CellID->158916249]
}, Open  ]],
Cell[CellGroupData[{
Cell[17448, 691, 471, 17, 70, "Input",
 CellID->2500458],
Cell[17922, 710, 162, 5, 36, "Output",
 CellID->423406831]
}, Open  ]],
Cell[18099, 718, 125, 3, 70, "ExampleDelimiter",
 CellID->296709362],
Cell[18227, 723, 187, 7, 70, "ExampleText",
 CellID->157026059],
Cell[CellGroupData[{
Cell[18439, 734, 525, 19, 70, "Input",
 CellID->785329019],
Cell[18967, 755, 161, 5, 36, "Output",
 CellID->456979928]
}, Open  ]],
Cell[CellGroupData[{
Cell[19165, 765, 515, 17, 70, "Input",
 CellID->183182956],
Cell[19683, 784, 161, 5, 36, "Output",
 CellID->400212608]
}, Open  ]],
Cell[19859, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->143098895],
Cell[19987, 797, 688, 27, 70, "ExampleText",
 CellID->63545188],
Cell[CellGroupData[{
Cell[20700, 828, 271, 9, 70, "Input",
 CellID->784115894],
Cell[20974, 839, 203, 7, 36, "Output",
 CellID->548999830]
}, Open  ]],
Cell[CellGroupData[{
Cell[21214, 851, 205, 6, 70, "Input",
 CellID->753824324],
Cell[21422, 859, 157, 5, 36, "Output",
 CellID->34626751]
}, Open  ]],
Cell[CellGroupData[{
Cell[21616, 869, 335, 11, 70, "Input",
 CellID->339106432],
Cell[21954, 882, 196, 7, 51, "Output",
 CellID->802358212]
}, Open  ]],
Cell[22165, 892, 125, 3, 70, "ExampleDelimiter",
 CellID->788610549],
Cell[22293, 897, 167, 7, 70, "ExampleText",
 CellID->33015946],
Cell[CellGroupData[{
Cell[22485, 908, 332, 12, 70, "Input",
 CellID->240458480],
Cell[22820, 922, 157, 5, 36, "Output",
 CellID->33592346]
}, Open  ]],
Cell[22992, 930, 125, 3, 70, "ExampleDelimiter",
 CellID->362409897],
Cell[23120, 935, 760, 32, 70, "ExampleText",
 CellID->34081567],
Cell[CellGroupData[{
Cell[23905, 971, 301, 10, 70, "Input",
 CellID->222855702],
Cell[24209, 983, 158, 5, 36, "Output",
 CellID->434440270]
}, Open  ]],
Cell[CellGroupData[{
Cell[24404, 993, 370, 12, 70, "Input",
 CellID->349864651],
Cell[24777, 1007, 157, 5, 36, "Output",
 CellID->74358697]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24983, 1018, 218, 7, 70, "ExampleSection",
 CellID->23758],
Cell[CellGroupData[{
Cell[25226, 1029, 228, 7, 70, "ExampleSubsection",
 CellID->12297],
Cell[25457, 1038, 240, 7, 70, "ExampleText",
 CellID->565056155],
Cell[CellGroupData[{
Cell[25722, 1049, 417, 13, 70, "Input",
 CellID->237031262],
Cell[26142, 1064, 158, 5, 36, "Output",
 CellID->565628870]
}, Open  ]],
Cell[26315, 1072, 124, 3, 70, "ExampleDelimiter",
 CellID->53304432],
Cell[26442, 1077, 353, 13, 70, "ExampleText",
 CellID->279368443],
Cell[CellGroupData[{
Cell[26820, 1094, 244, 8, 70, "Input",
 CellID->359819269],
Cell[27067, 1104, 158, 5, 36, "Output",
 CellID->171941064]
}, Open  ]],
Cell[CellGroupData[{
Cell[27262, 1114, 156, 5, 70, "Input",
 CellID->53176702],
Cell[27421, 1121, 193, 7, 45, "Output",
 CellID->268218531]
}, Open  ]],
Cell[27629, 1131, 125, 3, 70, "ExampleDelimiter",
 CellID->192956252],
Cell[27757, 1136, 251, 8, 70, "ExampleText",
 CellID->373032043],
Cell[CellGroupData[{
Cell[28033, 1148, 352, 12, 70, "Input",
 CellID->71170035],
Cell[28388, 1162, 198, 7, 36, "Output",
 CellID->608906953]
}, Open  ]],
Cell[28601, 1172, 372, 13, 70, "ExampleText",
 CellID->8600092],
Cell[CellGroupData[{
Cell[28998, 1189, 395, 13, 70, "Input",
 CellID->98179595],
Cell[29396, 1204, 237, 9, 45, "Output",
 CellID->432146381]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29682, 1219, 230, 7, 70, "ExampleSubsection",
 CellID->2838],
Cell[29915, 1228, 126, 3, 70, "ExampleText",
 CellID->266086219],
Cell[CellGroupData[{
Cell[30066, 1235, 765, 25, 70, "Input",
 CellID->600850587],
Cell[30834, 1262, 366, 12, 39, "Output",
 CellID->38931476]
}, Open  ]],
Cell[31215, 1277, 143, 4, 70, "ExampleText",
 CellID->494098244],
Cell[CellGroupData[{
Cell[31383, 1285, 764, 25, 70, "Input",
 CellID->30216502],
Cell[32150, 1312, 414, 13, 39, "Output",
 CellID->272564746]
}, Open  ]],
Cell[32579, 1328, 265, 8, 70, "ExampleText",
 CellID->420586],
Cell[32847, 1338, 107, 3, 70, "Input",
 CellID->136890207],
Cell[CellGroupData[{
Cell[32979, 1345, 821, 27, 70, "Input",
 CellID->22931155],
Cell[33803, 1374, 414, 13, 39, "Output",
 CellID->411929571]
}, Open  ]],
Cell[34232, 1390, 602, 22, 70, "ExampleText",
 CellID->520300087],
Cell[CellGroupData[{
Cell[34859, 1416, 822, 27, 70, "Input",
 CellID->126391231],
Cell[35684, 1445, 414, 13, 39, "Output",
 CellID->29337972]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36159, 1465, 223, 7, 70, "ExampleSection",
 CellID->10214],
Cell[36385, 1474, 381, 14, 70, "ExampleText",
 CellID->195830381],
Cell[36769, 1490, 1494, 37, 70, "Input",
 CellID->54559622],
Cell[CellGroupData[{
Cell[38288, 1531, 229, 7, 70, "Input",
 CellID->426535775],
Cell[38520, 1540, 157, 5, 36, "Output",
 CellID->55526208]
}, Open  ]],
Cell[CellGroupData[{
Cell[38714, 1550, 246, 8, 70, "Input",
 CellID->818536],
Cell[38963, 1560, 158, 5, 36, "Output",
 CellID->343075333]
}, Open  ]],
Cell[CellGroupData[{
Cell[39158, 1570, 220, 7, 70, "Input",
 CellID->286593832],
Cell[39381, 1579, 156, 5, 36, "Output",
 CellID->7051316]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39586, 1590, 231, 7, 70, "ExampleSection",
 CellID->767],
Cell[39820, 1599, 251, 8, 70, "ExampleText",
 CellID->412143078],
Cell[CellGroupData[{
Cell[40096, 1611, 121, 4, 70, "Input",
 CellID->1617530],
Cell[40220, 1617, 228, 7, 36, "Output",
 CellID->141247077]
}, Open  ]],
Cell[CellGroupData[{
Cell[40485, 1629, 297, 10, 70, "Input",
 CellID->570684648],
Cell[40785, 1641, 210, 7, 36, "Output",
 CellID->133865130]
}, Open  ]],
Cell[41010, 1651, 125, 3, 70, "ExampleDelimiter",
 CellID->711402502],
Cell[41138, 1656, 212, 8, 70, "ExampleText",
 CellID->165655667],
Cell[CellGroupData[{
Cell[41375, 1668, 255, 8, 70, "Input",
 CellID->28665],
Cell[41633, 1678, 157, 5, 36, "Output",
 CellID->18505102]
}, Open  ]],
Cell[41805, 1686, 124, 3, 70, "ExampleDelimiter",
 CellID->73574952],
Cell[41932, 1691, 217, 8, 70, "ExampleText",
 CellID->195834317],
Cell[CellGroupData[{
Cell[42174, 1703, 337, 11, 70, "Input",
 CellID->28092876],
Cell[42514, 1716, 287, 10, 45, "Output",
 CellID->252133464]
}, Open  ]],
Cell[CellGroupData[{
Cell[42838, 1731, 339, 11, 70, "Input",
 CellID->39679318],
Cell[43180, 1744, 180, 6, 36, "Output",
 CellID->125701392]
}, Open  ]],
Cell[43375, 1753, 125, 3, 70, "ExampleDelimiter",
 CellID->226214097],
Cell[43503, 1758, 231, 8, 70, "ExampleText",
 CellID->264789524],
Cell[CellGroupData[{
Cell[43759, 1770, 277, 9, 70, "Input",
 CellID->215820139],
Cell[44039, 1781, 178, 6, 51, "Output",
 CellID->105507110]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44266, 1793, 226, 7, 70, "ExampleSection",
 CellID->27340],
Cell[44495, 1802, 138, 4, 70, "ExampleText",
 CellID->519299667],
Cell[CellGroupData[{
Cell[44658, 1810, 226, 8, 70, "Input",
 CellID->1947090],
Cell[44887, 1820, 161, 5, 36, "Output",
 CellID->253863993]
}, Open  ]],
Cell[CellGroupData[{
Cell[45085, 1830, 236, 8, 70, "Input",
 CellID->9464827],
Cell[45324, 1840, 160, 5, 36, "Output",
 CellID->17391050]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45545, 1852, 311, 9, 70, "SeeAlsoSection",
 CellID->20581],
Cell[45859, 1863, 951, 35, 70, "SeeAlso",
 CellID->545]
}, Open  ]],
Cell[CellGroupData[{
Cell[46847, 1903, 314, 9, 70, "TutorialsSection",
 CellID->18486],
Cell[47164, 1914, 142, 3, 70, "Tutorials",
 CellID->377]
}, Open  ]],
Cell[CellGroupData[{
Cell[47343, 1922, 299, 8, 70, "MoreAboutSection"],
Cell[47645, 1932, 156, 3, 70, "MoreAbout",
 CellID->556762849],
Cell[47804, 1937, 151, 3, 70, "MoreAbout",
 CellID->301172944]
}, Open  ]],
Cell[47970, 1943, 27, 0, 70, "History"],
Cell[48000, 1945, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

