(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27384,        900]
NotebookOptionsPosition[     22937,        753]
NotebookOutlinePosition[     24357,        792]
CellTagsIndexPosition[     24272,        787]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic" :> Documentation`HelpLookup["paclet:ref/Dynamic"], 
          "FinishDynamic" :> 
          Documentation`HelpLookup["paclet:ref/FinishDynamic"], "Clock" :> 
          Documentation`HelpLookup["paclet:ref/Clock"], "Update" :> 
          Documentation`HelpLookup["paclet:ref/Update"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dynamic\"\>", 2->"\<\"FinishDynamic\"\>", 
       3->"\<\"Clock\"\>", 4->"\<\"Update\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dynamic Interactivity Language\"\>",
        2->"\<\"Evaluation Control\"\>", 
       3->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Refresh", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Refresh",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Refresh"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object whose value in a ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " should be refreshed at times specified by the options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Refresh",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Refresh"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["None",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " should never automatically be refreshed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->3225],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TrackedSymbols",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TrackedSymbols"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "symbols whose changes trigger an update", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["UpdateInterval",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/UpdateInterval"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "time interval at which to do updates", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->16825],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 " is evaluated inside a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", it gives the current value of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", then specifies criteria for when the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " should be updated."
}], "Notes",
 CellID->22374],

Cell[TextData[{
 "When one ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " appears inside another, the innermost ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " takes precedence. "
}], "Notes",
 CellID->20772],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " resets automatic updating even if it appears inside ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26053],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UpdateInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpdateInterval"], "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " specifies that updating should be done at least every ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->19391],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255339943],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->398351246],

Cell["Make a dynamically updating clock:", "ExampleText",
 CellID->62612958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Refresh", "[", 
   RowBox[{
    RowBox[{"DateString", "[", "]"}], ",", 
    RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303952573],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Refresh[
    DateString[], UpdateInterval -> 1], StandardForm],
  ImageSizeCache->{168., {2., 8.}}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237524374]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31555],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " updates as fast as possible:"
}], "ExampleText",
 CellID->1323154710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "=", "0"}], "}"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", ">", "100"}], ",", 
      RowBox[{"u", "=", "u"}], ",", 
      RowBox[{"u", "=", 
       RowBox[{"u", "+", "1"}]}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296219087],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`u$$ = 101}, 
  DynamicBox[ToBoxes[
    If[$CellContext`u$$ > 
     100, $CellContext`u$$ = $CellContext`u$$, $CellContext`u$$ = \
$CellContext`u$$ + 1], StandardForm],
   ImageSizeCache->{21., {0., 8.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->837077702]
}, Open  ]],

Cell[TextData[{
 "Control the update using ",
 Cell[BoxData[
  ButtonBox["TrackedSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["UpdateInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpdateInterval"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1068046285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "=", "0"}], "}"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Refresh", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", ">", "100"}], ",", 
        RowBox[{"u", "=", "u"}], ",", 
        RowBox[{"u", "=", 
         RowBox[{"u", "+", "1"}]}]}], "]"}], ",", 
      RowBox[{"TrackedSymbols", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"UpdateInterval", "\[Rule]", ".5"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->271594131],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`u$$ = 101}, 
  DynamicBox[ToBoxes[
    Refresh[
     If[$CellContext`u$$ > 
      100, $CellContext`u$$ = $CellContext`u$$, $CellContext`u$$ = \
$CellContext`u$$ + 1], TrackedSymbols -> {}, UpdateInterval -> 0.5], 
    StandardForm],
   ImageSizeCache->{21., {0., 8.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->346080441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1268945749],

Cell[TextData[{
 "Update y only when x updates in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1570535518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Refresh", "[", 
      RowBox[{"y", ",", 
       RowBox[{"TrackedSymbols", "\[Rule]", 
        RowBox[{"{", "x", "}"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->781822812],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.5, $CellContext`y$$ = 0.71, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}}, Typeset`size$$ = {74.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$5984$$ = 0, $CellContext`y$5985$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$5984$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$5985$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {$CellContext`x$$, 
        Refresh[$CellContext`y$$, TrackedSymbols -> {$CellContext`x$$}]}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {62., 67.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322994959]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["UpdateInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpdateInterval"]], "InlineFormula"],
 " to specify how often y should update:"
}], "ExampleText",
 CellID->511105086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Refresh", "[", 
      RowBox[{"y", ",", 
       RowBox[{"TrackedSymbols", "\[Rule]", 
        RowBox[{"{", "x", "}"}]}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1354984496],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.578, $CellContext`y$$ = 
    0.43836352539062773`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}}, Typeset`size$$ = {116.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$781$$ = 0, $CellContext`y$782$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$781$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$782$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {$CellContext`x$$, 
        Refresh[$CellContext`y$$, TrackedSymbols -> {$CellContext`x$$}, 
         UpdateInterval -> 1]}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {62., 67.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208592402]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17078],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FinishDynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FinishDynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Update",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Update"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26992]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27664],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Refresh",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Refresh"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->433217114],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->400338209],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->263918053],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->103946357]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Refresh - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 41.9077558}", "context" -> "System`", 
    "keywords" -> {
     "observer", "update dynamically", "update value", "watch changes"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Refresh[expr, opts] represents an object whose value in a Dynamic should \
be refreshed at times specified by the options opts. Refresh[expr, None] \
specifies that the value of expr should never automatically be refreshed. ", 
    "synonyms" -> {}, "title" -> "Refresh", "type" -> "Symbol", "uri" -> 
    "ref/Refresh"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9945, 312, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->255339943]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24129, 780}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2616, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3239, 86, 1572, 37, 70, "ObjectNameGrid"],
Cell[4814, 125, 1340, 41, 70, "Usage",
 CellID->25290]
}, Open  ]],
Cell[CellGroupData[{
Cell[6191, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6669, 188, 67, 1, 70, "Notes",
 CellID->3225],
Cell[6739, 191, 857, 23, 70, "3ColumnTableMod",
 CellID->16825],
Cell[7599, 216, 700, 25, 70, "Notes",
 CellID->22374],
Cell[8302, 243, 359, 13, 70, "Notes",
 CellID->20772],
Cell[8664, 258, 561, 20, 70, "Notes",
 CellID->26053],
Cell[9228, 280, 370, 13, 70, "Notes",
 CellID->19391],
Cell[9601, 295, 307, 12, 70, "Notes",
 CellID->29162]
}, Closed]],
Cell[CellGroupData[{
Cell[9945, 312, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255339943],
Cell[CellGroupData[{
Cell[10330, 326, 148, 5, 70, "ExampleSection",
 CellID->398351246],
Cell[10481, 333, 76, 1, 70, "ExampleText",
 CellID->62612958],
Cell[CellGroupData[{
Cell[10582, 338, 239, 7, 28, "Input",
 CellID->303952573],
Cell[10824, 347, 280, 9, 36, "Output",
 CellID->237524374]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11153, 362, 216, 7, 70, "ExampleSection",
 CellID->31555],
Cell[11372, 371, 222, 8, 70, "ExampleText",
 CellID->1323154710],
Cell[CellGroupData[{
Cell[11619, 383, 394, 13, 70, "Input",
 CellID->296219087],
Cell[12016, 398, 419, 12, 70, "Output",
 CellID->837077702]
}, Open  ]],
Cell[12450, 413, 362, 13, 70, "ExampleText",
 CellID->1068046285],
Cell[CellGroupData[{
Cell[12837, 430, 597, 19, 70, "Input",
 CellID->271594131],
Cell[13437, 451, 485, 14, 70, "Output",
 CellID->346080441]
}, Open  ]],
Cell[13937, 468, 126, 3, 70, "ExampleDelimiter",
 CellID->1268945749],
Cell[14066, 473, 222, 8, 70, "ExampleText",
 CellID->1570535518],
Cell[CellGroupData[{
Cell[14313, 485, 446, 14, 70, "Input",
 CellID->781822812],
Cell[14762, 501, 1846, 39, 70, "Output",
 CellID->322994959]
}, Open  ]],
Cell[16623, 543, 236, 8, 70, "ExampleText",
 CellID->511105086],
Cell[CellGroupData[{
Cell[16884, 555, 504, 15, 70, "Input",
 CellID->1354984496],
Cell[17391, 572, 1892, 40, 70, "Output",
 CellID->208592402]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19344, 619, 311, 9, 70, "SeeAlsoSection",
 CellID->17078],
Cell[19658, 630, 939, 35, 70, "SeeAlso",
 CellID->26992]
}, Open  ]],
Cell[CellGroupData[{
Cell[20634, 670, 314, 9, 70, "TutorialsSection",
 CellID->27664],
Cell[20951, 681, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[21113, 686, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[21323, 694, 305, 8, 70, "RelatedLinksSection"],
Cell[21631, 704, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22027, 721, 319, 9, 70, "MoreAboutSection",
 CellID->433217114],
Cell[22349, 732, 170, 3, 70, "MoreAbout",
 CellID->400338209],
Cell[22522, 737, 147, 3, 70, "MoreAbout",
 CellID->263918053],
Cell[22672, 742, 193, 4, 70, "MoreAbout",
 CellID->103946357]
}, Open  ]],
Cell[22880, 749, 27, 0, 70, "History"],
Cell[22910, 751, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

