(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13410,        407]
NotebookOptionsPosition[     11092,        333]
NotebookOutlinePosition[     12426,        371]
CellTagsIndexPosition[     12341,        366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DefaultDuration" :> 
         Documentation`HelpLookup["paclet:ref/DefaultDuration"], 
         "AnimationRate" :> 
         Documentation`HelpLookup["paclet:ref/AnimationRate"], 
         "UpdateInterval" :> 
         Documentation`HelpLookup["paclet:ref/UpdateInterval"], 
         "DisplayAllSteps" :> 
         Documentation`HelpLookup["paclet:ref/DisplayAllSteps"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DefaultDuration\"\>", 
      2->"\<\"AnimationRate\"\>", 3->"\<\"UpdateInterval\"\>", 
      4->"\<\"DisplayAllSteps\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RefreshRate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RefreshRate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RefreshRate"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Animate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
     " and related functions which specifies the refresh rate for frames in \
animations."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RefreshRate", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " specifies that an animation should if possible be refreshed ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times per second."
}], "Notes",
 CellID->17129]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->341367694],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->239453763],

Cell[TextData[{
 "Control the refresh rate of ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->184274304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"RefreshRate", "\[Rule]", "r"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772271996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.6033836364746094, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$3753$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$3753$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, RefreshRate -> 1, 
           AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.3063813209533691, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$3772$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$3772$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, RefreshRate -> 2, 
           AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->785494560]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29900],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultDuration",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultDuration"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnimationRate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationRate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpdateInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpdateInterval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DisplayAllSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DisplayAllSteps"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9447]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RefreshRate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 42.7984036}", "context" -> "System`", 
    "keywords" -> {
     "animation speed", "fps", "frame rate", "frames per second"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RefreshRate is an option to Animate and related functions which \
specifies the refresh rate for frames in animations.", 
    "synonyms" -> {"refresh rate"}, "title" -> "RefreshRate", "type" -> 
    "Symbol", "uri" -> "ref/RefreshRate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4630, 143, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->341367694]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12198, 359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 965, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1588, 49, 1576, 37, 70, "ObjectNameGrid"],
Cell[3167, 88, 630, 19, 70, "Usage",
 CellID->2160]
}, Open  ]],
Cell[CellGroupData[{
Cell[3834, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4312, 129, 281, 9, 70, "Notes",
 CellID->17129]
}, Closed]],
Cell[CellGroupData[{
Cell[4630, 143, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->341367694],
Cell[CellGroupData[{
Cell[5015, 157, 148, 5, 70, "ExampleSection",
 CellID->239453763],
Cell[5166, 164, 209, 8, 70, "ExampleText",
 CellID->184274304],
Cell[CellGroupData[{
Cell[5400, 176, 419, 12, 28, "Input",
 CellID->772271996],
Cell[5822, 190, 3833, 83, 208, "Output",
 CellID->785494560]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9716, 280, 311, 9, 70, "SeeAlsoSection",
 CellID->29900],
Cell[10030, 291, 990, 35, 70, "SeeAlso",
 CellID->9447]
}, Open  ]],
Cell[11035, 329, 27, 0, 70, "History"],
Cell[11065, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

