(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    181056,       3498]
NotebookOptionsPosition[    176752,       3361]
NotebookOutlinePosition[    178287,       3402]
CellTagsIndexPosition[    178200,       3397]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"], 
          "The Representation of Solution Sets" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSolutionSets"], "Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/Inequalities-SymbolicMathematics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Equations and Inequalities over Domains\"\>", 
       2->"\<\"The Representation of Solution Sets\"\>", 
       3->"\<\"Inequalities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"],
           "RegionPlot" :> Documentation`HelpLookup["paclet:ref/RegionPlot"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"], "Exclusions" :> 
          Documentation`HelpLookup["paclet:ref/Exclusions"], "BoundaryStyle" :> 
          Documentation`HelpLookup["paclet:ref/BoundaryStyle"], "Filling" :> 
          Documentation`HelpLookup["paclet:ref/Filling"], "ClippingStyle" :> 
          Documentation`HelpLookup["paclet:ref/ClippingStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotRange\"\>", 
       2->"\<\"RegionPlot\"\>", 3->"\<\"RegionPlot3D\"\>", 
       4->"\<\"Exclusions\"\>", 5->"\<\"BoundaryStyle\"\>", 
       6->"\<\"Filling\"\>", 7->"\<\"ClippingStyle\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Graphics Options & Styling\"\>", 3->"\<\"Inequalities\"\>", 
       4->"\<\"Plotting Options\"\>", 
       5->"\<\"New in 6.0: Data Visualization\"\>", 
       6->"\<\"New in 6.0: Function Visualization\"\>", 
       7->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       8->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RegionFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RegionFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
     "\[LineSeparator]is an option for plotting functions which specifies the \
region to include in the plot drawn. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31584]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"RegionFunction", "->", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " specifies that a point should be included in the region when ",
 Cell[BoxData[
  RowBox[{
   StyleBox["r", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15702],

Cell[TextData[{
 "The arguments supplied to ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " are as follows: "
}], "Notes",
 CellID->337],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], Cell[" and ", "TableText"], 
     ButtonBox["ListLinePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLinePlot"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " , ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ParametricPlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ParametricPlot"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegionPlot",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionPlot"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ContourPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContourPlot"], Cell[" and ", "TableText"], 
     ButtonBox["ListContourPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListContourPlot"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["DensityPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DensityPlot"], Cell[" and ", "TableText"], 
     ButtonBox["ListDensityPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListDensityPlot"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ContourPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContourPlot3D"], Cell[" and ", "TableText"], 
     ButtonBox["ListContourPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListContourPlot3D"]}], "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Plot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot3D"], Cell[", ", "TableText"], 
     ButtonBox["ListPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListPlot3D"], Cell[" and ", "TableText"], 
     ButtonBox["ListSurfacePlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListSurfacePlot3D"]}], "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ParametricPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ParametricPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegionPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, False, True, False, True, True, 
      True}}}},
 CellID->7997],

Cell[TextData[{
 "Adaptive refinement is typically used to determine the boundaries of the \
region specified by ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12686],

Cell[TextData[{
 "The boundary of regions defined by ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " is drawn with a style specified by the setting for ",
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31055]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505338328],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->175958400],

Cell["Plot over an annulus region:", "ExampleText",
 CellID->16183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"2", "<", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "9"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28541],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38899413]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"2", "<", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "9"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28990],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJydnQmcFcXx+N/bMxq8UNEYEomCoPEWxXhkOoIHUdEYD5QkIqAkHvGKtxHi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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVUlIlWEU/Z6+5/D+/3+vTWWaPRzKsYEcmp61KKpVC3UbaaBNoFHgugyi
fC4SU8IWkkRCRAWW7hyyCbSZqDSoICqtXYuCFnUO50LwLt/3f8P9zj333PsK
DrbXt6U55wZg6bDmbOdSsCZYY9i5JKwy5Fw+bBsMP7fBc+6Bjz18lOFcKexa
hnPV+N4JWxbSvTq7WwvbBVsOOxx37jTu12fCUcy5WfipwvrSDJ3fhPnuiHNt
mOdhPgOrgR13wnQ3KozcnyM+gK+DtYeFcQBjKiysM4aHuG7AZ29Yvhbw7uEl
znXBVw7Gk7DBqO7xbb67JnDuFHC+w9o45neAszwkjEnDuRnvdmVrndg4Z+xd
xiHXhxDXFdhWzB+F5HsF7CGswjhJ2d0mi4sx8dwo7v3E2kbjPs/4PxOVzxx8
XAe2PmBbhXk68F70xUW3cUBO6ONmRH4WMR/HmAvbj7XOsHAMZsgvfT4Oyd9K
2Edw9QE2jP0J5G4cNorcTWGchI1l6ixzwPPzYb3P7ySwtMaU27+Z4oI8vMZ6
KCYOqYNBi4UYbxvOSuwfgv85ywc5IW8n8H0e/htgLdhPj+kO39wbUbylnnJG
/os8cUSMrXHd4Xly3mw5Yvxb0pQL8jJuOXoDn33h/3nmyPzeiggX8faHpS3q
ajEufTMm5m4sQ9rOs9wzdxWWe+r5CM7+gDVk6izvMPZu4C0G7kRIvLO2ElZr
/GbdfUPcX2O6N5Kt+qq1WpkxzXOctRogLxOW031Zzl01n9TRkPE/a3eIbS3e
nw7kkzVA3huMj+aI/LOeqCHGdBlnKz3hp35KssX5hL3N2J8j7y98+aA+8g1P
S0xaoU6Y51zjvwQ+SwPVebNxzXeLsFYYKD/MYYflkTwxNsZVACypQHFNwvd6
T9orx1pZIJ12esoB+f+FcbsvnbZhfOar1r/HlY+E1Xu19Tfqpdbqtxj7q2Fv
TYPd1ot64GM4UDzEshAXHtZlyvrbUawdgzXi3Us4cyFQz5yzWqDGOkyr1FKF
J67Jc5mnOzzfE6hnMVev8O5LX3w9wfjUV676rf8xBvZs6olaYg8gdsbE3I1E
lT9qrcx6+x74+AOckSztldrdGqsfamYHzvzGGZcln/THPWqU96pMF0nrL1M4
f88XF+RswHoWddZo/x33sT/ta38UY+DJN7W5zlMO2AO+WB84gF7+CfOzUWmc
uU2YhhvMZ41pt8Lqi3iJaR733sdUD714K81TP26Cz89YPxdVPgs95ZR66DNN
/gOOMMoi
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlk0tsjGEUhs/UP1Mz/zczEpGIBWlVOq26hMQtU1bFekgkxKKkIyFpEwtr
GsRtoaoNNkVcNhKiOnbauuzcL622romgJWFHYsFzvIs3/znfec97zv+d79Ts
6Ci1V5lZC4jAWM5sHJxPmfWBptjsK/5t7GUJswVZs5fBbDVJr0n4SGwwb1ap
NjucMRvCruLsepIcznbhl8EN/HGQINYGZqG3Er0DsWp6rRL8UfQH0T+K9t6k
tJpyynXNKvj1cMaJt4NPxIbzqnWE+qfI7QJz0C7S4xL4v4j/Jb6Gs+/Y38A8
7E2crYU7gcbFlDjP8NtAK7V60C9kpelaXvMOue/gX07pnweIzYczSmwVnFtB
Z243JsR9Cy6llDNJ/lRe/zqbeGkGX9BH71sy4nbG6s1znqDVgN8Et5kaLXAL
sbT3pc0eE98JttNvN/F72CPgHPaJSLNaBH9FQjPbQ+1Jahyj1uZqcYfB8Ug5
74mtw7fpZlep/xx7JvnX0O8lXos9FHSXfsc/6aE/LX2f5xnsqbRizilnxPFY
MVKvFdAZqeeHQf/k/7Iczg++N0ElJb+HeC9opve5+H/o33KKJelxMf28CtL3
Hk4yiy4wFunOvsDdEMT1N/zA5xVLq5jQrF8E/ZvPvJ9+z1K/AOrTsg9xdiWl
s4GMevT6rXzfoF8Ta5b+hj7jL4y1K//ffE4z9tn6TpXx24Nm6TtQB/dDTnft
b/I3/7c0Vm8+g21w7wfNciN6BzO6Y7/bC+Rk4dZltYt+p6eDcpzbEWmXduc1
a9+pu/hbwfqkZu5320j+RKQ73h9rB333/A5rsZ8G7YK/cc/tDto912ggPi1W
Ldfwt/Io6C36m/kHMtGS4A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.36496952496322016`, 0.18181665580816972`, 0.6299891353810729], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmMllcVxt/5tvm+eb+FaqziElsBgW7YdNhmoCY6iMBAa10SGbZUoSql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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllWto12UUx5/9L5v//W4zyNQa5TUt06LUmm69yFgjJ2UZpK6GoK6Gs0gt
6s3Wm6DanJfIEgy7ORXDYEmUly2zyLTSNIrSyrTyUpSSFSPo8+X74svvnOd7
nvOc33nOOc+IBUtnt+VCCO2gAH6vDOFcEsLqYgirQBP6fDAKeVI+hJNpCM1V
IbxdHsJ2cBu2M0APTpaw/xvkAujD2Qr2nMtCeAg0s/dCRQhXxiHcyP4Ng0LY
WRZCA7Z3gG7k+7B5krOeAi+z9wjYBLeKPUvwdzv6m+h58BG2M9AbsZ0FTnL+
YPTvie8H0ENsXdhMZ+9C9G1wz6AfRv8SVODvFPEmUQg70Afg3kJfifwJawPw
raCG2G8GQ/BfTfw/4utB4t+K/y2gm1jWgRr83wBeYe9w9MPsbcr5X6+KLeuf
n4c7mzkXE7FvJvaZoAr5CWJ4Dn4EPl7D93Ws7WXvh+AgXC/xHYe7gH0R/hQ+
27GvjXw3uqM/4OpZ+4/z57A2FHkXmAt3Ef0mzp4ChnH+pey/LLGNuFb813HW
3/Avsb+TtZFwo0AH+rbg3AxDP1RwjsqRK8Cn2BJSyJOfhey/C/8bWevT3eLz
X+T5xDBW95k4V+3ise3PXEtTiWc93LWc8Q56LTbz8FdLDk+Qu1K5cz0efm3B
OS8mrjnVWj9rvyF/DR7A1xrWeslHbymEx4ltCt8xcKMT3/WLBdf6n9gUSq75
0ZHvSHejGurJnHPleiP/dDn65sxyibVlyJ3wd+Z8f0H1lvg+92HTCv8wqIF/
D3+LUtekanEI+hXqj8i+ZoEJkXOgf38Xvo5/r4/cKz+Rg59T51i5VY7ugXsj
cS+o58bqH8F2Qvm45F7JJe5t9Yxq50Clc6MaKsPXUeJZV3CPKNdzU5+lnE/O
XFOqJdVMC/oZcB65Ke/efpoY6nLu8QH0evy9iry16Nzekrl3lON/kG+N3Zvr
OfMv9Mmxc6ecHcPXpsy9rJ4uEc+j8A0F1/TpzD2i3lAMqrVF4O4K11wOuTty
LtUTLew/nTr374PF8BNS15r2/IL8a+pcK+ap8G2Re0N3eglndyTurWPYD0e/
P3UtnkCfhG0fa88W3DNd6Mszxz4TPMb5Q0EjudxFLsbj6xrwCLbLuZPP2dsW
uxZU04eQv4jda5pR2jsbTMvZx179e+TaXUBMX6EfBa/nnKMxxDanynNU83Mc
3NVgWfAM3Yfv6yPnvhNcVD+kttXM7YXfzdq8onu+I/Kd664Vg7hxrK0u2KYH
/d7IvVevno7c4+pt1bxmw+bEnGbEGc2/xG+L3oydyF2xZ61m1G7O2pN5tqqm
tij3kWNtgH8h9ppk5XBk5DdCb4PuYC18PnJuNTOr4c5X+m05Av8d//pt6tmm
GVuCH5R4dmlmnC15ZmhW7GDtA/z1x569+9nzmWZx7LdDb8ZivUfo+ytcs5r9
OlNn6Q1oIZY9iWefZuZBfB/PXDvqyRz8mti+dUealWWR31LNzJXIKzLfTSPx
dcKHyLNad35Aeupe051MjFwjqg31dDW1MDj23mbqZyn8tMy1qTdtemQbcXqD
/wcj+AhJ
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.46041345743784284`, 0.34776787831571354`, 0.764147128613921],
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMVVcVxs/cuffOnXvvOXfA6tCZAcqgVv7RNlopyEOUFrQ2miLig1LK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVVUUhndv71DuPefcUpShrdQWBQ1GX0QGCyrKIEhUUFFBwEIBAWkY
CxoUYtQXoWA0EfsgJg6QOICa+CIyiUMpVECIMXHAgEa0JiqDEmj9/vwP62b9
ew177XXWcGsbmiYvToUQWqE0dCYfQgdUmQ1hBgevF0L4Ng5hWSaEk1Ab+A7w
eWTd4InwE6AnS0IYVRpCj/IQxoEX4OuKshAGJiH0K4ZwCX/H0L8L2SSoDt01
2KzBXzs6LyI/gc2zsXUkG4T+l8iPgZfAX+DOsfAlnC2CvwhF+I6h37D/AJ27
kfUE/wU+Ar4a333BF8FvZMxfxVk25bPRxLsRm+/gLxDvCeR1ET7Av+ZCmIIs
zZ0N6J/UG9F/GPs88gRaim4ZZ9XY9oceRL838s+463NoLbbroH3kdBP2W5Bf
ic0Y3j8H/+3cVwKuBLegX5f4DYr9KPQ9/Ap0HkF3C7QB/C867VmftYAvgg/r
e4FnoTsTShHvJs52c/cuKJNyzubBz4WaiaWaO8+iOwe8HHwJ+8nKH/4+5e7d
0H7FC+6A78r4W5eBP8z4m//Ju37nbCN4Md/vAfR7Id8D3gcNjl1TqqWTUBX4
OugU/NG0+eehazM+uxf7QdgfB++C/sC2N/IOZBvA85H3A7+Z8psOIk/pjchX
IH9LstjfSmeHkJcp//DNyPuQ6+di19bwUt89Gp8fpR1DgW/Zjg2pCLV8zz7I
x0D/If867VheJWfP5BzTUfA3sd+SJ57V+NpB/M3k/uPg3DZCe/LO8Vb4bdBe
9E+Bb49d06pl9dQZbFeClyL7Ah+r4VdBK0pcI4olcMeCtGMaDe7Mu3bOgT8B
74wda5p4srFzoLfrzgI4D3FNaEQ+FF9nAV9x1zLuaCE/GyLbKse6+zzytqxj
GFTunlGvLIEOIG+LnUvl8FFy0wC9hH6vlN/SDPUt9Zsy8PcV/Hb11Bx8n0K/
k3xehs2tyG+DpqDfSIwpZCML7h316C/gp4lvaqltauDHFdyL6qnlyIdEruXp
UD2y8fjrIrbrkZdFrknVombQOfiVRfeOZkIFb/ubfCEKw3jffOKblzhXmonq
tUvQkax77ozmlc7I7ysZ9/5U7tyf8Qx4Df4J/M/O2ad6437O9mbcI+rlYeCV
Je7pSYl7Tr0mnz9i+5NmHLKROBgCfxPUN+cZ2yP2jNZsVo23ItsMtaZco33w
twiqyTqma+C7Yn8b9djgyG/WW9/jrBlf08A3kIOf8V+Jr/Po51Ke4Z2xe0S9
oZ3QhX5b0b2pb7wKXId8IfId2G9Ftg3qzrqnVGvrC/42qrkbkS0GV+b8ptOx
d4x2i2bK8dgzVrNVO2Cu6pWzzRnPpBn4G8F928uc03LwP4l7Z2fGub2ZO/rn
nGPN6iWRd5NmdnXRNa1aVoA18NnEu0QzTrNQM0mzSDOxCv3HCtbVm46Qp8cT
z3r11HZ+3lcPZz0DTufdo+rNevAB9VLi2ayd14SvYfiszjlG7a57Co5dO2wE
eHjRs1U6euthfEbBb56euIfUO6qRmfBVkWtFO6wWPCDxLtFOuAVfo4qeVYpR
tXF54lmtGqnE9oeiZ2k9Pmoj70Ttwv7IxxNbQTjrnTsb24bEvVoBngA/ETqE
/ezg2tfO065TD5xDVpF4t2imqJd6Ru5N9dTQomeSZpFqYmC5/yPov0GTajRx
jam2lqO/PvJ/BP030EychvyhxLFrR98Zu8ZV25oBqp1ZiWNVDQ0o98zWrF6E
/47EPaDafxmdd8DvJr5rGbQWfl3ib6kZpVzoP47+2ygn9ZpXReuqZ17g7u68
c6Ge1Ox6KvJ/Jc0wfcuFiXOrb6rd/HbRu147+qBymTgWzdTGgmeOZo1y/D+J
1j9r
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5558573899124655, 0.5137191008232573, 0.8983051218467689], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXm41mMax3/nPe/7ns67/H6nUSdNaLEMBjPMzCWMrThKDGNoIUtZUslS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmuQlmMYx5999333rX1Oi7aDLbXlkCZmFDNMdDJySJhEO2NLllS7bYUh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         "],
         VertexColors->None], 
        PolygonBox[{{3295, 4182, 2684, 1446, 1188}, {3307, 4186, 2606, 1212, 
         1196}, {4196, 3312, 1200, 1446, 2684}, {4195, 3308, 1197, 1212, 
         2606}},
         VertexColors->None]}]}, 
     {RGBColor[0.6281392418811329, 0.630907167432719, 0.9109650021551664], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuQ1lUZx3/v7r63fW8YC5nicnNKMCvT+COHgBRUGhMQdkGBSlaWiwsK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnuQzWUYx99zdvecPXt+5/zWtKTQoIspaabIdJmJ3EKhXBalTKbCCtV0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         "],
         VertexColors->None], 
        PolygonBox[{{3246, 3247, 581, 338, 2669}, {3249, 3248, 2670, 339, 
         582}, {4176, 3312, 2681, 342, 2563}, {3311, 4175, 2562, 342, 575}, {
         3295, 4169, 2549, 326, 2675}, {3307, 4173, 2558, 338, 2679}, {3226, 
         3227, 576, 326, 2665}, {4174, 3308, 2680, 339, 2559}},
         VertexColors->None]}]}, 
     {RGBColor[0.6983126172018, 0.7436562556236631, 0.9125647389755276], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwllUVxt/v3L7793KpGUExEQHFJgPtQqEloNwFDnIXMMZLkYgcERpz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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2eMlFUUhu/M7jI7M9/Mt2DBikEiICQqIkYUUHovLrI0hWgMouIuu2AJ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         "],
         VertexColors->None], 
        PolygonBox[{{3289, 4168, 2546, 321, 2674}, {4170, 3300, 2676, 331, 
         2553}, {3233, 3232, 2666, 331, 579}, {4167, 3288, 577, 321, 2545}, {
         3238, 3239, 580, 334, 2668}, {3302, 4172, 2555, 334, 2678}, {3237, 
         3236, 2667, 333, 578}, {4171, 3301, 2677, 333, 2554}},
         VertexColors->None]}]}, 
     {RGBColor[0.7678891806697676, 0.8487514631441819, 0.9116753397719713], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXeQ1dUVxx+v7iu/91sVO4oFjGZZmhVLQGOXrAhYYteMqDMKrBQpa0MU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQz2UUxr92fz+/9fveNuuPkts2GFq37gnjksqlWCsxlahmusyE1iKS
YYgQqWmKqbTooo2ulLumRkMzNV1oota9IqmVIqH0eebxx5k57/uc93nP933P
e875lt4zpmJ0QRAEW5EMcnESBCPCIPizXhA8BtAtDoJ/80EwJ8scBo3B7wI/
Dj4VfCn4GsYDwHphcw34u4x/RT+CNGFtZ6Q1trXwP50GwSusWcB4Ui4I6jPu
jv2z8O2pzz6sn430R78ZWYLto1EQ3AF/T/HDVYJsgqsZHGdZuxWOTXB9hKxl
7U2M26E3B3+K8QKkI3qMbABbj3zN+nnwD2d9j2J8LfI3fYTtZmQm2CxkK/og
7K+FryXr38d+NuNKxmORueh3MlfH2irGpfh2NdJUe7FHQ/y/G/wE+HTm/sD+
ZThHFQbBaezfRF+BlIE1RLaB/8T63qzdDL6Q8XPI82DTGH8N1zA4D3EeW5j7
l7M5i9yA/S7Gf+uuUvvWjrkWfFsD+GvY7z6+sTnYPMblfFsGmyti+yjffoXz
S90leJaz3sRcHj1EWmTNUcH6wUgX1rYCz4JlkBSsXtZnsyr0WeiMLgVrm/g8
doIvR38DGc3+o5B22JchP3A+9zMehC/lSAG2heKDaznfNwnf9iO7wfYgk8Gq
4NwC16eJ7/JJCVydwI9gOy7ns16c+Gx05v+BD4Qv5CwaICPQP1CMYX8Y/GP2
W4TN8YzPfDBYyNwS9ssgr8C1LLGvDyCnOO+9SCf0uxWjil84T/M9J7M+61L4
sjmf+bXYtkR2BT6/z8C3JY6ty5DN7HUhksOXZxi/zf53wfcD4/EZv51XY79F
vaFVcL+f+v3OgH89XOsSx34n5EX0F5DtBT5TnX1H7BvmfAfD4X4LvnHw7WSP
7WB55naAb0c+x5eBse92PuMfGa/E5hx8h5FhxNfk0Hv14rvy6MdSx/ZjcK6S
v/BNRB8Ex21gQ1Lng+7YvAO+BHwC+ICs394vcLyZ8xtcDX4ze9SAV4CHkX2U
b9/m/PbPhH4rygGV6GW6g0LH3PXgvZG2OeeLxfC9FPvtXAxnNfokONdj3wP+
j1n7GxwrsJ9d37nvUN53oRz4SWIbYXP0huBukfotDWR8JdhboWNzJPwb0SvZ
o7HOj7nVjGdEjpXxrNkgf/m+KcTivALnouvgeLTAOUn6vNSxrDnZNlWOy3hN
eeqYVCwqR6XgreHfoPsH7xrbB+1dzjd+iP2a1LntM2KmGH0AeC3xWsdcJ8Y1
iXORYuSL0G9AsS/ODWAbE8fadOQM2GFsarCtxiZSLkjN1Z79OoOX6JuKnNMW
gi9CYmwfBG+GngdvXuRvasTaEuQb/PkLjhK+JZu6NuxljxuU20LfpWJwLOsr
E99lE6Qmcs5QrtCbnoX+PXNL0fcii9FnMrcn45hfid6Z9UfxpxK+Juj3MHeS
/acx7l/sGFbsvoH9UtY/Ab4v45hdiz/rUsfCV3xfFfhTjCfm/E3d4OuK9AU7
BscBuNaHzg2PI3WMj8XeSzW3Q2yf5Es/zmcFeqvIunJ+rXJB5L3izPlYjfzW
FLM34e8WOO6Fu5q5Lujn9KaL7IPeVkXs3Ko3dpC1ByLHgnKM7lJ3rLvVnaoW
Kwfo7asm7+EtTGCug+6XNZfAPT9xbVWO+xTu+yL7pjNfAX4wdK4oYM3rqmWp
a1m19o99JjqLmchrke9Md6Wc0R7bDqlrhWL057xjXLHdh/37FTuHKHcsz/jb
+zC3JOMzmBI7ZyhXqIbtgKtjbN+V4y5DbwTeMuuaobutjpxrdcfjpEeOrdO6
I+ULvvdy9Sec11rsuyS+2+NZ3/2C1L2NYmAX/s5N3Mu0Yc+W+DYR6Zl3TzJR
95l3rVaOLgWbgHTNuycYB/9Q+IoKnTOVq3bnzaWc9Ujink29mmqQepFY+bzA
Pck7jK9OnIs093rknKpcqpp6Fv135fSca9w+8P2Ra4FqyiH0w5Fro3qm90L3
eOrt9GaGog9LfHfqQQ7g25VwHs34jMStGq3arD0C1Y7EueES1pyC+5/IuaAt
8HC+vVWxa2Hv/PncAd/mIueQW1lfFbp2qkbeBteQxGvVc8p2WexeVGtuwTZJ
3MuoxxgSu2dUr6geZwTjXOjcpZzUN3TPpF5JOeiq2Hesu9U3HWT/NpFzqXqE
8YlzunK53oRq/5zIuVw9wO1gDVPnsjJsbkw9J109amHqGqLaoR5YvVRt6lyn
nqou9JvRWzkJ50P4cyJ0LKrG5fD1YfbrnXEPrlh+OXYtU0xfpHoceq1iSLlv
Z+TcoBw4Br1+sXs/cVSxdmzst6We+3ToHly9t2qYeqepse9OPdSAyD2Veinl
mJHYXxD730A97/HYb0ZvRTn1O+60PHEuUA/3P5wnpjg=
         "],
         VertexColors->None], 
        PolygonBox[{{3289, 4185, 2604, 1208, 1184}, {4194, 3301, 1192, 1208, 
         2604}, {4197, 3300, 1191, 1449, 2685}, {3302, 4183, 2685, 1449, 
         1193}},
         VertexColors->None]}]}, 
     {RGBColor[0.8309096344496127, 0.8697671052403032, 0.8834422329532856], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QllUZx+9nd5/7efZ5ue91F6MsQpMXUxAEgglNcTCtHIFFHBNTcWkm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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVWUQx79Luafl3nvOKQIqRESUsojQsogiyBIiLmhlkSgoWzHRKLJE
VgEBQWQTomwRt0hIjPgiwZbFF1xpIeoLUYkgmzz40AUsIELE3z//h0lmzn++
mflm5ps5natmjZ3ZIoSwC2oJLcmHUFYawsySEH5Dvh1+QiGE51Cazrd/ciGs
RF6M3A98ZBrCw9CyKIT6TAjVnF8FXoWxhmwIk5BvAb8iHLkt/E2pdS/xbQd4
D3wswPbT2NyCvAh8WnEI58A3IL+K/Czy98iLkZ9BvydxfIv/xiSEH8GPgn8H
3ozvujiEF/G1lxjuAduJTim2E3Rqka9ho21RCJXQYbBaaBNnN0Jbwbpjfy7x
7CDGD5BHQXvhJ2BjHbbXQgeQRxRZdxt4dcZnMth/F3kqvo5j7w10TxLrRGIp
I6YYX4+DH4DfD3Xh/GvIy7jLK5yfD/85OnMi1+QCfFPiu/8A9cVexJn26A4B
Xwu2DhpFLDXE9y++zkErsP08PhejnyUnHcE78a0ucY1VW925c6l9ytdL2ByE
/v1QA2eboIOJc65cL0d/GPz7eefiDPYa0J2CfAR+C9TM/av4toF8XCcHH8N/
BPUrcg7mYW8+VB65hyaDTYJWoF+Gzk+cvwreqcg1vcpdzkDLsu6p3WCfQbMj
5+g+1QL/l8DrwSs4Xw61bmGdevgJ6FRhv7nYtUy4c68S1/RU7J5Vry7NOlcV
4JtLnLP9+DqQ+O7q8Quyhf5RdLdBb6K/GlqBv2bsnQdP0f8KbA10MfYZ6W6H
xsM/Bc3KuAffU+wF9+qHGed+MOcvZF2DBvgB6EwD+xr/94L3h4ZTjzV6g7F7
Qr1wFP0+8BWi4Jz35fz2vN+W3rB8V/ItRI6hJHXPq9fPRn6rk5Hrsn6z5egO
LnWtT2YdSz3fDkWOqRd8RWJsHPYHYv+6ZgRyI/G0QZ7OmSsZ52gqfC3fXgA/
Aj4X/mLi3p6DTm/4zXnbmqh+Rr6WuHfVE5/C9ybGtNg1bqfZkHduLkNXyGWO
b3/CV2O/mNj3ga9GtwM1TcDaY+Ow+gWdu5EfAF+P7xib/4ENRF6O/At4B+Qa
5Masc/Ig8qDEuVeNstifXbDtW0s8u4pT51Iz7BPutzN2LhTDE3nPAL39g9Dr
YMug3dxtHT6PcTaHvS7If3GmEv5G6rcoHfVWJTaaIvfYbcgLoT6Re1J3a5N6
tuqO6uWW2BgR3NOlyh1Uk7UN3V0zS7NKOdhDLF/E7uU6fHYCuwP6HbxA/Ovh
N6Se5eoxzWbNYM1ezegcfCvoS/DqrGfBdOibnGfCO3nnWLmdgn53zveA8vCP
YW84eMeCZ+s+9RzYUL6dQv90sWvROnbvqCYJfHnsXNVCL4PfpRqg2wp6C183
p+6NR6AFyKdy3l2aWcOQhyb2/TdyG3yfQH8PfB9iuJyzDZ3tFjxLJkKHcp4p
yn0T8tasa6DZciJnXc2YebF7XL3dDns/a/4krr3eoHafZoDevnZgEb6HIJ+I
nPMxxLOK8111V/CRee9k7WLtoGPIC1LncjsUUveUeunXyG91PTrji/1m/8g5
Z8qVZrBm55DEd9cMrQHbF3t36M0uhV+iHs24J7thf0beb0U1Wxm7ZqqVYhxN
vIH44hL3XCX4k7F309SMd90m/I2LvPNGY29M6t2rHa27q+aqtXIwq+A3prel
nafd/lDeb1s7vgzdLlDv4JrLt3KmXCmGAr5uJM6Fev409z8de9brzJ2c7Zy6
t8dG3p0DYu8S7dBeqWe6ZrlmzkLk/gXvNu14zbrzOf9LaOZpV6Wx3452lmZR
q9T/MppJmn3T8p7VmoERWDZ1r6nHz3J+UeJdoRnfGHvHareqx1SLfOK3pZpo
VnVN3euaWcdz/ufQv4b+CbKJa6Dcq6c3Ir+d+K6qwQzlruDdqB4Zof+rgmev
/mm0m3el7i3t6EfznqGanXrj+pfpmfrfSv80/wP0D1St
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8939300882294579, 0.8907827473364245, 0.8552091261345999], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwllUVxt9zvvOd857vSjY205SkE+IlBQJFvHIOqMjhdlBACBHicCkg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlntolXUYx3/ubDtne9/3vIPQMHQqpZalTtNpZeVleZmF81JYI1NXVGRm
kChGdvM2M815SXQZSZEkShdL0lph0s1aBWpF4rUQnS0zM6ZIfb58++PhPM/7
3K+/0236YxNmFoQQGoBCYFkUwrCyENpyIVTD6A/eOQ7htXYhbODblNIQRgMl
RSFMz4TQHt5B6APwB0K35kO4FZ2TyI5Cfx/2Xk9DiJH/FvpL5L8CGpBdCHRE
diJwPbyJ6AxFfgj0YfB12LwCfBJQAz6Zbzejex57jQS7DP378D0WSLH/OPSu
khB6QC9Hfie/rdBNQCO57QfmY78O/QWF9nkC+qEkhOfQPQ19jPiPA9uKQ1jD
t5H4uw0Ygv1XJQNvDfKjsN+EzFrwF4G+8AcDK8DPYv9iNoQK6CfK/s+R2JuI
Zwn8KtUYW9fC/0f2oXdgrxb/U+HPAjrCywMN4JXIPJtxjD0j+5BtxbgavJxv
jeCVfJtd5pqpVp/g7wP4dfC/Id9J8FdB3xi79ouAMugUGEBtDmXsu1fkXBXD
BPUTOAdeiI9z6P4NTC5wzD3J9Rr1l3xTvn0Nby/Qgn4zNhux1Yt45uU8Iy3Q
vaHrofchPx7bW9HfjH4G+xeIeTH6J9Efjv6f8M8CnfD/Jt82on83/PfBj/Nt
JfSc1LM1DlhP/Kf5dqbAPXseegGwJeMZnotsA/yaAs+LZrUWurWdZ/Y8/n8C
jhLPGOIpw1dd4vk6mHWsVwG5rGP+FdlCZMrVH2TWYasf8R4CPwKcQ3ZAbF+y
sRtbXZFZQj+mQv8Bvz/8GRnvxGjwU+h/jO9i4nkE2R6pc8sDF8CHx57NjYWO
VTuo3VPMryA/GXo79DHsN6s2qXe5GZt9sX0TOR/KeceuhrcN2Jp1D38H7xN7
t7Xjj4J/DizH10zoC+i35W3rO2CQ5jNxr+rxcT/6TxNDJfgsbLwLbxP6c9Cv
Qb+L5hV4Kfjbk+DzgLntXMMZ6L8Q+XYohhx0FrgT+q4Cx6qZ1CwqZuVSAf1L
kXPqBX9G5FlUj4+UesY0W/ORaYN3T+LcdqJ/O7ENwsbmnHug3Vwb2Zd2dAz8
SvhvwF9KzBXQ7aGHQT8If0TkndYuq+YH8LU/79uknRwJvx7+dUWe2e6Rb4Zu
hWraJfJMaBYWQ/eIXDPVagX0X6lrqlrqplThf0TsWxVnPGsvo3O4yDNXA+8i
OT9Q6JnX7m2IfEu1g8p1LDIrg3PWrLXkfcs0c/2Q/SK2b93Yj8B3xd7lf7HX
OfLN0a3RDb0M/CjwTJFvzFBs3ZL3LOhm9Ml7JjWLB4u8+6eg9wbfgP5577R2
WTl0gP9z5NtQlXPtq/H/fYF7sDzxjmg3dHPfAi9RTME3R70pjtwr9Ui10I5q
N1WThci/jY1x0HXQA5G/IXYvNyHfm3hWRY5VM1Ue+w3U2zccmfHglwOjc57x
35CfBr2d2r0H7KZXn6XG9Ubcgf60xLf8R+RXY3sE8pdynunD8I4kns2noNuj
2yH17dFN0u3/IfHu6Q1oI5cFsWV1s3UrdyS+7bqZucg1VO3U467wuiWeLdVo
APxO8O/N+U39EP2dsXurndQuXsx7t7WTuqUPJ34rdFMHx66ZaqUezoZ3CZlP
s77R+u9wJu9brf8QTapf5Fulm7c0cU1VS+1ELfnUlVpe+mPAq0t9z/Wf4TRv
9xboE9jaE1y7ktRvpWqoXFRj1VY57cfXntS7oZnpDn5l6tupmz0F/zHyB7K2
/07iN1Bvn2ZCs7wo9mxoptdHvum65Xrz/gO9wzKj
         "],
         VertexColors->None], PolygonBox[{{4119, 4190, 2537, 277, 2120}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVktsVVUUPfe9+/o+9972WVCjUaDyDbZ9WFpKq6VGxaAWBiYOQFHrJ6kD
xYGOSDQRJHGgtYLS955t/AADg4lxZNUYaEEF48DBI3GqMSaAIdGkigPjWq5l
Oti55567z95r/9a5XU/se/C5XAjhe0geMlgNYSwN4TheTraFsL0UwoYohNFy
CNsg08UQevHcg/1N2D8GvQnIDqz7khC+wtk7sZ7G3lHIHqybeDYgj2B9FrIR
55fjuQBZD7kDfv+E3b8g6/DeAqAxPGuQ2bx8zfj5sP3mY9kbwNlxYP6lPYTX
KiF0Yu+MbQ4VQjiCc4chnwPXHORVnPsOz/OQKay7shBWQS5gfRB6V3KyS9/E
sDZSvD2Q3SXFcd5+iY249jqOUftlfMwBY9wJPzcB3wnqwsehWHqMpdc2aZtr
xkW9nvJSjKfwXB3JZ814YuzPR8oVbXXa7zn4+hbyZqw6sV634Fu9qPpx76xx
LYuWfDM/QzhzwDVqou4NyDbnkvaviZS7/pzeR9wPrPspvxMn90bsl+tR62xG
LToL6oeN6JPnM8U4nilHjPufonzT70IHYoR8hr2fUdufIB/j2068T+NZjWTv
9oJ6jZiIjTg/gL1PYXcN1vuB+aGC6sPcP1aQ7jfQuS2Rr4GcvjMn1GVf8L27
LJ+s5duwdxkYBvF9BdYrIa1YcTyeLdWOPcd80saMa81cNo2Z8zTTppmi7ZNe
50qqG2s6CXvrE+1vxV6f87YKe/OZ6sd+ZWzEvgL7RzLZ74fuQEE9OYwYD2fa
exK5fClR/h5FP14PmcW8DMf6Tv3fO+Sbfrfg7FuZfFM2G8MZ6LRgZw52vobO
s6kwMvdr3CcTOPdrovpwFm71PDC+fQX5XO68M+f83m0d5oRr5oVxLDO2y7DX
yPS+CAwjqfrldey9A+mCzjOZ9KjTbb+080OmeBjHRdRwB9Yfokb347mlKg5j
DLlYdq4WxUdj5oDFouaO83HQMzLvfdaLs8NZXe1Z4Jr8MJXXGe5fBz+lRNzG
+GPX+inE8gdkV1FxrE2E4cdEZ6hPIR8TS5bXe80cstvcyJjeyBTXtTi3KRUv
tyV6/5+jJ4xnCN8HqsLXh/WVDvEvuao/US+TvzlbvZFyM+j8MH7yIGMknnfN
m+zNlYlqyzkjX3DW7ob9eyD1vGq+3/PV6dllXxHL1lR4WJP7UtWFtpu2fxG2
e6pac+7rxrcduvem4uOG9WvmxkPGsOiaMueclZsTzcsDqe684+b1hs/Sb+Y1
fdSdB/puuge+wNkvU/kow95HqWIjz56LpM+eH3at2RdDvrfIkewV8iQ5hXWb
zIsb2AsbfKcsmJd+g/7pSDPGWOZ9F4yYX1lT+hyvqG7k+U/Kmj/y/3/3ts+f
9pzegLhfgLxX0Vz2ezYZa1yS/pQ5jFjIu69UlLe7EOvf6Jk89J6uCA97+uVE
Pb3L+V70HBEbMTBe2miYD2+E/xch71fEKXXjJH+vS4SXnEA/5AfO9qzv3AO+
txg763fVvviPwNmgHv0ede2YX+aZPcw+upSonrwDT/g/IXa99npWpjwvxNUo
Ktfs65Y5jzMxaZuX2sUv9DHqvFOfc0V+Zw8wr3OOkfaOeS6b7vWaZ418xLlo
wd6Fdt0f/wKtTQdL
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlMlLlWEUxo/3fl71ft+91waIihygCVtkaqhFYSM000gDkZpBLco/IKhF
Ey2KbMCuoWRmi6homU2LisZVw1XbFhFkJRSUtYh+h8fFA+d857znvO/znPOV
N7duOBAzs3UgAHNCs18Zs38FZgvzzP5iV/GtATteaHYI+23a7GLCbA05U/B3
Z2QXk7M8MptcbLaD3K642TtyN+JvTZplObOCeIIze4ldBf3ES0KdvUS8mbwk
2InfSfxWkVl3ke7SQbyJWAJsx28nPp96+1Jm4/LN5oJ27EV8O0+sHv80/ilQ
Tn5PXGdbQCxQjVpy9xIfS241eIM9j2812K1gNnY9OMLZNnAupZ7ey3Nuc7ce
MAtUgFLe8sDjkDqe+o3Yr0Ab/TaT34J9FxzD34U/hvwvYJj8o3G99RuYmqc3
Z+m3hPysv5X8HLm98J2F7z4wAW7Xgy28qQuMEH+SUSxAg0bON4FrnK+k3iNi
f0AesTvkfIL/xxnZJ0e53wOCQBr0U29lJK06CnT2AvVq81WjA3tZJK1dg2rs
7+T89lzwE/sHmEmttfgLiOfS0tpnrAH/BThDvxj1ptHvKX5dIM3qInHk3LgG
Z1PSzLWqAoPE3oMc/KWIX4/EuXN9kBof6LU40uzepOd+7NcpnfUen0Nx7Nz6
DLiWJ3j/jYQ0LSXW4/NA/VygWZ4ILic10879ID26EtLAtXHOnCvXaAb2x7R6
OwdfsYfSmkXn0M8OgM6EalRGmjmfNd+R1ZE4dS5749o93ynfJd9BP3s4FLde
YygUJ86Fz9T9SDPns3Y80G5s4s7bktqRpZFmxmfFZ2w4I01ci5ECaVkVyXZN
y+CjKBS3/eAhsbJQs+7/iOeRdsh3xzV9iT8AOgPtQB92SUpc+g74XSaB7qTu
VEitVZHe6pr6LpWn1Mt3ajrxZ5F2w3ekJtTO+677jLtWV6LRWEz/oopQs+//
JL/LvUhc+J3+AwPOoF8=
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4190, 4119, 4177, 3800, 3799, 2943, 3940, 4083, 4082, 3471, 
         2855, 3811, 3810, 3138, 4090, 2866, 3262, 2848, 3522, 2847, 3261, 
         3361, 3360, 2825, 3242, 3168, 3275, 3274, 3287, 3259, 3260, 3172, 
         3258, 3257, 3358, 3359, 3235, 3234, 3506, 2854, 3271, 2865, 4086, 
         3133, 3797, 3798, 2846, 3476, 2845, 3939, 2942, 3795, 3796, 4179, 
         4121, 4212}],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4193, 3813, 4035, 4034, 4089, 3477, 3820, 3819, 3818, 3144, 
         3470, 3469, 3478, 2853, 3270, 3181, 3537, 3126, 3474, 3127, 3432, 
         3047, 3481, 3139, 3140, 3064, 4036, 3029, 4005, 3030, 3146, 4150, 
         3145, 2822, 4117, 3120, 3119, 3129, 4149, 3128, 2833, 3050, 4141, 
         3051, 3032, 3033, 4118, 2824, 3147, 4151, 3148, 3123, 4078, 3122, 
         4079, 3136, 3273, 3272, 3538, 3130, 3475, 3131, 3433, 3052, 3482, 
         3141, 3142, 4123, 2858, 3440, 3424, 3425, 3149, 4124, 2868, 3479, 
         3137, 4180, 4122, 4213}],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3065, 3418, 3417, 4077, 3118, 3948, 2955, 3821, 2870, 3822, 
         4159, 2907, 3861, 3862, 3719, 2806, 2776, 3093, 2780, 4110, 2891, 
         2972, 4138, 2971, 2880, 4156, 3631, 4155, 3632, 3629, 2963, 3630, 
         2973, 3160, 2883, 3464, 2884, 2966, 4136, 2965, 3848, 3847, 3961, 
         2964, 4163, 3849, 3850, 3319, 2885, 3529, 3316, 3317, 2969, 4137, 
         2970, 2968, 3633, 2967, 3634, 2974, 3161, 4126, 2886, 3465, 3466, 
         3102, 4146, 3101, 2881, 3459, 3460, 3153, 4096, 3152, 2811, 2788, 
         3076, 4144, 3077, 3451, 3450, 3835, 3834, 3833, 4046, 4045, 3823, 
         3955, 2956, 4161, 3824, 3825, 3826, 3444, 3445, 3069}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3084, 3422, 3421, 4004, 3028, 3959, 2961, 3838, 2873, 3878, 
         2923, 3875, 3877, 3876, 4013, 3665, 2784, 3552, 3551, 2997, 3204, 
         2809, 2785, 3343, 3344, 3505, 3504, 3205, 3206, 3553, 3347, 2915, 
         3510, 3511, 3207, 2810, 2787, 3382, 3383, 3001, 3646, 3648, 3647, 
         3666, 4014, 3880, 3881, 3879, 2924, 3882, 2874, 3841, 2962, 3960, 
         3124, 4084, 3426, 3427, 3088}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4184, 2939, 3770, 3769, 3768, 3911, 3910, 2906, 3858, 3860, 
         3859, 3609, 3854, 2889, 4128, 3593, 3594, 3595, 3452, 3453, 3083, 
         4051, 3082, 4052, 3375, 3342, 2782, 3702, 3701, 2996, 3203, 2808, 
         2783, 3703, 3611, 2911, 3566, 3567, 3568, 3704, 3612, 2914, 3569, 
         3570, 3571, 3705, 2786, 3380, 3381, 3000, 3643, 3645, 3644, 3384, 
         3387, 4095, 3150, 4094, 3151, 3455, 3454, 3840, 3839, 3596, 3855, 
         3856, 2894, 3599, 3557, 3885, 3886, 3751, 3752, 3887, 3888, 3753, 
         3754, 3755, 2934, 4129, 4214}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4189, 4133, 2940, 3785, 3784, 3783, 3921, 3920, 3747, 3746, 
         3884, 3883, 2892, 3597, 2893, 3598, 3023, 3662, 3412, 3413, 3068, 
         4039, 3067, 4040, 2789, 2812, 3385, 4115, 3386, 3490, 3489, 2999, 
         4103, 3184, 4101, 3183, 4102, 3378, 3379, 3346, 2913, 3528, 2912, 
         3345, 2998, 3610, 2910, 3863, 2909, 4160, 3642, 3980, 3979, 3376, 
         3377, 3092, 3486, 3487, 3193, 2781, 3458, 2777, 3722, 3721, 3720, 
         3020, 3407, 3406, 3589, 3588, 4060, 3091, 3845, 3846, 2879, 4061, 
         2878, 3843, 3844, 3872, 3871, 3724, 3873, 3874, 3725, 3726, 3727, 
         2938, 4132, 4216}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4183, 3302, 4172, 3508, 3238, 3239, 2952, 3241, 3240, 3509, 
         3167, 3304, 3303, 2834, 4026, 4027, 3782, 3781, 3780, 3054, 3580, 
         2827, 3411, 3021, 3999, 3022, 3110, 4111, 2790, 3442, 3443, 3195, 
         3194, 3488, 3066, 3441, 3004, 3388, 3111, 4066, 3112, 4067, 3005, 
         3992, 3009, 3989, 3991, 3990, 4006, 3055, 4142, 3056, 2841, 3927, 
         2932, 3925, 3926, 4208}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4185, 3289, 4168, 3524, 4167, 3288, 2949, 3229, 3228, 3501, 
         3165, 3297, 3296, 3322, 4018, 4019, 3773, 3772, 3771, 3048, 3579, 
         2823, 3423, 3736, 3735, 3734, 3121, 3321, 3320, 3669, 3670, 3640, 
         2992, 3639, 2993, 3641, 2988, 3374, 2771, 4108, 3109, 2987, 3416, 
         3025, 3484, 3485, 3176, 3696, 3697, 3698, 3177, 3189, 3188, 3532, 
         3061, 3436, 3792, 3627, 2929, 3625, 3626, 4198}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4194, 3301, 4171, 3507, 3236, 3237, 2950, 3290, 2867, 3525, 
         3174, 3292, 3291, 3323, 4024, 4025, 3779, 3778, 3777, 3053, 3243, 
         2826, 4080, 4081, 3742, 3741, 3740, 3034, 3325, 3324, 3671, 3672, 
         3556, 3555, 3554, 3002, 3649, 3208, 3209, 3706, 3981, 3003, 4139, 
         3613, 3614, 4106, 3187, 3982, 3983, 3984, 3491, 3492, 3390, 4116, 
         3389, 2813, 2791, 4112, 3006, 2840, 3924, 2931, 3922, 3923, 4207}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4197, 3300, 4170, 3503, 3232, 3233, 2951, 3231, 3230, 3502, 
         3166, 3299, 3298, 2832, 4022, 4023, 3776, 3775, 3774, 3049, 3410, 
         3409, 3408, 3739, 3738, 3737, 3031, 3192, 2779, 2807, 3977, 2994, 
         3976, 2995, 3978, 2908, 3341, 2990, 3637, 2991, 3638, 3202, 3636, 
         2989, 3549, 3550, 2775, 3664, 4011, 3043, 4010, 3044, 4012, 2839, 
         3909, 2930, 3907, 3908, 4204}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{2530, 244, 122, 19, 2228, 2084, 32, 135, 2529}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2493, 155, 399, 81, 443, 428, 94, 166, 240, 2481}],
        
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4199, 3695, 3694, 3794, 3793, 2838, 3042, 4140, 3041, 3997, 
         3972, 3973, 3969, 3971, 3970, 3340, 2774, 3700, 3699, 3975, 3974, 
         3998, 3157, 4153, 3158, 3154, 3156, 4152, 3155, 3159, 2778, 4109, 
         2890, 2875, 3952, 3953, 3949, 3951, 3950, 3954, 3913, 3914, 3912, 
         3915, 4205}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4206, 3919, 3916, 3918, 3917, 4059, 4055, 4056, 4054, 4058, 
         4057, 3085, 3087, 4145, 3086, 4053, 2792, 3708, 3707, 3986, 3985, 
         3210, 3653, 3654, 3650, 3652, 3651, 3348, 2793, 3559, 3558, 3656, 
         3655, 3663, 3057, 4143, 3058, 2842, 3930, 3931, 3928, 3929, 4209}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4182, 3295, 4169, 3500, 3226, 3227, 2948, 3313, 2869, 3527, 
         3175, 3315, 3314, 2831, 4020, 4021, 3767, 3766, 3765, 3046, 3578, 
         2821, 3420, 3733, 3732, 3731, 3027, 3191, 2773, 4037, 4038, 3967, 
         2985, 3966, 2986, 3968, 3200, 3201, 2983, 3964, 2984, 3965, 2905, 
         3963, 2980, 3689, 3690, 2768, 2805, 3039, 3040, 2837, 3906, 2928, 
         3904, 3905, 4203}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4186, 3307, 4173, 3513, 3246, 3247, 2953, 3245, 3244, 3512, 
         3169, 3306, 3305, 3326, 3437, 3438, 3256, 3255, 3521, 3062, 3435, 
         3434, 3414, 3745, 3744, 3743, 3035, 3097, 3096, 2814, 3723, 3711, 
         3710, 3709, 3007, 3987, 2916, 3349, 3561, 3560, 3010, 3657, 3211, 
         3391, 3011, 3534, 3535, 3179, 4099, 3178, 4100, 3180, 3197, 3196, 
         3533, 3063, 3439, 2843, 3934, 2933, 3932, 3933, 4210}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4195, 3308, 4174, 3514, 3248, 3249, 2954, 3251, 3250, 3515, 
         3170, 3310, 3309, 3327, 4028, 4029, 3750, 3749, 3748, 3036, 3581, 
         2828, 3415, 4072, 3116, 4071, 3117, 3329, 3328, 4092, 4093, 4048, 
         3078, 4047, 3079, 4049, 3008, 3988, 4098, 4097, 3715, 3714, 3114, 
         4068, 3014, 3996, 3015, 3716, 3717, 2795, 3718, 2799, 4113, 3019, 
         2844, 3891, 2925, 3889, 3890, 4202}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4196, 3312, 4176, 3526, 4175, 3311, 2947, 3225, 3224, 3499, 
         3164, 3294, 3293, 2830, 4016, 4017, 3764, 3763, 3762, 3045, 3577, 
         2820, 3419, 3730, 3729, 3728, 3026, 3190, 2772, 3667, 3668, 3548, 
         3547, 3546, 2982, 3635, 2981, 3373, 3107, 4148, 3108, 2978, 4001, 
         3024, 4000, 4003, 4002, 4015, 3059, 4164, 3060, 2836, 3870, 2922, 
         3869, 4201}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4187, 2935, 3791, 3790, 3789, 3938, 3937, 3583, 3582, 3624, 
         3623, 2897, 3601, 2898, 3602, 3830, 3831, 3448, 3449, 3074, 4043, 
         3073, 4044, 2797, 3394, 2794, 3713, 3712, 3113, 3393, 3392, 3682, 
         3683, 3681, 3680, 3573, 2918, 3616, 3013, 3661, 3660, 3572, 2917, 
         3615, 3659, 3658, 2815, 3212, 3012, 3993, 3995, 3994, 3350, 2796, 
         4042, 3070, 4041, 3071, 3447, 3446, 3828, 3827, 3600, 2896, 3857, 
         2895, 3618, 3619, 3617, 2919, 3935, 3936, 3786, 3787, 3788, 2941, 
         4134, 4217}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4188, 4130, 2936, 3758, 3757, 3756, 3901, 3900, 3576, 3575, 
         3866, 3865, 3622, 3851, 2888, 3853, 3852, 3590, 4127, 3591, 3592, 
         3402, 3403, 3100, 3536, 3198, 3199, 4070, 4069, 3684, 3676, 3677, 
         4064, 4063, 3099, 3679, 3106, 4065, 3105, 3691, 2769, 4154, 3678, 
         3604, 4166, 2901, 3603, 2902, 3605, 3692, 3607, 2903, 3606, 2904, 
         3608, 3693, 2770, 3338, 3339, 2979, 3687, 3688, 2767, 2804, 3371, 
         3080, 4050, 3081, 3405, 3404, 3461, 3094, 3462, 3095, 3530, 3531, 
         3318, 2882, 3463, 3372, 3355, 3356, 3540, 3539, 3223, 3902, 3903, 
         3759, 3760, 3761, 2937, 4131, 4215}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3072, 3429, 3428, 4085, 3125, 3956, 2957, 3829, 2871, 3895, 
         2926, 3892, 3894, 3893, 2800, 3399, 4105, 3185, 4104, 3186, 3542, 
         3541, 3016, 3213, 2816, 3397, 3351, 3352, 3517, 3516, 3214, 3215, 
         3017, 3353, 2920, 3519, 3520, 3216, 2817, 3398, 3395, 3396, 3018, 
         3562, 3563, 2798, 3564, 2801, 3897, 3898, 3896, 2927, 3899, 2872, 
         3832, 2958, 3957, 3037, 4007, 3430, 3431, 3075}],
        RowBox[{"-", "6"}]],
       Annotation[#, -6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3090, 3457, 3456, 2877, 3842, 2960, 4162, 4135, 3868, 2921, 
         3867, 4009, 4008, 3038, 2803, 2764, 4107, 3565, 3544, 2977, 3337, 
         3336, 2766, 3334, 3335, 3497, 3496, 2900, 3333, 3545, 3332, 2899, 
         3493, 3494, 3331, 3330, 2765, 4062, 3098, 3673, 3675, 4157, 3674, 
         4158, 2887, 3103, 4147, 3104, 2976, 3962, 2975, 3354, 3357, 2802, 
         4114, 3115, 3401, 3400, 2876, 4125, 3089, 3837, 3836, 2959, 3958, 
         3574, 3620, 3864, 3621, 4181}],
        RowBox[{"-", "6"}]],
       Annotation[#, -6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4191, 3809, 4031, 4030, 3806, 3805, 2946, 3945, 4076, 4075, 
         3468, 2852, 3808, 3807, 3135, 4088, 2864, 3269, 2851, 3498, 3221, 
         3222, 3370, 3369, 2819, 3220, 3163, 3268, 3267, 3286, 3265, 3266, 
         3162, 3219, 2818, 3367, 3368, 3218, 3217, 3495, 2850, 3264, 2863, 
         4087, 3134, 3803, 3804, 2849, 3467, 4073, 4074, 3944, 2945, 3801, 
         3802, 4178, 4120, 4211}],
        RowBox[{"-", "8"}]],
       Annotation[#, -8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4192, 3812, 4033, 4032, 3586, 3628, 3943, 3942, 3941, 3587, 
         3814, 2859, 3483, 2860, 3816, 3815, 3143, 4091, 3584, 3276, 4165, 
         2856, 3518, 3252, 3253, 3363, 3362, 3280, 3281, 3173, 3283, 3282, 
         2835, 3277, 3278, 3171, 3254, 2829, 3364, 3365, 3284, 2861, 3523, 
         2862, 3285, 3585, 3685, 3132, 3686, 3182, 3279, 2857, 3480, 3472, 
         3473, 3366, 2944, 3543, 3263, 3946, 3947, 3817, 4200}],
        RowBox[{"-", "8"}]],
       Annotation[#, -8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->424092995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->358151295],

Cell["Region cuts in the radial direction: ", "ExampleText",
 CellID->156817194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"5", "\[Theta]"}], "]"}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"5", "\[Phi]"}], "]"}], "/", "5"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#6", ">", "0.95"}], "&"}], ")"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"FaceForm", "[", 
     RowBox[{"Orange", ",", "Yellow"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1807274564],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 249},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->852071532]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10847],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoundaryStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoundaryStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Filling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Filling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClippingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClippingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16462]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7457],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->5317],

Cell[TextData[ButtonBox["The Representation of Solution Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSolutionSets"]], "Tutorials",\

 CellID->227434737],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Inequalities-SymbolicMathematics"]], "Tutorials",\

 CellID->31242]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RegionFunction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=RegionFunction"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->69236201],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->213858287],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->648506602],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->664421332],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->208575957],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->946052416],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->418552280],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->280969440],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->34791917]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RegionFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 43.5952990}", "context" -> "System`", 
    "keywords" -> {
     "volume slice", "volumetric slice", "region clipping", 
      "surface clipping", "curve clipping", "cutout", "surface cutout", 
      "plot constraints", "clipping plane", "clipping line", 
      "clipping volume", "clipping area", "clipping halfspace"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RegionFunction is an option for plotting functions which specifies the \
region to include in the plot drawn. ", "synonyms" -> {"region function"}, 
    "title" -> "RegionFunction", "type" -> "Symbol", "uri" -> 
    "ref/RegionFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14451, 439, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->505338328]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 178056, 3390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4073, 86, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4696, 113, 1579, 37, 70, "ObjectNameGrid"],
Cell[6278, 152, 490, 14, 70, "Usage",
 CellID->31584]
}, Open  ]],
Cell[CellGroupData[{
Cell[6805, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7283, 188, 462, 17, 70, "Notes",
 CellID->15702],
Cell[7748, 207, 151, 6, 70, "Notes",
 CellID->337],
Cell[7902, 215, 5818, 193, 70, "2ColumnTableMod",
 CellID->7997],
Cell[13723, 410, 281, 9, 70, "Notes",
 CellID->12686],
Cell[14007, 421, 407, 13, 70, "Notes",
 CellID->31055]
}, Closed]],
Cell[CellGroupData[{
Cell[14451, 439, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505338328],
Cell[CellGroupData[{
Cell[14836, 453, 148, 5, 70, "ExampleSection",
 CellID->175958400],
Cell[14987, 460, 67, 1, 70, "ExampleText",
 CellID->16183],
Cell[CellGroupData[{
Cell[15079, 465, 669, 22, 47, "Input",
 CellID->28541],
Cell[15751, 489, 15807, 263, 165, "Output",
 Evaluatable->False,
 CellID->38899413]
}, Open  ]],
Cell[CellGroupData[{
Cell[31595, 757, 674, 22, 70, "Input",
 CellID->28990],
Cell[32272, 781, 98194, 1683, 70, "Output",
 CellID->424092995]
}, Open  ]],
Cell[130481, 2467, 125, 3, 70, "ExampleDelimiter",
 CellID->358151295],
Cell[130609, 2472, 80, 1, 70, "ExampleText",
 CellID->156817194],
Cell[CellGroupData[{
Cell[130714, 2477, 789, 24, 47, "Input",
 CellID->1807274564],
Cell[131506, 2503, 39799, 657, 270, "Output",
 Evaluatable->False,
 CellID->852071532]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171366, 3167, 311, 9, 70, "SeeAlsoSection",
 CellID->10847],
Cell[171680, 3178, 1712, 62, 70, "SeeAlso",
 CellID->16462]
}, Open  ]],
Cell[CellGroupData[{
Cell[173429, 3245, 313, 9, 70, "TutorialsSection",
 CellID->7457],
Cell[173745, 3256, 187, 4, 70, "Tutorials",
 CellID->5317],
Cell[173935, 3262, 183, 4, 70, "Tutorials",
 CellID->227434737],
Cell[174121, 3268, 157, 4, 70, "Tutorials",
 CellID->31242]
}, Open  ]],
Cell[CellGroupData[{
Cell[174315, 3277, 305, 8, 70, "RelatedLinksSection"],
Cell[174623, 3287, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175030, 3304, 318, 9, 70, "MoreAboutSection",
 CellID->69236201],
Cell[175351, 3315, 151, 3, 70, "MoreAbout",
 CellID->213858287],
Cell[175505, 3320, 163, 3, 70, "MoreAbout",
 CellID->648506602],
Cell[175671, 3325, 136, 3, 70, "MoreAbout",
 CellID->664421332],
Cell[175810, 3330, 143, 3, 70, "MoreAbout",
 CellID->208575957],
Cell[175956, 3335, 166, 3, 70, "MoreAbout",
 CellID->946052416],
Cell[176125, 3340, 174, 3, 70, "MoreAbout",
 CellID->418552280],
Cell[176302, 3345, 197, 4, 70, "MoreAbout",
 CellID->280969440],
Cell[176502, 3351, 178, 3, 70, "MoreAbout",
 CellID->34791917]
}, Open  ]],
Cell[176695, 3357, 27, 0, 70, "History"],
Cell[176725, 3359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

