(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    823503,      17099]
NotebookOptionsPosition[    793284,      16047]
NotebookOutlinePosition[    794889,      16088]
CellTagsIndexPosition[    794801,      16083]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot"], "DensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/DensityPlot"], "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"], 
          "RegionFunction" :> 
          Documentation`HelpLookup["paclet:ref/RegionFunction"], 
          "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ContourPlot\"\>", 2->"\<\"DensityPlot\"\>", 
       3->"\<\"RegionPlot3D\"\>", 4->"\<\"RegionFunction\"\>", 
       5->"\<\"ParametricPlot\"\>", 6->"\<\"Reduce\"\>", 
       7->"\<\"FindInstance\"\>", 8->"\<\"Boole\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"Precollege Education\"\>", 
       3->"\<\"New in 6.0: Function Visualization\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RegionPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RegionPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RegionPlot"], "[", 
       RowBox[{
        StyleBox["pred", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a plot showing the region in which ",
     Cell[BoxData[
      StyleBox["pred", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The predicate ",
 Cell[BoxData[
  StyleBox["pred", "TI"]], "InlineFormula"],
 " can be any logical combination of inequalities. "
}], "Notes",
 CellID->31361],

Cell[TextData[{
 "The region plotted by ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " can contain disconnected parts. "
}], "Notes",
 CellID->27338],

Cell["\<\
By default, the interior of each part is shown in gray, with a black line as \
its boundary. \
\>", "Notes",
 CellID->31969],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->21367],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "AspectRatio", "1", Cell[
    "ratio of height to width", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for the boundary of each region ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], "Automatic", Cell[
    "how to color the interior of each region ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale the argument to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw a frame around the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how many mesh lines to draw ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}], Cell[
    "what mesh lines to draw ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh lines ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh lines ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining regions ", "TableText"]},
   {Cell[" ", "TableRowIcon"], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "initial number of sample points ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "the range of values to include in the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much to pad the range of values ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the style for regions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True}}}},
 CellID->18453],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " initially evaluates ",
 Cell[BoxData[
  StyleBox["pred", "TI"]], "InlineFormula"],
 " at a grid of equally spaced sample points specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to subdivide at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times, attempting to find the boundaries of all regions in which ",
 Cell[BoxData[
  StyleBox["pred", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25677],

Cell[TextData[{
 "You should realize that since it uses only a finite number of sample \
points, it is possible for ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " to miss regions in which ",
 Cell[BoxData[
  StyleBox["pred", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". To check your results, you should try increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14301],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " will explicitly include the full ranges ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16695],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " ",
 "will explicitly draw mesh lines to indicate the subdivisions it used to \
find each region. "
}], "Notes",
 CellID->25338],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " ",
 "can in general only find regions of positive measure; it cannot find \
regions that are just lines or points. "
}], "Notes",
 CellID->9835],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4691]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46513764],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->8468379],

Cell["Plot a region defined by an inequality: ", "ExampleText",
 CellID->19362291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "3"}]}], "<", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4473],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119214769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166468977],

Cell["\<\
Plot a region defined by logical combinations of inequalities:\
\>", "ExampleText",
 CellID->83322389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "<", "2"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "y"}], "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28861],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380280728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93724150],

Cell["Plot disconnected regions: ", "ExampleText",
 CellID->221870260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Dashed"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16199],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDuMVMkVhu9O9/T08H6sdmd5NrB4WWstERIS2SSWCAkXrSzNBpbRegOy
CQkJsRyYkBAHKxESEhISEhISEl5/51F1qu5j+s4AduIWzPStx6lTp87jr1N1
58/3f939y1/v//rzT/dXf/rl/oPdn3/6++qPf/uFotkXTdP8xv9/7zR8b/mm
/39rW36XP7/i54yqDX5v8Hvlz1f8+ao/X+20m2nvr+XnXCjrx+ubWZSsOs8X
ez2+HerRoykT+kJ+a9FJfkqT+drxv/aWm5+Fj//V/NePe6lYz7rlVa+59snG
KZ8vD45Xtrg6Ydyv2tCyjYLnlf/+1n9f6bQzrexrefnzS37+K82k2WprvV70
uNvq8D/vPHc163PX/7fHO1R9X2ea5XB50VNXb7Ns8eHDh559XOs8d/VrWK+z
cugn68pafuSxma1Wq1OnTrXJfmc//vijU9L6TZ7b9Hn69KmVznKpWsVCW758
+TK3vH37trfMpW5PQqOkT8vci7beK5eqbJMWH0LSN2/efP36tXJ5TNrP3r5t
Hj9uhAm1MC17/57W8k9shGeW5tmz0TZb+gzRJ09kkOZo27XxiVxGi7dv3+pa
bzLszk6D8O7caZ4/15VUyTarlfxD7K9evTK92KQTBG7dau7eVV6t7Zs3UrRc
QuHOM8iZzkCU7tDd3RWtJrzwnUaIZ29v79hhZ1A8X9dnVvC5frz+/fv3sClf
f6fPb968oYnqkT5jBSxP1L979+6lftz2mK3TP97jUbxX6SEXHY7+2evx5YFb
HFVJwzUsIyhkmnmfwyVFzBWmVcoLpvrixQsKHzx4gAZTbrN8/PjxkydPoGIW
v8msjB7rSVOnR+9Hjx5BFaF8u5azbfmxBSUGYnWx2kePGuQmSpG1Zm+vuXev
wb5FEzReLlkRGbIRDaOactqh8NYHGmjIjRs3cAviobTPFnNEUW7ckFHoQwe0
33vwjSLVpiXzVH3rcy7rc0RnwLBqN/rcbGBWhiMQCCO/e9eIzBvRFLM3j7sz
BkGrUj/RFGEi1893d3fb5AQ3BiUmOn3a25/y36fbobi+f3/1BaaYzXl+nHG/
8tbbpTL1p5vGUyY9Qnsr00G45vwK2piuW8k3yap07k1zSutRSdY09Zk65iJZ
JEsStFh0jwfntP7WrVvVWOgOuhy8oFloRdTTmC7R/9QpqUTXB7DQMEdoG0or
9SZt9M59yDeJojljHxGle/jwYdQjCoqqGe3s7EQ9ZglJrZrIEWYJ/8ERDxCR
qp1EEROM+hcvMMZHMSJug6Kohx2MK/rjNHwNhjnayFhtTz7a8kyWMMJBQVLZ
+SQDX7Voh4X5SiVEOK6LXzol+X2heNZYOIeHNbaynsZ6exMaZ1UoGD4qn+R5
Ntk/qpv07KyPcXDaN28mOkEbezKA4+v3Vj7F+gWdbw4wpukS/h1nGbQwtmJu
ws/Nyt5Y7kqX8LGYYNTDGO46188hZibXDO0+hnmyPtiJ08T3wkaSbTO7d+8e
IokxUVZUNnjSKFRbpMvvXDGnaRyZnuMCPUqcVIqAHvc6RhEfAcqJeni/e/eu
RCyr5xszkmiSOXaPfS7ZB6Fu3CuJdSzTSIV/vJi4Y6Q0+sW0LhayomyOYqlc
2n3tTSJ5ikfye+W/r66VlUZUgXMoATbCdBW/giQkrhskCASLQF2zNEDMaY5X
QploaDsN/rPORKAK48qGYD0eyUiJdWBp+Eg/wwgQJSagEqwhvtLxK1pH0L6l
jXFg3lb1WcAriyOISdsuWE+eDerwwf/PktWhXJAhDK3n8VMgwuEWOeuwMAAI
p1glhZi7oTuDhAQqGtickATyQCqU4wX4aXsXujAnbK6U1gJZME0arURWrNNT
o4veUciQIISjfT2LnRD6j8RtFyZjs05QevhQ1ptRVCdYE3nEfmFexlZstgkj
hCzgGQsphmxaxuKYlsHqqqBKU6MKMaNKHx4phHfZv/R3TMrrIvNKO/SCRb+Y
/JN7g+Ntyjuhuu6Towz23C6PJK/QGoY8MmFEpszayIjimS+1gQ5Pj1PYLCkI
9pb+Z5K9FSgxI0dWLpWdcSt77WhgqzeGSGqW9jaLzlhtivbv5FPHDAvREfnb
tvCWcFFhPIyHVYn+bChxe8McnejYw6zmjBmb1I0z9B0fFJRRA0xbqnJkdeyS
sZ4jK6tHnRw5WX+IeTTscyYyypnTLodb+dkKEZ/E9HNpFN9b2Cii+KtVcBH4
zLjkwdIaEbPd91t/iGET0+WnOY+5PRuWN74wbAQW48ZueCetqyO602ncap/A
Bt/XPWNz3ydstmVWRfb/eQfdlZSBoYibHkNO5zVGOr7GgT8NpKZ22z0pHOtI
YbMeGemxBj6yUEz4rsSUfarHfR4damYtBsoPQK3vIczmpOeZpCe+zgmDdtfg
bLI3L+vrw9go55N9VJZNnSMzW2Ech2uuaQBww32O1TPj7k5xVDM7nHQsmTiD
A690HLOJkfDR1R6IhwrXMmxlYxAbteQUUTfcQBpFn8lbBYLOO1KYi3pE6HM2
b4dpujWfG5wJOwBHs4u2Fz8XpTUwAcLS+SR5pijRMGNmn++5JHnH6SfTyvko
Vk88p79g7pNJl9w2l+tWxkSNGC4kL+DeO9AoTpTYnMouJTttIwqsjWfMVBJF
l/l6PM1AFaLNZZK90fVxK5axRRoj8T32SPBuGJAYyVpYEkrQumFAnnEgeFkw
vGRvrS1N8AZgkyrLxbeU5ZItgrdlNSy/peaY2sIupBmQJQfNNP28ZxftXXNq
b1hOg19I0fN1hEiirOXrrB3Wank9LCPyhNaOGJvyhIJ8LXmIUUT+j5ni7ijF
8vrZzk+JVE8k3wIXghxmSSO953fSDi5yjtZ9yndFP4mes/Ts/dLZ1fA+R3cr
C+QihwOC2yVraNK0zKMdRSADoX1FW8MTz0Dp5XJJa5bZWsM0VChES2UXdzVZ
As+UNhsyxLZtWu0f3yHOENCTfcVwnrKb72vmzB7EwiYFzdluHVWiZxkdzxkV
yIteQtVaxNnA5USDKdhst5Mt0UF0ez0fmumdmTm3jncv+4o1Hh0CA1tB1W5i
bnMoj1kiYfUiE3OLkStFEB5xynzmqvCVGS1jIqndwXKYeopQeHRJKpceX21v
EN9abEKdfX/RjW05ooinO0BGBYoM0hbRcKeKhqiD714yrnXEnuO25/kGEek8
ou0YT5EzRD89EhkvPHjGaydJT9lP9ViKJ9Nz5Pbsj9VjXz5X7c/u7rXnYlQI
zbgHMNlMzWF20a8+xLhzVtVkjLCnrstT+XTGRpaeL46xmZPnmFOZ5FDW54vX
5T2nUTDUiEoXOvOx1GpkmLFqkadL7W5738htRtn+KxvnEsMYEDF3M/eV1rOi
VZ5xQOtdS9ZrPf7Z22af4KcAtuo4ddcuqwdauP8xXnAQbsHdnav2n0PcfEK7
LpfeR6Q8uIWdSxbRRaTViYedL0R+lsYV4sVCCQ/T/JNxBOooZmc4EqcAhhJk
FZlO3GCRh93AVZxPdgSAknPaqSPS1a2sQqS9PKpu/3PZtByonewTXH2fsGrr
0375KmXHk9a3lhXqU692kL3spsYVQS26AAUCpYgFwqmLdzGMZw0BLPi6BJP1
1J3FRcwsgLUDpmq+U9oFqkW4CpIE5QyjFd1BV5G9m/ewFobWiCdoTMZzlEgu
UM/c5RwbzUcHKbIWOAqPENcLGhDgi7XAP7o3uX4IzvrIdLiPdPlH281U7E/b
7jugRZaI5TNPNsbiCOKyM3iTgrWI+wrUs4kQvdaZS2wz2Zh4vBWEHDn3cfoI
h1HCwIYbESBoFaeE69lg9e1eBl9YfD1uv6EYWLyeBEzRBW3XbCcNtuAn2kgV
6Fa0z/qwVnqI3zjtZjvfX+EfJo3CMTJtZBb9/VplB7EnpIvsscx6EQFKL7dU
jiZbc7vSekG9TAO0wQj5zF7ZSPgVCejBTKIQEX5KvpYJQ8C8Bv8d4Z1o+yf8
U6jhQBF0yv6q//dMZGRvcVadc3/xiCP79X0ywyyw+++gjWJ6ZidwMq7CxxvP
kah6Qc3W17wzKlvFtoFczb5nkIACzx50MywDGZLQ7NbwgvFAgKtieeecUiyt
4qGbuermVGHIY+ZI5qqbt0RPZW+dM7yVRJCWzyhneKs7B3rL5WXUs6X0SJXR
gN/SmMhNlUVFIXxukUWNXG6gUIPlqd1IhjJGMi2oRsqKUYyEWvvoaaR98p/d
LOqBc7Lrs6gw6JnAQKG6s83nAB+Rny32gUYZ2OMrG3tPkMO+WdExO0Nrqpwm
nqw63WAKlVaxTSruGpQ7HOuv2bCHB7Oz0JuMqT2PmO/fuAbkk3LMPU7Ku7dl
IOYnVGszxHzwWkg461V1iwBpeNY7o9QCAapHqE6pkKbvIxMKvuk6MIUTvZq2
Z0gWDfUTicCVsUsNdMtiFbJZGyVYG1wYorNRcJkFer3c1qf4IznQiArofM4h
efySKKEn73I2j2bhE1mLK6mFhh+9l2DxQo/5yjuqduYqXxdJwrhNue03NdNJ
5LDDezBpvlMKmhDci7QIitbO7h3SDgQg9PONw0ZupEriWHJ4lou1DJod3GMO
kYttNAmom5dnIxyKDVjWEcPxPdEP+syDa9cf0vr6TE73becT3wGwTCbrj8qi
FHbYn7DxnAnZiXyWlgFwhED5PcthWinPiKo85xcr0is+D5oNkfCyvFXNWHYx
AvFPvCG6gAnsHZhliXPGEZy5IUslWScq4p4nMtTze0GU+ERNQDSRcaUPHgrw
8lCO8rUHfYnKy+UyZ+bx3IZk/dQfDUWXpmU6l2ml0TbR9MhqMiLkxbdE9lNv
siqHud08bptPuQXaPec/2C3Q8NYVQvSMyoVchiT95GddZjPdOkr3AvZDhBnJ
VRmVyN1ZloIHvSW+f5Yi3wT1LMQwKsSuq5xloMLRm6DVLTIPDpOyFMZRF5Ux
++p82yjGiAb5or57+yDutlo+CZP1m6DTeYrTwyqD6HfujM+4m5hvMVSntBZg
pcoymfn+HBY/lY+PuQkaCLCfQRQ/PBvIgCzSCK4DJXZcn5c82aHWfZvg4HnT
IYryWGU8Cwyfc6qe+Q9EqCrSpnaW8XxpoawJ+5wyg/Ebpd07yiHHYc0M5Dik
mWNZqrxG1a0Qg3sxdveGafdGNw/VDdPujW7bC41ztt8bVJYL7GJSRvDd1DAm
tQASHPKAkKO+i3kNVw9zeMJlN8xZYNTIi+KFqtHihMxGI14W5++Kuoqbyeox
NJ13e3KulPm5X4pcKT6kd8pvb9rUZR/k0yQNnRJvI+NqWRiWxqlepv5E6x6t
jbcxjiedbcfyqIO3QwUW4KKJh8zE7qAyELJBH4iahhb5Dxq0GwESujKWwEzZ
u2mG2pHl3OCFvY5i7XBrrB8kNTP1fJ+3UVRTN4FlLLndQZX7B2b9VBE4Ld9p
2UJim13gxL+Kamk7Mb+cQJQ4bGiP1bNXhTQfnDC0WtUDPD80r7WfG6FqZneR
MXGraUdY/F7boZ6+s/oh6Yx7yrNrKdsqIRu76Qn0C0yP9HE2elR/W+5a2c1V
ohuri9dpmurE3940REh8EXxoJ/4wZpK2OnmPUFuby1Eoe0dykCM7mthf+R7E
Tq2ZHvtUiOmrBGkPxUpqnsvRn9zLYFaYHvQFxy6TPevV6deOMVlsJo6LZCbL
ZDF6u2zKPmtD7u/OzCHLc84keCZg6DZriXkbj9zH27E9Zs5W6GUHyaNEVpOV
91gQmLLmJWWaRu8RezbzUqaJVIuTeytDrJ5xjHFYU9/BTb8FF7mcwHbp/lTK
jQ3nNTR/e5C8xkh+xXYeQSeiYY7kHh1yjqeKVd33p2IeEzOH+ibq0/Gbqp65
yjcZqqwqs67ymChuJRXU1tfpMHlM7LOXx7Ro17YfkcccGCkrRJ0xLc7yp907
/XQ5TbWyzUzDIH+mUb73HCiwn9Vc9i1tXyuId9kCv+J/i7dx0uhr8tP7jhLv
/+Rbpo49hnUcf1yh2bW5+hFb677bFF4k8+GbyIRsm+65RXXmEDvUKRlExSK7
+f6HI7B8glLsG9SqK8zH8pe3A2b6Yscggl3LiV0sZbQLycZ6GI/Y2ju9tzsC
ErXSCcd717+REcOjWzB32qhSkaXNmBI3mO6qGh7N14P3yZ2qjcxsBLGOy21x
Bl9E3ny/1Msk/h1rI7LK1yN9S+llL9U3C/rDDcQb8SxUPp+X25v5XSfaCnaJ
s1eWDF9OS/CbUaQjkrFEq8zfKKYXntM7ZyO53oI/RZFx0p7e3pnZTVDBjnbS
Xp432w6FatccQ6L2hrzeD9uLu5t64vdSvn6em6PlX2EY2nkeS1aD3uaboXO7
DIvMKfrOV+j1XvoIPv990i8rkrXY+743umYy9/1rBN1nzdAKSgUT2PUKsYz8
NhojsdZ40uqvKSRHYDeGJbW+VZ60Y9O6CXvl+Cz2geLB5OB+liwP7ymxyfBi
WGLS3kPOR7CHR++jbZEFBQGgpLZ7m9vtVKbN5PNf3NCj8tQCE0DzcVfp/apN
zRutMjMH4lIet5NF6TUFey1P8H3ITq1RvYGWam/zW3vex/5yydyHnCWPwEeQ
d76hVLTVlcwj6NuGUrrIpYjCTlDMi0nmPXofaCWqFtc7LQ77V1sOM/b//2LP
IepH/mJP+bdDpF385aTfej+bL/4DFRHkHg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85971181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->523147204],

Cell["Style the region: ", "ExampleText",
 CellID->142732630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15076866],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211061956]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17363],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->298882101],

Cell["More points are sampled where the function changes quickly:", \
"ExampleText",
 CellID->740660496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "^", "2"}], "+", "x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1365410381],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlWXt4jNf2jnCoS0SDagZFKswJP7djQiLsI9FQlyRN1SVipMqhjdKmqplW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   "], {
    {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmc1lUVxu99gWGbYWAQGUH2LWVRFHJg2FdJDMIFFCXkk1GAEi6hGLEI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        "]], PolygonBox[CompressedData["
1:eJwtlnnQ11MUxs/5Zi1jL0th0jS0GEuUbNFoNEgkJkUpoqblTUjakWllSFmK
VilJRMmSSEVFvVEmRA0iomR9qzHD55nn+8dn5jn3fn/3nnvuOef+6naraNe3
iIgn4QAYlBHt4GX0ELgZ/TMsRS+DOei50Ad9DVyJvj/97RzYgh4MXdGvQvXC
a+i3H8Pp6K/Sc6/AteiF8Bz6RVibXlNrzYaz0U1YYye6LRyEHsnYCPS78hm7
GnQPj13KXE3s9ehKuBF7OAxFL4Zg7j/s25HDYQN6PXRBzw2ftVN6bZ25tXyF
KehZ8CF6FRyNnhyO1UaYH47Z41obnkaPlT/s9yD2MPQ+6ID+AZag34TP0NfB
reh50JLvx2CPRO+HgekYKTaDoQt6L6yUL9AQvQ1eQzeAPujarLFRZ4fPsTel
5+SjYq09tZdi3hLdG/qjH4Xb0I/BGPRTcCRrjcV+GD0J/kCPLv1bDi+gZ0Pr
8Nj36O2wCH0eTNXdQg30AKjHenWVM+gv4C50C8b2ojtBL+wJME5zUIe5E7Hv
QW+ST+jr4WT0eHgWfRLcq9iHY7E1vbdiUovf18TuV+bDJdh3YFegq8J3dWdp
686aoU+Au9HPwBF8fzj0CMfgu3ROKZd0RvnSjPk9YZ+aY08qz3cMnI+eWPp/
IGxO14ByfwGsRq+BgeGcOgu9G95HXxHWu9K1prFZ6JnQNJxTF6PPgVHoR+Br
9Jfl+gthD/q39FoPQRP0ufi7C90GGmOfgb09vOZ87JfStTZa8dL36VyeGl77
grTv2uMU+cLvd4fv+KjCPsmXdXCm/GNsRzhHeqZzTrmmO/kEfTXcEo5ZHfRk
5SC6I0xJ57RyWWMLdLb03bQP36VyVrmqO2yDXgeDwmvqrOOxe4XP3Ah7SNmf
tkF97FPTd7UFTlPtpnNL93kw8zUK964HwmdVD1Dt68y6+/bYncM50Eq9I+17
B/0GfWG69nVfLZSb8HuZfxXKZdbYjL5J9VzYB+29FV5H/wRvh3tc88I5rN9q
DdVOP+arh2uoe3qPqjIejZlvhN0Q/W24l47D7hnuqfelY6Cz6wxLtVfa9+mw
Ar08XZszlYPoZWlfZ4Rr74P0nGrwDfSSdK70hgbpmCvW8kF7z0v3EvnwVvpO
dZfTYGjaZ/naLfyWKCaKhe5MuTosPaecVW6NUg2Hc+xf9Htp31bDvnTOK9dX
hWMxHZ4o/ZmR9lFaY6qlf2BFuKYGoK9K9yrl54h0D1fv1ptSD12ZfjuUc4vR
fysm4Zz7K10TqgWNNdXecAO6Ghyb7lHqTXqzdJcr02+N7rQqHVPFUj4tQv+Z
7r3qSeptx/H7DWU99Ui/gZWlXR89DSaE3xj1Vn2jOfXYy9I1KVtrqLdflH57
1M/boj/N8u2Bw9jreeyJqt1wr1QPVu9Vz9yP7p/u9R+Fc7t2lr0v/DYdnz67
3qiu6TdNb5n+U6jXv5POPfXMQwvXoGpvLfRl7vL0W6B5nU13rrvWGXegk+/X
hGum0J+bwm+9xnYy/6tyJJwzetvls3zVG19Ld5vORb2JOushhffWmX9Jx0Bn
1xodsX9M17b+U+ht7pzONb3R6jXfpHux8vd/+nI1BQ==
        "]], 
       PolygonBox[{{131, 185, 345, 99, 389}, {143, 85, 279, 1, 409}, {165, 
        166, 329, 582, 458}, {150, 137, 399, 81, 429}, {185, 183, 485, 99, 
        345}, {166, 120, 373, 582, 329}, {113, 143, 409, 1, 362}, {136, 150, 
        429, 81, 397}}]}]}, {}, {}, {}}],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-2, 1}, {-1.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103251207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14269919],

Cell[TextData[{
 "Areas where the function is not ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " are excluded:"
}], "ExampleText",
 CellID->1304113656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", " ", "y"}], "]"}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020115110],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134549406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373712099],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->79146163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RegionPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], 
        RowBox[{"Sin", "[", "y", "]"}]}], ">", 
       RowBox[{"1", "/", "10"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "15"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1133661767],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{308, 307},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->81289986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->888468442],

Cell["Use logical combinations of regions:", "ExampleText",
 CellID->1713040825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "<", 
     RowBox[{
      RowBox[{"y", "^", "3"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "<", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1911374093],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324726038]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->153735188],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for the region:"
}], "ExampleText",
 CellID->157416703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "^", "2"}], "+", "x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254754736],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217995313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->621730161],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " for the region boundary:"
}], "ExampleText",
 CellID->347900488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Dashed"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244419543],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311818181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93704113],

Cell["Add labels:", "ExampleText",
 CellID->299525187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{"1", "<", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<annulus\>\""}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Green"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1833133861],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344423704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->578573904],

Cell["Use an overlay mesh:", "ExampleText",
 CellID->2051245947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{"1", "<", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "8"}], ",", 
    RowBox[{"MeshStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Dashed"}], "]"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1735645938],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380919506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47535311],

Cell["Style the areas between mesh lines:", "ExampleText",
 CellID->152911286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{"1", "<", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "8"}], ",", 
    RowBox[{"MeshShading", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Yellow", ",", "Orange"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->770854980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175810148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76417930],

Cell["Color the region with an overlay density:", "ExampleText",
 CellID->1497405390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "^", "2"}], "+", "x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Arg", "[", 
        RowBox[{"Nest", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "^", "2"}], "+", "x", "+", 
             RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "]"}]}], 
     "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531530537],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247477288]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(26)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->639263323],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->361980370],

Cell[TextData[{
 "Regions are shown with ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " set to 1:"
}], "ExampleText",
 CellID->1812813996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1614330783],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlm/tvXEcVx2+8u7bj5kHaPFqcV9NHWkrhv4Cf+CNMKKRVaaM0lBLyaNJH
6jRxKVSN3FqJIleGNFaThmBkcBVwkcHUwiKoFhEWkSJFwigoIsJCkSKZz5lz
Z2f37L27cx0qEWHJ3r135nzPc86cefhrPbu2P/Htnl1PbuvZ/NWdPTu2P7nt
uc1feXYnr0pLkiQ5z+/wvQnfF/jmfs8vLPDZ+Hcdf0t0aJMn+eLe8szviow2
+SptK/kin6UMursy2mLoWvHLk9NhJfcaqnbzvMw8O6pyeE6S5Q1vOgxNR0OP
8iJQWkuyMkMXcewS+XRdVvG3nGFjq3Ulp18jz460Z9sdZIX/L59bbUWOtgzK
GC0rKW3XorSrRHO2PbzM2WO2bJ5XLFKzWpqli9awmCRZmtZlMddtXap/R/q5
PP1sr7FobXtXi/ZW9Mo1L/vrX+mbl3cF952qvzpbWqGSbW1rhybPdgy36n+7
z5/7jPHv+ozxnb0q1Wc1euov/yE/WTNyjP8ecx3n5uauXr168eLFpG1qaipp
p2HK/fCKhmvXrt2daddbt27RfOXKlaRd6EqXLl3i+fr164ntf5951pwXF3HS
Yas8dt68eXN2dnZ8fHx4eLi/v//Im+/3/Wj4+Hu/qgyemkg6+MLj4b4f03Tu
3LnJyUmRbINQdszPzyPchQsXoBwYGKDfD4+dTdodXf/xUZ4PHXlP6dAEeySP
pJwLjY2aHg86vlgIvqOjoydOnHh7YOT0h9MffXw1WT71p38n7T//6K9DpyeR
A4GQDGHXORq0nJmZQZLBwUFk++D8xToaZEZx2rADgm69DcvW9tjiIg07YTdl
fG70z8lqx/X3f/wXUiDp0NAQIYFSzr+VGzduIDi93z05hmTau/KbT/6Bnsh4
6tQplE8eypTQ57D2ms/aXpsdB2wxMTEBWyz12z/8M7nPcRj/3d9xNnynp6cR
RvO3SIOhX+k9iaxIrH3LFyb+hi70xaYPZEqyzrzd5GwFNFx/8sEnQG1wSPA/
OfQxSl2+fNmN+zK8sRaRg6k2uj7oji0IMrx5fxQ3F59lHAkw8DC53yGh41v9
PyUKGE7Om2Ug1RBIpH2IC5yCCzDTpihu690zuhHxWCZ5SHBK+A6RxVeaIYAD
FGjU0R6YFPlkPG3M5SNe7Pb0CI42SLrVScoXvDA2NobJNMeRVOAJbvKI4wAr
GEoa6a4beVYDzSTYC2qJucdchJ4d+fTMmTNEL/mByMN47n2JwUJMSIx0R9lH
axb0xD6AJI97O8ON8Ysa7k0Jh8MPPZPPR+HqM8LhU4nNL3ud+ZSvX3LPyoc4
zsmXFnWte8ZvKlrydYeC3FhfUGwFlo2yxqPgIQH4hkGx/bNRVhuUbxqUtU3j
ZrW3e2qf7Z5avZrc0zQm7vYRheuF+ilvTajF96ujNFjlnvEpPhDfP+1QiCzC
VpruiUKpzozo/YtfX0mecSiMBQZdkDUOhdRHAhKAZx0KQcn8GmRthaJVK+kK
qwrADh91jGWJ3TgUrY7xAnaBNtlp7GJrrGYokEAoAM85FIKFkAmy5sWHUjN+
iHQh3OU1QSaJjxULtSsPy3uZ9yx6iwbP+5xGlguytdJgmfHJdx0K9QaBJ03L
o1C0YmREMG1IrL7gUIgUYrUoysjIyM9++RcB+J5Dwc04O8jaCsWtD2XcoIQA
7PZWZZqRcVMEhTRLUhSA7zsUJmhKhSBrnmeVmrAmuIVwj5FBVnj5I9+t/0oE
AYNdCPca3l1RGmi1RPaRGQiAfT77IENRlGCH/cYnS6NQdG+BmD546LgAvFgz
M+Sj+Goqa+fNVlYdJo4PmDi2taNycChNd0Gyd6vwIcWX1G4HHR9KQwrXfD52
VaMlSQ3bTL6lqp4hRyg/xhi1t0RS3W7ZovUJY+4lh0+5R2UZ7Nrabn5/JWs3
r9bzL/vajJmkKH4jrn1GaEQXFq9opTQ4COugZ16E+c9sVERF4IAarJONaqO/
bGzwqrFBEZSg4SGHQhgwBWRZpBlK8PchM2Plo4h9lBqGaCJ5/jUza9bvlVne
Gnth5lZqRhFu8rHcWgNFoaamDBaAXjPS7e5NM5Tg2V6TY+NQtOpH9v0vvyP2
OOzraBJmUZQwWxz2dsG5RVGCXV43drEjv96z2hryvKMuV+Niodl8pZxxopb+
KWcSMem4OWe3K7Pgf4gr7HjUUROeBGkRarXfUWO7WGoKWcrZPkfNaptSJmjW
mlorwD5Tz8ZSUyRRKvWZ3JJPXd0lrbH5UWvzem+F3TaCde+BY8kbxspNZA20
rNop8FJaVtpUntG06p6UNvgnilYXYMkP3D5Jf39/1XJJnpaMYsZySlH1ZzMK
HTgpRXXUNFC0+UeqbFnnu/4lSiwKLadPHr6GiNehZlzlSqTJadEUkgamplpQ
4EHZMWlG0bmQfzZaqUejspQ1ZjO0mLOp8h2GWnIkCihwb/hdGtn4SWpPfO8k
7b3f/V5mcV/fdnTWUVQzYzMKncBajpnsUayrmnqPGfzJycmh05Mp/pE335+b
m2shkU4sRTJRXbYbGBggY7eg0EVeGnfUIRAtxOZWXSintGF1GEWrE3ZKG+rZ
mJmLOQhBqzNXubpvsdBQQdbNlboq7jPVWuxMq+HRZ9awsdTq/D5TV8VSa917
1KzfYusTwobgOWrWzU2oG+ozPMW0G+qzsFNUBCVUzK8bH8TUl2F9rvVl7Qhq
VV+GdcNhY8Mi9bGGbEAJUVtk3RD2Znprcn1RlGCNXlM5FkEJu9OvebuwOpOd
0CLrKY2vgBLs0nxFqK1awYb1ZLCH38fI9qzqGdYsSk2NSaXZnHcjStjxe9XU
p3Hra+WlBVFY6zPg+SmKopkioFTjPAclq8by81D2noSW4mFHJWTu7B2VxhrB
9su+1RAi/SXj2dvhE3a2tFAP+GHt5U/J82qcOPnn5+eBlLX5QbM2z96pa+Tj
d7asH5R/WDEfMLNKEfzGaLZ8wu7Ai34vmcWfNGXvnfqI8jtbFrXTeHe/yeZx
+7qKEjLQPrOjU2SPmf54Sk4y9pm1bBzKUhNPe3w2BFVOU2J27IMMezJkyN/Z
6jK8dxveRc4ckIE8JqsyRQmnbHEoqmeYLV/w8ZKePcSdxSivEN16LvT2wMjs
7Kw0FUEhV6GRjMHnTf0Sd0alvEJO/Y7Jqfko4ZQtWHWXyeuCnj9DKTWMYCeE
O/3cggZizbhzwpVGgx0+PkBl3ip08gnXkZERWRftMGM2DkUlJiqxh0T6MyYv
xp3lrvJ2ISuJZ5/2dklvEMSdKyuvcLrxlM8fyCbn6/ln3OF8PVRR271VWQyR
L117/phVal0ACuG3TISvidJAe4X99CccSthPz78h0IiCZ9P16zaviQJF3nlY
W4Ny+sPppMejkAkEJe7+hfIaHx8n8QjA4x5Fr3qltzqIHGJX7s7E3RVR3iQy
fCPnZu4mi9x5AkWvv8l+3RcdNqWkLq8i77eoBMgCltxOeNTvbaajSysDBole
oknbCZr0Hsb6plHmWsvkMHrr7R93e0huTuEdPA9E2Y8G5Jb9hIddD739Q3zi
kvVNY3GDtw70yJ084CQ8O/IpNZ54TqsGvcHEgCOBbnEcEIaMwiSD8puibLXR
a4PghAVImxwS+QTrjI2NoY3esGYEkePePTmGGtqHyEQeshj6bI7i5nqVmYvk
buPxUbh1e26owQIDk7kMW56ZmUENYgBu3X5HAGsQyiSCLZncpG6Ql1m3gLNv
AmJLJMEp6W26NS4K8aTe7UMgyRsut1VQkpBBqPTW4FofsZTAvMUTElsPZkpm
q6fGm4q2HnM47bgRXJZv8MT72GKlcG0nryIh/mLtqjckXcYINzGVBDFlbFVp
CHHMzLxPyY4VH/4vyepw5N4qvIkYeGMPjIphsKs4N+liHPKpt0F5jxiIzuIK
6QkHN66X6f1VpKcJ65Nf6ImeUOlqEhe1CVonY4ImYrGKw6jCVY/ehkbS4Quu
BdNgeGyE7cvEQNLBUD/nfgh23sNJ5jQXQ50Yn4TFW1ShB113739r74FjbUJZ
YVjRRDSnNCJhOJ+PtHXdm+wsb+eO+Hb3nHP7ejHyFb0t35bJf1EodwbX/w0p
sj2eu26s3fUP/03R+J8YyZL/AKVGGdY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226009644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300502267],

Cell["Use the natural scale to show regions:", "ExampleText",
 CellID->1665503342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2003831251],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182154214]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoundaryStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5613271],

Cell["Regions have a gray boundary:", "ExampleText",
 CellID->1810853759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1291149738],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46750508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103536352],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to show regions without any boundary:"
}], "ExampleText",
 CellID->965592159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1499262702],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWctOWzEQvSSB0m4ob8ijhDx4BVi19EGpqFpBu4BPqBShSrCoWlF+o99Q
seAP+Izu+jFd3p4JY+I7tu/1zQsQROSeOHNmxh6b8dg5aJ4df/3WPDs5apb3
T5s/jk+Ofpb3vp/iq+xQEASX9J4L8DnEp9b7MgyB+rNGzyzJWq+ggEcOzXlg
Bljk9jPBm7BqF7U2nsEcYa4tDwyG3W6JvQZZpuFFvZnh73NCa9bwU3KMa7Il
rohelAV7xrAn+5kXFqZaWOWopbdXYM2onZKhZ0a0YB1725Ztjkia13wQLlhn
wlwx+nMMz4vW7IwZvXgk7A132ZZz3q292+5/qB1X7dunol0UbbnupXw6wSvZ
b3umdXHOaMwxXoU/f/+9AG4CKxHN+8ajCGUEY/HORG5UrIJcn/VkXpftYU87
I5p/1c4qe2DiL5jHYwvNDeBCyPtKKztllAXDk+K3PSXz14HVFJHJg//S0DNn
rB+8V8A1YC2GR3F7beWptT4HyTZwhRmutT4L+Q5wCbgU43EG8l1gFbgcw5uA
fB9YBDaiPC3i532U0EjXeO4/cY8y0QhounUe0y6PMev0UuMo7XDU3Mwqx32b
58HNpDW8CsYbnlM3k/JVg1dHvofMdV6ZJpPiVWHGFsfTHUeqqjY0ptvrYJmU
E3IqawmNTc5bUQ29NgpSacpMmRWaskpxW3osmCShptTQPbo1/XyK7Bkz8ufh
1f93NGbXGdhLwzaDg2VSfxcFI3593/xIzFm7eaYeR8VIjqOf15vLKCo3+jPt
WdQ/M6t8qzPccSTmGlcB8TuH/x5D+9YyGG/DpH2Lds0aGO9CuReOco9l7qCa
YQHMj8ApM99G8o7MkxuscwgcS6l7nsAl6m/GXtiLVkPU24PwqrLYtMcowqdR
fgCWgavR6BtVG8W+nlC16VVgPYY3z+tjteu6U1WwDa7QXXVnrytne6Xv5kVP
EN3x7vPp9OFc3ymP8sf1fWnK83yQQs9VS8pzuNIsK3nwRGhmPD12queTUd2x
SXM3MZi8YM9HeqZUma1XmVJl3v7eMXS2x/jeNExD/h5YAa5YIzcOyWceSSN0
VUi9vWOgNZSDvy+MI04m9bkExh5wMrGKSnf3YK/MaPw1ngFV5Zknw84ryMHe
PSSdYN2Vuc/Z1179R3Kxt4a8JVAndF3DnAdXhez2Fafhf39wV86TnZ0878oJ
/jYyKV7jQuOXM46D/ZXr4XfL/vxuecEp6T+Brv5u\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19565242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528020436],

Cell["Use a blue boundary:", "ExampleText",
 CellID->1521384906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1431570545],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41279470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->364998925],

Cell["Use a thicker dashed boundary:", "ExampleText",
 CellID->1512818153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Thickness", "[", "Medium", "]"}], ",", "Dashed"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129293624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145835371]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25149962],

Cell[TextData[{
 "Color regions by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values:"
}], "ExampleText",
 CellID->844961974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], 
       RowBox[{"Sin", "[", "y", "]"}]}], ">", 
      RowBox[{"1", "/", "10"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], 
       RowBox[{"Sin", "[", "y", "]"}]}], ">", 
      RowBox[{"1", "/", "10"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->986605617],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326648435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324531110],

Cell[TextData[{
 "Named color functions use the scaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->940465328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1815478652],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144072899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356379159],

Cell[TextData[{
 "Color regions according to a function of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->268528963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<SolarColors\>\"", "]"}], "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], 
        RowBox[{"Sin", "[", "y", "]"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37112921],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->582208546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->654606299],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2123132482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->921125776],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->702318019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69980572],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has lower priority than ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->573080239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "30"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Black", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Black"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2062143332],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369822155]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->368166912],

Cell[TextData[{
 "Use unscaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates for coloring the regions:"
}], "ExampleText",
 CellID->191837874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<BlueGreenYellow\>\"", "]"}], "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], 
        RowBox[{"Sin", "[", "y", "]"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1230709205],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147123798]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxRecursion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->178798526],

Cell["Refine the region where it changes quickly:", "ExampleText",
 CellID->1232698577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"Nest", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "^", "2"}], "+", "x", "+", 
            RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "r"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1751045384],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226859702]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7788324],

Cell["Use no mesh:", "ExampleText",
 CellID->553996305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27996],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->796424446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169395773],

Cell["Show the initial and final sampling meshes: ", "ExampleText",
 CellID->50507481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "->", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623192602],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztvQl4HMeVJggTB0VJ1Gn5aLvd7t5xb8/27Gx/c+3M7ny7+8183W5v25ZF
kRRvECAA4r6vQhXqvu8DqBOoAlC4TwIgKYIkeIuXiiJFSZQo06aOliXLamsk
il5Zx6d9GS8rMjIrccmXRFIfRWZmZcZ78eKPiBcvX/z5o4LG0uKqgsayXQXf
/X59QW1p2a6G7/5DTT1cyv5KVtZX9FlZWZPfyILjz+CI/M/9Z4D/8XA5R9+B
v7Ph0VXcWXa6jM+yVsHht+CA+zeb+S2Luxf+/7rMb8t57luLyPveF0iXe8h9
fyH5hZSSI5xnZX0z48pqyTMPZ9yR8zlK+eaSmnzvS6Tr3eSfb8DfOTLtlnn/
w/ydq74wNfjOl1h3tP5fLHnfFwcvXz5sfx7r5n6GY9XXPpem6ae//Qex5h9L
t9/Neuwzj3xuTdlSvvUHs+afQle07nf41sjj/03Pkas/E9p4sd//TPL7937P
5eHcy6m8Ml/mvs8Wns+5sqPw7yPLuAfl37+kNXMzrtwneSZniXNpCy51/71/
4t/JeS49x0rjmPB7ttTvRdMVWPr3YjlRDRFFd322XD8h00b/D/dP3s2bN99I
/3fq1KmzZ8+uSqVSWXlwAxynyH/Hjx+/cuVKNtwhHWGlo9Pa30GffyV5hoxI
eZ9++ulbb731DvkPlJibm1t19erVrLwnn3wS9LtK/pufn3/hhRdWwR1Z2W++
+SY8wj36Z0vouuaz5fdD7ob/kztd/f7777/22msgenh4eGpqKhKJJJPJrGx3
YHyVwzu8KjlyOisv1jvfN3wKDuFPa7u/M7aP+z1rNdycSCSmp6cnJycvXrwI
9vztb39Lys1eNs6pJt/5zW9+AzWG5pma2js0MpkcmDZZ/RqDz+tP9g4cUGt9
LQp7R2RmcOycUuPRm8NwAKd6U7hFYYMb4LZWlc3qCMKD8PjevXMXLlyAAqHY
tEYrGqmYO/53Yl6oHii3f//+rq4uk63XH9oT6nrS7h0+ePy1rNzUc//fqsm9
l/Pg36zsYNf+U0//Cznk/rr7zDPv7dn/glof6R08CYYDmw0ODh49ehTa/913
3/0vEmlf/Xz6/fV7770HwD558mxHMN6VmKpt0LgDY23tbn9oQqn29AwciyX2
9w7OK9Ve0E9vjDg8SY0+YHH2J/qPa41Bh7uvMzpjsvc2NFsSyUM2V+/EzEWF
0hkIT7aqXFBUda0KivV1dB0/eQZ6FoiTar4SBLJ3/Hvur7sAO4D9w4cPKxQK
sBJgbd+hn55/9oNVxJDzJ9+I9x/jDheydQ45hxO4xB2S51afOPs23BvrPdyu
D7tcrhMnTgDcs/7T72xzovO/ha4JHXTvvgMeb9RiCw2OnnJ6+vSmYDx5SKFy
t7V7yyuVDc1mo607GJ0OxfZEuqdrG41tav/ucgXXNMFRtT4UTx4B+zcrrC1t
rqKSVqOtqyM8brLFegbmVVq/UuMrq1SotIE2lSfedwgKd3j6ksPH7M6YyxPZ
t28OcAlq/EfZtuDmDdZXyJPc9XdkDADLAxSh9wMyI/E5wCo0d1be57R7LrE7
tF1335Gx6YvQT6BYaFbO7v9eIv/h5ej3H6B68HBB4e6q6laHO+5wJ7dsK9UZ
gwBosOBj6/Nb2uyA1yaFbeu2ck9gCK43tZh3lTSqdX64XlHTnl9Y3RGZjMb3
FhbVV1S3W51xozVWWNxQ26CHm70dw9vyK2tqtXCzSuvdtqPcYA7DdY0usH5D
gScwDMd6U2jj1mLoJA53orK6qbi4HO3+72Tt/h3J1X/L/ZX74osvHjp0CKwB
cORGDTI6ZHs6JuBfwZKf0+J3g8VhSMSicMQB08NAA7PJv/zLv/ydRKP/SU7D
//zLX/7y5Mkzw2NPBqNTinZ3U4sFVDXbE40tlkj3gam9z2sNwSaF1eKIzx19
5cn5nzc2m+Fi79AJi6PLZO0CxIL24zOXAPxwvTMyA6Y122IwksD1zugel38U
rkOB7sCI3d0DKsN1QD5cHJ5I6Y1Bq6vf4x+G04HRM42tNjgABWCYqqnXgUpd
idGDh+ZBSWlt5K3+t8TqgO7Lly+DIVqUnq7eeR7XvyerZ1Or4++5MN7oLXEY
bGCiuH79Otp1Ebv/G+6v//rMM88Mjuwx2yNQ1szcFV/nKAwl8eRRhdo1NH4a
4AeGgIv7D7/s8Q8MT6ZgHDl+5pcma+TwyX+GwQI17OqBFroICoEFJ/Y+29N/
6PyzN89evOHrHDl84jUosGfwBN4DN9MHtcZO+NsbGIQC4Xr/yKmB0ZNgDegL
+w9fA0EzB16EAo3WqD841j96BpTsS46BwtKaybfBvyYjDHhlp0+fhjYAG4OF
oJag5h+sJch5HhQCRcHVjsjsyMgIzC3/Zom2ILp+46OPPjp2/IQ/GI/3HUgO
HVOovNHEHBgfCgUb2t3JcGwGzAUjDzgh0CJwHRoF7Anm6giNAVjRsKR354LB
o/H9am0HNgfOSrnYKqHYTLs2AO2BI0Eutkm71oetgVcfgBYJd83CUAZtcfbi
+1Aho7ULnvZ2DoNioN7AyAlQtSPYc+zYcVD+bxdsF26E/Zt0n4BhQafTAVZj
PYeyVoGxsrJ1pi6Xb5Q7zCXnNQ1m+Jc7zCHngdCMUtOZ/n2VxZnMI9cbFa5w
/IBwH5zAJaEcKBSKpud3QSFQFBbdEd3bovRaLBZoH043TvHvsbqu+fjjjy9d
elajs1fVqAuK6mAQh/5QUtq8a3dj1ipAaVZeTZ2uuKQBDmGo+fvvP9qm9uL1
nUU1JlsXHLapPf/97x81WWO53PXsqlrtxk1FVmciK4ecw3SwfWdFaVlrFv6u
M4a+/4PHoXXx/MGGZuPmraVmexzOlBrv5q0l8AQcb9xSXFreCtqATuVVqt2l
zS5v7PLl50FjoruwOpf2CuK7537yySfgsXV2dg5PPj1/8p+zcgCvWdnR+MHh
iae5w1xybrT1wL/cIf4OQ4E/PJP+fRUMvnnkOrjr+w7/VLgPTuCSUA4UCkUL
51AIFEUOyUMHj70Kk7/H44GJ7W+W6Cl/zf31LRjfgqFku9Zrd/c1K+yBMHju
zwMmW5Tu6nrD4NgZrisnDzcrbDABAIYbW0xaQ+fUvuc7whOtSgfMHzCLuHz9
9U1Gt68fjnnNYQKprzfCZMJrCt5Uc5sdyuDPm9tsOHng/Q/BCFXXZAQBOPm0
tNrhWRDf2GIDVUAhUEtjCOpMISgjGJn0+GOvvvqqtI7y4xdZxeWA+wGDlycw
0Td0CkcjHMKE0ecPNIpl4yhGz3Ng5QHOMUwusHL46yVaiej+HWjOWFdfMLoH
gDoyeW5HQRU4nDCSwdAFoxooBuMjzi0457S0OVz+IYD3zIGXwHeN9R2EeQaG
Ixh+oOngGKcFGIrI+JSDEw5OLKROOaScIzjt4BWYZOiEQ576Ks4wONtgCXpj
CDoXKAMqpee6YWjapjZbJP4kDLFdiX1d8UGojrTe8i33V9xfeWAmMBZ4QiAZ
bfsnbb88lAN3jY+Pw3IShgBpnEDaiqQef/nhhx/Ozu7vDINFrhgtUbd/COw7
O3cFTBYITeL0hG0JB3AKF1uVzr0HX4J5B9bLNlfPgfmfQbPBOhomKWhCUBza
Em6mzcnPTdga1J/g5yZ0H6g3wV+FdmV9CSzha9i26EwEYPWp8kAjQ1EKpRtU
RP1gAQoq9g0dg/JgDe9w98BwANWbnJyGqkptIt/Cf0nOL168aHcPcaPBKtkW
+BO19GoqB9awsJiF9gbHNaN1peekTve//fbbDnf4+99fB8sRsHGTwv7ouu0a
QwccV9dqSspawJWgDY71XltQUAMzENyhNXSs37SrqdUKx2o9LGEKYRkGt2CL
4915tNURjdDi5Prd1EFEdwfaHA5os5N71mCrsw0Px9joWHpOW7tne34lp4ux
cxUsuFbBv1n3/NOPNsIcDodQkx/9eFOb2g3HUEOop90ZfuXV1zKsId/uf0HG
ZOjZsGTtHTwJ9s3+IrU8IwetcfT0W07f6Llz56C3/+US7U/q9l1w4yYn90bi
M57AIKwBwMhgarZbQYeiLj7b7WHUhJ/gBjjFZQM693NHX0WnEkGAvZdiAAGQ
RT1WRAA2v8hjBQjAGdeYOIpTAEh0w7lFMiThReoxr4KHs/Lgcaigr2MI1uej
YzPQ96UWkscAnr/00ktVdcZ0BO6LiAB8vrvviNPpBMRmfXeJ9if1uhdGCrcv
OjxxrqZBC1MgrtHAVKAgnTWxHyMKwOuhszi5fg+iACAA62q6uEtj4RVuHMCZ
mV3j4RVsf2x8nOFp24Me5J48bHewgkSbTJ+CXL+Xrl2n9j5Hl50gtKKmHXxf
ty/25ptvSi0jXrf8OenzH3zwwfT0tMnRZ3UN5Ml6tX9871lWTg78aPMMJRKJ
CxcucLqz6xps46dOnzVYOmobDBZnvKvnkN7IRVZIIORpGMErq1Vci8B5Vk5n
dNbu6quu04NPi6WDrwsOdFOLeWD0DFcl0G/yaYM5rFC5snLJeVfvYasjrtZ1
8udWR4/DnXT5x4hq4GPPXgI3oklhw99zYByFtVJtvR6KRhkgrFXlrqzVggNN
nrkXVkQtbXazvQvjNop2NygND8LfrW1Otc4DVUq3l/y6h7xzzYV+EI/HYfmI
C8WsPLlV4h9rNZpNV6PycnJRTnfffKvKd+rUqYw6SXswqeMaGMgm9+zr6tnv
D4798NHNVlcP9EVPYGjDhl1Zq+AwK9viSPz40S2dkamsXHLe3OYsLKrjVqW4
Ci3mJnMuxpmVQ34PRqee2FLkD47y95ts3XB/KLqHP29osdQ3m4T7o/F9m7bu
BpH87+AyPrZ+h8kW48tvbnPAEpr7ify+9tHHd6i0AfgJ/mzfUYFxVLsn+YN/
2ugLjkJNRsc41wx74pLjM3lblQfjGMx8ODTiGJr3RR6nV1M58Ad61MzMDPdG
S/qWUNripK4P3Lx5szOYgIae3HsJRlnow05vEo5h6AR/J8U52i9D6xrMERwB
cbSFqmgMYZzIsQ5gda0hCDfzIzTcqjcFcQzHK1ArnTGMUzc+A6M1H0nCeoFw
3k/HJ6BeYrnZIJcLHY2exCfug7GZRPy4yRmfBtXtrh67MwGiu/sOh7tnoXo3
btyQWkO+/THz59q1a7BaPfPMe7xvvlT7fEFwwMhBvWFtAr7m+++/n5E1IsUC
qfdD4L+Ho4NmWzfMcdU16ql9l2HGTY6eghF7bE8K5j6cKNFrEq+Mc3H2pN4d
elo5bAwY70NPjsZuee8NXTlhTYdPs8FfuiKn0zo+KVGGfxK1wTmePHk/BjtR
EygF6gO16k7Oc7P7vsv1TQaoM9Q8Gh+HST3DXvJo+cZn/EoOWg3cef7NyJcP
Lag3+PuAFu71vfSdvRQtpN5ffenqy8HIcEdkqqxCoTVw0UAYACrrNIHQOPhq
HeGJmgY9utPUzabNhH4XdbMpbNBrR9Sk0u43v/ajS38KHrxOV/4UPlgKXQeK
IgK4ChQiAljGAhrmUg0RSnxsG7GE+tU1GZ2eJCxVzbYupcYLQ+W+Q9fAHA3N
ZpO1uyM8/LOfX5faUx5NXyfns7Oz3b1Hlt/KXzw00fJ6enpefPHFjGxKKZpI
vfOOnTilVLui8b3gWmzaWtqqtBN/Y01xaRNM/lwIW+3eWVQHSEmJV+157HIe
24tdY2DIARGFbUpXc6LIAvs2iYksiCIOiCgshY04cCtLvJtdb6KSi+q4FmGF
pVBUgeJbd5Q5PEnQOtw1s2VbKf/GoLS8dd2GfDAQmElr8J46fVZqW3lkYU4L
rOQ1hijx/b+kyMLf+4ZOGawJ7r38N5ZAFqn3Q9evv2q0hMCfjvXs7wiNce92
7QlsOzQ5NgIABeACtsd2Y99tQQ34mBVepchCWPFzDuKKjVRQTIkiFRRRfKQC
n6Z4AjDhfRRLPNoX0egRiiOsEVWQ1QlHwp6BeZ0xBHYAa4BNwDJgnwxLyuMI
M1hPn+YyqrDVvtRIgrXiudm5l8CKAKavL4ElUve1P/3pz6yOqN3dBzoarOCa
TkBXBAhg64Hxw937uXkCI2gIqZ7+Y9B86L9g65EcsFm8gk2FpaCWJBTxrBDr
QBSNTl2gsQ5EUN/QMYAPPoPyuXEI70DsTMxcXFhyHmIGdE4MHGNm37VUPhYK
RoNJDWoK9YVaOz0Dbl8v2CFLajFx5IPYK3ffvn0O7zA8ZnYmYclNJtSs7KGJ
81pTjDvE82jiICzxhXM4gUvCeZs6AP9yhznkHEqC8tK/r4Ia5ZHrUCgULdy3
lBxUarlysnJRr/GZS2p9+MqVK6SObG40YuTs2fOwarF7hnfsqFS0uyzOflgq
VVSr9OZu0LSplVu/2px9vAwoDdqocHdjVi7pznB7VZ22pFzJn8OzNfV6vSXO
nzcpbEUlDdxhDjl3+8eqa7VFJc3873BnSXlzs9KTvr/VsSO/SrjfH5qqbTDs
3FUnyNtd3lrbZMXzHFhe7dxVA84MKEY0XKs1hoqKGzoje+AM8FNepVTrQ/BY
k8JaUFgL8qC2UGdqDfkYCtmZkZdKpWBlhUZG63+pEZFH9RqZujAwMADO8yNL
jCPEDvelLlzQ6H1gTfhT32iqazRC/+4bfqq8UglXoLxoYm7TtlKtKYSt5PSN
QBvEk0d4vWAYq6hph1v5c40+aDDHBD2htF0ljVAI/zsWDX/z5w7PgNWRgCbm
zyuq2rGB+ecHRs9U1qhF8mrqdVBq2i7t7uY2B0XVfb7OyfUbCozWOJxZnf0o
C26Hg6ZWO+iZ6D8OFQaYSO0jP9M8RM6vXr0aic9xg9Iqyfj+ZfWN8R0b1StF
ct7Gx8e5Nbo0m1OKHGKTB37961+brCEwp69zGFyZcPc+j3/c7e93evrMthhI
wjU6DOvejlG6biaDeJx9tw2VhT7MxlbAmXF6h7jZi847MAmgB0EjODD1sTEd
cGGsziQbB4I5iF9vLSIZBg02DiTMm7hWZyXD80ZrzOXlVIWaQn0d3l5v5zDY
0GyPvPXLtzPsJo+oB8k5TPSAUGGtfosgitELewqu5bko4MNLoIrY5aGbN2+6
fV0aYxQKAvvChB/vOwTmBj8RTA/AGhw7g2t5dDCxidkIjPQdO7qn0rgMOszo
ebDxoBRd67PxIGmUCB1maYwJV/TL1UgaY2KXALi6ZzWCapvt8UBoTGfshJkT
0Aemcbj7YHSDecDl7bpx44bUwvL4e4CcwwTBRxZzblH80Xfa+/fvF0byhfFH
7JIL+PMHujmfqaCmqlabtQrGJrLe1RqD/MxYpTRao7j2pitlfqSRxHDE7/2F
KJMktkOjTHxsRxJlopCURJkk0ScaZZLEsGi2wcp0lMSwaE1ZHR9kddSbw5u2
FMOACvDcuatW0e6GthgaP1dbb9i0pQTMCHYF62a0gzxKcRfEBx98MDk5CWNI
BhpuFZTi78OTTx8/flyYHZZA6YODQ+Px/iMAxqYWa2FRPRyA6i7/MHjb0Hrg
OetMYcAG1gGbLksSLRJFrthoERu5YqNFbOSKrvL5yBWOazSexUcZMuNZbNyK
jYrRjIgV6sfGxLCa5PpXJfrRzmK2xcEVhRJ6Bo+XV7VDOYDXimplQ5MRbBgI
T/cPjq0EnzH4r/ewHA5uFXzieV2j9bnnnhNmj4XxSezy0PyRY72DR5xkwoYh
AJaGCAFsf9o6cAVRim3Hxp/Y2BdtfVHsi2JTFPvCsrHZ0ctDVCIkJdEwUdyL
4jGdpbFsTSgK+Z6WzWBQ8paJjuXseyaYV8BCemMwFt8Xje89duykdBQQRzQQ
e5cvX+ZXgHm3NPY6o3thQcvl/qR3XH+PtcO9169fV2pcXb0HPP5+hycJS0Vo
GTQ4XNSZY2l/Kgfh5nD1QCPRaFXPwDw3zrDRKiyCjVZ1RqZoVAzaFVxSbtRD
/aA9EwPHuPGOjZKBaBoTQ2RpDR38E0tLRVy4vMm0ptyIG08eAueP9UPvRdn0
ZTZZSiXBCGAKf3DM7k5cvfry/Z8tFg3hduhm5bzyyivV9WazvY9mgQhZHcvL
AvmCZJtI5GTolQOFO7zDgUDgk08+ke60lI5lxDb3gmPt9EZKK9t2FFTDAhDW
kBVVqp276nC/RP6uGnAIMUPEHxx9YmuxzhTiM0Rq6jRbtpWRdk7vkyirUOTv
rBb2SWzZXtascPDnLQob2VfRw59X1rRv2cE8T/bc1ZdXqfjfVVrv4xt2wrJA
kLd1h1heSVlzQXE9/7ta539ic7GGwyE5b1Xaf/STLQAUzGC5t7xaVbCrDvdp
qLSBbdvLcaPfug0FZZVtbn/sww8/lNpMfnbE/etg4vHx8eknX8wS8sSEvK/l
5Yl9QfLRJHIy9MpBebHe+VQqtSxcrR0ZnRqfuQTLiqo6LazuJmYu1jeZ+kee
guLgtLxaqTN0gnPB558plE6TNbrv0DVen4HRM1ZHgmQ7kXOnbwSA08PhnJxr
9J1WR5zE0Yh+e/a/AMC0uXoOHnsVS+DeuVhjodhe/gnwjSz2bvBE+fM2tcfm
SogkGsCr7BhdQGK7xmd391KJ2SCxXesnu4BI9pvLPwbeKu5q4aK31SqoMpyW
VrSApmCKicnZlaDr3Llz/DwjzE236ByYS+U5faNcFryUz0KKMGKh+1959bVQ
13Rjq6UjOguuDnR8jb7DF+Siq+nYHLdBBOYOmG/4uQjmtbmjr6BXhrMmt4c0
sR8fwHtgmoLmwneUeAUGDG6jIEmzpt4Z5w2deA1mNpjfeB8LpkRQBHNr8UlW
BZpZQ/1CVgNwxWDiXEgD0BuMyGiQgxoweq9F6eh/gQ1gnWpxdJvt3aA9nDY0
G8Nd01wWvdS68igk82kOZuhhY97yOMyj8mBJDkM7DPBrl0AisdKD7733XjDc
7wkMRrqfNFm7Xf4haLuBkRNKtZ9uDgUkgCzwYng8Io7QeaaA4FexiIgUyQmE
p/l7ce8TfX3OX4XWhWph/jddB+chOuCQQhRLRozAIYKUL0NeN4ysLKgbAnZR
3bB2Et1yqW5s7e6jmsElMJrRGvd0DHO7f8whmAaGJ89xmwBC/WBqaZuIuQzk
uAmlvAGIbWhhRMvthW340zt48uLFi1I7PrxSC97dGYz+8MebdMYggLCotLGq
Vovbb5sU9pLSZkQiYivFReJ4eOEuIcQGCzCCKQ5ciJO76S4R+IP4SnG7pXiI
YSmI/hQJgCDIUiT+CABL94R0B4AzxBiWTvfB0L6ZqSONLS6oI3aCxXWkNV1Q
R7amrI4tbfbNW0ugjuCort+40+JIIB3Fo+t2dASj8v0AVzzC1UzWPSlbEeEx
49bbTE7rLd8fVrP94fyzH4yMjHDvBqXMVA99Pmve//rrr7t8Pa1KZ0d44tCJ
12E215kigByndyjSvXdi5gKiBoFHo4A8+OAMMYPjJQUfj7x0VIbHDMKOL4NC
D86wb2AZFHo87ngvJt03EHT8VdozWO1yWe2EeKa8brRXLKgbWz9Z3R6i9aMT
A0ackkPHwKmHigVCE5HuAxNcpkyyWWF3+XpfffVVafthn0jzhiFND9OYsq3J
nZLnsm/evGmy9abfYt7yfYKRR/fK8m+X0ha8//NZ8u6PP/7YbPXOzr0MDY/x
otm5q4AvZndYDqIGQZeOR/KYQ7hksXGu4YkUAC4dT+KwgmDDJynWsBPwTyLS
pvY+BzDj41+kB+COd7yC6Ge0yKFa0Mhppgaou6wGIt0zNODHfgQ5Y4276Q49
QDgtCNYugY74p59+uuYzlrNs5WM+4vv06dOwICZNfZvhG9+eQntdv35dmAN/
l3GfWHTNc8+/YHclXF6O5StF3lW6/YO4w53XEZAC0wJhp2DQpdEHaH4IoAuD
5bzWgBBwqEjkgTyByFJpvVBdajdvx5CNi5aQc0C1RheABQh/DtJBByozG2Uq
2l3871KJoGNTq0MqUdHupDrCgdOXdHmTfIYn6Mgl5Tt60vtA1sCBwRyGsRkH
fIOZy4VN9B9+6aWXEbXL8FzSTLdS7/Mucv72228Xl7YBBmCZ3TGxqk0d4OgT
uJipBUbt9PWsbLt7sKxayx3mknONIdrU6hLO4QQuCedFpQr4V3geCoMi078L
cqBQKHr5cgS9liMnUy9BXnb6fo/Hszz0LmrJXBidHc5gcWkTQOIn67Znkf34
2YXFDY8/sYvEU8n5zl21u7lEgU4SxODq17Fuw84WlYP/vaHFUlTSqDEE+POi
3U2i+7WGjic2Fze2WPjfVWrv5q27lRoPf15Tr99RUCPI27CxsK7RIJK3cUsx
QS0vz5xfWNOu8/PnUFhVjUYkb/PW0qY2G/97W7tr645yQd7OotpNW0q4Q3K+
BpQrRoYEY+ejj21rUdjhwOmO/uY3v8mw8GKIZe+TniNy5+bmZuZeSo9bt9O4
y2fA9R6+cuWKMA8thdwlLXrP2XNPu3zJdq3P7upx+/pTJLgA42woNsNH6NIZ
cMPR+H4uboGa4bAkxAe5OHhwDF3anPQcgTEc/glwKMCn52Ic9A2aw9WDDixe
gbmciqVSA6FJLt6CZUAfEUUlZaV2RvYIehotkUh8dhGp2SAVmV7wCW5lHO6a
RUfeaAk7vcm9cy/5gyNgqQXQnI6gpJmkpZbGGRCc7Jp6cyambhfsHn3qF3q9
/pNPPsnA7sPLsd/aDz/80OGOTcxcKiyqg2UhjeGiByiNKKMfysaGKdsSwCe9
2uKWXkKcDp9EX5SNawMiYCmKviQbxRbic3h1MU3Y2DbZI/r+cjWR1OHEuV8t
qQkfT2fqcDe686gFlHLw2KvVtRowJpgUDCttEfnINuJ4bGzM7h2+fXEMJ1V1
Ro6DUmo1aYyb2Ou+mdl9MJ7aXD3c/l17V1u7W7I8l0SaaUxNFCfGxZAQacbI
AI0pU+hgGTSiJoqDIwaEWLMk4k1BhNeX1E8UCU/vWl2hfjJ1XKZ+QkSerePd
NK4J2jU2my3OeDx51GiJNraYDxyYWx7O0dd75513tIYYlxyQd7vi3OEdGR8f
XxLnxF73wOLa7gz+8NEtVmcPJgr84IcbMGbLR8ky48qIJdzVxUaEaeSXDZ6x
8eM8NrCMaMJS2IgwxQIbQBPFj9nAMhM/XkjHXDb2ze6plSq5uI6yNV2pjvfL
1hRurqnXmSwxwp6578ePbbM4ghy7yF0rQP6JEyf43JnbEvk5KA9jHFK7yWP/
6dSFnoGD2jQdCTSH3ZXAVhNFiCmu+AixJOrLR7wkcWNRhJhiio8QS2LafNQO
S6CQEsWuKZ6W1iyH4p3Z87t8reTrtQKt7pPUi95EM4rB5GB4MP/C+Kar9xyM
Sh86/hqg4XZGNkan0952OmuSeCv3+Du6Dsz/jDKpsO4ltC3XMmz81+UdgMLY
SC42NRv/7eo9TKO9iBM32dDIRqCxefEpxEcvlzo5QLWm4heQno1IZfcXc7Jj
i8rO1BhlJzJlR6nsPKoxzWzBcZoyt4D9PP4YTIfiLwlJx1r8ssn58+cxxQz+
zhNlqt2iGXFSeblUnlLTyb1JlMaLpSMusdu9b7zxRkdkXGcM1tTp9OYwCO0b
fgr8vHlCTa5od3f3HUR5EzMXa+v1ZCcpOe8ZmK+r1z85/3Ne37mjr9icTMYc
uOlVNeoktxOVnA+Onamu59gC+fthKegLjim1Xv53ENeqdHT3Hcqi8uB5QV64
a7ap1SbYB+TpTSFf55ggr6JaRXbKpvWrZfUDeS7fgNEaFeRpDJ3hLj4/j+OT
q6rVmGxdvYMnCZ9crtYQrK7VgW0CoXGOhUJqUfm5H/Ho8/lCsf2YLZsnysi9
RTN/pfJyqTytKXb69Onl4fGu2b0HQrFphyf599//CaYbtKncpRUKwouSXVBU
W1rRZjBHKAddE7hpVmc6Qze/sLaFWyOmM3SVGl9puULNRWjJeXmVCjBhtKY5
5gqL6hqaTML90Pr5u2pVHCbJeX2TuYyVV7S7sbZBzx3i+Y78KiWXxpl+vl0X
2FXSALDif99d3gqYYvQrqMFvgaTlWWNwSa0L8L83NJtLyprMlANvW0E1942L
NGdericw9I8/WO9w90Xje/fM7F8mIvE7XzSTDie729MnzaXyuM88DA4uiUpi
u/s/+uijjmCfNzACkxPnKvUfsnuSg2On6PZRT2As3neIjx3RzMv+kdNsFBbu
hpu4tT6Nuoaie9jcTJibYfhl47AAAxjIuLU9jbu6vEk2MxMcPSqaRnth6hUi
xjCX8jEGQW5MKhcZ0VldoX5LyO3qPSDRNRTbS9mzVqN3oeHY+kY7QpPeQIJb
QUnfAC2GWVhBITf07YzZPCoP/rgD4zBlS20oi9oHXnnlFRhL65uMyBgzMXuh
pdWGjC/oZOEaga4G2FxMafQVvTuEERtrleZs4sJFGoFFvxT9RDbeKs3XlCgk
ivyykWSMki1XG/m6LFcbSV3WYl3oHjtaOPr6dY16sPm1n/18mTgnb/HzPvnk
E40xev7ZDyjU7yAdlDp69OiykP5gRWV9k8KGpDubtpTA33BcVavNL6zG9S0N
ckrzlGkUVhKdpfEkfuSUxGHFeZp5NA4ric/SeBIfn5VEYsV5mnmZSkoixaIo
NM0NXZmGC9VzZRqK67mW1hMUcfuH2tRuX3APiAR/SWfiyKR0xnBlVdOK+gR4
3P7QHqzibdwnVrN94swz7yWTSe7dn/TdnrRfYHYQzLfrN27nOKi4+mStwTQe
+OP2j4CjijEpUVSZjZIyEVtRJJfNnaSRLVFUmY3kMhFbUSSXzQ6lES5RxJYN
5bJR5QV0zGUjuUKG6Mo0XKieK9Lw7sx6Yt/oCE9qjWHSFnn1TSYQDH9alK7N
W4tu3LghbVNx7I2MdHnUI7q9e4X0O5rZ6BdxJuK+Bc3uYiZ2uw9GE5MljORD
CA8cOeEKNCdiBFtQEkcVRZgpOkQ5lfg0wksS3RXFcSkqRDmhiCyElSRzUxRZ
ltUoh2Ke5oYuVxv5uixTmwcldaHuEKsPtbDZHrv68k9JSywcx8NRH9ZksDK7
g28pvocnnz59+jT1eJYa+e/bs+dJi6ObEh7RJSCd2eFUZ47RSDCiy2jponFo
xIfBHKLrO3jE6R0i0QhyB+JKb0nQSDCiAunJ8BnAk7eDIykTZXJancmFJWcj
hkhe3DLlZurKyQ2MLCI3l+rKrlnvorKpucCME1P7Fx6b2av4HXpYd7UofWTf
waKchQIH4fI4C7+g3IgZei0sD+0xMHrG5/MtB8vEnvd8/PHHBrNnE/dZw36o
lFLt35Zf4SRso31DJ2EezVpFyELKqlRmR0KQC32suk4XjO1Pcxsmj9TU6Ua4
HdjkHDBndfQK949OXVDrA9w3SAQuxSqlwL0YCE+VV6mE+8dnLjW22hyeAf53
qbxoYq6gqHZiNs29qDfFrE6JPF2gM7ZP0K+qRiPo5wmMtGv9Inlme1yQB/oV
Fte7vEN4fhfI27mrDg3TM3A0f1eNzRkBF1Bq5cWwe/78eadv9A52M+Vlk79a
Vf73339f8LCXwO4Db775ptESrm00INGqxz+yZXt5baPJH5qqqtXoTEEoFXDQ
1GrVGIKAbGQBra43qLQ+jhoNzyuq25va7P7QNM/tajDHK2vUsMzNSt9vbtf4
YESk96trG/Ru7ms65NzhGa5vMoL3z/+uaPcr1V6NIcyf1zdZ2trdgrzqOi2u
4fjn9RZOnkLlFeTV1GsFrtrSstb6JoNIXlFpo6Bfq8pXVa1W60P8eXFpcwOX
VMTLW11QVAfKwaHDMwT9Wal2c99mWAlu9+/fv4/lRVxoXr/9/AfcaRKJz129
enXZuH1wcnLP8MRp5IzWm0J9Q8dgTpydu1JZw2U7wnWchD3+cUo4IMS9wQps
PjLLPL0I4wB0AzYmTb7w+SLLU5DBOJBDyK5OslHpTOnctz3Tri4rnc0kzZSe
ydOA0lmdM6Wzb7Nx9S7JABidOj81Nb0iZCcSCVj230H2QsjGOOGykf1QKNLj
cPc4XD0WZ2KAo6sYgUkf/oamgStObxJhICEqYGPj0nxlCRX/MngKpHFqXERJ
mQ5keQr4qLQ0Vi2vGf/9Uxr/lmgmyjyV10yeH4JqJqqbvGZSfojsdL/AiqHN
w117xsb3LdYv8uhV+O+dd96xu4cWx+nt2h/wxeaC/eGrrB0//fTTmvo2h6d/
3cZCs62bfgLOExiGY6O1a92GAoyRLclcII5Zr2G/cUJpKJdmLpDwH9DYGRtQ
YyNwIo4G2mUlUeuFdBS+E8sE/UQ6sjVdSEdZHgmRjmxNF9Ixk0eCXL+L6jix
99KGJ4o0hk6LvRMWRLK7P2mE5Rv8vziDXLlyhWfRzL7TY0Ty8Bxm2N/+9rdp
g36Ptd0D7777rkbnadd31NbrlO3u4YkUAKS5zc59CJN80rKR+8jlSdqyizAY
SOLWlE1VYGpdBocBG7dmI+gUfKJsUAmHgUzUmo2fs/oJ8XPaOUTa0RouqJ0s
g4RIO1rDBbVjanivRDvsiKHYVFVNe7hrtnfw8FtvvbXqMyHmS3dAZYyD38iY
T3Af+p35RK53iCPri88nL774YmFRvT84CY1MnXf8OjD9sC8GJLHJ2Yg1y7vA
xLoFxleeQXZi7+VFWA8oAkUxdsTfvkPXaD4qu+dNEucWxdepJjS+jv1hfPYS
1QL1l9VChjdiP8dMO8DqL6sFq/89rBZY9tS+56Hsjug0wP+FF17IwLjUk1q1
zJ4wMzPz5PzP7/QEuZ4AD1++fHl5PeHw4SMmW5fF0WV3JaDdsOnbtV72K+cp
8k7QZO2G1qeR7jaGJ4FHn8XWRXO7ABlO8r04XmcpUwLP5mDopBF4EAfrHaen
j38C9yULGeiIOLW2g8bfUSrZp07OAfFGSzRK2Rk4Nge1XypTpfGcYhgkrI64
29cvaKnVhzJk6gJpLe9GmW1qF/YbOFXrfEZr1Gzv3v/kwd8XujUajdM3sjir
wq3P3iCVh+etKt+ePXsWRPcDrB37B0brGgwNzeaNm4qV7R4Yldp1/u//YB20
KByr1J6CojrkcKiu024vqKYcB9nb8ytqG/QCR4LaEHhs3Y5mRZojobbRkL+T
4WDYsbOyulbLcjAE1m8oaFU5+d+Vas/jG3YKnA/lVcqi3U0iDoZ1G3c20fLV
ev+6dfnwN38OvzyxpURL5W3eWlparhDL21gADh//u0Lp2LSpWOB82FXSuCO/
UiRv09YSEmklnA4g6Z9++ERjqwXOQNd/+tGmhhZzTb2uOz7wu4zZufT85s2b
JA57Z8SWGbEPHn9tampqQUw/wmI6GOlz+QZgcG1Tu70dQ/OE7RQaDgYkOMbh
LEXWihpdwB+cEPJrpewKsCpw+/uFTGBwnGFZzWbXStkVYLKH0gU+BngW5g02
t1bCrpDt9g3CIp2LsuA54EyUfSwr0+MfYbUUM0/IynT5BkVa8swT5Pwu6LuU
N81kjemMQTBgMNT7e8E1pqvfwbUsruE8mUzK4Vpq1T/n/voaPf/000/jvZOF
u+pMjl7wQqGF6xr1U3ufg9Gpb+hUTb1+EnCT5hVGVjI23p7JwZDBC8xHF6U5
t5kcDIAmWBCw7A3o70tzhzM4GDgtZueusnF3XGIsVwuJ/hI2i8W0kOhP2SzI
lTVUC6RXi8QP7C5t7knOclnv0nb6XH0CP5N3p0/IyculURxiSYFxikSPv05t
+O677zo93TA2LjLSGywRlpYyJYnAyzM3yHINC/m4krxbeeYGXPRJ2R9otF2S
XbyYdtIoPEZMVqydTA1XrJ1MDSXaraHaOX1J8K3gt4NHrzvc3dw36j9/z+Fa
n/yQSqWSI6fv9BtZeRZnP/QJYsmsTH62b6ft+BCOP61KG3iv0Fl+9OPNDU0m
aDjwPDZuKgKPHY5blI4f/mjTqad/nRJn7LJRepargo2vy7IUi3J22TD9QjwQ
NI7OhiJFObtsmJ59q5GpYyqDSZlG41eso2xNV6yjbE3FOt5NdZyde+knj+dj
w0Cz4et/uTbGHiTtZ98Uzz34OYg7fUhOXi6NkfJzT3rHOvG+hLjQa6+9ZrZH
HZ6k2R5T6/yB0CilM06RN2WR+KxG78ePDbFRQYpNUTYyxZSIF4JCUxSvp7iU
Z5YQ8V1QWIqi9RSToqxkqWYSbooU+yZhJZrJ120lmsnWba1EsxSZtlzePoXK
CSXPzF2xOLteeeWVjN4gzf/8CrZ0Nv7D/f0tcX85evQoySq7019k+gvlveX7
y/fE/eTnP//5wNhTm7YWd8b2sg46t4mRvAM4ce5XcB2/4hVPHqVvEuhnV2gW
M2Vqo3k8iMLeoRM0fo8I9IemJsWMFiybBiJvePJpGrtH1MV6DslKZ3kwQGf6
9oCXPnhyEemZOi9HeobO97LS8f55bqEesXsGSitah8bPwZQgxTk3cn0FTjl8
f2U588L09PTwRPqbRgtxY9wmHBxSeblu/xhOu/I4f+6559q1HpO9u67J1KZy
PTn/c1gRu339ZZVthLeY+9g8DEzccNl7mCMC6DlAuTTqW8wSbgyrwHUBANQa
OjpCEwKXRm2DQcSNAfcLXBwg1uHu1XK8BfM8lwboE008KXB31NTpOHmUS6Mj
PNHc5hC4NAzWiNs/JMgrZ7k4QL8WhVXEFQLydMagSF6MizSl9atvNFD9VqO8
plYbfjELCqpvMmatIp9mAwuePfe0YGPpjv6vLLg+YFAciURgDueZLBZi1LhN
mDuk8nLhYdx7wqJYeB8QT/SarFFYBphsXY9vLNCSr7HoTKHv/7+P+4NjMM7Z
XX27y1pXkSlfreWS9wWGi51FdeVVSoFRY/3GXUoNw6ihbPds2VEmMHDsLm8t
KWsRGDU2btrV0uZgv+EX3b6zUmD8aGyxFBbXC4wfW/Mr6lgGjy3bylRar/C8
Wh/YtL1UkLdjZ3VlrUa4f/OWUoXKJWIMeWJLscD4Uddo2rmrRtCvsKge1kv0
+TXrNxQq2rnnDZbIxs1FjS1W0BXMF+1KfM6V7prPMr+a8xm/mssVoxxf7t7x
SWR9kuTI6VQqJaD8a0vZVYiqnj//jMs7aLREuBeW1pjd1TO59xJM6u1aH0y6
cAztTfMltfqQhDdDytfBcS13zwhcyzD+d0Qm2ZzmTL4OyrYsRPNpKiteIXwd
cxK5Ii5qZDZZRG4GFzXHaJI8tIRUCRe1wGhCylhDpeILCIujy2iNgDnBqJ+z
RxAOOxGHd478FaFnjIyMCF9Bv9MzFu8ZjyzXvl9newhUr7SiTWeKQk8A8MKo
jZsK4snDLW125Klj82GkEfhMFpBMFmdcWEqzoOVZQFgmZzbyL82AXkwb9n0A
VIU63ItoI8OLncmtspgm8vVgNFlDNUECPjAzOGNT+54/euz0H69HJZPJE2ff
vtOjFupRZ8+e/Rw96hv0yuzsk+BlQOPrTVHwcPyhcXCSYQoo2t0AfyO5XlWt
hk2wTGXE6OWZReT5o+m7AnGG8oLMIiyDtMBPQt8WSPhJltRQ9BYBIzfL1HAB
Fm95hpcl9Vuolqx+a6h+kfhsVZ3ObE/A2l1vCg2P7PkD98Bs8s4jGAziLvol
+sVt2v+4zIb5+XnOVKtW0PuIbfN8/s66JmN1vQYWOjsKqsHhJ9yEa4qKGuFf
+NOssG3dUQE4SUkym9moPvsWhH3zIMtjLXrDwL56WIi5hM0Mp5FU0RsG9tUD
+6ZmAR1z2TcPAmN3ppKL65hZ08+j40I1lddxfPr8ho2FuKOlVeV0ezuzF3wH
8nuY95DA4s68Jyfv83uSQswMPMneweOlla3dfQc4RkKylEilg/lwPDh2ymAO
A0AAJuw7FIps0TsUikh5bm3RmwqKankeFVHGOcu2IckJF72lkNUqhyKZ8oWv
RCNpnVamkWx97mU1Ip39Ymd4j8Ec4j6QbIkMjp89PH/qj+Zb3olj/MH7WCR+
oLHFGo7N4A4MbH5oe/gbjjF/HTCCby7oOwhEs83VR9+/IBYzucE7IzP0DQif
5e7snxTzuYB/O5/OYqdUTaKcc9x+zsq2u6nsbKq0KOu8Mzq7iGRW3+VKztD2
HioZD9BcRmsMFrpg2M8f2UjH+tLvlyXxvYGBga7eeZ7J4g5zh0geeOqDTz/N
vCf4mpwthT4wPrHH4e5zuJMVNdqyijaHZwhqpjOFwZeAv+HY1zlZUtoMB9AB
wA80WLoY1hhVV988redcSVnz6NQFgcVFq+/U6oMCa0yTwh6OHxBYYHaXtfSP
PMWf25x9IhYYKAkUcPtHGJaaSmXfcPr+zsh0VY1GuB/kkc/I+AV5FTXtJLCf
1q+ssk1gnYGS6xr0InktCquHygP9yioUybS8u0Fewa46i70HmUx2l7eYnX0q
jVep9o5P7lkeztl9q3fwvDw8683dL7zwgoBn8lZGyGjft2+/Uu2BdoDW2LK9
zOUfgqc6I3vWr98Jf8Mx4Eqj74ADAIjFkahrMgt8MOVV7c0KO8fnwvO7lLci
vyrP76IzxZparUq1n/9dZ+7esbPaRe+vqtXUN5kE/hjoPSVlrQIfTEOrs6Ss
ReCPKa/WlJW3CvK27eA4cgR5WmOkvKKN0a9aV16lFPhqdpU0NiusInlllUpB
P5DX0GwR+HF2V7S1Kp1U3pr8wlqF0o38M4W76sorNdDxofuPTUxljNTpPaa4
t/Q7YsTeyfpYxDOBk2vXrkkQK7xF+elPfxoITze0mA3WGEy3MOm6A0PU64Bj
nIYpk1sm8wsMP+z7DZhzJ/c+y0V86PsMCe8LmApABC5A+hkumjoxc5Fli5Hl
fekbOsa+5ciUTXlfBNnR+F5WX+47LGPn2Lc6oO/euZcyZbMaZ8pmeXJo/Jel
cQzFpqGzdkRmrl69moHmNXIoRpLROyiWRbE014+gWHjT8dprr3l8gzBaGq1R
l6fP2zEais0ipSD8DcfewAhl0l+My0X6xgF9UgQV+34hJcnSBsMBtLg1IYG1
KO9aygSzGI+L9O2DvFaUx0WilbROuECVvpnBOi2olahe8lpJmXPY+CtyT0Ij
kFXKhCcwAkPMIj3gTr74cuTZ3UNcWj4fO02zZRB3+tlnn1VpfUq1r1HhfHxj
oS84DrUA/xL8D/gbjt2B4cLiBpYvObUwW4vkTQCNjPLjqiTmT+GC17EXpEhE
ETuChFGGDSIuzdYieRuwkI4091peR0lN6XsJ8fsKgVFmQR3ZbPKFdMzkzpHk
h49Pny8oqgd3HpRweftfeumlzzL4eYU5AUlk7vQJOXm54MnevHlTMicIa8lf
/OIXZlsYXEqjrbukvAW8Y1gzQutX12pw/VjXaCwpbQTkpcSR7gWYWkRRejaO
TiN/8lwt2CmEN13YMVLiKDoF3TK4WtgIPfu2gNVPyP+WapdZR/ZdAfsOga2j
vH60jgvqx9RxrUQ/7JrxvrmdBdWwtoaVvVLthEl+ed4SfqjgTs+QyMPzM8+8
l0gk6Ep/Yc6MDz/8MBQdhoWcyzsIzToxc4l+VgXjjOAaAwww/rgkb4uAQFEM
HBGI8GNzrbFj0NwL7BeieD6i7sDRVxbhbqFoE8XyqSY0B5zVQlIHURyf9gBR
HTI1yWSvl2XBuZfVBCUOjp/lWGTCUy0qRyg6euPGjWUh/v333zfZeu8gXhbx
8Pz4+PgyEA//BUN9elPQ6elzepPcPnr8YBaho4TjU2mWGMCZ3S0wpmcwtvAY
g6Lo+pP7hKYhKPDEEA71YRJRQRQRlJsYpnYQaHUk3DCi4hOA73ZtQOBsQUzp
jGEaX+dJbbhcW4lMVk+NIUyj64hotc5H9ZRKBT0NhBBnIT4b/tsaakMAewyU
pDN26o1BgyXi98flefEyGSRLK9TdffOL52HffvneeG5zDUxMTCyIYBETTDw+
qNJ4G5stGzYVwYoXM7//6Yeb9KYQHJttsR0F1fjtxspq9e6yVvotw+xofG9R
SSN4RFm55NwfHN20dXcwOsWfQ5uXVyoJgsl5bZOhoqpdeN7bMbxpeynZc0DO
7e7eXcUNhKWInNc3mxqYbydmh6J7CovqTIy8sc1bS8JdM1RekJdH9dtd3gpd
gP+9IzK5fUclyX2VlVfXZKpt1DPyYnt2FtY4vf34+xqQ99i67UZrF5xBWeuf
KDRYog3NpmAoIfueRw61AwMDMG0svgfm9ttrg+ed0b0XLlxYELUirpdDh4/o
zRGzPV5Tp3O4Oc5mt6+/pLy5IzwxO3fVbO8yWjhaC9yWYnX2WB09JLDBxfXC
Dk+yMzrLnytULoM5PDz5NAnxZWVHug/AeKY3h/nfDea4yzfk9A3z52p9wGCN
9A6exPtz+oaf0pmCRkt0fPYSluDyj8FKQZCo1nVaHfEubu2FEtvd0K0Wlqg1
RuyuPkFD6J4WR7dIIozSEokmW5ego0obsLt6qMS7WlROlAiPQn0B6GCS2b0Z
rFwLoRaD4ncy0eS8BboTUh61X2Pt+PLLL+8oqDLZEuD59Y+ebmqxzh54CXy5
nsFjdQ368ZmLlLcE9wWyMetMzpRMhnP0SNnM5Ey+FJbhnM1VlmYlZ/KlgAbQ
n9jINd2WuLgG4zOXJHrPixlnFtNAojtlnCFX7qIaIDVkrPfQruL6555/YWFk
C6y6ly9f5lv+DquuDLJzYIWAX8rgrSbi1X349ddf15s6zPYYjJ6ewGDf0Clo
lza1G9oVFnow/NiccXZTd0oSo5ZnOZFnK6fxN1H+rzzHiZStXJIVLMn+XUw3
aaSa7jZftm7ytVuxbjL1k+h2F9XN4e7RGYPwW0//wVdffTX9rpOJCIpG9jfe
eMMdGL8zsovl4XggRD6W5mH/6KOPSsvrAf6PPratpkEHzaFod61bnw+rHO5Y
5fyH7687duaXqYXZQBZiLJFlJxfF39ic3IUYSzLZyVOSXF02VL2kjhIGdRqR
XkjHuzN1XKSmK9ZRtqZiHQUe9r0HX/7RT7ZAw5htnb/5zW8W8YFWsy1Mv/B7
Z7aQ7S0zcy/Nzc0t2FukGUP3B0NxWESpdQEYsVhOcBzD9FwQVyDwksawRazs
bPxZlrNcFEunSJRnKxHxqFAgiiLVFIVL65bLxq+FOPryNFu8divRTbZ290h0
S6X5uwzmiNs/ODE5t6Kv3IyPj/P4WnWnf8j0D1i/Xbx4cfn9Y3hktG/oBPe5
pEPXKHU46+umKR6PCrE2xCDLw07RI8NjPjyRolF0xB4Cj41JswwqpxhqRDZv
luVvydAgh6KMRs956ZNPy0pfTO+FNTgi4aJn9L6b1YAtYXLvs8PD4yvBOH5l
4A7GF8K48KWB5WH8lVdesTm7TdYYoBtbRkU23J9Kf2ciRZxihcrFYZxGtVsV
jn2UYR2Romh3nmK4y/XGYIyynQO6ahtNQlYfYT/3kLhTuhbejiGbM8H/LidR
6aQSsxFP4N/xv4M8sy1G4pASeQtpiOOsy5sUJGp0gYGRE4KG4DJSDfk+BEqD
hVaR5BuwmcXRde3atRWN0XB/aUU7Rxa+6g6Dukge2sMdGNNoNNzX2Zf3XdMb
N260q+3/8IN1ja1mjjxR5fjHHzzeqnLCcWOTOb+gOgs51HeXt+YX1gqc6Nu2
l9U3m0Wc41u2lQoc5U0Ka2FRvcCJXlzaXFmrETjYt24rb2mzC8+rtN4tW0sF
TvTqOm1JmULgRC/YVVfbYBRxoj+xtaRd6+N/B5WhSEFefkFNbYNBrN/2srZ2
N/+7Su2FWwR5dU2mguJ6Qb8dBTVQBfr8XWp94Ic/2oQc6m0q56OPbdXqvf/j
f/yPlWBX8L/vjL1ieWiPPftfOHz48GcyGfqy35d+oLdv1GSL0cgNNBEMLomB
Y5H4rNHCvbPEz0xIuD+kjCNwK5IgClmy/uAom0crZRwROMjpe0y7K8Fm0WYy
jkj52QGpfPSDkTomkdoZmRbpCRUTSXW4elhmFCk/u8DHghGWU+LvW5CX+tHu
+NDyviuN30an3zhN3fk2Ootd4dumy8Lug0eOHCuvUiqUThhID8z/jEvVPvRy
da3myfmfE1ZB4ctA0phyJutHJn84LsqkebKZrB8sfzgbx5bmyC6mCRvdpp8G
WpYmkjpIeFRkNclkYr+P5VBJMZEXqsvwZMrq6L58+bmFcZ7+XldWHtKb38G3
FN8wcfHfp+PmMvYbdcRuD/36179uUVg0+sDA2BmjJVrfZNIZgwOjZzV6f0Oz
mf0AXCojSizPryHP9E1j1ZKsV3l+DSnTtyRaLc55XZBfQ55rnX7/bWX6ydRx
mfrJc63fx3KcxJPzLl8/rNNBjYYWE/w9Nn1RZ+xsaja888476R1u9ywyvuOn
XG57/OdRefCHo3zav1/K1iAd13F/+D/+8HGtvhMgYLbHt+VXZRHGwTy7uw8c
6MVZJFg2DjZiLcvULYqesyFrNnrORqwzmbpTksg0G7Jeho65bMRaYLrIVHJx
HWVrulId75atKYisqlWbbV2kDXILdtUiAYfOGHr0sU0Z7BvyXg+2KvV6EEZZ
d/oE7qNbVp9Y+/zzV7wdIy7fEDQqrMPoALYE94Mol5biRJ6LWxSFpliTZ6QQ
xccp1EQxaIqzpTXLof2A8mSsRCv5eq1Aqwck9aJi4CL8BNdh0Q5qB2Mz0AjQ
FCvB/fXr13EHyx3c496ZDxKJBCzjl4X71TCXBiPDRmskOXxC2ItJWnhBBgeX
d4Bm1CI2Mjm4u3oP07gzNrebbPpmI9Fs1BvRhOyGeA8iidv9KZHuodKzEdcC
c8VyZGdqvAzZeVRjuoeU2Gg1Iph8FuqYwRIJxcbee++9FY3b0FTt+vCBo9cx
sS8r73bMUsyl8kCjI0eOZLBTS9GLjB79AxOAhXDXbGm5wupMCKzZSrWnq/eg
wLJdWa0SWMAJa7ZRxLJtcyZM1i6BZbuCZeUeHDtTVasRWMCRNJDE9eZ5Vu+W
Nnt33yERi/jY9DMCq3dNvU6wDcqzu5MLyJPqx8vj8sfl5OVw+tVpjJbwvkPX
0Jpgi6ISjt8Qbk0OTGRYUx6PxKY54+PjJlsv5kbn3Y553rlUXnW9ifvGxfKw
+HTqAgwqALwNGwvhb57XuqSsZXdZK8eTTXiwc+Aov6Cquk5rdcbxjvzC2tY2
u8CUrdL6SstbVVovX0JDi7W8Skko3Ml50e7G+iaDcL/Z1r1tR7mWMms3tVpL
KxQCM3dpRVt1nU5g2t6RX61QOUXydpU0CMzccHNltVpgHt9V3NDYYhbuN1hi
O4vq1LoAI6+ckffE1uLGFhO9Pxc0W7+BswhY5/nnn18RFmFBaHcP3cZrvByU
d/T0WyMjI3ctB4d5n376aSjcDzMjTEosVy4c68yxeN8haVYcnNucff0jp9lY
MDTW4NgpLgpAY78SXgYwkd6SwG/w4DPQ3DAUCVwOp8i+HJwhacyZKoBXwE2V
SKasDILkUHQPmw8L83Lf8FOLMVhA8ZQ7YAHJnLah2F6wCvqo/AyPRgMDfvTR
RwsjlYtQ4K9TU1Pjs8/etn4nj884+eI35/WwUTdiobUzs/smZy9gJIquQ9it
eOhsZZE3rqtxSyEuXqSxXPTZEByLcSjgLkX86g2AU8T/zDIwnErvG0OIiuLI
0uiyvEaUP0GikTSnFZdTSzNV4FJKWh9Zje7B+oAVwZap9HI1RZZ4YO+JyZms
dHvIx9LQR4XVk809eFvj1xecGhwcBDd8qfEVLfbhhx+azP4d3FtnbpvgQypt
oLnVzm6qTpGoKAxA4IadYhhiUxlRWxpN4ke8xXkQKFcDhbaEW1nEpkDRTQEu
iSBLIssL6UgzOuV1lLAp0BjyslgpaBRZUtOFdKQ1BXNr9J21jSbSBtk7C2st
thC38pK2obx3gWM3rJPBNczE5G2CfU5eo8INAzdaaRHkE3s91NM7WFTShAx2
Hv8IrDAyUW+wRDX6wHGSg80yMbARWja/ksaWFuQ6QNSnc7B54KfEXAx08EPQ
8+MmjS6JuA7Y+CwbK2Y1FHJI5fVjI8gsF8OSfBOiSDFbSyZSfB+rIYv48kql
2z/CcXHZewqLGvqSw9J2WwztqVQKVjW3L9pPnHu7sLjl5s2by0Q7jCbtWndn
ZLpV6eruOwzNmem0WJz9Q+PnoMmh4dl8UIolUV4lYkmWz4BnHElHgXmUi5gV
EEMIcJy7EN8snwFFjij6S7WhuaGZmlBEiyK/i7FDsAzJtB5s1Hct1YZ1VZCx
Tq31gw5GS5Abs5eHYhzZBwYGGLTefigennz6yJEj1EqLoJjY68Gx8enqWi2s
4WE1h+6AZB1ICcegoa32hJDxiagxmEN0lQUtZnX0SHkLAuFpKCMd1+WQa7YL
fMSAFad3gBuTsT7chx8DY0IuNWLEaOmiMV2e3IHLqpOVikiFpSeN6MqyOlic
CYGLmHIhpuO596BcgzmCa0AyFwx4O0b9wbGu3gPzR05m3S2Lyvs/y/zaVZrj
S5q7gYj92c9+1tzmTkeXbqdoWnZaXqvKx427Uot+daW2zP3Vr37l8HTDPNjc
anl8Q0EWYUy4e1dxU35hjc7IMSlU1WqVai9HHRCe3LGzyukdRNYBT2Doic0l
4e5ZnoXAYAqV1zAsCdH43sYWy/adlXwUS63z5xdUdYQnKItB32Prdwjftyve
3aQ1hITnOyKTBcX1Fkcii8rbuLlYYD3QGjqLdjeJWBZKyprBhxVYHbbmV3RG
0qwOZnt3YXGDSL/K6vaqOi0v32SLPb6xoKnFim/vc7cVVEEHgEOrPfrLX/5y
AfTex/0tYjSXxjhkeW2yk8nk+OyzZC66zd5OZKfLO3/+PGcKqV0f/nwWffDI
0eMma9Ri72pstsCwA2OZzhSEYxiOYIg32bq0xhho2RmdrWs0ABg5TjnkJdAa
gmVVKrXePz5ziTIbtLTZzfYEz0ugN8Us9kQP1yOJ9op2l0rjGZ5I8UwIyeGn
2tRu7n0J/34ifkCl9Tm9Q/zzbSqvRt/BMSHgeZPCijQIApMCwJlhXtCH9aaw
wLzQorCLuB76hp9q1/oF5gW7Z6it3TMxcxFbY83g2BnANtQZk4Ja2hzweCi6
99ixUxi7+Jw45k4RvxhHJlPDbeY1YGbc0dNvjY+Pcxn3a3i7ZH7tYFELPnTj
xg21ltudAVP50PhTWkMHWQQOk8+W9oxOXQAfAL857fYOUv4CXOegn5rJ2ov+
J5thmcliwL5x5b1Z4neyGaKZDAagGOdRM3FmcH2pG7yIdKgIG2nO5H6QlZ4c
Po5MVGymD8sAAeU8Of9zhzv64Ycfplvgns85IuMIhFwh6Ra+/RAt8IFIR4iV
j8jEon92+szZeN8cTKLQZL6OsWgcptIENL3LPxBNzKn1IYAl+JES0gIaY5BQ
9EpYC0QZlfKsBVKGXgnHryhnVJ6zAFWTRq4xfiflDl5MM2n0Wp4tQlaz+9Ps
wzewQ0gSf1A3GDwSyUNHj53MuneZozvnDcp5hdgXwLeE0T2t2S3fF/KoPPiD
+8HXLtkHFrIg6T0P2ey+Rx/bjh50ZaVq3fodRmsMjguL63cVNwJSU2JWApXG
N7ontQgLr4iVgM2fXIiVIJOFNyWJlrH5kwuxElAdxXFjgTlhZTpK+BdkOSJE
fMOZOpJSbtQ16Mur2shqZfXu8hZ/aBzJzX782DajyfXpp5+uqCcs9p0Q0p45
SEKMetxG/eH8sx9YnP3vv//+8vrDknb8GtixXesBTxl8EOgdRks36AKOtULl
dnMvrk+xmAMINbaYPR0y8V8KO1G2JcXcgkwEbIybgk6Ub0kRJ89EIGJJYOPK
QoR7JbqxcW9ZDghWtwcluqVIELtN7dUYguD8Q8X8wXGl2gNIhbVBu9bNZYdI
W04cdVn9GbOfg7kLew9+7owTfctjPpfKA+sBSnGkkImtLGqxRy49+1xnZKai
Skm26g+jA+8PTVMyM3YjF4ARnWppPBgRBOtDmnWJD8gyDYhi2oib/Yd+SjMv
2V1leIVVhOUnwO1TOcvWgGJXhqOB0eB+VgMMWUMpY9PPoEMDAsamL9bUa72B
sQsXns2wu3zsGvH57rvvgp9C9tbe6vjMQXm4K+V+iTWkkWrEIsyCncHE0MQ5
o7WrXRtAb5slH2tTeXBTLB0YMXkJA79ZNHpstESjlJUAcKBQuqUsASqtl0ao
AQFWR9zt6+efgPZXarwCLwHHY6DyCLwEiD6yK3tZEnlmXn3gFMOcwEq8D7cA
Wx09GIhOO+GcC+0JDMPYOLrnQrRrAAy0PLSRMTTn/PnzVXXGNnXgVucbyIHC
zY5kRY0BFgJLYY3Y5q63337bZA2Wlrf+6MebYTUC40h+QU1ljYbwCNy9ZVvp
4xt3wiH82bS5WEGYBtrU7p88ng/IwL33jS0W8Jg1zN7/2pLSZtFe/nXrdzY0
m/nfFUrHpk3FJIeXnJdXKbdtrxD28j+2Lr+2ieEOAHxt3FQs7P1vUtge31gg
yNueX1FcxsjTGAJwf3ObjZG3uZhyDdwLbvyGjYVYp83bSuubTHAAxf23//bD
uiYTGANMIrWdPLoQg7DoCHUf4FB+S49jnDx3YPz69etZDyyBLGKX1U+nnlHr
vIHQBAYGahtNnZHprFXcEvsel2/QZO2GOQV+c3j6wN/CsUGt9XWExoT1NjKr
eAJD/IodNZXutbc64yQSld6dz71ndSbYrEjpXnu3bxDGEy7igOeALj5SQDMt
qVAq0+MfERgBpDwE8Cy35Z+8rCa634tjGYrFsUxn4reKO9x9Ko0nlbootaQ4
rxJR+Nvf/rZJ4R4YPXOL40ulDfLvc9M+bjp7kljp20PDkxjbrKprx4khFJv2
+IfgIjSv2d6VSB5Gn4Q6N3SffSq9UkUKKkn8M3N/O8v7yuYjSvMWM/a3y7Dm
UhIoyj6LywtpBmUmc24GU8BD6ZirkPvD+mgsq1Vdoz4UnQYxk1P7HvhssZ3E
iDLo1xZHkvPIpK15q6AMfz94/LXe3l4u/v/gEqMYsQu3w7q7Z8zbOQLGbVLY
OyJ7yAj2iMs3IIxg7j6zPcauBXE0AyiyrHupzNij/D5zKeOqJENQkk8ou898
AbZbyronynzPVE+inSi2KrvT/yEmBsqBc2buimTBi/bDIZDklQ/cuHFD2gby
8yyOkteuXRPxYN96CEVOsxNn3x4fH4dRP+uhJRBK7LKWfCoqBC27dXvFhk2F
6Mxs3LRrR34VHIOftW59vsHanSWJ3IEau4rqoelTkow+NjC40N7vTM7TlCRG
yQYGF9r7vRADLY1RsmGaZenIRkBld+KzOq51eAbXPwGeJMeYC17lzoJqDfGA
t24vLylrgQOwK1g3ox3kUYpYvnjxYu/gSaE1bz2U4lsnmCmcvlHus34PL4FS
Ypevv/GLN73+pM4UjibmvJ3D0Hqh2AwAA9Ot/MExTzqKyL5jadf6ZPZm09aX
35st2jFOG18UK6ToFMUKKTZFsUI2CinECik0l6EZRSW7a/xhiWYpEhMMd82q
dX6c3UEFo7WLW/p2DIPVFCpvR3j49X9+I8Pi8nhE1Irfjt66eBTegi6FR2KX
r126dFlnDo/PXALoGa1RAEGs5xCmr5J34c9jo7GvvSlFUYzZVY0t7g9NSXZV
szu608RGT9PYHvvNBTbax8b2KO5obA8x1zt0YhHpVO30e/oHWekYxQPFQD1+
oj7wIgg127stju6x6WdM1q6zZ1MkZrpchIEvBUtg7uu/q26lTKg8qhf86Yzu
vXr16iNLIIsg75GZGS4PpKf/2ODYmcZWa1OLBdZuUDisUCLdXKYx2Lu0ogXz
guC0vtmIzD9KtcftHxR2TpdXq7hVH90JXdugFXZeAyod7t52rV/YOV3fZIol
nhR2aldUt3M7venO6Y7wRG2DQdg5DYteb8coK69dkAcDUUOzeWTqAmYu3Q/6
wfq2vEIBP8yT79wo1V74pav3sMkWq6rRgEAoQ2cKjk9OZ0ktJY8fYq88wE9N
gwUTLTHjMvfLnAWaS/XSGKKzs7PkM7eLoYb0tQcGBkbBvmZb7ImtJdDw0MM7
I1Nbtpdyb4US+x2e/k1bdrdr/HBscSR2FtaQXMfsdl1gV0mjmoulkVzIwqL6
mnpmh3N+QU1jE7NjGUa6gqJ6YUd1db2utLzVaE3vcN5ZVFfToBdyO3cUiHdI
tyidhcX1OmMonftZ2gIoE+RtfGKX3dVHczXXWhzx9U8Ugn7wa6vKDV6Vt4NL
lNpdodi2o8Jsj5us0URiMMNG4jgIQVMueMTuwDjOA6SXfpnnrxzUKzlyOpVK
cfVjd4sSazxy8qlzHn+/1Z5IDBx1egcwRxuGARg+YNx2epOR+D6XX8TSozUE
Q7E9IqZKmBfjySNsJAuaAkoRdhXL7hDu6j3Axs9AZmLgmBA/oxuqhXhZR2SS
zTLLlAtzElSD7i69DzPTuXqkPTwswuqEGh/TmyKh6OTh+ac+/fTTr3622O5N
zN9DdEBfBEN/qZHB6eUNTgEssr6xxMhBav61jz/+eP7oSZi4QUOYeMB8mCnY
3GadmEnhh1Fb2hx7D75EWW0kW3PZjCdpVAr9GHZf72I7c6XxMfRn2PgYu/uZ
jYZJc7VktXkY/RqaacZuv2EJbwBnYImhifNmW/f+A8fAQllfX9aMhOMQYKm+
2T4Nc+2XG0ng4fBfyFgKScQ6jwwPjxP6gMswl5dVtqk1PvBQrI6eplYrLMTG
Zy/pzeHKahX7ReZUJqcijRpJokk0ZiDaPbvkvldJtIvGDETRLhox4EclSVxL
nAO1kIYP0YgBFBzreRJGUyghOfyU3hgCzZGrprxSCdYBFcy2aKJ3EEYnqW3l
kfX1NLJmZmb27H/hS7v6wqgGrP6hPC7b4s+WQNY30t6NwRzUGDq376wCnwNa
xRMY+slj2zlDJ/aDK7xlWxkukVkWwoX2lrLRHzYviEYAlrO3VBShYne/shEq
Yb1P1/CiOBQboGI0/GrmHt8UWd4/9ng+uHjwfLhrBpwhtS4A+tfUabZsLzNY
okZLaHBwTGpReTx9I732Onz4MHgRfLt8+fC0Kl0ezN7c1wW+tQSevsn9df9z
z19xenvMti7oi7B2JVxofdAMuL6l3okoNiO/r5O2lCgbB5G05L5OIY4k2mXK
ElCwq3J2lylFDqvNQ5LdsrQ6+A1zuGK0hMkHkjug4uSTDNFLl16Q2kweMQRX
eeBXQMtB/8VhEY7zvshIWU3lpEjI2u4e4vZ0fXsJlJC63vf6P79hdYRGpy5Y
HN2ejmHcb4uZJdQNcfqGaTQlvZ8yTqMp2B6wvqE5MtAM3sDIIvsp+diOzdVH
93FSPh0hj8bpHRL2cZ5K76BOy32A7jjt7jvMKgw4wN2r3s4Rf3Csu+8IVBCq
KbWHPAIITnKhl+nN3TCtgX+kNcUImUZWdjRx0EWoAQlpDPnCK1wSztvUAfiX
5PKQ897Bk2ZnMv07xz2B5UCJUK5wHwoRypHKgUKgqAXl5FE5oa4nJycnb968
+edLtD2pZd4vfvELb4CLaEUTc5u2lLQoXYQfI7e0XAH/wh+l2lewq444mtxe
3Mlt+ZWtKj9/bnEmt2wrTQ6f5LXyBEYbms1CrcZnLinavR3Raf73vuGn6huN
iYHjtJZz1fV6oVZ6UxQ0IN9SJ+WDCbbsKA/HD/C/w1IJ1sNu/zDJh8taU1Gj
Ri2bWu2btu6G4kBiR6iPexshrb94rUx+zbl+/XqL0gdDKtj+C92+uZwcey94
qv39/dxb2T//TPzun9Rn7Y0bN7rjAw1N5qKSpnYdbrgaqW8ywgEYxursKa9W
Ob3DWCa3ti6rUinVXmgWvAIGLC5r4ajNg3uwBRyeodoGg0Lp5lu8Td1RVtGm
1of486KSlupajds/xp/v2FlV22gSWhBGCZAJ5fIyQVRFdXtVrQZqT+5Ya7TG
txdU1TUa/aEpuLCzoMZDKCu0xtDWHWUAP6gR1IvWWH51i+0JfuPBgwfrGq1n
nnnviz2zj88+W1lj4DzD7y7RT0lN7z12/JTR3DEy9XRLmw0JTHFE7YzOwgCJ
8ybra7E8E+xuCJi+J2YuslkdOHuzWR0wdfePnGQjHTBtw/TARjoE5lca2QA9
WNYgyqOa6D+OKcDk+r34GLu3D8oC7RuajaN7LhgtwaNHj0ttIj9O/wU5f+65
56CyQrblF6/Fs9N6TE1NvfXWW1l/uUSLk3p9+8033+zugTm1h5sTDR3YHHSp
hi0u8Y7wJSEYXrKJSrLCpGtJUTYFOmzSeAU6bNJ4Bc6yDA/ZN6liCAEJLTSm
3Z5KU5elxJvftByV82ggPBnoTLz++usZ9pFvfYKRHJjo9u/fH4nPQY9f9UVq
/9VUDnpkTt/ouXPnMtpaek5qdddHH3107twzDnfiRz/ejIufdo0vv6CaRLPv
VrS7dpe3sqspdFJbFDa9OSzZHcUusUQ7j9g8BRpFkEQXaBRBEl2gcQSWm+s+
igH4YzBHmhX2UwwzPsqvqFbX1GvJvqa7nthSjJvG9ObQjx/dCtWFSkPV/2pZ
7U/u4r5sYrL1YvHYInl/ylbPQzkARvhhfHwcnPB/tUSLk3p87YUXXqiuaQ53
zc7OvQyLlyaFzerogUkfGhQ8JlxSUztC++iMQZXOyzI+SfYNid7j07YW8Vqx
K352Zc+u+OnK/pu06wppUCf/Wan1giZYBFUPtNWZQqA5lMi9j6vXu3z9c0df
gdrV1iugpllSm8i3MLEU9z7j6NGj4KMNjJ3lGI//pO3LpZcTtoXey5cv//US
LUvOuV0KMKO165wwlFc3aFuVzvLqduKZDeMgjnbDnTQw70Z7DrIcSKIdM2BE
+m4c25TlcqLtKVpl09ZMr7K/zga3cWQGmXTGR3VwSQ1Fd0RnQd/mViu4fVZX
j97knz9yjNt/+L1ltSG5K+eNN95IJBJKTeeJs2//qUZltNrM3EtFuxWnT58G
WP3PS7Qf0f3hX//616Pje2BwcniTyeHjDnc/mBdnYIXKGwhP474TTK/FCVlH
AqHC/hK7q0fYLQLtptWHBD4jbLV2bYCug7HFSCY+d/5VfGPl7RjGOZSdqDWG
MPjzuPSFi1AwqOj0JU228NT0vl/96lfSOsq3ErmLWw2pdeEWpTcQmsn+E707
XkUegoJq6s1zc3Pvvvvuv16ilYjuueA37N1/ONK9R6Xxb9i0i+f52ba9bOuO
imh8LyBdbwo3tdrgsskWe2Jzsd3Th7w5Lu/A5q2lAu9Oi9JRuKtOeJdrdSY2
bdld32Ti390aLNEfP7qZsmvnwFC9bv3OzsgUF4+FH8krXRCZX1BTWFxP9Mjd
kl+h0vi6evZOTD0JfSFLWifx2vR/4c5Wg7cAfcbmHhyZugBowjSLrLw/ZO7H
asz9OHT8NSgB2mR6evrVV18l+rBrTaLfA4AWtzugUNriyUPIX+/yDjl9XApW
OeHOhxJhxK9r0Nucia7ew5ySWbnDEyllu1uj7+D5YcjVnIHRM+AVaA0hmC6I
pjlwUAPzhnewp/8YYdTJxcwM0oSJfYeuIc/OA5ifYXbEYbqBolz+0Xad30kU
cXoHm9scoBqZg9R+f+TatWvpusivIv+WYAlqNjMzA4sKq2tA2K/yBxqhcjui
ez2dk7BOhlnu/fffz/pfl8A70fE777333tj4lN0VMVi6SYr/TIvSyX66jk3N
R/cQxhSSxTTAuoRshhVGT4kP8B36vWiapc96h/SL11hTNuGKTbQHJ99s4963
Gi1xuys6Ojr1zjvvSOsnPyKRu3Kh+8/Ozrbrw2BB4W3Q778l6MoZ5na7eygc
Dl+6dAlmiP9tibYgWn77ww8/vPDMxVjXkM0Z9Ycm2lSeQGiC/a47Bkyn9r2A
qzP2E8rQEHADm2SZIuHLVdAAWd9mP1yPxh+ffobNsqQtOE/mcZpnia65UuMF
LxJUCgSHOkM9T6cuwHJJWid5+/8dGYOgwxw+fBiwCQsssP/5Zz/gts/l/S5W
vwutDo7A2PRF8DWgcJiNARf/bglbE42+DjeeP//Mhid2FhbXcXvTyKa5ZoUN
jrmP2T66uZl8fxfGmJ+s2wZDARxX1ah/8vgOGCXguLpWs2VrGX7991vbdpQX
lTThDrdt+RWV1e1cUrg+8JN1Oypq1CRBPLBxUxE+2aSwPvqTbe1aHxw3tJi3
bi/HbYDllYr1T+SDTlyOr7QOwl507qKURUaOXYOUwH1jBxY2YPp2XaisSgOo
PHj8tc+NduIHroY1CZjeE5iob7IPDg6eOHGC26P2HyXyv7pSXf/u448/hskX
DNAVH1a022Bc33/oZbpHbWrf8+COWB1xwOjg+DmnJ+kJcFnNs3NXAJ246wtQ
rjOFLfYewDzu2oX+0zd0DG7Tm0Iw6CPHEsygAHGwRSA0ism/IAjEgdBI1yAo
AGqAMv9Btg2kO8gIg6CI30G63/0/kYehGQCeU1NT0BKwBoEVGfQDWf5+if3v
hpNAmKMXALRD94FhRWOM7t+//8KFC2+++eZ/lkiTZgIuU7+/eeutt1588cVw
pDfWPQy++eDYmSc2FbeoHKUVCoXKubu8FbwHGA/Auwefp1XlLKtQ1NRpaxv1
6OYXFNYWFTeWlrUo2t35hTUDo9y8ATrncx+KthWWNIDRC4pqoFiDqSMcGwRB
IA6ESvX/vFb+L+ThTz75BNyiixcvAuSHhoZ2V7TDCgvMTTxC8toWdOrqnYc/
Wau4z9ysRqceMA1nFkc/NAo3U5N77wJrw7PQYFAOTOTgSEErQvf8r7+zzf8P
7q/vwqIeFrGjo5ODQxMeX5fDFe0Ij5ltMYcnqTGGFGqX2zeo0QV8neOD42dx
Mw8AvVXphovwEyy2jNYucIFcvqRa67E6Qg5XaGR0z4mTT0GxYFupniuxLXfD
/01+Bl8CbMpxda/ikqQ4rosB8l/WKjgEX8/v37i5dFt+DYA7EomArwcOCH8v
2Aue5fbW/F9QFidEmhe0hPS7YE4Ei1+5cgVaFGo1PbO/Lznq9QVXHZ4/lXWv
zx+xOUKh6ODUnifd3o6+/rEzZ1I44sEjYAJ4PC35npUgS3RFGmWQxhWlcSby
ey49x0KWWfPfTfJfZZTw+Wst/ZLYUrw10vPb7X78ptrvo9WlrHHLkvwFtswf
5X4Z1Kf3Ned9JjCQRbMw31fuOj7FFWFYxlHWV/5/TGD5cQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206294699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220867079],

Cell["Use 10 mesh lines in each direction:", "ExampleText",
 CellID->29115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8804],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294833587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33173284],

Cell[TextData[{
 "Use 3 mesh lines in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and 6 mesh lines in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->259883373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "6"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1693928656],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47894031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30067522],

Cell["Use mesh lines at specific values:", "ExampleText",
 CellID->218881433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->924338650],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46716942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->328961131],

Cell["Use different styles for different mesh lines:", "ExampleText",
 CellID->81763859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ",", "Red"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "Red"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "Dashed"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2134156344],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22593134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3895313],

Cell["Mesh lines apply to the whole region, not each component:", \
"ExampleText",
 CellID->612905462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192426763],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->438305166]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->101853424],

Cell[TextData[{
 "Mesh lines in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->840154786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#2", "&"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1058008473],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXQlsHcd5XvEdJCU7ca2jchQddkzHR+oaztEkDdKgKNIWSIoiKIogKNoK
rhvbcSzHsqPa1mGdNEWKpmTd1hGGMk3qokQ5kkWTlcXUqiTToaNC8hHBsgkI
qGMXcgkJBQEDr98//87Ovv/NezuPh7jblCAfd/fN8X/f/PP//+zOznx37qP3
3fvjuY/ef8/cOX/+yNyH77v/nvlzvj3vEVxKTfC8Ccs8z9s/3cNxDkfqj36W
448PXY5m4TOFrBV0ltJl5LwKHM7AAf1Phb7zKC3+ft/ynUu+GSXqq4mRLJNU
utniG1VK2px73g0FVypFnskFKdLDKOWGSElqEiTrRPVvOj7TlnYrTD/ZT1kR
GwSzEiw7sz87Ml189CV5uj0cdjM5tlXThiWpzv3ZMWHzask2MvbCeaYOW9Jw
KTPGjM3xkJXZneW3Rtb/r31kZc60canvPyO+rxnl8tj3ksjlxTKfyhX351T2
Vvyf6pCG6/90JJuZgiufEnnSEeeyBaPSXzPO36vzTHDOoNkmjDJToyJpGUyP
CnN5CFmLqnKucUIhR99SV65cuXLx4sX3338fn+m+vj5VSp/68SroI33mzJkg
hbSw0jpdOwJ5bhZ5lEXKfPLJJxf1DyTxqkimTH9/f3AVKQpsk5SrOufe5yjB
H9PpxMHBwYGBAVR49OjRjo6OLVu2tLS0PLVi62OPNzY+u7e6pf2EN2nHrldw
/M8PLMQnEuzcubOzs7O3t5clHBoaUmWlnPU4qD3DLYPau7u7UaZXsW3bthRq
8VKoE3VT9Vn6SDe3/hLX+ZdSeRmkP3bsGPKiBJQTyFCW7Qml+CNFIotz+PBh
1LGyrnndpgOovvPoW13HB6Ar//E/XuoXL/+mdc8pOpxEH9c+s34f/uP333/1
30d63t1zsJ9lBU2tra0Q8dy5c5cuXfK+JuqbMjwJUx999BGUBIR5FWgqL4Oq
IOKBw2dR+elfX/auJ6km4gjn+188g+8oRUsL5EEbIysKkLKUozvhFF+kjypo
wNtvv/38889v2LCBpQFHEKDSxlcq4MvL0kdl78nfQsznmrtrG3Y1NjZ2dXVB
Ib2vjJgtlg0958KFC2gFMLC68QWoFZj6t9f+axbVXYUmQ9viIr4CP0h2/vx5
ZPmylR+yuGEvmxWp7qKPSrCBFkdfQoFbdhwF3ENH3/KxF+dioiJk846XIAyU
DnnRwiDii6KOyU4yAAJaBM0NLV6/5RD4BWTvFsU3MON84zbScKRgwN7dVsSz
xNU7Va+FWBAOIqLRTL8AMMALsERhrQbQnl9e5H6DNgFodJcTJ05QX7lL1Ps5
qxwffPABNyxoRjN6d1K5GRwBHK7CQiFFQVl2ZHeoEtF26CCQA9JAJi8zHGSp
AJmXUhJBw9v2vwb1hlmBMrL0JdB9QcmCBoQSNazdjdYCRd7dqiwcwcLgant7
O1IUlGVHd1vOt7bgF+ggIGTyKkeITvXfNNJDxVicL0Qgu02zDNcBOdBupD9f
VciOnfhPnKPd8B35lDuKIiO9v1WXdOjQIZQEfomj6hEiqlKIWBLo9+uvv071
kBA1efWix7CewNQTk99QCNDHcI6r8CDUp27NhaNx2SY1uiTm4qdPNJL1njRC
BOo8vfdg/8KnNu7duxfu7NaINrmFPtIwA6wYoPFbqgwcwJLjIr6SZdi17GZt
HZgYFAA5vWtGA1GW0+MSHAy6EYzELRG4lDRpWAD0IhgENM6fKVw4wCm4wVey
DDuum1RJqBIVwzCggAqrzCPEWBWkxy+OISIrkowaJVKWD30BvRuWAV3qLxRS
FI5TmEF8JcuwI71RnUMh4Q8hgZceC5yh9IrHNPQemsYtIrHJc5YQOgaDg07v
fUeVCJMInSN7KNPbcc7WLQrdgKZCgMwYI01ry4IWOXXqFFr1xgikLOPly5f3
799f29Dyi+7f/BXK9tIvHbvQuG5PW1vbxx9/LMuwo+VzdGNWDt/ujx3WrC4P
TUrefE4EUpYPjY/BRd2a573voWgvtWbtbkQoMGAF+fM9wUyt/YgF0LFhdarG
GB/zh7YEPtI5kiDsIxgP+i74prjrb1R6HMF20dBOS273CzzOA28Y4MD1+7WP
HRpmC10APg8GpEAe2VosH/hGDEhDs++r/DhCMEl+e6aTTn5Gnb/33ntPLF5P
am2XevRQ8vkL+05t3LiRpJSjfImS5cPoGBaCIsEfqPyILXFOOi3z21HeoHve
8qd3Pvezl31fOMYoycPV1u+CoBBf3jWQOFlCDAmRHBrt/Z3WbZxT9Czz23FO
V30QfgMd8OXjAxDwqiDNsC9naYHBb7XiaJWcKcTgfs/8e1UqTAZ6Jo06ZX47
WnpaiqFBXx9cBwqAhGSwrgriLCPGIQ5gICC0fJ4iMStpU7BTiNIpwvxH3d8R
ypD1kvntmNWdnSw8Fzo6C8ywrwrqygB1nxouAgm11vQI5NM0clg2KuYeVTZO
cMkwE4VcPVlIwTIycn+0y+iLIxptyxUw4NeP9vNZkCgkC1MFC/cKFuQ9u3zv
yrmh6z761DijTwn0U3P5T1Ak2h8KtFNypXzvZIE2Pc5o09o+oauTfZsa0dYs
P/yNn/9+C/pojb9ecJgZZxYymgXEW3BpBSgkCyw/vBesOlm8B4TOuLHwe+oc
6X27mR1nFrh+9nUUwUyOYIHlB18Yy9G9kQc1i34EI/PbWbgu58cH4JJKqRxn
FoJ7yhiLm7YuzgLLD77q6+tX1bd4D9EtidTTDbvq6uqIRZnfzsKndSl+lFQ1
zixw/Rj/wi2Zto5iAQE6AljKOk/lP9LzLuyKLX8pFkC8j2q8WagW1u26CBZY
fsQwfnk/ESzK/PmekHOfOXPGR1sdC/SwTP4oWz+7r8mTF+NnGnUi6XyVHsYM
4S99pZ9m2D3hteoc47P6pnayfhPHGS2fdx0faGtro3ur8lmVbGuW/8qVK2CH
Iv1HdXk4p6eFMr9d4/mZNepraGho7/iVj2L8WOD8S1du6+rq0m0YzYLpsY8J
6ynzl2IB/aa2voXuCsaDBaRftmo7jVGjWGD5TTyzQNiNa51YUP2E7idj7MjY
YsFDGukPHnkTag01lUgkE5NEr/gXVSL8ent7O/UKOxPaUthmAMvnj8wSigeG
mLGE9Biw9/f3S5STy8WX6u7uPnD4LBX8uKoNbhXO1eiaZFDVWHJWpJxNouaZ
ZQJvw/TEo+dlOD28ArSG4nGJ+frhoQ35qidVves2HUD4bViXrOqZQfzoP1Sd
tT46Vfmy0PSVdc2QPyA2Trz2qYc/MNBK2rTvyYeBk/wWOiLFqwtVfb0nf4sW
I+9ZnQvPlSlfO5lHhE0InhhyjHjMBunxy/GO1J/yNZQZNdHfIlUz2xOjwdH9
Xs/jlXalSp1jnIXRGhVtn1MRJ2ZxAO2KZrY0Ymhja2sr+aLFqkb0SpyTLyqH
0XA6ec71mLFPLJkNpWf5nmvuPnfunNG8KIajGTh06BCEpCdKS+iDJMYlWw35
Xl/PMZalVgqNTSWCV3wP/dI20BYFlMYLzVy8dPPezje8pxSLONq+fTvpq51F
GUVWCm2MO2ssnxk1Vgk8MsJkfIFn8Jaq/GaMLfPbWcoK3UongiW2iC4sZYXt
WyZsXzks9fb27jnYnwSW0kKXpM+1s2R87nJdHi7Z8uffr8nq/sqxXpG5fHFj
x4zN5bshjBYKgjDOsGHsWf67H1JXMoLLuLPB8qHpMMAwulBcVxgfhgsYNFDW
lULXZH57j8oIjpPBEj2s6utzZ8mMXpklM3p1Y4nf3OA7IVRANhEsoUnRsC4s
Mb6hoaFltTvIcqwS1rkclox1jjtLLB8G4BiGG12JYglBKkJVylorrLPMb2eJ
x1mwX0tWbCWu7XOS48YSQr9jx465s9TR0dF1fMCwZCKFclgy1i0ZLNEM4pYW
8k1RLDE+9C30OMpap/LXNuy6dOmSYbGYp5c9Le7sVIqeRm9Shp/cMB5zv5rZ
MPcaUrlSnp65ND4sGWyYEYJsa7uu7Nu3r23fazRzsI4+Uu0dr+/evbu0roSv
8turxodVJYIl48OiWKrQdvVH85Zt/3mPV6/m1K5atQpuzbDoxpKZDxN3llg+
EzVKlHaWECIiUKSs9Sq/iRrLYUk+F487S+b5lxtLZkxfL3psOSzt3LkTbiE5
LBlP78ZSZ2fnkZ53DUvG05dgKRtcxQ/f9bCjjRs7xh5Z2akM4zIx3hqVF5rg
2yK5kgAzQxaOvNx0/z+nMvGm/V2v+DBULVCGPTxjMfe3FCPp4HlXzsQBwZ3I
AoanF2gO99C4aw7zkh/9FGhOHi5u80Zdjj++kPmkR6xwZI17bDJYK46+kDXW
hkZhxUaLNbbjyWANwwIMDtxYYy/eKGz3CFgza33w8MaXMe6cYbiKQasbZxjk
0ctNKh+UAqoxapxxgJ4QzvA9qLBhlyhn5qOEa1y0dJPXRKVkoCPQFD+h5bmp
E288eIw9b+r7TOAjfcT6ifGsfEzsLn2WoBXQjeGwRCWrL3hYkwyOQvdCbM/S
PxvGxcMZ5ik0lrHlY5aktt6QzztPmE0GT5kgrgjpRfCWqMH0xhtvYGDsNdFs
8My8+bWnT582eeRzpQl8PcX/6HNGfmnwrfQwOBkMBRrho63Jx8KPiPxeFjxZ
8NPSc8kJ+E+MTHDRHXanCWEmGBHbmfHtBTMTxBQldSbCSnPomRB2gtjTzg7f
fvXZCeLNUC+Mts7VueKr0GYSzJzsRdPccfqWZSSsqrkEESsjilXp2tvbadZg
Mtl1WQlS4M1jOXgCP9Ys8y3631GWg3ePxoTllIqFzDOQuI9T+XvmmESvKINh
xmqe6T+jymJ+dVn/r8PJ0+H/K95upCyPLJbQ8X+S44fgyW8uP34ogm0Y7IXv
tSeVpYjo3R/F2lnJv9Mu7jskanSHL8+fP1+UhbwxjOypk2zo/bg+Gejl6F+g
Ry9a8GST10QD3MyipZteffVVG/pk3iFa3fgCLRHhe/yaMI4333yzcd0er0nN
lKhvanvnnXdyufAuHaLN+YFLMnAX3C8Vbe7fQW6y6ocVPU+zij16vudc/H77
5/JR+U8fmIfgbmIpHgYHB1fWNSeEh+LPagqfVyxZsZXWplRMbNmyJbgumMjL
A2tx+teX4z6OYC4wEMBwwI0LnpnIz24w5sfI35av2FwFfs83GayY+XPRrLDT
Y1bM7GhXVjhgSAYroecDkazwrWFmxcw5L86KmekgV82IOSvpYAZZLv8dDEZj
5uHyvI3wHfWKEjaE32+Ou17wzB7jV6wze/JwDQ0NwaSyXpi5dyV6S5F5QXHX
jSphD9xmhLGNpKw8I6z4nKlS8+ZMKcmYN5c/WzmaJTN7m1kyPqwclswcxWSw
ZGZBubFk5oTX6/L8+UDlsGTsV9xZ4lnPsA2wRfQegdusZxigxUs302CnXo14
lq3agZFRuSwZu5QMlkyPcZtBv2bNmvVbX6ShcB19pDY9d3j16tW2/KXeSTGz
npPxnoGZ9ezGklktjN/CKP6egu2dFNNfk8EOFD40J7fwnRTzvkSdxX5FvZNi
3u+JOxtZnd5/F9ftLS+AQ5GUtVaX788Hc3vLKy16VDLeGAzuODqyZHpUrZYX
P+WyZN7ZiDtL/Pap8WFub5/yzRfDEt/dK5cl1AelpHU7k8GSmafs9iazea9y
pcbj3wUq531vE3sm433vYO6jI0tm9M0smbVlymHJvK0Qd5Z4JQVzNytqnYmM
7it+vLdC91j0HVojtvQ6E5VCE5OxCseOvPe0w55eruCyXPRMnd7u6bPCOsed
jZT+3l9Fw23lFrOqyHJhnYvrSvgqpzJj+mSsAmR0xm0VILPKEa8CZO6cuK1v
w6WY1czjzlKwMj90w7YilJ0lY1eXCl1yY6lK6FIy1jcz46golhhfc3PzomWb
abr2EvpI4QSXbPnNXpbF1vS0r49mbFYsGawM0vepzT+gJrZV8qaUjfvSpUso
i2zZEqF/xdeFK712ovXObzbwkH3xXS2SLZxc07Bw33snxCEfyqtFGh9qX9vQ
jVk6ZUYDyxFXRnmLLLhVvd5o4VywkgjJz9Y27KLxy0KLbTVRSPk6yevr8pO6
vliur9unFy8tWF+3fH1kfTPjgCdVveYZnn193UJW9ZtZ0pIwm2gX6CPFUjFi
01/5mWMP28rPbgiZIeNled3nQMGLrPtsZ7BwnC7qSfMEnBj1aWLx5eMD6IyD
g4NuLEaiDN1NZDbN3UQ7m9qn6xU67TvMd3Z2btjyYmz0j9I/s2E/WrRgnfop
TniMF1mgyjNvM7utW8+lwMs/PP9psxP1eLOyZu3utrY2Es1t9X70MSgfzTX/
qcpv1rJ228OAuXrllVf8GG+8Yzo+h2d7fNGzH374oeN+FmaF9MdEj3FjgVOZ
cVl1LFgwc1CiWGD5zXpE84UfK76rh9kRZWhoCF6KNGm80XP9ZiSk7Zu+E3Od
tmf+ijK8X43ZtUent9+JYbSIEWFjzVPM8UPL9WMIAOmp30btWSRb62Fdnj/y
cduziDk09xDisX8V8CBusO0/Zd+5Ca04f0EDreP1kHpWi6PHHm+kvU/c9q9i
rvr7+3nHypjsZQathG7SpGW3vczOnj1b19hKj/R/rGcy+/ej3FjgVEHMP+77
2mWF9YtigeU3UfyPhPVz29GNS0EPhBugKGm8WeD6i+9RaN/j0ERF96v8Zmzt
trvfZM0CNJCUKR47PZq2jNrpcYrQ5R/q8v0n1jK/bVdP2B8EEKorjTP6lEBP
6MLPJKYJtPfq8qDD5Et0ersnlGjjsYOrQeu2gytwdnd305tI/yTQu+1jyzv4
Mgt8I67n6u3ga/Ytxi8t4NbX57ZvsWnzubqfQ8MJtdz9t9RezUCNqOPA4bM9
V3GvZn93ang5fNL4z213aiD2vfQ/aD3xLZvbTs28Fzdry6ZtR65WC9Ou489u
7ly36QCCLbddx3m/cIpNeddxZopegXbbdZz5PH78+IKFa6mUq9OPX/rXC/c9
uBjDLsc95EGHv9v4D7QdwDmuOu4hPyNUCq3KMHGMUQbvkHR0dFCcPTMCJcvH
96JhV7zvq/w48l9Ik/nzPdFMnRvoyLZVjzE6FX+noS0wQvhBN5mZyx91sURA
DvzI5P2tliDER/FRl8qdhr1Bn0VMgwF+5Rgjyob4JiszJ6K9WGLezfGFfae9
76l9bHDUsLYdVwvy27VytjpHyFbbsIuiyOwYo8yEWoF2O70xAuVs3WswbqLV
sP5aocQRzoklmd+OUnGRRqvD53BrpscYZxCJoT9Qa0hc8nxOSN9gezGw/I7S
cBzgFBfx1U1OWG/SLbqyrlmRNRZIq4L0+AWd+BoDYQxkb47AqaRLDwzQLWh4
RHTgv9TytLe3067esgQ7Sn57hfkKAiEIfc1ooMsG6TE2AY0Yqt0SgUudk7eG
2wO0zqNvfVu1Hw5wCg3AVzVOyFSqNPwSegj0/OmGXaOCidbDadrYAWEw5KI7
Fp+PQMRyDA4OIjoFw0d63v1ThYh1GhfRfWUZdkQqVRqD4wfnLUfv6yn2pqE7
In67C9q9dOW2lpYWSHJbBJrPa1YRPzKab6oycID+xbory8j3cLerEtCvkBjt
goz29wncUShbm0EXABBoGTSZ/OztuXw/dntIcrgGOPSva80CEFxEp9F57L7s
DvrIgH8kRvtDpymKsc/+c5deWdAMIhl44GW1OyA97SH6BxHtwLIAJ5w2ciFC
pnuCX1Jl4QgmAUxAuSguk2XZtUulykAFoNcoEZEnKCoyxygC3UQxNwNMgXHY
JXgadJk/jMCmJKFdSREQAwVaBw0L43inamwc4BQXW1tbYSRAlizPju8u+qiE
B2TG0IGAb9fuE+bJWAQqmnHy4tG39xzsh9qiBPBEenZ3BBpVbxbtgJYFGvAK
8UHKrSE0uMiKi2SyPPOsjy7KJ9m2Z7OqhErwh04GsA889NSq+p+jDSgarY5A
qqKzSkiFJFCqh36ycvv27b29vfTc/cuininlylSFxkcDACfog/GDlqL7o+Pe
qGrFMa7g+pIVW5EGKcm+fsnKh9ybXs3vKVxDJ5RCSV8N9wEoaDp4hUVLN0GN
gBKKQNykI7hR9ymqwQ0ERRJoELQasiIYgqaSLnxV1CnvOkVL+RUlJYwoVBtm
BiKCDygelISp8qYpKXCEc+givgOIJ5asR2rkoXvgUorhMvY1+pgExqCVAAhV
AmmoifskKoYfXFHXrBZ+UjEaxzDqkYyXAamPLKhHg4InJPcqwBSsbWcnnDgU
E3R9Y8RsfV1pFTAjsoDGMGHQLdQHa1pBi5XQLEvIo0RUHxCSyfMq1GI+kBPp
8Etrqj+7F7lRBkqC0qNUsp9SznL4pAR/QqcZGCoUhiJPnjzZ09PjZWg9MppB
AUaJGnqw5WVBMqw2GhIUITk6wDdzvNuxvKsVUR+N2FAAxfYVdAtBPeVUP1xT
CtUyUK9C19ynfpAFGZFd1zypHP3JuyJjUDnKkJG4+t6suMGFOCIfWc03FZQw
fNTyLYKo2R/y/HctvVjtLDf8VpfzvpxqjjEzVyW9Rev1k/TwimpbPftKa1uD
XFTEcocjb8L/ArhDeo8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->397016987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338261583],

Cell["Mesh lines at fixed radii from the origin:", "ExampleText",
 CellID->11297412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"{", 
        RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "&"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1540985159],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175257965]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5686125],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove regions:"
}], "ExampleText",
 CellID->719452713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "8"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "-", "#2"}], "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1508814781],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138039833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143632515],

Cell["Lay a checkerboard pattern over a region:", "ExampleText",
 CellID->1567949747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Yellow"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Orange"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->759565492],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313910497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191789526],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has a higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->212237415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Green"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", "Automatic"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891467532],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364672452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->756505851],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has a higher priority than ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->550332952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1888102640],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11303943]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->98687283],

Cell["Use red mesh lines:", "ExampleText",
 CellID->105515030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799591503],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203832378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112690618],

Cell[TextData[{
 "Use red mesh lines in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and dashed mesh lines in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->831074307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Dashed"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721166018],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309711126]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PerformanceGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9418863],

Cell["Generate a higher-quality plot:", "ExampleText",
 CellID->120622978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], 
      RowBox[{"Sin", "[", "y", "]"}]}], ">", "0.1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1175154389],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159785484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28545372],

Cell["Emphasize performance, possibly at the cost of quality:", "ExampleText",
 CellID->898163183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], 
      RowBox[{"Sin", "[", "y", "]"}]}], ">", "0.1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119816638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01825500000001057`", ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1VE1IVGEU1Yma8fU32qbFw35WQVEEMVqJ72uRgxtrppyMFkKgEJTyWqqV
TgYRTIEE/VBEi/7eMmqhI7yPBp4iBWJEQ7mJIZjMaHICayyn8s65wZVZDJfz
uN+5955z72w52R3t8FVUVAz9/f2Ljw90Py8WN2jET29rj9jmesYvYxd2mWMf
LOA9PivsOAXGAzva92fqV6lyPDKCDxh8wOADjhPmGKJ8F3iS+Bhn6Z0CLvWj
yvHICD5g8AGDr1wfkkdG8AGDT+BlOgHLCP2AoV8536TukkdG8JXzXfom+5A8
MkrfpO5SNxmhXznfpW9Sd8kj43TwftKbr+K9HrwUGfEiBu/z4uzOV4nMKOsy
05R/7dkp1jl2S5+2GwJ8H4enZ87Ys34l7wK8yENdzHPtobE3k/4f5R4P/lg4
5EQDvIf5ex+jzhU/740y+t4knhj6cmQh2No6xXsLf35ta+u0v1exj996ms/V
d61mX6LUt/5K35fp3EZzavSBvq76Ux22OcJ3UaA67Av6RN9rb256UGwf53tp
pL7ZN+gFnaEXfEBfmBNzQwfZF77/vrFUl6O8iy7K5z3uJ34L+hSoH3eO5pH3
p2q/LPXnQmfJCxwn/fhu4IOsC1zaByXvEXsGfbCH0Ac+wld5f/BJ+oC5MCfm
xns5h+yT75T2naO8w3e0/7xXUkeZB3x+vDfpVRp6bvjuKedstR6aDxnmWNLK
9cTc4rFqjb4evd+83czXcB7e1Z3Y7SVSi+6K4+nC0YMBHbze0OJMZN2p3nUp
76dfN06sDGc25i3kx2uedTr7fCreZATNOkOXeBXuADzgzbYMD9h3Xrijn2+H
Mzmf7qd3qsSjUQd1n1L/brO3NZe4mHf7qK5S1IeLuTAneFEH78ATJmyJfJWm
fOikkI85MTfegWeS+lVrqF8LOkAX8KJOJemhQqSHBR/gC3SALpgTc6MO6oIH
vCU/FfLhA3zBXJgTeXgn/4f+AAUlYeQ=
     "], {{
       {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{7, 1, 2}, {14, 20, 19}, {114, 61, 12}, {115, 62, 13}, {
           84, 86, 30}, {72, 121, 19}, {90, 136, 35}, {54, 111, 8}, {12, 18, 
           17}, {70, 119, 16}, {11, 17, 16}, {118, 69, 15}, {140, 100, 38}, {
           141, 102, 39}, {76, 79, 27}, {17, 23, 22}, {40, 34, 35}, {73, 122, 
           21}, {137, 95, 36}, {78, 73, 21}, {85, 75, 24}, {39, 33, 34}, {18, 
           12, 13}, {10, 4, 5}, {51, 110, 2}, {9, 3, 4}, {88, 134, 32}, {55, 
           112, 5}, {17, 11, 12}, {63, 54, 8}, {16, 22, 21}, {22, 16, 17}, {
           71, 123, 18}, {32, 26, 27}, {79, 131, 27}, {37, 31, 32}, {25, 19, 
           20}, {86, 133, 30}, {23, 17, 18}, {35, 29, 30}, {34, 28, 29}, {20, 
           14, 15}, {139, 99, 43}, {75, 124, 24}, {109, 145, 49}, {42, 48, 
           47}, {41, 47, 46}, {31, 37, 36}, {92, 135, 38}, {48, 42, 43}, {89, 
           132, 33}, {29, 35, 34}, {50, 44, 45}, {126, 78, 21}, {44, 50, 
           49}, {3, 9, 8}, {1, 7, 6}, {113, 58, 6}, {28, 34, 33}, {101, 144, 
           43}, {117, 65, 9}, {116, 63, 8}, {127, 80, 22}, {4, 10, 9}, {138, 
           98, 42}, {130, 85, 24}, {64, 120, 13}, {33, 39, 38}, {128, 83, 
           29}, {125, 76, 27}, {129, 84, 30}, {142, 106, 45}, {47, 41, 42}, {
           19, 25, 24}, {26, 32, 31}, {107, 143, 46}, {34, 40, 39}, {100, 92, 
           38}, {99, 101, 43}, {62, 64, 13}}], 
          PolygonBox[{{143, 97, 41, 46}, {77, 125, 27, 26}, {67, 118, 15, 
           14}, {103, 141, 39, 40}, {59, 114, 12, 11}, {94, 137, 36, 37}, {
           102, 140, 38, 39}, {61, 115, 13, 12}, {83, 129, 30, 29}, {66, 117, 
           9, 10}, {131, 88, 32, 27}, {134, 91, 37, 32}, {124, 72, 19, 24}, {
           132, 82, 28, 33}, {135, 89, 33, 38}, {98, 139, 43, 42}, {91, 96, 
           41, 37}, {104, 142, 45, 44}, {123, 74, 23, 18}, {112, 56, 10, 5}, {
           110, 52, 7, 2}, {60, 57, 7, 11}, {68, 66, 10, 14}, {120, 71, 18, 
           13}, {96, 138, 42, 41}, {65, 116, 8, 9}, {122, 70, 16, 21}, {121, 
           68, 14, 19}, {81, 128, 29, 28}, {146, 127, 22, 23}, {80, 126, 21, 
           22}, {87, 130, 24, 25}, {57, 113, 6, 7}, {52, 59, 11, 7}, {93, 104,
            44, 40}, {144, 108, 48, 43}, {111, 53, 3, 8}, {119, 60, 11, 16}, {
           97, 94, 37, 41}, {136, 93, 40, 35}, {133, 90, 35, 30}, {105, 103, 
           40, 44}, {56, 67, 14, 10}, {145, 105, 44, 49}}]}]}, {}, {}, {}}, 
      {GrayLevel[0], Opacity[0.4], 
       LineBox[{2, 1, 6, 58, 113, 57, 60, 119, 70, 122, 73, 78, 126, 80, 127, 
        146, 23, 74, 123, 71, 120, 64, 62, 115, 61, 114, 59, 52, 110, 51, 2}],
        LineBox[{4, 3, 53, 111, 54, 63, 116, 65, 117, 66, 68, 121, 72, 124, 
        75, 85, 130, 87, 25, 20, 15, 69, 118, 67, 56, 112, 55, 5, 4}], 
       LineBox[{77, 26, 31, 36, 95, 137, 94, 97, 143, 107, 46, 47, 48, 108, 
        144, 101, 99, 139, 98, 138, 96, 91, 134, 88, 131, 79, 76, 125, 77}], 
       LineBox[{82, 28, 81, 128, 83, 129, 84, 86, 133, 90, 136, 93, 104, 142, 
        106, 45, 50, 49, 109, 145, 105, 103, 141, 102, 140, 100, 92, 135, 89, 
        132, 82}]}}],
    AspectRatio->1,
    Frame->True,
    Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{266, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->701494910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->54978163],

Cell["Use more initial points to get smoother regions:", "ExampleText",
 CellID->105252621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], 
       RowBox[{"Sin", "[", "y", "]"}]}], ">", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", " ", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "pp"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pp", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10", ",", "20", ",", "50"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339730340],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 377},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317934779]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->137908305],

Cell[TextData[{
 "Show the region over the full ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " range:"
}], "ExampleText",
 CellID->1755279014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "^", "2"}], "+", "x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162516693],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298111672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77906239],

Cell[TextData[{
 "Automatically compute the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " range:"
}], "ExampleText",
 CellID->1868205896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "^", "2"}], "+", "x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378679323],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm21oXlcdwG+f16StbdfEtpm4dZvUqfOb+tG6dEtVGPPlm29Y2sH2QVr6
gttcGRNlKGOgDku0tJSMaG1Zt9hFumVEO6mrCwYrFsuKhULBjkqxWKRQePz9
//9z7nlynntv7k2KoBiePLnn3nv+76/nnDy0Zfejj3xjy+7Htm5Zv3nnlh2P
PrZ11/qR7Tu5VV+SJMlxfsfXJVx3uNLf450Of7u/1/Nd51FNRnKhdxnzO5Tx
TC7l2Tou5G89Y957M575eUMF8/Reclc0qxWN10ZjndUI4yRZ03OnHc25reeN
Rs+dtZlQRLBL5K/eup3vRganMc0r3XuNeWlf5d6s/cd4+G+Sd0yrQBHLuX0B
NDbd3MEF0eZnZ9tsrOehBdLXPWdgwXTO8cGO9/qak3C3N7eisX8+GD0fip4b
1N7o0v0ttO1zMJIeq4pjTCzBWz2OPfZ/EV8tV9r90Xh9NL4zGq/W8c2bN69f
vy6XSzPen4tNRtv0rXPnzo2PjzMxua+Qpq3Kxuzs7Aujvzx27BjI7sviMWfe
zMzM2OFTr77+zuTkZIV5zdOnT48fOT3zp38deWX25MmTyUcy54qd52XCOF4q
3Nb09PRLx88Alw+EQd6HMyH3Zeit2IMVft34BXhSk6/695//2ZUrV+TRvZl4
XKDSn6zcnI1XXjB8N27ceP5HR99485Lha3E1NjY2MTGBqkZHR/m+x73fWiBf
2/Lw/OqNv772m4uMDh48yOMP3CI5PqLjs2fP/vTQlKBqqhx/uO/lixcvyqN7
bimeU6dO/fyltwOeoK9sPD6ytrr+9koLJ8G3fvv23x3Uk2+9y1geZUsp9oFt
kS0ZFOCh2/JQzELwXIQnANoKBTe+cOFCPoc+SmyRURNOCBSHDx8+NP7m7//4
z6RPYUyf+tvRo0d5ltzdKYodX1MY165dw4UhffTACWYmyxQGAHFGiT93l+JG
YdURI/r63R/+kawQKA0G3ALQ1atX42iZDeerOsaYnFRWKRx4Iy5893uHkM2d
FeBMTU29PPlnAbFauWLALXl0RykoX+k47/r2swdEvgMKBb/Cc4uhiNSNhsuX
Lz/3g1/IxAGvHRQmj95fqB3DjXZgO8xGL5hMVQ6CPAciK6sCJVj8YqAQ/YhN
C+foyzo+f/78j/dPCoBBhWI5rDyUL3m54CkSCdYolGefexFL9brJ1+yDMlqG
h0H5jP4AiZl8kxoBSXDnkWm2TbTkjQn9QfVoQjCuFYx9RGo8hMe42qVLl3gV
NvDpFYIJBN0RrZeLB+RrOSFx7zP7UA0fgMME3+RnYIODQH3mzBmLuFjyiRMn
uMObNbSg1mjpNlknX/34rgAaGyOf8B5iJSxAEjOTZd4b4IPI3BPVsyWtsqrD
t6GyONcCKiAwHzjm2cSJv2zwerQyxqqtBvYPNuIIQq2CL2QOxdfEe5EIFgtT
Iv17FduBF3+NbFRJHRcLwYbceH3//v2VOIQXwAvYjylaJAlj6JSnwOWCN8jP
MzNIfXoaLsk7rg4hQBAmBEycsYowAhItCYCP+6zPGNMjYnABNTV0mdQJnbAc
qp6QH6pgC5Fok0JBvAhZxVboKyPearBLkfymKOf6bjTbwm02CYpKUyYO62w4
QoTFuHuhhKrFoACyEhSTA3LDH8R5hn1OQZr4YI40vQdnrd3EM9Sf64QCshTy
dbJC7Ag/3zr0buFKQly3DusMi18YKYLYFOWmGEJ2PWyC60KciVmG9ysQPABZ
EfFxjgciD/SVc2uBPG3UGfgEGDB9WHlQMUhEGxsTa8/25l5MfpUilrZiqOO4
rqYYieq+KvC734vHhifthZLNigePtmCSoxtvZ/5vOaihIsqGGvuAQQl11ad9
/Y9ziQ9or9e0ZiBYRbZvf7LTmVNdfcbLE3BU+kmNUJY0GZiX9sASLq0/tKQt
l9ZzY9YYmYB7WOtH6xvMbrNpWad043mEfdCSBUjClvGaXBG7CFfkdrGjVR4n
YIXuh32GodXieSHPiqeVxlLCCJkQ2Wm2a6c5RMLjkdPkasG30tudNXQOH1Oh
cj4ZK76u2K0ZYDlhED+3sh+iUae1VfAEs2QjnKYeRdr3RJL9nFJhXXo5KpAu
mlaw8rUUFyXyoG+wYU5wAzlIGonAv3VVwB/VH7MG6TCcF5h3YmlITLTweaUn
7RAL6RmKfKHtI4XLk8vVaiACp0NKEG4rRVSd3JH+RrHVybhEG3mUuRKXWqmt
tKJLyJMeS2utPpiHHZIoTFiBSEkL8BQ2d6TuqnWKMqTBhmlgp3WcWCMJBN9B
gJKrvqgwsSFXZ2SurPXAfp+OMUPqMwGw3WcJAAllVaCEHL5DoQASwMWy6+UT
C0VmUjntVD4xKFtdm9/+XL5DTPjRrgqzbX2YFy13Idpdvg8spX2z/lCR7vKR
t5R+13jbefo7PxE73x3VBOV0YFBwbtc1GZSU/5JQpCtJljKFnA0/0I/dWvBN
XWN3pN3MNddsyP14JN6MmDBZDJdYQHSCYuF7T9RzVoDb1bnWvae7rseoTWPp
PLWsRWKYp2yRiU/obKjDqBDD3MohhxZ0QIALs0P/W64aXxFZ0+MRB+XyuOUb
rM/UyA+m7GLb454r5I+R5dQ1fZ38/UqVYjO9h2hCt5F2dIl1oNalBk7SjJKD
V/mbZ0dH77TTO3THpHUyHolOF711FcIQJ0/5foTnad95K7A++fQLgCZY4ulJ
QzsxsDhen4qseXFYZWJSN4Teyk26aNHd+5bXqttX6Ot019ul+Wt184cbYDOC
uIZAlR9D6PgLUWCRUu22L9xPe183NvsLdcDeSLLF1utXimO/7/dQsR3cIKnB
p8ZsJ81vRlZTbqXA6knc4ZL+kEWRkIsD1Hv8dEp7sMWB0NOmXgulJPkCKCGS
hdlPRCsDZSJZiKpPRhyU66cVSh8BCBrMbKzspWrBdvdE9loBZj/JCHtEdVim
1e1o0kWdPdHqRbk8YvmTGsb2vVwOhzpKVsnhVaCgf0wqZJ+qudzGoSozWkiT
Lo/kQwnVCPJwtajS0JCE5uv4fL1bHYV1MRfV+0qoSXS1xkdnFVbdUoWBiR6D
2VbDpfwXzo5r0R2+W0TBYrHlqkiDErLn9shrymkgrefdPtJQGm+tRROgX1DI
mDZOVl63Bjl0JrpK3EZPCMzyNEEDgb36+jsOQ8iXxXo3yKH6WOv9AI8PnKOI
yclJjNygS9qyODq/XUgnTzQUeeg+VMNc2RqQlu9pMFMJpRZPcQNUEWoD/Mvp
xbo5nKtsdR/3uJJ7AE8ASGokg6RFNLA4gLSQIQbf8DEcCRAxNKl0ryVYBA37
FdbxIj6EWIqmvpQmPigU4zXoNVkKrgeXUdttp7ZtkRCNS01psRYx4HMiW6Mi
7cvnp0JWtekdEIJ4/PS0nUNogR2EpiPMmAbS1jXCzoqtM1ARUoTPh8k6alIz
nMlSy3LvISZzO4dTx7Qw3LAuE/Zb4nWdjfp+6Go/q36AeDAnVAfNSAC9af+U
S9XGSIO6WtWGZ+tcIBfaEIlUueXix8bIPzdHebPKKloMJbWsHChZFbdoJH+1
L0TLER/naPlEZmVr65iSWEqGByWjJ6llRnx/VbjmWh3Pp3QG9gBLhI50dTfU
efmrovNjkqGtiRMCMErbJLI18bCzOHeFuheyr5liXdiqPmkAyJJxh70ubL2w
NOWZFVDWPg26kD5u2FuVW7fM7i+9Vfl14xiq7Z2Envd+T71t4ZXsWke8nbj6
aTH7OGEldDhDQ/PtRMX7WGENr3gnyqQbdvM/IV+tI6/M2sYrF3bkphWtCVTZ
Ywv79Lqj12ZASrQdZi4s+yc1SWotS+P2sV2UcrHHMIXavc9LAfLFOj8UdW4K
tZXWDXxsjbUKthCBbfeXPko2fXU7HLAY6wYfN9CNVPu2+wtWEcFb7+Ip5Tos
9bU+IhwZz7ptbAxO4QePrnl7cSvrNY/FohcT7lCRyDkt1aqtEaBVXBflLPNa
gkpAlOz6bJfe1j0Iv2gPo0cBQGAIasKNLag2vIXyCBSmaTn15HZb1nrbYgZG
a7vJDa54GQgITlbpa2gnnzKx8If0Ka8RlEQOS/14amoKfTg8cUcRivQ1hZ5i
JzTCeu9g5GdVznlAHbxJ3TMY9ZhVzpwEWgaiqrwKlLDDb1DCjlwVKKGmGYiy
fpnTRPHs4KdlThOFzjM+i1SOA6MBNbq1s9URDVWghLWH27zvW6rqOUdbBMV2
D8U+Vmq1yhVQueVyXjlYenpNTtEyESLwd9sBIlIgL3OSzNPqPZC+3nERBXck
UQCp3/usi2zF5/rsVCBZhvlELhedw2pF8Yk+O5kYom0zwl3lfCPvM0tW1BZ2
StJOcIad4ob3X5wxH4pflcw6M5x9RjTsSNaiymRDJoZ4JbL3LGpcASmedrpm
wAdbxfllh/iDi8AhL6is22k25mPr7tKRb+h015vV6TZbCv1cLYp92WeeF4in
lcZYS5jYb/bZ7UXDTzdG88+GF63s2gl2k3jYY80+wZ57ap6CizBMQqxwal7W
XvY+s08WGT6aOyv8B4Dtxctl8X8AVP2vhKxxPvT//4fJrcc3V9rhv3uSJf8G
ANPZVg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 166},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498364368]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->851719105],

Cell["Regions are shown in light blue:", "ExampleText",
 CellID->1648054478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->460721783],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110895757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80818],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to just show the boundary of the region:"
}], "ExampleText",
 CellID->532228304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1672459446],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWutSEzEU3m5bRFAKpe2We5U7gqK+g/7yITqMDjiiDOLd9+hP+OEjMOPT
ZTRn92yb/TZNuoaVou1M9/TbfN/J7SSbpPuifXb48rh9dnTQbj0/bZ8cHh28
bz17dypvFQue513K78+mJ3//kr/C76UQQiakrlV5LUpCU9qStAHjmrQ+3yfc
gPRSqK7TlaAIPyErxh6r1XTKzSv1cJqBHuYhvRDev8ulKUFqJeN9e3kCwHPa
8sxyay0YajNYfrr28LvtXbOUxj0/rK8vdP1ct/q155z2oe/rOELnRC8iydYB
q7YXof3iPrqOMZfsD2mjHG9DOYqpkmoZ2GoZsE1/y5Fvyy9vvmt9/FQPRD0V
CaNPd5QYe+4pMDDebeOBYrTQzZ/q4XP8kL1gG6WOgxZLd5HwZYupJFuN3P6s
yih1lPpHqRRXNHDKRpY6jj0rG0crRnj28ZEec9lHUXJ+sNc3Hu/D12f/e+qe
vFQ6nc4G20dG9ra8lCSrwnZZwUVpd43qTYoEyQqY3WTbYLttVK8xa5G91NjG
eNOoXg2xpDFeYdU02xbbdaOXe8xaY3sH8KpRHee5BWUZB7wBuGX0ugzsbcBl
znVHqWlydBY1Y3gJvDxgdQnu7wJeSni3Pc0XQf0wJHWx/LEPjEXhMjsugLd9
rtUTuL9grUVv59JTvQIcr74Ha4s5UB9qvA3esk1QvwbcFIPM0QGo3gAOhCky
G8B+C7iRo7oO7BPAdaO6BuxTwLUc1bPAPgM8m6O6CuyPgKs5qmeA/clJ/Rnw
TI7qaWB/cVJ/BTz9j6orwP4GmNL9gdXfNerkbOlrnnLZvIQr98TKV3dmNmz+
qN7YU+hnKtHWw17Pq+nNrPE4vCPp5qqvc9Z2U1/nkxLVHwC7rRDIe/951219
4bYyclvTuandVqPZ1tE0vxU1s2Q2L7ZTnWw7BJu3bLuXfudSuKN6DBj3ackd
lq2M6J3OOuLdZif8YH7JfaDNP+5m9wD7lvTk3rbfU25JRHtW3Hnjzjze768I
U2SugArPJsYs6WbvLWCvc5km2G6wvW/0Ep+6rLKdUrDq3ewlVsenMFXA5pMf
SqWs5pndYDvP982nT1vMqileVLxjVNPZC4XppLTlTnSCU2ZM9/eMaorySc6D
bHjm0Zc9nKeUNyGVVrm6/8uTLPXcxrOys53MT0CqL3Sn/TqW5d8K49o9XT/d
rOXSzudiFLGjVPN5tX0kXBVbjXCy51yiqxqxydGGb6sEFmz7Lz5I5aBpV+N4
z/regut7HHnrh608f0WviQAad733edQ3frzCbx1+m8U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362844181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->519034],

Cell["Use light orange:", "ExampleText",
 CellID->1922746645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "LightOrange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1656487460],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34602797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159751802],

Cell["Distinct colors are used for different regions:", "ExampleText",
 CellID->1810315125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1235429228],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408439953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->991001078],

Cell["Use transparent colors for different regions:", "ExampleText",
 CellID->825964116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Yellow", ",", 
        RowBox[{"Opacity", "[", "0.4", "]"}]}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Green", ",", 
        RowBox[{"Opacity", "[", "0.4", "]"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1096667334],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWm1sU9cZvmAnTrO2ZHyMED4KlMIYpR3V9rPaD8SmUKG0qiImZUQkGTRZ
wWkzM4ZDwVkglBEI+SC6J6qStQSmBn64CjJDMhJKVJRIKJGiREWBijlaFSZh
IWFRyRqS97zn+Ppc33vsmxQ00VEUrn3ux/O+53k/z7neVuGr3rW3wldTVbHy
N3UVH1TXVP1x5a9r63DKNUfTtEv4f7lQw/cEvvH/lxIJfNqP83F04YZCfLrx
uTg5XojPucnzNP6J5bqbP72IjjRM8H/8LmOsJZ82XydpmluO7XdYEYos1+fw
8y8ktXFbrs6b5XlnfRZbxkuU+ixIsrU0y2xmJk/Fx9wU3wsdtHl8edb5zk2o
7LzIEddZsh1DbWvDQ5ckpEfS5yLL2PwpPTST35NH9OIuISM3+UyuTSerx7hU
/Mxi/MPzT9fzlC417TnVXWl+kP8/1jvve37/bJ+3Xhd2EbSJf6ksmNVOv7Dc
Yc1n1vEvcRCyPAmRP4xc0JP81Gy6WbX4NIWh9CPlnWkZR3nHvKxXSNNPk59O
9z7ZK8+i5MfXiexMjpqT8Q6P6YqW9U5rVFi9bHb+me7rs/Pg9NjLPjcjtr5f
ln86fG4jHXLi8UejI9/0dN/A3z5fSPPUevs1d0MgjPHl0M1I5P4r3Cb3I/++
GRq+0f2PcOAzT7/3jJYT8jEMR3vD34zcehT/j/a6bY4buIThoamTzYNVlRe3
bP6k1su0uT3dTHMND7HREfrTcuiQdzXMcP5YU9eOMvZWcQ9UudA3BunLCSMP
0sf6rkFsT7Gfle3vampg3UdZ+ISHjbRoeWzoFA31I8xb/8nmfRcrm6+3BaeG
vtqQkeN1dMidGL97rOkal8a+CLJbk6wgkWCaJxZjUK+9jUGXHWWffxGciMXi
Ist74rFvJ4Jffl52DGqwtkbIZ7FOrYDhuVw22cr6jjHfQWh5renv4GV9RvY5
qzlgGMTUVHddDumQSjJASCTCTjazd0rOgrfp6Qd8JaDlPJiODjZfOFtyiDU3
sEi7tphk5kC6HjqOiWPWMBCfmVriy9yOgwN3tpeeB8+Y7TIuLR6nyfOT10ga
fy7nYfQBpsBK/8SCx1lc15aRNDdmCO7PlzbeDo+8klHSKi4JxqupDtb72fQ0
W0WS3Jgk6GT6MJzuR/we+A18CHiYwyohYbqDBQ4Hq0/D5C/bPIoju+CaVZVs
YlzX1nBczOBcLwORMCjPNe674/8kE8Ep4voawnXp46fBELyVY6i9YoVJbzgj
YNcRvgv2gInO9Y4m8ylQuqoxrw5tndA5rsP5oDNMtDIjK9yT4fdTwCLdN3Bs
pjNEHPmXyIpg5Iq/G3DaBpPecCXtpYQ587kUuXEZH18N34Y/kzdt5N6M8MJ8
YFlchYJQkw00axs5OrwH7gpj8rkLdKfORKxHEZ0NAaKI4l74LObx9dgUghRe
or0u8MFM4DD55fLEbCoNDcXKDRECZyURmzhfX491tGz9S8tYh/YGlwB3BDzd
uiQx095qiQoZ8dXR761vGdv1bnVXa5TZ8ItmzFChYWnYIYXveRTXg/CayZ0s
8buPJ6shpTNuSIERkK8M3WYmRXSd3Fu7yNpvcH6u+A+xgUqI0ObSwRUY2vtb
HyMhmwyLi+AyScpUScXKH8GKqEUQJyWMIcW1VRO4m0uo0Q/W9polTHcg9qgi
FNriV+iMRINUIG16d/w08+5h8R1IZ4TYGS8v9f71KGJEsIPkgFxkaKSO3UWG
78MrJTI4v1h5gEV2ah6OfCKy++1KZuI9cBjObyCr43ahwQJSZDRqZyGPI9f2
HqjRzSxEOxG3yKKOyLz2mnR+GO1kpbXExnMGG1tLmfRIlBiUN2POamReMVzR
6MPtpTxGhc7XUa/6dhFoPkf+aKC2zG/WOa4jFZPOTsjtbdcv9Fl0Lqkl0Oc5
8raylhMRM3JK54U2n3DSVSDW9e3f3abU1dgns+s638hUKOVpPnG2BAlyh/aC
mt+2RvQaxlzVLAhkhAXSnkSeQKlsriHQFzny7rZDdX3pPoHynR35x3yMQoao
JlDBBhKHPl4hkZE/4McEmtTZW48SYWiWDRnVF7VS6oysR94G0AKOvLW07dS0
WefgcXQddmRiXLCAsEBykIg3Q8e7mv4gEauaG/YF0/MDLGdopLZcAR/fmryH
Oi9ZkLmtwOK/SRYqD9yb/JeBrGZBIMvcL5B7iskhJHJ7bOeWYhOyrAJOyNbI
uB9pZ2V7CXQ+R3678uTHk8rIcEJGS4yuVCLfGWhm/vclcnngiD9sQkbngExv
RybGhS+gw0RCk4ijvU1Mf08i7umu39OdHnNorw2N1JYTY/QzbxWbLDeIljX4
e4m8P1RX0dQl+UXDjMbaQFazME/pEyHfQTZUKZEbR94v9Zp9omw/il06cl5S
e2v/JCRgOYRlipSApoCNVGSRkIo9KYH3iVn3fNWyzqPfni6XslCvtpV9J1mu
FINOMk5NVyH/qWS8mDA6qic1n8yyHp87mSOFrKPjNeixnowsaz528gksD7AE
mY3Xof69U2KazbWmBj1UJSX4wx+WB8zMlfhQ/LJHjMgbWzZTWZVRPox1cu9u
iSw7lyTymx+anlflDay0sHpUZfz56owfaUdHmD1vCF0bAuGrYRMyOsOu6j0S
GW1h44gZOXwiHPjMnuPsyFi9YamV1gWwzR9I5C3FZ9pjZuRUF+CEbPVDajh5
k5+sJZlrtRMyek5kUdkT3cB6tvs9iazoiZBIqfPOVKsz81ug5nfoVIjWMNlq
tfAJ2XkLXakdjJbLjsVaUVlzw0Twy8QMOhYrC7IzFMj7gr6q5nQWEBwoJ479
m3Udcm+ylVXulci2Wp3yNidka5WS+eJ5tU+kOpd0ZGJcrBLq/VcGB5TVXyCW
+Zs+GjDrOtmK9YeBqLbcAqWu0n/z1br6D90ZGEvYenn7yiazzvlKnWXHknn9
sVCps+wC8tS5P8VvZmSxgrT2b9Qfo3/DasxjrBbgFljcGMip/jh9nUeMm9bP
TK6fZRTnOqyfM692BXLmquR2qEqLM7KwWJktaX2HyIiWQz1Cbo1WgAXTmkk/
Mtobpkflmp/qnUtRUQtVmciT2gMAvnX9L+NO7lk4vVMoNLiv9fbTbhtnKOd2
+AQLUKUSzbKxvzB+ut97hhgvmjG+2ENCn4vcj2KYtAA66MayP+8PpTSfbAUy
5aKlWZHlfpdApC1xzosby5S+hj7a8I7rPxeYIy1JzKLETN+wLDWwsYgA7dpr
nHPk1Ho/w1oIV7G8YQiiWKf2msE5Mj9JWZ5Vc/v+IziHceE+2qucE7CDWB0c
uJO8H8WPdk8j7dqrhu/AusR++h6kqldaYXgn/J72YtZzCUjisHIkcj95Pxp+
SNBDx7X1xrobY9r7zbw7+5IRUYhV4GlrOfuQsc/HUCdAnegVwQjti4OqSPta
IwNgkYHA4jvLiv1qNx4GBEjA+m01x43FaMd6eynOTImd8Kmhr5CkaMc61rla
7CoPncIZJBeIzLxnvZo/jXwIywrHWcE9HRJ6ukmC2G7nv27ScsR+O+3qc0Ha
CiFppAVNCcyNHLkmI0NrOALvdvrFGwuqyUvS3lhA5g3ay+aVOweKJ6Wh5YS9
i7g02AXWgAvDEdZmlEZXjDc0wEVvgVKCSS0gebmQx3f8k69nMEGevXMhEWam
rX9widVspH2BeDMT62QoPoHDrNgH88FYP80oma5oeZgFWhpUMPQemC3cGXED
dvNJPq7Sd6iA8ATH4q0GjMDjLA80DuuXSAtMHTKhCBiO6/mkSx59RxrSj1AU
FPuu+Ltvh0eg+M9s3rPR4AAOj5AC7796k0GfXHqN5sEXMcR5SEcY09sb7nGe
B9NRgEIJ2o3fXIeWHpJAg7ceh2IfxriAqANZ4GJjRu/aZOQNmB1/mpsONE5e
3yAiPvYtbEnvKNx0cImlvPH8//db1O+mE+US1W8H5R3m3X8t650zf7uu+r1R
+pt6p18kWX5ZkHXlnD4XVTafDat/S+n4NNrz2dBpNt6tej+Z3RMf906zl9EN
3QkRYzP5JZ71N69Ov2B1GlufzzKXH34Z+gw9b4+Pc/yM/bfE2pz/Al3MmK0=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41194458]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->264172455],

Cell["Find the intersection of two half-spaces:", "ExampleText",
 CellID->1588416969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[LessEqual]", 
     RowBox[{
      RowBox[{"2", "y"}], "+", "1"}]}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{"x", "-", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "35"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440396275],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmftLFFEUx2d3dtdHorWpbbo+sKckvSXpXZI9TZLeJbRtppuZ7yxNl1Do
lwiiEDIIZGNhoz+hH4KifmhJMPA/8Md+6KcQhO3eee3eM2fPziqKYMvuvXPn
fj/nnnvOnTvDTr2vt7W53dcb8PvKT3b7OlsD/p7yuo5udkq2SZI0xn5vPBI7
jrEj5TcWi7E6sXSz0sG6Slgts7qI1XZWl2ptr9YvK+q1vOSnlZaq0tv80MML
R7xtVniBBdVujjaKA6gLkpxPPU4JaNsVWQHhjTW7sG1bVLvulFxqy8UmRTyX
eqZ5XQzaeq3EXjKvnMTSpeXJyepnPK1SBsiz0+SFE/gJcyynaKfSL7W9pR7P
psRZS6bysetNYIU3y8F5eH1gbYdiNSuFHyOssKWpdMVSrYa4lq8ku86girx5
9nCrI1o9fyvL0ien2jM7Ozs1NcVK6anYn6H2z8zMBEfHw+EwU83NzUlBUZVl
qF68+vj955937z/HtUOi1pGotUd//ZWcX3/8FohB00wlWdVzuYwyj8RYCKO4
UKKf8CtTJCYnJ3ls+ggiWycmwl8YEY1GOdFDEDkKwaIVinyLE10EkSsS2jw6
yGjl6Yww9/tEtNxotNoIv/JRIkAQhSjRIlzLsiTeDVTSk0CGQiEtas0GmQnW
u8NkoQiNu9+wYGWnFC16TRb5bHykT7IykpokjnvR3DbpSgvzKkdj2pRGZCpQ
Czdi6A4rkBtR8hqxAjajxBWC2CoSWt4ukau/UmeEXDcSq78KzcMFwq/t6BXW
QBA70bnXE8RulDhLEHtR4jQZrWoTw6NVR0SrBs3JCcKv/ejVV0sQBxOISCSi
zeQYQRxG536EII6ixCGCOI4SB8j41qJMDRHfOjS++wi/TqErvpogzogZYfc6
7tUegjinE+q9TpvHLoI4j858BxmtBpSpIqLViBLbCL8uoiu+kiAuoxnZIuyy
3D/znesquvI3Cbur+Kxr3qGvo9fChrRs3OQ2HMYMpqenK1Lw8F6lWJCZhbcT
n9g0pDLjLmVl/FsKzSbAUN5Zlpb3PkCXWoj8bcCUEPn1A62X0N4B2mJyPUP1
emIl30W0ybxoAVoPoW0F2nWENgC0hYT2HtAWENo2oM0nowbVbiJq7Yg2mRcP
gHYNoe0A2tWEthNo8whtF9DmkpGA6hwiEj2INpkXvUC7itD2AW02oX0ItFmE
th9oM8lIQLWLiMRjRJvMiwGgdRLaQaB1CPuQjO5dTwAjGwz6j4jADgHWngY7
rOz4BkuScK9Xx33+8oOkfqyOGVQ4dsCavHNhXPK9Hdeb87VwHVyFwwnKeGQW
Y+Tlrlt5kVl5M17ekeFPjsb7H4v7SeJbB6vcfPevbMDZjZ02ODo+EHzNvtIQ
L3hbUj/JSfEZuQworPxjb34/QD97q2f+v4lZWL/5Xqa+AzO/J5Ns/wCJgL8L
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->237578870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->393640522],

Cell["Simple regions including a disk: ", "ExampleText",
 CellID->552011990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41991373],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->483296162]
}, Open  ]],

Cell["Disk annulus:", "ExampleText",
 CellID->136696095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "4"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17180969],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->90496558]
}, Open  ]],

Cell["Ellipse:", "ExampleText",
 CellID->22029998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "y"}], ")"}], "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->84329592],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->102200925]
}, Open  ]],

Cell["Ellipse annulus:", "ExampleText",
 CellID->644647238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "4"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "y"}], ")"}], "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->66914258],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->211263166]
}, Open  ]],

Cell["Disk segment: ", "ExampleText",
 CellID->267727325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", 
     RowBox[{"-", "x"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->513884130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[5]=",
 CellID->9627212]
}, Open  ]],

Cell["Disk segment annulus:", "ExampleText",
 CellID->240324382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "4"}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", 
     RowBox[{"-", "x"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->728823031],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[6]=",
 CellID->121344614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->692718249],

Cell["Illustrate set operations: ", "ExampleText",
 CellID->5583065],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "x"}], ")"}], "2"], "+", 
     SuperscriptBox["y", "2"]}], "<", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], "+", "x"}], ")"}], "2"], "+", 
     SuperscriptBox["y", "2"]}], "<", "1"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->6853300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
      "And", ",", "Or", ",", "Xor", ",", "Implies", ",", "Nand", ",", "Nor"}],
       "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->640275383],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->60422152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99670882],

Cell["Visualize regions in the complex plane: ", "ExampleText",
 CellID->559707777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"1", "<", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "<", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20938958],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->692932592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"1", "<", 
    RowBox[{"Abs", "[", " ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "-", "2"}], 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}], "-", "1"}]], "]"}], 
    "<", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97517862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->716309703]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"z", "=", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}]}], "}"}], ",", 
     RowBox[{"RegionPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"z", "-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"z", "+", "1"}], ")"}]}], "]"}], "<", "r"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", 
       RowBox[{"3", "/", "2"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->234782973],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->858158454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17922501],

Cell["Identify where a function is real-valued:", "ExampleText",
 CellID->929304730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", " ", "-", 
       RowBox[{"y", "^", "3"}]}], "]"}], ",", "_Real"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1285679827],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127593342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->729606211],

Cell["Integrate over a region that contains parameters: ", "ExampleText",
 CellID->251967833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18917],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"a", "\[GreaterEqual]", "2"}]},
    {
     FractionBox[
      RowBox[{"a", " ", "\[Pi]"}], "4"], 
     RowBox[{"0", "<", "a", "\[LessEqual]", "1"}]},
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}]]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"ArcCsc", "[", 
          SqrtBox["a"], "]"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"ArcTan", "[", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}]], "]"}]}]}], ")"}]}], 
     RowBox[{"1", "<", "a", "<", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{396, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60629050]
}, Open  ]],

Cell["Visualize the regions for the three different cases: ", "ExampleText",
 CellID->470272964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"5", "/", "2"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113960094],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm21oHEUYx+eyd5ekjRatxVhrja1t7fubfbG1tqbVWLXaVut7bUOqtB9E
qf0kSFAqxVICtsVwbUgIKddGjyREPTlNOTVyviQYjBgaDAYCASNIMHhIIFD/
z+zO7mWSS8+YfW4/GLi73Z1nnt//ZmfmeWYuu6v02OGXXik9dqSstKjkaOlr
h4+UvV704KtHccnwCeHbI4R4uVDg+CqO5Iv+9uIlRC7eD+HSdOuzAJ9l+Myz
S4WhalwVB7Xz/P9YHhxDiUQiojgUCgmjqqoqmUxS0a0TeI3H4+LFFHthfRdV
3tnZKQ7I8v7+fvOSyTPf/ealcDj81be/39/+09/CeOfd2qGhobRcq0Zzc/On
l3/dn1LDJlsW7e3tdfUJ0yJUHevu7haj2/V/tifY6BwWi5O9Tdp988OfNTU1
VDiHnX25tR+DLTvsTz7/JRqNZod9qaEtkUhkh1194QtMSNlhnw191Nvbmx12
+fFzw8PD3Oyt0u7rtj/q6uqo8DZ2dnPsSiwWyw67Ntza0dGRHXbFmQjCLTf7
Pmn3/Y9/YU4dGRkRc9nZzv3mZztzCz/7xKkLg4OD3Owt0u6zL/saGxup8HZ2
tjPG+NlOzsTJvlfawSUcU2ERO9u042ZvVrEEpzS33MHORgVUo0JO9iY1p8IZ
La/msbOdfI2TfY/2veezs53vzcneqNYlmNLpe9/JznbiGCd7gza+F7Cznfyc
k71ey1sWMrLXqTY/WXGR+toidrYTS9xj+/GeQ6cBeepIEHdL+6bozy0tLVR2
11Rp8NsaLLaJNug9z/avyVkrfccTvyGbwmJNLHahRQzNZ04GutaomRi9BEmm
WOIpXe9XRXt6eqjIK7pWSx/hD7/DHxUt9YiuVdpMsyyFYprmXVNZjsYNuqJ0
pVpXQATFguW6DzF6RkmvVbecOo0r1B4e4DRaV1B5QLPOQKXODkxSrX5nclL8
mIqXa4pXjr7/VmsFM1KsW46v1K9p8pmtYthNaVqMUrlMU7lK8zEVo4fa2IdP
0uPLsPWWpvRJ0rXaBV3jt9fE/XCJimGWrjUu6JrM+Fis1kyIrTSG13pE1yKV
XyPdg1exziO6Fqp+f+q9D5CGivUe0bVA+mj4uBNZCUX/DR7RNV/mWchdT1c2
xeNxdLGNHlE2T7UYVnB9fX1ik0d0FckWQ36JHoYWw2SxmU1Z+hx8rrqPWHbW
19cPDAxsmSpVabLwsWuROdIacwJqwitWv1tdaJl0K6HZZBew6ahM8+U2RgWF
UgF6BkzfPlGNyhRJihkVzCK7INYYGDYVZyLoCKiAZtjBqGGmbAXkx1hSlB8/
hyFC/7FQwqhgBtnl4uBSQxvC05tvVSJVx+qG+sNORh3TyC4fPRJeTSnoFShK
JBIITaTmUUY1BtkVIPOiTe/YFdQ8X9uCTgJNuE2gmbKSyeRud1UZtifhf6P8
rMhFSMQJ7hGqdnV1obvQLsq+a6p4Qc43zt7m5HTQ4cEMWc7etZus5+UIsn+b
MHEu8p6TftBFENGoHfUsPt818rNqTwT9ECFrTNRzm+zs0fKRn9F2y/TVinvk
p7X9gAAb+SmthwXZyPvUOgVkyrt1D+6Rn1R9G/M+5a95zGRnR4+P/IT0g7iC
ady2YCHvVetka36exkbeo5Gns5F3a+QCNvLjGvk6NvJj0k9tuNUiX89G3qX8
WP8pMYON/EjKTEKubmAjP6xmT8Rn2k25kY28U/2Kc7LiImUGM9nID0k/OEBa
SuntTWzkEukHKwVrD3IWG/kBdZ8RNLAMEDezkXeo+4z4jHAlCtnI21UeFolE
KDO4hYeM21sMuvRj7enOnpgMw/2yxunKpn9Pts7p+YHttOQyzB+KqWhcrnVO
o/2AtKe2kZdSnzfIkDqZcudZikMi3fMcZGg+9yF8/wDvQAUc\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->111368024]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->465324047],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " samples more points where it needs to:"
}], "ExampleText",
 CellID->252222440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "^", "2"}], "+", "x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88084274],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlW3lczdkbbkhDo7FvIVsIIcslwmnKGlIjWyXLWBrZhjSFMUYUsoRra2hc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   "], {
    {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgncl1MWx597H3tFKCWJlJpWyS5ZKmUUUqhUSoqUlGRLpdWSFiWKRFkq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        "]], PolygonBox[CompressedData["
1:eJwtl3f8V1Mcxu/5nAaFspIRFckqVCKESmZCS6VBIV7hR6EpMsreO0UlpWEU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        "]], 
       PolygonBox[{{811, 305, 186, 808, 304}, {318, 829, 316, 825, 
        200}}]}]}, {}, {}, {}}],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-1.5, 0.5}, {-1.1, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2113138950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92078925],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " for volumes:"
}], "ExampleText",
 CellID->1541735666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", 
     RowBox[{"z", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "<", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "35"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208559390],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 264},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->134957417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78086410],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 " for systems of equalities:"
}], "ExampleText",
 CellID->2137104422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Nest", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "^", "2"}], "+", "x", "+", 
           RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "==", "2"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1.5"}], ",", "0.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2083640414],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdnHVYVE0UhxUDDLBQEUFRbLFb1INJGaCAit0iJnYHooKICiIYIKAiYIId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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1fOfEAYYBvC7bNuXbdvmZddlXrZt27Zt27XlthrCVkNttcXte59++D7v
X/A8b1BIaHD3wICAgJsi7IYjPBGISCQiE4WoRCM6MYhJLGITh7jEIz4JSEgi
EpOEpCQjOSlISSpSk4Yg0pKO9GQgI5nITBayko3s5CAnuchNHvKSj/wUoCCF
KEwRilKM4pSgJKUoTRnKUo7yVKAilahMFapSjerUoCa1qE0dgqlLPerTgIY0
ojFNaEozmtOClrSiNSG0oS3taE8HOtKJznShK93oTig96EkvetOHvvSjPwMY
yCAGM4ShDGM4IxjJKEYzhrGMYzwTmMgkJjOFqUxjOjOYySxmM4e5zGM+C1jI
IhazhKUsYzkrWMkqVrOGtaxjPRvYyCY2s4WtbGM7O9jJLnazh73sYz8HOMgh
DnOEoxzjOCc4ySlOc4aznOM8F7jIJS5zhatc4zo3uMktvuFbbnOHu9zjPg94
yCO+43se84Qf+JGf+JmnPOM5L/iFX3nJK37jd/7gT17zhr/4m7e84x/+5T0f
+MgnPvOF/wgrfyDhCE8EIhKJyEQhKtGITgxiEovYxCEu8YhPAhKSiMQkISnJ
SE4KUpKK1KQhiLSkIz0ZyEgmMpOFrGQjOznISS5yk4e85CM/BShIIQpThKIU
ozglKEkpSlOGspSjPBWoSCUqU4WqVKM6NahJLWpTh2DqUo/6NKAhjWhME5rS
jOa0oCWtaE0IbWhLO9rTgY50ojNd6Eo3wsY7lB70pBe96UNf+tGfAQxkEIMZ
wlCGMZwRjGQUoxnDWMYxnglMZBKTmcJUpjGdGcxkFrOZw1zmMZ8FLGQRi1nC
UpaxnBWsZBWrWcNa1rGeDWxkE5vZwla2sZ0d7GQXu9nDXvaxnwMc5BCHOcJR
jnGcE5zkFKc5w1nOcZ4LXOQSl7nCVa5xnRuBX3/o/yg/2JE=
        "]],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{"x", "+", 
             SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"x", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
             RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "\[Equal]", "2"}]],
      
      Annotation[#, 
       Abs[$CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                   Complex[0, 1] $CellContext`y)^2 + 
                 Complex[0, 1] $CellContext`y)^2 + 
               Complex[0, 1] $CellContext`y)^2 + 
             Complex[0, 1] $CellContext`y)^2 + 
           Complex[0, 1] $CellContext`y)^2 + Complex[0, 1] $CellContext`y] == 
       2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl01OQGAYABNDL5WLbtu2ksW02ToM2tm3bts22sdXYtm32dfrxZvZzP3aT
NG5bpU2wgICAFoEBAWeEs5zjPBe4yCUuc4WrXOM6N7jJLW5zh7vc4z4PeMgj
HvOEpzzjOS94ySte84a3vOM9H/jIJz7zha984zs/+Plfed2DEUhwgghBSEIR
mjCEJRzhiUBEIhGZKEQlGtGJQUxiEZs4xCUe8UlAQhKRmCQkJRnJSUFKUpGa
NKQlHenJQEYykZksZCUb2clBTnKRmzzkJR/5KcAvFKQQhSlCUYpRnBKUpBSl
KUNZylGeClSkEpWpQlWqUZ0a1KQWtalDXerxK/VpQEMa0ZgmNKUZv9E88P9t
taQVv/MHrWlDW9rRng50pBOd6UJXutGdHvSkF73pQ1/60Z8BDGQQgxnCUIYx
nBGMZBSjGcNYxjGeCUxkEpOZwlSmMZ0ZzGQWs5nDXOYxnwUsZBGLWcJSlrGc
FaxkFatZw1rWsZ4NbGQTm9nCVraxnR38yV/8zU52sZs97GUf+znAQQ5xmCMc
5RjHOcFJ/uEUpznDWc5xngtc5BKXucJVrnGdG9zkFre5w13ucZ8HPOQRj3nC
U57xnBe85BWvecNb3vGeD3zkE5/5wle+8Z0f/CQguP8TSHCCCEFIQhGaMIQl
HOGJQEQiEZkoRCUa0YlBTGIRmzjEJR7xSUBCEpGYJCQlGclJQUpSkZo0pCUd
6clARjKRmSxkJRvZyUFOcpGbPOQlH/kpwC8UpBCFKUJRilGcEpSkFKUpQ1nK
UZ4KVKQSlalCVapRnRrUpBa1qUNd6vEr9WlAQxrRmCY0pRm/0ZwWtKQVv/MH
rWlDW9rRng50pBOd6UJXutGdHvSkF73pQ1/60Z8BDGQQgxnCUIYxnBGMZBSj
GcNYxjGeCUxkEpOZwlSmMZ0ZzGQWs5nDXOYxnwUsZBGLWcJSlrGcFaxkFatZ
w1rWsZ4NbGQTm9nCVraxnR38yV/8zU52sZs97GUf+znAQQ5xmCMc5RjHOcFJ
/uEUpznDWc5xngtc5BKXucJVrnGdG9zkFre5w13ucZ8HPOQRj3nCU57xnBe8
5BWvecNb3vGeD3zkE5/5wle+8Z0f/CQgyP8JJDhBhCAkoQhNGMISjvBEICKR
iEwUohKN6MQgJrGITRziEo/4JCAhiUhMEpKSjOSkICWpSE0a0pKO9GQgI5nI
TBayko3s5CAnuchNHv4Fw4k3fw==
        "]],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{"x", "+", 
             SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"x", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
             RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "\[Equal]", "2"}]],
      
      Annotation[#, 
       Abs[$CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                   Complex[0, 1] $CellContext`y)^2 + 
                 Complex[0, 1] $CellContext`y)^2 + 
               Complex[0, 1] $CellContext`y)^2 + 
             Complex[0, 1] $CellContext`y)^2 + 
           Complex[0, 1] $CellContext`y)^2 + Complex[0, 1] $CellContext`y] == 
       2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[{1082, 1083, 1084, 1085, 1086}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{"x", "+", 
             SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"x", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
             RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "\[Equal]", "2"}]],
      
      Annotation[#, 
       Abs[$CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                   Complex[0, 1] $CellContext`y)^2 + 
                 Complex[0, 1] $CellContext`y)^2 + 
               Complex[0, 1] $CellContext`y)^2 + 
             Complex[0, 1] $CellContext`y)^2 + 
           Complex[0, 1] $CellContext`y)^2 + Complex[0, 1] $CellContext`y] == 
       2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[{1087, 1088, 1089, 1090, 1091}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{"x", "+", 
             SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"x", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
             RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "\[Equal]", "2"}]],
      
      Annotation[#, 
       Abs[$CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                   Complex[0, 1] $CellContext`y)^2 + 
                 Complex[0, 1] $CellContext`y)^2 + 
               Complex[0, 1] $CellContext`y)^2 + 
             Complex[0, 1] $CellContext`y)^2 + 
           Complex[0, 1] $CellContext`y)^2 + Complex[0, 1] $CellContext`y] == 
       2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN0+OD0AcAgOFfdXdZa2xti9uat1q1asyuy67Lusu2bdu2beOybdve8+F5
/4M3VURUeGSMIAiiJWdIEOQiN3nISz7yU4CCFKIwRShKMcIpTglKUorSlKEs
5ShPBSpSicpUoSoRVKM6NahJLWpTh7rUoz4NiCSKhjSiMU1oSjOa04KWtKI1
bWhLO9rTgY50ojNd6Eo3utODnvSiN33oSz/6M4CBDGIwQxjKMIYzgpGMYjRj
GMs4xjOBiUxiMlOYyjSmM4OZzGI2c5jLPOazgIUsYjFLWMoylrOClaxiNWtY
yzrWs4GNbGIzW9jKNrazg53sYjd72Ms+otnPAQ5yiMMc4SjHOM4JTnKK05zh
LOc4zwUuconLXOEq17jODW5yi9vc4S73uM8DHvKIxzzhKc94zgte8orXvOEt
73hPEBoEMYhJLEIIJYzYxCEu8YhPAhKSiMQkISkfkIwP+YiP+YRP+YzkfE4K
vuBLviIlqUhNGtKSjq/5hm9Jz3d8zw/8yE/8zC/8ym9kICO/k4nMZOEPspKN
7PzJX/zNP/zLf+QgJ7nITR7yko/8FKAghShMEYpSjHCKU4KSlKI0ZShLOcpT
gYpUojJVqEoE1ahODWpSi9rUoS71qE8DIomiIY1oTBOa0ozmtKAlrWhNG9rS
jvZ0oCOd6EwXutKN7vSgJ73oTR/60o/+DGAggxjMEIYyjOGMYCSjGM0YxjKO
8UxgIpOYzBSmMo3pzGAms5jNHOYyj/ksYCGLWMwSlrKM5axgJatYzRrWso71
bGAjm9jMFrayje3sYCe72M0e9rKPaPZzgIMc4jBHOMoxjnOCk5ziNGc4yznO
c4GLXOIyV7jKNa5zg5vc4jZ3uMs97vOAhzziMU94yjOe84KXvOI1b3jLO94T
hPmfmMQihFDCiE0c4hKP+CQgIYlITBKS8j97pgGh
        "]],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{"x", "+", 
             SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"x", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "+", 
             RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "\[Equal]", "2"}]],
      
      Annotation[#, 
       Abs[$CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + ($CellContext`x + ($CellContext`x + \
($CellContext`x + ($CellContext`x + Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                    Complex[0, 1] $CellContext`y)^2 + 
                   Complex[0, 1] $CellContext`y)^2 + 
                 Complex[0, 1] $CellContext`y)^2 + 
               Complex[0, 1] $CellContext`y)^2 + 
             Complex[0, 1] $CellContext`y)^2 + 
           Complex[0, 1] $CellContext`y)^2 + Complex[0, 1] $CellContext`y] == 
       2, "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1.5, 0.5}, {-1.1, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1395360385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"y", "^", "4"}], "+", 
        RowBox[{"z", "^", "4"}]}], ")"}]}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], ")"}]}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1300565455],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->9669885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196824387],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " to constrain other plots:"
}], "ExampleText",
 CellID->1276959983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Nest", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "^", "2"}], "+", "x", "+", 
             RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2062349810],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->681999243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Nest", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#", "^", "2"}], "+", "x", "+", 
             RowBox[{"I", " ", "y"}]}], ")"}], "&"}], ",", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], ",", "8"}], "]"}], "]"}], "<", "2"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1416377100],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->493602478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38551197],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for plane parametric curves and regions:"
}], "ExampleText",
 CellID->338007888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
       RowBox[{"r", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->9341621],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->194132647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->574934350],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " to integrate over regions: "
}], "ExampleText",
 CellID->215155923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"1", "<", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "<", "4"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "<", "1"}], "&&", 
      RowBox[{"x", ">", "0"}], "&&", 
      RowBox[{"y", ">", "0"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69201702],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  RowBox[{"(", 
   RowBox[{"16", "+", 
    RowBox[{"6", " ", 
     SqrtBox["5"]}], "+", 
    RowBox[{"16", " ", 
     RowBox[{"ArcCsch", "[", "2", "]"}]}], "-", 
    RowBox[{"ArcSinh", "[", "2", "]"}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SuperscriptBox["#1", "2"], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}]}], 
   ")"}]}]], "Output",
 ImageSize->{460, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136492029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"1", "<", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "<", "4"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "<", "1"}], "&&", 
      RowBox[{"x", ">", "0"}], "&&", 
      RowBox[{"y", ">", "0"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->931932869],

Cell[BoxData["1.4204931119869977`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->535857987]
}, Open  ]],

Cell["The integration region: ", "ExampleText",
 CellID->124722570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "<", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], "<", "4"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "<", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->696423687],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144931559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->615229212],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 " to optimize over regions: "
}], "ExampleText",
 CellID->85593649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "4"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40884941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"76", "+", 
        RowBox[{"28", " ", "#1"}], "+", 
        RowBox[{"18", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "2"]}], 
       "-", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"76", "+", 
           RowBox[{"28", " ", "#1"}], "+", 
           RowBox[{"18", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{493, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590582061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "4"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269941188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.721936255293988`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.058171028404169`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.48586827313171393`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203871822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMaximum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "4"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28444876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.72193620895597`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2.0581710194987015`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.48586826345164585`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->272740813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->453027011],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to get a cylindrical representation of the region: "
}], "ExampleText",
 CellID->530728075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "\[LessEqual]", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "4"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97890929],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "<", "x", "\[LessEqual]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
    RowBox[{"0", "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "<", "x", 
     "\[LessEqual]", "2"}], "&&", 
    RowBox[{"0", "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox["1", "x"]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", "<", "x", "<", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       SuperscriptBox["x", "2"]}]], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox["1", "x"]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox["1", "x"]}]}], ")"}]}]], "Output",
 ImageSize->{462, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->603872463]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find specific samples in regions: "
}], "ExampleText",
 CellID->53708313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "\[LessEqual]", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "4"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78905639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["1", "4"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99948407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8929],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " will only visualize 2-dimensional regions: "
}], "ExampleText",
 CellID->35219074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474399871],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[{}, {}],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414266998]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " to visualize 1-dimensional regions: "
}], "ExampleText",
 CellID->326766167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276849339],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmAlsVFUUhoeCoolFVGICBspSAYmIAsUagYPBmKAYKIuiCUogLBI2IawV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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1Gl8CAQYBvDNNrPLsHs228zYfR92JXSJrhEpJZOKakN3SclRuuhQObov
R+VIpwihVKKD7nJ3UBRdCP/9+vB/3s/Ph+fNaGxuaAoMCAg4QbTcVgQRTAit
CaUNYYQTQSRRtCWadrSnAzHEEkc8CSSSRDIdSSGVTqSRTgadyaQLWXSlG9nk
kEse+RRQSBHFlFBKGeVUUEkV3ammhlrqqG/pTQ9OpCe96M1JnMwpnMpp9OF0
+tKPMziTszibc2igPwM4l4EM4jwGcz4XMIQLuYihXMwwGhnOJYzgUi7jckYy
iiu4kqtoopnRjGEsV3MN13Id13MDN3ITNzOOWxjPrdzGBG5nIpOYzBTu4E6m
chd3cw/3ch/TmM79PMCDPMQMHuYRHmUms5jNHB7jcZ7gSZ7iaZ7hWZ7jeV5g
LvOYzwJe5CVeZiGLWMwSXmEpr/Iar/MGb/IWy3ib5azgHVayitW8yxrWso73
eJ/1fMCHfMQGPmYjm/iET/mMz9nMFr7gS77ia77hW77je35gK9vYzg52sovd
/MhP/Mwv7GEvv/Ib+9jP7/zBAQ7yJ3/xN//wL4c4zBH+4yjHaBl/IK0IIpgQ
WhNKG8IIJ4JIomhLNO1oTwdiiCWOeBJIJIlkOpJCKp1II50MOpNJF7LoSjey
ySGXPPIpoJAiiimhlDLKqaCSKrpTTQ211FEf+P/fOw6q4YlT
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->397715402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98316132],

Cell["\<\
Piecewise constant functions can have 2-dimensional level sets: \
\>", "ExampleText",
 CellID->313066817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Floor", "[", "x", " ", "]"}], 
       RowBox[{"Floor", "[", "y", "]"}]}], ",", "2"}], "]"}], "\[Equal]", 
    "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21001530],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28537895]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10583],

Cell["Overlay colors on a transcendental region:", "ExampleText",
 CellID->128511864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->378854997],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197859495]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", "y", "]"}]}], ">", 
    RowBox[{"1", "/", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "30"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Black", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Black"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9906228],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1460995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16419192],

Cell["Exclusive-or of five disks:", "ExampleText",
 CellID->58123718],

Cell[BoxData[
 RowBox[{
  RowBox[{"disk", "[", 
   RowBox[{"m_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x0", "=", 
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"Cos", "[", 
         RowBox[{"m", " ", "2", 
          RowBox[{"Pi", "/", "n"}]}], "]"}]}]}], ",", 
      RowBox[{"y0", "=", 
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"m", " ", "2", 
          RowBox[{"Pi", "/", "n"}]}], "]"}]}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "x0"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "y0"}], ")"}], "^", "2"}]}], "<", "1"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229769265],

Cell[BoxData[
 RowBox[{
  RowBox[{"disk", "[", "n_", "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Xor", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"disk", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "0", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699561132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"disk", "[", "5", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->163583367],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3355276]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3297],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DensityPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DensityPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RegionPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=RegionPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->407036638],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->547448184],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->97124914],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->752270413],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->221095387],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->249860298]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RegionPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 15, 30.0339878}", "context" -> "System`", 
    "keywords" -> {
     "characteristic function", "complex inequalities", "constraint regions", 
      "constraint set", "feasible sets", "inequalities", "inequalityplot", 
      "logical combinations of inequalities", "plot region", 
      "plotting 2D regions", "plotting complex regions", 
      "plotting feasible sets", "plotting inequalities", "Venn diagrams"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RegionPlot[pred, {x, x_min, x_max}, {y, y_min, y_max}] makes a plot \
showing the region in which pred is True. ", "synonyms" -> {"region plot"}, 
    "title" -> "RegionPlot", "type" -> "Symbol", "uri" -> "ref/RegionPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18490, 576, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46513764]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 794658, 16076}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2712, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3335, 84, 1575, 37, 70, "ObjectNameGrid"],
Cell[4913, 123, 1292, 42, 70, "Usage",
 CellID->32737]
}, Open  ]],
Cell[CellGroupData[{
Cell[6242, 170, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6720, 187, 176, 6, 70, "Notes",
 CellID->31361],
Cell[6899, 195, 231, 8, 70, "Notes",
 CellID->27338],
Cell[7133, 205, 134, 4, 70, "Notes",
 CellID->31969],
Cell[7270, 211, 364, 12, 70, "Notes",
 CellID->21367],
Cell[7637, 225, 6135, 164, 70, "3ColumnTableMod",
 CellID->18453],
Cell[13775, 391, 884, 28, 70, "Notes",
 CellID->25677],
Cell[14662, 421, 820, 27, 70, "Notes",
 CellID->14301],
Cell[15485, 450, 1050, 43, 70, "Notes",
 CellID->16695],
Cell[16538, 495, 498, 19, 70, "Notes",
 CellID->25338],
Cell[17039, 516, 286, 9, 70, "Notes",
 CellID->9835],
Cell[17328, 527, 632, 24, 70, "Notes",
 CellID->31585],
Cell[17963, 553, 490, 18, 70, "Notes",
 CellID->4691]
}, Closed]],
Cell[CellGroupData[{
Cell[18490, 576, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46513764],
Cell[CellGroupData[{
Cell[18874, 590, 146, 5, 70, "ExampleSection",
 CellID->8468379],
Cell[19023, 597, 82, 1, 70, "ExampleText",
 CellID->19362291],
Cell[CellGroupData[{
Cell[19130, 602, 395, 14, 28, "Input",
 CellID->4473],
Cell[19528, 618, 2945, 52, 204, "Output",
 Evaluatable->False,
 CellID->119214769]
}, Open  ]],
Cell[22488, 673, 125, 3, 70, "ExampleDelimiter",
 CellID->166468977],
Cell[22616, 678, 112, 3, 70, "ExampleText",
 CellID->83322389],
Cell[CellGroupData[{
Cell[22753, 685, 476, 17, 28, "Input",
 CellID->28861],
Cell[23232, 704, 2734, 49, 204, "Output",
 Evaluatable->False,
 CellID->380280728]
}, Open  ]],
Cell[25981, 756, 124, 3, 70, "ExampleDelimiter",
 CellID->93724150],
Cell[26108, 761, 70, 1, 70, "ExampleText",
 CellID->221870260],
Cell[CellGroupData[{
Cell[26203, 766, 544, 17, 47, "Input",
 CellID->16199],
Cell[26750, 785, 6958, 118, 197, "Output",
 Evaluatable->False,
 CellID->85971181]
}, Open  ]],
Cell[33723, 906, 125, 3, 70, "ExampleDelimiter",
 CellID->523147204],
Cell[33851, 911, 61, 1, 70, "ExampleText",
 CellID->142732630],
Cell[CellGroupData[{
Cell[33937, 916, 754, 24, 47, "Input",
 CellID->15076866],
Cell[34694, 942, 9062, 153, 193, "Output",
 Evaluatable->False,
 CellID->211061956]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43805, 1101, 216, 7, 70, "ExampleSection",
 CellID->17363],
Cell[CellGroupData[{
Cell[44046, 1112, 229, 7, 70, "ExampleSubsection",
 CellID->298882101],
Cell[44278, 1121, 104, 2, 70, "ExampleText",
 CellID->740660496],
Cell[CellGroupData[{
Cell[44407, 1127, 691, 23, 70, "Input",
 CellID->1365410381],
Cell[45101, 1152, 12035, 207, 193, "Output",
 CellID->103251207]
}, Open  ]],
Cell[57151, 1362, 124, 3, 70, "ExampleDelimiter",
 CellID->14269919],
Cell[57278, 1367, 221, 8, 70, "ExampleText",
 CellID->1304113656],
Cell[CellGroupData[{
Cell[57524, 1379, 383, 13, 70, "Input",
 CellID->1020115110],
Cell[57910, 1394, 2852, 51, 70, "Output",
 Evaluatable->False,
 CellID->134549406]
}, Open  ]],
Cell[60777, 1448, 125, 3, 70, "ExampleDelimiter",
 CellID->373712099],
Cell[60905, 1453, 356, 13, 70, "ExampleText",
 CellID->79146163],
Cell[CellGroupData[{
Cell[61286, 1470, 943, 29, 70, "Input",
 CellID->1133661767],
Cell[62232, 1501, 12834, 215, 70, "Output",
 Evaluatable->False,
 CellID->81289986]
}, Open  ]],
Cell[75081, 1719, 125, 3, 70, "ExampleDelimiter",
 CellID->888468442],
Cell[75209, 1724, 80, 1, 70, "ExampleText",
 CellID->1713040825],
Cell[CellGroupData[{
Cell[75314, 1729, 533, 19, 70, "Input",
 CellID->1911374093],
Cell[75850, 1750, 3527, 62, 70, "Output",
 Evaluatable->False,
 CellID->324726038]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79426, 1818, 233, 7, 70, "ExampleSubsection",
 CellID->153735188],
Cell[79662, 1827, 220, 8, 70, "ExampleText",
 CellID->157416703],
Cell[CellGroupData[{
Cell[79907, 1839, 698, 23, 70, "Input",
 CellID->254754736],
Cell[80608, 1864, 4064, 71, 70, "Output",
 Evaluatable->False,
 CellID->217995313]
}, Open  ]],
Cell[84687, 1938, 125, 3, 70, "ExampleDelimiter",
 CellID->621730161],
Cell[84815, 1943, 237, 8, 70, "ExampleText",
 CellID->347900488],
Cell[CellGroupData[{
Cell[85077, 1955, 545, 17, 70, "Input",
 CellID->244419543],
Cell[85625, 1974, 4560, 79, 70, "Output",
 Evaluatable->False,
 CellID->311818181]
}, Open  ]],
Cell[90200, 2056, 124, 3, 70, "ExampleDelimiter",
 CellID->93704113],
Cell[90327, 2061, 54, 1, 70, "ExampleText",
 CellID->299525187],
Cell[CellGroupData[{
Cell[90406, 2066, 672, 21, 70, "Input",
 CellID->1833133861],
Cell[91081, 2089, 4812, 83, 70, "Output",
 Evaluatable->False,
 CellID->344423704]
}, Open  ]],
Cell[95908, 2175, 125, 3, 70, "ExampleDelimiter",
 CellID->578573904],
Cell[96036, 2180, 64, 1, 70, "ExampleText",
 CellID->2051245947],
Cell[CellGroupData[{
Cell[96125, 2185, 619, 20, 70, "Input",
 CellID->1735645938],
Cell[96747, 2207, 7634, 129, 70, "Output",
 Evaluatable->False,
 CellID->380919506]
}, Open  ]],
Cell[104396, 2339, 124, 3, 70, "ExampleDelimiter",
 CellID->47535311],
Cell[104523, 2344, 78, 1, 70, "ExampleText",
 CellID->152911286],
Cell[CellGroupData[{
Cell[104626, 2349, 729, 24, 70, "Input",
 CellID->770854980],
Cell[105358, 2375, 7321, 124, 70, "Output",
 Evaluatable->False,
 CellID->175810148]
}, Open  ]],
Cell[112694, 2502, 124, 3, 70, "ExampleDelimiter",
 CellID->76417930],
Cell[112821, 2507, 85, 1, 70, "ExampleText",
 CellID->1497405390],
Cell[CellGroupData[{
Cell[112931, 2512, 1316, 41, 70, "Input",
 CellID->531530537],
Cell[114250, 2555, 37593, 620, 70, "Output",
 Evaluatable->False,
 CellID->247477288]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[151904, 3182, 223, 7, 70, "ExampleSection",
 CellID->639263323],
Cell[CellGroupData[{
Cell[152152, 3193, 232, 7, 70, "ExampleSubsection",
 CellID->361980370],
Cell[152387, 3202, 222, 8, 70, "ExampleText",
 CellID->1812813996],
Cell[CellGroupData[{
Cell[152634, 3214, 713, 25, 70, "Input",
 CellID->1614330783],
Cell[153350, 3241, 4393, 76, 70, "Output",
 Evaluatable->False,
 CellID->226009644]
}, Open  ]],
Cell[157758, 3320, 125, 3, 70, "ExampleDelimiter",
 CellID->300502267],
Cell[157886, 3325, 82, 1, 70, "ExampleText",
 CellID->1665503342],
Cell[CellGroupData[{
Cell[157993, 3330, 771, 26, 70, "Input",
 CellID->2003831251],
Cell[158767, 3358, 3685, 64, 70, "Output",
 Evaluatable->False,
 CellID->182154214]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[162501, 3428, 232, 7, 70, "ExampleSubsection",
 CellID->5613271],
Cell[162736, 3437, 73, 1, 70, "ExampleText",
 CellID->1810853759],
Cell[CellGroupData[{
Cell[162834, 3442, 436, 15, 70, "Input",
 CellID->1291149738],
Cell[163273, 3459, 4380, 76, 70, "Output",
 Evaluatable->False,
 CellID->46750508]
}, Open  ]],
Cell[167668, 3538, 125, 3, 70, "ExampleDelimiter",
 CellID->103536352],
Cell[167796, 3543, 216, 8, 70, "ExampleText",
 CellID->965592159],
Cell[CellGroupData[{
Cell[168037, 3555, 491, 16, 70, "Input",
 CellID->1499262702],
Cell[168531, 3573, 1472, 28, 70, "Output",
 Evaluatable->False,
 CellID->19565242]
}, Open  ]],
Cell[170018, 3604, 125, 3, 70, "ExampleDelimiter",
 CellID->528020436],
Cell[170146, 3609, 64, 1, 70, "ExampleText",
 CellID->1521384906],
Cell[CellGroupData[{
Cell[170235, 3614, 491, 16, 70, "Input",
 CellID->1431570545],
Cell[170729, 3632, 4303, 75, 70, "Output",
 Evaluatable->False,
 CellID->41279470]
}, Open  ]],
Cell[175047, 3710, 125, 3, 70, "ExampleDelimiter",
 CellID->364998925],
Cell[175175, 3715, 74, 1, 70, "ExampleText",
 CellID->1512818153],
Cell[CellGroupData[{
Cell[175274, 3720, 604, 20, 70, "Input",
 CellID->129293624],
Cell[175881, 3742, 4690, 81, 70, "Output",
 Evaluatable->False,
 CellID->145835371]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[180620, 3829, 233, 7, 70, "ExampleSubsection",
 CellID->25149962],
Cell[180856, 3838, 233, 9, 70, "ExampleText",
 CellID->844961974],
Cell[CellGroupData[{
Cell[181114, 3851, 1358, 44, 70, "Input",
 CellID->986605617],
Cell[182475, 3897, 10957, 184, 70, "Output",
 Evaluatable->False,
 CellID->326648435]
}, Open  ]],
Cell[193447, 4084, 125, 3, 70, "ExampleDelimiter",
 CellID->324531110],
Cell[193575, 4089, 175, 6, 70, "ExampleText",
 CellID->940465328],
Cell[CellGroupData[{
Cell[193775, 4099, 504, 17, 70, "Input",
 CellID->1815478652],
Cell[194282, 4118, 6719, 114, 70, "Output",
 Evaluatable->False,
 CellID->144072899]
}, Open  ]],
Cell[201016, 4235, 125, 3, 70, "ExampleDelimiter",
 CellID->356379159],
Cell[201144, 4240, 243, 9, 70, "ExampleText",
 CellID->268528963],
Cell[CellGroupData[{
Cell[201412, 4253, 853, 26, 70, "Input",
 CellID->37112921],
Cell[202268, 4281, 24238, 401, 70, "Output",
 Evaluatable->False,
 CellID->582208546]
}, Open  ]],
Cell[226521, 4685, 125, 3, 70, "ExampleDelimiter",
 CellID->654606299],
Cell[226649, 4690, 341, 12, 70, "ExampleText",
 CellID->2123132482],
Cell[CellGroupData[{
Cell[227015, 4706, 662, 21, 70, "Input",
 CellID->921125776],
Cell[227680, 4729, 4869, 84, 70, "Output",
 Evaluatable->False,
 CellID->702318019]
}, Open  ]],
Cell[232564, 4816, 124, 3, 70, "ExampleDelimiter",
 CellID->69980572],
Cell[232691, 4821, 343, 12, 70, "ExampleText",
 CellID->573080239],
Cell[CellGroupData[{
Cell[233059, 4837, 788, 25, 70, "Input",
 CellID->2062143332],
Cell[233850, 4864, 8439, 142, 70, "Output",
 Evaluatable->False,
 CellID->369822155]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[242338, 5012, 241, 7, 70, "ExampleSubsection",
 CellID->368166912],
Cell[242582, 5021, 252, 9, 70, "ExampleText",
 CellID->191837874],
Cell[CellGroupData[{
Cell[242859, 5034, 859, 26, 70, "Input",
 CellID->1230709205],
Cell[243721, 5062, 28549, 472, 70, "Output",
 Evaluatable->False,
 CellID->147123798]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[272319, 5540, 233, 7, 70, "ExampleSubsection",
 CellID->178798526],
Cell[272555, 5549, 87, 1, 70, "ExampleText",
 CellID->1232698577],
Cell[CellGroupData[{
Cell[272667, 5554, 942, 30, 70, "Input",
 CellID->1751045384],
Cell[273612, 5586, 25800, 427, 70, "Output",
 Evaluatable->False,
 CellID->226859702]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[299461, 6019, 223, 7, 70, "ExampleSubsection",
 CellID->7788324],
Cell[299687, 6028, 55, 1, 70, "ExampleText",
 CellID->553996305],
Cell[CellGroupData[{
Cell[299767, 6033, 437, 15, 70, "Input",
 CellID->27996],
Cell[300207, 6050, 4234, 73, 70, "Output",
 Evaluatable->False,
 CellID->796424446]
}, Open  ]],
Cell[304456, 6126, 125, 3, 70, "ExampleDelimiter",
 CellID->169395773],
Cell[304584, 6131, 86, 1, 70, "ExampleText",
 CellID->50507481],
Cell[CellGroupData[{
Cell[304695, 6136, 913, 30, 70, "Input",
 CellID->623192602],
Cell[305611, 6168, 33567, 554, 70, "Output",
 Evaluatable->False,
 CellID->206294699]
}, Open  ]],
Cell[339193, 6725, 125, 3, 70, "ExampleDelimiter",
 CellID->220867079],
Cell[339321, 6730, 75, 1, 70, "ExampleText",
 CellID->29115],
Cell[CellGroupData[{
Cell[339421, 6735, 439, 15, 70, "Input",
 CellID->8804],
Cell[339863, 6752, 5861, 100, 70, "Output",
 Evaluatable->False,
 CellID->294833587]
}, Open  ]],
Cell[345739, 6855, 124, 3, 70, "ExampleDelimiter",
 CellID->33173284],
Cell[345866, 6860, 266, 9, 70, "ExampleText",
 CellID->259883373],
Cell[CellGroupData[{
Cell[346157, 6873, 495, 17, 70, "Input",
 CellID->1693928656],
Cell[346655, 6892, 5071, 87, 70, "Output",
 Evaluatable->False,
 CellID->47894031]
}, Open  ]],
Cell[351741, 6982, 124, 3, 70, "ExampleDelimiter",
 CellID->30067522],
Cell[351868, 6987, 77, 1, 70, "ExampleText",
 CellID->218881433],
Cell[CellGroupData[{
Cell[351970, 6992, 659, 23, 70, "Input",
 CellID->924338650],
Cell[352632, 7017, 4689, 81, 70, "Output",
 Evaluatable->False,
 CellID->46716942]
}, Open  ]],
Cell[357336, 7101, 125, 3, 70, "ExampleDelimiter",
 CellID->328961131],
Cell[357464, 7106, 88, 1, 70, "ExampleText",
 CellID->81763859],
Cell[CellGroupData[{
Cell[357577, 7111, 853, 30, 70, "Input",
 CellID->2134156344],
Cell[358433, 7143, 4730, 82, 70, "Output",
 Evaluatable->False,
 CellID->22593134]
}, Open  ]],
Cell[363178, 7228, 123, 3, 70, "ExampleDelimiter",
 CellID->3895313],
Cell[363304, 7233, 102, 2, 70, "ExampleText",
 CellID->612905462],
Cell[CellGroupData[{
Cell[363431, 7239, 479, 16, 70, "Input",
 CellID->192426763],
Cell[363913, 7257, 3873, 68, 70, "Output",
 Evaluatable->False,
 CellID->438305166]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[367835, 7331, 234, 7, 70, "ExampleSubsection",
 CellID->101853424],
Cell[368072, 7340, 231, 9, 70, "ExampleText",
 CellID->840154786],
Cell[CellGroupData[{
Cell[368328, 7353, 1126, 36, 70, "Input",
 CellID->1058008473],
Cell[369457, 7391, 8895, 150, 70, "Output",
 Evaluatable->False,
 CellID->397016987]
}, Open  ]],
Cell[378367, 7544, 125, 3, 70, "ExampleDelimiter",
 CellID->338261583],
Cell[378495, 7549, 84, 1, 70, "ExampleText",
 CellID->11297412],
Cell[CellGroupData[{
Cell[378604, 7554, 640, 22, 70, "Input",
 CellID->1540985159],
Cell[379247, 7578, 12429, 208, 70, "Output",
 Evaluatable->False,
 CellID->175257965]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[391725, 7792, 230, 7, 70, "ExampleSubsection",
 CellID->5686125],
Cell[391958, 7801, 197, 8, 70, "ExampleText",
 CellID->719452713],
Cell[CellGroupData[{
Cell[392180, 7813, 677, 22, 70, "Input",
 CellID->1508814781],
Cell[392860, 7837, 5341, 92, 70, "Output",
 Evaluatable->False,
 CellID->138039833]
}, Open  ]],
Cell[398216, 7932, 125, 3, 70, "ExampleDelimiter",
 CellID->143632515],
Cell[398344, 7937, 85, 1, 70, "ExampleText",
 CellID->1567949747],
Cell[CellGroupData[{
Cell[398454, 7942, 670, 22, 70, "Input",
 CellID->759565492],
Cell[399127, 7966, 6455, 110, 70, "Output",
 Evaluatable->False,
 CellID->313910497]
}, Open  ]],
Cell[405597, 8079, 125, 3, 70, "ExampleDelimiter",
 CellID->191789526],
Cell[405725, 8084, 339, 12, 70, "ExampleText",
 CellID->212237415],
Cell[CellGroupData[{
Cell[406089, 8100, 733, 24, 70, "Input",
 CellID->891467532],
Cell[406825, 8126, 5776, 99, 70, "Output",
 Evaluatable->False,
 CellID->364672452]
}, Open  ]],
Cell[412616, 8228, 125, 3, 70, "ExampleDelimiter",
 CellID->756505851],
Cell[412744, 8233, 346, 12, 70, "ExampleText",
 CellID->550332952],
Cell[CellGroupData[{
Cell[413115, 8249, 756, 24, 70, "Input",
 CellID->1888102640],
Cell[413874, 8275, 9061, 153, 70, "Output",
 Evaluatable->False,
 CellID->11303943]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[422984, 8434, 229, 7, 70, "ExampleSubsection",
 CellID->98687283],
Cell[423216, 8443, 62, 1, 70, "ExampleText",
 CellID->105515030],
Cell[CellGroupData[{
Cell[423303, 8448, 493, 16, 70, "Input",
 CellID->799591503],
Cell[423799, 8466, 5316, 91, 70, "Output",
 Evaluatable->False,
 CellID->203832378]
}, Open  ]],
Cell[429130, 8560, 125, 3, 70, "ExampleDelimiter",
 CellID->112690618],
Cell[429258, 8565, 273, 9, 70, "ExampleText",
 CellID->831074307],
Cell[CellGroupData[{
Cell[429556, 8578, 549, 18, 70, "Input",
 CellID->721166018],
Cell[430108, 8598, 5719, 98, 70, "Output",
 Evaluatable->False,
 CellID->309711126]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[435876, 8702, 234, 7, 70, "ExampleSubsection",
 CellID->9418863],
Cell[436113, 8711, 74, 1, 70, "ExampleText",
 CellID->120622978],
Cell[CellGroupData[{
Cell[436212, 8716, 528, 17, 70, "Input",
 CellID->1175154389],
Cell[436743, 8735, 4861, 84, 70, "Output",
 Evaluatable->False,
 CellID->159785484]
}, Open  ]],
Cell[441619, 8822, 124, 3, 70, "ExampleDelimiter",
 CellID->28545372],
Cell[441746, 8827, 98, 1, 70, "ExampleText",
 CellID->898163183],
Cell[CellGroupData[{
Cell[441869, 8832, 525, 17, 70, "Input",
 CellID->119816638],
Cell[442397, 8851, 4719, 78, 203, "Output",
 CellID->701494910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[447165, 8935, 230, 7, 70, "ExampleSubsection",
 CellID->54978163],
Cell[447398, 8944, 91, 1, 70, "ExampleText",
 CellID->105252621],
Cell[CellGroupData[{
Cell[447514, 8949, 726, 23, 70, "Input",
 CellID->339730340],
Cell[448243, 8974, 10644, 179, 70, "Output",
 Evaluatable->False,
 CellID->317934779]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[458936, 9159, 230, 7, 70, "ExampleSubsection",
 CellID->137908305],
Cell[459169, 9168, 236, 9, 70, "ExampleText",
 CellID->1755279014],
Cell[CellGroupData[{
Cell[459430, 9181, 645, 22, 70, "Input",
 CellID->162516693],
Cell[460078, 9205, 4104, 71, 70, "Output",
 Evaluatable->False,
 CellID->298111672]
}, Open  ]],
Cell[464197, 9279, 124, 3, 70, "ExampleDelimiter",
 CellID->77906239],
Cell[464324, 9284, 232, 9, 70, "ExampleText",
 CellID->1868205896],
Cell[CellGroupData[{
Cell[464581, 9297, 701, 23, 70, "Input",
 CellID->378679323],
Cell[465285, 9322, 4857, 84, 70, "Output",
 Evaluatable->False,
 CellID->498364368]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[470191, 9412, 230, 7, 70, "ExampleSubsection",
 CellID->851719105],
Cell[470424, 9421, 76, 1, 70, "ExampleText",
 CellID->1648054478],
Cell[CellGroupData[{
Cell[470525, 9426, 648, 23, 70, "Input",
 CellID->460721783],
Cell[471176, 9451, 3258, 57, 70, "Output",
 Evaluatable->False,
 CellID->110895757]
}, Open  ]],
Cell[474449, 9511, 121, 3, 70, "ExampleDelimiter",
 CellID->80818],
Cell[474573, 9516, 219, 8, 70, "ExampleText",
 CellID->532228304],
Cell[CellGroupData[{
Cell[474817, 9528, 700, 24, 70, "Input",
 CellID->1672459446],
Cell[475520, 9554, 1538, 29, 70, "Output",
 Evaluatable->False,
 CellID->362844181]
}, Open  ]],
Cell[477073, 9586, 122, 3, 70, "ExampleDelimiter",
 CellID->519034],
Cell[477198, 9591, 61, 1, 70, "ExampleText",
 CellID->1922746645],
Cell[CellGroupData[{
Cell[477284, 9596, 707, 24, 70, "Input",
 CellID->1656487460],
Cell[477994, 9622, 3274, 58, 70, "Output",
 Evaluatable->False,
 CellID->34602797]
}, Open  ]],
Cell[481283, 9683, 125, 3, 70, "ExampleDelimiter",
 CellID->159751802],
Cell[481411, 9688, 91, 1, 70, "ExampleText",
 CellID->1810315125],
Cell[CellGroupData[{
Cell[481527, 9693, 685, 24, 70, "Input",
 CellID->1235429228],
Cell[482215, 9719, 4462, 77, 70, "Output",
 Evaluatable->False,
 CellID->408439953]
}, Open  ]],
Cell[486692, 9799, 125, 3, 70, "ExampleDelimiter",
 CellID->991001078],
Cell[486820, 9804, 88, 1, 70, "ExampleText",
 CellID->825964116],
Cell[CellGroupData[{
Cell[486933, 9809, 1016, 34, 70, "Input",
 CellID->1096667334],
Cell[487952, 9845, 4360, 76, 70, "Output",
 Evaluatable->False,
 CellID->41194458]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[492373, 9928, 227, 7, 70, "ExampleSection",
 CellID->264172455],
Cell[492603, 9937, 85, 1, 70, "ExampleText",
 CellID->1588416969],
Cell[CellGroupData[{
Cell[492713, 9942, 509, 17, 70, "Input",
 CellID->440396275],
Cell[493225, 9961, 1729, 33, 70, "Output",
 Evaluatable->False,
 CellID->237578870]
}, Open  ]],
Cell[494969, 9997, 125, 3, 70, "ExampleDelimiter",
 CellID->393640522],
Cell[495097, 10002, 76, 1, 70, "ExampleText",
 CellID->552011990],
Cell[CellGroupData[{
Cell[495198, 10007, 410, 14, 70, "Input",
 CellID->41991373],
Cell[495611, 10023, 3640, 64, 70, "Output",
 Evaluatable->False,
 CellID->483296162]
}, Open  ]],
Cell[499266, 10090, 56, 1, 70, "ExampleText",
 CellID->136696095],
Cell[CellGroupData[{
Cell[499347, 10095, 456, 15, 70, "Input",
 CellID->17180969],
Cell[499806, 10112, 4570, 79, 70, "Output",
 Evaluatable->False,
 CellID->90496558]
}, Open  ]],
Cell[504391, 10194, 50, 1, 70, "ExampleText",
 CellID->22029998],
Cell[CellGroupData[{
Cell[504466, 10199, 460, 16, 70, "Input",
 CellID->84329592],
Cell[504929, 10217, 2904, 52, 70, "Output",
 Evaluatable->False,
 CellID->102200925]
}, Open  ]],
Cell[507848, 10272, 59, 1, 70, "ExampleText",
 CellID->644647238],
Cell[CellGroupData[{
Cell[507932, 10277, 506, 17, 70, "Input",
 CellID->66914258],
Cell[508441, 10296, 3599, 63, 70, "Output",
 Evaluatable->False,
 CellID->211263166]
}, Open  ]],
Cell[512055, 10362, 57, 1, 70, "ExampleText",
 CellID->267727325],
Cell[CellGroupData[{
Cell[512137, 10367, 550, 18, 70, "Input",
 CellID->513884130],
Cell[512690, 10387, 2373, 43, 70, "Output",
 Evaluatable->False,
 CellID->9627212]
}, Open  ]],
Cell[515078, 10433, 64, 1, 70, "ExampleText",
 CellID->240324382],
Cell[CellGroupData[{
Cell[515167, 10438, 597, 19, 70, "Input",
 CellID->728823031],
Cell[515767, 10459, 2696, 48, 70, "Output",
 Evaluatable->False,
 CellID->121344614]
}, Open  ]],
Cell[518478, 10510, 125, 3, 70, "ExampleDelimiter",
 CellID->692718249],
Cell[518606, 10515, 68, 1, 70, "ExampleText",
 CellID->5583065],
Cell[518677, 10518, 573, 21, 70, "Input",
 CellID->6853300],
Cell[CellGroupData[{
Cell[519275, 10543, 649, 21, 70, "Input",
 CellID->640275383],
Cell[519927, 10566, 8474, 143, 70, "Output",
 Evaluatable->False,
 CellID->60422152]
}, Open  ]],
Cell[528416, 10712, 124, 3, 70, "ExampleDelimiter",
 CellID->99670882],
Cell[528543, 10717, 83, 1, 70, "ExampleText",
 CellID->559707777],
Cell[CellGroupData[{
Cell[528651, 10722, 429, 14, 70, "Input",
 CellID->20938958],
Cell[529083, 10738, 4685, 81, 70, "Output",
 Evaluatable->False,
 CellID->692932592]
}, Open  ]],
Cell[CellGroupData[{
Cell[533805, 10824, 676, 23, 70, "Input",
 CellID->97517862],
Cell[534484, 10849, 2871, 51, 70, "Output",
 Evaluatable->False,
 CellID->716309703]
}, Open  ]],
Cell[CellGroupData[{
Cell[537392, 10905, 1096, 35, 70, "Input",
 CellID->234782973],
Cell[538491, 10942, 4352, 76, 70, "Output",
 Evaluatable->False,
 CellID->858158454]
}, Open  ]],
Cell[542858, 11021, 124, 3, 70, "ExampleDelimiter",
 CellID->17922501],
Cell[542985, 11026, 84, 1, 70, "ExampleText",
 CellID->929304730],
Cell[CellGroupData[{
Cell[543094, 11031, 457, 15, 70, "Input",
 CellID->1285679827],
Cell[543554, 11048, 2547, 46, 70, "Output",
 Evaluatable->False,
 CellID->127593342]
}, Open  ]],
Cell[546116, 11097, 125, 3, 70, "ExampleDelimiter",
 CellID->729606211],
Cell[546244, 11102, 93, 1, 70, "ExampleText",
 CellID->251967833],
Cell[CellGroupData[{
Cell[546362, 11107, 390, 13, 70, "Input",
 CellID->18917],
Cell[546755, 11122, 1394, 44, 82, "Output",
 CellID->60629050]
}, Open  ]],
Cell[548164, 11169, 96, 1, 70, "ExampleText",
 CellID->470272964],
Cell[CellGroupData[{
Cell[548285, 11174, 682, 22, 70, "Input",
 CellID->113960094],
Cell[548970, 11198, 2204, 40, 70, "Output",
 Evaluatable->False,
 CellID->111368024]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[551223, 11244, 237, 7, 70, "ExampleSection",
 CellID->465324047],
Cell[551463, 11253, 220, 7, 70, "ExampleText",
 CellID->252222440],
Cell[CellGroupData[{
Cell[551708, 11264, 693, 23, 70, "Input",
 CellID->88084274],
Cell[552404, 11289, 19323, 327, 190, "Output",
 CellID->2113138950]
}, Open  ]],
Cell[571742, 11619, 124, 3, 70, "ExampleDelimiter",
 CellID->92078925],
Cell[571869, 11624, 208, 8, 70, "ExampleText",
 CellID->1541735666],
Cell[CellGroupData[{
Cell[572102, 11636, 739, 25, 70, "Input",
 CellID->208559390],
Cell[572844, 11663, 28022, 464, 70, "Output",
 Evaluatable->False,
 CellID->134957417]
}, Open  ]],
Cell[600881, 12130, 124, 3, 70, "ExampleDelimiter",
 CellID->78086410],
Cell[601008, 12135, 359, 13, 70, "ExampleText",
 CellID->2137104422],
Cell[CellGroupData[{
Cell[601392, 12152, 702, 24, 70, "Input",
 CellID->2083640414],
Cell[602097, 12178, 36450, 672, 70, "Output",
 CellID->1395360385]
}, Open  ]],
Cell[CellGroupData[{
Cell[638584, 12855, 896, 29, 70, "Input",
 CellID->1300565455],
Cell[639483, 12886, 51960, 856, 70, "Output",
 Evaluatable->False,
 CellID->9669885]
}, Open  ]],
Cell[691458, 13745, 125, 3, 70, "ExampleDelimiter",
 CellID->196824387],
Cell[691586, 13750, 225, 8, 70, "ExampleText",
 CellID->1276959983],
Cell[CellGroupData[{
Cell[691836, 13762, 923, 29, 70, "Input",
 CellID->2062349810],
Cell[692762, 13793, 15284, 255, 70, "Output",
 Evaluatable->False,
 CellID->681999243]
}, Open  ]],
Cell[CellGroupData[{
Cell[708083, 14053, 918, 29, 70, "Input",
 CellID->1416377100],
Cell[709004, 14084, 8651, 146, 70, "Output",
 Evaluatable->False,
 CellID->493602478]
}, Open  ]],
Cell[717670, 14233, 124, 3, 70, "ExampleDelimiter",
 CellID->38551197],
Cell[717797, 14238, 239, 8, 70, "ExampleText",
 CellID->338007888],
Cell[CellGroupData[{
Cell[718061, 14250, 870, 28, 70, "Input",
 CellID->9341621],
Cell[718934, 14280, 19301, 321, 70, "Output",
 Evaluatable->False,
 CellID->194132647]
}, Open  ]],
Cell[738250, 14604, 125, 3, 70, "ExampleDelimiter",
 CellID->574934350],
Cell[738378, 14609, 348, 13, 70, "ExampleText",
 CellID->215155923],
Cell[CellGroupData[{
Cell[738751, 14626, 709, 23, 70, "Input",
 CellID->69201702],
Cell[739463, 14651, 695, 24, 51, "Output",
 CellID->136492029]
}, Open  ]],
Cell[CellGroupData[{
Cell[740195, 14680, 716, 23, 70, "Input",
 CellID->931932869],
Cell[740914, 14705, 176, 5, 36, "Output",
 CellID->535857987]
}, Open  ]],
Cell[741105, 14713, 67, 1, 70, "ExampleText",
 CellID->124722570],
Cell[CellGroupData[{
Cell[741197, 14718, 546, 18, 70, "Input",
 CellID->696423687],
Cell[741746, 14738, 3234, 57, 70, "Output",
 Evaluatable->False,
 CellID->144931559]
}, Open  ]],
Cell[744995, 14798, 125, 3, 70, "ExampleDelimiter",
 CellID->615229212],
Cell[745123, 14803, 474, 18, 70, "ExampleText",
 CellID->85593649],
Cell[CellGroupData[{
Cell[745622, 14825, 619, 19, 70, "Input",
 CellID->40884941],
Cell[746244, 14846, 1635, 53, 58, "Output",
 CellID->590582061]
}, Open  ]],
Cell[CellGroupData[{
Cell[747916, 14904, 621, 19, 70, "Input",
 CellID->269941188],
Cell[748540, 14925, 373, 12, 36, "Output",
 CellID->203871822]
}, Open  ]],
Cell[CellGroupData[{
Cell[748950, 14942, 622, 19, 70, "Input",
 CellID->28444876],
Cell[749575, 14963, 373, 12, 36, "Output",
 CellID->272740813]
}, Open  ]],
Cell[749963, 14978, 125, 3, 70, "ExampleDelimiter",
 CellID->453027011],
Cell[750091, 14983, 234, 8, 70, "ExampleText",
 CellID->530728075],
Cell[CellGroupData[{
Cell[750350, 14995, 497, 15, 70, "Input",
 CellID->97890929],
Cell[750850, 15012, 2058, 68, 143, "Output",
 CellID->603872463]
}, Open  ]],
Cell[752923, 15083, 231, 8, 70, "ExampleText",
 CellID->53708313],
Cell[CellGroupData[{
Cell[753179, 15095, 503, 15, 70, "Input",
 CellID->78905639],
Cell[753685, 15112, 313, 11, 51, "Output",
 CellID->99948407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[754047, 15129, 225, 7, 70, "ExampleSection",
 CellID->8929],
Cell[754275, 15138, 224, 7, 70, "ExampleText",
 CellID->35219074],
Cell[CellGroupData[{
Cell[754524, 15149, 407, 14, 70, "Input",
 CellID->474399871],
Cell[754934, 15165, 420, 14, 193, "Output",
 CellID->414266998]
}, Open  ]],
Cell[755369, 15182, 229, 8, 70, "ExampleText",
 CellID->326766167],
Cell[CellGroupData[{
Cell[755623, 15194, 408, 14, 70, "Input",
 CellID->276849339],
Cell[756034, 15210, 4038, 79, 70, "Output",
 CellID->397715402]
}, Open  ]],
Cell[760087, 15292, 124, 3, 70, "ExampleDelimiter",
 CellID->98316132],
Cell[760214, 15297, 115, 3, 70, "ExampleText",
 CellID->313066817],
Cell[CellGroupData[{
Cell[760354, 15304, 503, 16, 70, "Input",
 CellID->21001530],
Cell[760860, 15322, 2355, 43, 70, "Output",
 Evaluatable->False,
 CellID->28537895]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[763264, 15371, 224, 7, 70, "ExampleSection",
 CellID->10583],
Cell[763491, 15380, 85, 1, 70, "ExampleText",
 CellID->128511864],
Cell[CellGroupData[{
Cell[763601, 15385, 503, 17, 70, "Input",
 CellID->378854997],
Cell[764107, 15404, 6719, 114, 70, "Output",
 Evaluatable->False,
 CellID->197859495]
}, Open  ]],
Cell[CellGroupData[{
Cell[770863, 15523, 785, 25, 70, "Input",
 CellID->9906228],
Cell[771651, 15550, 8437, 142, 70, "Output",
 Evaluatable->False,
 CellID->1460995]
}, Open  ]],
Cell[780103, 15695, 124, 3, 70, "ExampleDelimiter",
 CellID->16419192],
Cell[780230, 15700, 69, 1, 70, "ExampleText",
 CellID->58123718],
Cell[780302, 15703, 848, 30, 70, "Input",
 CellID->229769265],
Cell[781153, 15735, 400, 13, 70, "Input",
 CellID->699561132],
Cell[CellGroupData[{
Cell[781578, 15752, 383, 12, 70, "Input",
 CellID->163583367],
Cell[781964, 15766, 6994, 119, 70, "Output",
 Evaluatable->False,
 CellID->3355276]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[789019, 15892, 310, 9, 70, "SeeAlsoSection",
 CellID->3297],
Cell[789332, 15903, 1962, 71, 70, "SeeAlso",
 CellID->5425]
}, Open  ]],
Cell[CellGroupData[{
Cell[791331, 15979, 305, 8, 70, "RelatedLinksSection"],
Cell[791639, 15989, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[792041, 16006, 319, 9, 70, "MoreAboutSection",
 CellID->407036638],
Cell[792363, 16017, 155, 3, 70, "MoreAbout",
 CellID->547448184],
Cell[792521, 16022, 150, 3, 70, "MoreAbout",
 CellID->97124914],
Cell[792674, 16027, 174, 3, 70, "MoreAbout",
 CellID->752270413],
Cell[792851, 16032, 179, 3, 70, "MoreAbout",
 CellID->221095387],
Cell[793033, 16037, 179, 3, 70, "MoreAbout",
 CellID->249860298]
}, Open  ]],
Cell[793227, 16043, 27, 0, 70, "History"],
Cell[793257, 16045, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

