(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29629,       1052]
NotebookOptionsPosition[     22319,        805]
NotebookOutlinePosition[     24079,        852]
CellTagsIndexPosition[     23953,        846]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Contexts" :> Documentation`HelpLookup["paclet:tutorial/Contexts"], 
          "Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematica Packages\"\>", 
       2->"\<\"Contexts\"\>", 
       3->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], 
          "ClearAll" :> Documentation`HelpLookup["paclet:ref/ClearAll"], 
          "Names" :> Documentation`HelpLookup["paclet:ref/Names"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Clear\"\>", 2->"\<\"ClearAll\"\>", 
       3->"\<\"Names\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Atomic Elements of Expressions\"\>", 
       3->"\<\"Memory Measurement & Optimization\"\>", 
       4->"\<\"Namespace Management\"\>", 5->"\<\"Symbol Handling\"\>", 
       6->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Remove", "ObjectName",
 CellID->22677],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Remove",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Remove"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["symbol", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes symbols completely, so that their names are no \
longer recognized by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Remove",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Remove"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes all symbols whose names match any of the string \
patterns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27658]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 " to get rid of symbols that you do not need, and which may shadow symbols \
in contexts later on your context path. "
}], "Notes",
 CellID->5107],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " allows the following metacharacters:"
}], "Notes",
 CellID->30223],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "match zero or more characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "@", Cell[
    "match one or more characters, but not upper-case letters", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->439942953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)*\>\"", "]"}]], "InlineFormula"],
 " removes all symbols in a particular context. "
}], "Notes",
 CellID->37],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11057],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 " does not affect symbols with the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22224],

Cell["\<\
Once you have removed a symbol, you will never be able to refer to it again, \
unless you recreate it. \
\>", "Notes",
 CellID->8568],

Cell[TextData[{
 "If you have an expression that contains a symbol which you remove, the \
removed symbol will be printed as ",
 Cell[BoxData[
  RowBox[{"Removed", "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 ", where its name is given in a string. "
}], "Notes",
 CellID->3378]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420043914],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->92595116],

Cell[BoxData[
 RowBox[{"Remove", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124283790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4925165],

Cell[BoxData[
 RowBox[{
  RowBox[{"Information", "::", "\<\"notfound\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"x\\\"\\) not found. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/notfound\\\", ButtonNote -> \
\\\"Information::notfound\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->92193822]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->432362370],

Cell["Remove all symbols in a given context:", "ExampleText",
 CellID->198620288],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21451926],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130572274],

Cell["Specify symbols to remove as string patterns:", "ExampleText",
 CellID->222778793],

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", "1"}], ";", 
  RowBox[{"x2", "=", "3"}], ";", 
  RowBox[{"y", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168901340],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237737555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "x*"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->353929966],

Cell[BoxData[
 RowBox[{
  RowBox[{"Information", "::", "\<\"nomatch\"\>"}], ":", 
  " ", "\<\"No symbol matching \\!\\(\\\"x*\\\"\\) found. \\!\\(\\*ButtonBox[\
\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Information/nomatch\\\", ButtonNote -> \
\\\"Information::nomatch\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->128749370]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->63096772],

Cell["\<\
If a symbol from a package is used before the package is loaded, an extra \
symbol is created:\
\>", "ExampleText",
 CellID->433323409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33197795],

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183209999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->136684068],

Cell[BoxData[
 RowBox[{
  RowBox[{"BarChart", "::", "\<\"shdw\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"BarChart\\\"\\) appears in multiple contexts \\!\
\\({\\\"BarCharts`\\\", \\\"Global`\\\"}\\); definitions in context \
\\!\\(\\\"BarCharts`\\\"\\) may shadow or be shadowed by other definitions.\"\
\>"}]], "Message", "MSG",
 CellID->440572383]
}, Open  ]],

Cell["The extra symbol should be removed:", "ExampleText",
 CellID->294187348],

Cell[BoxData[
 RowBox[{"Remove", "[", "Global`BarChart", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->803478745],

Cell["Only the correct symbol from the package remains:", "ExampleText",
 CellID->156719868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->195900203],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMFO4zAQdZsUTogVJ458AexyBVROcKEFhFSthFgRIaT2gFgBH9Cv2fOK
P+JLykziqM60adzQphP6qtb2xJ7n58nEjqdtOtFb//Epehs8RHvnL9Hf/uDh
de/s+YUOBQ1jGn1jzMeuofKISvGHXwP6JEVZalMaULMu5SHlHStfc22Q6o/M
z7j1qTjadWRKzdWM+nyUywL5wnL7NVVb9smtmyS6KMzt0Eu7M2UEzVztuHU4
lict0Mnot610ZfPuTGv/EEc56RXUmMAONy06rbjHVr5mZhzhxMjCFWly/ps+
jVJ9bcfywf7N3e0/epsjTli29Yklh8OhrT+O60nO1I/1Zf32VH2BX1fWji9t
jBKPlf6jg6m8HsBqNismpYeNThuBFVitDyvMCGAFVmCFGQGswAqsMCOAVVWx
BTdOxbLeOEM2arMpODbBuTLOLRK3FHJlv62L/0qO+qOQm9a6OpnqnGn1ssL9
BFiBFVhhRgArsAIrzAhgBVZghRkBrKqKhyRZ8pKxML1xHMk0DpHU4BdlfrzT
2F6b1HcWxYua0NucpJglbHj/RS7RWvbr8yvCxfQk5xjtqAyqnSNQ64QKjwIq
PAqomlHhUYtDzd+/xPLS7rTkveSGkGV9db3y3uHPNxojn+DqzqPcASx/R5D3
jb7mqw5zI1DrggqPAio8Cqg49+uBGnp+j7GgOzm7/3AENZHszE7ARv+POZm7
v4nnKBSO832luPM+bcAT1SOO74ckPX/ZWqykk9l31YLFYfH6aMF28q4hL3ro
u/4kWZIW/ePID9M39vffC02uvHKc5ThKVJa/YkV3zS76r878a3he5E2fd+Ia
hcXrpQXbweLltQLj9+y+1e4yl7Z7ddao1lTMdJ1vi938PNEBtwUnvZJjcnRn
7IvHraRHjGu4JJ/OaRqfnetlFA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18644205]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->225277915],

Cell["\<\
If a symbol is removed, all of its properties and definitions are removed as \
well:\
\>", "ExampleText",
 CellID->790821080],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->440961248],

Cell[BoxData[
 RowBox[{"Remove", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1015309270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->539651915],

Cell[BoxData[
 RowBox[{
  RowBox[{"Information", "::", "\<\"notfound\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"f\\\"\\) not found. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/notfound\\\", ButtonNote -> \
\\\"Information::notfound\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->664385899]
}, Open  ]],

Cell["\<\
Using the same symbol again creates a new one without any of its old \
properties:\
\>", "ExampleText",
 CellID->49632634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->173033675],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->334201085]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355316602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClearAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAll"]], "InlineFormula"],
 " also removes all properties and definitions, but leaves the symbol \
intact:"
}], "ExampleText",
 CellID->17550964],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->327327101],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->401406030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->59669195],

Cell["Cell$$6019`f", "Print", "PrintUsage",
 CellTags->"Info3381660111-9312229",
 CellID->774846969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76884530],

Cell[TextData[{
 "If an expression still refers to a removed symbol, those places are denoted \
with ",
 Cell[BoxData["Removed"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->407600683],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246728590],

Cell[BoxData[
 RowBox[{"Remove", "[", "y", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->378227833],

Cell[CellGroupData[{

Cell[BoxData["expr"], "Input",
 CellLabel->"In[3]:=",
 CellID->138647508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[
    RowBox[{"Removed", "[", "\<\"y\"\>", "]"}],
    False,
    Editable->False], ",", "z"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->294381059]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->438516302],

Cell["Protected symbols cannot be removed:", "ExampleText",
 CellID->138137824],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "x", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->354007221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Remove", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->812009204],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "::", "\<\"rmptc\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(x\\) is Protected and cannot be removed. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Remove/rmptc\\\", \
ButtonNote -> \\\"Remove::rmptc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->33690645]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unprotect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unprotect"]], "InlineFormula"],
 " to remove protected symbols:"
}], "ExampleText",
 CellID->503028240],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "x", "]"}], ";"}], "\n", 
 RowBox[{"Remove", "[", "x", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->152175712]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4845],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3289]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32736],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->31603],

Cell[TextData[ButtonBox["Contexts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Contexts"]], "Tutorials",
 CellID->28243],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->924]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->495765249],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->78016658],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->65583472],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->596484917],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->12270858],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->271621596]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Remove - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 20.4571536}", "context" -> "System`", 
    "keywords" -> {
     "cleaning up", "clearing symbols", "context shadowing", "definitions", 
      "inert functions", "name space conflicts", 
      "removing symbol table entries", "symbol table", "symbols", 
      "workspace"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Remove[symbol_1, ...] removes symbols completely, so that their names \
are no longer recognized by Mathematica. Remove[\"SubscriptBox[ form, 1]\", \
\"SubscriptBox[ form, 2]\", ...] removes all symbols whose names match any of \
the string patterns form_i. ", "synonyms" -> {}, "title" -> "Remove", "type" -> 
    "Symbol", "uri" -> "ref/Remove"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8077, 257, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->420043914]},
 "Info3381660111-9312229"->{
  Cell[16412, 570, 100, 2, 70, "Print",
   CellTags->"Info3381660111-9312229",
   CellID->774846969]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23678, 835},
 {"Info3381660111-9312229", 23827, 839}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3025, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3648, 95, 44, 1, 70, "ObjectName",
 CellID->22677],
Cell[3695, 98, 1372, 43, 70, "Usage",
 CellID->27658]
}, Open  ]],
Cell[CellGroupData[{
Cell[5104, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5582, 163, 295, 9, 70, "Notes",
 CellID->5107],
Cell[5880, 174, 273, 9, 70, "Notes",
 CellID->30223],
Cell[6156, 185, 487, 11, 70, "2ColumnTableMod",
 CellID->439942953],
Cell[6646, 198, 301, 10, 70, "Notes",
 CellID->37],
Cell[6950, 210, 291, 12, 70, "Notes",
 CellID->11057],
Cell[7244, 224, 335, 12, 70, "Notes",
 CellID->22224],
Cell[7582, 238, 143, 4, 70, "Notes",
 CellID->8568],
Cell[7728, 244, 312, 8, 70, "Notes",
 CellID->3378]
}, Closed]],
Cell[CellGroupData[{
Cell[8077, 257, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420043914],
Cell[CellGroupData[{
Cell[8462, 271, 147, 5, 70, "ExampleSection",
 CellID->92595116],
Cell[8612, 278, 102, 3, 70, "Input",
 CellID->124283790],
Cell[CellGroupData[{
Cell[8739, 285, 85, 3, 70, "Input",
 CellID->4925165],
Cell[8827, 290, 379, 7, 70, "Message",
 CellID->92193822]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9255, 303, 243, 7, 70, "ExampleSection",
 CellID->432362370],
Cell[9501, 312, 81, 1, 70, "ExampleText",
 CellID->198620288],
Cell[9585, 315, 116, 3, 70, "Input",
 CellID->21451926],
Cell[9704, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->130572274],
Cell[9832, 325, 88, 1, 70, "ExampleText",
 CellID->222778793],
Cell[9923, 328, 178, 6, 70, "Input",
 CellID->168901340],
Cell[10104, 336, 111, 3, 70, "Input",
 CellID->237737555],
Cell[CellGroupData[{
Cell[10240, 343, 88, 3, 70, "Input",
 CellID->353929966],
Cell[10331, 348, 390, 7, 70, "Message",
 CellID->128749370]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10770, 361, 226, 7, 70, "ExampleSection",
 CellID->63096772],
Cell[10999, 370, 145, 4, 70, "ExampleText",
 CellID->433323409],
Cell[CellGroupData[{
Cell[11169, 378, 170, 5, 70, "Input",
 CellID->33197795],
Cell[11342, 385, 250, 8, 36, "Output",
 CellID->183209999]
}, Open  ]],
Cell[CellGroupData[{
Cell[11629, 398, 118, 3, 70, "Input",
 CellID->136684068],
Cell[11750, 403, 349, 7, 70, "Message",
 CellID->440572383]
}, Open  ]],
Cell[12114, 413, 78, 1, 70, "ExampleText",
 CellID->294187348],
Cell[12195, 416, 116, 3, 70, "Input",
 CellID->803478745],
Cell[12314, 421, 92, 1, 70, "ExampleText",
 CellID->156719868],
Cell[CellGroupData[{
Cell[12431, 426, 171, 5, 70, "Input",
 CellID->195900203],
Cell[12605, 433, 1155, 23, 70, "Output",
 Evaluatable->False,
 CellID->18644205]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13809, 462, 237, 7, 70, "ExampleSection",
 CellID->225277915],
Cell[14049, 471, 135, 4, 70, "ExampleText",
 CellID->790821080],
Cell[14187, 477, 246, 8, 70, "Input",
 CellID->440961248],
Cell[14436, 487, 103, 3, 70, "Input",
 CellID->1015309270],
Cell[CellGroupData[{
Cell[14564, 494, 87, 3, 70, "Input",
 CellID->539651915],
Cell[14654, 499, 380, 7, 70, "Message",
 CellID->664385899]
}, Open  ]],
Cell[15049, 509, 132, 4, 70, "ExampleText",
 CellID->49632634],
Cell[CellGroupData[{
Cell[15206, 517, 106, 3, 70, "Input",
 CellID->173033675],
Cell[15315, 522, 231, 8, 36, "Output",
 CellID->334201085]
}, Open  ]],
Cell[15561, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->355316602],
Cell[15689, 538, 253, 8, 70, "ExampleText",
 CellID->17550964],
Cell[15945, 548, 246, 8, 70, "Input",
 CellID->327327101],
Cell[16194, 558, 104, 3, 70, "Input",
 CellID->401406030],
Cell[CellGroupData[{
Cell[16323, 565, 86, 3, 70, "Input",
 CellID->59669195],
Cell[16412, 570, 100, 2, 70, "Print",
 CellTags->"Info3381660111-9312229",
 CellID->774846969]
}, Open  ]],
Cell[16527, 575, 124, 3, 70, "ExampleDelimiter",
 CellID->76884530],
Cell[16654, 580, 191, 6, 70, "ExampleText",
 CellID->407600683],
Cell[16848, 588, 172, 6, 70, "Input",
 CellID->246728590],
Cell[17023, 596, 102, 3, 70, "Input",
 CellID->378227833],
Cell[CellGroupData[{
Cell[17150, 603, 73, 2, 70, "Input",
 CellID->138647508],
Cell[17226, 607, 302, 11, 36, "Output",
 CellID->294381059]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17577, 624, 230, 7, 70, "ExampleSection",
 CellID->438516302],
Cell[17810, 633, 79, 1, 70, "ExampleText",
 CellID->138137824],
Cell[17892, 636, 174, 6, 70, "Input",
 CellID->354007221],
Cell[CellGroupData[{
Cell[18091, 646, 102, 3, 70, "Input",
 CellID->812009204],
Cell[18196, 651, 376, 7, 70, "Message",
 CellID->33690645]
}, Open  ]],
Cell[18587, 661, 217, 8, 70, "ExampleText",
 CellID->503028240],
Cell[18807, 671, 168, 5, 70, "Input",
 CellID->152175712]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19024, 682, 310, 9, 70, "SeeAlsoSection",
 CellID->4845],
Cell[19337, 693, 683, 26, 70, "SeeAlso",
 CellID->3289]
}, Open  ]],
Cell[CellGroupData[{
Cell[20057, 724, 314, 9, 70, "TutorialsSection",
 CellID->32736],
Cell[20374, 735, 280, 9, 70, "Tutorials",
 CellID->31603],
Cell[20657, 746, 127, 3, 70, "Tutorials",
 CellID->28243],
Cell[20787, 751, 189, 4, 70, "Tutorials",
 CellID->924]
}, Open  ]],
Cell[CellGroupData[{
Cell[21013, 760, 299, 8, 70, "MoreAboutSection"],
Cell[21315, 770, 134, 3, 70, "MoreAbout",
 CellID->495765249],
Cell[21452, 775, 168, 3, 70, "MoreAbout",
 CellID->78016658],
Cell[21623, 780, 176, 3, 70, "MoreAbout",
 CellID->65583472],
Cell[21802, 785, 151, 3, 70, "MoreAbout",
 CellID->596484917],
Cell[21956, 790, 140, 3, 70, "MoreAbout",
 CellID->12270858],
Cell[22099, 795, 148, 3, 70, "MoreAbout",
 CellID->271621596]
}, Open  ]],
Cell[22262, 801, 27, 0, 70, "History"],
Cell[22292, 803, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

