(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15930,        573]
NotebookOptionsPosition[     12131,        444]
NotebookOutlinePosition[     13494,        482]
CellTagsIndexPosition[     13409,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CopyDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CopyDirectory"], 
          "CreateDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CreateDirectory"], 
          "DeleteDirectory" :> 
          Documentation`HelpLookup["paclet:ref/DeleteDirectory"], 
          "RenameFile" :> 
          Documentation`HelpLookup["paclet:ref/RenameFile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CopyDirectory\"\>", 
       2->"\<\"CreateDirectory\"\>", 3->"\<\"DeleteDirectory\"\>", 
       4->"\<\"RenameFile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RenameDirectory", "ObjectName",
 CellID->2186],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RenameDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RenameDirectory"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]renames the directory ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18794]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " must already exist; ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " must not. "
}], "Notes",
 CellID->2613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RenameDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RenameDirectory"]], "InlineFormula"],
 " sets the modification date for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " to be the same as for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26047],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RenameDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RenameDirectory"]], "InlineFormula"],
 " returns the full new directory name, or ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if the directory cannot be renamed. "
}], "Notes",
 CellID->16591]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->738720705],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->375378165],

Cell["Copy a directory:", "ExampleText",
 CellID->4147619],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", 
   RowBox[{
   "$InstallationDirectory", "<>", 
    "\"\</SystemFiles/Kernel/TextResources/English\>\""}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270696185],

Cell[BoxData[
 RowBox[{
  RowBox[{"cdir1", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39535821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CopyDirectory", "[", 
  RowBox[{"dir", ",", "cdir1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18623894],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1\"\>"], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->218468912]
}, Open  ]],

Cell["List of files in the directory:", "ExampleText",
 CellID->517405236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->131730757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1\\\\FunctionInformation.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1\\\\Messages.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1\\\\Usage.m\"\>"}], "}"}]], "Output",
 ImageSize->{571, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->373692550]
}, Open  ]],

Cell["Rename the directory: ", "ExampleText",
 CellID->450614725],

Cell[BoxData[
 RowBox[{
  RowBox[{"cdir2", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test2\>\""}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16490388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RenameDirectory", "[", 
  RowBox[{"cdir1", ",", "cdir2"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->137769795],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test2\"\>"], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->270642002]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir1"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->79281089],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->152313231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir2"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->40533896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test2\\\\FunctionInformation.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test2\\\\Messages.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test2\\\\Usage.m\"\>"}], "}"}]], "Output",
 ImageSize->{571, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->118449763]
}, Open  ]],

Cell["Delete the directory: ", "ExampleText",
 CellID->24757972],

Cell[BoxData[
 RowBox[{"DeleteDirectory", "[", 
  RowBox[{"cdir2", ",", 
   RowBox[{"DeleteContents", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->539433362]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->785],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CopyDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CopyDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RenameFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RenameFile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23893]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20548],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->17128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->890497819],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->25130763]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RenameDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 21.2540490}", "context" -> "System`", 
    "keywords" -> {
     "directory name", "move directory", "file utilities", "file operations"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RenameDirectory[\"SubscriptBox[ dir, 1]\", \"SubscriptBox[ dir, 2]\"] \
renames the directory dir_1 to dir_2. ", 
    "synonyms" -> {"rename directory", "mv -r"}, "title" -> "RenameDirectory",
     "type" -> "Symbol", "uri" -> "ref/RenameDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5512, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->738720705]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13266, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2251, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2874, 84, 52, 1, 70, "ObjectName",
 CellID->2186],
Cell[2929, 87, 904, 29, 70, "Usage",
 CellID->18794]
}, Open  ]],
Cell[CellGroupData[{
Cell[3870, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4348, 138, 288, 12, 70, "Notes",
 CellID->2613],
Cell[4639, 152, 452, 17, 70, "Notes",
 CellID->26047],
Cell[5094, 171, 381, 12, 70, "Notes",
 CellID->16591]
}, Closed]],
Cell[CellGroupData[{
Cell[5512, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->738720705],
Cell[CellGroupData[{
Cell[5897, 202, 148, 5, 70, "ExampleSection",
 CellID->375378165],
Cell[6048, 209, 58, 1, 70, "ExampleText",
 CellID->4147619],
Cell[6109, 212, 215, 7, 70, "Input",
 CellID->270696185],
Cell[6327, 221, 165, 5, 70, "Input",
 CellID->39535821],
Cell[CellGroupData[{
Cell[6517, 230, 137, 4, 28, "Input",
 CellID->18623894],
Cell[6657, 236, 240, 6, 36, "Output",
 CellID->218468912]
}, Open  ]],
Cell[6912, 245, 74, 1, 70, "ExampleText",
 CellID->517405236],
Cell[CellGroupData[{
Cell[7011, 250, 140, 4, 70, "Input",
 CellID->131730757],
Cell[7154, 256, 515, 12, 71, "Output",
 CellID->373692550]
}, Open  ]],
Cell[7684, 271, 65, 1, 70, "ExampleText",
 CellID->450614725],
Cell[7752, 274, 165, 5, 70, "Input",
 CellID->16490388],
Cell[CellGroupData[{
Cell[7942, 283, 142, 4, 70, "Input",
 CellID->137769795],
Cell[8087, 289, 240, 6, 36, "Output",
 CellID->270642002]
}, Open  ]],
Cell[CellGroupData[{
Cell[8364, 300, 139, 4, 70, "Input",
 CellID->79281089],
Cell[8506, 306, 175, 6, 36, "Output",
 CellID->152313231]
}, Open  ]],
Cell[CellGroupData[{
Cell[8718, 317, 139, 4, 70, "Input",
 CellID->40533896],
Cell[8860, 323, 515, 12, 71, "Output",
 CellID->118449763]
}, Open  ]],
Cell[9390, 338, 64, 1, 70, "ExampleText",
 CellID->24757972],
Cell[9457, 341, 189, 5, 70, "Input",
 CellID->539433362]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9695, 352, 309, 9, 70, "SeeAlsoSection",
 CellID->785],
Cell[10007, 363, 983, 35, 70, "SeeAlso",
 CellID->23893]
}, Open  ]],
Cell[CellGroupData[{
Cell[11027, 403, 314, 9, 70, "TutorialsSection",
 CellID->20548],
Cell[11344, 414, 178, 4, 70, "Tutorials",
 CellID->17128]
}, Open  ]],
Cell[CellGroupData[{
Cell[11559, 423, 319, 9, 70, "MoreAboutSection",
 CellID->890497819],
Cell[11881, 434, 178, 3, 70, "MoreAbout",
 CellID->25130763]
}, Open  ]],
Cell[12074, 440, 27, 0, 70, "History"],
Cell[12104, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

