(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14929,        525]
NotebookOptionsPosition[     11701,        418]
NotebookOutlinePosition[     13061,        456]
CellTagsIndexPosition[     12976,        451]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Repeated Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/RepeatedPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Repeated Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Repeated" :> Documentation`HelpLookup["paclet:ref/Repeated"], 
          "BlankNullSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankNullSequence"], 
          "PatternSequence" :> 
          Documentation`HelpLookup["paclet:ref/PatternSequence"], "Longest" :> 
          Documentation`HelpLookup["paclet:ref/Longest"], "Shortest" :> 
          Documentation`HelpLookup["paclet:ref/Shortest"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Repeated\"\>", 
       2->"\<\"BlankNullSequence\"\>", 3->"\<\"PatternSequence\"\>", 
       4->"\<\"Longest\"\>", 5->"\<\"Shortest\"\>", 
       6->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"New in 6.0: Core Language\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "RepeatedNull ",
 StyleBox["(...)", "OperatorCharacter"]
}], "ObjectName",
 CellID->13108],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], "..."}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["RepeatedNull",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RepeatedNull"], "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object which represents a sequence of zero \
or more expressions, each matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16873]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "..."}]], "InlineFormula"],
 " can appear as an argument of any function. It represents any sequence of \
arguments. "
}], "Notes",
 CellID->9409],

Cell[TextData[{
 "All the objects in the sequence represented by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "..."}]], "InlineFormula"],
 " must match ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ", but the objects need not be identical. "
}], "Notes",
 CellID->16772],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " may, but need not, itself be a pattern object. "
}], "Notes",
 CellID->1225]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265898655],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->252316337],

Cell[TextData[{
 "Replace any list of zero or more ",
 Cell[BoxData["a"], "InlineFormula"],
 "'s by ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", "a", "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "..."}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3733],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27059],

Cell[TextData[{
 "Replace any list of zero or more ",
 Cell[BoxData["f"], "InlineFormula"],
 "'s with one argument:"
}], "ExampleText",
 CellID->21597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"f", "[", "b", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"f", "[", "a", "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b"}], "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"g", "[", "b", "]"}]}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "_", "]"}], "..."}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"g", "[", "b", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24846]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20444],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Repeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Repeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankNullSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankNullSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29187],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Repeated Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepeatedPatterns"]], "Tutorials",
 CellID->14891]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->55319044],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->249765407],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->403054823],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->303137682]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RepeatedNull (...) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 25.9416690}", "context" -> "System`", 
    "keywords" -> {
     "ellipsis", "repeated expression", "RepeatedNull", "zero or more"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "p ... or RepeatedNull[p] is a pattern object which represents a sequence \
of zero or more expressions, each matching p. ", 
    "synonyms" -> {"repeated null", "..."}, "title" -> "RepeatedNull", "type" -> 
    "Symbol", "uri" -> "ref/RepeatedNull"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5449, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->265898655]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12833, 444}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2759, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3382, 89, 107, 4, 70, "ObjectName",
 CellID->13108],
Cell[3492, 95, 722, 23, 70, "Usage",
 CellID->16873]
}, Open  ]],
Cell[CellGroupData[{
Cell[4251, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4729, 140, 212, 7, 70, "Notes",
 CellID->9409],
Cell[4944, 149, 293, 10, 70, "Notes",
 CellID->16772],
Cell[5240, 161, 172, 6, 70, "Notes",
 CellID->1225]
}, Closed]],
Cell[CellGroupData[{
Cell[5449, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265898655],
Cell[CellGroupData[{
Cell[5834, 186, 148, 5, 70, "ExampleSection",
 CellID->252316337],
Cell[5985, 193, 179, 7, 70, "ExampleText",
 CellID->2250],
Cell[CellGroupData[{
Cell[6189, 204, 443, 16, 28, "Input",
 CellID->3733],
Cell[6635, 222, 279, 9, 36, "Output",
 CellID->31108]
}, Open  ]],
Cell[6929, 234, 121, 3, 70, "ExampleDelimiter",
 CellID->27059],
Cell[7053, 239, 151, 5, 70, "ExampleText",
 CellID->21597],
Cell[CellGroupData[{
Cell[7229, 248, 656, 23, 70, "Input",
 CellID->14379],
Cell[7888, 273, 421, 14, 36, "Output",
 CellID->24846]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8370, 294, 311, 9, 70, "SeeAlsoSection",
 CellID->20444],
Cell[8684, 305, 1477, 53, 70, "SeeAlso",
 CellID->10512]
}, Open  ]],
Cell[CellGroupData[{
Cell[10198, 363, 314, 9, 70, "TutorialsSection",
 CellID->29187],
Cell[10515, 374, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[10696, 379, 144, 3, 70, "Tutorials",
 CellID->14891]
}, Open  ]],
Cell[CellGroupData[{
Cell[10877, 387, 318, 9, 70, "MoreAboutSection",
 CellID->55319044],
Cell[11198, 398, 156, 3, 70, "MoreAbout",
 CellID->249765407],
Cell[11357, 403, 128, 3, 70, "MoreAbout",
 CellID->403054823],
Cell[11488, 408, 141, 3, 70, "MoreAbout",
 CellID->303137682]
}, Open  ]],
Cell[11644, 414, 27, 0, 70, "History"],
Cell[11674, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

