(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24772,        908]
NotebookOptionsPosition[     20364,        758]
NotebookOutlinePosition[     21717,        795]
CellTagsIndexPosition[     21632,        790]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReplaceAll" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceAll"], 
          "ReplaceRepeated" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceRepeated"], "Rule" :> 
          Documentation`HelpLookup["paclet:ref/Rule"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], 
          "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], "FreeQ" :> 
          Documentation`HelpLookup["paclet:ref/FreeQ"], "RuleDelayed" :> 
          Documentation`HelpLookup["paclet:ref/RuleDelayed"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReplaceAll\"\>", 
       2->"\<\"ReplaceRepeated\"\>", 3->"\<\"Rule\"\>", 4->"\<\"Set\"\>", 
       5->"\<\"ReplacePart\"\>", 6->"\<\"ReplaceList\"\>", 
       7->"\<\"StringReplace\"\>", 8->"\<\"PolynomialReduce\"\>", 
       9->"\<\"FreeQ\"\>", 10->"\<\"RuleDelayed\"\>", 
       11->"\<\"SparseArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], "Rules" :> 
          Documentation`HelpLookup["paclet:guide/Rules"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Rules\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Replace", "ObjectName",
 CellID->22859],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Replace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Replace"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["rules", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies a rule or list of rules in an attempt to \
transform the entire expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Replace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Replace"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["rules", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies rules to parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The rules must be of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":>", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6547],

Cell[TextData[{
 "A list of rules can be given. The rules are tried in order. The result of \
the first one that applies is returned. If none of the rules apply, the \
original ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is returned. "
}], "Notes",
 CellID->3674],

Cell[TextData[{
 "If the rules are given in nested lists, ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " is effectively mapped onto the inner lists. Thus ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["12", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["21", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Replace", "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["12", "TR"]]}], "}"}]}], "]"}], ",", 
    RowBox[{"Replace", "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["21", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27584],

Cell[TextData[{
 "Delayed rules defined with ",
 Cell[BoxData[":>"], "InlineFormula"],
 " can contain ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions. "
}], "Notes",
 CellID->26251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->10917],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->14488],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineFormula"],
 ", corresponding to the whole expression."
}], "Notes",
 CellID->22763],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->20126],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2543],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->24948],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " includes heads of expressions, and their parts. "
}], "Notes",
 CellID->25197],

Cell[TextData[{
 "Replacements are performed to parts specified by ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " even when those parts have ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " or related wrappers. "
}], "Notes",
 CellID->7452]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114777335],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->900611929],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " by default applies rules only to complete expressions:"
}], "ExampleText",
 CellID->2276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "->", 
    RowBox[{"a", "+", "b"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32671],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2231]
}, Open  ]],

Cell["It does not map down to subparts:", "ExampleText",
 CellID->468565443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "->", 
    RowBox[{"a", "+", "b"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29189],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6445],

Cell["A list of rules gives a list of results:", "ExampleText",
 CellID->11106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "->", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", "->", "b"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23139363]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31808],

Cell["Replace at level 1:", "ExampleText",
 CellID->148399041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "->", 
    RowBox[{"a", "+", "b"}]}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22950],

Cell[BoxData[
 RowBox[{"1", "+", "a", "+", "b"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->815856361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->632050940],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " also works with ",
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->251732077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"x", ":>", 
    RowBox[{"RandomReal", "[", "]"}]}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9214336351868824`", ",", "0.7603317756083712`", ",", 
   "0.8602251208793763`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141921480]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12149],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceRepeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceRepeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RuleDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RuleDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30640],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "Tutorials",
 CellID->15805]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->592007375],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->477649679],

Cell[TextData[ButtonBox["Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Rules"]], "MoreAbout",
 CellID->234314]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Replace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 27.6292122}", "context" -> "System`", 
    "keywords" -> {"apply rules to whole expression"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Replace[expr, rules] applies a rule or list of rules in an attempt to \
transform the entire expression expr. Replace[expr, rules, levelspec] applies \
rules to parts of expr specified by levelspec. ", "synonyms" -> {}, "title" -> 
    "Replace", "type" -> "Symbol", "uri" -> "ref/Replace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11713, 404, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114777335]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21488, 783}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2931, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3554, 91, 45, 1, 70, "ObjectName",
 CellID->22859],
Cell[3602, 94, 1223, 39, 70, "Usage",
 CellID->7347]
}, Open  ]],
Cell[CellGroupData[{
Cell[4862, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5340, 155, 305, 13, 70, "Notes",
 CellID->6547],
Cell[5648, 170, 285, 8, 70, "Notes",
 CellID->3674],
Cell[5936, 180, 1682, 59, 70, "Notes",
 CellID->27584],
Cell[7621, 241, 189, 7, 70, "Notes",
 CellID->26251],
Cell[7813, 250, 201, 7, 70, "Notes",
 CellID->10917],
Cell[8017, 259, 1664, 55, 70, "2ColumnTableMod",
 CellID->14488],
Cell[9684, 316, 376, 14, 70, "Notes",
 CellID->22763],
Cell[10063, 332, 303, 12, 70, "Notes",
 CellID->20126],
Cell[10369, 346, 311, 13, 70, "Notes",
 CellID->2543],
Cell[10683, 361, 189, 6, 70, "Notes",
 CellID->24948],
Cell[10875, 369, 466, 17, 70, "Notes",
 CellID->25197],
Cell[11344, 388, 332, 11, 70, "Notes",
 CellID->7452]
}, Closed]],
Cell[CellGroupData[{
Cell[11713, 404, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114777335],
Cell[CellGroupData[{
Cell[12098, 418, 148, 5, 70, "ExampleSection",
 CellID->900611929],
Cell[12249, 425, 225, 7, 70, "ExampleText",
 CellID->2276],
Cell[CellGroupData[{
Cell[12499, 436, 221, 8, 28, "Input",
 CellID->32671],
Cell[12723, 446, 175, 6, 36, "Output",
 CellID->2231]
}, Open  ]],
Cell[12913, 455, 76, 1, 70, "ExampleText",
 CellID->468565443],
Cell[CellGroupData[{
Cell[13014, 460, 246, 9, 28, "Input",
 CellID->29189],
Cell[13263, 471, 198, 7, 36, "Output",
 CellID->776]
}, Open  ]],
Cell[13476, 481, 120, 3, 70, "ExampleDelimiter",
 CellID->6445],
Cell[13599, 486, 79, 1, 70, "ExampleText",
 CellID->11106],
Cell[CellGroupData[{
Cell[13703, 491, 278, 10, 70, "Input",
 CellID->9795],
Cell[13984, 503, 202, 7, 36, "Output",
 CellID->23139363]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14235, 516, 216, 7, 70, "ExampleSection",
 CellID->31808],
Cell[14454, 525, 62, 1, 70, "ExampleText",
 CellID->148399041],
Cell[CellGroupData[{
Cell[14541, 530, 280, 10, 70, "Input",
 CellID->22950],
Cell[14824, 542, 190, 6, 36, "Output",
 CellID->815856361]
}, Open  ]],
Cell[15029, 551, 125, 3, 70, "ExampleDelimiter",
 CellID->632050940],
Cell[15157, 556, 323, 12, 70, "ExampleText",
 CellID->251732077],
Cell[CellGroupData[{
Cell[15505, 572, 273, 9, 70, "Input",
 CellID->7765],
Cell[15781, 583, 275, 9, 36, "Output",
 CellID->141921480]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16117, 599, 311, 9, 70, "SeeAlsoSection",
 CellID->12149],
Cell[16431, 610, 2700, 98, 70, "SeeAlso",
 CellID->19811]
}, Open  ]],
Cell[CellGroupData[{
Cell[19168, 713, 314, 9, 70, "TutorialsSection",
 CellID->30640],
Cell[19485, 724, 167, 3, 70, "Tutorials",
 CellID->15805]
}, Open  ]],
Cell[CellGroupData[{
Cell[19689, 732, 319, 9, 70, "MoreAboutSection",
 CellID->592007375],
Cell[20011, 743, 136, 3, 70, "MoreAbout",
 CellID->477649679],
Cell[20150, 748, 119, 3, 70, "MoreAbout",
 CellID->234314]
}, Open  ]],
Cell[20284, 754, 50, 0, 70, "History"],
Cell[20337, 756, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

