(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24075,        864]
NotebookOptionsPosition[     18957,        694]
NotebookOutlinePosition[     20539,        735]
CellTagsIndexPosition[     20454,        730]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding Expressions That Match a Pattern" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingExpressionsThatMatchAPattern"], 
          "Applying Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Finding Expressions That Match a Pattern\"\>", 
       2->"\<\"Applying Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Replace" :> Documentation`HelpLookup["paclet:ref/Replace"], 
          "ReplaceAll" :> Documentation`HelpLookup["paclet:ref/ReplaceAll"], 
          "StringReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/StringReplaceList"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "Trace" :> 
          Documentation`HelpLookup["paclet:ref/Trace"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "Split" :> 
          Documentation`HelpLookup["paclet:ref/Split"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Replace\"\>", 2->"\<\"ReplaceAll\"\>", 
       3->"\<\"StringReplaceList\"\>", 4->"\<\"Cases\"\>", 5->"\<\"Trace\"\>",
        6->"\<\"Position\"\>", 7->"\<\"Split\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Rules" :> Documentation`HelpLookup["paclet:guide/Rules"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Rules\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReplaceList", "ObjectName",
 CellID->12726],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplaceList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplaceList"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["rules", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to transform the entire expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by applying a rule or list of rules in all possible ways, and returns \
a list of the results obtained. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplaceList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplaceList"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["rules", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " results. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When no transformation is possible, ",
 Cell[BoxData[
  ButtonBox["ReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceList"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19314]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214960877],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->283886886],

Cell["Give the results of all possible replacements:", "ExampleText",
 CellID->50380632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x__", ",", "y__"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->679808153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32075930]
}, Open  ]],

Cell["Give only the first replacement that applies:", "ExampleText",
 CellID->448233123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x__", ",", "y__"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->51254442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9489049]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11364],

Cell["Use all rules that apply:", "ExampleText",
 CellID->217630522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "a"}], ",", 
     RowBox[{"x", "\[Rule]", "b"}], ",", 
     RowBox[{"x", "\[Rule]", "c"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26952948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157576175]
}, Open  ]],

Cell["Use only the first rule:", "ExampleText",
 CellID->237696109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "a"}], ",", 
     RowBox[{"x", "\[Rule]", "b"}], ",", 
     RowBox[{"x", "\[Rule]", "c"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546140189],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149429688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->361395264],

Cell["Find the possible values to break a sum of terms in two:", "ExampleText",
 CellID->109077883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{
    RowBox[{"x_", "+", "y_"}], "->", 
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713183686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", 
     RowBox[{"b", "+", "c"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", 
     RowBox[{"a", "+", "c"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", 
     RowBox[{"a", "+", "b"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ",", "b"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95202373]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8499],

Cell["Generate all subsets:", "ExampleText",
 CellID->357680136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "x__", ",", "___"}], "}"}], "\[Rule]", 
    RowBox[{"{", "x", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->966365255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "d", "}"}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123167417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->735338986],

Cell["Find all elements that appear twice:", "ExampleText",
 CellID->100137852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "b", ",", "c", ",", "c", ",", "a"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "x_", ",", "x_", ",", "___"}], "}"}], "->", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43604950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8028927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153484093],

Cell["Find all sublists flanked by the same element:", "ExampleText",
 CellID->27330279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "a", ",", "d", ",", "b", ",", "d"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "x_", ",", "y__", ",", "x_", ",", "___"}], "}"}], 
    "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", "y", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517406544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", "b", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->648563651]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17308],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15537],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "Tutorials",
 CellID->19123],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "Tutorials",
 CellID->10848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->88902958],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->5654501],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->499349347],

Cell[TextData[ButtonBox["Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Rules"]], "MoreAbout",
 CellID->6774198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ReplaceList"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplaceList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 27.1760756}", "context" -> "System`", 
    "keywords" -> {
     "enumerating sublists", "lists", "multiple matches for patterns", 
      "parser construction", "production rules", "rewrite rules", "searching",
       "selecting sublists", "sublists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ReplaceList[expr, rules] attempts to transform the entire expression \
expr by applying a rule or list of rules in all possible ways, and returns a \
list of the results obtained. ReplaceList[expr, rules, n] gives a list of at \
most n results. ", "synonyms" -> {"replace list"}, "title" -> "ReplaceList", 
    "type" -> "Symbol", "uri" -> "ref/ReplaceList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5542, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->214960877]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20311, 723}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2826, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3449, 89, 49, 1, 70, "ObjectName",
 CellID->12726],
Cell[3501, 92, 1203, 36, 70, "Usage",
 CellID->13392]
}, Open  ]],
Cell[CellGroupData[{
Cell[4741, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5219, 150, 286, 11, 70, "Notes",
 CellID->19314]
}, Closed]],
Cell[CellGroupData[{
Cell[5542, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214960877],
Cell[CellGroupData[{
Cell[5927, 180, 148, 5, 70, "ExampleSection",
 CellID->283886886],
Cell[6078, 187, 88, 1, 70, "ExampleText",
 CellID->50380632],
Cell[CellGroupData[{
Cell[6191, 192, 413, 14, 28, "Input",
 CellID->679808153],
Cell[6607, 208, 1078, 36, 54, "Output",
 CellID->32075930]
}, Open  ]],
Cell[7700, 247, 88, 1, 70, "ExampleText",
 CellID->448233123],
Cell[CellGroupData[{
Cell[7813, 252, 408, 14, 28, "Input",
 CellID->51254442],
Cell[8224, 268, 308, 11, 36, "Output",
 CellID->9489049]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8581, 285, 216, 7, 70, "ExampleSection",
 CellID->11364],
Cell[8800, 294, 68, 1, 70, "ExampleText",
 CellID->217630522],
Cell[CellGroupData[{
Cell[8893, 299, 284, 9, 70, "Input",
 CellID->26952948],
Cell[9180, 310, 213, 7, 36, "Output",
 CellID->157576175]
}, Open  ]],
Cell[9408, 320, 67, 1, 70, "ExampleText",
 CellID->237696109],
Cell[CellGroupData[{
Cell[9500, 325, 281, 9, 70, "Input",
 CellID->546140189],
Cell[9784, 336, 158, 5, 36, "Output",
 CellID->149429688]
}, Open  ]],
Cell[9957, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->361395264],
Cell[10085, 349, 99, 1, 70, "ExampleText",
 CellID->109077883],
Cell[CellGroupData[{
Cell[10209, 354, 272, 9, 70, "Input",
 CellID->713183686],
Cell[10484, 365, 723, 25, 36, "Output",
 CellID->95202373]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11256, 396, 222, 7, 70, "ExampleSection",
 CellID->8499],
Cell[11481, 405, 64, 1, 70, "ExampleText",
 CellID->357680136],
Cell[CellGroupData[{
Cell[11570, 410, 321, 10, 70, "Input",
 CellID->966365255],
Cell[11894, 422, 714, 23, 36, "Output",
 CellID->123167417]
}, Open  ]],
Cell[12623, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->735338986],
Cell[12751, 453, 79, 1, 70, "ExampleText",
 CellID->100137852],
Cell[CellGroupData[{
Cell[12855, 458, 338, 11, 70, "Input",
 CellID->43604950],
Cell[13196, 471, 211, 7, 36, "Output",
 CellID->8028927]
}, Open  ]],
Cell[13422, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->153484093],
Cell[13550, 486, 88, 1, 70, "ExampleText",
 CellID->27330279],
Cell[CellGroupData[{
Cell[13663, 491, 436, 14, 70, "Input",
 CellID->517406544],
Cell[14102, 507, 503, 18, 36, "Output",
 CellID->648563651]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14666, 532, 311, 9, 70, "SeeAlsoSection",
 CellID->17308],
Cell[14980, 543, 1678, 62, 70, "SeeAlso",
 CellID->21372]
}, Open  ]],
Cell[CellGroupData[{
Cell[16695, 610, 314, 9, 70, "TutorialsSection",
 CellID->15537],
Cell[17012, 621, 189, 4, 70, "Tutorials",
 CellID->19123],
Cell[17204, 627, 167, 3, 70, "Tutorials",
 CellID->10848]
}, Open  ]],
Cell[CellGroupData[{
Cell[17408, 635, 318, 9, 70, "MoreAboutSection",
 CellID->88902958],
Cell[17729, 646, 145, 3, 70, "MoreAbout",
 CellID->5654501],
Cell[17877, 651, 151, 3, 70, "MoreAbout",
 CellID->499349347],
Cell[18031, 656, 120, 3, 70, "MoreAbout",
 CellID->6774198]
}, Open  ]],
Cell[CellGroupData[{
Cell[18188, 664, 305, 8, 70, "RelatedLinksSection"],
Cell[18496, 674, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[18900, 690, 27, 0, 70, "History"],
Cell[18930, 692, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

