(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45403,       1435]
NotebookOptionsPosition[     39109,       1218]
NotebookOutlinePosition[     40548,       1257]
CellTagsIndexPosition[     40462,       1252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], "Clip" :> 
          Documentation`HelpLookup["paclet:ref/Clip"], "Scaled" :> 
          Documentation`HelpLookup["paclet:ref/Scaled"], "RescalingTransform" :> 
          Documentation`HelpLookup["paclet:ref/RescalingTransform"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Mean\"\>", 2->"\<\"Clip\"\>", 
       3->"\<\"Scaled\"\>", 
       4->"\<\"RescalingTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Data Transforms and Smoothing\"\>",
        2->"\<\"Mathematical Functions\"\>", 3->"\<\"Numerical Data\"\>", 
       4->"\<\"Numerical Functions\"\>", 
       5->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rescale", "ObjectName",
 CellID->1895],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rescale",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rescale"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " rescaled to run from 0 to 1 over the range ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rescale",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rescale"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " rescaled to run from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " over the range ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rescale",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rescale"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]rescales each element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " to run from 0 to 1 over the range ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Min",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Min"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Max",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Max"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rescale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rescale"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["min", "TI"], ",", 
      StyleBox["max", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["x", "TI"], "-", 
     StyleBox["min", "TI"]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["max", "TI"], "-", 
     StyleBox["min", "TI"]}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25998],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Rescale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rescale"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17757],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rescale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rescale"]], "InlineFormula"],
 " works with complex numbers and symbolic quantities."
}], "Notes",
 CellID->508074717]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13977620],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->444558949],

Cell["Rescale to run from 0 to 1 over the range -10 to 10:", "ExampleText",
 CellID->653524461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{"2.5", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441569214],

Cell[BoxData["0.625`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156566505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56715479],

Cell[TextData[{
 "Rescale ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " to run from ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " when its values run from ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->8337912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55113610],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], " ", "c"}], "+", 
     RowBox[{"a", " ", "d"}]}], 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b"}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "c"}], "+", "d"}], ")"}], " ", "x"}], 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}]]}]], "Output",
 ImageSize->{146, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443564181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240226157],

Cell["Rescale so that all the list elements run from 0 to 1:", "ExampleText",
 CellID->399340804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", ".7"}], ",", ".5", ",", "1.2", ",", "5.6", ",", "1.8"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107861355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.19047619047619047`", ",", "0.30158730158730157`", ",", "1.`",
    ",", "0.3968253968253968`"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423312077]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23545],

Cell["Rescale a list of values:", "ExampleText",
 CellID->188745868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.5", ",", "3.5", ",", "4.5", ",", "6.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323799081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.25`", ",", "0.35000000000000003`", ",", "0.45`", ",", "0.65`"}], 
  "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30810672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->685788958],

Cell["Rescale with exact or symbolic quantities:", "ExampleText",
 CellID->190416525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->756416987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "a"], ",", 
   FractionBox["2", "a"], ",", 
   FractionBox["3", "a"], ",", 
   FractionBox["4", "a"], ",", 
   FractionBox["5", "a"], ",", 
   FractionBox["6", "a"]}], "}"}]], "Output",
 ImageSize->{141, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418712444]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11952],

Cell["Rescale in the complex plane:", "ExampleText",
 CellID->19918481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"0.5", "I"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633950007],

Cell[BoxData[
 RowBox[{"0.75`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115851690]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8150],

Cell["Make a Celsius to Fahrenheit conversion table:", "ExampleText",
 CellID->341235791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Rescale", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "40"}], ",", "100"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "40"}], ",", "212"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "40"}], ",", "100", ",", "10"}], "}"}]}], "]"}], "//", 
  "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78764500],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"-", "40"}], 
     RowBox[{"-", "40"}]},
    {
     RowBox[{"-", "30"}], 
     RowBox[{"-", "22"}]},
    {
     RowBox[{"-", "20"}], 
     RowBox[{"-", "4"}]},
    {
     RowBox[{"-", "10"}], "14"},
    {"0", "32"},
    {"10", "50"},
    {"20", "68"},
    {"30", "86"},
    {"40", "104"},
    {"50", "122"},
    {"60", "140"},
    {"70", "158"},
    {"80", "176"},
    {"90", "194"},
    {"100", "212"}
   }],
  "Grid"]], "Output",
 ImageSize->{56, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->863427540]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10062],

Cell[TextData[{
 "In the complex plane, ",
 Cell[BoxData[
  ButtonBox["Rescale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rescale"]], "InlineFormula"],
 " just scales and rotates a region:"
}], "ExampleText",
 CellID->204172433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "[", 
    RowBox[{"Rescale", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "+", "I"}], ",", 
        RowBox[{"3", "-", 
         RowBox[{"2", "I"}]}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13477122],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9278367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502950235],

Cell["\<\
Reversing both range specifications gives back the same result:\
\>", "ExampleText",
 CellID->576879887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rescale", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["r", "0"], ",", 
      SubscriptBox["r", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "0"], ",", 
      SubscriptBox["x", "1"]}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44820970],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["r", "1"]}], ")"}], " ", 
    SubscriptBox["x", "0"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x"}], "+", 
      SubscriptBox["r", "0"]}], ")"}], " ", 
    SubscriptBox["x", "1"]}]}], 
  RowBox[{
   SubscriptBox["r", "0"], "-", 
   SubscriptBox["r", "1"]}]]], "Output",
 ImageSize->{152, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213062191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rescale", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["r", "1"], ",", 
      SubscriptBox["r", "0"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "0"]}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52510338],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["r", "1"]}], ")"}], " ", 
    SubscriptBox["x", "0"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x"}], "+", 
      SubscriptBox["r", "0"]}], ")"}], " ", 
    SubscriptBox["x", "1"]}]}], 
  RowBox[{
   SubscriptBox["r", "0"], "-", 
   SubscriptBox["r", "1"]}]]], "Output",
 ImageSize->{152, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170149777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52583640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rescale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rescale"]], "InlineFormula"],
 " is effectively linear with respect to its first argument:"
}], "ExampleText",
 CellID->255409513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rescale", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455717211],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], " ", "c"}], "+", 
     RowBox[{"a", " ", "d"}]}], 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b"}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "c"}], "+", "d"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}]}], "+", 
      RowBox[{"x", " ", "\[Alpha]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}]]}]], "Output",
 ImageSize->{233, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176032946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", " ", 
   RowBox[{"Rescale", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
   RowBox[{"Rescale", "[", 
    RowBox[{"y", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->157510184],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b"}]]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", "d"}], ")"}], " ", "y"}], 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Alpha]"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b"}]]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", "d"}], ")"}], " ", "x"}], 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}]]}], ")"}], " ", 
   "\[Alpha]"}]}]], "Output",
 ImageSize->{381, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->408996566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", "\[Equal]", "%%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->893370222],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->314161862]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30468],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RescalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RescalingTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14567],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->8023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->47627662],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->316124872],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->52206096],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->6551690],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->198384529],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->20201279]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rescale - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 29.5355110}", "context" -> "System`", 
    "keywords" -> {"Renormalize"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Rescale[x, {min, max}] gives x rescaled to run from 0 to 1 over the \
range min to max. Rescale[x, {min, max}, {x_min, x_max}] gives x rescaled to \
run from x_min to x_max over the range min to max. Rescale[list] rescales \
each element of list to run from 0 to 1 over the range Min[list] to \
Max[list]. ", "synonyms" -> {}, "title" -> "Rescale", "type" -> "Symbol", 
    "uri" -> "ref/Rescale"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8024, 262, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13977620]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40320, 1245}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2617, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3240, 86, 44, 1, 70, "ObjectName",
 CellID->1895],
Cell[3287, 89, 2844, 96, 70, "Usage",
 CellID->17058]
}, Open  ]],
Cell[CellGroupData[{
Cell[6168, 190, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6646, 207, 632, 25, 70, "Notes",
 CellID->25998],
Cell[7281, 234, 482, 14, 70, "Notes",
 CellID->17757],
Cell[7766, 250, 221, 7, 70, "Notes",
 CellID->508074717]
}, Closed]],
Cell[CellGroupData[{
Cell[8024, 262, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13977620],
Cell[CellGroupData[{
Cell[8408, 276, 148, 5, 70, "ExampleSection",
 CellID->444558949],
Cell[8559, 283, 95, 1, 70, "ExampleText",
 CellID->653524461],
Cell[CellGroupData[{
Cell[8679, 288, 200, 7, 28, "Input",
 CellID->441569214],
Cell[8882, 297, 163, 5, 36, "Output",
 CellID->156566505]
}, Open  ]],
Cell[9060, 305, 124, 3, 70, "ExampleDelimiter",
 CellID->56715479],
Cell[9187, 310, 457, 18, 70, "ExampleText",
 CellID->8337912],
Cell[CellGroupData[{
Cell[9669, 332, 233, 8, 70, "Input",
 CellID->55113610],
Cell[9905, 342, 528, 21, 51, "Output",
 CellID->443564181]
}, Open  ]],
Cell[10448, 366, 125, 3, 70, "ExampleDelimiter",
 CellID->240226157],
Cell[10576, 371, 97, 1, 70, "ExampleText",
 CellID->399340804],
Cell[CellGroupData[{
Cell[10698, 376, 212, 7, 70, "Input",
 CellID->107861355],
Cell[10913, 385, 301, 9, 36, "Output",
 CellID->423312077]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11263, 400, 216, 7, 70, "ExampleSection",
 CellID->23545],
Cell[11482, 409, 68, 1, 70, "ExampleText",
 CellID->188745868],
Cell[CellGroupData[{
Cell[11575, 414, 253, 8, 70, "Input",
 CellID->323799081],
Cell[11831, 424, 257, 8, 36, "Output",
 CellID->30810672]
}, Open  ]],
Cell[12103, 435, 125, 3, 70, "ExampleDelimiter",
 CellID->685788958],
Cell[12231, 440, 85, 1, 70, "ExampleText",
 CellID->190416525],
Cell[CellGroupData[{
Cell[12341, 445, 268, 9, 70, "Input",
 CellID->756416987],
Cell[12612, 456, 376, 13, 51, "Output",
 CellID->418712444]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13037, 475, 239, 7, 70, "ExampleSection",
 CellID->11952],
Cell[13279, 484, 71, 1, 70, "ExampleText",
 CellID->19918481],
Cell[CellGroupData[{
Cell[13375, 489, 247, 9, 70, "Input",
 CellID->633950007],
Cell[13625, 500, 244, 7, 36, "Output",
 CellID->115851690]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13918, 513, 222, 7, 70, "ExampleSection",
 CellID->8150],
Cell[14143, 522, 89, 1, 70, "ExampleText",
 CellID->341235791],
Cell[CellGroupData[{
Cell[14257, 527, 554, 19, 70, "Input",
 CellID->78764500],
Cell[14814, 548, 613, 30, 244, "Output",
 CellID->863427540]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15476, 584, 233, 7, 70, "ExampleSection",
 CellID->10062],
Cell[15712, 593, 236, 8, 70, "ExampleText",
 CellID->204172433],
Cell[CellGroupData[{
Cell[15973, 605, 727, 25, 70, "Input",
 CellID->13477122],
Cell[16703, 632, 13651, 228, 70, "Output",
 Evaluatable->False,
 CellID->9278367]
}, Open  ]],
Cell[30369, 863, 125, 3, 70, "ExampleDelimiter",
 CellID->502950235],
Cell[30497, 868, 114, 3, 70, "ExampleText",
 CellID->576879887],
Cell[CellGroupData[{
Cell[30636, 875, 373, 13, 70, "Input",
 CellID->44820970],
Cell[31012, 890, 543, 21, 53, "Output",
 CellID->213062191]
}, Open  ]],
Cell[CellGroupData[{
Cell[31592, 916, 373, 13, 70, "Input",
 CellID->52510338],
Cell[31968, 931, 543, 21, 53, "Output",
 CellID->170149777]
}, Open  ]],
Cell[32526, 955, 124, 3, 70, "ExampleDelimiter",
 CellID->52583640],
Cell[32653, 960, 233, 7, 70, "ExampleText",
 CellID->255409513],
Cell[CellGroupData[{
Cell[32911, 971, 375, 13, 70, "Input",
 CellID->455717211],
Cell[33289, 986, 704, 27, 51, "Output",
 CellID->176032946]
}, Open  ]],
Cell[CellGroupData[{
Cell[34030, 1018, 553, 19, 70, "Input",
 CellID->157510184],
Cell[34586, 1039, 1176, 45, 51, "Output",
 CellID->408996566]
}, Open  ]],
Cell[CellGroupData[{
Cell[35799, 1089, 135, 4, 70, "Input",
 CellID->893370222],
Cell[35937, 1095, 161, 5, 36, "Output",
 CellID->314161862]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36159, 1107, 311, 9, 70, "SeeAlsoSection",
 CellID->30468],
Cell[36473, 1118, 940, 35, 70, "SeeAlso",
 CellID->2136]
}, Open  ]],
Cell[CellGroupData[{
Cell[37450, 1158, 314, 9, 70, "TutorialsSection",
 CellID->14567],
Cell[37767, 1169, 147, 3, 70, "Tutorials",
 CellID->8023]
}, Open  ]],
Cell[CellGroupData[{
Cell[37951, 1177, 318, 9, 70, "MoreAboutSection",
 CellID->47627662],
Cell[38272, 1188, 167, 3, 70, "MoreAbout",
 CellID->316124872],
Cell[38442, 1193, 154, 3, 70, "MoreAbout",
 CellID->52206096],
Cell[38599, 1198, 137, 3, 70, "MoreAbout",
 CellID->6551690],
Cell[38739, 1203, 149, 3, 70, "MoreAbout",
 CellID->198384529],
Cell[38891, 1208, 144, 3, 70, "MoreAbout",
 CellID->20201279]
}, Open  ]],
Cell[39050, 1214, 29, 0, 70, "History"],
Cell[39082, 1216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

