(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13359,        480]
NotebookOptionsPosition[     10113,        370]
NotebookOutlinePosition[     11425,        407]
CellTagsIndexPosition[     11340,        402]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], "Directory" :> 
          Documentation`HelpLookup["paclet:ref/Directory"], "$Path" :> 
          Documentation`HelpLookup["paclet:ref/$Path"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SetDirectory\"\>", 2->"\<\"Directory\"\>", 
       3->"\<\"$Path\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ResetDirectory", "ObjectName",
 CellID->14967],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ResetDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ResetDirectory"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]resets the current working directory to its previous \
value. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Successive calls to ",
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 " yield earlier and earlier current directories. "
}], "Notes",
 CellID->23613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 " uses the directory stack given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7257],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 " removes the last element from the directory stack, and makes the second\
\[Hyphen]to\[Hyphen]last element current. "
}], "Notes",
 CellID->2919]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165474539],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13662170],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 " pushes a directory onto the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->545770821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "$InstallationDirectory", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365646888],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>"], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464015974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryStack", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223241202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>", 
   ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\My Documents\"\>"}], 
  "}"}]], "Output",
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->626772017]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 " pops a directory from the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->714022966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResetDirectory", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->300499958],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>"], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->199115048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryStack", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->45218536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\My Documents\"\>"}], 
  "}"}]], "Output",
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->295687246]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24711],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Path"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18376],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->28408]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->340266185],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->388517214]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ResetDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 30.3949080}", "context" -> "System`", 
    "keywords" -> {"previous directory", "return to directory"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ResetDirectory[] resets the current working directory to its previous \
value. ", "synonyms" -> {"reset directory", "popd", "reset directory"}, 
    "title" -> "ResetDirectory", "type" -> "Symbol", "uri" -> 
    "ref/ResetDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4671, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->165474539]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11197, 395}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 78, 52, 1, 70, "ObjectName",
 CellID->14967],
Cell[2696, 81, 494, 16, 70, "Usage",
 CellID->11845]
}, Open  ]],
Cell[CellGroupData[{
Cell[3227, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3705, 119, 252, 8, 70, "Notes",
 CellID->23613],
Cell[3960, 129, 377, 13, 70, "Notes",
 CellID->7257],
Cell[4340, 144, 294, 8, 70, "Notes",
 CellID->2919]
}, Closed]],
Cell[CellGroupData[{
Cell[4671, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165474539],
Cell[CellGroupData[{
Cell[5056, 171, 147, 5, 70, "ExampleSection",
 CellID->13662170],
Cell[5206, 178, 377, 13, 70, "ExampleText",
 CellID->545770821],
Cell[CellGroupData[{
Cell[5608, 195, 129, 3, 28, "Input",
 CellID->365646888],
Cell[5740, 200, 229, 6, 36, "Output",
 CellID->464015974]
}, Open  ]],
Cell[CellGroupData[{
Cell[6006, 211, 105, 3, 28, "Input",
 CellID->223241202],
Cell[6114, 216, 494, 13, 71, "Output",
 CellID->626772017]
}, Open  ]],
Cell[6623, 232, 379, 13, 70, "ExampleText",
 CellID->714022966],
Cell[CellGroupData[{
Cell[7027, 249, 105, 3, 70, "Input",
 CellID->300499958],
Cell[7135, 254, 229, 6, 36, "Output",
 CellID->199115048]
}, Open  ]],
Cell[CellGroupData[{
Cell[7401, 265, 104, 3, 70, "Input",
 CellID->45218536],
Cell[7508, 270, 410, 11, 71, "Output",
 CellID->295687246]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7979, 288, 311, 9, 70, "SeeAlsoSection",
 CellID->24711],
Cell[8293, 299, 700, 26, 70, "SeeAlso",
 CellID->19410]
}, Open  ]],
Cell[CellGroupData[{
Cell[9030, 330, 314, 9, 70, "TutorialsSection",
 CellID->18376],
Cell[9347, 341, 156, 3, 70, "Tutorials",
 CellID->28408]
}, Open  ]],
Cell[CellGroupData[{
Cell[9540, 349, 319, 9, 70, "MoreAboutSection",
 CellID->340266185],
Cell[9862, 360, 179, 3, 70, "MoreAbout",
 CellID->388517214]
}, Open  ]],
Cell[10056, 366, 27, 0, 70, "History"],
Cell[10086, 368, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

