(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21015,        815]
NotebookOptionsPosition[     16322,        645]
NotebookOutlinePosition[     17586,        682]
CellTagsIndexPosition[     17501,        677]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Residues" :> 
          Documentation`HelpLookup["paclet:tutorial/Residues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Residues\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "Limit" :> Documentation`HelpLookup["paclet:ref/Limit"], 
          "PrincipalValue" :> 
          Documentation`HelpLookup["paclet:ref/PrincipalValue"], "Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"], "D" :> 
          Documentation`HelpLookup["paclet:ref/D"], "Derivative" :> 
          Documentation`HelpLookup["paclet:ref/Derivative"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 2->"\<\"Limit\"\>", 
       3->"\<\"PrincipalValue\"\>", 4->"\<\"Integrate\"\>", 5->"\<\"D\"\>", 
       6->"\<\"Derivative\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Functions of Complex Variables\"\>", 
       2->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Residue", "ObjectName",
 CellID->20728],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Residue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Residue"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["z", "TI"], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["0", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the residue of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["z", "TI"], "=", 
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The residue is defined as the coefficient of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["z", "TI"], "-", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["0", "TR"]]}], ")"}], "^", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 " in the Laurent expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7033],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can usually find residues at a point only when it can evaluate power \
series at that point. "
}], "Notes",
 CellID->7262]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229472960],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->38640567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21376],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44289771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "z", "]"}], 
    RowBox[{"Gamma", "[", 
     RowBox[{"z", "-", "1"}], "]"}], 
    RowBox[{"Gamma", "[", 
     RowBox[{"z", "-", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28172],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "17"}], "+", 
    RowBox[{"30", " ", "EulerGamma"}], "-", 
    RowBox[{"18", " ", 
     SuperscriptBox["EulerGamma", "2"]}], "-", 
    SuperscriptBox["\[Pi]", "2"]}], ")"}]}]], "Output",
 ImageSize->{285, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->906928638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], "/", 
    RowBox[{"z", "^", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1152],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "4", ")"}],
     Derivative],
    MultilineFunction->None], "[", "0", "]"}]}]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243621611]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5512],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->698043365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"Sin", "[", "z", "]"}], "^", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22069],

Cell[BoxData[
 FractionBox["3", "8"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54762225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"Sin", "[", "z", "]"}], "^", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23376],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["z", "5"]], "+", 
   FractionBox["5", 
    RowBox[{"6", " ", 
     SuperscriptBox["z", "3"]}]], "+", 
   FractionBox["3", 
    RowBox[{"8", " ", "z"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, -5, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 
    Rational[5, 6], 0, 
    Rational[3, 8]}, -5, 1, 1],
  Editable->False]], "Output",
 ImageSize->{140, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101628302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "z", "]"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "^", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20108],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"StieltjesGamma", "[", "9", "]"}], "362880"]}]], "Output",
 ImageSize->{135, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576285753]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5354],

Cell["\<\
Illustrate Cauchy's theorem for the integral of a complex function:\
\>", "ExampleText",
 CellID->31147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"Sin", "[", "z", "]"}], "^", "7"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1", ",", "I", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "I"}], ",", "1"}], "}"}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", "Pi", " ", "I"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9705],

Cell[BoxData[
 RowBox[{"0.3125`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501214263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"Sin", "[", "z", "]"}], "^", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3953],

Cell[BoxData[
 FractionBox["5", "16"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167542312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->241],

Cell[BoxData["0.3125`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->67350033]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9244],

Cell["Residues are not defined at branch points:", "ExampleText",
 CellID->12153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "z", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7815],

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["z"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Output",
 ImageSize->{146, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12487963]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9332],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrincipalValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrincipalValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30899],

Cell[TextData[ButtonBox["Residues",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Residues"]], "Tutorials",
 CellID->17496]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->307906688],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->336311498],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->528221829]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Residue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 34.5356390}", "context" -> "System`", 
    "keywords" -> {
     "complex analysis", "res", "singularity of meromorphic function"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Residue[expr, {z, z_0}] finds the residue of expr at the point z = z_0. \
", "synonyms" -> {}, "title" -> "Residue", "type" -> "Symbol", "uri" -> 
    "ref/Residue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5127, 168, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->229472960]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17358, 670}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2360, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2983, 82, 45, 1, 70, "ObjectName",
 CellID->20728],
Cell[3031, 85, 936, 32, 70, "Usage",
 CellID->6756]
}, Open  ]],
Cell[CellGroupData[{
Cell[4004, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4482, 139, 415, 16, 70, "Notes",
 CellID->7033],
Cell[4900, 157, 190, 6, 70, "Notes",
 CellID->7262]
}, Closed]],
Cell[CellGroupData[{
Cell[5127, 168, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229472960],
Cell[CellGroupData[{
Cell[5512, 182, 147, 5, 70, "ExampleSection",
 CellID->38640567],
Cell[CellGroupData[{
Cell[5684, 191, 195, 7, 28, "Input",
 CellID->21376],
Cell[5882, 200, 157, 5, 36, "Output",
 CellID->44289771]
}, Open  ]],
Cell[CellGroupData[{
Cell[6076, 210, 349, 12, 28, "Input",
 CellID->28172],
Cell[6428, 224, 417, 14, 51, "Output",
 CellID->906928638]
}, Open  ]],
Cell[6860, 241, 120, 3, 70, "ExampleDelimiter",
 CellID->8150],
Cell[CellGroupData[{
Cell[7005, 248, 249, 9, 28, "Input",
 CellID->1152],
Cell[7257, 259, 340, 13, 51, "Output",
 CellID->243621611]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7646, 278, 216, 7, 70, "ExampleSection",
 CellID->22564],
Cell[CellGroupData[{
Cell[7887, 289, 219, 8, 70, "Input",
 CellID->5512],
Cell[8109, 299, 158, 5, 36, "Output",
 CellID->698043365]
}, Open  ]],
Cell[8282, 307, 121, 3, 70, "ExampleDelimiter",
 CellID->11404],
Cell[CellGroupData[{
Cell[8428, 314, 253, 9, 70, "Input",
 CellID->22069],
Cell[8684, 325, 177, 6, 51, "Output",
 CellID->54762225]
}, Open  ]],
Cell[CellGroupData[{
Cell[8898, 336, 262, 9, 70, "Input",
 CellID->23376],
Cell[9163, 347, 657, 23, 53, "Output",
 CellID->101628302]
}, Open  ]],
Cell[9835, 373, 121, 3, 70, "ExampleDelimiter",
 CellID->12826],
Cell[CellGroupData[{
Cell[9981, 380, 307, 11, 70, "Input",
 CellID->20108],
Cell[10291, 393, 244, 8, 51, "Output",
 CellID->576285753]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10584, 407, 222, 7, 70, "ExampleSection",
 CellID->5354],
Cell[10809, 416, 114, 3, 70, "ExampleText",
 CellID->31147],
Cell[CellGroupData[{
Cell[10948, 423, 421, 14, 70, "Input",
 CellID->9705],
Cell[11372, 439, 244, 7, 36, "Output",
 CellID->501214263]
}, Open  ]],
Cell[CellGroupData[{
Cell[11653, 451, 252, 9, 70, "Input",
 CellID->3953],
Cell[11908, 462, 179, 6, 51, "Output",
 CellID->167542312]
}, Open  ]],
Cell[CellGroupData[{
Cell[12124, 473, 91, 3, 70, "Input",
 CellID->241],
Cell[12218, 478, 163, 5, 36, "Output",
 CellID->67350033]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12430, 489, 225, 7, 70, "ExampleSection",
 CellID->9244],
Cell[12658, 498, 81, 1, 70, "ExampleText",
 CellID->12153],
Cell[CellGroupData[{
Cell[12764, 503, 227, 8, 70, "Input",
 CellID->7815],
Cell[12994, 513, 299, 11, 55, "Output",
 CellID->12487963]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13354, 531, 310, 9, 70, "SeeAlsoSection",
 CellID->9332],
Cell[13667, 542, 1424, 53, 70, "SeeAlso",
 CellID->4897]
}, Open  ]],
Cell[CellGroupData[{
Cell[15128, 600, 314, 9, 70, "TutorialsSection",
 CellID->30899],
Cell[15445, 611, 127, 3, 70, "Tutorials",
 CellID->17496]
}, Open  ]],
Cell[CellGroupData[{
Cell[15609, 619, 319, 9, 70, "MoreAboutSection",
 CellID->307906688],
Cell[15931, 630, 169, 3, 70, "MoreAbout",
 CellID->336311498],
Cell[16103, 635, 147, 3, 70, "MoreAbout",
 CellID->528221829]
}, Open  ]],
Cell[16265, 641, 27, 0, 70, "History"],
Cell[16295, 643, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

