(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    144151,       4922]
NotebookOptionsPosition[    123419,       4199]
NotebookOutlinePosition[    125024,       4240]
CellTagsIndexPosition[    124937,       4235]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quantifiers" :> 
          Documentation`HelpLookup["paclet:tutorial/Quantifiers"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quantifiers\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Exists" :> 
          Documentation`HelpLookup["paclet:ref/Exists"], "ForAll" :> 
          Documentation`HelpLookup["paclet:ref/ForAll"], 
          "CylindricalDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CylindricalDecomposition"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Reduce\"\>", 
       2->"\<\"FindInstance\"\>", 3->"\<\"Exists\"\>", 4->"\<\"ForAll\"\>", 
       5->"\<\"CylindricalDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Logic & Boolean Algebra\"\>", 3->"\<\"Polynomial Algebra\"\>",
        4->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Resolve", "ObjectName",
 CellID->15458],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Resolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Resolve"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to resolve ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " into a form that eliminates ",
     Cell[BoxData[
      ButtonBox["ForAll",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ForAll"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Exists",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Exists"]], "InlineFormula"],
     " quantifiers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Resolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Resolve"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]works over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". Common choices of ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     " are ",
     Cell[BoxData[
      ButtonBox["Complexes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Booleans",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Booleans"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " is in effect automatically applied by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20986],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can contain equations, inequalities, domain specifications and \
quantifiers, in the same form as in ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25526],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " always describes exactly the same mathematical set as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", but without quantifiers. "
}], "Notes",
 CellID->15629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " assumes by default that quantities appearing algebraically in inequalities \
are real, while all other quantities are complex. "
}], "Notes",
 CellID->22357],

Cell[TextData[{
 "When a quantifier such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is eliminated the result will contain no mention of the localized variable \
",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can in principle always eliminate quantifiers if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " contains only polynomial equations and inequalities over the reals or \
complexes. "
}], "Notes",
 CellID->8713]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57668404],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->80999812],

Cell["Prove that the unit disk is nonempty:", "ExampleText",
 CellID->23762659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287110999],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172681968]
}, Open  ]],

Cell["\<\
Find the conditions for a quadratic form over the reals to be positive:\
\>", "ExampleText",
 CellID->359183303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"a", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", "x"}], "+", "c"}], ">", "0"}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->566463313],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{342, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51765877]
}, Open  ]],

Cell["\<\
Find conditions for a quadratic to have at least two distinct complex roots:\
\>", "ExampleText",
 CellID->167253360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], " ", "&&", " ",
      
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}], " ", "&&", " ",
      
     RowBox[{"x", "\[NotEqual]", "y"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->322384905],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{313, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->685512367]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(27)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30220266],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Complex Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->741232164],

Cell["\<\
Decide the existence of solutions of a univariate polynomial equation:\
\>", "ExampleText",
 CellID->706341477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "7"}], "+", 
      RowBox[{"3", " ", "x"}], "-", "11"}], "\[Equal]", "0"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25191051],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127509417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50107856],

Cell["\<\
Decide the existence of solutions of a multivariate polynomial system:\
\>", "ExampleText",
 CellID->114315605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[NotEqual]", "3"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334270597],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113944237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121571775],

Cell["\<\
Decide the truth value of fully quantified polynomial formulas:\
\>", "ExampleText",
 CellID->168866784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"Exists", "[", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}]}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418580139],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187777044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"b", ",", "c"}], "}"}], ",", 
    RowBox[{"Exists", "[", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}]}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81322241],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253810122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36043039],

Cell["\<\
Find conditions under which a polynomial equation has solutions:\
\>", "ExampleText",
 CellID->7119569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "3"}], "+", "1"}], ")"}], 
       RowBox[{"x", "^", "7"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"a", " ", "b"}], "+", "1"}], ")"}], " ", 
       RowBox[{"x", "^", "2"}]}], "-", "3"}], "\[Equal]", "0"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210942678],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"a", " ", "b"}]}], "\[NotEqual]", "0"}], "||", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "3"]}], "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225666176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275898722],

Cell["\<\
Find conditions under which a polynomial system has solutions:\
\>", "ExampleText",
 CellID->500979440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "x"}], "-", 
       RowBox[{"a", " ", "y"}]}], "\[Equal]", "2"}], "&&", 
     RowBox[{"x", "\[NotEqual]", "y"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->804315401],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "+", "b"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"4", " ", "a", " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"]}], "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "b"}], "+", 
      SuperscriptBox["b", "2"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"4", " ", "a", " ", "b"}], "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"]}], "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "b"}], "+", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"4", " ", "a", " ", "b"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "3"]}], "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], "+", "b"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "b"}], "+", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{489, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21922202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201579014],

Cell["\<\
Find conditions under which a quantified polynomial formula is true:\
\>", "ExampleText",
 CellID->218083473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{"c", ",", 
    RowBox[{"Exists", "[", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}]}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101700695],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[NotEqual]", "0"}], "||", 
  RowBox[{"b", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182832422]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Real Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->98928300],

Cell["\<\
Decide the existence of solutions of a univariate polynomial equation:\
\>", "ExampleText",
 CellID->126185585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "7"}], "+", 
       RowBox[{"3", " ", "x"}], "-", "11"}], "\[Equal]", "0"}]}], "]"}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11210030],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->682548528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->636503092],

Cell["\<\
Decide the existence of solutions of a univariate polynomial inequality:\
\>", "ExampleText",
 CellID->60489641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "+", 
       RowBox[{"3", " ", "x"}], "+", "11"}], "\[LessEqual]", "0"}]}], "]"}], 
   ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340262036],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->566743702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163659358],

Cell["\<\
Decide the existence of solutions of a multivariate polynomial system:\
\>", "ExampleText",
 CellID->386441401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "11"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "3"}], "-", 
        RowBox[{"y", "^", "2"}]}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], ">", "3"}]}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392893401],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54911719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->588868794],

Cell["\<\
Decide the truth value of fully quantified polynomial formulas:\
\>", "ExampleText",
 CellID->191842668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], "\[GreaterEqual]", "0"}]}], 
      "]"}]}], "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89763932],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116913249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], "\[GreaterEqual]", "0"}]}], 
      "]"}]}], "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->147214915],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4741930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->269612],

Cell["Find conditions under which a linear system has solutions:", \
"ExampleText",
 CellID->81962537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"b", " ", "y"}]}], "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", "b"}], ")"}], "x"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"b", "^", "2"}]}], ")"}], "y"}]}], "\[Equal]", "2"}]}]}], 
    "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21800398],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{498, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352957677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->520459019],

Cell["\<\
Find conditions under which a quadratic system has solutions:\
\>", "ExampleText",
 CellID->668546723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"b", " ", "x"}], "+", "c"}], "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"c", " ", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"a", "^", "3"}], "-", 
        RowBox[{"b", "^", "3"}]}], "\[Equal]", "2"}]}]}], "]"}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288792855],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{499, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386985061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->736131332],

Cell["\<\
Find conditions under which a polynomial system has solutions:\
\>", "ExampleText",
 CellID->799637042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"x", "^", "4"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"y", "^", "4"}]}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", 
        RowBox[{"a", " ", 
         RowBox[{"y", "^", "3"}]}]}], "\[GreaterEqual]", "2"}]}]}], "]"}], 
   ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195265571],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}], ")"}], "||", 
  RowBox[{"0", "<", "a", "\[LessEqual]", 
   FractionBox["1", "16"]}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", 
     FractionBox["1", "16"]}], "&&", 
    RowBox[{"b", "\[LessEqual]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "531441"}], " ", 
          SuperscriptBox["a", "20"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "314928"}], " ", 
             SuperscriptBox["a", "15"]}], "+", 
            RowBox[{"25509168", " ", 
             SuperscriptBox["a", "16"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "69984"}], " ", 
             SuperscriptBox["a", "10"]}], "-", 
            RowBox[{"57946752", " ", 
             SuperscriptBox["a", "11"]}], "-", 
            RowBox[{"408146688", " ", 
             SuperscriptBox["a", "12"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6912"}], " ", 
             SuperscriptBox["a", "5"]}], "+", 
            RowBox[{"5038848", " ", 
             SuperscriptBox["a", "6"]}], "-", 
            RowBox[{"216670464", " ", 
             SuperscriptBox["a", "7"]}], "+", 
            RowBox[{"2176782336", " ", 
             SuperscriptBox["a", "8"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "9"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "256"}], "+", 
            RowBox[{"4096", " ", "a"}]}], ")"}], " ", 
          SuperscriptBox["#1", "12"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{511, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108422537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167602913],

Cell["\<\
Find conditions under which a formula linear in quantified variables is true:\
\
\>", "ExampleText",
 CellID->332999475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"c", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", "x"}], "+", 
          RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
        RowBox[{
         RowBox[{
          RowBox[{"c", " ", "x"}], "+", 
          RowBox[{"a", " ", "y"}]}], "\[GreaterEqual]", "b"}]}]}], "]"}]}], 
    "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673622182],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     SuperscriptBox["b", "2"], "\[LessEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     SuperscriptBox["b", "2"], "\[LessEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"b", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     SuperscriptBox["b", "2"], "\[LessEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "\[LessEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"b", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "\[GreaterEqual]", "0"}]}], ")"}], "||", 
  
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     SuperscriptBox["b", "2"], "\[LessEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["b", "3"]}]}], "\[GreaterEqual]", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{506, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287503614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137718676],

Cell["\<\
Find conditions under which a formula quadratic in quantified variables is \
true:\
\>", "ExampleText",
 CellID->1728819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"c", ",", 
     RowBox[{
      RowBox[{"c", "^", "2"}], "<", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "3"}]}]}], ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], "==", "0"}]}], "]"}]}], "]"}], 
   ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167634249],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{543, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37009585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351022213],

Cell["\<\
Find conditions under which a quantified polynomial formula is true:\
\>", "ExampleText",
 CellID->487604460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"y", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "-", "1"}], ")"}], "x", " ", "y"}], "-", 
         
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "a"}], "-", "1"}], ")"}], " ", 
          RowBox[{"y", "^", "4"}]}], "+", 
         RowBox[{"a", "^", "3"}]}], "\[GreaterEqual]", "2"}]}], "]"}]}], 
    "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610519768],

Cell[BoxData[
 RowBox[{"a", "\[GreaterEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{143, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20734296]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Integer Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247179601],

Cell["\<\
Decide the existence of solutions of a linear system of equations:\
\>", "ExampleText",
 CellID->91649387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", 
        RowBox[{"3", "y"}], "-", 
        RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"3", "x"}], "-", 
        RowBox[{"4", "y"}], "+", 
        RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}]}], "]"}], ",", "Integers"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31436120],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->397690229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56626870],

Cell["\<\
Decide the existence of solutions of a linear system of equations and \
inequalities:\
\>", "ExampleText",
 CellID->610547063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", 
        RowBox[{"3", "y"}]}], "\[Equal]", "4"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"3", "x"}], "-", 
        RowBox[{"4", "y"}]}], "\[LessEqual]", "5"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", 
        RowBox[{"2", "y"}]}], ">", 
       RowBox[{"-", "21"}]}]}]}], "]"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336458608],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195159341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20516472],

Cell["\<\
Decide the existence of solutions of a univariate polynomial equation:\
\>", "ExampleText",
 CellID->68329701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "1000"}], "-", 
       RowBox[{"2", 
        RowBox[{"x", "^", "777"}]}], "+", "1"}], "\[Equal]", "0"}]}], "]"}], 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626380406],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600531274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327203451],

Cell["\<\
Decide the existence of solutions of a univariate polynomial inequality:\
\>", "ExampleText",
 CellID->292309597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "5"}], "-", 
       RowBox[{"2", "x"}], "+", "1"}], "<", "0"}]}], "]"}], ",", "Integers"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50212146],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68034724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7255924],

Cell["Decide the existence of solutions of Frobenius equations:", \
"ExampleText",
 CellID->571787434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1221", "x"}], "+", 
        RowBox[{"3434", "y"}], "+", 
        RowBox[{"5566", "z"}], "+", 
        RowBox[{"8778", "t"}]}], "\[Equal]", "90909"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"z", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"t", "\[GreaterEqual]", "0"}]}]}], "]"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136926990],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52486410]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1221", "x"}], "+", 
        RowBox[{"3434", "y"}], "+", 
        RowBox[{"5566", "z"}], "+", 
        RowBox[{"8778", "t"}]}], "\[Equal]", "909090"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"z", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"t", "\[GreaterEqual]", "0"}]}]}], "]"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5225840],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79529143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->487716768],

Cell["\<\
Decide the existence of solutions of binary quadratic equations:\
\>", "ExampleText",
 CellID->149610693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"x", " ", "y"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "107"}]}], "]"}], ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408955322],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288789391]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"3", 
         RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "22"}], "&&", 
      RowBox[{"x", ">", "0"}], "&&", 
      RowBox[{"y", ">", "0"}]}]}], "]"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78572943],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254917575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160308141],

Cell["Decide the existence of solutions of a Thue equation:", "ExampleText",
 CellID->146235021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"2", 
        RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
       RowBox[{"y", "^", "3"}]}], "\[Equal]", "2"}]}], "]"}], ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264134555],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332185882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140799112],

Cell["\<\
Decide the existence of solutions of a sum of squares equation:\
\>", "ExampleText",
 CellID->297997273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"4", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"9", 
        RowBox[{"z", "^", "2"}]}], "+", 
       RowBox[{"16", 
        RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "354"}]}], "]"}], ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->454294297],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39404964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11130723],

Cell["\<\
Decide the existence of solutions of a bounded system of equations and \
inequalities:\
\>", "ExampleText",
 CellID->502130737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"y", "^", "4"}], "+", 
        RowBox[{"z", "^", "4"}]}], "\[LessEqual]", "500"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "3"}]}], "\[Equal]", "32"}]}]}], "]"}], ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->572071652],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555001849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731201360],

Cell["\<\
Decide the existence of solutions of a system of congruences:\
\>", "ExampleText",
 CellID->4884468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], ",", "2"}], "]"}], "\[Equal]", "1"}], "&&",
       
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"x", "-", 
          RowBox[{"2", "y"}]}], ",", "3"}], "]"}], "\[Equal]", "2"}]}]}], 
    "]"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146539654],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634646629]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Boolean Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->104018231],

Cell["Decide the satisfiability of a Boolean formula:", "ExampleText",
 CellID->9706577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{
      RowBox[{"Xor", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{"a", "||", "b"}], ")"}], "&&", 
      RowBox[{"(", 
       RowBox[{"c", "||", "d"}], ")"}]}]}], "]"}], ",", "Booleans"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->442917868],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392747214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258260121],

Cell["\<\
Find conditions under which a quantified Boolean formula is true:\
\>", "ExampleText",
 CellID->42740151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"a", ",", 
     RowBox[{"ForAll", "[", 
      RowBox[{"b", ",", 
       RowBox[{
        RowBox[{"Nand", "[", 
         RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "&&", 
        RowBox[{"(", 
         RowBox[{"a", "||", "b"}], ")"}], "&&", 
        RowBox[{"(", 
         RowBox[{"c", "||", "d"}], ")"}]}]}], "]"}]}], "]"}], ",", 
   "Booleans"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141745785],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"c", "||", "d"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"!", "c"}], "||", 
    RowBox[{"!", "d"}]}], ")"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18519872]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mixed Domains",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->480968683],

Cell["\<\
Decide the existence of solutions of an equation involving a real and a \
complex variable:\
\>", "ExampleText",
 CellID->416860605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"-", "1"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385046663],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20973446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20662917],

Cell[TextData[{
 "Decide the existence of solutions of an inequality ",
 "involving ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32888600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", "x", "]"}], "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"Abs", "[", "x", "]"}]}]}], "<", "1"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->381496655],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244978302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606489584],

Cell["\<\
Find under what conditions a fourth power of a complex number is real:\
\>", "ExampleText",
 CellID->614570127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}], ",", 
    RowBox[{
     RowBox[{"y", "^", "4"}], "\[Equal]", "x"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314513323],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Im", "[", "y", "]"}], "3"], " ", 
    RowBox[{"Re", "[", "y", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Im", "[", "y", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Re", "[", "y", "]"}], "3"]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50107770]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19831],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Backsubstitution",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->157444474],

Cell[TextData[{
 "Here the solutions for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " are expressed in terms of ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->328585869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", " ", "y"}], " ", "+", 
         RowBox[{"z", "^", "4"}], "-", "z"}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "4"}]}], "\[Equal]", "10"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "-", "y", "+", "3"}], ")"}], "^", "2"}], 
        "\[LessEqual]", "0"}]}]}], "]"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145416537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2820000000000099`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"429442729", "-", 
           RowBox[{"286433306", " ", "#1"}], "-", 
           RowBox[{"166962841", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"123312194", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"36126257", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"25419888", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"5476330", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"3130910", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"608028", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"244522", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"47550", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           RowBox[{"11920", " ", 
            SuperscriptBox["#1", "11"]}], "+", 
           RowBox[{"2449", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"332", " ", 
            SuperscriptBox["#1", "13"]}], "-", 
           RowBox[{"74", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           SuperscriptBox["#1", "16"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"6551", "-", 
           RowBox[{"2915", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"486", " ", 
            SuperscriptBox["y", "4"]}], "-", 
           RowBox[{"36", " ", 
            SuperscriptBox["y", "6"]}], "+", 
           SuperscriptBox["y", "8"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2916", " ", "y"}], "-", 
              RowBox[{"972", " ", 
               SuperscriptBox["y", "3"]}], "+", 
              RowBox[{"108", " ", 
               SuperscriptBox["y", "5"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["y", "7"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2915"}], "+", 
              RowBox[{"1458", " ", 
               SuperscriptBox["y", "2"]}], "-", 
              RowBox[{"216", " ", 
               SuperscriptBox["y", "4"]}], "+", 
              RowBox[{"10", " ", 
               SuperscriptBox["y", "6"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "972"}], " ", "y"}], "+", 
              RowBox[{"252", " ", 
               SuperscriptBox["y", "3"]}], "-", 
              RowBox[{"16", " ", 
               SuperscriptBox["y", "5"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"486", "-", 
              RowBox[{"216", " ", 
               SuperscriptBox["y", "2"]}], "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["y", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"108", " ", "y"}], "-", 
              RowBox[{"16", " ", 
               SuperscriptBox["y", "3"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "36"}], "+", 
              RowBox[{"10", " ", 
               SuperscriptBox["y", "2"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"4", " ", "y", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           SuperscriptBox["#1", "8"]}], "&"}], ",", "1"}], "]"}]}]}], ")"}], "||",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"429442729", "-", 
           RowBox[{"286433306", " ", "#1"}], "-", 
           RowBox[{"166962841", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"123312194", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"36126257", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"25419888", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"5476330", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"3130910", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"608028", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"244522", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"47550", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           RowBox[{"11920", " ", 
            SuperscriptBox["#1", "11"]}], "+", 
           RowBox[{"2449", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"332", " ", 
            SuperscriptBox["#1", "13"]}], "-", 
           RowBox[{"74", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           SuperscriptBox["#1", "16"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"6551", "-", 
           RowBox[{"2915", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"486", " ", 
            SuperscriptBox["y", "4"]}], "-", 
           RowBox[{"36", " ", 
            SuperscriptBox["y", "6"]}], "+", 
           SuperscriptBox["y", "8"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2916", " ", "y"}], "-", 
              RowBox[{"972", " ", 
               SuperscriptBox["y", "3"]}], "+", 
              RowBox[{"108", " ", 
               SuperscriptBox["y", "5"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["y", "7"]}]}], ")"}], " ", "#1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2915"}], "+", 
              RowBox[{"1458", " ", 
               SuperscriptBox["y", "2"]}], "-", 
              RowBox[{"216", " ", 
               SuperscriptBox["y", "4"]}], "+", 
              RowBox[{"10", " ", 
               SuperscriptBox["y", "6"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "972"}], " ", "y"}], "+", 
              RowBox[{"252", " ", 
               SuperscriptBox["y", "3"]}], "-", 
              RowBox[{"16", " ", 
               SuperscriptBox["y", "5"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"486", "-", 
              RowBox[{"216", " ", 
               SuperscriptBox["y", "2"]}], "+", 
              RowBox[{"19", " ", 
               SuperscriptBox["y", "4"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "4"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"108", " ", "y"}], "-", 
              RowBox[{"16", " ", 
               SuperscriptBox["y", "3"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "36"}], "+", 
              RowBox[{"10", " ", 
               SuperscriptBox["y", "2"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"4", " ", "y", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           SuperscriptBox["#1", "8"]}], "&"}], ",", "2"}], "]"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 ImageSize->{578, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563615179]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Backsubstitution", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " gives explicit numeric values for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->254790440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", " ", "y"}], " ", "+", 
         RowBox[{"z", "^", "4"}], "-", "z"}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "4"}]}], "\[Equal]", "10"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "-", "y", "+", "3"}], ")"}], "^", "2"}], 
        "\[LessEqual]", "0"}]}]}], "]"}], ",", "Reals", ",", 
    RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375275797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.000000000000012`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"429442729", "-", 
           RowBox[{"286433306", " ", "#1"}], "-", 
           RowBox[{"166962841", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"123312194", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"36126257", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"25419888", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"5476330", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"3130910", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"608028", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"244522", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"47550", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           RowBox[{"11920", " ", 
            SuperscriptBox["#1", "11"]}], "+", 
           RowBox[{"2449", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"332", " ", 
            SuperscriptBox["#1", "13"]}], "-", 
           RowBox[{"74", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           SuperscriptBox["#1", "16"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"82", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"756", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           RowBox[{"2754", " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"4980", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"4975", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"3496", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"2236", " ", 
            SuperscriptBox["#1", "10"]}], "-", 
           RowBox[{"904", " ", 
            SuperscriptBox["#1", "11"]}], "+", 
           RowBox[{"415", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"100", " ", 
            SuperscriptBox["#1", "13"]}], "+", 
           RowBox[{"34", " ", 
            SuperscriptBox["#1", "14"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           SuperscriptBox["#1", "16"]}], "&"}], ",", "1"}], "]"}]}]}], ")"}], 
    "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"429442729", "-", 
           RowBox[{"286433306", " ", "#1"}], "-", 
           RowBox[{"166962841", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"123312194", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"36126257", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"25419888", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"5476330", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"3130910", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"608028", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"244522", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"47550", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           RowBox[{"11920", " ", 
            SuperscriptBox["#1", "11"]}], "+", 
           RowBox[{"2449", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"332", " ", 
            SuperscriptBox["#1", "13"]}], "-", 
           RowBox[{"74", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           SuperscriptBox["#1", "16"]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"82", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"756", " ", 
            SuperscriptBox["#1", "5"]}], "+", 
           RowBox[{"2754", " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"4980", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"4975", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"3496", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"2236", " ", 
            SuperscriptBox["#1", "10"]}], "-", 
           RowBox[{"904", " ", 
            SuperscriptBox["#1", "11"]}], "+", 
           RowBox[{"415", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"100", " ", 
            SuperscriptBox["#1", "13"]}], "+", 
           RowBox[{"34", " ", 
            SuperscriptBox["#1", "14"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           SuperscriptBox["#1", "16"]}], "&"}], ",", "2"}], "]"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 ImageSize->{577, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->327654299]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cubics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->675506344],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " does not use general formulas for solving cubics in radicals:"
}], "ExampleText",
 CellID->458422457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", ">", "a"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "3"}], "+", "x", "+", "1"}], "\[Equal]", "0"}]}]}], 
    "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535287292],

Cell[BoxData[
 RowBox[{"a", "<", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", "#1", "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{162, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318235755]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " expresses roots of cubics in terms of radicals:"
}], "ExampleText",
 CellID->248533402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", ">", "a"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "3"}], "+", "x", "+", "1"}], "\[Equal]", "0"}]}]}], 
    "]"}], ",", "Reals", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->110410003],

Cell[BoxData[
 RowBox[{"a", "<", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "9"}], "+", 
          SqrtBox["93"]}], ")"}]}]], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "9"}], "+", 
         SqrtBox["93"]}], ")"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]], 
    SuperscriptBox["3", 
     RowBox[{"2", "/", "3"}]]]}]}]], "Output",
 ImageSize->{281, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39313673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Quartics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8894379],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " does not use general formulas for solving quartics in radicals:"
}], "ExampleText",
 CellID->218375062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", ">", "a"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", "x", "-", "9"}], "\[Equal]", "0"}]}]}], 
    "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588422049],

Cell[BoxData[
 RowBox[{"a", "<", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "9"}], "+", "#1", "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}]], "Output",
 ImageSize->{170, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253286314]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " expresses roots of quartics in terms of radicals:"
}], "ExampleText",
 CellID->1763111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", ">", "a"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", "x", "-", "9"}], "\[Equal]", "0"}]}]}], 
    "]"}], ",", "Reals", ",", 
   RowBox[{"Quartics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18202855],

Cell[BoxData[
 RowBox[{"a", "<", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["2", 
          RowBox[{"1", "+", 
           SqrtBox["6913"]}]], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["6913"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"12", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["2", 
           RowBox[{"1", "+", 
            SqrtBox["6913"]}]], ")"}], 
         RowBox[{"1", "/", "3"}]]}], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SqrtBox["6913"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], "+", 
       FractionBox["2", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "12"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["2", 
              RowBox[{"1", "+", 
               SqrtBox["6913"]}]], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SqrtBox["6913"]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}]]]}], ")"}]}]}]}]}]], "Output",
 ImageSize->{576, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->783358861]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->437839846],

Cell["\<\
This computation takes a long time due to high degrees of algebraic numbers \
involved:\
\>", "ExampleText",
 CellID->777105701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", " ", "z"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "8"}], " ", "+", " ", 
         RowBox[{"2", 
          RowBox[{"y", "^", "8"}]}], " ", "+", " ", 
         RowBox[{"3", 
          RowBox[{"z", "^", "8"}]}]}], " ", "\[LessEqual]", "1"}], " ", "&&", 
       " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "3"}], "-", " ", 
         RowBox[{"9", 
          RowBox[{"y", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"7", 
          RowBox[{"z", "^", "3"}]}], "-", 
         RowBox[{"x", " ", "y", " ", "z"}]}], "\[GreaterEqual]", "10"}]}]}], 
     "]"}], ",", "Reals"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568869471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100.484`", ",", "False"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615417061]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "100"}]], 
  "InlineFormula"],
 " we get an answer faster, but it may be incorrect:"
}], "ExampleText",
 CellID->2548684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", " ", "z"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "8"}], " ", "+", " ", 
         RowBox[{"2", 
          RowBox[{"y", "^", "8"}]}], " ", "+", " ", 
         RowBox[{"3", 
          RowBox[{"z", "^", "8"}]}]}], " ", "\[LessEqual]", "1"}], " ", "&&", 
       " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "3"}], "-", " ", 
         RowBox[{"9", 
          RowBox[{"y", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"7", 
          RowBox[{"z", "^", "3"}]}]}], "\[GreaterEqual]", "10"}]}]}], "]"}], 
    ",", "Reals", ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->620387507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"29.172000000000025`", ",", "False"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398776978]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14397],

Cell["Find conditions for a quintic to have all roots equal:", "ExampleText",
 CellID->295732803],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "+", 
   RowBox[{"a", " ", 
    RowBox[{"x", "^", "4"}]}], " ", "+", " ", 
   RowBox[{"b", " ", 
    RowBox[{"x", "^", "3"}]}], " ", "+", " ", 
   RowBox[{"c", " ", 
    RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
   RowBox[{"d", " ", "x"}], " ", "+", " ", "e"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172345212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "==", "0"}], ",", 
    RowBox[{"ForAll", "[", 
     RowBox[{"y", ",", 
      RowBox[{
       RowBox[{"f", "[", "y", "]"}], "==", "0"}], ",", " ", 
      RowBox[{"x", "==", "y"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->694531945],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"5", " ", "b"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "b"}], "-", 
    RowBox[{"5", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"20", " ", "d"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "c"}], "-", 
    RowBox[{"10", " ", "d"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"100", " ", "e"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "d"}], "-", 
    RowBox[{"25", " ", "e"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], "-", 
    RowBox[{"20", " ", "a", " ", "e"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "d"}], "-", 
    RowBox[{"10", " ", "a", " ", "e"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", "d"}], "-", 
    RowBox[{"5", " ", "b", " ", "e"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{"5", " ", "c", " ", "e"}]}], "\[Equal]", "0"}]}]], "Output",
 ImageSize->{505, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186619961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15835217],

Cell["\<\
Prove the inequality between the arithmetic mean and the geometric mean:\
\>", "ExampleText",
 CellID->49187758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{"b", ">", "0"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "/", "2"}], "\[GreaterEqual]", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", " ", "b"}], "]"}]}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226717895],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227269363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->639407459],

Cell["\<\
Prove a special case of H\[ODoubleDot]lder's inequality:\
\>", "ExampleText",
 CellID->604358210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{"b", ">", "0"}], "&&", 
      RowBox[{"c", ">", "0"}], "&&", 
      RowBox[{"d", ">", "0"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{"b", " ", "d"}]}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"c", "^", "2"}], "+", 
         RowBox[{"d", "^", "2"}]}], "]"}]}]}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->549226970],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251300098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237324540],

Cell["Prove a special case of Minkowski's inequality:", "ExampleText",
 CellID->32116044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "d"}], ")"}], "^", "2"}]}], "]"}], "\[LessEqual]",
       
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], "]"}], "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"c", "^", "2"}], "+", 
         RowBox[{"d", "^", "2"}]}], "]"}]}]}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65274632],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56274901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->372298976],

Cell["Find conditions for a quadratic to be always positive:", "ExampleText",
 CellID->571354619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], ">", "0"}]}], "]"}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3722289],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{342, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405277278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97572279],

Cell["Test whether one region is included in another:", "ExampleText",
 CellID->102801770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", " ", 
  RowBox[{
   RowBox[{"ForAll", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "x"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"2", " ", "x", " ", "y"}]}], "\[LessEqual]", "1"}], 
      "\[Implies]", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "2"}]}]}], "]"}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52993724],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170667806]
}, Open  ]],

Cell["Plot the relationship:", "ExampleText",
 CellID->241929558],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RegionPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "x"}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"], "+", 
         RowBox[{"2", " ", "x", " ", "y"}]}], "\[LessEqual]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "35"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Pink"}]}], "]"}], ",", 
     RowBox[{"RegionPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35717418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"r2", ",", "r1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204010330],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->38530531]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10899],

Cell[TextData[{
 "For fully quantified systems of equations and inequalities ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->263420728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->806166019],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->541851932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361755979],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43674746]
}, Open  ]],

Cell[TextData[{
 "A solution instance can be found with ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->296006325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "3"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63628572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["5", "4"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox[
      SqrtBox["61"], "8"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{136, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->724263745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->432897616],

Cell[TextData[{
 "For systems with free variables ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " may return an unsolved system:"
}], "ExampleText",
 CellID->10832987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"2", "a", " ", "x"}], "+", "b"}], "<", "0"}], "&&", 
      RowBox[{
       RowBox[{"2", "x"}], ">", 
       RowBox[{"a", "+", 
        RowBox[{"b", "^", "2"}], "-", "1"}]}]}]}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275436192],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "a"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"4", " ", "b"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    SuperscriptBox["b", "4"]}], ">", "1"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", "b"}], ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "-", 
      SuperscriptBox["b", "2"]}], ">", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "-", 
      SuperscriptBox["b", "2"]}], ">", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"4", " ", "b"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"]}], "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{404, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3842220]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " eliminates quantifiers and solves the resulting system:"
}], "ExampleText",
 CellID->51746291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"2", "a", " ", "x"}], "+", "b"}], "<", "0"}], "&&", 
      RowBox[{
       RowBox[{"2", "x"}], ">", 
       RowBox[{"a", "+", 
        RowBox[{"b", "^", "2"}], "-", "1"}]}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190641450],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{514, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->670471480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->718331119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " can be used to eliminate variables from systems of complex polynomial \
equations:"
}], "ExampleText",
 CellID->171844387],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "z"}], "\[Equal]", "y"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"x", "^", "2"}], 
       RowBox[{"z", "^", "2"}]}]}], "\[Equal]", "1"}]}]}], ";"}], "\n", 
 RowBox[{"Eliminate", "[", 
  RowBox[{"eqns", ",", "z"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->390638522],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "2"], "\[Equal]", 
  RowBox[{"1", "-", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27222524]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " gives the same equations, but may also give inequations:"
}], "ExampleText",
 CellID->13015819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"z", ",", "eqns"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->566447379],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], "&&", 
  RowBox[{"x", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22988669]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12368],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " appears in an inequality, it is assumed to be real:"
}], "ExampleText",
 CellID->343714591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "<", 
     RowBox[{"-", "1"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17926567],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->739117076]
}, Open  ]],

Cell[TextData[{
 "This allows complex values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " for which both sides of the inequality are real:"
}], "ExampleText",
 CellID->655705013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "<", 
      RowBox[{"-", "1"}]}]}], "]"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114150870],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->482810094]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23615],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3182]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25651],

Cell[TextData[ButtonBox["Quantifiers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Quantifiers"]], "Tutorials",
 CellID->28612],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "Tutorials",
 CellID->212396704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20507],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5786"], None}]], "RelatedLinks",
 CellID->31335]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->860232071],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->735748230],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->15625164],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->143125872],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->86841856]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 35.2387820}", "context" -> "System`", 
    "keywords" -> {
     "cylindrical decomposition", "decision problem", 
      "existential quantifier", "geometric theorem proving", "Groebner basis",
       "quantifier elimination", "remove quantifiers", "SAT problem", 
      "satisfiability problem", "theorem proving", "universal quantifier"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Resolve[expr] attempts to resolve expr into a form that eliminates \
ForAll and Exists quantifiers. Resolve[expr, dom] works over the domain dom. \
Common choices of dom are Complexes, Reals and Booleans. ", "synonyms" -> {}, 
    "title" -> "Resolve", "type" -> "Symbol", "uri" -> "ref/Resolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8088, 264, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57668404]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 124795, 4228}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2784, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3407, 89, 45, 1, 70, "ObjectName",
 CellID->15458],
Cell[3455, 92, 1816, 60, 70, "Usage",
 CellID->24]
}, Open  ]],
Cell[CellGroupData[{
Cell[5308, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5786, 174, 326, 12, 70, "Notes",
 CellID->20986],
Cell[6115, 188, 332, 11, 70, "Notes",
 CellID->25526],
Cell[6450, 201, 385, 13, 70, "Notes",
 CellID->15629],
Cell[6838, 216, 347, 10, 70, "Notes",
 CellID->22357],
Cell[7188, 228, 443, 16, 70, "Notes",
 CellID->24517],
Cell[7634, 246, 417, 13, 70, "Notes",
 CellID->8713]
}, Closed]],
Cell[CellGroupData[{
Cell[8088, 264, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57668404],
Cell[CellGroupData[{
Cell[8472, 278, 147, 5, 70, "ExampleSection",
 CellID->80999812],
Cell[8622, 285, 79, 1, 70, "ExampleText",
 CellID->23762659],
Cell[CellGroupData[{
Cell[8726, 290, 316, 11, 28, "Input",
 CellID->287110999],
Cell[9045, 303, 161, 5, 36, "Output",
 CellID->172681968]
}, Open  ]],
Cell[9221, 311, 122, 3, 70, "ExampleText",
 CellID->359183303],
Cell[CellGroupData[{
Cell[9368, 318, 330, 12, 28, "Input",
 CellID->566463313],
Cell[9701, 332, 975, 34, 58, "Output",
 CellID->51765877]
}, Open  ]],
Cell[10691, 369, 127, 3, 70, "ExampleText",
 CellID->167253360],
Cell[CellGroupData[{
Cell[10843, 376, 626, 21, 70, "Input",
 CellID->322384905],
Cell[11472, 399, 572, 20, 39, "Output",
 CellID->685512367]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12093, 425, 220, 7, 70, "ExampleSection",
 CellID->30220266],
Cell[CellGroupData[{
Cell[12338, 436, 235, 7, 70, "ExampleSubsection",
 CellID->741232164],
Cell[12576, 445, 121, 3, 70, "ExampleText",
 CellID->706341477],
Cell[CellGroupData[{
Cell[12722, 452, 290, 10, 70, "Input",
 CellID->25191051],
Cell[13015, 464, 161, 5, 36, "Output",
 CellID->127509417]
}, Open  ]],
Cell[13191, 472, 124, 3, 70, "ExampleDelimiter",
 CellID->50107856],
Cell[13318, 477, 121, 3, 70, "ExampleText",
 CellID->114315605],
Cell[CellGroupData[{
Cell[13464, 484, 546, 19, 70, "Input",
 CellID->334270597],
Cell[14013, 505, 161, 5, 36, "Output",
 CellID->113944237]
}, Open  ]],
Cell[14189, 513, 125, 3, 70, "ExampleDelimiter",
 CellID->121571775],
Cell[14317, 518, 114, 3, 70, "ExampleText",
 CellID->168866784],
Cell[CellGroupData[{
Cell[14456, 525, 446, 15, 70, "Input",
 CellID->418580139],
Cell[14905, 542, 162, 5, 36, "Output",
 CellID->187777044]
}, Open  ]],
Cell[CellGroupData[{
Cell[15104, 552, 405, 14, 70, "Input",
 CellID->81322241],
Cell[15512, 568, 161, 5, 36, "Output",
 CellID->253810122]
}, Open  ]],
Cell[15688, 576, 124, 3, 70, "ExampleDelimiter",
 CellID->36043039],
Cell[15815, 581, 113, 3, 70, "ExampleText",
 CellID->7119569],
Cell[CellGroupData[{
Cell[15953, 588, 595, 20, 70, "Input",
 CellID->210942678],
Cell[16551, 610, 419, 14, 36, "Output",
 CellID->225666176]
}, Open  ]],
Cell[16985, 627, 125, 3, 70, "ExampleDelimiter",
 CellID->275898722],
Cell[17113, 632, 113, 3, 70, "ExampleText",
 CellID->500979440],
Cell[CellGroupData[{
Cell[17251, 639, 574, 19, 70, "Input",
 CellID->804315401],
Cell[17828, 660, 2539, 80, 96, "Output",
 CellID->21922202]
}, Open  ]],
Cell[20382, 743, 125, 3, 70, "ExampleDelimiter",
 CellID->201579014],
Cell[20510, 748, 119, 3, 70, "ExampleText",
 CellID->218083473],
Cell[CellGroupData[{
Cell[20654, 755, 385, 13, 70, "Input",
 CellID->101700695],
Cell[21042, 770, 247, 8, 36, "Output",
 CellID->182832422]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21338, 784, 232, 7, 70, "ExampleSubsection",
 CellID->98928300],
Cell[21573, 793, 121, 3, 70, "ExampleText",
 CellID->126185585],
Cell[CellGroupData[{
Cell[21719, 800, 324, 11, 70, "Input",
 CellID->11210030],
Cell[22046, 813, 161, 5, 36, "Output",
 CellID->682548528]
}, Open  ]],
Cell[22222, 821, 125, 3, 70, "ExampleDelimiter",
 CellID->636503092],
Cell[22350, 826, 122, 3, 70, "ExampleText",
 CellID->60489641],
Cell[CellGroupData[{
Cell[22497, 833, 329, 11, 70, "Input",
 CellID->340262036],
Cell[22829, 846, 162, 5, 36, "Output",
 CellID->566743702]
}, Open  ]],
Cell[23006, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->163659358],
Cell[23134, 859, 121, 3, 70, "ExampleText",
 CellID->386441401],
Cell[CellGroupData[{
Cell[23280, 866, 583, 20, 70, "Input",
 CellID->392893401],
Cell[23866, 888, 160, 5, 36, "Output",
 CellID->54911719]
}, Open  ]],
Cell[24041, 896, 125, 3, 70, "ExampleDelimiter",
 CellID->588868794],
Cell[24169, 901, 114, 3, 70, "ExampleText",
 CellID->191842668],
Cell[CellGroupData[{
Cell[24308, 908, 493, 16, 70, "Input",
 CellID->89763932],
Cell[24804, 926, 162, 5, 36, "Output",
 CellID->116913249]
}, Open  ]],
Cell[CellGroupData[{
Cell[25003, 936, 453, 15, 70, "Input",
 CellID->147214915],
Cell[25459, 953, 159, 5, 36, "Output",
 CellID->4741930]
}, Open  ]],
Cell[25633, 961, 122, 3, 70, "ExampleDelimiter",
 CellID->269612],
Cell[25758, 966, 102, 2, 70, "ExampleText",
 CellID->81962537],
Cell[CellGroupData[{
Cell[25885, 972, 696, 24, 70, "Input",
 CellID->21800398],
Cell[26584, 998, 4263, 74, 70, "Output",
 Evaluatable->False,
 CellID->352957677]
}, Open  ]],
Cell[30862, 1075, 125, 3, 70, "ExampleDelimiter",
 CellID->520459019],
Cell[30990, 1080, 112, 3, 70, "ExampleText",
 CellID->668546723],
Cell[CellGroupData[{
Cell[31127, 1087, 576, 19, 70, "Input",
 CellID->288792855],
Cell[31706, 1108, 4653, 80, 70, "Output",
 Evaluatable->False,
 CellID->386985061]
}, Open  ]],
Cell[36374, 1191, 125, 3, 70, "ExampleDelimiter",
 CellID->736131332],
Cell[36502, 1196, 113, 3, 70, "ExampleText",
 CellID->799637042],
Cell[CellGroupData[{
Cell[36640, 1203, 581, 20, 70, "Input",
 CellID->195265571],
Cell[37224, 1225, 2107, 64, 127, "Output",
 CellID->108422537]
}, Open  ]],
Cell[39346, 1292, 125, 3, 70, "ExampleDelimiter",
 CellID->167602913],
Cell[39474, 1297, 130, 4, 70, "ExampleText",
 CellID->332999475],
Cell[CellGroupData[{
Cell[39629, 1305, 616, 20, 70, "Input",
 CellID->673622182],
Cell[40248, 1327, 3096, 104, 115, "Output",
 CellID->287503614]
}, Open  ]],
Cell[43359, 1434, 125, 3, 70, "ExampleDelimiter",
 CellID->137718676],
Cell[43487, 1439, 131, 4, 70, "ExampleText",
 CellID->1728819],
Cell[CellGroupData[{
Cell[43643, 1447, 561, 19, 70, "Input",
 CellID->167634249],
Cell[44207, 1468, 3286, 58, 70, "Output",
 Evaluatable->False,
 CellID->37009585]
}, Open  ]],
Cell[47508, 1529, 125, 3, 70, "ExampleDelimiter",
 CellID->351022213],
Cell[47636, 1534, 119, 3, 70, "ExampleText",
 CellID->487604460],
Cell[CellGroupData[{
Cell[47780, 1541, 666, 22, 70, "Input",
 CellID->610519768],
Cell[48449, 1565, 346, 12, 39, "Output",
 CellID->20734296]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48844, 1583, 236, 7, 70, "ExampleSubsection",
 CellID->247179601],
Cell[49083, 1592, 116, 3, 70, "ExampleText",
 CellID->91649387],
Cell[CellGroupData[{
Cell[49224, 1599, 576, 20, 70, "Input",
 CellID->31436120],
Cell[49803, 1621, 161, 5, 36, "Output",
 CellID->397690229]
}, Open  ]],
Cell[49979, 1629, 124, 3, 70, "ExampleDelimiter",
 CellID->56626870],
Cell[50106, 1634, 136, 4, 70, "ExampleText",
 CellID->610547063],
Cell[CellGroupData[{
Cell[50267, 1642, 625, 21, 70, "Input",
 CellID->336458608],
Cell[50895, 1665, 161, 5, 36, "Output",
 CellID->195159341]
}, Open  ]],
Cell[51071, 1673, 124, 3, 70, "ExampleDelimiter",
 CellID->20516472],
Cell[51198, 1678, 120, 3, 70, "ExampleText",
 CellID->68329701],
Cell[CellGroupData[{
Cell[51343, 1685, 351, 12, 70, "Input",
 CellID->626380406],
Cell[51697, 1699, 161, 5, 36, "Output",
 CellID->600531274]
}, Open  ]],
Cell[51873, 1707, 125, 3, 70, "ExampleDelimiter",
 CellID->327203451],
Cell[52001, 1712, 123, 3, 70, "ExampleText",
 CellID->292309597],
Cell[CellGroupData[{
Cell[52149, 1719, 313, 11, 70, "Input",
 CellID->50212146],
Cell[52465, 1732, 160, 5, 36, "Output",
 CellID->68034724]
}, Open  ]],
Cell[52640, 1740, 123, 3, 70, "ExampleDelimiter",
 CellID->7255924],
Cell[52766, 1745, 102, 2, 70, "ExampleText",
 CellID->571787434],
Cell[CellGroupData[{
Cell[52893, 1751, 686, 20, 70, "Input",
 CellID->136926990],
Cell[53582, 1773, 161, 5, 36, "Output",
 CellID->52486410]
}, Open  ]],
Cell[CellGroupData[{
Cell[53780, 1783, 685, 20, 70, "Input",
 CellID->5225840],
Cell[54468, 1805, 160, 5, 36, "Output",
 CellID->79529143]
}, Open  ]],
Cell[54643, 1813, 125, 3, 70, "ExampleDelimiter",
 CellID->487716768],
Cell[54771, 1818, 115, 3, 70, "ExampleText",
 CellID->149610693],
Cell[CellGroupData[{
Cell[54911, 1825, 405, 14, 70, "Input",
 CellID->408955322],
Cell[55319, 1841, 162, 5, 36, "Output",
 CellID->288789391]
}, Open  ]],
Cell[CellGroupData[{
Cell[55518, 1851, 482, 16, 70, "Input",
 CellID->78572943],
Cell[56003, 1869, 161, 5, 36, "Output",
 CellID->254917575]
}, Open  ]],
Cell[56179, 1877, 125, 3, 70, "ExampleDelimiter",
 CellID->160308141],
Cell[56307, 1882, 96, 1, 70, "ExampleText",
 CellID->146235021],
Cell[CellGroupData[{
Cell[56428, 1887, 437, 15, 70, "Input",
 CellID->264134555],
Cell[56868, 1904, 161, 5, 36, "Output",
 CellID->332185882]
}, Open  ]],
Cell[57044, 1912, 125, 3, 70, "ExampleDelimiter",
 CellID->140799112],
Cell[57172, 1917, 114, 3, 70, "ExampleText",
 CellID->297997273],
Cell[CellGroupData[{
Cell[57311, 1924, 536, 18, 70, "Input",
 CellID->454294297],
Cell[57850, 1944, 160, 5, 36, "Output",
 CellID->39404964]
}, Open  ]],
Cell[58025, 1952, 124, 3, 70, "ExampleDelimiter",
 CellID->11130723],
Cell[58152, 1957, 137, 4, 70, "ExampleText",
 CellID->502130737],
Cell[CellGroupData[{
Cell[58314, 1965, 582, 19, 70, "Input",
 CellID->572071652],
Cell[58899, 1986, 161, 5, 36, "Output",
 CellID->555001849]
}, Open  ]],
Cell[59075, 1994, 125, 3, 70, "ExampleDelimiter",
 CellID->731201360],
Cell[59203, 1999, 110, 3, 70, "ExampleText",
 CellID->4884468],
Cell[CellGroupData[{
Cell[59338, 2006, 628, 22, 70, "Input",
 CellID->146539654],
Cell[59969, 2030, 161, 5, 36, "Output",
 CellID->634646629]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60179, 2041, 235, 7, 70, "ExampleSubsection",
 CellID->104018231],
Cell[60417, 2050, 88, 1, 70, "ExampleText",
 CellID->9706577],
Cell[CellGroupData[{
Cell[60530, 2055, 500, 16, 70, "Input",
 CellID->442917868],
Cell[61033, 2073, 161, 5, 36, "Output",
 CellID->392747214]
}, Open  ]],
Cell[61209, 2081, 125, 3, 70, "ExampleDelimiter",
 CellID->258260121],
Cell[61337, 2086, 115, 3, 70, "ExampleText",
 CellID->42740151],
Cell[CellGroupData[{
Cell[61477, 2093, 506, 16, 70, "Input",
 CellID->141745785],
Cell[61986, 2111, 317, 12, 36, "Output",
 CellID->18519872]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62352, 2129, 234, 7, 70, "ExampleSubsection",
 CellID->480968683],
Cell[62589, 2138, 142, 4, 70, "ExampleText",
 CellID->416860605],
Cell[CellGroupData[{
Cell[62756, 2146, 420, 14, 70, "Input",
 CellID->385046663],
Cell[63179, 2162, 160, 5, 36, "Output",
 CellID->20973446]
}, Open  ]],
Cell[63354, 2170, 124, 3, 70, "ExampleDelimiter",
 CellID->20662917],
Cell[63481, 2175, 289, 11, 70, "ExampleText",
 CellID->32888600],
Cell[CellGroupData[{
Cell[63795, 2190, 333, 12, 70, "Input",
 CellID->381496655],
Cell[64131, 2204, 161, 5, 36, "Output",
 CellID->244978302]
}, Open  ]],
Cell[64307, 2212, 125, 3, 70, "ExampleDelimiter",
 CellID->606489584],
Cell[64435, 2217, 121, 3, 70, "ExampleText",
 CellID->614570127],
Cell[CellGroupData[{
Cell[64581, 2224, 294, 9, 70, "Input",
 CellID->314513323],
Cell[64878, 2235, 436, 15, 36, "Output",
 CellID->50107770]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[65375, 2257, 218, 7, 70, "ExampleSection",
 CellID->19831],
Cell[CellGroupData[{
Cell[65618, 2268, 237, 7, 70, "ExampleSubsection",
 CellID->157444474],
Cell[65858, 2277, 233, 9, 70, "ExampleText",
 CellID->328585869],
Cell[CellGroupData[{
Cell[66116, 2290, 747, 24, 70, "Input",
 CellID->145416537],
Cell[66866, 2316, 8235, 220, 282, "Output",
 CellID->563615179]
}, Open  ]],
Cell[75116, 2539, 443, 17, 70, "ExampleText",
 CellID->254790440],
Cell[CellGroupData[{
Cell[75584, 2560, 806, 25, 70, "Input",
 CellID->375275797],
Cell[76393, 2587, 5658, 150, 206, "Output",
 CellID->327654299]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82100, 2743, 227, 7, 70, "ExampleSubsection",
 CellID->675506344],
Cell[82330, 2752, 253, 8, 70, "ExampleText",
 CellID->458422457],
Cell[CellGroupData[{
Cell[82608, 2764, 349, 12, 70, "Input",
 CellID->535287292],
Cell[82960, 2778, 322, 11, 39, "Output",
 CellID->318235755]
}, Open  ]],
Cell[83297, 2792, 458, 17, 70, "ExampleText",
 CellID->248533402],
Cell[CellGroupData[{
Cell[83780, 2813, 397, 13, 70, "Input",
 CellID->110410003],
Cell[84180, 2828, 766, 29, 72, "Output",
 CellID->39313673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84995, 2863, 227, 7, 70, "ExampleSubsection",
 CellID->8894379],
Cell[85225, 2872, 255, 8, 70, "ExampleText",
 CellID->218375062],
Cell[CellGroupData[{
Cell[85505, 2884, 349, 12, 70, "Input",
 CellID->588422049],
Cell[85857, 2898, 344, 12, 39, "Output",
 CellID->253286314]
}, Open  ]],
Cell[86216, 2913, 462, 17, 70, "ExampleText",
 CellID->1763111],
Cell[CellGroupData[{
Cell[86703, 2934, 398, 13, 70, "Input",
 CellID->18202855],
Cell[87104, 2949, 1920, 67, 178, "Output",
 CellID->783358861]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89073, 3022, 237, 7, 70, "ExampleSubsection",
 CellID->437839846],
Cell[89313, 3031, 138, 4, 70, "ExampleText",
 CellID->777105701],
Cell[CellGroupData[{
Cell[89476, 3039, 882, 27, 70, "Input",
 CellID->568869471],
Cell[90361, 3068, 215, 7, 36, "Output",
 CellID->615417061]
}, Open  ]],
Cell[90591, 3078, 283, 10, 70, "ExampleText",
 CellID->2548684],
Cell[CellGroupData[{
Cell[90899, 3092, 892, 28, 70, "Input",
 CellID->620387507],
Cell[91794, 3122, 226, 7, 36, "Output",
 CellID->398776978]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[92081, 3136, 223, 7, 70, "ExampleSection",
 CellID->14397],
Cell[92307, 3145, 97, 1, 70, "ExampleText",
 CellID->295732803],
Cell[92407, 3148, 425, 13, 70, "Input",
 CellID->172345212],
Cell[CellGroupData[{
Cell[92857, 3165, 392, 12, 70, "Input",
 CellID->694531945],
Cell[93252, 3179, 1413, 48, 54, "Output",
 CellID->186619961]
}, Open  ]],
Cell[94680, 3230, 124, 3, 70, "ExampleDelimiter",
 CellID->15835217],
Cell[94807, 3235, 122, 3, 70, "ExampleText",
 CellID->49187758],
Cell[CellGroupData[{
Cell[94954, 3242, 523, 18, 70, "Input",
 CellID->226717895],
Cell[95480, 3262, 161, 5, 36, "Output",
 CellID->227269363]
}, Open  ]],
Cell[95656, 3270, 125, 3, 70, "ExampleDelimiter",
 CellID->639407459],
Cell[95784, 3275, 107, 3, 70, "ExampleText",
 CellID->604358210],
Cell[CellGroupData[{
Cell[95916, 3282, 824, 27, 70, "Input",
 CellID->549226970],
Cell[96743, 3311, 161, 5, 36, "Output",
 CellID->251300098]
}, Open  ]],
Cell[96919, 3319, 125, 3, 70, "ExampleDelimiter",
 CellID->237324540],
Cell[97047, 3324, 89, 1, 70, "ExampleText",
 CellID->32116044],
Cell[CellGroupData[{
Cell[97161, 3329, 828, 28, 70, "Input",
 CellID->65274632],
Cell[97992, 3359, 160, 5, 36, "Output",
 CellID->56274901]
}, Open  ]],
Cell[98167, 3367, 125, 3, 70, "ExampleDelimiter",
 CellID->372298976],
Cell[98295, 3372, 97, 1, 70, "ExampleText",
 CellID->571354619],
Cell[CellGroupData[{
Cell[98417, 3377, 339, 12, 70, "Input",
 CellID->3722289],
Cell[98759, 3391, 976, 34, 58, "Output",
 CellID->405277278]
}, Open  ]],
Cell[99750, 3428, 124, 3, 70, "ExampleDelimiter",
 CellID->97572279],
Cell[99877, 3433, 90, 1, 70, "ExampleText",
 CellID->102801770],
Cell[CellGroupData[{
Cell[99992, 3438, 655, 22, 70, "Input",
 CellID->52993724],
Cell[100650, 3462, 161, 5, 36, "Output",
 CellID->170667806]
}, Open  ]],
Cell[100826, 3470, 65, 1, 70, "ExampleText",
 CellID->241929558],
Cell[100894, 3473, 1209, 38, 70, "Input",
 CellID->35717418],
Cell[CellGroupData[{
Cell[102128, 3515, 149, 5, 70, "Input",
 CellID->204010330],
Cell[102280, 3522, 4640, 80, 70, "Output",
 Evaluatable->False,
 CellID->38530531]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106969, 3608, 233, 7, 70, "ExampleSection",
 CellID->10899],
Cell[107205, 3617, 378, 13, 70, "ExampleText",
 CellID->263420728],
Cell[CellGroupData[{
Cell[107608, 3634, 476, 17, 70, "Input",
 CellID->806166019],
Cell[108087, 3653, 161, 5, 36, "Output",
 CellID->541851932]
}, Open  ]],
Cell[CellGroupData[{
Cell[108285, 3663, 475, 17, 70, "Input",
 CellID->361755979],
Cell[108763, 3682, 160, 5, 36, "Output",
 CellID->43674746]
}, Open  ]],
Cell[108938, 3690, 229, 8, 70, "ExampleText",
 CellID->296006325],
Cell[CellGroupData[{
Cell[109192, 3702, 432, 15, 70, "Input",
 CellID->63628572],
Cell[109627, 3719, 355, 13, 56, "Output",
 CellID->724263745]
}, Open  ]],
Cell[109997, 3735, 125, 3, 70, "ExampleDelimiter",
 CellID->432897616],
Cell[110125, 3740, 242, 8, 70, "ExampleText",
 CellID->10832987],
Cell[CellGroupData[{
Cell[110392, 3752, 464, 16, 70, "Input",
 CellID->275436192],
Cell[110859, 3770, 1297, 45, 58, "Output",
 CellID->3842220]
}, Open  ]],
Cell[112171, 3818, 228, 7, 70, "ExampleText",
 CellID->51746291],
Cell[CellGroupData[{
Cell[112424, 3829, 519, 17, 70, "Input",
 CellID->190641450],
Cell[112946, 3848, 3100, 55, 70, "Output",
 Evaluatable->False,
 CellID->670471480]
}, Open  ]],
Cell[116061, 3906, 125, 3, 70, "ExampleDelimiter",
 CellID->718331119],
Cell[116189, 3911, 262, 8, 70, "ExampleText",
 CellID->171844387],
Cell[CellGroupData[{
Cell[116476, 3923, 443, 15, 70, "Input",
 CellID->390638522],
Cell[116922, 3940, 258, 9, 36, "Output",
 CellID->27222524]
}, Open  ]],
Cell[117195, 3952, 231, 7, 70, "ExampleText",
 CellID->13015819],
Cell[CellGroupData[{
Cell[117451, 3963, 163, 5, 70, "Input",
 CellID->566447379],
Cell[117617, 3970, 350, 12, 36, "Output",
 CellID->22988669]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118016, 3988, 226, 7, 70, "ExampleSection",
 CellID->12368],
Cell[118245, 3997, 180, 6, 70, "ExampleText",
 CellID->343714591],
Cell[CellGroupData[{
Cell[118450, 4007, 231, 8, 70, "Input",
 CellID->17926567],
Cell[118684, 4017, 162, 5, 36, "Output",
 CellID->739117076]
}, Open  ]],
Cell[118861, 4025, 199, 6, 70, "ExampleText",
 CellID->655705013],
Cell[CellGroupData[{
Cell[119085, 4035, 268, 9, 70, "Input",
 CellID->114150870],
Cell[119356, 4046, 161, 5, 36, "Output",
 CellID->482810094]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[119578, 4058, 311, 9, 70, "SeeAlsoSection",
 CellID->23615],
Cell[119892, 4069, 1213, 44, 70, "SeeAlso",
 CellID->3182]
}, Open  ]],
Cell[CellGroupData[{
Cell[121142, 4118, 314, 9, 70, "TutorialsSection",
 CellID->25651],
Cell[121459, 4129, 133, 3, 70, "Tutorials",
 CellID->28612],
Cell[121595, 4134, 165, 3, 70, "Tutorials",
 CellID->212396704]
}, Open  ]],
Cell[CellGroupData[{
Cell[121797, 4142, 321, 9, 70, "RelatedLinksSection",
 CellID->20507],
Cell[122121, 4153, 253, 5, 70, "RelatedLinks",
 CellID->31335]
}, Open  ]],
Cell[CellGroupData[{
Cell[122411, 4163, 319, 9, 70, "MoreAboutSection",
 CellID->860232071],
Cell[122733, 4174, 156, 3, 70, "MoreAbout",
 CellID->735748230],
Cell[122892, 4179, 156, 3, 70, "MoreAbout",
 CellID->15625164],
Cell[123051, 4184, 147, 3, 70, "MoreAbout",
 CellID->143125872],
Cell[123201, 4189, 146, 3, 70, "MoreAbout",
 CellID->86841856]
}, Open  ]],
Cell[123362, 4195, 27, 0, 70, "History"],
Cell[123392, 4197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

