(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16118,        601]
NotebookOptionsPosition[     12361,        472]
NotebookOutlinePosition[     13618,        508]
CellTagsIndexPosition[     13533,        503]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Break" :> Documentation`HelpLookup["paclet:ref/Break"], 
          "Throw" :> Documentation`HelpLookup["paclet:ref/Throw"], "Abort" :> 
          Documentation`HelpLookup["paclet:ref/Abort"], "DialogReturn" :> 
          Documentation`HelpLookup["paclet:ref/DialogReturn"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Break\"\>", 2->"\<\"Throw\"\>", 
       3->"\<\"Abort\"\>", 4->"\<\"DialogReturn\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>", 
       3->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Return", "ObjectName",
 CellID->13858],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Return",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Return"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the value ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " from a function. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Return",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Return"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the value ",
     Cell[BoxData[
      ButtonBox["Null",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Null"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2851]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " exits control structures within the definition of a function, and gives \
the value ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " for the whole function. "
}], "Notes",
 CellID->18703],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " takes effect as soon as it is evaluated, even if it appears inside other \
functions. "
}], "Notes",
 CellID->12914],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " can be used inside functions like ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16134]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->675315235],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->29659070],

Cell["Return from a function:", "ExampleText",
 CellID->16248],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", ">", "5"}], ",", 
      RowBox[{"Return", "[", "a", "]"}]}], "]"}], ";", 
    RowBox[{"x", "+", "3"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "6", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257816113],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169988760]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " exits only the innermost construct in which it is invoked:"
}], "ExampleText",
 CellID->217957994],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", ">", "5"}], ",", 
      RowBox[{"Return", "[", "a", "]"}]}], "]"}], ";", "x"}], 
   ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311498136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "6", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260531154],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->259369146]
}, Open  ]],

Cell[TextData[{
 "Here it exits the ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " loop, but not the function ",
 Cell[BoxData["g"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43734571],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x", ">", "5"}], ",", 
        RowBox[{"Return", "[", "a", "]"}]}], "]"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], ";", "x"}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5097478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "6", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->73023666],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->241520917]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " for explicit flow control:"
}], "ExampleText",
 CellID->21155077],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{"Catch", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x", ">", "5"}], ",", 
        RowBox[{"Throw", "[", "a", "]"}]}], "]"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], ";", "x"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->83431108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", "6", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->82277805],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->153713439]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1056],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26758],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->16895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->568252170],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->5184748],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->173507058],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->676889387]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Return - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 42.2702120}", "context" -> "System`", 
    "keywords" -> {"functions", "procedures", "routines", "subroutines"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Return[expr] returns the value expr from a function. Return[] returns \
the value Null. ", "synonyms" -> {}, "title" -> "Return", "type" -> "Symbol", 
    "uri" -> "ref/Return"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5428, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->675315235]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13390, 496}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2308, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2931, 81, 44, 1, 70, "ObjectName",
 CellID->13858],
Cell[2978, 84, 934, 31, 70, "Usage",
 CellID->2851]
}, Open  ]],
Cell[CellGroupData[{
Cell[3949, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4427, 137, 392, 13, 70, "Notes",
 CellID->18703],
Cell[4822, 152, 250, 8, 70, "Notes",
 CellID->12914],
Cell[5075, 162, 316, 12, 70, "Notes",
 CellID->16134]
}, Closed]],
Cell[CellGroupData[{
Cell[5428, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->675315235],
Cell[CellGroupData[{
Cell[5813, 193, 147, 5, 70, "ExampleSection",
 CellID->29659070],
Cell[5963, 200, 62, 1, 70, "ExampleText",
 CellID->16248],
Cell[6028, 203, 310, 11, 70, "Input",
 CellID->4290],
Cell[CellGroupData[{
Cell[6363, 218, 97, 3, 28, "Input",
 CellID->257816113],
Cell[6463, 223, 158, 5, 36, "Output",
 CellID->169988760]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6670, 234, 224, 7, 70, "ExampleSection",
 CellID->693],
Cell[6897, 243, 232, 7, 70, "ExampleText",
 CellID->217957994],
Cell[7132, 252, 294, 11, 70, "Input",
 CellID->311498136],
Cell[CellGroupData[{
Cell[7451, 267, 97, 3, 70, "Input",
 CellID->260531154],
Cell[7551, 272, 158, 5, 36, "Output",
 CellID->259369146]
}, Open  ]],
Cell[7724, 280, 259, 10, 70, "ExampleText",
 CellID->43734571],
Cell[7986, 292, 380, 13, 70, "Input",
 CellID->5097478],
Cell[CellGroupData[{
Cell[8391, 309, 96, 3, 70, "Input",
 CellID->73023666],
Cell[8490, 314, 158, 5, 36, "Output",
 CellID->241520917]
}, Open  ]],
Cell[8663, 322, 329, 13, 70, "ExampleText",
 CellID->21155077],
Cell[8995, 337, 389, 13, 70, "Input",
 CellID->83431108],
Cell[CellGroupData[{
Cell[9409, 354, 96, 3, 70, "Input",
 CellID->82277805],
Cell[9508, 359, 158, 5, 36, "Output",
 CellID->153713439]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9727, 371, 310, 9, 70, "SeeAlsoSection",
 CellID->1056],
Cell[10040, 382, 931, 35, 70, "SeeAlso",
 CellID->19662]
}, Open  ]],
Cell[CellGroupData[{
Cell[11008, 422, 314, 9, 70, "TutorialsSection",
 CellID->26758],
Cell[11325, 433, 164, 3, 70, "Tutorials",
 CellID->16895]
}, Open  ]],
Cell[CellGroupData[{
Cell[11526, 441, 319, 9, 70, "MoreAboutSection",
 CellID->568252170],
Cell[11848, 452, 133, 3, 70, "MoreAbout",
 CellID->5184748],
Cell[11984, 457, 147, 3, 70, "MoreAbout",
 CellID->173507058],
Cell[12134, 462, 155, 3, 70, "MoreAbout",
 CellID->676889387]
}, Open  ]],
Cell[12304, 468, 27, 0, 70, "History"],
Cell[12334, 470, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

