(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11463,        410]
NotebookOptionsPosition[      8280,        306]
NotebookOutlinePosition[      9675,        345]
CellTagsIndexPosition[      9591,        340]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EnterExpressionPacket" :> 
          Documentation`HelpLookup["paclet:ref/EnterExpressionPacket"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"EnterExpressionPacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink Packets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReturnExpressionPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReturnExpressionPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReturnExpressionPacket"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet that contains the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", the result of an ",
     Cell[BoxData[
      ButtonBox["EnterExpressionPacket",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EnterExpressionPacket"]], "InlineFormula"],
     " evaluation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->290323088],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->95976222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "705", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16201300]
}, Open  ]],

Cell["Read the first packet: ", "ExampleText",
 CellID->7997287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->638042991]
}, Open  ]],

Cell[TextData[{
 "Write the expression ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 " to the link without evaluating it:"
}], "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"EnterExpressionPacket", "[", 
     RowBox[{"2", "+", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1893681694],

Cell["\<\
The packet in the middle of the list shows the current state:\
\>", "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LinkRead", "[", "link", "]"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1022125259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OutputNamePacket", "[", "\<\"Out[1]= \"\>", "]"}], ",", 
   RowBox[{"ReturnExpressionPacket", "[", "4", "]"}], ",", 
   RowBox[{"InputNamePacket", "[", "\<\"In[2]:= \"\>", "]"}]}], 
  "}"}]], "Output",
 ImageSize->{573, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->147600690]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1662412026],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EnterExpressionPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EnterExpressionPacket"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->494148692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->6436076]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReturnExpressionPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 39.5826432}", "context" -> "System`", 
    "keywords" -> {
     "output from MathLink", "output packet", "expression packet"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ReturnExpressionPacket[expr] is a MathLink packet that contains the \
expression expr, the result of an EnterExpressionPacket evaluation.", 
    "synonyms" -> {"return expression packet"}, "title" -> 
    "ReturnExpressionPacket", "type" -> "Symbol", "uri" -> 
    "ref/ReturnExpressionPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3432, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9456, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1843, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2466, 75, 65, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2534, 78, 861, 26, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3432, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3809, 123, 148, 5, 70, "ExampleSection",
 CellID->290323088],
Cell[3960, 130, 147, 6, 70, "ExampleText",
 CellID->95976222],
Cell[CellGroupData[{
Cell[4132, 140, 234, 7, 28, "Input",
 CellID->312144257],
Cell[4369, 149, 259, 8, 36, "Output",
 CellID->16201300]
}, Open  ]],
Cell[4643, 160, 64, 1, 70, "ExampleText",
 CellID->7997287],
Cell[CellGroupData[{
Cell[4732, 165, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[4843, 170, 215, 6, 36, "Output",
 CellID->638042991]
}, Open  ]],
Cell[5073, 179, 180, 6, 70, "ExampleText",
 CellID->316479038],
Cell[5256, 187, 247, 7, 70, "Input",
 CellID->1893681694],
Cell[5506, 196, 113, 3, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[5644, 203, 188, 6, 70, "Input",
 CellID->1022125259],
Cell[5835, 211, 384, 11, 36, "Output",
 CellID->147600690]
}, Open  ]],
Cell[6234, 225, 59, 1, 70, "ExampleText",
 CellID->1662412026],
Cell[6296, 228, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6454, 237, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6773, 248, 226, 6, 70, "SeeAlso",
 CellID->494148692]
}, Open  ]],
Cell[CellGroupData[{
Cell[7036, 259, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7357, 270, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[7765, 286, 299, 8, 70, "MoreAboutSection"],
Cell[8067, 296, 141, 3, 70, "MoreAbout",
 CellID->6436076]
}, Open  ]],
Cell[8223, 302, 27, 0, 70, "History"],
Cell[8253, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

