(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2978374,      52449]
NotebookOptionsPosition[   2943425,      51265]
NotebookOutlinePosition[   2945554,      51313]
CellTagsIndexPosition[   2945465,      51308]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolarPlot" :> Documentation`HelpLookup["paclet:ref/PolarPlot"],
           "SphericalPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/SphericalPlot3D"], 
          "ParametricPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot3D"], "Cylinder" :> 
          Documentation`HelpLookup["paclet:ref/Cylinder"], "RotationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/RotationMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolarPlot\"\>", 
       2->"\<\"SphericalPlot3D\"\>", 3->"\<\"ParametricPlot3D\"\>", 
       4->"\<\"Cylinder\"\>", 
       5->"\<\"RotationMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RevolutionPlot3D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RevolutionPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["z", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of the surface of revolution with \
height ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["z", "TI"]]], "InlineFormula"],
     " at radius ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RevolutionPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["z", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["\[Theta]", "TR"], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the azimuthal angle ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     " to vary between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RevolutionPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot of the surface obtained by rotating \
the parametric curve with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["z", "TI"]}]], "InlineFormula"],
     " coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["x", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["z", "TI"]]}], "}"}]], "InlineFormula"],
     " around the ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " axis."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RevolutionPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["\[Theta]", "TR"], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["\[Theta]", "TR"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the azimuthal angle ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     " to vary from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RevolutionPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{
         StyleBox["{", "TR"], 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the surface obtained by rotating the parametric \
curve with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}]], "InlineFormula"],
     " coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["x", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["y", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["z", "TI"]]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RevolutionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["z", "TI"]], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RevolutionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", "0", ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["z", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->291403673],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RevolutionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["z", "TI"]], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Theta]", "TR"], ",", 
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " corresponds to plotting the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " in cylindrical coordinates as a function of radius ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " and angle ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->538881656],

Cell[TextData[{
 "The angle ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " is measured in radians, counterclockwise from the positive ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis when viewed from above."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RevolutionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RevolutionPlot3D"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       StyleBox["f", "TI"], "}"}], ",", 
      RowBox[{"{", 
       StyleBox["g", "TI"], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " plots surfaces corresponding to all the functions ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->37751789],

Cell[TextData[{
 "Holes are left at positions where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " etc. evaluate to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or anything other than real numbers. "
}], "Notes",
 CellID->20967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " treats the variables ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15055],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and evaluates ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " only after assigning specific numerical values to variables."
}], "Notes",
 CellID->13787],

Cell[TextData[{
 "In some cases it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " symbolically before specific numerical values are assigned to variables."
}], "Notes",
 CellID->27224],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->18222],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw boundary lines for surfaces ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxRatios",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxRatios"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "side ratios for the bounding 3D box", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the color of curves and surfaces ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     Cell[BoxData[
      FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["\[Phi]", TraditionalForm]], "InlineMath"],
     " curves to exclude"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExclusionsStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExclusionsStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw at excluded points or curves", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many mesh divisions in each direction to draw ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#4", "&"}], ",", 
      RowBox[{"#5", "&"}]}], "}"}], Cell[
    "how to determine the placement of mesh divisions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh divisions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh divisions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining surfaces", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NormalsFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NormalsFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine effective surface normals", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the initial number of sample points in each parameter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives for the style for each object ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->16439],

Cell[TextData[{
 "Interactive labeling can be specified for surfaces using ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27441],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " initially evaluates each function at a number of equally spaced sample \
points specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to choose additional sample points, \
subdividing in each parameter at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times. "
}], "Notes",
 CellID->31441],

Cell[TextData[{
 "You should realize that with the finite number of sample points used, it is \
possible for ",
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " to miss features in your functions. To check your results, you should try \
increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8872],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{"RevolutionPlot3D", "::", 
    StyleBox["accbend", "TI"]}], "]"}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " print a message if it is unable to reach a certain smoothness of curve."
}], "Notes",
 CellID->40938333],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BoxRatios",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoxRatios"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", slices through the final 3D graphic parallel to the ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " axis give forms that agree with the default aspect ratio used by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->122297948],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]]}], TraditionalForm]], "InlineMath"],
 "\[NegativeThickSpace]. Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 CellID->19176],

Cell["The functions are evaluated all over each surface. ", "Notes",
 CellID->5137],

Cell[TextData[{
 "By default, surfaces are treated as uniform white diffuse reflectors, \
corresponding to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"], "->", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["White",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/White"], "&"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20633],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3241]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->278583170],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->831652957],

Cell[TextData[{
 "Revolve a function curve around the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis: "
}], "ExampleText",
 CellID->326149400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "4"}], "-", 
    RowBox[{"t", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76958772],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362673333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33267003],

Cell[TextData[{
 "Revolve a parametric curve around the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis: "
}], "ExampleText",
 CellID->17312858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35676364],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->575023648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343419216],

Cell[TextData[{
 "Revolve a parametric curve halfway around the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis: "
}], "ExampleText",
 CellID->17628148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114044744],

Cell[GraphicsData["CompressedBitmap", "\<\
eJysvQV4HUmSLqrbsMM8s8M7c3ffztKtI1mW2W7bbbb7yDKzZSgxM8sgZraY
mZmZLGZmZmY68b1XkXWO7Dmt7rH7XX/u6sqsOlnx/xkRGYnmPtWWl1F5qq3w
/OlfL2g+VZdXeK711/NqmkzWp/9LREQkUETkfx34nQhz//8yKfKfAgCIfCoj
IwPkj8h+vIjIMdfPmEwJkqKZK77yyXvvMlf+u0/5Tz/f86k0c/2ESX4fU5/t
foe5ESfPH/J//aOvPd9Hnt/n//6nmPp89zn/G2LknTv8Mn7+Le/c5L/zKyG8
nwilKfL2df5X/1no6adC6f9D3r7KL/t3Qk8/E0r/D3mbyy/7jx/09mV+2X8W
evq5UPq/ydsX+G//VejpPwml/4u8fY4vyb8JPf2eUPo/ydtf8sv+9w96+xS/
7P8Uevp9ofR/kLdP8Mv+b6GnPxBK/428fZT/NiX09IdCaSKpyGG+JGIf9PYB
ftniQk9/JJT+f8jb+/llHxB6+mOhNGGYaCJmHvqgtyn+20eFnv5EKP2v5O3/
4UtyQujpT4XS/5u8/Z/8sk8KPf2ZUJroEWEdy/7yg97+N37ZZ4We/lwo/Rfy
NpHnU8YTsQ9Ezgu99Quh9L980K9+KZT+89//CljP8OG/wh8Jvy3sSf5E3v49
csW8TSzuM/Zb7OfOCb3/a6E08Qciv/v73zE3xNI/383hyy7M7m+E0n/4ttI+
fZcj7P9O/18qV9hTnhJKC3vW339gucJeUliDfyuU/t0HlivsT7/Yqxzh7+zW
tnBpwv72w0r7q1Apwp71xF6cCXP6tVKEPe5xofQfhNK/2bMUYU98TCgt3Jr9
es9ShH2usG/7sFKEffF/8GtB2MP8SSj9qz1LE/a+6O1QVYQ955+F0r/8oNKw
Vfke81g4/5tL+2SPb6NP/SGTL8zfvwilf7GnTHu1AT9hHgtrxl+E0j/fszRh
r4+/+rnA4wm3BsKtxddKE64z5OXHzGORT7nX10TYP1gbwnb/YaULtx5/4iN/
v/RP2PSFUUF6D7a+1qJ+7UvCbQda1aekZOgHfsnoxEW+Z6QpSDOxIJGCe3mB
FCXyGffc8G7zhF/AgHjvWhD+3u93ny/AO1Q7jYJvkfTnsU7vvv1UhsfPfScF
cz0/xcoiZJWYFPbpezMh3C4S30baryUe+2UYAP6XF0rfyZPizs/91FgLcx89
4wnq5toqSnZpgU1/xj0zLkKafhHWA+PHhLVvb9mE21zi6/6JyLaD1ymUEHqB
/c5cMV+6smA253OPV5ijo4rXu9I7AvmkVt9nGeVjhWP+/IYvn7D/3Fs+4daW
yEvarQUi2TiP/SKvGSWYLRIw9jYE0zGO/PRPTIiOPaMRlOTdDWTv6gr3yiKp
4FmWPO4Xw+TTaCMY3Ql7qL0lFG63iR5+H58vEgYniZx9+PmdBpa1nw1lYLIq
DK8JLnh1NcWrriq+/PDJNop1ex2vksssgu9xz82wHHJPDOH1cBcBxmdT2Af9
ZE9ZhWMBYkk/ILJus7XNEIo33SjNVh2fvZ+y8lYTeZNc8erxEq8mGqCphD+4
93gLZbq1Rt7/AWomS+kpVEzusUG8HuwgD/kSC9vr3hILxwWkDn5PJN6CeSL0
BJGY+BQgWrBcjldW5hoic4obxDjgjbMJXvUIzU+fbd95tMna9ve4Xy0xQqPE
X05xv0DPxz0yuOtnUQBhTWTl/YuQvMIRCHnrD8SeNmFhm1UIGCMi96AsPOKQ
lsqIyOl8kUsD8CbOEa/uRDNM1EGLMP1Ieotw/EPudeIDrizyteLUJPf4CFGM
Aa5EB4qEYgjzt7fUwhEPaj75ym9hbps1M5Zj6CJ6XIfXxRK8DhKZa8OhPJBo
M/Gnni/ByQhv9FV4avI7LMc/kry1xr22wleMszMo6xfj3KNEmw/2cfd3kPeE
ZXknMUokHMH8cBfJ4ibMb7H6+ms+wb1EJ1pguxZvFojzGkzDa104vCXyJjlD
lB0xQGO8Gqux/uQXT59s3X2IbkLyxir36jJKfGGO0Q1if2MMx3gj0cPdhzrN
pWrwR3vW/de4FkZAYo7fEQQbML9JzHDnHeHEEqEJtmrwZr6IYEiFjji8qQgi
2u0CMfbEKE3ZWvuRgQpPXR69z+PHm7fvEz8itczXk7Mz3JMTAr98sF+E/OGK
tqGIH6YtfxZ6i7Q03yMI1mB+A2a3iFnuwCiPWJDIj3n1KN5qOcwV8OXvfE/+
NFeIc2Al/6UzURsTNZ6OIspPP9188HCdVAOpgyvzKOzpKaYOiImOcA/0cvd1
8VsdqpZF8zU/tzcO4ViR9Fl+hM8X1mBug9jqNowRLz4ArLky2iRCorHfRVhj
2s0Y7PSwrgxVdjTk0FaePFq/e2+Nr+VX5rmX5lDSk4yiE+s8NMTd38MVbSdq
08ClqlF24TZkb3mFo1ESfVBE3hWYWyOaswnj2zBKRO7jWyujPDvEAJZLYCYP
bwZSoIvwXxUEJb7EDJwgyoZYrinP0QDxmKru6CggHlp6/dGDtVu3VxDPV/Pc
i7Pc88R2j49yDxPblehnqkDQ8lN1XOqtyHfGRGJNcYJpCeZWYIbAmtiEMeKH
+nnQw4MOFJDXANvEJpaKYSaXwErmw6oWwEpxhhhbvPF5wXM15Nlo4w8NlLY0
ZNHOpO+v3r+7wjeLizPc89Pcs8TAjwxzDxAD39dLqqmZXElNfVgrQFqxfbtv
kXdEYH4ZZleJVq3D+CaMEDPp24EuYuvNPF49b6sK7xeL3kMUSxAFQ6kvPkpz
5sXZ8cIs8N7DaMdeF6vaRGlLR25T+RkaysO7AkO/Msc9N8U9M8l3WQcHufv7
BfEt1calGgmqcpEPRkXi/sP8ASYmd24BZpdhmkAaX4dR4rv6t6BnBzqJBjby
eLUo6Fopb7GAN5OD9wNJvM5YvKkJ5pX58vLf4H2CHS/CEm+8jHec9LCmXyht
GihsaNAISfruEvPRmzdIsHZxmntmgnt6Au+PDnP393HF2EpqZ+qJS9WT+0IR
ka9FtntjImOFYgTNHMwuwvQyQbMCY+swTFxA7yZ0b0M7AVS/vVODN6slvIX8
nZlsAiiR1xWDN7VBvHJfXoEHvpBkvxNliTc+Jtuu+lu2mljXRvLrOjLryk9W
Wedw+/rCdSniz85OMnES9wvi0g4NcsV6BLbUwroIIrBwL+Jb8HAwPTsPM4sw
tYT3Yyswsk60bQO6N6GT2FLjNq92a6cKpVwp2lnI257OQhj9CbyuaMysC9op
990pJHhS7HdirLZDXuEPPQy2HLSxrk3k1/Rk1tSf8fHcvT5/U2pOkkv83akx
JopiAhKC5PtcTheXw7aUjWxjyaVyPxgT0btDBNMMzCzA1ALBtASjqzBE/EPP
OnRtQDsxqPotXs3WTiVKuly4s5C7xYcVz+uK2mZhvfVhYOF9qsN2rNV22Gv8
oafBprPOppUaVrqBzKrWs1Xlx+gc7l+fu3V19hoXOwmoeidGuMeGuUeI5xPv
YWBxOa0EUC06PhR778h2Tx9BNG9mEmZmYWqeoJqH0SUYJjbVtwbda9C5Aa0E
WN0mr3pzu4IAK9iez96azsSq6Y/b6Yrcag3D+wqfnSICLN1hJ956K5wA8zbY
cNPdsFVHYEYyyzrPltWfLMvdR5u6c3XmBnda8vI0qbJR7rEhfl+DaaL2dXI5
bQLfV4E29cnHYTuK6elpmJqFSdQJGJ2H4SUYJNh6VqFzDdqJhTVsQs06rxJV
ar14ezlvaz5rczqDxbaN2EIRUqXPdrHHVq4T/iTReivSbCvIBHXaXXfdQXPd
QhkVQe/Zkqb0kvJDxHZfavrWV1NSl6e4F4gLPM7Gmf3Er3cyAc972Eq5VA6i
Ex4d+ZY2S5Sgm4CpaZicIehmYXgehpZgAENc6FqGjlVoIwDrNnjVazsVCHCt
cGs5d3M+c2M6DUH1x253RWy2hmyxAEvct/KcEFSyzVa02WYIAfhGZ81Zc81a
BQEaPFvUkl5UfcgP+u98NXn98qTkBX4892OM/Q/2M7WHwEjtMe0xAVnCpfKY
m+lXMh+GEWMjUiYHpiZgcgrGUUdgZBaGFmCQOJXuJehYhrZVaCGupXaNV7m2
8xYBrxVsLuVszGdsTKUisP6Yra7wjbZgxF/ls1XqvplPQKZYb8aab4aZ4r2n
zqqL5qqd6qqZPHpgHekF9YfzLMj7kpM3L09IXhhne/JMZxKDPkZDxToJtCZi
elXkPp+5LljL4YvC42j/AOcJmBiH8UkCcgqGZmFwAfqxxYHORWhfglaitvVr
UL3Kq1jbKSM48zeWstbn0hHAaMJ2f/Rmd9h6WzA+qubjxEpLtd6IN98IJzi9
tJfdNFcc1FYtFRGn3uM5zYdzjJCyt1CJbl/C7rLk2VHuqWHSGPT9PU4mtqog
91iXq04K344Tcf3LLt7JYZgYZXtiB2FoCgZnoX8eeokv7ViAtiVoJhBrV6Fy
hfd2dacU5V3LXV/KXJtLQxyj8VsDURvdoettQfio2nurzH2jwJFAtFpPMN+I
fLEWZIDa766x7Ki6bKOEEA0ez2o9nGXkk781/ewaxlc3LoxKnh3hnmKHMfq4
Et0MRIEXrWMNkm0BNz2VZ+3kEcLe4xt79q3IyNrEAIwPwfgIjI2xtvGfMDgN
/TPQR1xR5zy0zUPLEjQRY61e4VUs75StbpcgsNWctaWM1blUBDYSt0kwr7UF
4qMa781y941CR2QqzWot0Xw9+uVaiCEW4qGx5Ky6ZKu4aC6LnOo8wOEaxVtT
rNbevjAidXZY8tQg9zjxQAzmfR1c0RZBGFbJpYpRfVncK+6KLKiv4SZjUu/V
6nu4yZjTeC+M98PYIIwOwwgOY8DgBCnzAPRgCwbts9A6D81L0EAinaol3tul
nVIEsJm/vpq9upS+MpuC8EYZ5JHr3SGrbQFIRI3Xxlv39SLH1Rwb/GGi2WrM
y9UwQ7z3VF9wUV20V1ywlMU2TO/BFGu4stcmnnAxqLl+dujqqUHJ4/3cwyRW
E2vnijVzOQ0C91vyDvmWn8rHI8eJABjrgdE+GB2AkSECexT6x6FvEnrYGvgr
tM5C8zw0EoWvWYKKRV7Z0k4JQZ63upq1spi6PJuEydHY9YGIte7glTZ/JKLG
c73Cba3YcSXXBv1e0uuV2Bcr4UbLATroHlxVFhwU561k58hXfsXIq3prQv7a
+DMusn/r3JDUqYGrx/u4h4lP3tfGFWviitZjUIfgi1lThigDkb3ma/bGTOaE
fkI8VTuMdMFILwwPwNAg5vSPQt8Y9ExAN3FlbdMsr3+CBhJeVC3A2wVe6eJO
EVbcRu7KasbyYsrSbCLBHb02EL7aHbTc5ofJ2jerFW6rJY4redaIO/n1cpzp
UoThUpAOUuiuwiL+rdkz9FyMzOq3xhWvjdHckceX0HldO91/9Xiv5OEu7gHS
2RVt5IrWvocb4z+IM4Uonb282Lcg/xmmh9tgqBOGemCoj8Aegr4R6BmF7nHo
xL4BtExC0ww0zLIjEL/hlSzyChHGRvbySvrSYvLiTAJSMBK1MhC2wmBu98Vk
rcdKhetKieNynjVWbvKrpTjTxUhD/mzE75wUZm1lZsyfTpk+mmRk1bw1pnxt
VJY7/OQS6tyNU31Sx7slD3VyJdoQJYdBXMPlMKZdRkDnoFxJZhBniMx9mH6T
0bBfE4VuhMEWGGyHwW4YQDOCvkHoGYbuEehEI4PWCWiehMZpqCPxSNUcvJ2D
0jl2BGYlbXEhaXEmHikYiVweCFvuCVxq90WQte7LlS5LpQ5LZDbmt6E6c/4a
6CpcFKbtZKYsn06+fDTBiKl1c1T12og8d+jZJdS0W6d6pI53Xj3YwRVv5e4n
ToxTzeW8JcFUAX98CdKsIemFCPnzEXjJaFh/A/Q3Q38b9GPzB7290NMPXYPQ
OQztxLE1j0PjBNRPQi02KlAxA2UzUDzLK5zfyUNlX89YICM1fyqwRoVNfTmf
YDwXrT8XqjMboIEUucpPOdCTVk8nXj3C6QndWyNq14YVvhp8frH/0Rlk+Nqx
jquH2rj7Wrj7WF9VxeWUs46ajy/LAdLMPwYfGSM8TWqvGvrqoLcRelugF/tG
0N0DXX3QOQDtxIO1jELTGDSMQ+0EVBNrfjsNpdO8ohlePtbPVtbcevr8SvLc
QsL8TCxCHAlbGAhe6PFfaPdGAupcFyqd5kvt5gut57Nf408SjWdj9GfCtKcD
1TGcc5OfdKQnrJ+Mmz0cY122htSg0pV++kLv4y+70XEfbb96qFlyH3FZYqzp
lnGpItRlPgN5rpBl/d0Y6KmCnhroqYceDMShqx06u6CjB9r6oBWHX6BpGBpG
oG4Masahilh12SQUT/EKpnl5WIFbGbPrqbPLSbPzcXPT0diwj4TODQTN9fjN
tXthss5lrtJxrsx2ttBqNuc1/iTRaCZGbzpcaypIbdJHGct0osdsn4yaPxxh
GdCU7Fe+0id7vkf6dOe9E+i5pA42SYrXo/MSZYNMprkq4FJZAgaKPCHXgblb
idX4MAZ+t8tAVxl0VUBXNXTVQVcT5nS0QnsntHVBSzc0E9fWMAh1w1AzAlVE
68vHoWSCVzjJy5/i5aDib6ZNr6XMLCfMzMfOTEdhLY+EzA4EzPb4zrZ7YrLO
ebbKYabMZqbQYibnNdZ7kuFUrO5khNZkkNqErxKGnM7PR22lR8zvDzGyG1zH
CEXlUrfcua4np9rvHcPA7NqBBknxWmLiFVwO689yWQb+Cd4GQ5kfFLoiCQno
zoXn17+Fh5OY7iyBznLoqIQOHMGF9kZoa4HWdmjpgCac5oL6Pqjth5pBqBqC
CjIjXDoKRWO8gnFe7gQvC61jM3VqLWlqOX56PmZ6OhJhjgRND/hP9/hMt7/B
ZJ3TdJX9dJn1VKH5VO4rpC7ZYDJOdyJCczxYdcxPEel1eTZs93jI4t4AI7vh
NfQBKhc75c92PD3Zdv9o062D6OeuihOnjp6gRIQ/vkGlokyVYVARAKVvkIdk
g4/j4RKm24qgvQzaK6Ctmnj0emhpguYWaGyFBuIiaruhuheq+qFiAMrRDUPx
MBSM8PJGedljvEysys3kidWEyaW4yfmoyelwhDkcONXvN9XtNdXugcl6x6kq
u8kyq8kis4ncl2gCyfrjcdpjkeqjISojfgpIr8uTQfuHA5Z3+xjZjaTQFaie
b5c/0/b8i5aHRxpvHcBhtqtiVQJ/X0j0IZ1LJaFINZFQFQxvfZj7tXQTkQ/m
AUftCZ8noSUfWoqhtRxaKoirr4WmBmhsgnriKWo7oLoTKruhohfKe6GU2Enh
IOQN8XKGeZkjvHSsy43EsdW4saXo8bnI8ekwxDnsP9HvM9HtOdHuNtHsjDlV
NuNlFuNFr8dyTccyDPFXcVojkWpDIUpD/nKDns/RDTk86LO604NESHbqXsFq
UDjd/PxE06PD9bf3o75KMiZB3CJhIZM/XwsNiVAXDTVhUOmPrVHWq49jgvUQ
DenEERZAUzHeNFZCYzU01EJdPdSiMkJ1K1S0wdtOKO+Ckm5CRB/k9UNOP2QN
8tKxJdlOGt6IH1mNGVmMHJkLR5DjAaPDvmP9XmPdHmPtLqPNjhhAVFmNlpuP
Fr0cyTUZydBHLYjTGIpUGQhRGPCX7fd6itbgcL/b6nYXI74xt033EjoGxZON
9LH6x4dq74hXXxNle6fF5JrNpdIEXDSlQGMc1EWgfBWe67nmH8YFvvXb3XRd
CtRnCHqw9eVQVwm11VBTC9X1pNxmKG+BsnYo6YAiYi35PZDTA5m9kNHPS8Wq
3EoYXI8dWokaWgwfmgtFiGN+w8Pew/1vRrrdhtudhpsdMLPKYqjs9VDRi6Fc
o8EMXfxhvPpApFJfiHxvAN3r9QRpdrjbaX2zA5m40qJ3AdVS8Ys6+mjt4wPV
d8UqbnDKBGO4OcQwkvkj79CaBs2J0BBF/IW3yF5rm1gecEz+MxF2Jd0nAh4u
48+qYqE6EWpSoSYTakgYXVMC1eVQXQFV1VBJXGh5A5Q2QUkLFLVCAUajkNMF
WV2Q3g1pvbxkrMutuL716IGViP6F0P7ZYHQmYz4DQ56D/R6DXS6DbQ4DTXaY
WWU2UPayv8hkINegP0MHfxiv2hul2BMi2xXwvMtLGqMzh9tt1tdbkYxLjXrn
GjRO46CTzOGqxxIVd0XLrnFYhWCYyOBSKVwqgbR0pOPTmkzceyhUo7vYu/38
ZyGNEF5bSJ6T+ce3UVARB5VJUJlGiOK3UOJQUQZviScpq4HSOihugMJGKGiG
vBbMzGqH9HZI7eQld/ESsXK3YnrWI3uXw3oXgntnA9G9jHn1DXn09bn1dzn1
tdn1NdlgZuWr3jLT3iKj3ly93gwt/GG8SneUfGcI3RHwtMP7UbvbXTQRa6lm
BpLJxXq9s3UaJ3H0W+bg28fi7BjH9yVJv4BpQbhUIpeKRXm6CqEzh9UfaAyH
Gj+Rb+Tmt0JcfLYXN+cI8jAoi4byeCgnTro8C8pzobyAPColLUklFFVDYS3k
10NuA+GlGTJaILUVktt4ie28ODSqzciutfCu5ZCuhcDuGX/s1I6+6R5y6+lz
6e1y6Gmz6W6ywszKl91lxl1FBt25ul0ZGqgj8YodUXLtoc9aA6RbvR+0uN1B
m7GWbEBqztfqfVmtcaISqdmPwtzh5F+ncq4yzhSpSeJScShPbzn0FEN3Hn+s
AJoioNb/m7n5nRAXnwqlyawXme8t9IPiYCiJgJJoKInHnJI0KMmEkhwo5o9M
/B8oKIf8CsirgpwayEYFh/QGSG2E5CZeYgsvrpUXg5W9Gd6+FtKxFNgx798x
44PAR907B106ex27uuy6Wq06mywws9K0s8ywo1CvI1erPUMNDTRevjVKpiX0
SXPAoybve41ut7AKbLi1yM+ZSr2TbzWOsj7lR49F8+5wsm9QGVdJ2MGQw6Wi
UZ7+t9BXCr0FAn5a0Mssl7v8/+EHu1CQ6wn5/lAYAoURUBhDGEuCwlQozISC
bMjPI33Mv0FmBWRgiAwptZBcz0ts4MU18mKadqKwqjdCW1aDWpf8W+d926a9
EPGIa9ugU3uvfXunTXurRVvja4y2K43bSvVbC3VaczVaM1RbkhXxt1HPmkKl
GwMeNHjdqXO7jg7O+nIVrr8jrYuiBGrxI9HsO1TGDSr1Kqsv/Oh8oAYGKqG/
DPqK+Ky0Ilej+ZbfwApB/a0ro8kbuMATMl0h2wtyAyAvFJN5MZAXD3lJkJsK
uRmYk50LWfmQWQgZxUTWv0JiJSRU8+JqeNG1vEhst7ZCG9eDGlcCmhZ9m+a8
mqc9EPCIc8uAQ0uPbUunZUurWUvjS/RTlQbNpbrNhZpNOWpNGUqNyfKoIZFP
6kIe1vrfrfG6We12tZLVEPTEXxTrHi1UP5SvKJFD2Em/Q6XcoBKvstrCZ2eo
DoaqYLAcBor57LRh9X6zTf0zvLeaX5iTX5K6d4B0N8j0hqwAwkAEZEdDdhxk
JUJWCuZkZEJ6NqTlQUoBJBdBUjHRnj/wIqp4YRj2bgXVrvvXrfjWLXrVz71p
mHJDmMMOjQO2jT1WjR3mjS2vGhtMMfip0Gso1W4oUK/PUa5LV6hLlkHNiHxU
HXKv6nMBD0bH8nWO5KodzFbYn0F4SL5DJdyg4qSoaC4VzvLwAxhpQB6G3hIr
yocejLpW6r7Ft/x5Lz/7z5hOsIIkR0hxgzQvgjYEMiIgPRrS4yCNNHypqZCS
AUlZkJgDCXkQR1xwdDFElkB4GZH758te1Qse1bOuNZPO2FwM29b2W9V2m9e2
v6ptMa1tMEKcb7VrStRrClSqsxVYtH/wu17qKVnicqnI/hwG5Aj+SLbOoUw1
iXSFfegpHoom3KFib1BRUlQ4lwrG7462wGgDjNTACDpfGMiHXqRprsZXeJ7o
R9+M+4+YjnkNcTaQ4AiJbphM9oeUYEgJh5QoSCatWlISJKRAfBrEZUBMFuZE
5kJEPoQVQEgRBBXzAkrQTXiXrXqWE/MS+XPas/JEaexsht8pCbpR7Hu18M3l
ApfzeXZf5rIADQ+lax9IVRVPlhdNRIBUzB0q8gYVJkUFcSlsNmGsFcYaYJQE
RcOlMFgAfWyE/mH4iF5fxHSoHkSYQJQZxNhArCPmxHtCvC8kBEECsf74aIiL
g9gEiEmCqBSIJCFIWCaEZENQDgTk8fzyd3ywstffFK24Fy+6lMw5lUzbl47b
YIs3aF7W+6qsy7SszbCsSa+sThthl6uUFimW5smWZD4vTpUuTnhQxGSG3SgI
lMr3+SrX40KO85ks25OZLBcGEsna+5NUxRLkqdhnpEG4Q4XeoAKlKAytYKIT
JtpgnIwyjFbCSBnDxacfzAOp5wuYDtaHMFMIxwgeohwhyhWi30C0D8QQc48O
h+goiIqBiDgIT4AwEmsEp0JgOvhngG/Wjnf2tic6pDXXvGXn/AXHglm7ginr
wjFLVNmBl0U9JkUdhkWtekWN2kW1Goi3TLGwUK4w93lBhnR+ysP8+LsYOIZK
5QR8le19MdP9bIbTqXTb46l8EsQTtMTiVDgxclTkEyqMybxN+d+kvFGMyR6Y
7ILJNpggvcixKhgph6GCPee1v5kF4jEuQKABBJsSvbCGMHsIc4FwDwgnJh8e
yAsL5YWF80KjICQGgkns4p8Ifsngk8rzStt+k77pjla24pS15JA9b5szY50z
aZE7+hq1ut8kr9swr10vr0U7r0Ejr0YV4ZbK5RY8z815kpP+MDv5XnbcLbSf
UG5GwKV073NpbqdTHE8k2xxJZDnQF43R5EQqc8JlqJDHVCCTeZPyukm5oxhT
vTDVBVPtRCPqYbwaRlD7NojVfwQLJL3lqYG/IoychUAzCLSCIDsIcoIg4gOC
fHhB/rzAIF5ACC8gnOdPOj0+ceAVz3uTuOOetOWavOGMbcKyfdqiTfqcVfq0
ecb468yRF6jSfYZZXXpZbdpZzRpZ9SpZ1YqIuYTOzH+Smf0oI+1eetKt9Njr
aGUhl1P8zyd7fZnk9kWCw9F464OxZuLROKIrGqbOCVHkBD6n/B4RHbhB4SAV
TA/AdC9Md8E06SdONjBEIJ7B/KWetI/jAX3Dhovqtocmz1Ob4DMB39fgawl+
tuCH44Lg587z9eT5+PB8/HnegTyvECaT9yaC5x614xaz7RK36RS/7oBNw5J1
0rxl8qx58tSrlDHT1GFjVOoe3bROrbRW9bRGlbQ6xbQqORSw+Elq3qPUrHsp
qbeTE68nxUgmRVzB2vc7E+95Mtb1WIz9oShLiYhXYmEMCB3RQFWOnzzH5xnl
+YDCmrlOEcFmBmCmF2bIqMF0C6EBw7f1QVQ54bU538IBNuCrtsobjmrbLur8
2cY3xuD5EjzNwQtHh8HTiefpuvPGfcfDc8cd/RHPNZDnErzjHLrlGLZpH7Fu
G7Vmgz5r0SJ27nXc9Mv4CdOEUaPEIX2E1a2V1KGe1KKS1KCYVCuXVEmjWyl8
lJh7PyHzdkLK9fiEq3HRV2LDLmDw4nM60uNEhPORMNuDIebiQS9EA3D2QtRb
WdRTluP+hHK5RzmyOvsjmB2G2UGYJdMpMx1IwhRGG5vDJUv9aIwfwwLumlg2
V1izVt6wU2Xut511yFe+ALcX4PYa33a14bna77g47Ti77jijPfIcvXn2vlt2
/hs2gevWQauWISvm2JjMv4yYMY2cNI4aN4ge0Yse0EZgXWqxbcqxTQqx9bKx
1c9j3z7BZrXgXkz2rej061FJkpFxlyMiz0eEnAln8r1OhrgdC3I8HGAt4fda
zMdE1IsBoSHqriTqQnMcH1N2dyhSMbNk7mhuAObIKNpsB8xgrLk9Xrk2UvLJ
tzKwOyqBM88LprIrrxXWLJSQPluNbTvtHQc9EvPuB0dznoPVjoPNtr39jp0T
wrZx27by2LT0XLfwXjXzXX6FTfW8SeCsUdCUQfC4XsioTuiQZlifGjrwDsXw
FrnwBjq89ml45ePwsgcIL+9mWOa10FRuaMKlkJhzweFngoJOoqd7c8LP5YiP
/UFvS3HPl6IeRqJujORqHEcFjt0zjs1DyvI2ZUYAj8HcsGB0aq57F/fGGA4T
DHakfG394N41T/DjDopFY9mVF/JoPeaqGxYaW1ba29a6Oza67DeO8Gxe7Vib
b1tZblvaIL3mjptmzuuvXVdfui2beiwa45jxrIH3tJ7PhLbvqKbfkLp/v0pA
jxI2qm0ygU3PAuukA6seBr69F1hyG4HmXA1I/yog+aJ/3Fm/qNO+oSd9Ao6j
h3M/8sbpkIethJu5mIspx8mA48BAUOFYy3Esn3LM7lMvUfb5CZgfg3kykD7f
R/Bji7A1Wbc8+pZI/BHosQc9p0MvGeD0yaqp0tpL1fVX6huvNbfN1AhUQ3bM
7j+3XyP1my+s101tV03sl40cFw2c5vVdmMxpbfcJTY8x9TfDKp4DSp69Cl5d
soim+al3w2Ofmgc+FXd9ym75FF3DzKwr3qkXvBLPesacehNxwiP4mLvfYfRq
rgdcHA46WYs7vObYGXNs9DhWjPxKHDPSv/gUFiZhYQwWhgWzFnM4s7A93bQ6
gcFhb2eG8CrYb8H8UyY9rkLPadGLugh7xVBx1Uh5zVht3QQxb5jqbJrqb5oa
bpkYE+zUqqH5ir7lkp71vI7NrJYdkzWp5jim4jSi5Dyo4NIn69pNu3Y8RRSN
D93r7rlX3XYvv+FeIuVewEU/kXHeLfmMa/xJl6hjLqFHnAMPOfkcwBjUWdzO
TtzGUsz6JcfSkGMuItgE9owyekDhDAQsTMPiJCwSK18Y5I9C7sy2rk9hD2qw
D1dMfW39797IyXgBBuYTSvSsGo0Nlrbcso7Csq7Sih4u21jV11jT117T113X
11/XM8QcXROC/09z6ubTqhbImpL1iLzNkKxtP23X88y+U9qh7RE2RvV3HGtu
OlZccyyVdCy64ph3EeGlnXZI/MI+9qh9xCG74AO2/hI2XvvQazmKWdiImrO7
SjQpE0ZwGcpAmtIjIGdhkcFMpgsXh2FxgN/X3ZhpXZzEDrfI19emfwveXyFL
z+lxecQ7r0ovqMksqsstauDaqyVNlWVN9WVNzRVN7WUNnPhaVDdYUDOcVzWe
VTYhDYLIz3ulLboeWbY/sGq5a8Wka29YV0pZl3Otiy9b51+wzjmDeJJPWMUf
sYo+aBkmYUF+9atXlIkRZaxDGapR+oyczygdgm0OFmdgicx3L43BEgMP5+o2
ZtuXpjGm7e0v/treh2/Gxq7fGHyCyKbk6BkFel6J+SuLOJRlF5SVF5RVF5TV
F5QxyptT1JxR0J2W15uUM5iQMRyjjZjMoScm/Y9Nex++YPtrv/IXe+ElaupG
GTMJa8rAjNIzoQz0KD0NSleJ0mZkkqbUSb3MwdIMLLM4RmFpiF9HK8QNDQ5X
inx9D8feOHA2mdj34fFn9BRNz8ggmllZelZOflZWcVZWaUYWVXOaVpl8rjHx
TGvsqfaItO7QY9SVvgcGPfcMOu8Ytt80arlu1ChlVMdFra24ZFp60bTwnGne
l6ZZJ03TjiHWOAnDSHHDUHHjAHEjbzFDd1EDZ6JwFpTWS0rLkNLWprRUKQ15
Sp01QVich6VZWCbrJpfHYRknXjYXetlxlmG2Rwpf35O3N06yLuILJt15CwEO
PaBHHtHj0ng/+YSeekpPPpGZfCI3+QT1cvyx4thjpZGHqsMP1Afva/Tf1WQy
u29pd9zQabum03xVt5GrV3dZt/oiKlXpWYOiswZ5XxpknTRIP26QfEiXyYwW
0wrbpxu4T893n+4bMV0XUR17Cgt5TakYU6p6lJoGpapEqchQSij40iIsz8My
WV+2PAnL6Gy2FgdW5nEkeHgcIyrhvVHfghJb0wYuzVpq/2166C49fA+Tow9o
kU9H79NkffvwPdmhu3KDdxT7byn13lTuuY613H5VrZWr3nRFo+GSZu0Fzaqz
GhVfovIWndTOO6mdfVI7/bh28hHteAnMDOeoBotp+IlpeoppuIlpOIqq21BY
iCklb0ApalFKKpSiHCX/lJJDsZcXYYUsHVyZgmV0LltLwysL/XvtWNsb2x8F
6YbLBBurB303MDF4kxb5DC+IrP863XdNpkdKrktSvoOL9dlySanpglL9OeXa
MypVp1XenlQuPY6S5h9Vyz6qln5ULeWwWsIBtZh9ykxmCKXgL6rsLariLqri
JKpsK6pkSWFcYkTRupSMOiWrSMnQFM02FbBClsOtzPBWJgmmkdXFQaR6qv2T
D0b2J4Ev+azlEt1+hV9zn/VI0iJiPaQiu76iO6/QHZfptot06wXMaTwrW/el
XM0pucov5N8eky89Il90CKFmSyhmSCimSCgmSCjGiitGcnAtbwAl58OR8+DI
u3Dk7TlyVhy51wSAPkVrUrQyRcuSJCzzN/PA6ixvBe1uc3l0ZRGnQEensbEv
63orfJ4Ci+hPQoh2VwV/2niWbjlPZCbpfR0X6Y4L+JdJtDEPztEtZ+mmM3Tj
abr+FGZWH6crjtLlh+mSg3ThfjpvH2ZmiMqkiMokisrEispEisqEEnF9KdqT
ol0p2oGirSnajKJNSb4WRatStDwf0iqs4IYeWJ3nrc4QSOMrS7iTbGymt3sc
3eXXdhTujekvu7VUe5JuILI2n6aJ7/zvplN0I5P5BV13gq45RlcfxacMhtKD
dLEEXSBB5+6ns8QwM4WiEyg6lqIjKZqBEUikZGE4UrQNRZtT9AuSqU3RahSt
QNHPWSQrq7CK6/J5q2hGmysTy0voEUdn+96tU36H4Yd7YiD7CrCBfHuYrjqG
xdYeo+uO05/UHaNJNPBf1cyDQ3TFQbpcAh8z0heK03nidI44nSlOpxEMDICY
9wD4EvncCABbirag6JcUbUQy1SlakaJl+ADWYJW/e5W5bqxMLi+hoxuexSa4
vK/ha3vZ9sZAdrPgitUSCbr8EJZceYSuPEhXHqAricwVEjQZz/11vhidK0pn
idIZYnSqGJ1EhGckj6DoEIHknkQ2Icn1KLaEH8IaLmDlreF2gY3V6SXiuIZm
cUa7fKBF+MSIveUlO4pwtWkBUeXS/XSpBF22jy4Tx2SJGF3MoYs4dIEonS9K
kyFwkU/l+Ixt8NfH7KwtssQtLqObGZxFH1M+2CZ8ksQ7CfB35ESpf2ducjk0
+/1CDl0oSu6Zr1F0HkXnUHQW+VgaRTO6mUTR8YLaZTKDKTqAon0o+g1FsxXM
ZFpS9CuKNqFoxn2wtiaCATOReG2dXS/6KVvJ/bNsZPKvH8QUyku08M85HBQs
h4jKiJdJ0RkUzUrI6h9jQNGkIllX4E/R3kRIV4EWMplCQqJD4PdX13CHAW8d
13Kur87NL0+jtPhl4XPL9pbz30mae6yFddQin6QzRf+e5TCVopMJjQlEhmjC
ZJhA4ZgcL4r2oGgX4rVYnWMy35dTQSDnp7C2SeRcfsdp1SiOMrA1+w/l/Buf
z08YcUT+jSUuXsAdkwwn9AVRtD+pYybHnaKdiWQ2RLJXglZiVzK+L1plBUNr
XiHuaHhhctey+fz8I+nwjB0Sq/8zS1L4exrnJ6hPJocRyJ44eHNinsbv+XhG
IKYlfkzR/DMsiEBLq/Pv+HpPs/6xRP+122qx2k/qFi+/ZKuO4YitPVeBKbwv
lR7J2Usq9CELu1IBOYvlnR59iFQi35MRHP8RQj4TRGgiA0cin5mRJoMV4Xv8
b+KWgzn+N4XPn/lwNkR+KiPYrcr8CRQ0u7t14yIwNyuKJnX5+S54LGh9iywr
ET7l5SO+/+78RoFv+AXjsd3fc9pWpOVnkiz+XYf0Toq1LdLkff7dpRDaX03k
+KkbsRVWCYRsRY00e0xSmqLvsnUifJrMd/v6Z4Kv/8iOlP+a1Dzb1jIfVRJE
cveYK2IWPo/pu30VmSO1+5k+KZ0JGOVYVMKnR3238vFUMnZMyUJAInNVIpqE
393zNMOP/gqem8JaoOKudePre52M9fGl41vIiPA+jO9W2o/5sgrPLe5d2h+F
ShM+8/LjS8PChEv5oaCWPr36d/wJz+8L68APPkjG7/O/KvKZFCn9OemXsN9j
tQLfEj6p8rt9i5yChwEelxTMwLnFtxfBt0T20Lrv9q3P+dyL/ECS/QwJlZhY
REWg6thpIcg/ddvFKXy203f79meCGvv5LtCbFP2A3MsRb6FO7o2IF2G7hHbE
o+Ov/u/I8IngOSuCyCf4fxwTZCS5T9FPBKauRhynCAmFXpFW1YoknUhrK0Li
Jvy98AmG31EqLOp3rEjMlb1hJZIW9FdYiZgmxZAkzYhEtiQYESGR0htBc/jJ
B7Qu/1iuXXZ+zwrF6IuUwJlLE1/Idmk1cRwChWJ7uxYCoZwEcnkLorkAfiQp
fNLdR8j2w12Cdsli5LomkIvsD/oRW0dso+xNoskAQSzHhuf/MALYWwJBPEZY
eU+HiLX8nOVEQWBJOgJOXgmCalaVWcmYoIH86p+CSSguQoLfCBJ0/qPoaG/Z
yCnEn72vQUSnfs/cMGZ2Q9D670qoQXIMSZeE1W8mbLATBFGshD4k8BUh0V2I
wCt8HkX6Y6xPwijwbx8kHzkF+VPu38WxhMc/SxIvsCuevEA8XZK5S6D1e0rl
QQJfH1K1bBAYSqiLFPQk4nZ92MfySNB8LmSJrKT/wkp6T9AevC+poSD8sSB9
FVZSN4Gj8CUayLIYLuiHMSTGkf6PCL9H9KnIN/ZY9pZV0D8ltP7rrjXc+DAZ
HUi86CbwG36EymDSOWQUMUrAYwLpPSYL+rqfpKGku9H/B7L6b4K0wGLw///x
vsR3BeHxrsQ67zkVy7+X2FPgUXYpjRTwyWQmEVmZjm866aYzOVmiOKjACJnF
90DCkcbeUv+rkNTEvP6HuWFFvkPRjyj6mSAEfV9ktu1iRX7fnAIEysoyHEvq
P5HQy+Snk5GFLDIIwg6R5Imh1Hlk3CGXwqEjlEN4lGVv6f/3XtJTbPr6e9Kz
YzvqRHoDgfSWJHNX+l0dDib5rJ2xypEsoJrJzyai51E4llNAABSJI4BiUbpo
PyYLyAgYSiM8VvUOw6eCp5+9b4JEepxJYEV/SNFPBZ0LRnRt5gY31Yr8Iptk
MSIUUHQhRRdTdIkoXUpG2piPlYvjOGLZAUyWSNCFZATsa+N8rCy/FuJTeCX+
X/aWEXOukdDqPr8P+mtjgQ9jFUKEtIospYECBWbtLV6UThKlU0XpDDJOmCPK
jvv9pHwf/VacrtjPh1F1EAdFq8iobsVhHHUsIZC+Nur6YUjwV5+916bhLXo8
Eif+hW0y2E6sHunWvyTtxa5B7vq498GwppgsSqftozP20dn76Nx9dL4YXUSq
olQC66FCgn43MlJ3lK47xnwXLyhH9Qm68hhrrX/eExWu6cJf74Xm6x4cPQ5p
Ef5jV/Hl32sI2ZDTXNDMOAvCh11UEQKVTyT5aaJ05j46Zz+dtx9nBYrFcRC1
/CA+qjxKVx+hawmc+uN0wwm0AP4ahaZTdNNpfKnhFE4v1Jyk9zoD8R2+b9sl
w7Kyi/Ndjf0fNky7TUJr1kqUSWitQ/JfkAEKq/dwsmPOX8eZInCeOUzVSdBF
B2jGZsoO0m8P05VE92q/oOtO0g0naQZX82m65UuE2naWbjvHSvJpyzm66Sxd
f4atR+G5GhYnrkf6ZA98glHjT/mxDGmDOVKCYGY3NFYkwbq2IFpgsdmxDTCH
9uTQvhxsrBAbRyZaVCaOTNykiMqki2J+rphMgThdJIFzI+WHca6n+jjNAMNK
+hJngprP4axQ23m6/QLC67xEd16muy7Tn3RdYWOsz9sv0y2X8AdVZ4muCeP8
/rfi/ON7foS9fipAS0kSV32bPHhMRjtZU9Qi47MiZEzZkiNry5F15Mi5cuTe
cOR9OPIBHJwfDKfkosQU4vYrJEoopEgopEsoZEngjFzBAfniQ/KlR+TeHpOv
PCFXfVKu9rRsw5e4SoCdGWu/hDN7DLrurxBwryRTe71X6U/6pGgyfNYrxQ/i
2rlE38/T34BY2O8I70dhkb/TYD5qsV3DlSIB111BL1UOFVlGk5LVpeSMKJxI
NKdkrTmKDqKKLqJKHqJK3qLK/qLKQaI4bRolqhi7XyXhoEryYZX0wypZh1Vy
D+Mca/ERpdLjSm+/UKo8pVzzpVLdGaWGc4pNF/B8lrbL8h1fyXVx5bqvyvZK
yfRdo9k45xOcyf2nwVv00C16kEzXD9yi+27yRwNar9J8IxWeE2dZ+IMQ6t30
+7HQ/l3M71f5E0pWhpJTpOTVKAVtStGAUjSlcD2eFaVkx1F1ElV1E1PzElPz
E1MPFFMPFcWVSrH7VBMOaCQf1kg7ppF5XCPnuEbBcY3i4zg//vaUWtWXajVn
1evOqzVeVG2+rNr6FTLSeVW5+5pS73XFvpuKA7cUBm/LsbBH7tGj95i6xxn6
z3Gunsm6Tw/fpwfvCmYE2q4LsAufNLo39t8LYSeVf+Dv61vmLqna55SCPE7Z
K2tSKnqUqjGl+orM5ttSao4cTVcxzTf7tHz2aQXs0w7Zpx0higDjJTSTD+uk
HdPJPKGTc0on/5RO0Smd0lO4irfqnGbNBa36S1qNV7SauZptVzU7ruFPem6q
991S67+jOnhXZfi+8sgDBRb7+GP5icdyE9Iyk9IM1sknbEM1Lk2PPqaHH/Fr
vu0WzcclvObj29C/6wMR9CdE+FGw7HVK/jalcJ9CVZShVJQoVXVKTYdSN6Q0
XlCa5hSuQXWgtFw4Oh5iut779PzF9YLF9cPF9aPFEGLSQd3UowaZJwxyThnk
f2lQdM6g9KzB23P66Kcv6dZ/pdckqdcipdd2Xbfjhm73LVwq0n9Pe+C+1tAD
zZFHGqOP1cel1Vj0U8+Upp8rTtMKM7T8jIwsuwZnmqYnn9Pjz+jRp/SQNKsB
H1bru2uThForclYAi12KUrxJKd2llB8RmPKUhiqlqUVp6VPaJpTOa0rbktIS
wbkXPXeOgZeYod8+oyBxozBx4yhxwzgJXOOTesQo44RJ9imTvC9Nis6ZlF40
eXvJpOoyrvSplzRsksIFQe03jTpvG3bfNey9j2vpBh/pD0vrjT7RHXumM/Fc
e5LWZOHPyqnNyqvOySvPKSjNKSjMK6LQcwoycwr0jDw9JYfJ4WcsAx9W8/gW
Af9nkXfjFzJcCp0uQa9wnVK5Tanep9SfUKiXSpS2BqWrS+kZUfovKQMLSs+G
LP9zpYzecEx8xUwD970IFX8Ruf9lrMSLhEMvycCIyF+abrxovfWi/c6Lznsv
eh6Y9j0yHZDGDfsjz4zHnhtNyBhOyhpMy+vPKOiySBeUtRZUNBZV1BdV1RZV
VRZUUfcWVOUXVGUXVOg5ZUQ6IU8PEwX4CKwivxV5L/giN7JcSp5LdJtFe5PS
uEtpPqK0npOlcKqUvhZlYEAZmlLGZpSRFWVsT5myqL6fdcoi94xlwXnL4ouW
ZVcsKyUta6Qs629YkKe/nZQ3nVI0mVEynlM2mlcxZIEtaegua+isaGqvaGou
a6kva6FWLWkpLWkpLGnKL2rILmigZJPK9BCpzq+tINwbG3nr1yLCY1ByXEqB
wcYlDorFdpvSfkDpPKH0ZEm9aVDGupSJMWVK4vk/eopa+O6zDNxvGXrAKvKg
dewRm8TjNiknbZln2Wdt8y/YFl22Lf3K9u1V26prtrU3bRtv46O2Bzadj2y6
pW36nloPPLcakrEclcMlmJNK5mwc/aslTVMW/5qO/pquwZqe3pqezpq+9qo+
LvZa1VdeYf7qKS3rKizpopOd06QnVT8C/2/gvRGwnwh4YIArcylVLlkLeJ1g
v0vpPaIMnlNGCpQxK9vfzDjmVmIW9mKWzvtw3aS3uK2/hG3wQbvww/bRRxzi
Tzgkn3JMO4OrRHMvOhVccSqRdCqXcqq84VRzy6n+rlPTfVxo3iHt2PXUsfe5
Q7+Mw5Cc/YiC3ZgSUjOlZj2jbjWnabmgbbGkg8uSGSjE5/xs08h408hw09hg
w1hvw0Rn3QSpWDNRXzNWXTVSXjFElVzUk5nXoSfU6Y/gQeSn72s3uWF0XIUQ
ocElq+tuULp3KP0HlBFh4L91OeZGHIuXHCsLUWsbcVvH/Xau++2ZB74HHAMP
OYUecY485hJzwiXhlGvKGbeM87h4OP8r96Kr7qXX3N/edK++gwuJGx+6tzzG
JcRdz916ZFz75VwHFVyGlZzHVJwn1JCiGU2HOW37BV27JT2bFQPrVUNcNb1h
wq6a/sn2K8Ot1wabr3Gl48YrrY1XGusv1dZeoOIuG8svGcnO6xF9EF5BvDcP
vxZ49h/t2jghgtEIdYYCLqXNJdZ9gzLk79x/znklzzFT4aDe6nOsTTi2rzj2
lvsc7PY7OR1wdj+Ii8f9DrsFHXMPO+4R9YVH3Ok3SWc90y54Zl3GvViFUl4l
N7zLb3lX3vWuue9d/8i7Wdqr7Rk+6pb16lPAxebDKm9G1TzGNdyntJCnOV3X
eX3nRUOnZSPHVROHdVM71kR2Xltum1lsm7/esXjJYtixxIZk21J7y1J700Jz
wxz1ee21wspL+UUT2TlD+mNZ+b7A7SkQVhjF0GL44FLsPoqD96hX0hwzmmOh
yLFW46AaG3AcTDlOZqLO1vtdHQ64uRxyf3MYdxIEHPMK+cI74qR3zJc+Ced8
Uy76Zlzxy5HE/axFN/3LbvtX3POvfuhf99i/8al/y3P/dll81KvoN6DsN6Tm
O6LhO67lM6njPa2LTM0bvlk09lgycV954bb2ynXjtTOfEUu7bSubbWurHRsL
nq0Z2L4iKH7Is9PfsdPbttXZstHcsFbftFJcs1Bafq2w8ALVXnhnwTtOPtnV
I4GlyKPnUOJHgIx68HdTHJWkcOvdbcrsAWX5lGMty7FV4thrcNAZGIm6vhR1
s9jnYSvh6XjIy+2wt+dR3G8U9IVf2Gn/qC8D4s4HJl0KTPsqKPNqcO513ARb
cjek/H5I5aOQWumQhmchzTIhbXIhnYq4TatfNXhQPWhEM2hMO3BCN3BaP2DW
EKlaNPVdeumz8sp7zcxzw/zNpqUHnxJb5207R9znYm/Lc7ACRwtwek1q7/s7
TvrbjjpbDhiXbNiqrFopLZkrfCsf7+sI2YVzUeRdr0+J6IcyudclYYGxJPXi
KoX7jO5Q1o8o22ccB3mOk4qoi5YougYTUc/Xol5W4j52B32dD/t7HA3wPo4b
SUJOB0ecDYk5Hxp/KTSZG5YuFZ59Izz/Nh7VUvYgouJxZPXTyLrnkY2yka3y
kR1Kkd0q+GhAM2JYO3xUN3xCP2zKMHTWOGTeFAlbfh20Yha4auG/buW3ae27
bevNJ8bBfcfRbcfJecfZkediD6624IpuHdxfg/sLdrRjxxWBbDmprjuortgo
fRw3nwliJGxWGa3RIGV+KUmZXKVeXaXMpSj83F3K4THlRHNcFDhuaqJvtEVR
v1+I+prt87eWCHA4FOR6NPjN8VDfE2FMfujZiMgLkbGXIxO5UalS0Zk3Y3Lv
xBTcx61Y5dKxVc9ia2ViG+RimxVxW1anWmyPBm7IGtKNGdGPGTeMnjKOnjGN
mnsZufgaGVuxDFuzCl23Cdm0Dd6yD9pxCOAz4+K94+q54+ax4+7G83CBN47w
Br08eFqCpxnZRGfCrtvccdfcclVfd1L5YGbImNA/sW0NuaoQR6vN7tjkEn2R
oiyuUTbXKPzmfcrlCeUuy3mjxPHSEPXRFcV9WS/FgizEg20PhjodCXc/HuF1
ItLvNO7kDL8YG30lNl4yLvlafPrN+Ow7CXn3E4oe4X69iueJ1TKJdfKJjYqJ
LSqJHeqJ3ZqJfdr4aNggYcwoYdI0Yfpl/Nzr+AXzuCVLpG3NJnrdLmrTIXLL
MWLHOYznEsrSw/MI2Hnjt+Pps+PlxfP2AG838EGnD7524GsNvhbg+wp8Tdn+
wo6n1qY7euGP4eca39XgVY1L+g1cyohczRituUbZXqccrlPOIri//M0zykue
46vC8dcUDdQXQ/fxel+4lUSE/aEol2PRHidifU7HBZzFM0QiriTESCYmXEtK
uZmUcSc5+35y/qOU4ie437VCJrVGPrVeKbVJJbVVPbVDM7VHB/d6DhqmjBin
jJumTL1MnjFLnrdIWrRKXLZB3tYd4jed4racY3dcY3ju0TyPSD4/3iE8n2Ce
bwDPz4/n5wP+XhDggQgDnSHQAQJtINASAsjuQ3/SXHlrfjM/v4c9LIvlR5H1
wSw5XLKNjEtZX6XsrlNONyjXmxR+9BHl+5zyV+AEqnFCtEXDDERR8c3Fo20O
xjociXM9Ef/mVILPmcTAC7h/M5KbEnstJfFmauqdtIz7aTmP0guepBc/w6MX
KuUzapUyGlQymtUz2jQzOnUyevRxg/KQccboi/SJV+lTZumzFmnz1qlLtqkr
9kjphnPylkvStlsizyMBPOPBK47Pj38k7j0OCOUFBvOCAiGYnAoQ4gkh7hDi
AiGOEGILIcQVBb+AIKRox1fjY/iRIk02uqtdcriUObm3v0o5X6fcblKet8gm
fGkqUIYKUeKEqXMidEWjjMTQl1gciLc5nOB4PNH1ZJLnmRTf8ymBl1AZoqTS
425kJN3OSL2XmfkwM1c6q/BZVolMNvOoSim7TiW7UT27RSu7XSe7Sz+71xDz
h19kj73KnjTPmrbMmrPOXLDNXLbPWHVE6jZd07bdU3fepIBXMvgkgW8iyw8E
xUJwDC8kihcawQsLhXByLESEH0R4Q8QbiHCFCCeIIA4p3AzCXkCIwV67Qvfm
h9jXDeKZFQSNlSHjdhh+uJQNSbpcpTyuU163KN/bFG52fEqFyVERKpxoTdEY
PbE4431oShaHkmyPJTt9ker2ZZrXuXS/SxlBX2WGXcUN4fG3s5Pu5aQ9zMmS
zs17llsok1cqj9uXq1Xy69Tzm7TyW3XyO/Tzu43y+0xwr9vI67xx87wpy7wZ
m9x5u9xFh5wVp+w1F2RvyyNz2zOD550OvunglwoBKXyKQhMhLB7CYyEyBqKi
IJocYxYdBDEBEOMDMZ4Q4w4x6B8gyhoizSDCFMJwHOWjWCJsKAu0yJSliEs2
anOpN1cp7+uU/y0q6A6F+4OfUVHyVIyKaJzmvng98UTj/UmvDqIV2J1Idzqd
4X4u0+tilv+V7OCrOeHXcR9z/L285If56dIF2c8K8mUKi+QLy5TwwIUa9aJ6
raJm3aI2/aJOIzx8of9lEZM/alE0YVU4ZVM4a1+44Fiw5Jy/6pq/7o7Ebnvl
7vjkgF82+GdBYCYEZ/BZCk+ByCSISoToeIiNhThyTlB8OCSEQEIgJPhBghfE
E9cUZw+x1hD9GqJM9vJF3/tGloiXl2IDHsY7Mw6IIYhL9vRzKR9JKuAaFXyT
CrtLRYrgiGCsPCdeZV+ilniyvkSKyYG010fQudidynI+m+1+Icf7Sq6/ZF7I
tfyIW3gsR8KDopTHRRlPi3Po4gK5kmLFknKVUia/Vqu0Qbe0Wb+03ai0y6Ss
92XpgBnmj1mVTtqWTtuXzDmWLDoXL7sVr3kUbXgWEQ9SwPPLh4A8CMqFkBwI
y+ZzFJUO0akQmwJxSRCfCAnkrKmkaEiOhOQwSA6CZIwuIdkDklwg0R7irSD2
lXAv4pv5EfmbCD9SNiQ3Viw9XMqTJAMlqdBrVPhNKuouFUMYSpAXS1IVT9GS
SNM/kG5yKPP1MbQp+zO5LufzPC4X+HALA64VhdwsjryDZ7MkPi5NfVqWSZfl
ypUXKJaXqLx9q/6WjKr866T92xmnt/Mu5Utu5SseZetepZs+pcT9FkNgEQQX
QmgBhOdDRB7iiM6B2CyIy4T4dEhMhaQUSCYHhaTGQVoMpEVCejikYzgJaT6Q
6gEpLpCMe2Y/jIlfCDTlz0zXifE2rCtmXA1jR1zKlyRDJamIa1TUTSr2Lif+
MQe/rrAvVVUiXftgpsGhbNOjOWZfoLY7nCtwuVT05qtiH6mSwBuloXfKIu+X
k4llkR/U6Vc3GVW3mlZ3vKzuNqvut6gessZjJMYdqtiVzX+AoHIIKYOwUogo
gchiiC5E2ePyISEXT/9JyoLkTEhNhzRyfGhGImTEQ2YMZEVBFm5yh6wAyPSB
DA9Ic/549L8jbZEZgevMQudSQSQZIUlFX6PiblIJdzlJj0Xx6wr7M9UOZGkf
zjE4kmd6PN/sFLoHh4slrldKyaz075OeV6fJVmcp1OQp1xSp1ZZq1lbo4B7G
eqO6JpO6tpd1nWZ1PRZ1/dZ1Q3Z4OtqEU920a+2ce+3Cm9plr5o135oNf2SH
F1zF/rufv4G4UgSTWARJhZCSD6m5kJYD6eRooKw0yEqB7CTIiYecWMglR4fk
hkJuIOT4QJa7yMfz8RvS8FgTAjwYd8HYA6MHDBki2HuKk6ISb1LJ9zip0qLY
XipK5KgdytM5UmB4rPDFyWLzMyXsCqEjntcr/G5VBt2tCntYHSWNxzMly+Lp
U9nK9Xlq9UWaDWU6DZX6uLm6waSx+WVjm1ljp0VjrzWeXzXsgPmTro0z7g1z
ng2L3g0rvvVr/vWbgcgYL7SWF14DkdUQXQWxlRCPRxHwHUdqCaQVQUYhZOZD
FjnzMScTctMhLxXPG8tPgHxyxlJBBBSEQH4A5Hl/B4Z+SXwqYyluXMp7lx72
cDlJKlEKDxBLu8fJkBbLJgzlqx8u1DnGnt/1X47cSjepKq+b1X53a4If1IY/
rot+htutk+Ub05Uas1Wb8jWairWbyvSaKw1xr3LDi+bm1y3tFi1dVi29ti0D
9i3DTpg/6d4886Z53rt5ybdpxb9pPbBxMwRZ24lo4EXV82LqIK4WEmogsRqS
8Qw4SGP/1R2Rn0FOEeSS07Tyc6AgCwoyyBl1yVBEzt0qioKicCgKgUL/j+MG
15+qCfwpY0meXCqAS4Vw8RCtaPZoQkkqRYpKv0Fl3uPkSIux5+GJGZ0qf3m2
wuJipe1XqPjuN2q9btf5368PftQQ/qQxmsajmFIUm9NVmrPVW/K1Wop1W8v0
WyuN8RjBhldtLeZt7ZZtXTZtvfZtg45tIy6YP/Wmbcardd4XD9JbDWxZD27Z
CkPWeFFNvJhGPG8voQGS6iGlDtLw6EDIrIasSsipgNxywtKPobAAinKhOJsc
cEgOqSpNgNJYKI2CkjAoCf44bn4m6DHZEavyI/dhXCqKHEuYSLhJl6KyblI5
9zn5bE1JaBwt1z1ZYXSm8tX5asvLNbaSqP7utxq87jb6P2wKlm4Kf9YcLYP7
k1KUWjNU23I02/J12ov128sN26tM8MyeRrOOFouOduuObruOPseOQeeOEVfM
n/LqmPXpWPBrXwpsXw1u3wht24rAswZ5MS28uBZeQjMkNUFKI6Q1QgYePQnZ
dZBbA3nVkF8JhW+hqJx/MkxpAZTlQVkOlONZRFCeDOUJUB4L5ZFQFvrh+kPW
018ipOgIPDFjWgHkPpJLxZJTP1MITVlSVO5N8k/YPBErkZUoY240TlTqna42
Plfz6lKd5Vf1tlK4l9r9TpPX/Wb/Ry3BT1rC6dYYubYERdwImqHenqPVWaDb
WWzQWW7UWfUC97w2WnS1WHW123Z1O3T3OXcPunaNuGP+lE/XrF/XQkDncnDn
amjnRkTHVhQSyItr5yW08ZJaIaUF0logo5l1QpDbgAeDFtRCUQ0Uk1Mey95C
eRl/hx9U5EMF+QcOKtOgMhkqE6ACQwzh8fF3LO2euvUjLqVP6HBn1Ic9lo5L
xXCpBC6VTM7OzWK15vh90dIn4uWyh9Atapys0TtTa3y+7tXlBgvJRttraEzu
d1u8Hrb6S7cFP2sLl2mPUehMUMbDNjM0OnN0ugv0u4uNustNuqte4r70Rsve
FpueDruebqfeftfeIfee0TeYP+3XOxfQsxDUvRzSvRbevRHVvR2NhPESOnlJ
HZDSDmltkNEGWa18YvKb8DDZogYoqYNSsqv/bRVUVEBlGVSVsGtgoToTqtOg
OgmqMeL7Fla+Zl9XSCvO+GQv4nUYhxwlwj8TNY2hhv13NK5yim9ySh+IlT89
UCl7BJ2Nxuk63bP1RhcbXn7VZHG12fYGGpPbvTavRx3+TzuCn3eGy3bGKP5/
tX15WBRZli/vVVvVNdXTs/fMdE+/7un3vZn+XrdbdVld2pZdVpVaagWgoqi4
i/uKu7hg4YaoKLgv5Y6Cioi7KCAg+y4JJLnvSe77Huf7Js+NCKAiUXG+Hv8I
Iy6Z957f75x77ombEeeI7qxGyI/Wiwo3SYqTpWXbJRUpkppUfEmvOU0mSJd2
HJaKjspkx2TKE1LNaWw3XpBZLkntVzA9rueGxJ8rCd7CTui7IvqeCB4I4WEH
POmAwnaWn5JWKH0FZS3wsgkqSKbm6jqoqcF0xXUVUF/OZUZuKISGx1B/H+rz
35GjD5mZRY6XyIp1K4pNqfuYsZ2xMYPKpw6uTPi4et6ntYtH1K8YhR5n09jm
beNf7aJa904SpMe1Z8SjyKfndn6/QHR5kSh7qSh3pfjOGgT9aIOkcIuseJu8
bKe8YpesZg++QtuSrhAckncckYuzMGmy8pRccwbbTRcVlsty+1WZ67rMmyvz
38IXhOl8CX1PAg8kmIL5cSemY37eyTJU2gblAnjZCpUtUMVk9W6AujrMbt1Q
DY1YohGaXpBjITQ9gsZ778ZPNDO9yPEKcc155PwRORaRgg4YrMcNqZ75Se28
z+oXjWxc/md0NZvGtW6bKEiJFuyd3J4+TZgxA6fT6Xmi7xMllxdLspdJcldJ
7yQhvkebZIVb5cU7FGW7lBWpipq9+Np9y0GVIEPZcVQpPq6SnVQpz6g057Dd
dFlpvaq0ZytcOQrvLUUgT4EMFcjoBzJ4JMWM3U/F8BytCkow2ziUd0BFO1QK
oJokbK5rgfomaGiAxnpoqoVmkruypRxevUDo/N+d38AMs7fF3B1lE6+D84pc
PmdooQZhUtC4obUzhtXPHd646PPm5V+gr9k4vi352/aUmPY9U4Tp00UZMzGL
2qn5kvOLZJeXyrJXyHJXy++sQ1yPNisLtymLd6rKvlNX7lHV7Fc3pKvD7YIj
amGWWnxCIzutUZ3VaL/HRtMVtTVb7bihct9UeW+rAvmYo4m+r6AfKuCxHJ7K
4JkUikmqrlIRQqzohCohVLdDDcnyXd8KDc3Q1ATNjdBSD69IHYHWChCUgaAE
BCSn2Tvww+wdn+buG/LCSxWZreOpgSVYCGNQRfQQJH/KH+qnD2uYO6I5cdSr
ZV+2rhmDzjE5WrgzVrgnTnRghiRjFuZYO7VAdn6x/NIyRfZKRe5aZd56RPdo
q7pwu7o4RVOWqqncq6lJ0zYcxBfrBZla4XGt+JROfkanOq/TXsRG0zWt9brW
katx39L47mgCd5E0+qGKfqyCp0p4poAiBZSQ6iHlEoRYJcZCATVCqCOp/hoF
0PQKWlrgVTO0kiTObTXQVgXtFdBeCu3F78hPLKHlDLdq5ZPj0yimxNGgl9Sg
quihNbEf46oQ/8emOX9qSfxCsOyrttVj0dMkx4h2ThbtnipOmyk9PFuWNQ/F
PrdEeWm56tpqVW6SOm+DBvnZpi3cqS3+Tle2R1e5X1ebrm84jO/xtx3TC0/o
xaf18nN61QW99hI2mrP1thy946bOnafz5euC95A0+pGGfqqhn6mhSAUlKigl
9WVeyhBijRRqxVAnggZSaKO5HVoE0CoAQQsISBLw9jroqIGOShCii+A/wdMf
bq6Sk4IopmYIHnFWUYNqoofWxX6CSoj/rGXWyNaFo9uXfd2xahz6mK2x4p1T
JKnTpGkJ8sNzFFkLUORzS9WXVqqvrdHkrtPmbdQVbMV6F4Up+uJUfdnersq0
rtqDXQ0ZmFWo7bhBeMogOWOQnzeoLhp0V7DRfMNgu9nlvN3lzu/yFeiD95Ew
+omOLtTSRVoo0UCpGsrVZAVXIMRaOdRLoYFkB2wRQUsHtLZDWxu0ESckbAJh
AwhrSQmXitdyw8+y3b2PFU3i5NtRbK2EYiwngnWyqrHKypCGGFJkY9rw1oSR
ggWjO5aO7Vw1XrTuW3SKO+JkqdPl+2cpD81VZS5Egc8t01xcpb22VpezXp+3
WV+QjK+zF+4yFO02lO4zVBzAyicNRzAliuCEUXjaKDmHpVFUl4y6q9hozjHa
bhmdeUbPXYPvniH4EOmiC/X0cz1drIMXOigjCcQq1VCtglqsEgMNcmhCxw+v
xNDaCW1CaO+ADpz30NkCokYQ1YGoBsSV/WbmH3rWqmymSEDYXroXJ2pINdbg
GdIUM6x50meogYRR7fO/FC4ZK1o5QZJEoU/cPlWROkO5f5bq0Dz10UScPGeX
6y6u1l9N0uds6Lq9uetuMiJ7+p2xaI+xdL+pIt1Uc9jUcNREiDEJz5gl583y
i2bVZbPuGjaac0222yZnvslTYPI/QKropwb6mYEu6qJLuqBMDy9JorFqLdRq
oF6NEJuU0IJ+HwQSaBNDhwiEQugkGVfFrSBuAkkDSNAv85//fBMrxAnjTgW3
ZBP3MhB9LzW0gRrcEj3sVexwZH/mn4Vzv+pcPE6yYqI0KQZdyrZpyu9mqvfN
1hycrz2aqD2+BKfNhdVdV9cZbmw03N5ivLvNSFgxFe01l6aZKw6aazLMDZmY
z0lw0iI8a5F8j2WV1FcsumzMlmC+abblYd0lz32z/6GZ2IqRfm6kiw1QaoDy
Lqgg9apqdVCvhQYNQmwhyQYFCmiXQYcUhGLoJA5H0g4SAUhbQNoI0vp3Y4Wi
yK9OhJInUUxpJizLQ8o0fdxIDX0V/YkgZkTblJHoUuZ8LU78Rrr8W/naWFTP
tnj1rpmavXO06fN1GYn6Y0tRkd+vMVxZZ7yx0Xhriyl/G1rAk1Rz0T5L6QFL
xSFrzRFLQyZW1hKcsgrPWSUXsNyW+qpVdx0bzbes9jsWV4HF+8Dif4Q80c/M
dJGJfmGCMiNUGKGKJDyr00ODDpqw5Bi0aoiLVUKHAjplIJKCmEQ9UiGpfPYK
5OiDI/IwvZ4T4lkmkjunp5yrrSJlm0hl7I/DjLTFDO+Y/DmSP2eMdOF4+bJv
FWtiVRvi0I+kJGj3zNEdmK8/vKgraymK+/1a0+X1puubzDe3mvO3m++nILDn
+6yl6baKw7aaI7b6LEwhJThtE563SS7a5Vfs6my77gY2WvJs9nyb657N+9AW
eIIchZ5b6BIzlJqxVlslqVNXa4D6LmjUQzNWmQMBcTRCNXQqQaQACXExMjHI
O0HeTirgYfQV8QT5+30yQn5Z+A3xs/dI/RGmUFHYkdSy5Sc/aY0e1h4zvHPS
KIzfZo2RLRivWEopV8Wq18WhbnYk6HbP1act6Dq0yJC5FKfJ+bXmyxss2Zst
N7da7uyw3tuFuJ7vt5EMeP8aeIrA6WIr/cIK5RaosEA1yYtWb4RGAzQb4FUX
u6XXoYVODYhUIFGClDgMhQSL+yk7QImxXMR7Hm/A+G9cBPKMK0NUQw2qpwY3
UYPRU1LDhDHDRbGjJFO/RD7njVcuplQrYtVJcdrN09EbpM417FtgOLjIeHSZ
6cRKFPjSBiuTv/DFQcfLDEd1pqP+OCacEZx1Ci84JZedimtO9Q2smWi87bTk
Oxz3HK6HDu8TporgP0KVFWpIyckGEzSZoMUIrWxZUOjUgUgDEjVIVSAnoYhS
CioxqDpB3f5OuJkMhtwqgStN2M6pIc3UYFJM9lNh9Ahx7CjplC/RDc6doEqk
1MtjNWvidBun42zfNc+4d6ExfbHpyDIzc5/4i2tb7Dnb7Hk77QXfIdpnaY6S
Q86XR1zVWa76E5ieRXDOJbzgklxxK7Ld6hxsMea5LHddjvtO9yOX7ykyEip2
0C/sdLkdKm3M04x/Ay1maDVBG6bqgc4uEOlBogWpBuQk3lAqQCUDtRQ0aIYR
bzD1zQDZgfonLurkCBjYGF4NqCECaigGvNEjJDGjZLFfyuPHItMLKc3SWO2q
ON36ePTQKfNMDO7fHFuFyrqwwX51iyNnm+P2TkfBdwil8ICr5JCr/Ki7+pi7
/iRmghGcdwsvuiVXPYrrHnUuthjvuC0FbscDt/ux21eIlIRKnHSZk37pgCoH
1JAqyo1WaLYyO5CIS2QAiR6kOpBrQUGcoFqJxVu1UtCK34kBYgN/R6oyVrC1
5Qe/ooa0UR+TsskjpNFh/KMVU8fiAjSf0i6O1a2M0yfFG5h9hz/sTrSkLbYc
Xm7NWmU7lYSyXtnqvLHdeTvFeTfVRShwFx92lx/1VB331J3ExDSC7z3CSx7J
Na/ihld9E1uM+R7rfY/jkcf9xON7hqSEXrhC5S660gnVTqgjBbObbNBiw+q7
7RYQmtnJIO0CuR4UOkKBGsv2ahWgw1ka8XbeG6zg73qtgZUsC4NasdDux53U
p0ho9OfymNHKyWNUMyagh02cxNYMH7YxAd1waqJ1/xLroeW2zFX2k0ko7uWt
zuvbsdRt/m73g30IqfiwpyzTW3XcW3cKayELLviEl32Saz5Fjk99C1NSGQu8
1gdex2Ovu9DrL0JeQmVu+qWbrnJBrQvqScXhFju02qHNBh1ocYhOStYBRReo
SCyl0YBWBToF6N+BBbIb8lOyXVhCagrXUgOJgx/cTg0NU0DqDn8ujx6tjBmj
njZeS7APXhpnWBVv3JBgTp6Ly9q+Jbb05fYjqxwnklDUS1td2TvcN3d58nd7
HuxHyEUZvrJMX9UJX91pxCu46Bde8Uuy/Ypcv+Y25pQy3fNZH/ocT3yeZz5/
MX4lVO6hKz1Q7YY6Ul672YnFlwUO6LBDp41lQGYChZHbB9PqQacFvRr0OGMj
3jbtwd/9PsEXRO/F5FjHVpQe3IG4h0moEchi9GhV9Nc4zRIo5HhxnHFlvGld
gnnLXFTCniX2AyscGaudx9ehwV/c6r62w5O7y3tnj/f+fh+DuzTLX3nCX3cG
UbZeDAiv+iXX/fJcv5rBfd9vfeR3PvV7nvv9JfiV0EsfXeWFWi/Ue4jaXdDq
hHYnCMlckNgQkcIMShOojWy+ML0WutAdRrzt27fOmSp5xPu/JNibqIHE74eB
fyKhhqPTZwqpT/pGN/1bkuErzrQ83rw2wbKJAE9d4khb4Ty82nVsnfv0JtTP
1R3eHATuu5eGKJ5n+MPAK074a89gJfvWS4GOqwHx9YD8ZkCdhy2mBwHb44Cz
0O8pQh6C5b5QpY+u9kGdFxpR/9DqhjYXdLigk5i/DHPxgdICahIW6Iyg10e9
926YvyJoy1jMgwRhZeN5GPNnMupzBEx9rY0ep5s6sWtWLMYsS+MtqxOsG+ba
khci+/tWuA6tdmeuc5/aiLq5st17Y5fvNmJGDM+O+F8g5gCHOdhxLSC+gZg1
d7DF/DBgexJwPvN7iv1E0/5QlY+u9UG9D5oIZoEH2t3Q6QYxKa8uJ5jVVtAQ
zHojdHWBAV1exLvpr0dNbGQ0G9yHfRuD+Q8S6o9Ez6PRuqPH6adMNMyIQcyL
460rE2zr5tq3Esx7lrvSV7uPJnlOEMyXtvuyd/lu7fYXsJgDJVmBlycCNWeC
TReC4ZaOa0HEfKsbc5BgDniL8TJU4aer/VDngwYfUbIX2jwg9ICITHK5ExSY
6xI0JL2q3gxdRjB0gVHbf8zdVWLJukai90FhX4bxAfUpY9oImRqnj51oiI8x
zZ6CLmx5gn3tXMemBc7ti5H6tFWejCTP8Y3eM1tQMddS/Lm7/XfTAg8PIoow
5PKTgWqEHELI2UFxTlB+K6jJRwbMj4L2pwHX84C3hECuDNA1fqj3Q5Of6NgH
HV7o9ICYQFa4QEUSlWoJ5C4LGE1gxDkXkT2xb7zkvo95w6uegG2jhnRSf8Db
emqEkhqlob5Ci4meYIyLNiVMRrBLZtpXz3FsmO9MXoRg9670HFzrzdrgPb0F
lXIlxZ+z239nf+DBQYRTnBUoOxmsPhts7A32dlBzl4B9HLQXBl1FAe8LArY6
QNcGoMEPzQRsuw+EXhAR45a7QekCtZNdwLtsYLSACU0uIk/EW5HWsN56kLBH
rZ9rqC8RKTXBODnaPH2ydc5UpHT5bEfSfNfmRPeOpWjAB9Z4j27wnSRIL6f4
r6cG8jikRVnBMNKqs6GGCzQivR4S5xKkBfhXy5OQ/VnQVYznwcogXROg6wLQ
GCA69UOHDzp9ICFIFW5Qu0DLITXawGQBs6H/SJn7VlIctRF9M5nDn1HDCM6R
Gmq0jhqD3cVQ5qmTrAlxtvnTMQBbM8+1MdG9bQni3Lfal7Hed2Kz/+w21ER2
auDWvuA9gvN5VrCUwXmxG2dInofaNTwKWZ6G7M+DrhKCsypI1wahIQBNBGd7
AIR+EPtASnCqPKBxgY6Yr8EOJhuYMSTh5yphMPIrLv6C800jqIGvqIGMV5JR
nynJFNVRXxuob7C3ybHW6VNsc+IR4Io5rvUL3VsXe1KWowAH1/mzNvnPJKNs
V1ODN/cF7x4MEYChFydDlWfp+ov4Sn/7jZDoZkh+hwFIWwpD9qKQ+0WQ2GuQ
rgtCYxCa8RI6AiDyg4TYrtILGg9o3aDH9MhgtIMZ1z5+zpi+0XXndh5ODcR7
M+pjKfVHJfUn4nrC0MYZqQno1KdOtiVMc8yfgWvcmvnuTYu925ehaaYl+Y9u
DJwi0K58F8zZG8pPR/mfHUNoFWfpOhYajdDyCbTHtOVZyFEc8pTiZagmRNcH
oYngagtCZwDEAZASaGovaD2gRweEQMx2sKBf6Ce2X+IhjIvUNR+EGyLUMAU1
AiMQ6ssuaqyRGo/QJk+yTZ/qmDMdoa2Y51mf6E1eitD2rQ0c3hA4vjVwbgfK
dn1vKC+dfpCBpljSG1oOLbpFy/Ox3fiEtj6jEVo5gVYbohtC0BwiKguCKAgS
Yp9KP2i8oCOBk5FozYIuICJ30htwfUb8CwmBh5Lgd7iK+lxLtGYMGyQ1EYma
OsWREO+cn4Dec81C7+alvh0rkNj09cGsLcEzBFf23tDtA/T9DMRSfJJ+eQ5q
u3HdpuV3Ca6ntPU57XyB54FqOlRHQ2MIXhFcwhCIgyAj6lP7QeeDLjLpTGyy
7v/sF6bujNzDqCFC6hMZcSBa6s8YzVJjTdQEC0UhRdOnOefMdCXORurWL/Zt
W4F8pq0LHtkcOrUd5bm6h755gC4gcIpO0uUcnLYcCMNRFHBwimhnKYFTQ9MN
NDTTREchEIVASnCpAqD1g54s/yYPWFg4/cTTnY17MPVxOIRBs6NG6ajRuGCG
zY76FqdoXJwzYbpr/iwEs2aRb/OyQMoq5PHQptDxbaFzu1Cm3DTIP9wDpuYS
AZMLojxQFOC5sRBsxeAqww8Ha2m6kYYWAkZIg5gGGQGjCYLODwYfSVj6234h
+DWH4HecP0d1UF+hP6cmWqlodHTx8a45CZ7EuajxDUsD21ei+Okb6cxk+kwK
SnEjDe4cgoeZKGnZOagmuhDkgDgs/j0i/jOwlYC7HM+DdUA3AbTiOYhokBIc
6hCTYGoAmL1gdYPNCSRFbRQfx4A+cZBo7LfUENxyCysCj6gIAmM8WhUVi/Hj
zBmeebMRxtrFgS0rgrvW4tgZW+mTO/Akez8+1Hz/aA+Mxmt4Lr7TA8P+Atwv
8TxUD9BCMAgB+Q4TrA+Cgcx8ixds6M74Wd34Hq1vLCTS+ld252M4uRH4oov6
ykhUYqNiEEjcdM/sWd7EeTjPNywLbl+N8h/cTB/bDmd3oVQ3D0LBETwpPcs8
WhH1XqAGCUVR/zcePgQpEV9Ngy4EBjK1LT6wIT1vzdb3BsnJm9KfkAiX9cIG
agyunWFjoiah/42f6Z03FyVfuyS4eSWabtom+mgynEoBsu/4QeVFqL9KmM8H
xX08MT1nhid7T38FYgAZEV5Lg57YviUAVh/YcZLxsyDyo5y+ZSefwu1fdpth
JLM4mqhx6GOpWGd0HKp05izfwvmo5PXLQ9tW02Rf8IMbpGTmgywUqVv2KMYq
nJzRs9bSCWz+bw3DO5He6ge7j2n+oaz8qJuR/W+gp34rQiDa+SkxfSlj+ngc
Y6bGozelJuPKEDfTN3sOkr5maYh5Uy99M2RuhzPEXG4fhvuZjB1/FCZd+QAb
zWGPU0Gkr++er4R4Js8Pcm7DHiOydPLvjRipSY7bH/UwHpkVh8yPj4jZk7Xh
C7IwcAqgpqAC4mex+egHrFtOJxO7z0iGkynMgGQP7eUFqOXMR/kQTyxh51NJ
Zm0jQBtBIibHsBL0NBHqI57M/Dv5/mIgqzt5S/5PzC0tsxgQRUxyUVPRQmfO
9icuDHbbyL+ET3IOQj5xPOXfs8KLOOGtL/DoD1tQM2tBrPHraOgiztMWAAcq
gp8tlr/r1F8MZPUjT42MJK6U8T0T7IT3X0XHexdx/1AHa1CGo6RSYPgkj/E6
56HmCofiEZ7YyvAYCFvSq178awn/OAOCYMdpFZEJmb9z2IPhvajICsa/5bBR
o4jjHGMiDP8yfD5tdmDefCR94yoc8XAyHE8hpp8B94/hSTURuDMfVERgOzNx
GzjOpRznBiKwneiPn2n5l6+dr72l5PONUhM5f02NxWCVotDHU3FoKzPmIC1J
K+ita1CAzJ14zD0EBVk/lPkxnjjI0kQ3c3NVQU5YI0FPw6+Jyf+VhpH3b6Hv
rFU4P/HDPfl0yYZNFPueRjQ6d2oaLiCz5iE9GwjTGWHT+A4FyScBQuXlH4js
JB6GNQqGYz0rLzgIx/z3r/i/Gr4+IkBOOR8Zlo9xJDHoDanp6G7nL0ROtq7F
UY8RY8hj5iCJv4T5ZM0vIXbbACAgwjGUsjaAX2d+vwiP1D+5fsnK9RPozo/z
DePgXAyPP5s+t4e7IzuIuklsWHqhRyoT8QnBJiKMpBdrdjzyn9TgX/ct2c9Z
7RKbfn8Rl+2TFW+Sm1m3Zi9A0MlJOObJVDzeO87mMv5QeJcsG6XECJnlTk6O
Rjqqr0pE/Ge0GLl+xpPrn1nGmDfEmU+jRGMN7zH8xaPvW7CIZvNTHSFTJC+T
lWpAB2HMSqYzKpF5Dxu6yLUD+eJrjv9UZt9y/SPLF0ExoOfTuGQZmF/kfkTN
CDAsbklitZ1Lblqqr3Jy2MmUxV5l7CfADswgEbOT/7R633L9LcvXz3vxxfwj
0dUAaiYrU/hfZgrHUuUV6G4NNgNX/cPAtfLXEv77fn3L8hNWFr4Xf4+T5r15
i2h2BEaOl5d75MCgA505P57ge4S+x/6Q1Q8/hsLYlqlQcSKVG4vJuw4Ojnn+
iHy/2feIA1i0fcX5GFryo2h+Lvxevfasz2yf/Oz86Ncw5OPvJvBXJF6f3Sv3
QN7n8K1WDL3491v8/sidAYlTEXj3SsD+lYtKcajf876J+sA7EX4edH7ufmaE
H/N6fu+HrERFrv388bBWAL7B9zteOz/CYMZjBuixRH7ewsjxOQ74/aPNo23z
GebXDegvTv4n+Pz9NSvH4D7k+O+M9yHbH9/ifsr7Jn88fgTd3/E+4n2Cv/cy
mnfNr/fRY5Gc9eH/HCv8ufgV75p/78L09iueTPyZ+zXvml/jhOnl16wM/DvQ
Mbxr/l0f8+1/Z5Hwvz2Wd82v6sJ8m3uOrLcdc7bNzVC+Tx/Hu+bfSTM9/32E
Bj/gsdVn1uRe/XzTV78R4/w1KyXrwnqGixhvAMszf5UZz7vmVwDoLx7Opvj9
T+Bd8/d7Xtf/ALa/j9j/+ev8RAKq98pNthLe0FtvafnziR91fUt66L5mY+Qe
i+Fm0k9YVvnPclLcNbOcsHL9jjcqP+aM5v7OBnCMUn/PjsGPBCf8ECX0zO2o
qEG8kfhR0Rje31ErAzitdu/Z8v177/0Ufmwzlu2Bqcn4fyI08KOIlvcjWvgR
xHDe+L21SIKRKPa+sV/jcTrjR0ZklA9688icL2Jrzf1Dv0f4MXD3K92dRKzc
fEzYwc/6PcJf8b7N731YH73/vN+9954VCIMfBQzto3fSb7fF9F5Zen+Sv67/
vzdolusZbfZ18RND8B/ZT/BXcdL7AJ5GST/dfLxxtSUjRmiKv6b+ps/vdXPS
jxF+B69ffwawffFXTdL3+5HWip/9TT/H/f8R7Xxvzp/5fUrBm4n/8Rcbnaue
xl/z/573ub78Afe0bF+c/uQvJiG3OvUp4Wu0889v7ZXzH9wseu810nCjc5W+
+DEIP0M+nv7iraP/0xtGi5wHvXrnjf7TPkb/VT9H52YE56v56zQ/enj/DXz/
39fyRtbdqC/x+EG3nNBd7pGzg9f025eFAeuXPnwre8QKSITN7rH0Gra3p+OY
i7SaSL/9IY81ZgxcC950//njPq0isncStUR9yuul73vNvnX93+/zt3/Bvrgn
SV8X7f+lxnn7POfqvXHz/Pf97Jmr7PH2aH8EcBbQe5x/eatkzPfGwOst58cR
fXCz6nNyOfatKD7os4fe3xlJmv/Mon37LgPnNzn7H9lPSWL+Rz43hsd6LGm9
GHGM+l//BSQhHdY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 309},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->315608893]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->445539917],

Cell["More points are sampled when the function changes quickly:", \
"ExampleText",
 CellID->382860810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"7", "t"}], "]"}], "/", "10"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"7", "t"}], "]"}], "/", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172764079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253337378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522092952],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->143328471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "/", "t"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11813271],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12570195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599482084],

Cell["Ranges where the function becomes nonreal are excluded:", "ExampleText",
 CellID->877461877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"t", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Theta]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615433788],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254976353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->480472185],

Cell["\<\
The surface is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->103006685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", " ", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "\[Theta]"}], "]"}], "^", "5"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "5"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydfAd4HMeR9d4CoLJkBSvZPuvss+98/lcnybLPtuQg2ZbvZDfAnINIDcWg
TIpiBpFzzsAuNmOxABY55xyZo0iKSqQYkYFF3vf9190zAwID0LIPX2F2J1XX
e1VdXdMzO2TjR1s3v7vxo21vbnzmzzs2frB125s7n3nt/R10k9s/qVSqEvof
/KSKfv//9Bv/LwFAd8xY7qZLd7rrV3xtD1u60VW+Jm/dO2Mr+/pLvnWfYut/
/Y2trBWV++2tM9tT07WHJCv+jW8NU1ghbvWXjnFXtPBjvjdCsfVHfKu3pP/+
efeuo0u28bvSUSo3+mXz5s3s691zLBatWK/Q9KSkQy193iPp+vd5j/62dJSH
rJ22Jmp/Yd7jH5W0qRXbOQfu4sni+c/Pe/63pPbu+zuPf3AmE5ID+Llu04aq
2P7npvljaw9IrTzMtnpMtyId/5/8c7t0zKN/45gt0jGPz2iRfVWi/3/8aEGK
hydnY5N0aPgxr0oW/rP0+V2FZjeF5p/ys16Z4/unpba+pzhfGYv/cYfzn5Ta
V7b3HYU+D8X+n9xBnxxHP5zHHtbOnXA8Ip33Y8V5CxTt3isd95076JHj6t8V
eu6aR8/M9adneeVBSctPv0GLm8S+kj1R28KZHr8DJpXcB+acTaSzn1OcfY/i
6LvnPfsv0tkv/J/O/glu5x/2+XOFlrul7XdjRvSKMabIQIyd/5qPRY/p4yQW
xMz3wzsw+rjUkjKuRXzg6yxBPqDY/8N5LXtUauXX4KGpUgVZEGxhCpTn/2De
8x+WrPkNR0IPCDQhyIxgM7dhZk5XyX1hjo4HJRt+I1KiUgUYwdSYJDUhFsxB
8y/T3pmZ3X4vOpYORAYEGBBoRJCR6WFKzAg1z9XzDNfzC8zNqVzXfUyXHgF6
BBoQZECwkesyMV1hZoRbbvdD0aKfSWt/ZGsP0A1+OvinIyAdgXquwCArMHEF
og5l3H+f63pY4kUe+x7iPiKxIDEg0SBRUJNIeh6JkIPnWRm/rxZ+WvjrEKBD
YDqC9AjWc4+oQ41UR5iJtRxBxQJl2//M235E4bmnMGOUemBhCryS4ZkIkgAS
DxKHmVZRo6hJJJwZGwY3EoqfyNHhmwq/NPhrEaAVBwTVXaEGUJvCjAg3MYsi
zYiSWGWYRSbuw/x1hdwXlKPPvTL7nkmyifPZR62jxqkWkBAsIMH4gdyDfFLg
myJ2VNWCQC2CdAhORwhnMMwAdTjjMMIk2RpthTKHyjn+CW79Y4q9coZ/RLZS
aeJs+6h11DjV3SSIchlIfR7EfB4s+5xnnG+B1ynin18K/FMRkAZmuhbBOoSk
I5RbH25AhBGRJqijaGdwi7YgxgrMkw05o7PGk8fnxfKQhOUJubdIKKZZngGB
Ga6mCNxIAEXhTzlnn4EMTRA8OSCxVmO8P+ydgEOJ8EmCXzL8UxCQisA0DkeL
EB1C0xHGEYlwokyIpoDUMTR03GKtMjc8p8/Jr8poeWy6t81GLGN7eiY2EVi4
EhiFQmH4427ix7Gp2QYPCs4zCF5BWBiMhSGS5xm6R8QmDsbBOx6HEuCbCL8k
+CcjIAWBqQhKQwgVLcJ0CE9nMCMNiDRCHW2iNlKQsRbEWZnI447bHfz1CGZn
yO9PYxFRzIZADaf2E18aD8SHYvCl/34s9PzhGcAlUEKzKBiLQ8C0qql1bqLr
VKr9MTgYC+84HIqHbwL8EuGfhIBkBKUgOJVhCpUxRXDvRRkQbUSMGbFmxHFM
8VJvmoVlfo99H3Oz9jNi96f4xNgL4cgCZWQ+IIfgQbyZsw6CfrKvarZ4gO5g
u30YfHYohcxRe4mQg7A4GEtDpRGfms5z0dPs0isS+6NwIBreMTgUB994+CXA
PxGBSQhKRnAKQlIRmoYwLcJ1iExHJEfOYJs4bDPDnEAlY1YeuXOkyrXIv0HK
9hLKAMl5DAlFdpB58QD14EGWiL0hAZR8eheR0S0SoYVgWahYxzF0vDL5DkMX
gf2ROBAF72gcioFvHPziEZCAwEQEJSE4GaEpCEtFuBYRFJ0OURxdjBGxRsSZ
EE/RWRi6xAwk2TBdJ6lnZUh5dJnpyX+fRjcNzYfjOgCyH2QfA7WX+nIf8+V+
vvmg5Mt7pqGKjvQKwKJALOEgeVbn2e7b7KI3FHvDsD8cByLhHQWfaPjGwC8O
AfEITEBQIkKSZIBpiNQiSofodMRIYynFp3KjCBMsSLTStpMy6HqyTU417nPi
WKwpn5CwPyemKIrQjzvnoASMwiJ7cBfZDdX99Atb3cu3yyhnOtPTT8woHhTb
8lCsCMOqcKyOkGprFp+7grA7GHtDsD8MB8PhHQmfKPhGwz8GAXEIikdwAoMZ
lozwFERQmGmIlmHG8nIl3oQEMxItUCdZGcIMpNiQkjl31BC9+fgc3M9Bqi4l
mPtoDO5hDvwYZBfIR0w86DeaaeiW3ZBQz4DMMd7r5YeF/lgcgCVBWBaM5SFY
GYpVYVgTjrUR4MHzFG1lpx92BWB3IPYGY38IDobBOxw+kfCLgn80AmMRFIeQ
BIQmSqAjUxFFQWsRk47YdMQZEG8QPZxIBxUPCjrZipQMpNqQmnk7hp+6jZZx
IA6+vA5XM9AsNBmWjznAnSw2P4Q72UGx72Rjw0ccu4h3L93LTn5GROvpDS8f
LPTDIo52aSBDu4KjXS2jXR+JDVHMgJ0+2OWH3f7YG4j9wTgYgkNh8AmHXyQC
ohAYg2CKNh5hiQhPgjqSFjYPRachRotYHeLSEa9HAq9qE01IMiPZghQrUjnY
tExo7XO9/Ph8XqYKWO1Lw456ebcEmQIm71O879Exn31+wPoq3bZDZJctXpTc
zX3teQBeFPohLPRl0Jdw6MuDsCIYqzj0teFYF4ENkXgjGju8scsHu/2wNwD7
A3EwGIdC4RsGvwiGOygaIbEIjUNYAiISEZmEqBREpyJWxp1AcRuQyKEnm5Fi
QSrHnWaDNhM6O3RZUCL/Nkd+F+bOFPBsLVWo7nImkyZkXpju55SUD13kfRd5
10XedpHtdElZeQeql8i7mK7fKE2MpJ0z4oMTxNg5iIWHsMgXi/0YO8s4Oysp
OyFYw9lZz9nZGI03Y7DbB3v9cCAABwNxKBi+ofAPR2Akgik1MQiLQ3g8IhMR
lYToZMRQatIQp0O8jlGTaECSEcn80inVgjQr0jKgtUHHqUnPmhsVIjcL5vT9
+a9xxVmU21fCL0zHznsT5O0Jsm2CbJ0kWybZIWqyHaqfU6ooSTSMGD07ZtCz
B56Um/2Mm0WHsNgHS/yw1J9xs4Jzs5pzsy4cGyLwRhQ2cW42x+GAH7wD4BME
vxAEhCEoAsFRCKXExCKCEpOA6CTEJCM2BXFpiNciQYfEdCQZkGxECicmjROj
zYCOjmzqdNpV3PRZMGRDBDM7OsReI49wcryIRMygS+TLfSZf6jvxxa5VyPbR
6b7kTt4cJ8Ik2TxF3nKpyRaX6nmyDfMS57kbnnvhxVlb6M1Z88UyylrAbdbW
hmF9ON6g4RTFKYvFW3HYQgu7QPiHIDAUwREIiURYNMJjERmHKEpZImKTEZeC
+FQkaJGoQ1I6kg1IMSLVhDRxVkCto+OkR7oNejsYX5yyOfNQj/5D8XSXgh82
4vAxg80nkE1D5I1hssFJNoySN8bIpgmai9+cUv2CbHZRlubhaBfrdV574LUP
Cw/MImg5JSgQq4KxJhTrwlhMbeQxJcRI7GxNwHZaG1F2whAaifAoRMYgKg7R
8YhJRFwS4lOQkIrENCTpkJyOFANSjUgzQWuGzsoIYszYYLDDmAW1kVLjZsqR
oSrn3e7EkgduzxKp5+GHzcSp5Sr2VcbRuj6ydoCsHiRrhsm6UbJ+jGyYIBun
KE+Mpa2gnfA2Szt4gv8YnjJFiyhFhzhFfoyilUFYHYy1odhAAygCm6IgRGNz
DLbEYWs8tifgbVpXhSEsAhGUn2hExyImHnGJiE9CQjISU5GkRbIOKelINUBr
hNYEnQXpVugzGEWGTBg5P6ZsUHLMVByYyY3ctdjq/X+DI+Uc5sx1JWc/wYza
+LeMs5U3yYoesqyXrBggq4bJmhGydoysnyQbXeRNkLcg0fYO5+zDOZwdvM3Z
igCsDsLaEKzjnG2MxJtRjLC3YrE1DtsoYYl4JwnvJSMyElHRiIlFbBziE5CQ
hMQUJKUiRYtUHdL00BqgM0JnRroFeisMnDBjJkx2mLJgzobakkNxWRxyTCln
PpU88Dmf6VFvvtHvtpbbbP1IYouz/3vG1qLrZOFNsqSPLBsgK4bJqlGydoJs
mGJsCSBbwPrhNFU7b+d2mqVEqpb6YoU/VgViTRDWhWBDGDaG481IFltvxXCe
4vF2gsTT+ymIiUZsDOLjkJCAxCQkpSAlFalapKVDq4fOgHQT9GboLTBYYcyA
ycaoMtthzoIlG9YcWB2w5iIjd04lMD9HytmRexWc/IvECZubV/2OcfL6ZfL6
NeLVTRb1kSWDZIWTrB4j6ybJGzSCXGQzjyDa696bURHImZtysuQQlvthpT9W
B2JtMNaH4o1wbIqAEMUI2RKLbXGckES8m4T3k/FBKrMyIQ6JCUhOQkoKUtOQ
poU2HTo90g3Qm2Aww2iB0QpTBsyZoGxQgy1ZjI0MKg7YcmHLmx01qnnm5m4z
cvvu3m0mvicx8dg0E3+4RF67Ql6/QUgPWThAlg2TlTMC5A5MEM7EYm8s9cEK
P6wKYKGxPgRv8NAQIrE5GltiGA3b4/FOgkwDzcCxSIxHciJSkpCagrQ0aLVI
T4deD70RBhOMZphEDmywZMLKacjIZhzYOAeZVPKQmS95ec6I9MC8EaHk4SmJ
B34t8Wvy0lnyypfktWvk9VvEk0bEMFk+SlZPkHWzSXiXj1MyCTSbLDqApd5Y
7ouVflgTiHXB2BDCO0cENkdhSzS2xmJ7HGcgkYdANJJikRyPlESkJUObCl0a
0rXQp8NggNEIowkmC8xWWDJgscGaiQw7MrIYCbYcZDoYfLWdhoGbPX9WHvkb
PLhJa2zceUL6ZHGgepm8eIK8/Bl59Wvy55vkr71k0RBZNkJWjjPcb/DsMAc3
HZwX7sOSg1h2iIFeHYC1gRx0KN4Mx+ZIDjqGgX47niOOQFI0UmKRGo+0RGiT
kZ6K9DTodTCkw2iAyQizGWYLLFZYM5BhQ0YmbHbYspCZzXDbHbDnIisPWfnI
LpieeZs5Z6GexrvgDllyvjs3Dyli4mEpJp4RufnPw+SXF8lvL5M/3SCv9xKv
QbJ0mpspIrhmcuO5E14fY9FeLN6PZd5Y4YNVfoyY9UF4IxSbwiBE4K0obI3G
9li8HccsTYpEcjRSY6FNgC4R6cnQp8KghVEHkx5mAywmWMywWpBhZazYOCuZ
WbBnw56DLAfjhrKSzVnJoVI4556CyMn0HfXp4Jg7Q6Lk61sKbh6QuPlXtvIS
ebaT/OICefkr8scb5H96iecgWeKUuGGjygxuPoTXR1i4G4v3YdkBLPfGKl+s
8efEBGNTKIRwvBXJiNkWwwxJDkdKJFKjoY2DLgHpSdAnw5AKkxYmHcx6WAyw
mpBhRoYFtgxk2pCZCbsd9ixkZSMrB9mcmJw85OQzVhyFcBTNvdPz9zMjz5g9
qmDkHokRPl/2S6LpIi+eJy99RV69Tv67hzMyMpsRl5hGPXfAaxcW78GSfVjh
jZU+WOOHdQF4I4jTEYa3IrCFTzAkhSA1HGlR0MZAFwd9AgxJMKbAlAqzFpZ0
WPXIMCLDBJsZmVbYM2DPRJYdWVnIzkY25yInF5QLaqeDc6HOpWS45RbLiUJZ
uz34D/PymIIXD4kX/iTCz4jmMPnZBcbLK5wXryGydPQ2L7zC9XyHdaFFvAst
28vCZOUhrPbFOn9soKSEQAjF5nAeHUFICUVaOHRRSI+BPg7GBJiSYE6BJQ1W
LTLSYTPAZkSmGXYLYyTLhuxMZNuRk42cHDgccOTCQROoOjdffNoirxB5Rcgr
Rn7x3Di5/x/iY86c8exnL+gKn5F7jmiOkRcukF9fJq/eIP/dy1hZNkpWieMN
L2C3YyEfcRfvwqLdWEZD5SBW+2CdHzYEYmMw3gxhjaYEIDUI2lDoIqCPgiEG
xniYE2FJhjUFGWmw6WDTI9MAuwlZFmRZkZ3B+MihfGTBkQ1HDnLpiJKbB3Ve
AeUjv5DFSj4no6BE5ON2dv1H4uJxCbFYryw2YbGRiYrN0f1Y6jMVRHOSvHCR
EfGHW+R/+sjCYbJsjKyeJOt5Jb+FZZGF78NrBxZ/jKV7seIAVntjrS82+GNj
IKfA15UWAF0w0kNhiIAxGqZYWOJhTURGMmypyNTCng67AVlGZJuRbUVOBnJs
cNiRm4XcbOTmIM+BvFzk5yE/H/kFoCQUFDEeKAOFJVAXlkL5lBSvPaZHmzuN
OvwuP9UjXvEsNGGhEV6UAzcvA9y89GATCTyjvkA0TURzmvzsEnn5a/KnbvKX
frLQSZaPkzV8JN4Mz23wehcLP8Dij7BkN5bvw6qDWOuD9X7MkFTvqTRfly4A
+mAYw2CKhDkallhkJMCWhMwU2NNg1yFLj2wjckzIscBhRa4NuZnItSMvG/k5
yHcgPxcFeSjIR0EBCmi2KKTZwqOwmHFRVAomZZjzxJjIhfw8ljyK8si4/TTT
IgsWsjuFXiaoiYHNR+pB0pmoPIiOz9yyWXo2XcfYyCaadvLsWfKLL8hvr5HX
eshfB8limlAnyPopssnluQWe21lkLNqBpR9j+V6sOoC13syOtAOT2kNT6X5T
hkCXKQTmcFiikBEDWzwyE2FPRlYasrXITkeOAQ4THGbkWpGXgbxM5NuRn4WC
HBQ4UMCpKMxHYQEKC1FUBHURTRAeRSUoLmWEFJehuFxkQ54pcpfzwPT9v4dm
9oK76JelNizOwCIrvMzwNIFRoaZUUD4oGToQLVtPgztJ5ZwwVlmU0BpVIyzV
CKs1whsaYbNGeFsjfKARdmmEvRrhoEbw1QhEU0s0R8lzF8gvvyK/v07+TMdl
mm15d2LFnEsMoUUfYslHWL4HK/dxuvaM6g5M6A9NGv2nzEEuSyisEbBFIzMO
9gRkJSE7BTlaONLh0CPXiDwz8izIz0C+DQV2FGShMBuFOSjKRVEeivJRVIBi
GjnFNHLuKi5GSQlKSlFSxhgrKUdJhfjcyZ2u6VSzGFRe1zAmxQy9IhvLs7DM
TtlaYoNqAeXUywIaXJ4GeOoZk4xFymoqSDITlTtJ4oxyf9FPNSVU9ZuFGmGJ
RlipEdZrhDc1wlaN8K5G+FAjfKwR9muEQxohQCOEaIQIjRDNGLYRTTN5luas
S+SlK+TVm+T1frLISVbw8WyTi2Zuz7fh9T4W78SyjxkK7a6h9L0jRu8Jk++k
JWAqI8RlC0dmJOwxyI5HTiJykuFIQ64OeXrkGZBvQoEFBVYU2lCYiaIsFGWj
KAfFDhTnoTgfJVRoolaXUH7vKeH8lpZyKUNpOWO5tAJllXOfuFFWv//EWZbn
qe40py4/Y8WY5/XyI2tysdqBVQ6szMHybCzJxGIbFmVgoRWEx7MUyKkuSjiR
H1VxI3GcdY+Z7L/mxWOasr+Gh7XoADGyP9IIuzXCgRk+iNQIMRohUSOkaASd
RtA/u5Voylh98dxZ8vMvyG94miCDPOLp5Su/fNkGTx7xtEXdzj7D7iHT/hGL
z4TVf9IWNGUPdWVFIjsaOXFwJCA3GXmpyNeiIB0FBhSaUGhGkRVFNhRnotiO
kmyU5KDEgZJclOahNB+lBSgtRFkRyopRVoKyUqjLaIL0KCtHWQUTylp5legL
eZxgjx8z7kX+5z4/MP88K7/qodp4r3hiUzE2FuGNImwoxPoCrMvH2nysycOq
XOaYFdQxOViW5Vpqn1qSObkoY8LLOOZpGCHxYyR6gkRNkigXiRKnsVV/Edlf
pxE2aIRNGkHQCFs0wjaN8I5GeF8j7OA5Zg/vDd4awU8jBGqEUN4hYjVCguwM
o0awagT7s5uz/3M70diJpoFoTpDnaSq6TF7hvYSOZit5fbOJDeu0l9DG9R/c
Mu7qM+8dsh4cyfQdtwdOZYVM5YS7HFHIjUVuPPKTUJCCgjQU6lCkR5ERxWYU
W1CSgZJMlNpRmoXSHJQ5UJaLsjyU5aO8AOWFKC9CeTHKS1BeSvtKOfXJgvJy
VFSgopJLFeR4VuShv8s7c+4SuEs9hN+LcdtWga1cVGq68NhSDvap3kY75V1v
V+GdarxXgw/qsKMeHzXi42axJlL9lYRMkFAX/UrlPZ6FKPs7uQN28zwv+oCm
en+NEMTdIPaJeI2QrBG0GsGgESwaIVMj5GiE/OeE4uffKvvZ24U/3000lUTT
QTRnyIufk99cZR1FHBrk6oK2aHz3qmXnrYzdfbb9g/ZDI9n+4zlBU47QqbxI
V34MCuJQkIjCZBSloViH4nSUGFBqQqkFpRkos6HMjvIslGej3IHyXFTkoSIf
FQWoKERFESqKUVGCCto/Kqkv7qosR2UFKiu5VKGymt+feGjeWvL/1l/UkkdY
TaGmXKs/rKPnfVjPSKeyswFqyr3K4+Mm7G7Gnhbsa8X+NtETd0s5SvXaPp6B
KOc+cujTPBQ+g/YkjZCmEdI1gknsABrBoREKNELJs0LF80LtL4XGl99u/uMe
onHwAu84ef4i+ZU4cAzI9QzzuPntr6wfXM3cdStrX1/2wUGH70he4Hh+yFR+
uKswylUUi+IEFCehJBWlWpSmo8yAMhPKLSi3osKGikxUZKEyG5U5qMxFZR4q
81FZgMpCVBWhqhhVJagqRVUZ1FW0ZPGoqkBVJaqquFRT1FU1s67hZl4FyWxO
jxLz+GDmXY+Z9+TZTIp6bwvtfYxezvCBdhxsh3cHr2oekKub3wTNR20qp9ao
oFYjVD4r1D4vNL4otL0sHP7T2yc9dxGNmWiq2UW4hg8Gv+Plj9cwWT5G1Wds
u5T53lf2HVdz9tzKPdCb5zOY7+8sDB4vCpsqjnSVxLhK41GWhLIUlKehQocK
PSqMqDSj0opKG6oyUZWFqmxUOVCVi+o8VOejugDVdAhWV7OasLoE1aWoLkN1
OapZv6+mfd29ugrV1VxqoK6uxcx706xmdpfvadyB0bk10uwZbb7u0wnfLjGX
PybH7atiuSJmZzEtmDWCTSNkaYRcjVCkEco0QpVGqH9eaPml0PGScPQPm8+Q
7ac8PyCaFKIpJppW8uwp8sKn5CV+MfLXAao1861z2e986vjwy9xdVwv23Sz0
7i3yGywOdJaGjpdFTJZFozwOFYmoTEZlGqp0qNKjyohqM6qtqLahJhM1WajJ
Ro0DNbmoyUNNAWoKUVuEmmLUlqCmFLVlqClHbTlqKlBTCXUNHTrdaqpRU8NE
pa6ppdvq5sw2uMtXG8pfH8y6C3c7PudhUVp/Uo7Hl5JmDGvZGiFPIxRrhHKN
UKMRGp4TWl8Uul4Wjr8inH1986dLt55bRYkL4528npXgz55nJfgrN6imHOFE
7vZz+e9/WvjRl0V7rpYcvFnq21sWOFgeMlIRMV4ZPVUVh6pEVCejJg01OtTo
UWtErRm1VtTaUGtHXRbqclDnQF0u6vJRV4C6QtQVoa4YdSWoK0VdGepop1bX
0cBzr6tEXRVqq1FXDXUt69W1taitY6JS19bPikE5RyrvIIncPSZVHD9Q7H1a
jrLn0/lok8XZYb2SBpRGaHlB6Pwv4fjvhLN/Fj5dKFxe89Znm94nGj9eO9Me
2smu6n7+OVWQ/2ZX4dYTxe+dK9l5qWzPV+UHrlb43qoM6KsKGaoOH6mJnqiN
napNRF0y6tJQp0O9AfVG1FtQb0W9DQ12NGSjIQcNuWjIQ0M+Glhd3ECv0xpK
aMapL0NDGerLUV+B+krUV0FdT1OdW10N6mtQV8sYo+NCXT39p6MBZl5dKLlQ
/urmGcX6d+S4ecjBA4X2rQaN0PqCcORXwqlXhPOvC18uE65tENj9Fs1BojHx
yrVNHPd/WLyppXTr4fJ3T1bs+KRq96XqA5drfK7VBnTXBffVhQ/VR43Wx000
JLgaktGYhsZ0NOrRaEKTBU0ZaLKhyY6mbDQ50JSLpjw05aOxEE1FaCxGUwka
S9FYhsZyNLK81MjyUkMVGqvRUMNE3cDyUn0dGupRT8NDXU+5qG/knp8ZK/Pz
8sQ38PI9mZe7aikdzwtHfy2c+YPwKRGurBS6BUHE/wOi0RENzaWqirWllRtr
q7e01rxzpHbHqbrd5+v3f9bgc7kx4HpjSHdTeH9T9HBz3Ghz4mRLsqslDS06
tBjQYkKLBS0ZaMlEaxZastHiQEsuWvLRUoCWQjQXoaUY6mZafTTTjuLWVIHm
SjTR5KJuohHh3lSDxlouNB4aKQnujQ1ooNLIRN3QBGX2Vd5fFNl48hvYYM/N
skeAVT9qWJfXsKm8cUt947ttTTuONu8+3bL/QovP560BV9pCbrSF97RFD7TF
OdsTx9pTJtu1aE9HuwHtZrRb0W5Deybas9CegzYH2vPQlo+2ArQVoa0YrSVo
LUVrGVrL0VKBlkq0MJwtFOeClho013KpQ3M9mmjkNzUw/I1opNLERN3YDGWW
vGdetE99A1q27s6u8n5KD748Msnq2iY9XXYIBR3bKjrea+jY2dG551jngbOd
Phe7Ar7sCvm6K+JmV3RvV/xgV+LI4ZTxLu3UYT26jOgyo8uKLhu67OjKRmcO
OnPRmYfOAnQUoqMIHSXoKEV7GdrL0V6B9kq0UalCWzVa2cjRSqPco7UOLfVc
GtBMgaubaQW4oLkJTVSaubSgsQXKZ37mz49PS/nxX6TP78t42dNUXzgnvxzh
pTx12tECHuffPb6r6fjeruPeJ477nTsedOlY6FfHI68dj+k+ntB/LHn4WNro
Md3EMYPrmAnHLDiagaOZOJqFIzk44sCRPBzJx+FCHC7C4WJ0laCrDF30yqKT
Zf2OSnRUoaMa7bRHtzOs7XVoq+fSgFaGtZVGcksTxdHSjGYqLQx/C+sNrZBw
KaN8ftzK3wnOlws5D+wZ4s+Gpz4fcX0xwk7EERtOluJsHc53iD3/qbMBp8+E
XDgT/vmZ6Cun426cTuw5nTJwSus8pR8/aZw8acZJK05m4oQdJ7Jx3IHjeTiW
j2OFOFaEo8U4WoIjZThSjiMstx2muc2tqwpd1ehiPu+sZczUoaOeSTvNa+2U
gzbKgUdbM1qptDBpYUy0tNJzm1vR3MYxfFMEiHXw976BCRYhboyJ++nBF4cn
Lznx2Qg+H+VknHDgbCUuNOPSYXx+Cl9eYI/pqp45n3zrk7S+T9KHzhlGz5kn
zlqnztpwxo4z2TjtwKlcnMrHyQKcLMKJYpwowfEyHC/HsQocq8TRKhytxhEq
NThci8N16KJSj64GdFJpRAfF30H7eDu95HRrb0EblVYWG61Qt7ax2GhDSzu3
fYECi/KZHJGBf/4GBp6QGODedj8/NHVhGBeduDQC9Wej4u8FcLEOn7Xji+P4
6hyuXMLVy7h2Hde7cb2fM/LEBdvUebvrfDY+ceBcLs7l42wBzhThTDFOl+BU
GU6V42QFTlTiRBWOV+N4DY5RqcXROhytxxEqLP4PU+xdFHsnw97Zgg4qDHs7
Xbi3t6FNlHbKRDs9orVD7hVKJpTrIhPf/wYm2MyAWmZiwamBibNDrk+GccGJ
iyP4lPJxaZRNjFI+Pm/Gl0dw5TS+vohrX+D617hxEzf7cGsQt0Zwaxzdk+h2
sR91qe47X4RPSnCuFOfKcLYcZypwphKnq3CqGqdqcJLVOCdo4Xfv8Xocb8Cx
RiZHm3CESjMOU2lBVwvlhXHQ2YrONnRQoRy0t7Mc0oE2WVo75/aC+Zl4ZkZe
nLmX3z+9h1IgTnAc6R090T91etBFiTg3jPNOausFysPFUfG3WfiqE1+fxLXz
uP4ZblzGzeu41YPuAXQ70TOGngn0TFELesGZuOtcNc7W4GwtztThdB1O1eMU
8/pJmuHvOdGE41SacYxKC45SacURKux6/3Abxd/O8LejswMdXNzaKVy3tk60
dc3b/5X5QUSurJSVMcF/s8msvbvtlrOrd/JY/9SJAdfpIZwdxjknPnFCfZ4y
QFngGQNXj+P6Ody8hFuX0X0N3bfQ04feIfSOoncCfVP3oY/qd/VCZJT/0E/l
caoJp5pxsgUnqLAIP85y27E2HKVCgaqPUP8e7mC5sgNdnUxoruykmaGL+p1d
SrYflmN/3hFgDm7lL62VuB+Ucd/bcH24pXu8s3fqcJ/r2ABODuLUEM4M46yT
EaD+ZIQzIKK/cRa3PkX3V+i5it5b6OtF3yD6RtA/jv5J9LvuQT/V2gc3F2XB
Y6oPE70Y78VYL0Z7xZ+zqjyOt+NYB5OjVBjOIxTnYYqzi+Hs7ELnYXQcptvp
Yt4Kdw7Wf/0GrPfJWO+r/Hq4/sZY863J9l5XVx+ODODYIE4O4dQwTg/jDIt3
Clt9boTjFnNh75fou4q+W+jvRf8gBpwYGMPAJAZc92KABVA/XLJQxJMUdB/G
+xjokV44ezHci6EeDPZgoAf93ejrFplQHzlMcVOgHl1H0ClLx5G5z0UpUYv3
Yn4k9WllVpueKbuv6KuhiqujdTcmm7rR2oOOPnT14+gAjg/iBMesUlPUagpb
RO2UvNx/FQM3MdCLwUEMOjE4hsFJDE5hCBgEXS6gH2qKXe1i//00N0z1Y6Kf
g+7DaB9G+mTcvTLuHvT1iCMWv5vo1nkUM7wz9x0HSrT/ptiqHOX4bC/T/IDj
C2fxlbHKa5O1N12N3a6WHrT3obMfhwdwdBDHhxj2kww7JUB92jmNn/8qAYM3
mdFDgxhyYmgMw5MYnnLDMM1oQ1Q/xe0a5LhVC6YGMDnAYfdjrJ9hVjtZ1A/1
YbCXsUfjhWEWn9rBHZ96U8+LV/mmAo531pML3McPGy44sz4fz788Ufr1VOV1
V+1NNHSjuQdtfbNgHxviyIenkbtR5Kp7KHSuXYXhPgwPYtgJ5xick3C6KKNO
etVBj6TIVY+4hkCRizI1yJEPYHwAYwMYpeD74exnOhj4Phl8L5Q9cX6sP5kH
K/flw/oL4xmfTeZ8OVV4xVV6FZU3UHMT9d1o6kFLL8PY0Y/OgVkY6ehK/Uph
MpT8Mmmz/MdwjoxgZBz0ymeEIRwBQ8n8604Bqu5nyAYxMSgjG8DIAEfWj6F+
jox6ub8PfBz1mOkNdmku1uL/oUDzHdlXj6Wcm9JfdFk/c2V96cq7jKKvUXqN
Y7qFum409qC5F619aOtnsLoorEEcGcTRIYZMzaC5UWhSW9O/NOWRNTqB0Sn6
dZT2zRGKh2JyUfQPTQ1hksvEEMYHMTaI0UEZ1YCMqp+hoqDEMeN2jMkzePx9
F6y96Zm4J9LOQ38R5s+Q+QUcl5F/BUVXUXadgam+ycA09KCpFy19PA77ZTfN
wCOTtGAaw5gLYywixsBw0DGU1uRURti2EVbYOOESZRhTw5ikHqaoVPeNDUm4
RgbhHOS4BjA0wHH1o5+mp3+9Ay7lGzgelT31eMon0F2E4VMG0fYFsr5C7mUU
fI3iazLKW6jtRn0PGnuZ1yjQ1n4OdIAB7Rrk85/3TmMbB8PmxhYerjFQaCI6
Fwc6whZOTDkZKJV6gi48KKpRLiNDDJVKTXunyp3BGsDAAIP14zmoxNHwWQWq
h2SvfTv1PEd1iaHK4Kio7/KuoPCqBKziBqo4sLoeyYPNfVJEUmxc6YMzMY0z
34zTfMjATY0xRFMUkZrBupvCmhrBJBUnJpwYd2JsGKPUaxSRaoFziOebQZZq
RUjq/gHMzPLyZJf0tp0ZiOSnBSiiCwyR/lMJlPULZH6J7MvIvYL8rxmuEorr
BipuMlxiNxN9RqHJSsXfujNEE3BxUGr6oXKneCgucenGYC2gWCZGGBAqo04R
C/0fHmJZf4iNlgNcKBCeBab76Jy3tdwt++TRtIvQfQr9JRg/g/lzCQH1TA4F
8TUKrqLoGkquzwJB/SO7/jHZdtcEprj5blPUdrdJbvgk60+T1HKPiVFu+QjG
RpjlKvWIk/lgGMPDoJYz44eY5Wpa4Px0luXPS2sessXf0nKL0znn00bbvoRd
NPoK8mbbrbwieVy2eXICTCjfE+x/DOpx+j9G7XVnZnKhdqqdNJsNUZ4HWAbs
H2IlJ1Mx286fzRlZWC2QdgHMXDlETLPNzbqMnCuM5jlj8uNylI9PgIpKPc4i
YmwcY2OSqEdHqfcZt3REcXKhg+cQ43aQ9l/3gWFQU5m1Q/yNH9NPnKleVLT1
9J3aHplgeV3lNjoO9xEag07a4jDNFXcPjbCGBrmwdoZZI/Qa5MdSO3xucM7b
eZRzg0/I7TjH4WQ9mS7UdPRXuQ/TumcUQ6NsqaaNqQfpP617Ve79TvQNM6Gt
/VBqTXwK8ReSN+ZthXl7aByiqIdYtqBFJf0cZNmCLdxpEwNc+mlbtBmVW58T
vcNMpn8pwnuq+Da3OXzN0+LAOERxH2CoBkbRP8rUsxb62D+NrV7WUs8wpHO/
K2ES3y3wK4Xmb9+Jwb5x9LEA6aNx0cdSOr0apJ+9bOxiCzfaTA+X6Rb4vLT4
pqEZGpXP7T4pt8Curllv7qUtUOXqnlG49dCRnl54PyVpFN+29JJCg/IJ6Sdl
drrHIIp7N7O4e4TNZHQzY2858QRmPHWvelny7by6mHU3x3CTeZIt3G6NspWb
TJO4cGKGLcxS8c1Hv1VoUz7d/pSs/cYobjDtdOF+g2m8Ma3xW5JG8V13v1No
UP6WYFrjtVFcY0F3jWm7Nq3tQUmb+Day3yvOfvBO2q6O4CpTRBfyk4Xi++Fe
UZzxgGL9aVnDlRFQ4ftZ++K79V6VWL/jWdL6PdJZv+Bn/VFxtPKuyA+ko3nk
qf6k2Ku8q/B9CQ/3leo1xV7lTMR3JN0ct+rPkv3Ko56QjuJtq/5HsVc5iyPH
DD9O9bpir/LK+FuSvYQf/RfFXuWV5f2S7oX86L8q9iqvVe6Wjl7KjyYSOuVR
7tJRK/lRXjP2yvUMW13L97J22UXEBr6m+qf/BWvLEco=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7068021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->531535455],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->925604860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RevolutionPlot3D", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389502305],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{368, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->902168642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37999934],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->428507920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "t"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "t"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41892276],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81598352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6152905],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 " to remove points or split the resulting surface:"
}], "ExampleText",
 CellID->384456475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"t", "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"t", "\[Equal]", "1"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920579685],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyNfAdYG1e6tq4AZ9vdcv+t9267bf9bVsRpTt9kk002m6zc7RQ7bhlcEjuO
e+8FGxubYnrviCIQCIEECCF677333jua9/n/c45GGA9sNn7OjDWaw8z7ve/3
fafM6Mj3njxod2TvyUOf7f3tn4/v/ergoc9O/Pbdo8fJV1b/IJFI1GRz+LmE
fP5/5BPbLgCQWNnZ2YH9k6yjO8k5srcmX77Ijk6TPa0iJf9Ll749KRzZLLsC
2QtXOCb8zVP0yHrp+uTDC+z8UeGvvyv6a/PZw8Jf/+OKv36enT8knP8hPbJZ
Oi9c4zlW54Bwh//zNXU44To/EbEgFR2vZbX3CVf8ueislej4aVZ7t3Dtf/5G
tXcKtX8lOmstOrZltT8RkPxWdNZGdCxjtT8Urv1v36j2NuHa/yk6u0Z0/HtW
e7Nw7f8rOvuU6Ph/We2NwrX/5xvVlgvX/r3o7LdEx+xqkveF2k+Lzn5bdPzf
rPZ7ApJnv1Htd4RrPy86+x3R8X+x2m8L137p79RmnEneFK79yjeq/bpQ+3XR
2e+Kjn/Har8qIHlTdPZ7omOmteQl4dpvfaPa64RrvyM6+4+i4/9gtZ8Trv1n
0dnvi47/ndVeK9R+/xvVthWQyEVnfyA6Zv7PfIt+ueEb1f5v4dqbRWd/KDr+
V1b7d8K1t4rO/kh0zOKWMUOv/eE3qv2vwrVpbWtLXltW6zes1q+X1aL/i7PN
P4mOf83+6pfLkCxl7a9BZP6rX+Cx51pHVmGNogo2impSM6oaQs3vYmWeX+2K
v2JX/JlQm8aZTUQlrCIrISVX/ha58rej6JWjqxFdQ4tESndWUTWWOy21F19j
7S/ZXX4s4H6G/h9eQWpEVIDcjRSJlOxsyF0l1opKkLuai01UFaTk/mvI7Z8i
92XMkv/F/ii2yny/Hy27n8QqrALhrEikZGdNbm1N7kdvJ7Eit4piRSKld4yu
YneUxlTDJsZ8V2vyv01MLTlXC3GGEN/9X9jdfyBwSmPKOqwc1sJdpZF0M99Z
GkXvTm4ZzYqE3lliFVMFcucYSjvZSWOrYRVrRiEl/38rthZPESTibCxGwdo/
lkPolzRWrULLGRKr8HJSk8CJYIVwX0EUJ6gUVBMCK4oViRlddKUFnTUBtoag
kVgTGHaWf1JlDb6nrIUNwWVNcIlbt9VxfUdgh7Ya1gSXDWOIYIsoZwxZMyxR
FRYsFAahoxIEQyxliu6sCBglKxIp3VnFWXCxj2RXi/hakL1kDdlZx9VhjbIO
1rF19Fp1IGgZuL+D+BcM8VNY3s6FlCGUFYkV2UnD6LbcAsqwohzECoshxIQK
ECtiKLNkRy2wUpItrtrs1/EUMYGrYkViTXbfia9jqK0E1FICWtxHEqNlvSTW
x7B4HwVrQ1BaE5RW4RRyRBkISlIkFKmUAJVGlZthRrNCEBJ/iCUolSQbxBGu
beKrHmuuooyraiBNIH6ZQMEm1iKxTihrEii/qjqo6mkhH+thFV9PLKEHynoQ
a6gEZh2+qSXUg9cQS6wFS6TEEmqINJJsijJmgTSabDFki6V8KytA0Csp33GV
Zo4TqmGdWANrNcFslVQHNSsSKdnZqOthk1hPbCJoCWKpgFhKAEuszZBJWaUF
+BnDyXqMT/SZWYsXTJBR1CGlJP7IFka28FJSM6IUBH0kK2b8ZIsuE/BTNZTl
ICbEVZhvJrFKqERiFS0SKzXxmSTCvYZ4dTJlMbkeGlYkVmQn1TTAOqkBUjXZ
EsmW0EBsamAqWFlssoqtpyiJS63I1z99bJHN0rdmo1hf66ngUmaRNbFIKlgk
JQZJI8mmoNZFlSK6FDFltEhjqc8pyxBXzq5A1ZQmELNsEiuhrkRSFS0aGtUa
GsXJ1UiuoUUiTaG+pa2Fto4WHVFES1RKaSDfJjcguVEoUk0j1bMRalYk1GYr
YrOU2CyNb1hmM7k1ERGr9CSW2fw1IxLWdwgqxRrCgMQquAQhrJCEUAJpKNnC
Sggb5P8I8qVNZAkUJYhihdBBoor+VWwplKWIo8eUjm+pypBQjsRyqCuQVAEN
KZVIJrGXQqXWVkFbTYtEqiMRl0raoDSSBdKJRenEujTChVVaI1JZkUjpzlrX
CF0TLdomchXCTzLlh5CUxArxd/JdYiPzC8oRie4GxJFSTwtzNuIcYoZ+sipD
4uxJ+0s2QdTOoBIEsyKxZjtKVbFQpKFkCyNbONkiyBZZTJK0ohhRrEQXI6YY
scUsaiU/VpUgoRSJpJRBXYakMmjKkVyOlHJoK6CrRGoV0qqQXo30GuhJqUUG
KXUwEKYMxOcNlCVDIzJIaSL2k52VnnxYk96MNFZSm6FrpnxZpTRR72qCpglJ
rFC2SIZrRAIrgk9J4xrM8U78KpYVMV8/XpUv8THtP1oTvmyCqBsFFSOYFeJc
dEfZKkJoEcFMdtIw8mFNeBEiChFRhEhSCqEoJLmj0MzUL+KKEF8EVRESipFY
DHUxkkqgKUFyKVJKoS2Drhyp5UirQHol9FXIqIKhGpk1MNYgqxZZdcgmpR45
JFik2dQzshuRZS5NMBJqrIzNkGa2kMGjoQUZLdC3IL0FaS0CgxKplpxPaV7O
obpJ8DbCo42qEYQ9s7+xbED4kxL2xH261dkT9y5+ReMxkGSdQBJ3hEEbQqDE
JqgIwUulkNJIOAolH9aEFSC8ABGsRBZAUWDm7bexBVAWIK4A8QVIKEBiAdSF
SCqEpgjJRUgphrYEulKkliKtDOnl0JcjowKGSmRWwliFrCpkVyOnBnk1yK9F
QR0K6lHQgHxSGpFHbM8jHOQSVr6b24IcUlqR3YqsVhhbkdmK5VRKpIRMybdT
W6BrASGTcJncDE2zwGQiDWXKpJWZScYh4XIppwvMiEePrNVaEa3iEQftu64h
XFoHktgjNFoFEeaC6VZA2AspQGg+LWH5CCclz8zev0flIToPMXlQ5iEuD/F5
UOUhIRfqXGhykZIHbT5SC5BWAH0hDEXILIKxGFklyC5BTilyS5FXhvxyFFSg
sBJFVSiuRkktSutQVo+yBpQ1oqwJxTRyCwmHNoUtKDCXVuS3km/z2wi63Dbk
tCG7DVltjNNWSDPIye/qW5HeCoHPlhV80qsu8dm4xCdpsRpgju0V499/WpVL
cY+c9l9sBC6tA0n0BlJXDCxAECsk2PNpasxDCCuhApv/G56DyBwochCVg+gc
xOQgNgfKbMRlQWVEohFJWUjOgjYLqdlIy4E+F4ZcZOYhKw/ZecjNR34BCotQ
XIySUpSWoawc5RWoqERlFaqqUV2L6jpU16O6AdWNqG5CdQsqW1DegtJWFFM+
i9tgVdROTCjsQH478tqR247sdmS1w9iOzDZktEHfhjRCa6uF1hZKa9IyWhOa
WLpklJo9tIFFutgzV2dTPCNE22frAMJmAGEzgLAZQNi0DigAITQwnxZpYB75
JjAXQbkIJiWH9Rslz4VkIdSIMCPCjYgwItIIhRFRRkQbEJsBpR4qPRL1SMpA
sh5aPVL1SNNDn4GMDGRmwGhATibyslCQjaJclOShrAAVhagqQk0JaktRV4b6
CjRUorEKjdVorEVjHRob0NiIxmY0tKChFfVtqG1DdTsq2lFGSgdKOwjPpZ3E
/OJOFHWioBN5ncjtQHYH5djQTjlOZxzrWqFtpRwntzC/bYaa5FjquDaEYzPB
xHOp0/4tjn+0KsfikSwboQscWxGOrSwcB+QLRRpAOLYKyEVADgKzhZ7puiAj
gjIRbECIAaEGhBkQbkCkHop0RKUiRgelDvE6JGih1kKTgpQU6JKRloz0FGSk
IFOLrFTkpCEvHQUZKDKgxIiyLFTkoCoXNfmoL0BjEZqL0VqC9jJ0lKO9Au1V
aK9Bey3a69HegLYmtDWjrRVt7WjtQHMHGjtQ14maTlR1QVrRRVyovBulXSju
QmEXI7uTkd1Byda3U7JT2wSyU8xktwhkm72Z+nE8zRSEaSUrktW4/uGqXItn
Ymg+lgbQNp+Q7c+KxMqfcO5Psq0/TQ/++fDPo0Ui9c8lqdo/5/EILCATAQYE
ZJBzgXpINgbpEaxHaBrCdAjXIiIZkUmISkKMGnFqqBKRmIikBCQnQKtCqgrp
8XyGis9M5LPVfG4Sn6/hC1P4Yi1fquPLU/nKdL5az9dm8PUGvtHIN2fxbdl8
Ry7flc/3FPG9pXxvBd9bhZ4a9NShpx49jehpRncLutvQ3YHuTnR0oa0bLd1o
6kZDN+p7UNuD6h5U9KC0G8XdKCAKdCGnC1mdyCQKdIgVWJV+6uXM0amfL2/t
xJ68ugZUKZoTzOMdQr5/CeNdSnZSwr2Eku9HCqFfSndWfvnwy6OFHOea87ON
rxF+mfAzwE8Pv3T616mQ/DVQh6AUBCcjOAkhaoSoEBqH8DhEKhGlREwslLGI
j0FCDNTRvCaC14bzaeF8RgRvjORzFHx+NF8Uw5fE8mVKviKer1LxNQl8XSLf
kMQ3afjWFL5dx3el8z0ZfJ+RH8jmB/P5oSLTcKlpqIIfquaH6vjBBgw2YbAF
g60YbMdAJwa60NeNnh509aKjF219aOlDYx/q+lDZi3IiRQ+KiBTdyOt+LEUG
kyKN6ND2hA6JJOckNJlHhIIOjUIMNKyIgR+syr+4HaXHUqKB1OL8fqwQrmlL
SQTwJYU0klJfIsAa39zH/u+TBZ9MSH0MkGzx0cMnDb6p8NXCNxm+SfBTwz8B
/ioEKBEQjUAFghUIjUR4JCIjEBWBmHBeGczHBZhUvia1rynFx5TqY9L7mjL9
TNkBprxAU2GQqSTYVB5qqgoz1Yab6iNMTVGmlhhTe5ypU2XqUZv6NKYBrWk4
1TSqN41mmsZyTOP5poki00SpaaLSNF7Dj9fz4038WAvG2jDWgbFOjHZjpAdD
vRjoQ28/ugbQ3o+WfjT2o6oPFb0o60UJUaQH+T3I7UZ2F4ydLDI6kNZO5Ugh
crQyOVqoHJJvrgdjfsVoVjxiofO4VjQWiAhMAxvfQqYBk8EnT8j3nHc2vLPg
bYSXAV4Z8NLDOx3eqfDWwSsFnmp4qeAVB28lvKPhHQnvMPiGwD8YgcEIDkJo
EB/mx0d4myLdTVGuizHOi/HOi4nOi8nOizrnxXTnRYPrYtajhVy3uQL32SLP
mVKv6QrvqRrfyfqAyebgqdawqY6Iqa6o6d6Y6YG4mSHVzKh6Zjx5bjJ1fkq/
OG1cnMlZnMlfnC1anC1bnK00zdaYZupNM038TCs/3cFPd2G6B1N9mOjDWD+G
BtA3iK5BtA+ieRDV/ajsQ3kfSntR3IvCXuT1IKcbxi4YOldRQs2USGimrqlq
glkIJROCyBBTD3HeX10J8dwXm7+nUWHjVyxEBdGDqEFioYD4fb65b2PnnQOv
bHhlwcsIz0x4ZsBDD890eKbCQwePFHho4KaCmxLuMXCPhHso3IPg7g8PP3j5
wscXfl68v5sp0MUU9GAx5N5iqP1CpP1CtP2C0n5BZT+ntp9Otp/U2Y+n3xkz
OIxm3RvJvT+c7zhU9HCwzHmgyrW/zr2v0au/1be/I6C/K3igN3RgIGJwSDE4
GjM4Hjc8kTg6pRmb1k3Mpk/NZ84s5MyZ8hf44gVT2aKpctFUs7hYb1psMi22
mhY7+IVufqGPn+3H5ABGBzE4hN4hdA2jbQh1A6jsR3k/SvtQ3PeEKhmdSDer
0o6UtlVUiV9S5W/Exj+uqoh4Toz2R6386CwF0cK3iGphDg4fYQz5uXcuvHLg
mQ3PLHga4WGAux7u6XBPhZsOblq4JeNREpyVcImGiwIuoXAJhLMPnD3h6gG3
R7y7k8nD0eR1d9H79qLv9QW/KwuBl+ZDLs2GX5pSXJqIvjSqvDSsujSgvtiX
fKlHd7k7/UqX4Vpn1vWO3JvthbfbSu+0Vjq01Dg2Nzi1NLu2tLu3dnm19vq2
9ge0DQW1jYa2j0d0TER3TSl7phN6Z5P657SDC+nDpsxR5IyhcAqls3zlAl+z
wNcvmJoWTa2Lix2Li92mhX7T/CCmBzExhJFhDAyjZwQdI2gYQtUAKgZQ1o+S
fhT1Ia8X2RZR9J1I66CiaJkoSa1PiiKKk5WqfG9VVcRzr08JqkiJIlJf8yyI
1Jskqv1eFjU8iBSZcGdquKXBVQdXLVyT4aqBSyIexuCBAg/C8CAQD3zh6AFH
V9y/b3K8a3p4a9Hp+oLz5QXXC/OPzs67n5rxPDHhc3wk4PhQyIn+8BO9kSe6
ok90KI+3qY43q483Jp9s0J2qTz9dl3m2NudCTcGl6uIrVeXXKqtvVNTZVzY5
VLY6VnU6VfU8qur3qB7yqh71rRkLqJ0IqZ8Kb5yOap5VtswntC1oOky6Luh7
kNWP/CEUj6F8EtWzfP083zRvap03dS4s9iwsDiwuDGF2GJMjGBvB8Cj6R9E9
iuZhVA+ichDlAygdoJrk9yKnB8ZuZHQ9oYmmlbYiRJOlKJHGNZpHvbGsrJhB
WF2RH4uO6fsKUkERFhdfehfAOx9eebR45sIzBx7ZcDfCPRNuBrjp4ZoGFy2c
k+GsgVMSHibgfhTuheNeEBz8cNcLdx/hjhNu3lq8dWXh9oX5O2fm756cczg2
d//LKccvRh8eGnQ90OtxoNP7QLv/gdagg01hBxsiD9ZGH6xWHqxQHSxTHypN
+aIk9UhxxtGirGOFeScKik7nl53NqzqfV3spr+FaXsvN/Hb7/G6H/L4HBYPO
BSOPCsc8iiZ8SqYCyqZDKmYjKuejqxfjak2J9XS2Oa2FdpNIA11I8hGJgTHU
TaJplm+bM3XOmXrnFwcWFof5uRFMj2J8DCNjGBxH9xhaR1A3jKpBVAwybYi+
fU9ok9oBbTuS21YES5MQLDR7SaxIsPyNXu93V1VI/JYNm0P7FpHocW+qkGYx
s05SopLkENHJw6KTWyYeGfBID5c0OGvxUIMHSXiQCMd4OChgH4zb/rjljZvu
uOmC6478pSsLl87NXz4xd+XI7NXPZ64fmLhpN3xrX7/97m6HXW0Pdja57Khz
21HjtbPKd2d54M7SkE+LIj4tiP40V7krO2FPluazLJ2dUX/QmPl5Zs6RzIKj
hpLjhorTmdVnDfUXDE2XDW3XDJ03M3vtMwccMkceGMecjRNuWVOe2TO+ubOB
efOhBYuRRXxMCVRl9KFCai0MDchuofMYJd2o6EPNMJom+PZZvmvW1DdnGlxY
HDHNj2FmHJPjGJ3A4AR6xtA2ioYRVA2hYgilgxa1epHZDX0X0jqF9kbDUlsi
CyNVszB7xOKoUUhsK97MYKqZO8fmLyXiN5uogix2TpEg8iGlkBYhjvLhyeKI
6OOeDTcjHmXC1QAXPZzT4KSFowb31bifAAcl7CNwMxjXfHDVA1dcceUhLt3l
z15cOH189szh2TP7Z87tHTu/a/Dijt5LH3dc2d5yfWvDrS01dzdVOG4scdpY
+GhjvsemHJ9NWQFbjCHbDBHbM2I+McTv1Ks/TUvZk5a2LzWDS806oMv7XFd8
NK38eHrVCV3tKW3jWW3LRV3HFV33dV3/7bThexljjukTTmlTrukzHvpZn4x5
f8NicCYfbqQzXHH5UBfRmWl9JZ2EzmtAUTPKO1BDhiqk7Z/ku2f4vhnT0Pzi
6OLiBGYnMDWJ8Umm0jjax9A4iuphQSUSkbl9MPbQgEpfEVBmiVRsJGkOKMnf
i6iVWrGnwWvMB+boIR98hRaIqCQlMklOiFXKYiplwDkdTql4qMV9DRwS4aDC
nVjcisD1IFzywoVHOO+E8/dx9jZ/4uz8l1/MHN0//dWeyWM7ho9v7zm5ue3U
hqYz8rpz71de+kvptfcKb76be+cd4/13DU7vZTz6i97zgzRfeWrQel3YJm30
9tS4j3QJHydrPknS7kxK363O3KvO3a8p+iKl7Ki28itNzTF1/YnE5tOJbecS
uy4n9d1IGbqTOuqgHb+nmXyQPO2SMuuunffSLfql8sF6hKVDkYHYTCRkIzkP
aUUwlCKnEoV1KGuhcyxkWNk2gu5Jvn/aNDRnGl1YnODnpzA9hfEpDE2iZwLt
42gaRdUIykmzNoD8fmT3wsDCKbUT2g4kt0PTBvWT4RTXRIWK/ZvR9O1Vo2np
HZzTRBofSxB5F8KrgEUQk8cj16KNkUaQsx4P0/BAi3sa3E2EfTxuReN6OK4E
4YIXTrvglCNO3sXx66Yjp+YPHpg5sHvq4Cdjn2/r/2Jj5+EPmo68W3P07fJj
fyw++Ub+2T9kX3zdcPUN/a230hzeSnN8K8Xl7WT3dzTef1b7v5cYuj5JsSU5
dptGtS1RvT0++UNl6sexhl3xOZ8lFBxUlx5OqjiSWP1lfN1RZeOxmNbTcZ0X
VL1X1YO3kkfsk8bvJEw6xE87qmadE+bd1IveyXygjg/WIkwLhQ6xaXQ2U2OA
LgsZeXR+vbCSTqJXt6ChC2396B7hB6b54VnT2IJp0rQwjdkZjE8LCrWOo3YU
FcMoGUTBAHL6kNkDfTfLdh1IYfII2a6FyhNvnhOjgWRllmepPy2eF39CoZ8s
U4iNY+jrsL7LVPIWqZQDt2w8yoJrJpwz8DAdjjrcT8FdNW7H40Y0robjUhDO
eeOEM75ywNHbOHLZdPDY/Gfc9J6PJvZuGdq3vvuz91vt3qnb/2bFgVcLD72Y
c/iFzK/W6U++lHb2Fe2l15JvvJFy582U+2+oH/5B5fpGnMebSt934oLfV0Vs
SIzZlBC3OS5hc6xmS5RuuyJjR0zWHmW+XXzxQVX553FVX8TUHo5q+DKy5UR0
x9nYnkvxA9cTh2+qxm4pJ27HTN+JmnWMnXeJX/BM5P2S+YAkPigRoWooNIhN
gUoHTRp0emQYkZ2PwhKUVaKmHo0taO9G7zA/NMmPzPDj86apxcVZqtXYNPqn
0D6BhnEqFOl/FA4itx9ZJJR6kL4slJIsoUSFakYc0+pxqySei1mp0j8JKpmf
ayzFkURKBJKcJoHkySTyyIN7rkUfI1wMcNLDMQ33tbirgX0CbipxJQIXgnDG
G8eccfguPr+BgxdMnx2Z27Vnese28R0b+3a+3/HpO4273qze/WrJnhfy9q41
cE+nHVyrO/xs8rHnk06tSzz/csK119W3X1c7vKZyfDXW+ZUot9cUPn+MDnw3
NvyDuKj1SuX6GNUGhXpjuHZLePqHkcadUXl7Y4rsYkv3R1cciKw+GF5/OLz5
q4j2U4ru8zH9V+KGrsWOXo8avxE5dTti1kEx5xSz4BbHeyfyvireX4nAWDp/
F6mCUo3EFDppnaqDIR05RhTmo7wENVVoakRnJ/oG+eEJfmyan5w1TS8szGFy
BkPT6JpC8wQqRlA6jKJB5A8gm4RTLwunLipRyrJst6pE4jcjn1qh0A8Ehdhs
AZXmnHeRJckVLNMmB4+ymTaZcMrAg3Tc18EhBfZq3IrH9VhcCMUZPxxzxed3
YXcN+86Ydn0xt2P39Edbxz/Z0PfRey0fvV378evln7xUsOO5rJ22abtstXtt
U+xs1YeeVh15Rnn8uZizLyovvxp/85X4Oy/H3ntJ8fCl8Ecvh3m9HhHwliL0
vWjF+9ExH0TGfRCWKA9J2RiStjUk8+Pw3F2RhfsUJZ9FlHOh1ftD6g6FNB0J
aTse1nUmsu9i9OClyJEr4WNXQ6duhs7cCZtzjFxwieY94nivGN4niveNpLN6
YbGIVkGlhloNjRqpyTDokJOOIiPK81FXjpZ6dLVjYIAfHecnpvjp2cXZxelZ
jMygd5r0LVA9xuQZQsEgcvph7ENGD5On83FjlLBMHiVTSIgg8ezZGkGfJ0dM
9PD7j/Uh4hRaxMmHex7ccvEoB65ZcDHCyYCHetxPg4MWdzS4lYAbcbgagzOB
OOGNww9gdwO7Ty3u+Hzuo11T27aMb5f3ffR+y7a3qre8Wrx1Xc62tRkf2uo+
ttXssE3cbZv0mW38ftuYz20jj66NOP284uJL0ddfjLn9ouLuujDHF0Jc1gV7
vBLs90ZYyJ8iIv4cEf3nUOV7QQkfBCWvD0zdFGjYFpy9I7Rgd1jxnpCyvYFV
XGDdgcDGLwJbjwZ1ngztPRcxcD50+GLw2OWgyWtBM7eC5xxCFx5G8m5RvHsk
7xkOr1D4hSFEgchYKIlE8UiIRXI80hKRqUGuFsUZqMxFQynaatHThqE+fnyM
n5oyzcxNz2F0FgMz6JhG3ThKRwR9cgdW6NO+ij6x7HHYN9PH8hYim327SAQS
wqdwWfjkCeHjkgXnTDzMgGM67ulwJwW31bihwjUlLipwwg9fPsKBu9h7FTuP
zG37dGrzprHN7/dv/XPrtrerN79atOG5zI22qZttk7faJm63jfvYNu5TW9Ve
21jONvKgLPSIbcjJZ8POr4u49kLkzefD7jwXfP+5QOfnA9xfDPB5NTDozZDw
t0MUfwqMfddf9Rd/zV/9dRv89Zv9sz4MDCtD4U7/0t1+lfv8au38Gg76txz2
7zgW2HM6pP9M4NA5/9GL/hNXAqZvBMzZBy04hvIu4bxrKO8WDI8g+AQjMAzh
CvZ0IhrxCiQqkBKD9HhkJSEvGSXpqM5BYwl90NbbgpEBfnKcn5kSFJpF1wya
JqlCxcMoGFqhUAdVKHE1hWLYewvRDSvembFZoZHlvUs28/Pmco08C2gILaU4
12wWQpl4kIH76birxW0NbibiWjyuxOJsGI564+BDfHYbuy7hY7vpzVvH1783
sPGdti1v1Wx5rWjjC5lyWYpcpt5gG7/JNmaLbeSHtlE7bGN32Sr22YbtlwV+
IQs8tjbo7HMhV54Nu/5M0O21fvfW+jk94+f2vK/3i74PjXAm7V8OjWfiMwQY
cSGCk/RqAkvoa8exdXSui/WVXiE8xDFCVKQnRRoAkmfaMXXNd/am36JDIP8w
mHcKhIs/3PzhFQD/IISEQaFAdARiwxAXgqRIpMYiMwHZKhQkoSwVtVloLkJn
DQY7+IkRfnp8Zm5xbI5q1D2DlmlUjAka5TCN9D1I7RY0SlrSqOVJjRoFjcRz
09YrNLIWNGLv0L26UqPHaS4bzkwjxwzcS8cdLW5pcD0BV+JwKQYng/G5G+zu
Y88N7DyP7TsnNvx1RP52x4Y3ajYTgdYZ5bZEoAS5LF4ui14vC99oG7rVNvwj
28idtmF7ZEGczP9zmd9Rme/ptf6Xng66aut309bnShJuaGFPUiqJXBK/JIqJ
nxAkBBLxHIKNPuvzoM+5PYoRWovIekQRnaKJTi/HECKaoSSkEHYIRyTfEL46
kdINXS94Rx84+cDVBx6+8PFDUBDCwxAZgqhAxAYiIRRaBTKUyIxBbhyKElGh
RX0m2krQ24DRHn5qZHZ2loo0h+5ZKlLNBIpHUDCMnEFkLhNJYxapjfpKfAt1
neUiRZvfAfobKj1+I1XQiI5fpUQfya+oPCsUcmEKPTQrlCYodFWFS0pciMZX
ATjggn138elVfHzKtHXrmPydAfkbjetfKd74onH900QelUQql8VKPpbLIuSy
4PWygM22QdttQz+xDfpU5rdP5nNQ5v2lzPukrfduXxwKwwnS+1DjSjJupMJe
DwcD7hvxIBtOOXDOhUseXPPxqABuRXAvhlcZ/CoRVIPQOoTXI7IBikZENSGm
GbEtUBJ22qAiTHUiqRvJPdD1IZ1QOQy4ecHLG/7+CA1EmD8ifBHth/hAaMKQ
FgV9BIyRyItFSQKqU9CUja4K+iR1cnBuZnJsXlCoeRq1k8sU6oe+928qROWx
KCSRRjesfDoqfoeSSfUr1hIReVaK48rEcWLi3M+AQxrstbipwWUVLsTiXBSO
+IJzwm577LiM7UfmN/11WP5mp/zVKvkL2evXUmVI1MhlkXKZQi4Llcv85TLf
jbZ+W20DPpL575B57ZV5kpvL905svIat7tgXhMNROBmPCxpc0eJGOm5n4G4m
7mXBMQcPc+GUB5d8uBbiEdGmBJ5l8KmAfxUCaxBcyxRqQEQjFE2IakZ0C2Jb
EdeO+A4kdCGpB8l90A0gfQgZQ9C0dlIegnwR7I0wLyi8ofSFOgi6MKSGQB+E
7HAURqNchfo0tOWjrwajHfPTY+NzC4NEmzk0z6BmEmVjYm1SmDZqpg3Nb0va
MGFIMxTNxqxCH40qsLIFYr+6+d2SJh4FNG2Q5PFomSYPiCZ63GWa3GCanIvB
aQW+8MG+h/j0Jj66gC12s+vfHpC/1iRfVyx/Jt0iSJhcFiKXhctlgXKZt1zm
JZd5brL12SbzZhH8O/mWzg03sc0L+0JwmOTIBJxPxmUdrhNBDLhrxL1sKsiD
PDjlw6UQrkVwK4FHKbzK4VMJvyoE1CCoFiH1CG1AeCMimqBoRlQrYtqg7EB8
F1TdSOyFph/qHj6qrtl8X4R4IMID0V5I8EdyELT+SPWFIRC5YSiJRnUimg3o
KuaHm+anhidmZwfn0TWHJqZDKdFhBNmDMPQjjYRhF5I7VwRI8+MAISLQnLvK
iHRpHmdFtCwfBzGF/sPrbyjkbFHoHlPothbXNbikwplonAjHIR/seYhPrmHb
WWz8dEr+hy75y9Xy53PkTyeRPMbkIZESQHIZiRe5zEMuc5fL3NiY+N/kJ+c3
eWJXMA5G41gCziXjkg7X0nHTAHsjHLJxPxcP8uFUAOciuBbDrRQeZfCqoML4
VsO/BoG1CKpHSANCGxHejIgWKNoQ1Y7oTsR2Ia4HEc1T7F7/CoUb4ryh9oXG
G1ovpPvAGICCMFTEoj4Z7dmmwdr5qYGJ2cnBed6sRNUkfXyUNwzjAPR9SO1B
SteycGgVh4M5T9lEWd6qMRPM+s2UfvG7okyvFU8b2G+vfrWKFnmWaMliWmTg
ThpuaXEtCRdVOE3allAc8MHuh/jwCjafxvpt4/LXO+UvlsifJaESJ5dFEQlo
2+ItsZbL/FigPJLLXNkM7W/kG2o3OPIfBeKzSByJxykNzutwRY8bmbiVhTs5
cMiFYz4eFMKpCC4leFQK93J4VsCrCj7V8K2Bfx0C6hHYgOAmhDQjtAXhbQhv
R0gLb36u8mvEukPliUR3JHsg1RMZ3sgNQEkEauL4Vv1if+X8ZN/EzPjg/ELH
HOqmUTZBuc8ZYlHQC203i4IOJLYjoe2JKJBS8q3MUbDUdlstzTGzj+KZaTP7
4thg7P+WsG+mnhS3fEZ9Lu30mKm/T9IGSR4khRB/TcCZGBwNg503Pn2IbVew
4QTkW8bkr3XIX8iVr9VYWosAs9+T5ET2bO7oZ/Iz05s8+R1hOKjEV2qc0uJC
Oq5k4LoRt7JhnwuHfNwvxIMiOJXApRSu5XCrgHsVPKvhVQPvWvjQt8x9advo
2wifBh6W9yP+GSpXJD2Czg16Dxi9UBiEyihTs3aht2R+omtiesSc86umUDSG
7CEYB6mH68we3kk9PIF5OOm4EYqlsfSdfppoGinFpFh6rOJZMDOr9CwdFzI2
f2NmU5RXXFheeWCknUoHPe1g3kjBFTXOxeFEFA4GYNcjbL0K+eFF+eZR+avt
8hdy5LZKluoJlT7Md12I+5rfM/jRZlf+ozDsi8WhBHyVjDNpuGjA1SzcyMGt
PNwpgEMh7hXDsQQPy+BUDif6Gy1n+ps45yo4V+OopsF8pd9C7YwUF6Q9gsEd
eX4oj1hsVM93F8yNtQ1Oj7XOop55ppkzw4DgmZouwTNVxDMttBHWzJyZPdOc
F9gTdhFr4ifFZhbFv1z/Z0tmEKgssKSFXDjn0J65ozktkPypw1UNLqhwKgbH
IrHHE9vvYP1pyDeNyF9pI/0Zlg38WHtJ/NFZLnto/hXW97cGmfYocUCNo1qc
TMfpDJzNxHkjLmbjci6u5uF6Aa4V4EKOidX/BTRO0DkjwxW53igLXaiPn+vM
GRvvbplBwzR1r8IxZA4ig/RU+mmfP7mb9v8TO1gEL+eJvkVOmJJGUW9W1Fta
JvHvFcRvA5mZEmdW9ozpFwJThYyp/MdMOZEGnzT7JIr1uJWKaym4qMYZJY5H
4zM/fOyEjZch3zMlf6VT/oKRdcO9ad50k1jJZQ+EO7xmvk3KA6Q7IdudL/af
r42e7szpH++tn6INR+kkjEOC3al9SOlBUhezu512sqndLXRsFGNxEcmS5cId
xOqvbvlq78xLrKjlRdRyiZQOz376KJ+O11xyqekPsnA/E3czcDsN17W4lISz
KpyMxVcK7HDHltvYcA7yv/TJnzOyThVxDyfiIeyX+D9BqiOMrny+13xVxEhv
adPEVOUkSiaQPwY9iYR+OmBYslRltrT1saVPKiwgFluwep4Wv83O7PyF55MK
m22ksZBNR0FkLGRPYiGVjo7OJ+J0HI7H4FAotj3ApmtYfxLydeWsf0KysqPk
j2YLtQ4wOPE5rrOVYb0DdRUTKBmn5hmGBPOSV5hHRk4xzLxoamEUbYkUZGBV
T8sK1cTW/QOzzjKP9vMlvy2yWFUAs3hkMEeGdIJ4BtxOx3UdLmtwNgEnlDga
hR2e2HIXGy+CDlpomnSVyxwkbE2EHyHD0ZT1oL8+sWFkoHgceWMwjiC1H1qL
PQnMnrg2OgY020O0ou9GRrGEb7aHjOxXf3q4wh5xPqPzGlJik+QnK616mAPH
LNzLxJ0M3ErHNR0uaXBahWOxOKLAdjdsvon1Z8B6MU5sjQqSqtLvzWfeb29K
I41X7igyR+gwlRij6YGaGNOJ+CeNIabQlktki7jtWt0WscVLtvx4yRbqdxZb
qN8xW26m46qWDv7IEPDLaOwNxFZXbLoCud0Mcbc/0Uv9YDbzXungcM4IDMNI
G0RKP7UgcZkFscssYL4lJfCtCHjxCFgcRWbsYgvZ/NJPqHORIWchk8GC3inX
EjWZsM/AjTQ6aD2fhONxdBj7qT82P8SG85DL7CUM+/enDQ5Zw3T8qR2AppcM
fei4lIxOyRhVyYDHtCCaAbfgllhFNlDiKffi2RZxBjfjF1vJ8P/4Cfz5j/E/
yMY9Ix1i32b4L2txLgnH4nAwEp/4YtN9Av4mzWN0lCr57kTGHYI8qQ+JBHk3
4juhfBI54ZtgV9Df3BHwS9Aj6le+27g6+h8KUf2zJdSFj1FTh8mjDkNRZ1lQ
pzPUGhyPxxfR2BlAIN+oPMjR1mZpJPc9uYwb09vHd0PVxWB3ILYNMRbYUc0Q
cFO6JVZmyBF1q79pthK12LafrIo+n6KnnBOPz4KDEfYG3NTjaioupOBUIr5U
UrZrv+Qq9nIvCpyzPiMBL1V2kpsT2DFknNaG6FZEtVDYUgXtZRLgkYzuCOLp
lGyriDoIWMQWiHsHZgvE7zhSC6TEYyT/57HP51t8nuDPpvjvkIFOBh17XtTi
jAbHVGg4wzV/xeVu4K7JOMmzeDyGs6Y2RLcTrAR9FEOvMKOXRhJPF3BLw+sg
fi+J4v0HckhxmrGKLWJs//Sxhxda0DLCH+bSqQrqLkY6eXFDj8upOJeCtltc
+1mu9TBXuImLe5E7LuNkePzseQ3BS3htg6IVkS2IJFgjaW4nYCMaKc200JFE
eD2sCOpf/F3UP1nm2ZRZKcEp+RFBSmHm05mtB7mU17tZsM/EzQxcTUfHfa7r
Etdzjmvdz1V/zGnf5JwJrP8SfIO2gE9RnGsimukMi1Aa6YSLNJwwKmD7pQib
9QpsP/s6RossjDKoTkuMZjNGM3EjAz3XuaHrXNeXXOchrmUXl/UuF/MMdYF/
x+O1vRjSb4U1IayRFoKRQAwjpZ5Oq0rJf9Zhdfi1CInVCqxi/2BYf+ZZvAxr
oYD1Ma1muFnos+eGb3N9p7neo1zP51zbbq70r1zqaxTuMQLv18vwfod6bCjN
BgRkaD3FKaEobcLo2gdhtZb4+tXfRSz2DZaRf+axEnEBQ5yPh3lwzKWIR+9y
w1e4gZPc0Amu73Oucw/XtI0repdLfZmLfpb7iiD+ueALFPH3mM/SOTdLsQmt
g1VoLcSrgUlXYBSvXMYwPkVZXQFTIiVAJT8y4xx35CYIp+e40bPc2Gmu/xDX
+SnX/jHXuIkrfIvTvcLFPMcFP81dknFfEnCW1XEo2h9QtFbB9Qipo0VixXYE
MMFLikRKdv/JQmn50wTaDJl7t/+CZf0/C9JihpSBdS0UkP6YkDp1jxu7zE1c
5qYuciNfcT2fcb37uK6dXOs2rkHOFbzF6V/n1C9xiue5gLWcg4y7KOOOyLjd
Mu7byxBbMcQbZJycFdaoEAvq6NRzMF3vJaQW/7UqYjPHYk/5OcsExcSF3IsZ
6CLGcCF1hMkb3PQNbuYKN3GGGzzEDRzgBvdzvbu5jo+4lo1c/V+48j9xOW9y
qa9yqhe58Gc5P1vOXcY5ySjTh2XcLhnHIl3IEhS0ZM16GbdRxm2RcR/KuI/Z
B2vy1XeYFUG1FiukZCcNoVsN/vtrrBFHKvPy/xDp8IiZNHeHmyPGXOZGv+JG
DnOjpHzO9e/lOj7kmjdyTXKu7j2u8i2u+DUu8yUu+Tku/hlO8TQXJON8ZJyb
jHso4+7KuJsy7ioz75yMO8XcSXqIWnVQxu2XcZyM2yfj9si4T8n3O+j3u9g3
n7FvPpJxm8n3hAUpsfjbNLKDamATXAOZhaYl88zW/UZknTk+PEsE68gYsZhk
cNI+/sf8dW7qDDd+nJs4xk0c5YYPcL0kArZx7Vu51s1c41+5mne5ije54le4
/HVc1vNc6rOcei0Xa8uFy7hAGecr4zxl3COm3X0ZZy/jbsi4yzLuAjP0tIw7
IaOB/iWTVXqEWnaAmUWc8xMZt41pSq36FtMxsIY+qgqi65iQnZRYuHaZJY/V
E68myFYFI+ZJPUogsSXGzV3mps9w06e5qRPcxJfc4Gdc9ydc18dc10dcx3bq
g0Sz8je5kte4ole5vJe4rHWc/nlO9wyneZpLkHFKGaeQcWEWEz1knCsz0ZFp
eUtGWwezlieZfcS4g8ysXcw9tzCziFW01ZAGVsMqqBrPCxFvtuBfhSOqFBVG
8nsCff4CN0sgH+dGD3F9u7m+XVzvLqoHgdy0nqt+h6v4I1f+R670Da7wdS7n
Vepvqc9xmrWcWsbFy7gYGRcp40IZai8LauJ+95gw15kqZxjkYwzyAeZyHzMZ
CGTiXzYEr1UgXVEmaGldtBeewP3vIuaZEv/rVQrPUsye4ia/4obtuEGOMt6/
h+vZybVt5eo/4Krf5are5SqJBX/iit6k2PXrON1zdimEcdvHjIfIOD8Z582c
ioSOM8N+i3nUeQv2ozLuEAuOHYzrbQy4hPUyA6vw2rK2wbxunXilFcn/mI/H
v6A0jx7khjgKlThH8yau/q9c3Qd2te9z1e9xZW9z+X/gjC9z6eu41OftiHOk
PM0lMprNzu8ns/Ox+P8DxjFzC7vzMrszjOMvWGR/auF4A/OJPwg52YzwP1fj
UzwX8m8jByihxCXat1OUjRvtGjbY1X5gV/meXfEfuRySeV7mMl7an/6Cne5Z
O42tXbyFzUDZfn+K0s5dZkf814HF5xWZ3UWZ3VmZ3XHWTuxn0UjYfB2Pe+3m
FQL/5sqdv+wmym4nDZBd0xa7+g121R/sL3vXruBNLvs1zvjq/syX9qe9sD/l
mf2JtgJdobL9QbL9frL9nrL9rrL9JJBuU5e0I1jOyexOyuy+lLGVIpfenjSv
ULnsvuL2h82r/FPt+v2V7+8vIVK9weW+cSDr1QP6lw7onj+gWXsg3paSECHb
Hyo7ECA74C074CY78FC2/65ZA2qp+dcf/71KNll+vF2obf6FrnhFUHHfYwuW
rXpoXh9U3M4sO94o2GxeEev3AufiWn8VrmleCc5WdPanouP3hNrmtQ/Fq4yK
f9vyJ6G2eRXJtaKz4tHKHwW85lU7nxGdFY/DLB5lXpv0WSxb53ZZrZeFWuZV
XcUrl4rfd3pBqM3ubV6F92veE7CM4syr9a4TnRXPltgK12broUpeFPCKa/2P
UIvNCDP0Xzdr+zuhNptPlfy9tVMtYw4248JWRf26+arfCNdma5WaZ6i/Zobo
X4TaH7DarwvWiWv9TKjFVh2VvCE6Kx5/W1ao3MJqi1dvFa9F9EPh2ttZ7T+K
zq629gCt/QmrLV7rdbVn37T2LlbbsrKtuJaNgHcfq/XOsrO0d2ElXIM9iJC8
S/a0+3iIHUn+4f8D0F/EQQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37658354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->612530555],

Cell["Plot multiple surfaces:", "ExampleText",
 CellID->1921453855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "t"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"t", "^", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15857399],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222710706]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->832128040],

Cell["Provide explicit styling to different surfaces:", "ExampleText",
 CellID->12356458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"t", "^", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", 
        RowBox[{"t", "^", "2"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"Specularity", "[", 
         RowBox[{"White", ",", "20"}], "]"}]}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Cyan", ",", 
        RowBox[{"Specularity", "[", 
         RowBox[{"White", ",", "20"}], "]"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37527117],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28115884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691855548],

Cell["Add labels:", "ExampleText",
 CellID->106214885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"t", "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"t", "^", "2"}]}]}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73436451],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->834191257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70180948],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for a surface:"
}], "ExampleText",
 CellID->703033904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "t"}], "}"}], ",", "\"\<cone\>\""}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->228985387],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XXd8Ttnztjqrs/rqva+12mZNEL3XxSoR3eq9rbZh9b7sF6u31ZYghMhE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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[
       TagBox[
        TooltipBox[{Polygon3DBox[CompressedData["
1:eJxFnHf8V+P7x9/nPvOjRUJpk4yvVQghSUJRWdmjlMwQGmgoDVSSPb62r1VW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           "]], Polygon3DBox[CompressedData["
1:eJwtnAf8VvMfxe/33u+998kmo0mhQTLLHg3ZDSVKpImEBkKEUNl7JKskm6Jh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           "]], Polygon3DBox[CompressedData["
1:eJwt13e4VcUVxuED59zLESQxKEmkKEivihQpEbgBQenSIXLp3QhGICGChSIl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           "]]},
         "\"cone\""],
        Annotation[#, "cone", "Tooltip"]& ]]}, {}, {}, {}}, {
     Line3DBox[{699, 1, 695, 242, 1433, 16, 270, 1444, 31, 286, 1455, 46, 302,
       61, 1731, 317, 76, 1752, 334, 91, 1767, 350, 106, 366, 1518, 121, 382, 
      1529, 136, 398, 1540, 151, 414, 166, 1823, 429, 181, 1844, 446, 196, 
      1858, 462, 701, 211, 696, 461, 837, 212, 838, 213, 839, 214, 840, 215, 
      841, 216, 842, 217, 843, 218, 1402, 694, 844, 219, 845, 220, 846, 221, 
      847, 222, 848, 223, 849, 224, 1255, 464, 702, 225, 697, 463, 1602, 210, 
      459, 1588, 195, 443, 1574, 180, 426, 165, 1799, 411, 150, 1796, 395, 
      135, 1783, 379, 120, 363, 1517, 105, 347, 1503, 90, 331, 1489, 75, 314, 
      60, 1707, 299, 45, 1704, 283, 30, 1691, 267, 700, 15, 698, 478, 738, 14,
       737, 13, 736, 12, 734, 11, 732, 10, 730, 9, 1361, 666, 728, 8, 727, 7, 
      726, 6, 725, 5, 723, 4, 721, 3, 719, 2, 1256, 465, 699}], {}, {}, {
      Line3DBox[{719, 978, 851, 2224, 720, 979, 2140, 859, 740, 1016, 2143, 
       867, 748, 1036, 2148, 875, 756, 1056, 2156, 883, 765, 1074, 2162, 891, 
       773, 2292, 1096, 899, 781, 1116, 907, 2249, 789, 1136, 2167, 915, 797, 
       1156, 2170, 923, 805, 1176, 2175, 931, 813, 1196, 2183, 939, 822, 1214,
        2189, 947, 830, 2317, 1236, 955, 838}], 
      Line3DBox[{721, 980, 852, 2225, 722, 981, 860, 2226, 741, 1017, 2144, 
       868, 749, 1037, 2149, 876, 757, 1057, 2157, 884, 766, 2287, 1075, 892, 
       774, 2293, 1097, 900, 782, 1117, 908, 2250, 790, 1137, 916, 2255, 798, 
       1157, 2171, 924, 806, 1177, 2176, 932, 814, 1197, 2184, 940, 823, 2312,
        1215, 948, 831, 2318, 1237, 956, 839}], 
      Line3DBox[{723, 982, 853, 2227, 724, 983, 861, 2228, 742, 1018, 869, 
       2234, 750, 1038, 2150, 877, 758, 2285, 1058, 885, 767, 2288, 1076, 893,
        775, 2294, 1098, 901, 783, 1118, 909, 2251, 791, 1138, 917, 2256, 799,
        1158, 925, 2259, 807, 1178, 2177, 933, 815, 2310, 1198, 941, 824, 
       2313, 1216, 949, 832, 2319, 1238, 957, 840}], 
      Line3DBox[{725, 984, 985, 2273, 1257, 986, 987, 2279, 1263, 1019, 1020, 
       2283, 1269, 1039, 2199, 1040, 1275, 2236, 1059, 1060, 1280, 2238, 1077,
        1078, 1286, 2242, 1099, 1100, 1292, 1119, 1120, 2298, 1298, 1139, 
       1140, 2304, 1304, 1159, 1160, 2308, 1310, 1179, 2214, 1180, 1316, 2261,
        1199, 1200, 1321, 2263, 1217, 1218, 1327, 2267, 1239, 1240, 841}], 
      Line3DBox[{726, 988, 989, 2274, 1258, 990, 991, 2280, 1264, 1021, 2195, 
       1022, 1270, 1041, 2200, 1042, 1276, 1061, 2204, 1062, 1281, 2239, 1079,
        1080, 1287, 2243, 1101, 1102, 1293, 1121, 1122, 2299, 1299, 1141, 
       1142, 2305, 1305, 1161, 2210, 1162, 1311, 1181, 2215, 1182, 1317, 1201,
        2219, 1202, 1322, 2264, 1219, 1220, 1328, 2268, 1241, 1242, 842}], 
      Line3DBox[{727, 992, 993, 2275, 1259, 994, 2193, 995, 1265, 1023, 2196, 
       1024, 1271, 1043, 2201, 1044, 759, 1081, 2205, 1082, 1282, 1083, 2207, 
       1084, 1288, 2244, 1103, 1104, 1294, 1123, 1124, 2300, 1300, 1143, 2208,
        1144, 1306, 1163, 2211, 1164, 1312, 1183, 2216, 1184, 816, 1221, 2220,
        1222, 1323, 1223, 2222, 1224, 1329, 2269, 1243, 1244, 843}], 
      Line3DBox[{728, 1403, 1404, 1362, 1364, 2331, 1363, 996, 1405, 1406, 
       1365, 1367, 2332, 1366, 1025, 1407, 1408, 1368, 1370, 2333, 1369, 1045,
        1409, 1410, 1371, 1373, 1372, 1063, 1411, 2334, 1412, 1374, 1376, 
       1375, 1085, 1413, 2335, 1414, 1377, 1379, 1378, 1105, 1415, 2336, 1416,
        1380, 1382, 1381, 1125, 1417, 1418, 1383, 1385, 2337, 1384, 1145, 
       1419, 1420, 1386, 1388, 2338, 1387, 1165, 1421, 1422, 1389, 1391, 2339,
        1390, 1185, 1423, 1424, 1392, 1394, 1393, 1203, 1425, 2340, 1426, 
       1395, 1397, 1396, 1225, 1427, 2341, 1428, 1398, 1400, 1399, 1245, 1429,
        2342, 1430, 1401, 1432, 1431, 1402}], 
      Line3DBox[{730, 997, 855, 2229, 731, 998, 2142, 863, 744, 1026, 2146, 
       871, 752, 1046, 2152, 879, 761, 1064, 2159, 887, 769, 1086, 2164, 895, 
       777, 2295, 1106, 903, 785, 1126, 911, 2252, 793, 1146, 2169, 919, 801, 
       1166, 2173, 927, 809, 1186, 2179, 935, 818, 1204, 2186, 943, 826, 1226,
        2191, 951, 834, 2320, 1246, 959, 845}], 
      Line3DBox[{732, 999, 856, 2230, 733, 1000, 864, 2231, 745, 1027, 2147, 
       872, 753, 1047, 2153, 880, 762, 1065, 2160, 888, 770, 2289, 1087, 896, 
       778, 2296, 1107, 904, 786, 1127, 912, 2253, 794, 1147, 920, 2257, 802, 
       1167, 2174, 928, 810, 1187, 2180, 936, 819, 1205, 2187, 944, 827, 2314,
        1227, 952, 835, 2321, 1247, 960, 846}], 
      Line3DBox[{734, 1001, 857, 2232, 735, 1002, 865, 2233, 746, 1028, 873, 
       2235, 754, 1048, 2154, 881, 763, 2286, 1066, 889, 771, 2290, 1088, 897,
        779, 2297, 1108, 905, 787, 1128, 913, 2254, 795, 1148, 921, 2258, 803,
        1168, 929, 2260, 811, 1188, 2181, 937, 820, 2311, 1206, 945, 828, 
       2315, 1228, 953, 836, 2322, 1248, 961, 847}], 
      Line3DBox[{736, 1003, 1004, 2276, 1260, 1005, 1006, 2281, 1266, 1029, 
       1030, 2284, 1272, 1049, 2202, 1050, 1277, 2237, 1067, 1068, 1283, 2240,
        1089, 1090, 1289, 2245, 1109, 1110, 1295, 1129, 1130, 2301, 1301, 
       1149, 1150, 2306, 1307, 1169, 1170, 2309, 1313, 1189, 2217, 1190, 1318,
        2262, 1207, 1208, 1324, 2265, 1229, 1230, 1330, 2270, 1249, 1250, 
       848}], Line3DBox[{737, 1007, 1008, 2277, 1261, 1009, 1010, 2282, 1267, 
       1031, 2197, 1032, 1273, 1051, 2203, 1052, 1278, 1069, 2206, 1070, 1284,
        2241, 1091, 1092, 1290, 2246, 1111, 1112, 1296, 1131, 1132, 2302, 
       1302, 1151, 1152, 2307, 1308, 1171, 2212, 1172, 1314, 1191, 2218, 1192,
        1319, 1209, 2221, 1210, 1325, 2266, 1231, 1232, 1331, 2271, 1251, 
       1252, 849}], 
      Line3DBox[{738, 1011, 1334, 1012, 2278, 1262, 1013, 1336, 2194, 1014, 
       1268, 1033, 1338, 2198, 1034, 1274, 1053, 1340, 1054, 1279, 1071, 2325,
        1342, 1072, 1285, 1093, 2326, 1344, 1094, 1291, 2247, 1113, 1346, 
       1114, 1297, 1133, 1348, 1134, 2303, 1303, 1153, 1350, 2209, 1154, 1309,
        1173, 1352, 2213, 1174, 1315, 1193, 1354, 1194, 1320, 1211, 2329, 
       1356, 1212, 1326, 1233, 2330, 1358, 1234, 1332, 2272, 1253, 1360, 1254,
        1255}], 
      Line3DBox[{837, 954, 1359, 1235, 2316, 829, 946, 1357, 2188, 1213, 821, 
       938, 1355, 2182, 1195, 812, 930, 1353, 1175, 804, 922, 2328, 1351, 
       1155, 796, 914, 2327, 1349, 1135, 788, 2248, 906, 1347, 1115, 780, 898,
        1345, 1095, 2291, 772, 890, 1343, 2161, 1073, 764, 882, 1341, 2155, 
       1055, 755, 874, 1339, 1035, 747, 866, 2324, 1337, 1015, 739, 858, 2323,
        1335, 977, 718, 2223, 850, 1333, 976, 1256}], 
      Line3DBox[{844, 958, 2192, 975, 833, 950, 2190, 974, 825, 942, 2185, 
       973, 817, 934, 2178, 972, 808, 926, 2172, 971, 800, 918, 2168, 970, 
       792, 910, 2166, 969, 784, 902, 2165, 968, 776, 894, 2163, 967, 768, 
       886, 2158, 966, 760, 878, 2151, 965, 751, 870, 2145, 964, 743, 862, 
       2141, 963, 729, 854, 2139, 962, 1361}]}, {
      Line3DBox[{1433, 1675, 1859, 2223, 1603, 2013, 1677, 1860, 2224, 1604, 
       1434, 1679, 1861, 2225, 1605, 1435, 1681, 1862, 2227, 1606, 1436, 2065,
        2273, 1863, 1607, 1437, 2067, 2274, 1864, 1608, 1438, 2069, 2275, 
       1865, 1609, 2025, 2331, 2026, 2027, 1684, 2043, 2139, 1439, 1685, 1866,
        2229, 1610, 1440, 1687, 1867, 2230, 1611, 1441, 1689, 1868, 2232, 
       1612, 1442, 2070, 2276, 1869, 1613, 1443, 2072, 2277, 1870, 1614, 2014,
        2074, 2278, 1871, 1615, 1691}], 
      Line3DBox[{1444, 1676, 1872, 2044, 2323, 2015, 1678, 1873, 2045, 2140, 
       1445, 1680, 1874, 2226, 1616, 1446, 1682, 1875, 2228, 1617, 1447, 2066,
        2279, 1876, 1618, 1448, 2068, 2280, 1877, 1619, 1449, 2193, 1683, 
       1878, 1620, 2028, 2332, 670, 1699, 2046, 2141, 1450, 1686, 1879, 2047, 
       2142, 1451, 1688, 1880, 2231, 1621, 1452, 1690, 1881, 2233, 1622, 1453,
        2071, 2281, 1882, 1623, 1454, 2073, 2282, 1883, 1624, 2016, 2194, 
       1692, 1884, 1625, 1704}], 
      Line3DBox[{1455, 1693, 1885, 2048, 2324, 2017, 1694, 1886, 2049, 2143, 
       1456, 1695, 1887, 2050, 2144, 1457, 1696, 1888, 2234, 1626, 1458, 2075,
        2283, 1889, 1627, 1459, 2195, 1697, 1890, 1628, 1460, 2196, 1698, 
       1891, 1629, 2029, 2333, 2030, 1665, 1706, 2051, 2145, 1461, 1700, 1892,
        2052, 2146, 1462, 1701, 1893, 2053, 2147, 1463, 1702, 1894, 2235, 
       1630, 1464, 2076, 2284, 1895, 1631, 1465, 2197, 1703, 1896, 1632, 2018,
        2198, 1705, 1897, 1633, 1707}], 
      Line3DBox[{302, 285, 1339, 640, 287, 2148, 1466, 288, 2149, 1467, 289, 
       2150, 1468, 2199, 290, 1469, 2200, 291, 1470, 2201, 292, 673, 1371, 
       229, 2151, 1471, 294, 2152, 1472, 295, 2153, 1473, 296, 2154, 1474, 
       2202, 297, 1475, 2203, 298, 641, 1340, 300, 314}], 
      Line3DBox[{1489, 1728, 1909, 1727, 2325, 1488, 1726, 1908, 1725, 2206, 
       1487, 1724, 1907, 2237, 2080, 1486, 2079, 2286, 1906, 1723, 1485, 2160,
        1722, 1905, 1721, 1484, 2159, 1720, 1904, 1719, 1483, 2158, 1667, 
       1718, 1666, 2037, 2334, 1482, 1739, 1738, 2205, 1481, 1717, 1903, 1716,
        2204, 1480, 1715, 1902, 2236, 2078, 1479, 2077, 2285, 1901, 1714, 
       1478, 2157, 1713, 1900, 1712, 1477, 2156, 1711, 1899, 1710, 1476, 2155,
        1709, 1898, 1708, 1731}], 
      Line3DBox[{1503, 1750, 1922, 1749, 2326, 1502, 1748, 1921, 2241, 2088, 
       1501, 1747, 1920, 2240, 2087, 1500, 2086, 2290, 1919, 1746, 1499, 2085,
        2289, 1918, 1745, 1498, 2164, 1744, 1917, 1743, 1497, 2163, 1668, 
       1742, 708, 2335, 1496, 1741, 1916, 1740, 2207, 1495, 1737, 1915, 2239, 
       2084, 1494, 1736, 1914, 2238, 2083, 1493, 2082, 2288, 1913, 1735, 1492,
        2081, 2287, 1912, 1734, 1491, 2162, 1733, 1911, 1732, 1490, 2161, 
       1730, 1910, 1729, 1752}], 
      Line3DBox[{106, 544, 780, 107, 545, 781, 108, 546, 782, 109, 547, 783, 
       110, 1292, 548, 111, 1293, 549, 112, 1294, 550, 113, 1125, 357, 784, 
       114, 551, 785, 115, 552, 786, 116, 553, 787, 117, 1295, 554, 118, 1296,
        555, 119, 1297, 556, 120}], 
      Line3DBox[{1517, 1765, 1935, 2247, 2101, 1516, 1764, 1934, 2246, 2100, 
       1515, 1763, 1933, 2245, 2099, 1514, 2098, 2297, 1932, 1762, 1513, 2097,
        2296, 1931, 1761, 1512, 2096, 2295, 1930, 1760, 1511, 2165, 1669, 
       1759, 2039, 2038, 2336, 1510, 1758, 1929, 2244, 2095, 1509, 1757, 1928,
        2243, 2094, 1508, 1756, 1927, 2242, 2093, 1507, 2092, 2294, 1926, 
       1755, 1506, 2091, 2293, 1925, 1754, 1505, 2090, 2292, 1924, 1753, 1504,
        2089, 2291, 1923, 1751, 1767}], 
      Line3DBox[{1518, 1766, 1936, 2248, 1634, 2019, 1768, 1937, 2249, 1635, 
       1519, 1769, 1938, 2250, 1636, 1520, 1770, 1939, 2251, 1637, 1521, 2102,
        2298, 1940, 1638, 1522, 2103, 2299, 1941, 1639, 1523, 2104, 2300, 
       1942, 1640, 2031, 2337, 2032, 2033, 1779, 2054, 2166, 1524, 1771, 1943,
        2252, 1641, 1525, 1772, 1944, 2253, 1642, 1526, 1773, 1945, 2254, 
       1643, 1527, 2105, 2301, 1946, 1644, 1528, 2106, 2302, 1947, 1645, 2020,
        2107, 2303, 1948, 1646, 1783}], 
      Line3DBox[{1529, 1774, 1949, 2055, 2327, 2021, 1775, 1950, 2056, 2167, 
       1530, 1776, 1951, 2255, 1647, 1531, 1777, 1952, 2256, 1648, 1532, 2108,
        2304, 1953, 1649, 1533, 2109, 2305, 1954, 1650, 1534, 2208, 1778, 
       1955, 1651, 2034, 2338, 684, 1791, 2057, 2168, 1535, 1780, 1956, 2058, 
       2169, 1536, 1781, 1957, 2257, 1652, 1537, 1782, 1958, 2258, 1653, 1538,
        2110, 2306, 1959, 1654, 1539, 2111, 2307, 1960, 1655, 2022, 2209, 
       1784, 1961, 1656, 1796}], 
      Line3DBox[{1540, 1785, 1962, 2059, 2328, 2023, 1786, 1963, 2060, 2170, 
       1541, 1787, 1964, 2061, 2171, 1542, 1788, 1965, 2259, 1657, 1543, 2112,
        2308, 1966, 1658, 1544, 2210, 1789, 1967, 1659, 1545, 2211, 1790, 
       1968, 1660, 2035, 2339, 2036, 1670, 1798, 2062, 2172, 1546, 1792, 1969,
        2063, 2173, 1547, 1793, 1970, 2064, 2174, 1548, 1794, 1971, 2260, 
       1661, 1549, 2113, 2309, 1972, 1662, 1550, 2212, 1795, 1973, 1663, 2024,
        2213, 1797, 1974, 1664, 1799}], 
      Line3DBox[{414, 397, 1353, 654, 399, 2175, 1551, 400, 2176, 1552, 401, 
       2177, 1553, 2214, 402, 1554, 2215, 403, 1555, 2216, 404, 687, 1392, 
       236, 2178, 1556, 406, 2179, 1557, 407, 2180, 1558, 408, 2181, 1559, 
       2217, 409, 1560, 2218, 410, 655, 1354, 412, 426}], 
      Line3DBox[{1574, 1820, 1986, 1819, 2329, 1573, 1818, 1985, 1817, 2221, 
       1572, 1816, 1984, 2262, 2117, 1571, 2116, 2311, 1983, 1815, 1570, 2187,
        1814, 1982, 1813, 1569, 2186, 1812, 1981, 1811, 1568, 2185, 1672, 
       1810, 1671, 2040, 2340, 1567, 1831, 1830, 2220, 1566, 1809, 1980, 1808,
        2219, 1565, 1807, 1979, 2261, 2115, 1564, 2114, 2310, 1978, 1806, 
       1563, 2184, 1805, 1977, 1804, 1562, 2183, 1803, 1976, 1802, 1561, 2182,
        1801, 1975, 1800, 1823}], 
      Line3DBox[{1588, 1842, 1999, 1841, 2330, 1587, 1840, 1998, 2266, 2125, 
       1586, 1839, 1997, 2265, 2124, 1585, 2123, 2315, 1996, 1838, 1584, 2122,
        2314, 1995, 1837, 1583, 2191, 1836, 1994, 1835, 1582, 2190, 1673, 
       1834, 715, 2341, 1581, 1833, 1993, 1832, 2222, 1580, 1829, 1992, 2264, 
       2121, 1579, 1828, 1991, 2263, 2120, 1578, 2119, 2313, 1990, 1827, 1577,
        2118, 2312, 1989, 1826, 1576, 2189, 1825, 1988, 1824, 1575, 2188, 
       1822, 1987, 1821, 1844}], 
      Line3DBox[{1602, 1857, 2012, 2272, 2138, 1601, 1856, 2011, 2271, 2137, 
       1600, 1855, 2010, 2270, 2136, 1599, 2135, 2322, 2009, 1854, 1598, 2134,
        2321, 2008, 1853, 1597, 2133, 2320, 2007, 1852, 1596, 2192, 1674, 
       1851, 2042, 2041, 2342, 1595, 1850, 2006, 2269, 2132, 1594, 1849, 2005,
        2268, 2131, 1593, 1848, 2004, 2267, 2130, 1592, 2129, 2319, 2003, 
       1847, 1591, 2128, 2318, 2002, 1846, 1590, 2127, 2317, 2001, 1845, 1589,
        2126, 2316, 2000, 1843, 1858}]}}},
   VertexColors->{
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.4255971428571429, 0.11128428571428571`, 0.5662882857142857], 
     RGBColor[0.863287, 0.17742085714285727`, 0.14022885714285716`], 
     RGBColor[0.4255971428571429, 0.11128428571428571`, 0.5662882857142857], 
     RGBColor[0.863287, 0.17742085714285727`, 0.14022885714285716`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.4255971428571429, 0.11128428571428571`, 0.5662882857142857], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.863287, 0.17742085714285727`, 0.14022885714285716`], 
     RGBColor[0.4255971428571429, 0.11128428571428571`, 0.5662882857142857], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.863287, 0.17742085714285727`, 0.14022885714285716`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.540341, 0.7338622857142857, 0.41722657142857156`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25069832142857146`, 0.22599249999999987`, 0.7693615178571428],
      
     RGBColor[0.24417840178571423`, 0.3618019196428569, 0.816023486607143], 
     RGBColor[0.2662996651785714, 0.48710556696428553`, 0.8022483616071431], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7054376026785714, 0.7424953169642857, 0.29899584821428576`], 
     RGBColor[0.7948568705357142, 0.7209330580357143, 0.26072067410714284`], 
     RGBColor[0.8636794196428571, 0.6703783883928572, 0.23647461607142858`], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.87808384375, 0.29302708258928606`, 0.16044935602678578`], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.30616257589285706`, 0.5858883214285713, 0.7392464732142858], 
     RGBColor[0.36078965178571415`, 0.6559647589285713, 0.6452215937500002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010222098214286, 0.5822507232142858, 0.21643250000000003`], 
     RGBColor[0.9027425267857143, 0.4532463392857147, 0.1918732276785715], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.878014375, 0.29248433035714333`, 0.16035442410714296`], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.24882857142857143`, 0.2642019999999999, 0.7825611428571427], 
     RGBColor[0.2535265714285714, 0.41499428571428554`, 0.8102747142857143], 
     RGBColor[0.28886314285714276`, 0.5431845714285712, 0.7666072857142859], 
     RGBColor[0.3448911428571428, 0.6357064285714285, 0.6725417142857145], 
     RGBColor[0.4199331428571428, 0.6952647142857141, 0.5553740000000001], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.6215634285714284, 0.743557, 0.3500992857142859], 
     RGBColor[0.7306125714285714, 0.7364672857142858, 0.2882132857142858], 
     RGBColor[0.8241045714285713, 0.6995635714285715, 0.2504297142857143], 
     RGBColor[0.8849417142857142, 0.6205167142857144, 0.22512285714285718`], 
     RGBColor[0.9023275714285715, 0.4907817142857146, 0.19902200000000006`], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.31099318712207247`, 0.11769938654640746`, 0.6645849280729975],
      
     RGBColor[0.2497782277483259, 0.2447951845703124, 0.7758569806431361], 
     RGBColor[0.25040635074288503`, 0.3972398025076728, 0.8121935325142997], 
     RGBColor[0.28317794389343254`, 0.5290546441802977, 0.7755875772552492], 
     RGBColor[0.33709623855154847`, 0.6256795309012275, 0.685967390816825], 
     RGBColor[0.4100236809256416, 0.6886800266985211, 0.5704279187622072], 
     RGBColor[0.501476985569545, 0.7259096123831612, 0.4549170116402764], 
     RGBColor[0.7178260661882672, 0.7395289559762137, 0.29368980857631144`], 
     RGBColor[0.814342309422084, 0.7066962526593891, 0.2538646183297294], 
     RGBColor[0.8795843674621581, 0.6330800940093997, 0.22798309921264656`], 
     RGBColor[0.9020648411080496, 0.5091916950160437, 0.20252621386718753`], 
     RGBColor[0.8851775014822824, 0.33913968739536854`, 0.16949070351736892`],
      
     RGBColor[0.8603231809082031, 0.15426484198869983`, 0.1361786757899693], 
     RGBColor[0.24724942157854346`, 0.379276443028041, 0.8141349250749861], 
     RGBColor[0.2774927449297223, 0.5149247169320241, 0.7845678687962124], 
     RGBColor[0.32930180998011993`, 0.6156532451869419, 0.6993922479596821], 
     RGBColor[0.4001148237827845, 0.6820957409842354, 0.5854809187622072], 
     RGBColor[0.48953769985525936`, 0.7218994695260184, 0.4691511544974193], 
     RGBColor[0.804580047415597, 0.7138289338902065, 0.2572995223737444], 
     RGBColor[0.874227020638602, 0.6456434737330846, 0.23084334128243586`], 
     RGBColor[0.9018021268223354, 0.5276005521589009, 0.20603021386718756`], 
     RGBColor[0.8887126443394253, 0.3621048302525116, 0.17399541780308325`], 
     RGBColor[0.8632871809082031, 0.1774222705601286, 0.14022910436139793`], 
     RGBColor[0.27182966736275804`, 0.500849769945417, 0.793513217568534], 
     RGBColor[0.32150738140869134`, 0.6056269594726561, 0.7128171051025393], 
     RGBColor[0.39020596663992735`, 0.6755114552699497, 0.6005339187622072], 
     RGBColor[0.47759841414097365`, 0.7178893266688755, 0.48338529735456215`],
      
     RGBColor[0.8688905195225306, 0.6581579687107633, 0.23369245400565014`], 
     RGBColor[0.9015394125366211, 0.5460094093017582, 0.2095342138671876], 
     RGBColor[0.8922477871965682, 0.3850699731096547, 0.17850013208879756`], 
     RGBColor[0.8662511809082031, 0.2005796991315571, 0.14427953293282647`], 
     RGBColor[0.31099318712207247`, 0.11769938654640746`, 0.6645849280729975],
      
     RGBColor[0.2497782277483259, 0.2447951845703124, 0.7758569806431361], 
     RGBColor[0.25040635074288503`, 0.3972398025076728, 0.8121935325142997], 
     RGBColor[0.28317794389343254`, 0.5290546441802977, 0.7755875772552492], 
     RGBColor[0.33709623855154847`, 0.6256795309012275, 0.685967390816825], 
     RGBColor[0.4100236809256416, 0.6886800266985211, 0.5704279187622072], 
     RGBColor[0.501476985569545, 0.7259096123831612, 0.4549170116402764], 
     RGBColor[0.7178260661882672, 0.7395289559762137, 0.29368980857631144`], 
     RGBColor[0.814342309422084, 0.7066962526593891, 0.2538646183297294], 
     RGBColor[0.8795843674621581, 0.6330800940093997, 0.22798309921264656`], 
     RGBColor[0.9020648411080496, 0.5091916950160437, 0.20252621386718753`], 
     RGBColor[0.8851775014822824, 0.33913968739536854`, 0.16949070351736892`],
      
     RGBColor[0.8603231809082031, 0.15426484198869983`, 0.1361786757899693], 
     RGBColor[0.24724942157854346`, 0.379276443028041, 0.8141349250749861], 
     RGBColor[0.2774927449297223, 0.5149247169320241, 0.7845678687962124], 
     RGBColor[0.32930180998011993`, 0.6156532451869419, 0.6993922479596821], 
     RGBColor[0.4001148237827845, 0.6820957409842354, 0.5854809187622072], 
     RGBColor[0.48953769985525936`, 0.7218994695260184, 0.4691511544974193], 
     RGBColor[0.804580047415597, 0.7138289338902065, 0.2572995223737444], 
     RGBColor[0.874227020638602, 0.6456434737330846, 0.23084334128243586`], 
     RGBColor[0.9018021268223354, 0.5276005521589009, 0.20603021386718756`], 
     RGBColor[0.8887126443394253, 0.3621048302525116, 0.17399541780308325`], 
     RGBColor[0.8632871809082031, 0.1774222705601286, 0.14022910436139793`], 
     RGBColor[0.27182966736275804`, 0.500849769945417, 0.793513217568534], 
     RGBColor[0.32150738140869134`, 0.6056269594726561, 0.7128171051025393], 
     RGBColor[0.39020596663992735`, 0.6755114552699497, 0.6005339187622072], 
     RGBColor[0.47759841414097365`, 0.7178893266688755, 0.48338529735456215`],
      
     RGBColor[0.8688905195225306, 0.6581579687107633, 0.23369245400565014`], 
     RGBColor[0.9015394125366211, 0.5460094093017582, 0.2095342138671876], 
     RGBColor[0.8922477871965682, 0.3850699731096547, 0.17850013208879756`], 
     RGBColor[0.8662511809082031, 0.2005796991315571, 0.14427953293282647`], 
     RGBColor[0.5538034108276365, 0.7358334887259347, 0.4054984992414204], 
     RGBColor[0.5538025891723632, 0.7358333684169224, 0.4054992150442942], 
     RGBColor[0.5806945446166991, 0.7397709620797294, 0.3820717027849471], 
     RGBColor[0.5941240892333984, 0.7417373527308873, 0.3703722627127512], 
     RGBColor[0.6075934841308592, 0.7437095783691406, 0.35863810620117204`], 
     RGBColor[0.5538034108276365, 0.7358334887259347, 0.4054984992414204], 
     RGBColor[0.5538025891723632, 0.7358333684169224, 0.4054992150442942], 
     RGBColor[0.5806945446166991, 0.7397709620797294, 0.3820717027849471], 
     RGBColor[0.5941240892333984, 0.7417373527308873, 0.3703722627127512], 
     RGBColor[0.6075934841308592, 0.7437095783691406, 0.35863810620117204`], 
     RGBColor[0.4485031732700894, 0.11002521970912388`, 0.5466533413521902], 
     RGBColor[0.42559574469866074`, 0.11128436256626674`, 0.5662894842093331],
      
     RGBColor[0.2938217596609934, 0.14838265427943625`, 0.6943793413347515], 
     RGBColor[0.28520290251813624`, 0.16378351142229344`, 0.7093340556204658],
      
     RGBColor[0.24787879917689734`, 0.28361118457031226`, 0.7892661235002789],
      
     RGBColor[0.24692908489118304`, 0.30301918457031235`, 0.7959706949288504],
      
     RGBColor[0.25667562076241623`, 0.43291280787876646`, 0.8083381675240654],
      
     RGBColor[0.2598244779052734, 0.4508302364501951, 0.8064017389526368], 
     RGBColor[0.4415685005929128, 0.7057876730259486, 0.5263405418178015], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6354767062901087, 0.7433959901733398, 0.34161005331856875`], 
     RGBColor[0.6493891348615372, 0.7432349901733398, 0.3331213390328545], 
     RGBColor[0.7434006376168385, 0.7334052416904995, 0.2827360942905972], 
     RGBColor[0.7561879233311242, 0.7303433845476424, 0.2772592371477401], 
     RGBColor[0.8339570298810683, 0.6923649892316547, 0.2469630741402763], 
     RGBColor[0.8438088870239256, 0.6851668463745118, 0.2434966455688477], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.875156432434082, 0.2701555176609587, 0.15644892740522118`], 
     RGBColor[0.4026883161272321, 0.1125435054234096, 0.585925627066476], 
     RGBColor[0.27658404537527903`, 0.17918436856515063`, 0.7242887699061802],
      
     RGBColor[0.24597937060546876`, 0.3224271845703124, 0.8026752663574218], 
     RGBColor[0.2629733350481306, 0.4687476650216237, 0.8044653103812082], 
     RGBColor[0.3703126537737164, 0.6622926497279575, 0.6307547640380862], 
     RGBColor[0.45361417886788485`, 0.7098335507986885, 0.5119795566231866], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6633015634329658, 0.7430739901733399, 0.3246326247471403], 
     RGBColor[0.76897520904541, 0.7272815274047851, 0.27178238000488286`], 
     RGBColor[0.8536607441667828, 0.6779687035173689, 0.24003021699741908`], 
     RGBColor[0.8993450439104353, 0.43117546895926373`, 0.18754392890276234`],
      
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.872185716217041, 0.2469456159733366, 0.15238932084546775`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.40269111244419636`, 0.11254335171944756`, 0.5859232300763813],
      
     RGBColor[0.3569648035180229, 0.11505677024166924`, 0.6251196126648698], 
     RGBColor[0.27658509748186383`, 0.17918248857770647`, 0.724286944379534], 
     
     RGBColor[0.2594152440708706, 0.20986294367327002`, 0.7540786264822822], 
     RGBColor[0.24597948653738838`, 0.32242481542968743`, 0.8026744479282923],
      
     RGBColor[0.2440802318638393, 0.3612372617187497, 0.816082363141741], 
     RGBColor[0.2629729506661551, 0.46874547783551884`, 0.804465546761649], 
     RGBColor[0.3215083328770228, 0.6056281833844865, 0.7128154663260325], 
     RGBColor[0.370389461931501, 0.662343687587193, 0.6306380812377932], 
     RGBColor[0.3902071762172153, 0.6755122590157644, 0.6005320812377932], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6632998651384626, 0.7430740098266602, 0.32463366096714574`], 
     RGBColor[0.6910151822858536, 0.7427532774658203, 0.3077230685860772], 
     RGBColor[0.7689736480974468, 0.7272819011666434, 0.2717830485665458], 
     RGBColor[0.7945458781040733, 0.7211587475237166, 0.260830337123326], 
     RGBColor[0.8536595415475026, 0.6779695821969169, 0.2400306401454381], 
     RGBColor[0.901539444606236, 0.5460071621268139, 0.20953378613281257`], 
     RGBColor[0.8993176413748606, 0.43099745546177476`, 0.18750901076834547`],
      
     RGBColor[0.8922473556605748, 0.3850671697474892, 0.17849958219691694`], 
     RGBColor[0.8721597332763672, 0.24674261391775992`, 0.1523538140825545], 
     RGBColor[0.8662508190917969, 0.20057687229701474`, 0.14427903849574503`],
      
     RGBColor[0.425598541015625, 0.1112842088623047, 0.5662870872192383], 
     RGBColor[0.3340131008382525, 0.11631834669484412`, 0.6447937070849111], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.28520395462472103`, 0.16378163143484928`, 0.7093322300938196],
      
     RGBColor[0.25072905210658486`, 0.22538412001255573`, 0.7691501744733537],
      
     RGBColor[0.24692920082310268`, 0.3030168154296874, 0.795969876499721], 
     RGBColor[0.259824093523298, 0.4508280492640902, 0.8064019753330777], 
     RGBColor[0.3293027614484514, 0.6156544690987722, 0.6993906091831754], 
     RGBColor[0.40011603336007245`, 0.6820965447300501, 0.5854790812377931], 
     RGBColor[0.45375263494001106`, 0.7098800551409039, 0.5118144878278461], 
     RGBColor[0.47759987157331185`, 0.7178898161882672, 0.48338355978829534`],
      
     RGBColor[0.44181079871913354`, 0.7058690556248255, 0.5260516714259559], 
     RGBColor[0.4895391572875975, 0.7218999590454102, 0.46914941693115253`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6493874365670339, 0.7432350098266601, 0.3331223752528601], 
     RGBColor[0.7050363017054966, 0.7425910196533203, 0.2991680362200057], 
     RGBColor[0.7561863623831612, 0.7303437583095006, 0.27725990570940295`], 
     RGBColor[0.8438076844046455, 0.6851677250540598, 0.24349706871686666`], 
     RGBColor[0.9018021588919504, 0.5275983049839568, 0.20602978613281256`], 
     RGBColor[0.8887122128034319, 0.3621020268903465, 0.17399486791120267`], 
     RGBColor[0.8751391104736328, 0.2700201829572407, 0.15642525622994563`], 
     RGBColor[0.8632868190917968, 0.17741944372558593`, 0.1402286099243164], 
     RGBColor[0.44850596958705363`, 0.11002506600516183`, 0.5466509443620954],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.2938228117675782, 0.1483807742919921, 0.6943775158081054], 
     RGBColor[0.24787891510881696`, 0.2836088154296873, 0.7892653050711494], 
     RGBColor[0.2566752363804408, 0.43291062069266156`, 0.8083384039045062], 
     RGBColor[0.33709719001988, 0.625680754813058, 0.6859657520403183], 
     RGBColor[0.41002489050292956`, 0.6886808304443358, 0.5704260812377933], 
     RGBColor[0.5014784430018833, 0.725910101902553, 0.45491527407400967`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6354750079956053, 0.7433960098266601, 0.34161108953857433`], 
     RGBColor[0.7433990766688754, 0.7334056154523577, 0.2827367628522601], 
     RGBColor[0.8339558272617884, 0.6923658679112026, 0.24696349728829523`], 
     RGBColor[0.9020648731776646, 0.5091894478410997, 0.20252578613281258`], 
     RGBColor[0.8851770699462891, 0.3391368840332037, 0.1694901536254884], 
     RGBColor[0.8603228190917969, 0.15426201515415744`, 0.13617818135288784`],
      
     RGBColor[0.4485031732700894, 0.11002521970912388`, 0.5466533413521902], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.2938217596609934, 0.14838265427943625`, 0.6943793413347515], 
     RGBColor[0.24787879917689734`, 0.28361118457031226`, 0.7892661235002789],
      
     RGBColor[0.25667562076241623`, 0.43291280787876646`, 0.8083381675240654],
      
     RGBColor[0.6354767062901087, 0.7433959901733398, 0.34161005331856875`], 
     RGBColor[0.7434006376168385, 0.7334052416904995, 0.2827360942905972], 
     RGBColor[0.8339570298810683, 0.6923649892316547, 0.2469630741402763], 
     RGBColor[0.42559574469866074`, 0.11128436256626674`, 0.5662894842093331],
      
     RGBColor[0.28520290251813624`, 0.16378351142229344`, 0.7093340556204658],
      
     RGBColor[0.24692908489118304`, 0.30301918457031235`, 0.7959706949288504],
      
     RGBColor[0.2598244779052734, 0.4508302364501951, 0.8064017389526368], 
     RGBColor[0.4415685005929128, 0.7057876730259486, 0.5263405418178015], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6493891348615372, 0.7432349901733398, 0.3331213390328545], 
     RGBColor[0.7561879233311242, 0.7303433845476424, 0.2772592371477401], 
     RGBColor[0.8438088870239256, 0.6851668463745118, 0.2434966455688477], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.875156432434082, 0.2701555176609587, 0.15644892740522118`], 
     RGBColor[0.4026883161272321, 0.1125435054234096, 0.585925627066476], 
     RGBColor[0.27658404537527903`, 0.17918436856515063`, 0.7242887699061802],
      
     RGBColor[0.24597937060546876`, 0.3224271845703124, 0.8026752663574218], 
     RGBColor[0.2629733350481306, 0.4687476650216237, 0.8044653103812082], 
     RGBColor[0.3703126537737164, 0.6622926497279575, 0.6307547640380862], 
     RGBColor[0.45361417886788485`, 0.7098335507986885, 0.5119795566231866], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6633015634329658, 0.7430739901733399, 0.3246326247471403], 
     RGBColor[0.76897520904541, 0.7272815274047851, 0.27178238000488286`], 
     RGBColor[0.8536607441667828, 0.6779687035173689, 0.24003021699741908`], 
     RGBColor[0.8993450439104353, 0.43117546895926373`, 0.18754392890276234`],
      
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.872185716217041, 0.2469456159733366, 0.15238932084546775`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.857359, 0.131106, 0.132128], 
     RGBColor[0.40269111244419636`, 0.11254335171944756`, 0.5859232300763813],
      
     RGBColor[0.3569648035180229, 0.11505677024166924`, 0.6251196126648698], 
     RGBColor[0.27658509748186383`, 0.17918248857770647`, 0.724286944379534], 
     
     RGBColor[0.2594152440708706, 0.20986294367327002`, 0.7540786264822822], 
     RGBColor[0.24597948653738838`, 0.32242481542968743`, 0.8026744479282923],
      
     RGBColor[0.2440802318638393, 0.3612372617187497, 0.816082363141741], 
     RGBColor[0.2629729506661551, 0.46874547783551884`, 0.804465546761649], 
     RGBColor[0.3215083328770228, 0.6056281833844865, 0.7128154663260325], 
     RGBColor[0.370389461931501, 0.662343687587193, 0.6306380812377932], 
     RGBColor[0.3902071762172153, 0.6755122590157644, 0.6005320812377932], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6632998651384626, 0.7430740098266602, 0.32463366096714574`], 
     RGBColor[0.6910151822858536, 0.7427532774658203, 0.3077230685860772], 
     RGBColor[0.7689736480974468, 0.7272819011666434, 0.2717830485665458], 
     RGBColor[0.7945458781040733, 0.7211587475237166, 0.260830337123326], 
     RGBColor[0.8536595415475026, 0.6779695821969169, 0.2400306401454381], 
     RGBColor[0.901539444606236, 0.5460071621268139, 0.20953378613281257`], 
     RGBColor[0.8993176413748606, 0.43099745546177476`, 0.18750901076834547`],
      
     RGBColor[0.8922473556605748, 0.3850671697474892, 0.17849958219691694`], 
     RGBColor[0.8721597332763672, 0.24674261391775992`, 0.1523538140825545], 
     RGBColor[0.8662508190917969, 0.20057687229701474`, 0.14427903849574503`],
      
     RGBColor[0.425598541015625, 0.1112842088623047, 0.5662870872192383], 
     RGBColor[0.3340131008382525, 0.11631834669484412`, 0.6447937070849111], 
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.28520395462472103`, 0.16378163143484928`, 0.7093322300938196],
      
     RGBColor[0.25072905210658486`, 0.22538412001255573`, 0.7691501744733537],
      
     RGBColor[0.24692920082310268`, 0.3030168154296874, 0.795969876499721], 
     RGBColor[0.259824093523298, 0.4508280492640902, 0.8064019753330777], 
     RGBColor[0.3293027614484514, 0.6156544690987722, 0.6993906091831754], 
     RGBColor[0.40011603336007245`, 0.6820965447300501, 0.5854790812377931], 
     RGBColor[0.45375263494001106`, 0.7098800551409039, 0.5118144878278461], 
     RGBColor[0.47759987157331185`, 0.7178898161882672, 0.48338355978829534`],
      
     RGBColor[0.44181079871913354`, 0.7058690556248255, 0.5260516714259559], 
     RGBColor[0.4895391572875975, 0.7218999590454102, 0.46914941693115253`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6493874365670339, 0.7432350098266601, 0.3331223752528601], 
     RGBColor[0.7050363017054966, 0.7425910196533203, 0.2991680362200057], 
     RGBColor[0.7561863623831612, 0.7303437583095006, 0.27725990570940295`], 
     RGBColor[0.8438076844046455, 0.6851677250540598, 0.24349706871686666`], 
     RGBColor[0.9018021588919504, 0.5275983049839568, 0.20602978613281256`], 
     RGBColor[0.8887122128034319, 0.3621020268903465, 0.17399486791120267`], 
     RGBColor[0.8751391104736328, 0.2700201829572407, 0.15642525622994563`], 
     RGBColor[0.8632868190917968, 0.17741944372558593`, 0.1402286099243164], 
     RGBColor[0.44850596958705363`, 0.11002506600516183`, 0.5466509443620954],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.2938228117675782, 0.1483807742919921, 0.6943775158081054], 
     RGBColor[0.24787891510881696`, 0.2836088154296873, 0.7892653050711494], 
     RGBColor[0.2566752363804408, 0.43291062069266156`, 0.8083384039045062], 
     RGBColor[0.33709719001988, 0.625680754813058, 0.6859657520403183], 
     RGBColor[0.41002489050292956`, 0.6886808304443358, 0.5704260812377933], 
     RGBColor[0.5014784430018833, 0.725910101902553, 0.45491527407400967`], 
     RGBColor[0.5672649999999998, 0.7378045714285714, 0.39377114285714304`], 
     RGBColor[0.6354750079956053, 0.7433960098266601, 0.34161108953857433`], 
     RGBColor[0.7433990766688754, 0.7334056154523577, 0.2827367628522601], 
     RGBColor[0.8339558272617884, 0.6923658679112026, 0.24696349728829523`], 
     RGBColor[0.9020648731776646, 0.5091894478410997, 0.20252578613281258`], 
     RGBColor[0.8851770699462891, 0.3391368840332037, 0.1694901536254884], 
     RGBColor[0.8603228190917969, 0.15426201515415744`, 0.13617818135288784`],
      
     RGBColor[0.471412, 0.108766, 0.527016], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.37978228571428574`, 0.11380257142857143`, 0.6055605714285714],
      
     RGBColor[0.26796571428571436`, 0.19458428571428563`, 0.7392425714285713],
      
     RGBColor[0.2450297142857143, 0.34183399999999986`, 0.8093794285714285], 
     RGBColor[0.26612199999999997`, 0.48666399999999976`, 0.802529], 
     RGBColor[0.3137134285714285, 0.5956012857142856, 0.726241142857143], 
     RGBColor[0.3802977142857142, 0.6689275714285713, 0.6155860000000003], 
     RGBColor[0.465659857142857, 0.7138794285714285, 0.49761857142857163`], 
     RGBColor[0.6772131428571426, 0.742913, 0.3161444285714287], 
     RGBColor[0.781761714285714, 0.7242198571428572, 0.26630585714285726`], 
     RGBColor[0.8635119999999998, 0.6707710000000001, 0.23656400000000005`], 
     RGBColor[0.9012767142857143, 0.5644171428571431, 0.21303800000000006`], 
     RGBColor[0.8957827142857143, 0.4080337142857147, 0.18300457142857152`], 
     RGBColor[0.869215, 0.22373571428571454`, 0.14832971428571434`], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.3024411428571429, 0.1329808571428571, 0.6794237142857142], 
     RGBColor[0.8816421428571429, 0.3161731428571434, 0.1649857142857144], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5266752294921874, 0.7318613062220982, 0.429131804827009], 
     RGBColor[0.5538025891723632, 0.7358333684169224, 0.4054992150442942], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5268822866210937, 0.731891624093192, 0.4289514225027903], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5266752294921874, 0.7318613062220982, 0.429131804827009], 
     RGBColor[0.5538025891723632, 0.7358333684169224, 0.4054992150442942], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5134169999999999, 0.72992, 0.4406820000000002], 
     RGBColor[0.5268822866210937, 0.731891624093192, 0.4289514225027903], 
     RGBColor[0.5266752294921874, 0.7318613062220982, 0.429131804827009], 
     RGBColor[0.5268822866210937, 0.731891624093192, 0.4289514225027903], 
     RGBColor[0.5538034108276365, 0.7358334887259347, 0.4054984992414204], 
     RGBColor[0.5266752294921874, 0.7318613062220982, 0.429131804827009], 
     RGBColor[0.5268822866210937, 0.731891624093192, 0.4289514225027903], 
     RGBColor[0.5538034108276365, 0.7358334887259347, 0.4054984992414204], 
     RGBColor[0.6077562942592075, 0.7437167814941407, 0.3585237543596541], 
     RGBColor[0.333878880354745, 0.11632572433492117`, 0.6449087602686542], 
     RGBColor[0.2507206383231027, 0.22553644042968737`, 0.7692039702497209], 
     RGBColor[0.5943631909179686, 0.7417723626534598, 0.370163964076451], 
     RGBColor[0.7051371201956612, 0.7425672661220006, 0.29912454633440294`], 
     RGBColor[0.35683058303451537`, 0.11506414788174629`, 0.6252346658486128],
      
     RGBColor[0.2593134527587891, 0.2100448324584961, 0.7542552461853027], 
     RGBColor[0.24410421606445307`, 0.3613797927246092, 0.8160691080322267], 
     RGBColor[0.5809734965820311, 0.7398118069893973, 0.38182868770926354`], 
     RGBColor[0.6911794922790526, 0.7427513760070801, 0.30762281430053723`], 
     RGBColor[0.7946247650146483, 0.7211026431884766, 0.2608023416748047], 
     RGBColor[0.6077562942592075, 0.7437167814941407, 0.3585237543596541], 
     RGBColor[0.333878880354745, 0.11632572433492117`, 0.6449087602686542], 
     RGBColor[0.2507206383231027, 0.22553644042968737`, 0.7692039702497209], 
     RGBColor[0.5943631909179686, 0.7417723626534598, 0.370163964076451], 
     RGBColor[0.7051371201956612, 0.7425672661220006, 0.29912454633440294`], 
     RGBColor[0.35683058303451537`, 0.11506414788174629`, 0.6252346658486128],
      
     RGBColor[0.2593134527587891, 0.2100448324584961, 0.7542552461853027], 
     RGBColor[0.24410421606445307`, 0.3613797927246092, 0.8160691080322267], 
     RGBColor[0.5809734965820311, 0.7398118069893973, 0.38182868770926354`], 
     RGBColor[0.6911794922790526, 0.7427513760070801, 0.30762281430053723`], 
     RGBColor[0.7946247650146483, 0.7211026431884766, 0.2608023416748047], 
     RGBColor[0.29452222989763527`, 0.5572496004071915, 0.7576682403433664], 
     RGBColor[0.3001813169381277, 0.5713146293858118, 0.7487291949724472], 
     RGBColor[0.35262372598702557`, 0.6456531600167409, 0.6592233776157926], 
     RGBColor[0.36047904853166846`, 0.6557577760881695, 0.6456936387765069], 
     RGBColor[0.4298323233816963, 0.701842570033482, 0.5403357001953127], 
     RGBColor[0.8902744549996511, 0.6080110377328057, 0.22227575206647607`], 
     RGBColor[0.895607195713588, 0.5955053611798969, 0.21942864699009493`], 
     RGBColor[0.9025882011893136, 0.4725189235142302, 0.19554580273437505`], 
     RGBColor[0.902852967930385, 0.4539662471749444, 0.19201442773437502`], 
     RGBColor[0.8781072157679967, 0.293209401681083, 0.1604812749459404], 
     RGBColor[0.3058738897007533, 0.5854628833879741, 0.7397372558419365], 
     RGBColor[0.9010030457850864, 0.5828516884547643, 0.216547848362514], 
     RGBColor[0.27178542456926613`, 0.5007398094220841, 0.7935831031058177], 
     RGBColor[0.3059489712524413, 0.5856135532226561, 0.7396143785400393], 
     RGBColor[0.8688488281075613, 0.6582557382027764, 0.23371471269880026`], 
     RGBColor[0.9010150101928711, 0.582755213989258, 0.21652852636718756`], 
     RGBColor[0.2472218902195521, 0.3791197858232767, 0.8141518558240619], 
     RGBColor[0.2774485021362304, 0.5148147564086912, 0.7846377543334963], 
     RGBColor[0.3002482883823939, 0.571481079432896, 0.7486234074532646], 
     RGBColor[0.3605568081577845, 0.6558100378592354, 0.6455753171997073], 
     RGBColor[0.8043790596684045, 0.7139757832096646, 0.25737024098641537`], 
     RGBColor[0.8741853292236327, 0.6457412432250978, 0.23086559997558598`], 
     RGBColor[0.8956624164014543, 0.5953758645292011, 0.21939916513279512`], 
     RGBColor[0.9028255974644253, 0.45378598650251156`, 0.1919790818655832], 
     RGBColor[0.31106069903657274`, 0.11757996157635482`, 0.6644684007890513],
      
     RGBColor[0.24978558942522322`, 0.24464474414062493`, 0.7758050103934151],
      
     RGBColor[0.2503742308240618, 0.3970570357687812, 0.8122132850548881], 
     RGBColor[0.2831115797031947, 0.5288897033952984, 0.7756924055611748], 
     RGBColor[0.29462268706403455`, 0.557499275477818, 0.7575095590645927], 
     RGBColor[0.3527157805480956, 0.645771573486328, 0.6590648259887697], 
     RGBColor[0.43002272160993293`, 0.7019097004045758, 0.5401055417829242], 
     RGBColor[0.717726945992606, 0.7395526898542132, 0.2937322622419085], 
     RGBColor[0.8142274592808312, 0.7067801665562222, 0.25390502896554135`], 
     RGBColor[0.8795218303397041, 0.6332267482474193, 0.22801648725237172`], 
     RGBColor[0.8903060096784318, 0.6079370396466939, 0.22225890529087616`], 
     RGBColor[0.9025913039245606, 0.4723015093383791, 0.19550441943359378`], 
     RGBColor[0.8780955123291015, 0.29311824800327885`, 0.16046530162266331`],
      
     RGBColor[0.29452222989763527`, 0.5572496004071915, 0.7576682403433664], 
     RGBColor[0.35262372598702557`, 0.6456531600167409, 0.6592233776157926], 
     RGBColor[0.4298323233816963, 0.701842570033482, 0.5403357001953127], 
     RGBColor[0.8902744549996511, 0.6080110377328057, 0.22227575206647607`], 
     RGBColor[0.9025882011893136, 0.4725189235142302, 0.19554580273437505`], 
     RGBColor[0.8781072157679967, 0.293209401681083, 0.1604812749459404], 
     RGBColor[0.3001813169381277, 0.5713146293858118, 0.7487291949724472], 
     RGBColor[0.36047904853166846`, 0.6557577760881695, 0.6456936387765069], 
     RGBColor[0.895607195713588, 0.5955053611798969, 0.21942864699009493`], 
     RGBColor[0.902852967930385, 0.4539662471749444, 0.19201442773437502`], 
     RGBColor[0.3058738897007533, 0.5854628833879741, 0.7397372558419365], 
     RGBColor[0.9010030457850864, 0.5828516884547643, 0.216547848362514], 
     RGBColor[0.27178542456926613`, 0.5007398094220841, 0.7935831031058177], 
     RGBColor[0.3059489712524413, 0.5856135532226561, 0.7396143785400393], 
     RGBColor[0.8688488281075613, 0.6582557382027764, 0.23371471269880026`], 
     RGBColor[0.9010150101928711, 0.582755213989258, 0.21652852636718756`], 
     RGBColor[0.2472218902195521, 0.3791197858232767, 0.8141518558240619], 
     RGBColor[0.2774485021362304, 0.5148147564086912, 0.7846377543334963], 
     RGBColor[0.3002482883823939, 0.571481079432896, 0.7486234074532646], 
     RGBColor[0.3605568081577845, 0.6558100378592354, 0.6455753171997073], 
     RGBColor[0.8043790596684045, 0.7139757832096646, 0.25737024098641537`], 
     RGBColor[0.8741853292236327, 0.6457412432250978, 0.23086559997558598`], 
     RGBColor[0.8956624164014543, 0.5953758645292011, 0.21939916513279512`], 
     RGBColor[0.9028255974644253, 0.45378598650251156`, 0.1919790818655832], 
     RGBColor[0.31106069903657274`, 0.11757996157635482`, 0.6644684007890513],
      
     RGBColor[0.24978558942522322`, 0.24464474414062493`, 0.7758050103934151],
      
     RGBColor[0.2503742308240618, 0.3970570357687812, 0.8122132850548881], 
     RGBColor[0.2831115797031947, 0.5288897033952984, 0.7756924055611748], 
     RGBColor[0.29462268706403455`, 0.557499275477818, 0.7575095590645927], 
     RGBColor[0.3527157805480956, 0.645771573486328, 0.6590648259887697], 
     RGBColor[0.43002272160993293`, 0.7019097004045758, 0.5401055417829242], 
     RGBColor[0.717726945992606, 0.7395526898542132, 0.2937322622419085], 
     RGBColor[0.8142274592808312, 0.7067801665562222, 0.25390502896554135`], 
     RGBColor[0.8795218303397041, 0.6332267482474193, 0.22801648725237172`], 
     RGBColor[0.8903060096784318, 0.6079370396466939, 0.22225890529087616`], 
     RGBColor[0.9025913039245606, 0.4723015093383791, 0.19550441943359378`], 
     RGBColor[0.8780955123291015, 0.29311824800327885`, 0.16046530162266331`],
      
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.26621083258928563`, 0.4868847834821426, 0.8023886808035716], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.8635957098214284, 0.6705746941964288, 0.23651930803571433`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.24412920089285708`, 0.3615219598214283, 0.8160537433035715], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.794702935267857, 0.7210455290178572, 0.26077483705357146`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25071316071428573`, 0.22568924999999992`, 0.7692567589285714],
      
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.7052378013392856, 0.7425431584821429, 0.29908142410714295`], 
     RGBColor[0.6080857633928571, 0.74371296875, 0.3583227276785715], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.8780609136352538, 0.2928479319501606, 0.16041802107674738`], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.878037644317627, 0.29266613115365214`, 0.16038622259194518`], 
     
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.8780609136352538, 0.2928479319501606, 0.16041802107674738`], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.878037644317627, 0.29266613115365214`, 0.16038622259194518`], 
     
     RGBColor[0.30604078794642847`, 0.5857316607142856, 0.739456236607143], 
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010181049107142, 0.5825383616071431, 0.21648725000000008`], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.360634825892857, 0.6558618794642855, 0.6454567968750002], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9027977633928572, 0.45360516964285746`, 0.19194361383928576`],
      
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.2507057990373884, 0.2258396904296874, 0.7693087291782923], 
     RGBColor[0.24416206555175776`, 0.3617089642333982, 0.816033532775879], 
     RGBColor[0.24414572931780126`, 0.3616160088239394, 0.816043578944615], 
     RGBColor[0.2662773702806745, 0.48705015548488056`, 0.8022835784367154], 
     RGBColor[0.26625507538277754`, 0.4869947440054755, 0.8023187952662878], 
     RGBColor[0.7053369215349469, 0.7425194246041434, 0.2990389704415458], 
     RGBColor[0.7948057592163085, 0.720970401916504, 0.26073865789794926`], 
     RGBColor[0.7947546478969026, 0.7210077457972937, 0.2607566416887556], 
     RGBColor[0.8636584104396274, 0.6704276565486365, 0.2364858327069964], 
     RGBColor[0.8636374012363978, 0.6704769247044157, 0.23649704934256421`], 
     RGBColor[0.2662328672354562, 0.4869395481349399, 0.8023538750653949], 
     RGBColor[0.8636164737810406, 0.6705260011553086, 0.23650822233363566`], 
     RGBColor[0.3060412636805942, 0.5857322726702008, 0.7394554172188897], 
     RGBColor[0.9010181209455217, 0.5825372380196709, 0.21648703613281256`], 
     RGBColor[0.30608170108468186`, 0.585784288922991, 0.739385769217355], 
     RGBColor[0.36063543068150106`, 0.655862281337193, 0.6454558781127931], 
     RGBColor[0.9010194839041573, 0.5824417330845427, 0.21646885742187508`], 
     RGBColor[0.9027975476248605, 0.45360376796177476`, 0.19194333889334547`],
      
     RGBColor[0.30612166275460373`, 0.585835693219866, 0.7393169406040738], 
     RGBColor[0.36071254123360763`, 0.6559135201328822, 0.6453387359313967], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010208308279855, 0.5823473517368865, 0.21645089257812508`], 
     RGBColor[0.9027700372052875, 0.4534250536237449, 0.19190828328595852`], 
     RGBColor[0.8780835723876953, 0.2930249624633792, 0.16044898519897466`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.2507057990373884, 0.2258396904296874, 0.7693087291782923], 
     RGBColor[0.24416206555175776`, 0.3617089642333982, 0.816033532775879], 
     RGBColor[0.2662773702806745, 0.48705015548488056`, 0.8022835784367154], 
     RGBColor[0.7053369215349469, 0.7425194246041434, 0.2990389704415458], 
     RGBColor[0.7948057592163085, 0.720970401916504, 0.26073865789794926`], 
     RGBColor[0.8636584104396274, 0.6704276565486365, 0.2364858327069964], 
     RGBColor[0.24414572931780126`, 0.3616160088239394, 0.816043578944615], 
     RGBColor[0.26625507538277754`, 0.4869947440054755, 0.8023187952662878], 
     RGBColor[0.7947546478969026, 0.7210077457972937, 0.2607566416887556], 
     RGBColor[0.8636374012363978, 0.6704769247044157, 0.23649704934256421`], 
     RGBColor[0.2662328672354562, 0.4869395481349399, 0.8023538750653949], 
     RGBColor[0.8636164737810406, 0.6705260011553086, 0.23650822233363566`], 
     RGBColor[0.3060412636805942, 0.5857322726702008, 0.7394554172188897], 
     RGBColor[0.9010181209455217, 0.5825372380196709, 0.21648703613281256`], 
     RGBColor[0.30608170108468186`, 0.585784288922991, 0.739385769217355], 
     RGBColor[0.36063543068150106`, 0.655862281337193, 0.6454558781127931], 
     RGBColor[0.9010194839041573, 0.5824417330845427, 0.21646885742187508`], 
     RGBColor[0.9027975476248605, 0.45360376796177476`, 0.19194333889334547`],
      
     RGBColor[0.30612166275460373`, 0.585835693219866, 0.7393169406040738], 
     RGBColor[0.36071254123360763`, 0.6559135201328822, 0.6453387359313967], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010208308279855, 0.5823473517368865, 0.21645089257812508`], 
     RGBColor[0.9027700372052875, 0.4534250536237449, 0.19190828328595852`], 
     RGBColor[0.8780835723876953, 0.2930249624633792, 0.16044898519897466`], 
     RGBColor[0.3061223763558524, 0.5858366111537388, 0.7393157115216937], 
     RGBColor[0.3607170771484374, 0.6559165341796874, 0.645331845214844], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010208548801967, 0.5823456663556783, 0.2164505717773438], 
     RGBColor[0.9027697135532925, 0.45342295110212094`, 0.19190787086704808`],
      
     RGBColor[0.8780827583007812, 0.29301860208565866`, 0.16044787271554134`],
      
     RGBColor[0.3060821768188476, 0.5857849008789061, 0.7393849498291017], 
     RGBColor[0.3606396642020088, 0.6558650944475446, 0.645449446777344], 
     RGBColor[0.9010194999389648, 0.5824406094970705, 0.21646864355468756`], 
     RGBColor[0.902797331856864, 0.45360236628069234`, 0.1919430639474052], 
     RGBColor[0.30604173941475993`, 0.585732884626116, 0.7394545978306364], 
     RGBColor[0.9010181369803292, 0.582536114432199, 0.21648682226562507`], 
     RGBColor[0.2662326937343052, 0.4869391169172013, 0.8023541491263255], 
     RGBColor[0.8636163102852956, 0.6705263845650811, 0.2365083096226284], 
     RGBColor[0.24414539298357277`, 0.36161409503609765`, 0.8160437857775008],
      
     RGBColor[0.26625490188162665`, 0.486994312787737, 0.8023190693272183], 
     RGBColor[0.7947535956050326, 0.7210085146418981, 0.2607570119432722], 
     RGBColor[0.8636372377406528, 0.6704773081141882, 0.23649713663155694`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25070585700334824`, 0.22583850585937493`, 0.7693083199637276],
      
     RGBColor[0.24416187336077003`, 0.36170787064034565`, 0.8160336509660994],
      
     RGBColor[0.26627711002894805`, 0.4870495086582727, 0.8022839895281112], 
     RGBColor[0.7053314582170758, 0.7425207327706473, 0.29904131040736615`], 
     RGBColor[0.7948051579066683, 0.720970841256278, 0.26073886947195873`], 
     RGBColor[0.8636581651960099, 0.6704282316632955, 0.23648596364048555`], 
     RGBColor[0.3061223763558524, 0.5858366111537388, 0.7393157115216937], 
     RGBColor[0.3607170771484374, 0.6559165341796874, 0.645331845214844], 
     RGBColor[0.43021510267857127`, 0.7019743169642856, 0.5398761830357145], 
     RGBColor[0.9010208548801967, 0.5823456663556783, 0.2164505717773438], 
     RGBColor[0.9027697135532925, 0.45342295110212094`, 0.19190787086704808`],
      
     RGBColor[0.8780827583007812, 0.29301860208565866`, 0.16044787271554134`],
      
     RGBColor[0.3060821768188476, 0.5857849008789061, 0.7393849498291017], 
     RGBColor[0.3606396642020088, 0.6558650944475446, 0.645449446777344], 
     RGBColor[0.9010194999389648, 0.5824406094970705, 0.21646864355468756`], 
     RGBColor[0.902797331856864, 0.45360236628069234`, 0.1919430639474052], 
     RGBColor[0.30604173941475993`, 0.585732884626116, 0.7394545978306364], 
     RGBColor[0.9010181369803292, 0.582536114432199, 0.21648682226562507`], 
     RGBColor[0.2662326937343052, 0.4869391169172013, 0.8023541491263255], 
     RGBColor[0.8636163102852956, 0.6705263845650811, 0.2365083096226284], 
     RGBColor[0.24414539298357277`, 0.36161409503609765`, 0.8160437857775008],
      
     RGBColor[0.26625490188162665`, 0.486994312787737, 0.8023190693272183], 
     RGBColor[0.7947535956050326, 0.7210085146418981, 0.2607570119432722], 
     RGBColor[0.8636372377406528, 0.6704773081141882, 0.23649713663155694`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.25070585700334824`, 0.22583850585937493`, 0.7693083199637276],
      
     RGBColor[0.24416187336077003`, 0.36170787064034565`, 0.8160336509660994],
      
     RGBColor[0.26627711002894805`, 0.4870495086582727, 0.8022839895281112], 
     RGBColor[0.7053314582170758, 0.7425207327706473, 0.29904131040736615`], 
     RGBColor[0.7948051579066683, 0.720970841256278, 0.26073886947195873`], 
     RGBColor[0.8636581651960099, 0.6704282316632955, 0.23648596364048555`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.8780374407958985, 0.29266454105922207`, 0.16038594447108687`],
      
     RGBColor[0.8780607779541015, 0.2928468718872073, 0.16041783566284187`], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.3110613981584821, 0.11757992314801897`, 0.6644678015049525], 
     RGBColor[0.8780374407958985, 0.29266454105922207`, 0.16038594447108687`],
      
     RGBColor[0.8780607779541015, 0.2928468718872073, 0.16041783566284187`], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715], 
     RGBColor[0.5138376874999999, 0.7299815982142858, 0.4403155089285715]},
   VertexNormals->CompressedData["
1:eJyUfXlcj08XdvY1SSQSEqlIya409l1CltCCIrtsRVmSimixJLIW2QrZl5ax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    "]],
  Axes->True,
  Lighting->"Neutral",
  Method->{},
  PlotRange->{{-2., 2.}, {-2., 2.}, {-2., 2.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133323377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75606381],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->74584912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Cyan", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Green", ",", "Dashed"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63220257],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170425652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245529945],

Cell["Style the areas between mesh levels:", "ExampleText",
 CellID->371708829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Yellow"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Orange"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1642453520],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349672813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257247073],

Cell["Color by parameter values:", "ExampleText",
 CellID->681674874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "\[Theta]", ",", "r"}],
        "}"}], ",", 
      RowBox[{"Hue", "[", "\[Theta]", " ", "]"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->194047514],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259917562]
}, Open  ]],

Cell["Use named color schemes: ", "ExampleText",
 CellID->282713241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "#6", "]"}], 
      "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->317733308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->215639517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66517670],

Cell["Remove portions of a curve or surface:", "ExampleText",
 CellID->390723782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"5", "t"}], "]"}], "/", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "\[Theta]", ",", "r"}],
        "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"8", "t"}], "]"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"8", "\[Theta]"}], "]"}]}], ">", "0.1"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"FaceForm", "[", 
     RowBox[{"Red", ",", "Cyan"}], "]"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "35"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1352180492],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 252},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->146292168]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(35)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->298205037],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoundaryStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->334643741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " automatically matches ",
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1980942875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1267920684],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111731965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2115421836],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNnHeYFFW6xmuru2cAQcF8zRtd3btXfdzV3et1d6/roug2UcyoiKxhBROG
Sw5DGkBBMoggaQiSEUQkg+QkOeechmEC/PE9937hnFOnTlXPtD77x+XpGXqm
q6vq/M77vd97qrsn3bjFa02bNW7xepPGtz3ybuO3X3u9yXu31XzrXfxV4iee
583Er07Xe3j/f/Eef80EAHzA+v4mfk/gQz79RHeA/3k+3v0Tb9HMeSRB35LB
z5734P/z7aqWM8bbDQX6KUf9f3mF+/wV/9cav9Ovk1lun/cv3u5DNbIqWW5f
V40vYW3vERn8ulHtix9s2rQp3a3kcBFadSJ7z3WOf41FnDb8Y5bPu1I9T36P
J6HO7w9ZPr+6Ok/mkZTny5b3Z9hDSj2jujpy1R/0TPvY1dSeXJXxuaTMWNSI
7gvNR6513vTUGtb46a67z3v52U0yHPGKrJ79kjrWtTFb015/x1vdF6MYULVz
s9rDvzl7cKvhHt7T7yMEk5Hf3KCOdtO/bI/XQXzt31DBEe7O+gjXqHN29eAe
IaHOJPtz19XwC2dP7pGqxMyRXdXZHe0KdbTbnaPlOEerFHmmW4XXg60c21Pj
lOSOzt2b9hAZtnXYDMd9XI3j32PGQcevnOX511Lb3+Xsp5KzdU5kf9pThH1N
e96t/VR29pOK3U9EUd4t5cz2TWDVrnPOvuXn2m9kjzdXSORaNYb74uYq9Eym
zlWX1FVX7p6vUnt2VXGvc6TLnMfvyPLMa6j9P/Aj96fnUu/nT85+7M5Ls3Bn
Ofuxj6erQQYuT3f3Xc15zu2h+ddzeJk6s79m9ex7wOry6rjuM3Ve+jVvcpc6
Ti1nqyuc/f+St86FzFlLJ4zHs9qTW2fRTHO9OjOueEosKrnofdJjknv0aHWd
uGqL7ttOMPaWf1PHSlUwhgRk7pvXZjk+XRu11DErO8d0U2q02uK7VTbH1nlI
H7tq3HhT5hkKb2TWf/Txq0FUp48QUzyF6s656OQV3Uum8eva0T2hqvr/MTXa
q+JIh/aT7UhvcDi6acvWzQ8hqLWv9+umDXvNY49UtKfV/ah69i1x47XO4lZ+
ltbjI+pZP6vgWbxX46BxlWDmx8Tjh9Uc/zLDHN/Gm0XnNfob+3hkDg+ps/51
BWd9c9ZH8CG8YqLfPqiO4qYP9yg3/aCjRBRh7fkP6oh3xyiAiN3yg45kZsXa
0+/UEdye7I7pxh89JveId6sj3l/BESW/aIVpjbtKc736tyAaY0+r/vJMaDwD
XpwOL0yDRlPhucnw7CR45kt4eiI8NQGeHA8Nx8ETBdBgLNQbA3VHw60ZOMcd
XfcbPhLneTc50nncCVZPufGtedD8W2g2F/45F974Bl6fA699Df+YDU1nQZOv
QJ0tn+rzU+DZyepUn5wADcdDg3FQvwDqjaXzrDMKao+E9BeomPQIPG56OKQ/
h/QwlW9/UB9xU1Xl2PFUcvb7CzUunt2ffrAY3l8ELRbCewvh3QXwznx4az40
nwfNvuWR8jBftYb5Es8IjvE5a4xPjIMGBWoicIBpHiAOTwaHI8XhJdOfQXoo
34aAnx4MV8eNt8Le5SY2GXMN57dVnH3fpsbM/b/1d+D9vNUyaLkM/mcpfLQE
PlwCCsMiheFtxBBmgFP9CgJgSYoecfRPTeTpLYD6PLe1R4XGjaPGMePoh6Ko
cNA45vQgvg2E9ABIpPsjh37g9k2t3GjfjJ/vGhB0S3s/N6kxC8FOq6HjKrp5
foeV4P2s/QpotwLa4m05IJBWeAvjEBbvLCA9EAjWfECBNfDMJCpGnH01fpl3
M/ihOL4hNPODecg8al+NOpHuC8n0p+BeFakWGbWrgIQ93sjMuxSut2bey+m2
FrrqWxe8rQG/8xqMtnmrAQF1YkCIp/1KhrMc2iwHI5QPWSLEhAsEgaAskAYW
PgoCUTScQFJADgEEkfzgYNJx9Dh4j0bv4+gT6T5IoTd+fQLumdv1H1cJrp9e
ZngkVFKz98bXQ1TVJ3tugESPDVhMPdZDPt+6420daqPbOvCRjXctokEyeWtA
hGOIII6PmAWCQGWgFaI1oCmgO6MOaPAjeOQ094NooANowDhcT4/Xx/EmcLyJ
9MeQk+5F+ugJ+D997wlu5ep1lO6C9vrKi83z2t3da0eXO3uuAYEPpvpsglTv
Tfh47+8B///ke7yL3xIfb4REr41EagMgNcHUjUiRbi7rwGRaLiVlYHmgK5AH
DOX57sszTaP1aLg4Wrzhz72ABpyb7gFV0/ngrh7c9aHkygzeH3FL9wplNWuM
fv+tUHXAVnx84FYYuI1uXhK/JQbhneqDtsNgvg3B2w4YugM+2wnDdsLnu2Dk
Hhi9FyYfguXn4MIxSLeEdDucxTycwS74f1caXzfA/+ludbzrp7vTrOLvuvOt
G27ZHXJjzi3IvhV3N9r2SmcflcHq0Uk5dbmlcAT+Z/S1ExI4Di/5OQ9mON/8
EbvBu/qL3TS2UXwbsw/G7oOC/TDhAHx5EKYehq+OwdfHYfEZWFUI24vh9CUo
K4Ld62HwcHi5E85ha2yt6bbEIt0R0h34eyf+3hkfzcOvzkSmC/2M370UfUsQ
pi78cw7ezalg9q8uj03oN243TSkyvPLHcSdw1AkcdQIH7eOovSqjeFrxpoa+
D8bth/EHFAB/0iHwrpt2BKYfgZlHYc5x+PYkLDoN352F1edh8wXYUwrHLsK5
MigtgsJDsG01TJkEXfpDs27wTHuo3RrSrSDN31HzrUkPbUDhagcp5JVEVEkk
lkJWyAUh5REq5NS5Qi5XZeCSaVXD2wevH0Cwck8gCx9ReMlRezWPveAjEC+B
ahjHN89HKF6liQeJDIKZcpgEgnBmMBx/9jFkNfcEzD9FiJadhRXnYO152HSB
hIOgjl6EM5fgQhmUXICSU3ByD2xZCd/OguGjIa8fEXuxEzRoS9AQRCtiZfC1
xmpqg19t8asd1lF7ZpdCdjnILoHM3BytHTOTdtwEpZ31GkWFr1ujJryUFITc
mAKqw0sgCgSBN4818pvJFg8RC1bOLC6eb06QapDKwtOw9AxpZ2UhrDsPG4tI
QTtKYF8ZHLkIJ1BHF6EYpVQMJWfg/BE4sh22roKFc2DiROj3GXTqC+/kQ5M8
eKYDPNEW6ljiQjfCSgooJVhd7ZFOB/xChVWgJHYU00d0d3F77ZUQvZbFV22J
SNIQ0XWTDJgcBh+heHfOQCxMZjaTmXMC5jKcBSyZJWdINeivqwtJOBuK4HvU
TgnsLg0QnbkIhaigMii7AKWFUHwCzuyHQ1sI1NK5MGMqjBgFnwyGdn3gvR7w
amd4oSM82Q7qMa4cUlXCqIrvJpBYAoklFbFcJJaogBb3F/N6XnXbfR3vYQ4p
4WDk4TGLHGQxk3HM0jh8VIp3J+KYFyZCitFQ1hdRQW0tVlz2Mxe0oFOonktQ
hGhKub4KoeQ0FB6mKjuwCTavgBXz4esZMG48DB0B+QMJ0Ls94PUu0LgTPNsB
nmoH9dsQo6TNqJVUYsri5JG0xME8qsVcZOby0tk9BZmvt8qlM30l9HLLiyKv
9yE1n7A9gNgMNKmu2cdZRlxjc0+qMhN02LKWMjrUE9abLSmsui3FsLME9pbC
gTI4zABPXoLT7OQXLhJDLMJSZnjhOJw5AMd2wr6NhHHlQrKsyZPgizFUk/kD
oG1vaNED/tmVKhPVhraPxYkw67YmF2+F9diSqVJ9phTFXMoOFais4tftfcPQ
XfXRbnl/ubbbG3iej+y8B0P0uA7naZ9SALX80MlXMcN1hmExbCsm89pVSt5u
MGKJYkZAIzt/kay+lEmWnYfSs1B8kkzt1F7ytb0bYPNKgjl/NsycCgXjSJZ9
hlDrbNMb3u9J7eAfneElEWd7aNgW6rI+a3NjaIVEW0JKaZOoJpXrVUS14qvr
AVX9qhTtjmtevVJuCtbz0cG8PxvxZcJHEmSCa84TQazhjaxCKeOdXMlGi9gm
T1yCkxdZjhehSHqCVDVyPEe9s+gYnD0IJ3fDoa2wZz310VULYdEcmD0dvpwI
I8fAoOHw8WDo3I9otugJzbvBa10osDXqSEAbtqNGW4+BejmKZo6jUZek/aqU
F7OyyFaf7Iu4W870j7rqCxNcwkUsTWEF17FAXKshbuJS3qY5ohL3WRyPoy9e
otBxlisb3bFYSxLzWsk5qm/sIGiTp/fDiV1wcAvsWgebVsCaxbBkLsyZSWkO
tfn5SOg/DHoOopzSmuX5Vnfyzlc6U2Z5jhX6JDOto0WaY2nU7jlEmEKgS7eq
65E/kq4P1rX8x40mFzhQLWWu0P4YcNUVLvo0RY5N2EZrVFrIKr3Avae0hAu+
iN3zDNW80upeOLoDDmyGnWsV4GXfkpNix57AisUFxadDqTNhzGn9CXzQC97O
hze6QtPO1KKe76gw12dvRenW5ljo5Vqc/bSKjhIZPfKGOBXHvaabia/IXP+L
62RJtUfSNL/bJL3wVGbS2kiNE5iWtNXSsfiB4X1EW6uoGTPQ2bIQ8hKMjIwc
bRbtAXsWOi22rRO74cg22P+9pr4Els0jy501nVrY2AJS9sDP4ZMh0G0AdOyr
xI3gsZ1heHo5T+n76faBZygfVs6Ro5zDZe9nYq/zoyIaujKdreppi6b8T67r
1xXQYhXfhd0iylo8I9C2xo1Z6mAZHNK4j0smQPO4BIWXqJ+dLwuJnCwERX5W
uUjRUTh3EE7vg+O74PBW2MfQMTGsXQLfzYMFX1P8mjYZxo+HUWPgsy+g/2fQ
axB0HQAd+kIrFHxPSvfN2KhfyaPO9zyHCfQVzBMNtOwFfVLWRy1VSuM+2BJy
9TykZB7kH1HSVwhiXScL6gnl2fyaxhMGsvQ1xZndw+EsHmJkjTZiUB+IoBZx
Y4ot1OmhOEy7TNofu8qFY2TbKHEMuBjOsA/u3Qg71sCm5bBuCYVd7IbfzIQZ
U6ghjh0Hw0dRT0SHQRfHkNHhU2beC97pQczRy8VnXugYyN1gF8Wn2deVn2vy
Xo7m7pAlYsmYVUG2xN3n0btWvHorNHBj1wY4NkMxbVvbYiVi3ba8lYGzodgK
LwpjV7Zynp3lDDmL0vkhbpi7ydKxZ2KY276G/GXdUlixABZ/Q8b+1TRqnuMn
kLej2gcMg95DoMdAyiTtEX5vhp8PzbuTyWPUa8Kab8Sax9WI4t8GnQTx+8i/
ElKupJ3eokP69mPWDtmSdq+ycOd8OiNgbR7bSiKMS+MZi4vY0i6KqpvDHSUS
sRMtcOycp9hR0Maxee4Jk8aMMm82+cp0lvmYAlr9DhlBCxNcA3cfSHmlvVY6
rocxtYixo8EYsYvHNLQ8pm5r1V213kNOQ4rnCC6/hPj3YGRL370eytdrno5y
d8xkh+UnsfJ2XOWsTV/QSxLU9FViOcv2Ih2UdX5mP5zaA8d3wuFttJDevZ4m
YDNPwMoFdMkBjR1zIsaYSV/S6hq9fdhIspq+QymBdx9Ac4CLbZyDD605eI0N
BwP5izqTO55Tm6dB6951HL0SCRz+slj+cZ3WrRO+Kthog459mywTCTReqiLg
3kysL1EcPFWO0iO4ywrJzQNbsfSOznJsBzVRTC5IfNtqsvX1S2mRg6lx4RyY
+xX7y2TKjqT60aR6tBhcQaK/d+1PIdKB/ia7vDEao33xGok2Rv5prgBaa1ZW
inevccS7jX59iZnmbLLtgmXrI0uvtpGt6YRR5do0z2ayDgcot8dSYyAsYWmS
uOgmD9lBV8owmOAih5iyilctoniC3RI9G5eP6CQi5JEsZEzlaCbi3F001pYf
K6xv56vmaSzlxY4UW0TO6Co+6tlLCtywoumqiK+vjlTAVl7lus75La98Ksdo
VfuC5yNf74p9FmGTpUmv2h5OW4Q9Hxl7f82Ssq1czH7oFSfZK9CsD26mC0YG
9HoD+huYNwvmzKCrHtgfJ0yAMWPhi9HUIjGIi2nkM2uM4217Qytm3UKzxl75
qlhHRMUSFOvzhRIjZM/ny+m1tXmznt1s4b43QnjHvhMjtS1M2vMRNHOuvz/C
2bHhWDEXlZVHukxWNOIR3BNxXYOufPYABe2Tuyn6HebOuFfD3sywVy+C5fMp
ieBiB2MgmsXUydQicTGPDo2rHvQLXNL3GUoZHE0aUwlGQuRttC3ZRKxaXEM6
5vMdlLzFOHwUt5djlqSIXBJ6law5u59QkCtWSsiKsHfV3jKVL2IYX3KDhs3Y
85GyV0sgl8dZvFhbR5GgZlGje5zYpRwZeyDGPVzZbF1FprxhKaxZRHF7CXdC
9OVZ7CGTv6SFDkp7BEt7kLYRdOduEdotega0xaOVmWjgKHDxk4Zhjde1NR5c
s6bM4qY6N2cI+7h3JnrX7ioJ/Fm6XSZh0yWQOG2zi9S6YDW/8rBbXiIKLzxE
jZAUznZydDv59v5NFP9C5BdTCFzKHRHd+2s2lamTYOIEpXNc9AwdoXwFAyF6
eDfOIwi/TQT+m9rJm+YFPVLUbkfy+pxQPB/17iVF8bX5RlcBXMruLAj1G8F6
j9tNP55zrI0wah9Be7XiURszOU5LGePcp/cqPyHz3kLJQ2hvi9DGXkkWzq6C
C/pJE5XU0cWlY6KxfMpGjsAxi+T1hfZ9LOA94N18lUje0Emwie6ejSyHMYI3
F15MGxXNJ43maW3ksI57RVS9+9/9jEDlctB7PsL3cqL4fdI5ovcRvJcwEc9j
9o8Ke1q0S8s0Rs4GE1L6ATizjz1GUp/0Tg5+O4zYlxF+DNwY/xZpUzdOg020
oCCkdzQbjIJo7fkDVGyxZ+D9nmoGmukZEMvBOG5Ur9qqnoQGWvi0GvVyjO7r
6KCYHX33vcycdFIOd89H8l4VidSZZM8Ok6ScclEZu691X9thH+MyRvqmle6h
gHiULV6iC+FfE+Bfu5hercEAgz1VjB7D4gy2my/DBUBJHB1H2333imZATJ98
J1wGz4UbLS5QxX1MJdB1ASqFRB19qSvi8u4ssNo9912yPHeVDH97RYP4feTv
I30v4aTE3KjvGP0/ThfBL/Atg/1IcDRmbxyI4uN2up5FnRanYZ07Dat4GqTf
iuuTD4ULYcQo6rrGitD7e+qY05EjfGgmOFw2NzNhGZIqB50ybU/yfJyLJE6D
u/J007wwv015Pr9fgESePGZdHyHGXsKo3PORs1dFXXWVRU+kl4a0HsvZWE1E
7rikl0SDZi+tVfJjJtQLteXPmkaeM4V77LhxSvQYJ23bEePv1p9pf8q0Pwlo
y7KpuWX/ynwi0jexXoBT0vTrZ8vb/fwDr/7JzpP2uod1nXLaqSTGnCAxhojX
KYsQL2Pikh6D3iritturBf2gQN9A0Lcj9JUa+hKCjtFd+qwYvXIabrUTxtPL
FrbEcdkvZkN2zw3XcG9dEXfbchyhi+t4CZJ6AtHbdJ3rvFH6P4/zoVwh7zi6
aD0h6Cukn7R9xUf8Xro0Ql+6qy15CfHiLpgmpcdKxKEJWE2vIMsErFtCaycM
9NhpZfmEVq88ZjJ5TFT4gz4P2YzMgaTM6By8k8H2pfcG8m8far9o/pF3rrpX
3IV87OeRKwnwDF00YezF84spyzhenrQ9hpnXdmwm6Kq26G2nMabO0aZC7GLt
4jczpgRN1kh/2BfUZ5XlcNY0rRbjZlbkI8Zjgs+zugAQvnyWzr3aKFe73M9B
iRM5ys41Lm4bOZOmxIJ0ZVnEKyMfIXv1lLFYbh5V9/mjcP6wjo8Re0FPx/aJ
KWbPesrwSFocZqMhvSAgjc4uJoOrp3iNh33mY72S6tKPco0N+6M42FG3kbba
yFpe8bvIMnH+leqd8v5eV79uBi9h3Sq/SJBfsGV4PmL16jpUS22q3CaNfk0u
V7YRBrtbg90SBosZPWiZ6N5iHlNV13RVzGnR+IfxcJtt297xbDGvGCcPXCR8
3QC1zO/bCd7zqlednvtJO3ETiXcm4WlnuKicIRUs5Fm0jNdroHphUUSy4Y4Y
8mRpiuIPvOwkW96q+6LF1xbuGs136VzVHY05i0tMkgw4DkaPhZGjaT0kPdIY
hW3RnfupWG4Qo1d80FMtUN/uHjRLY9SvhBG77yjGO7LOuSOObk5hxAaYatKm
yqrNCRxXxwwfwepeV+K4QVS32hCOiyFsV8sa7HgG7bawdB20C2ZrAw7bgq1e
1f20M0jyExtWISRM9yObro4iITPW/iCfd7Be3xSqd8ZQ1dXvdq5ETPU7vcs1
VWlfWqFEUhQqDmCslZsYkdyglugxJHWEcwz2q2mBD2CQc3QqDc1YwceDyGaz
h6k6m2W218ZS/I1yU35PgyYXqWyfKjtZZq4gKXp1MtW3yVxRHUoEkOSlLJRT
AAFc50px/RK60iEZWDrUwq/JSEOFPpkKXZqUUqPdp7jWKY6xnapWxbkAU3E5
DJ2GhRXPr7n4pqp/G652esxcd5DKZWoJU7eeYaaWCLG1K9i0LUrbkbWwJCcJ
rKrz6PCEK7UQtqUKm0Qo6T/ij3NmBEVsS2+Mlp5kqUG8WJY6Ni6JizhsROWR
s1q9eGXker58PvE/ouyoUecE6UfeOIcZCNlxr64TtJMM9RpSnIlC3FSCktXm
pwJRhfS4e0t3EQuUZCSFiyswW3eSj0yPIYBDVUTqOZAuvhmAkpLa9KbXZAOA
Vj9nbgmjtbsieUjnce65qaA3cHvwuD/8PWNpam+T6y1udXLAMfZGjUKHR8Vq
VYiVXBlYoZMOtQvO62hydo1ix5C8U1AQ+NwwbhoSJ6VMVaK0+kancnGRq5GQ
eD0kfwsqzEm5F2fppA0pxCgbPZmQEq5GMTHTT8vBtNrqqqYXiJXZNUnreonc
WlXDR6qOgOFwgFWWvcJNIROpq5WW5HMt91iOT+ZkemFu4OYWDsx6J8F7OCSb
w2HZhEssMKhwxNhePhLt7sqmrA5pDD4Qj87LIh5TayZ05Gubj6VSQ2lGPkd5
b1QzdkL4u2M6tEYoVyfnbNe2y0lHWjFuCQzIJSSV7zJw0QZkkgMW1TRdVOjg
IbXo/DAoUlc2mjxJEYzmCkWE3TryN6k4WRGLy10D1iIpYRbFFgsfYXgPhGxY
l41ZPgVObOHYzhcdY3Es191MIuk87TGzplnFYwVToxRx5SHD1eKqr4R/DASD
g/oRY+bXm4nEzUzi97HrIqLAINBZzoJXM7DXaCO33MM2WVUtxkBsn9VBaHtU
GLKoXBgmoW0EWzs1J10zmbSBDT5aNo6Z6Pcm/5QpuH9LjK9s1AziS4ZyiNpE
TEVYTmH6sVrqxY1dRUHpNGKhYb+Qugh6c6wQtJE6pVFZzT1fNeO/Jkk+ya/a
PhQMMtpCnQkOS91Uvu2I5YxT1gySPkyrsOvfCH46L3LNSqzAmWbHHXmouWqE
8vfC/ujMK19ReTDW19REcgsUa4uK2LhbqBHqMW5eoca4wR5jrMdZHTEkZR21
1HSOtqZzuFzTp7HJ37X7T2ds/FrY/RXMmaVNuy6VQ3Ejk96ups0Z0uLQkNzq
NAqNWJUzczwSOnX5y5bu38PjK7t3m7KyZyOkOB1LbH8tb0Kssw95i6mvGers
je7sOUkp+vIXS/9L1Q6/e+eO05FTPGoVhTE+1QJ0Hs90iqFGoCNDUBq2bCaJ
pum85G/Dun+3z331iP39FtOdHGsK+jVfiIqeXdCmooXL/qw1ynPq/TluZt2f
q2V5VPk7Yvhk3qv3F2df7rsIb1Vn8hBv/d/Oo+7r9zeqrWvy1g9B8Oql+658
2uox3urhOHdx3ttMP9bmrf8W12Osn6urfdfjrWs6j8Z95pa2bshbPxI3y85o
aetneOtH1ejcrVLqfBvxVo9ZjzZVH+KhfbzEj9LfOaRI+Qr/5P3k/wCX91Sm
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28908344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324245119],

Cell["Use a thick red boundary:", "ExampleText",
 CellID->266495939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Red"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2042761571],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8265383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5886106],

Cell[TextData[{
 "Boundaries are drawn where the surface is clipped by ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->240428955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "\[Theta]"}], "}"}], 
      ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"3", "t"}], "]"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"3", "\[Theta]"}], "]"}]}], ">", "0"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1407245809],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94991340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143580316],

Cell[TextData[{
 "Boundaries are not drawn where the surface is clipped by ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10484720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", " ", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "\[Theta]"}], "]"}], "^", "5"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "5"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1543211221],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16613756]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxRatios",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->263378493],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["BoxRatios",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxRatios"]], "InlineFormula"],
 " preserve the ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " used by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->688234545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "Front"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->811075073],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282766375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260195860],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["BoxRatios",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxRatios"]], "InlineFormula"],
 " preserve the revolved circles:"
}], "ExampleText",
 CellID->42196339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", 
      RowBox[{"Pi", "/", "3"}]}]}], "}"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Top"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1476928767],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116633596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183724593],

Cell[TextData[{
 "Use specific ",
 Cell[BoxData[
  ButtonBox["BoxRatios",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxRatios"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->868917321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", 
      RowBox[{"Pi", "/", "3"}]}]}], "}"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1004614447],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557165794]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->496022519],

Cell[TextData[{
 "Color a surface by ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " parameters:"
}], "ExampleText",
 CellID->1734711881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RevolutionPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "x", ",", "y", ",", "z", ",", "t", ",", "\[Theta]", ",", "r"}], 
         "}"}], ",", 
        RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}], ",", 
       RowBox[{"Hue", "[", "z", "]"}], ",", 
       RowBox[{"Hue", "[", "t", "]"}], ",", 
       RowBox[{"Hue", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Hue", "[", "r", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698865991],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 267},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->185629835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133437816],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " for predefined color gradients:"
}], "ExampleText",
 CellID->164913451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"3", 
      RowBox[{"Pi", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "\[Theta]", ",", "r"}],
        "}"}], ",", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "r", "]"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1523343760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydfAVYFU3793mNp9THR0Glke7uBkmpQzdKS4ogiHQKSImigEqKIqIoYiCI
gQKCIt2IhGB3K871fTOzexCP+MafC5bZ2dnZmd/d98yuiWuIt2eAa4iPu+t6
/WDXbd4+7tvX6wUGw6rF/6JQKOfh3y4mCiz/P1jCf+cBAPDCvGMwOi6G1wD+
oWj8m9pt8LgEVmrOndHawCNFC/8PgsdFvzhbuNdYeESV0vgsmrxjEW7r6elJ
PmAF3b3rcWt7ckTsZB9LaHeRY1r4Lge6kbOSz/yd7u6lZO+LyP9cuN6Rrs91
5LP/RCdLvo+YQvmL7jnc+L8T3f2MP8z4ez0ezVJiNGQV2eeiX/a16gcc/re+
7PH4v99DofxD9kZZTJyj49/zMEJF+lH/8UvE0ZNWkv/X0CGNbhDFZW8S67X/
4TnCuLUX2R8LXevFdK2FcGttsjUHOS82urvoURPEd234CRcW8n76MS00CvQ8
4V/0wzQf/3n3LaXrV+AX96/5xTg46fr7je46/y/6YyDHQ//8/2t/C/EP/wJz
RW0EfqAQjU9E6Vr/TvdkxMHokevw3ebkmRjdXfQ8SS+XxN1i4EddIkXXy590
vSwm29PzGuZcijjdM2g6Zj4W9E/4g2xDr7WwtGCEliwg2zT9I0/X21/g17P+
3qskXS0j2ZsiXW/L6Nr99hO11y3YH00j0aMk9x/6/53EgmmONj/zFqpQW4BK
S+Z0mjj4kZ820LVeTvdUzOkUVXLMOv9Vaxa6WnbyWfp0d9NTlWPBu2m6ZeO/
eTZiI+LZDORsaVyFftCzmcF3+VlM8vT83v5eYMwk1nRygU754H9mEvP5vayk
6wXr07ln0ziJnvKctDEvteBfacW30pprpQ3XSluulZS/ca0H3ypPgdVegqu9
RBi8pBgpS2ElkgxkWmkahf2HJ60ma3kATd9Quf4m0cDnf1izrLBhWWHLvMKO
aQU8t1+7woFxhSPDikVODCsofzozrti05u/Na/52Wfu367q/XZlWujGtdGde
6cGykrLIk/Ufyl9e7P9QaD8+gqvh0VeGER491NaS+hfBsuQ/4LN0HjI/U37F
vFlgTfGXKe/fpuwriKdS1yw3Y1huzrDcYvVyy1XLrVYtX4eql2xZu9Kb+R8f
tn981q/CaCMHhO6Z/25MmDo/WQEKtn2LSTnCo/nNhIMcisna5aYMy6j/LPsd
j2D0nvXImM3wfZvhcVuCghMPHSZm7Cen7eDJ5H0r3D0e12/+7Kv8OVcR3WyV
WUOh/DS+f+jGt+gX4+P7iebG65YbMy4zWbUMN6f8NjFAvT9ofm/YYnjEcnDE
qm/UGnES5ffOCafOSeeOqc3wpOOBS+eMS9eMK2VR90NXytKeR669j1z7H7sM
PnEZfuqCeY+ydPKx44NH9p74Z3LEnKhdHLDun61sq2g8tngBCUO4LfnF+LlJ
KZij9mIjxmXGcPDoHgLFPtOxAbPhQQt40jdMoEhZ1zricGvEsWXUqWXUufne
pqYxl6b7rjfH3eC1pimPlgcet6Y92x563n7kdeexV/tjr7tPvDqfenU/8+x9
7tn/Avmmwy898EDxU5c+eOQw/cD2wX3L8UGzsU4jYm5Ltq1HPB4kxkiZ54nP
56ClczMidQW9D7IK168nZ8dHm+VSI4Zlc5L0onMj1laUJXCuo/3UoQHzvkFL
TE2mpn67GwP2jQOO1wacrgw4NwxuvjzoUj/kWj/sVjfiXj/qUT/mBdtdnvBu
mPS+OuVzbdqnccb3xiPfpsd+zU/9bj3za3vud+eFH+a7pX2vfQbfeI+83XLv
jef91+4Ucu5PnWYe2T+YtIFEvd9jQsz9t22sq+ZGCIcN71/1Ew0Xni07SVPe
77NdTc72bZveyw7abCf7TUf6zAb6zXsGLAlJb+qzvdaDxKW+2/FSj9PFHucL
PZvP9bqc7XWt7nX/myY/fzW/2gbLt98E3n27tettQO87/4F3fsPvfEbRzDww
cr/PPHF4MGUDS/c6jeGx65JWS4UKoQcXB3MiuqKu/iHHSPNRCZ1E81LofYz1
NJ39x4dmnXd3DV52G8KT6QHTsX5qf795Vz8xjz8au20aOm1r79qda7eH56fb
nU61b6ps34zvXXa8e0tFj3dFn29Fv3/F4FZYVTm87eTotlP3gqruB5+ZCCa1
V+3jkLqnoZef7yAo8kf7+6DO99t6P2wd+BAw+N535J332FvPybfuhNxMP7Kf
GrcaH6AS6C6+c1a9sVQR8yQxZ5ZVZKCx4ic6Et4FE/jug2Kclny6qAn/fbqt
965rI+5l+dQgdXTAvKfP4nYPEshrHVZ17dbnb9ueabU9dcu+osXhWIsTvnd5
8S23olaPotteRXe8i+/6FHf4FXcGlHQHlvQg2pX2by8bDMHzXFY5HnZycmfV
g/DqmfCaRxHnn0TABnUvIi6/Cr/6emfj2zCCaks7PwX3ftrW93Hr0Af/0Q8+
pE2beeY4PW07OWoxDlmXQumpg3RWvpwnS1D61xqf8Pv+AAvHDjT/H/1HNuBP
3NvEkNlgv3lHjzmB6W+XblvV3LKuarapuGF79IZdaaMDMff8RtfcRvfcG565
TVtym31yb/nltfrntW3Nu7Mtrz04r2M7eiKa+6rCgfDioYjS0cgjY1FHx6PL
J6MrHsRUzsScehQL25x9Fnv+RUzty5j619FX3kY2voto+hBOPrvzS0jPl2Ck
yD75j330mfxAaLK/Hj5xmJ6wnuinIqaHYBxHYMByRbgwqe0WRmIhv/5HLpmT
BpKP5rTZnw8Tpb+eUf92ZQM8+dJp8KHPCBYeDlHvDZgRVPqtrs3yXIvVqZvW
5ddtSq7YFlyxI/jpQMOmfZddsi+7wpOsBs+sq1uyrvlkNfpl3QjIagrc0xy0
p2U7IuJvqPXKwnvxxfcTSicSyqYSj00nIcl5nFT1NLH6eeK5Vwm1r+Pr38Ze
eR/T+CG66VMkgdOqrq+hfV+Dh74E3vvsN/HJ+8EHDzS2p47fQbqk1VyuXJ/7
HSR8J81yEXEMLfdB78X9jBJdDeyOlyZPf82eVv92FYE022nwqR+DNGg62kft
6ja71WFOaMXTNy2PX7cqbbA+VGeDa5btrXXMuuiccXFz2gWX1AvIxKXUbkmp
80mu90tuCKCxOYFzxp2YrLuxe7ri9vbE5/Ql7h9Mwt7Jn+VPUk88S6l6kVz9
Kvn8m6Tat4n17xOufoy78SmGoNA/vbMhg1+DRr8EjH/2ffDBcx5IpnMg1R2Q
geXjO4XJ59H7zwz/JSfRtC29TaXZSQrLi2TZbzSwvnUYfMFgPR4yHesz7ek2
a7lrBk+rb5ifuGYJC4cvWR04bw0LmWft0s86pFY7JVdvSjqzOeGMa1y1R+xZ
r0UkRhSGuMsh8VfCEq5FJN6ISmqKgfXJrQmptxPT2pPSO5Mzu1P29KbuHdi9
byh9/2hG3v1M1PtUVtF0JoESa+WLtKpXu6vfpJ5/m3Lp/S5Ydf1zfNOX2LbZ
SKR8vu0YmA0e/bp14rPvFA3DB3MY1mo1HVOu248wPLZDCI4nbSMbZaFI93/F
kd7rYqdx3D+vkxFbf7uMcAQdBrP9Rh+GkZoc7zPt7aa2Ejg2mpVfNiu8aJ57
zoKwXymnbHadtEs46RBX6RRTuSnyhEtEpRsNQ+bws4Hh54IiLoRE1IZF1kVE
XY6Ovhobcz0BNohvTk64lZLUtju5PS2lI313d2Z6b1bmQPaeob17R/fBBrkT
OflT+w5P7yt6uLf0STaB6sqqNxln36Uhrf8x+ernxBtf42/NRsPT7m9hc3jO
8SSF8LeJDGOaIXuSBgsa9bIfLPh/jx3SakgX46iNFXGZhxg8viOAq9UCLbro
tn7Dzxi4qQHT/m7qbQzcWQhcHbXgvFnOGXSafAIxY2y5bdQx+4ijjmFHnUPL
NhOYcQZX+MJr208Gbj8VFHImJORsWOi5iNAL0Ttq43bWJ4Q37Iq4lgobRDel
x97Kimvbk9CendSxL7k7J7X3wO6B3PShPHg1eyw/ZyIvdyovfzr38MMDRU/2
lz7LOfpiH6HpmM+8yzz3If3Sp9SGz8mNXxNbZmPpIfyIIXxsPzVqcb8DSVTr
SdWGg3KwcCJKhAA0y5wjUZ0Z90gf59N04LI5y4la/QYW9pXoIxrsY7DA609c
ROHxQwp6LLioBW7qEPh+HUZ+2qNB0+Ee0/YOpJnPNVKP11MP15juq0KnicfM
o0sRxGEltiHF9sFFjtiG8gQUuweUegUc8Qk46h9wLBA2CKgI2