(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42819,       1577]
NotebookOptionsPosition[     34721,       1294]
NotebookOutlinePosition[     36202,       1333]
CellTagsIndexPosition[     36116,       1328]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingLists"], 
          "Partitioning and Padding Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningAndPaddingLists"], 
          "Grouping and Combining Elements of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GroupingAndCombiningElementsOfLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rearranging Lists\"\>", 
       2->"\<\"Partitioning and Padding Lists\"\>", 
       3->"\<\"Grouping and Combining Elements of Lists\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Insert" :> Documentation`HelpLookup["paclet:ref/Insert"], 
          "Take" :> Documentation`HelpLookup["paclet:ref/Take"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Insert\"\>", 2->"\<\"Take\"\>", 
       3->"\<\"PadLeft\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"List Manipulation\"\>", 
       3->"\<\"Rearranging & Restructuring Lists\"\>", 
       4->"\<\"New in 6.0: Core Language\"\>", 
       5->"\<\"New in 6.0: List Manipulation\"\>", 
       6->"\<\"New in 6.0: Numerical Data Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Riffle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Riffle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Riffle"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Riffle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Riffle"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Riffle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Riffle"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a list in which every ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
     " element is ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Riffle",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Riffle"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a list in which ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " appears if possible at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{Cell[BoxData[
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]]], "InlineFormula"], "+", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], "+", 
       RowBox[{"2", 
        StyleBox["n", "TI"]}]}]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If there are fewer ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " than gaps between ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are used cyclically. "
}], "Notes",
 CellID->240],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["e", "TI"], "}"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["e", "TI"], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23923],

Cell[TextData[{
 "The specification ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["max", "TI"]], ",", 
    StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
 " is of the type used in ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 ". Negative indices count from the end of the list. "
}], "Notes",
 CellID->26066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7536],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      RowBox[{"-", "1"}], ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Riffle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Riffle"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->17231]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->517960012],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->127695951],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]Riffle",
 "\[CloseCurlyDoubleQuote]",
 " ",
 Cell[BoxData["x"], "InlineFormula"],
 " between successive elements in a list:"
}], "ExampleText",
 CellID->27149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "x", ",", "2", ",", "x", ",", "3", ",", "x", ",", "4", ",", "x", 
   ",", "5", ",", "x", ",", "6", ",", "x", ",", "7", ",", "x", ",", "8", ",", 
   "x", ",", "9"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31249],

Cell[TextData[{
 "Riffle in ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " cyclically:"
}], "ExampleText",
 CellID->3792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "x", ",", "2", ",", "y", ",", "3", ",", "x", ",", "4", ",", "y", 
   ",", "5", ",", "x", ",", "6", ",", "y", ",", "7", ",", "x", ",", "8", ",", 
   "y", ",", "9"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6861],

Cell[TextData[{
 "Riffle in ",
 Cell[BoxData["x"], "InlineFormula"],
 " at every third position:"
}], "ExampleText",
 CellID->12742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "x", ",", "3", ",", "4", ",", "x", ",", "5", ",", "6", 
   ",", "x", ",", "7", ",", "8", ",", "x", ",", "9"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->984917663]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4455],

Cell[TextData[{
 "Riffle in ",
 Cell[BoxData["x"], "InlineFormula"],
 " at every other position:"
}], "ExampleText",
 CellID->30188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "x", ",", "2", ",", "x", ",", "3", ",", "x", ",", "4", ",", "x", 
   ",", "5", ",", "x", ",", "6", ",", "x", ",", "7", ",", "x", ",", "8", ",", 
   "x", ",", "9"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11380]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "x", ",", "2", ",", "x", ",", "3", ",", "x", ",", "4", ",", "x", 
   ",", "5", ",", "x", ",", "6", ",", "x", ",", "7", ",", "x", ",", "8", ",", 
   "x", ",", "9"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13339],

Cell[TextData[{
 "Include ",
 Cell[BoxData["x"], "InlineFormula"],
 " at the beginning and end:"
}], "ExampleText",
 CellID->29553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "1", ",", "x", ",", "2", ",", "x", ",", "3", ",", "x", ",", "4", 
   ",", "x", ",", "5", ",", "x", ",", "6", ",", "x", ",", "7", ",", "x", ",", 
   "8", ",", "x", ",", "9", ",", "x"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59],

Cell["Use step 3:", "ExampleText",
 CellID->3773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4345],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "1", ",", "2", ",", "x", ",", "3", ",", "4", ",", "x", ",", "5", 
   ",", "6", ",", "x", ",", "7", ",", "8", ",", "x", ",", "9"}], 
  "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18770],

Cell[TextData[{
 "Starting riffling in ",
 Cell[BoxData["x"], "InlineFormula"],
 " only at position 5:"
}], "ExampleText",
 CellID->31186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "x", ",", "5", ",", "x", ",", "6", 
   ",", "x", ",", "7", ",", "x", ",", "8", ",", "x", ",", "9", ",", "x"}], 
  "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8756],

Cell[TextData[{
 "Cyclically riffle in ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "x", ",", "5", ",", "y", ",", "6", 
   ",", "x", ",", "7", ",", "y", ",", "8", ",", "x", ",", "9", ",", "y"}], 
  "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26991],

Cell["Intersperse two lists:", "ExampleText",
 CellID->24715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "b", ",", "y", ",", "c", ",", "z", ",", "d"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10437],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Riffle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Riffle"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->7384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"5", "->", "1"}], ",", "10"}], "]"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->17532],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "x", ",", "0", ",", "x", ",", "0", ",", "x", ",", "0", ",", "x", 
   ",", "1", ",", "x", ",", "0", ",", "x", ",", "0", ",", "x", ",", "0", ",", 
   "x", ",", "0", ",", "x", ",", "0"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26212]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21281],

Cell["Insert spaces between words:", "ExampleText",
 CellID->17725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\"\<this\>\"", ",", "\"\<is\>\"", ",", "\"\<an\>\"", ",", 
      "\"\<example\>\""}], "}"}], ",", "\"\< \>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11583],

Cell[BoxData["\<\"this is an example\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27834],

Cell["Create a directory name from a path list:", "ExampleText",
 CellID->23172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<usr\>\"", ",", "\"\<local\>\"", ",", "\"\<bin\>\""}], "}"}],
     ",", "\"\</\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3191],

Cell[BoxData["\<\"usr/local/bin\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17020],

Cell["Insert 0s between successive integers:", "ExampleText",
 CellID->10597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "2", ",", "0", ",", "3", ",", "0", ",", "4", ",", "0", 
   ",", "5", ",", "0", ",", "6", ",", "0", ",", "7", ",", "0", ",", "8", ",", 
   "0", ",", "9", ",", "0", ",", "10"}], "}"}]], "Output",
 ImageSize->{360, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18230],

Cell["Alternate positive and negative integers:", "ExampleText",
 CellID->4428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"Range", "[", "10", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "2", ",", 
   RowBox[{"-", "2"}], ",", "3", ",", 
   RowBox[{"-", "3"}], ",", "4", ",", 
   RowBox[{"-", "4"}], ",", "5", ",", 
   RowBox[{"-", "5"}], ",", "6", ",", 
   RowBox[{"-", "6"}], ",", "7", ",", 
   RowBox[{"-", "7"}], ",", "8", ",", 
   RowBox[{"-", "8"}], ",", "9", ",", 
   RowBox[{"-", "9"}], ",", "10"}], "}"}]], "Output",
 ImageSize->{429, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16793],

Cell["Insert commas at every 4th character:", "ExampleText",
 CellID->26348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"Characters", "[", "\"\<4345252523535\>\"", "]"}], ",", 
    "\"\<,\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "1", ",", 
      RowBox[{"-", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28138],

Cell[BoxData["\<\"4,345,252,523,535\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22743],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Riffle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Riffle"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "b", ",", "x", ",", "c", ",", "x", ",", "d"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "x", ",", "b", ",", "x", ",", "c", ",", "x", ",", "d", ",", "x"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27496]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4693],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7998],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "Tutorials",
 CellID->8707],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "Tutorials",
 CellID->16128],

Cell[TextData[ButtonBox["Grouping and Combining Elements of Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GroupingAndCombiningElementsOfLists"]], "Tutorials",
 CellID->2880]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Riffle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Riffle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->10219877],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->194869842],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->182349831],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->30087764],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->1664687],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->320655894],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->31921719]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Riffle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 17, 45.8968408}", "context" -> "System`", 
    "keywords" -> {"interleave"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Riffle[{e_1, e_2, ...}, x] gives {e_1, x, e_2, x, ...}. Riffle[{e_1, \
e_2, ...}, {x_1, x_2, ...}] gives {e_1, x_1, e_2, x_2, ...}. Riffle[list, x, \
n] yields a list in which every n\\[Null]^th element is x. Riffle[list, x, \
{i_min, i_max, n}] yields a list in which x appears if possible at positions \
i_min, i_min + n, i_min + 2 n, ... , i_max. ", "synonyms" -> {}, "title" -> 
    "Riffle", "type" -> "Symbol", "uri" -> "ref/Riffle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14095, 468, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->517960012]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35972, 1321}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3230, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3853, 100, 1571, 37, 70, "ObjectNameGrid"],
Cell[5427, 139, 4531, 153, 70, "Usage",
 CellID->26985]
}, Open  ]],
Cell[CellGroupData[{
Cell[9995, 297, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10473, 314, 1090, 43, 70, "Notes",
 CellID->240],
Cell[11566, 359, 380, 16, 70, "Notes",
 CellID->23923],
Cell[11949, 377, 518, 19, 70, "Notes",
 CellID->26066],
Cell[12470, 398, 595, 23, 70, "Notes",
 CellID->7536],
Cell[13068, 423, 672, 26, 70, "Notes",
 CellID->17692],
Cell[13743, 451, 315, 12, 70, "Notes",
 CellID->17231]
}, Closed]],
Cell[CellGroupData[{
Cell[14095, 468, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->517960012],
Cell[CellGroupData[{
Cell[14480, 482, 148, 5, 70, "ExampleSection",
 CellID->127695951],
Cell[14631, 489, 200, 7, 70, "ExampleText",
 CellID->27149],
Cell[CellGroupData[{
Cell[14856, 500, 251, 8, 28, "Input",
 CellID->15065],
Cell[15110, 510, 361, 10, 36, "Output",
 CellID->27534]
}, Open  ]],
Cell[15486, 523, 121, 3, 70, "ExampleDelimiter",
 CellID->31249],
Cell[15610, 528, 166, 7, 70, "ExampleText",
 CellID->3792],
Cell[CellGroupData[{
Cell[15801, 539, 300, 10, 70, "Input",
 CellID->26924],
Cell[16104, 551, 361, 10, 36, "Output",
 CellID->17405]
}, Open  ]],
Cell[16480, 564, 120, 3, 70, "ExampleDelimiter",
 CellID->6861],
Cell[16603, 569, 132, 5, 70, "ExampleText",
 CellID->12742],
Cell[CellGroupData[{
Cell[16760, 578, 261, 8, 70, "Input",
 CellID->26385],
Cell[17024, 588, 321, 9, 36, "Output",
 CellID->984917663]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17394, 603, 215, 7, 70, "ExampleSection",
 CellID->4455],
Cell[17612, 612, 132, 5, 70, "ExampleText",
 CellID->30188],
Cell[CellGroupData[{
Cell[17769, 621, 251, 8, 70, "Input",
 CellID->16044],
Cell[18023, 631, 361, 10, 36, "Output",
 CellID->11380]
}, Open  ]],
Cell[CellGroupData[{
Cell[18421, 646, 341, 11, 70, "Input",
 CellID->19001],
Cell[18765, 659, 361, 10, 36, "Output",
 CellID->15871]
}, Open  ]],
Cell[19141, 672, 121, 3, 70, "ExampleDelimiter",
 CellID->13339],
Cell[19265, 677, 131, 5, 70, "ExampleText",
 CellID->29553],
Cell[CellGroupData[{
Cell[19421, 686, 341, 11, 70, "Input",
 CellID->20129],
Cell[19765, 699, 381, 10, 36, "Output",
 CellID->14056]
}, Open  ]],
Cell[20161, 712, 118, 3, 70, "ExampleDelimiter",
 CellID->59],
Cell[20282, 717, 49, 1, 70, "ExampleText",
 CellID->3773],
Cell[CellGroupData[{
Cell[20356, 722, 340, 11, 70, "Input",
 CellID->4345],
Cell[20699, 735, 330, 10, 36, "Output",
 CellID->31083]
}, Open  ]],
Cell[21044, 748, 121, 3, 70, "ExampleDelimiter",
 CellID->18770],
Cell[21168, 753, 138, 5, 70, "ExampleText",
 CellID->31186],
Cell[CellGroupData[{
Cell[21331, 762, 340, 11, 70, "Input",
 CellID->5090],
Cell[21674, 775, 340, 10, 36, "Output",
 CellID->24178]
}, Open  ]],
Cell[22029, 788, 120, 3, 70, "ExampleDelimiter",
 CellID->8756],
Cell[22152, 793, 167, 7, 70, "ExampleText",
 CellID->25484],
Cell[CellGroupData[{
Cell[22344, 804, 390, 13, 70, "Input",
 CellID->21724],
Cell[22737, 819, 339, 10, 36, "Output",
 CellID->3922]
}, Open  ]],
Cell[23091, 832, 121, 3, 70, "ExampleDelimiter",
 CellID->26991],
Cell[23215, 837, 61, 1, 70, "ExampleText",
 CellID->24715],
Cell[CellGroupData[{
Cell[23301, 842, 259, 8, 70, "Input",
 CellID->17684],
Cell[23563, 852, 253, 8, 36, "Output",
 CellID->27472]
}, Open  ]],
Cell[23831, 863, 121, 3, 70, "ExampleDelimiter",
 CellID->10437],
Cell[23955, 868, 317, 12, 70, "ExampleText",
 CellID->7384],
Cell[CellGroupData[{
Cell[24297, 884, 215, 8, 70, "Input",
 CellID->17532],
Cell[24515, 894, 381, 10, 36, "Output",
 CellID->26212]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24945, 910, 223, 7, 70, "ExampleSection",
 CellID->21281],
Cell[25171, 919, 67, 1, 70, "ExampleText",
 CellID->17725],
Cell[CellGroupData[{
Cell[25263, 924, 294, 9, 70, "Input",
 CellID->11583],
Cell[25560, 935, 180, 5, 36, "Output",
 CellID->32044]
}, Open  ]],
Cell[25755, 943, 121, 3, 70, "ExampleDelimiter",
 CellID->27834],
Cell[25879, 948, 80, 1, 70, "ExampleText",
 CellID->23172],
Cell[CellGroupData[{
Cell[25984, 953, 264, 8, 70, "Input",
 CellID->3191],
Cell[26251, 963, 174, 5, 36, "Output",
 CellID->12952]
}, Open  ]],
Cell[26440, 971, 121, 3, 70, "ExampleDelimiter",
 CellID->17020],
Cell[26564, 976, 77, 1, 70, "ExampleText",
 CellID->10597],
Cell[CellGroupData[{
Cell[26666, 981, 154, 5, 70, "Input",
 CellID->6296],
Cell[26823, 988, 382, 10, 36, "Output",
 CellID->26662]
}, Open  ]],
Cell[27220, 1001, 121, 3, 70, "ExampleDelimiter",
 CellID->18230],
Cell[27344, 1006, 79, 1, 70, "ExampleText",
 CellID->4428],
Cell[CellGroupData[{
Cell[27448, 1011, 209, 7, 70, "Input",
 CellID->19438],
Cell[27660, 1020, 541, 16, 36, "Output",
 CellID->9547]
}, Open  ]],
Cell[28216, 1039, 121, 3, 70, "ExampleDelimiter",
 CellID->16793],
Cell[28340, 1044, 76, 1, 70, "ExampleText",
 CellID->26348],
Cell[CellGroupData[{
Cell[28441, 1049, 346, 11, 70, "Input",
 CellID->28138],
Cell[28790, 1062, 177, 5, 36, "Output",
 CellID->763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29016, 1073, 233, 7, 70, "ExampleSection",
 CellID->22743],
Cell[29252, 1082, 310, 12, 70, "ExampleText",
 CellID->7814],
Cell[CellGroupData[{
Cell[29587, 1098, 192, 7, 70, "Input",
 CellID->9312],
Cell[29782, 1107, 253, 8, 36, "Output",
 CellID->18449]
}, Open  ]],
Cell[CellGroupData[{
Cell[30072, 1120, 333, 11, 70, "Input",
 CellID->20337],
Cell[30408, 1133, 266, 9, 36, "Output",
 CellID->27496]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30735, 1149, 310, 9, 70, "SeeAlsoSection",
 CellID->4693],
Cell[31048, 1160, 682, 26, 70, "SeeAlso",
 CellID->10619]
}, Open  ]],
Cell[CellGroupData[{
Cell[31767, 1191, 313, 9, 70, "TutorialsSection",
 CellID->7998],
Cell[32083, 1202, 143, 3, 70, "Tutorials",
 CellID->8707],
Cell[32229, 1207, 168, 3, 70, "Tutorials",
 CellID->16128],
Cell[32400, 1212, 188, 4, 70, "Tutorials",
 CellID->2880]
}, Open  ]],
Cell[CellGroupData[{
Cell[32625, 1221, 305, 8, 70, "RelatedLinksSection"],
Cell[32933, 1231, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33327, 1248, 318, 9, 70, "MoreAboutSection",
 CellID->10219877],
Cell[33648, 1259, 173, 3, 70, "MoreAbout",
 CellID->194869842],
Cell[33824, 1264, 145, 3, 70, "MoreAbout",
 CellID->182349831],
Cell[33972, 1269, 176, 3, 70, "MoreAbout",
 CellID->30087764],
Cell[34151, 1274, 154, 3, 70, "MoreAbout",
 CellID->1664687],
Cell[34308, 1279, 164, 3, 70, "MoreAbout",
 CellID->320655894],
Cell[34475, 1284, 174, 3, 70, "MoreAbout",
 CellID->31921719]
}, Open  ]],
Cell[34664, 1290, 27, 0, 70, "History"],
Cell[34694, 1292, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

