(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49335,       1795]
NotebookOptionsPosition[     41309,       1522]
NotebookOutlinePosition[     42869,       1562]
CellTagsIndexPosition[     42783,       1557]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Root Isolation" :> 
          Documentation`HelpLookup["paclet:tutorial/RootIsolation"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Root Isolation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Roots" :> Documentation`HelpLookup["paclet:ref/Roots"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Root" :> 
          Documentation`HelpLookup["paclet:ref/Root"], "CountRoots" :> 
          Documentation`HelpLookup["paclet:ref/CountRoots"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], 
          "IsolatingInterval" :> 
          Documentation`HelpLookup["paclet:ref/IsolatingInterval"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Roots\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"Reduce\"\>", 4->"\<\"Root\"\>", 5->"\<\"CountRoots\"\>", 
       6->"\<\"FindRoot\"\>", 
       7->"\<\"IsolatingInterval\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:guide/IntervalArithmetic"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60AlgebraicComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Interval Arithmetic\"\>", 
       2->"\<\"Polynomial Equations\"\>", 
       3->"\<\"New in 6.0: Symbolic Computation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RootIntervals", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootIntervals",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootIntervals"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["poly", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["poly", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of isolating intervals for the real roots \
of any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", together with a list of which polynomials actually have each \
successive root."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootIntervals",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootIntervals"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives isolating intervals for real roots of a single \
polynomial. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootIntervals",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootIntervals"], "[", 
       RowBox[{
        StyleBox["polys", "TI"], ",", 
        ButtonBox["Complexes",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Complexes"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives bounding rectangles for complex roots."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21478]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The coefficients of ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " must be integers or rationals."
}], "Notes",
 CellID->26814],

Cell[TextData[{
 "An isolating interval for a root ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " of a polynomial ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " is an interval where the only root of ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " contained in the interval is ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13787],

Cell["\<\
If a root is real, the isolating interval is an open real interval, or a \
point. If a root is not real, the isolating interval is an open rectangle, \
disjoint from the real axis. \
\>", "Notes",
 CellID->5045],

Cell[TextData[{
 "Multiple roots give multiple entries in the second list generated by ",
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1376342]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53412546],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->11288036],

Cell["\<\
Get isolating intervals, together with a list of which polynomial has which \
root:\
\>", "ExampleText",
 CellID->81330507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "-", "10"}], ",", 
    RowBox[{"x", "-", "20"}], ",", 
    RowBox[{"x", "-", "10"}], ",", 
    RowBox[{"x", "-", "30"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18699903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "31"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337235435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20206060],

Cell["\<\
The isolating intervals are always specified by exact rationals:\
\>", "ExampleText",
 CellID->216268437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "200"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "201"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180546937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["369", "128"], ",", 
       FractionBox["2955", "1024"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["2955", "1024"], ",", 
       FractionBox["1479", "512"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{294, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->668226492]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->136228846],

Cell["Isolate the real roots of a polynomial:", "ExampleText",
 CellID->66814597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", "2"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", "3"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16268516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["5", "4"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["5", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["3", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{421, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17933408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13383273],

Cell["Isolate the real roots of a list of polynomials:", "ExampleText",
 CellID->514816060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", "2"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", "3"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->586343835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["77", "64"]}], ",", 
       RowBox[{"-", 
        FractionBox["153", "128"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["153", "128"]}], ",", 
       RowBox[{"-", 
        FractionBox["19", "16"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["19", "16"], ",", 
       FractionBox["153", "128"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["153", "128"], ",", 
       FractionBox["77", "64"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["3", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{503, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->764679204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->526804269],

Cell["Isolate the complex roots of a polynomial:", "ExampleText",
 CellID->70894114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "2"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700035452],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        FractionBox[
         RowBox[{"9", " ", "\[ImaginaryI]"}], "2"]}], ",", "3"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"3", "+", 
        FractionBox[
         RowBox[{"9", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{458, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247560949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459030898],

Cell["Isolate the complex roots of a list of polynomials:", "ExampleText",
 CellID->47134193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "2"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "3"}]}], "}"}], ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50831802],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["5", "4"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["5", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "64"]}], "-", 
        FractionBox[
         RowBox[{"81", " ", "\[ImaginaryI]"}], "64"]}], ",", 
       RowBox[{
        FractionBox["3", "32"], "-", 
        FractionBox[
         RowBox[{"9", " ", "\[ImaginaryI]"}], "8"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "64"]}], "+", 
        FractionBox[
         RowBox[{"9", " ", "\[ImaginaryI]"}], "8"]}], ",", 
       RowBox[{
        FractionBox["3", "32"], "+", 
        FractionBox[
         RowBox[{"81", " ", "\[ImaginaryI]"}], "64"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "64"]}], "-", 
        FractionBox[
         RowBox[{"45", " ", "\[ImaginaryI]"}], "32"]}], ",", 
       RowBox[{
        FractionBox["3", "32"], "-", 
        FractionBox[
         RowBox[{"81", " ", "\[ImaginaryI]"}], "64"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "64"]}], "+", 
        FractionBox[
         RowBox[{"81", " ", "\[ImaginaryI]"}], "64"]}], ",", 
       RowBox[{
        FractionBox["3", "32"], "+", 
        FractionBox[
         RowBox[{"45", " ", "\[ImaginaryI]"}], "32"]}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352592583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225534891],

Cell["\<\
Polynomials may have multiple roots; pairs of polynomials may have common \
roots:\
\>", "ExampleText",
 CellID->293275947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "3"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "4"}], "-", "2"}], ")"}], "^", "2"}]}], " ", ",", 
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", "27"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "8"}], "-", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166436042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", 
        FractionBox["3", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139318829]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "1"}]}], "}"}], ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48142870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        FractionBox["3", "8"], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}], ",", 
       RowBox[{
        FractionBox["3", "8"], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{532, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245300666]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51900208],

Cell["Isolating intervals of rational roots may be single points:", \
"ExampleText",
 CellID->2128223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"x", 
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"x", "-", "2"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->547152278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->620060838]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->447759991],

Cell["Find numeric approximations of real roots of a polynomial:", \
"ExampleText",
 CellID->239148615],

Cell[BoxData[
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    RowBox[{"x", "^", "777"}], "-", 
    RowBox[{"22", 
     RowBox[{"x", "^", "123"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "33"}]}], "-", 
    RowBox[{"17", 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "-", "1"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88768758],

Cell["Find isolating intervals:", "ExampleText",
 CellID->340547239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ints", "=", 
  RowBox[{
   RowBox[{"RootIntervals", "[", "poly", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144342663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->347009908]
}, Open  ]],

Cell["Find root approximations:", "ExampleText",
 CellID->1476335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{"poly", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Brent\>\""}]}], "]"}], "&"}], "/@", 
  "ints"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->181640032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.004477583420293`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.4956672798453987`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.0043758709713597`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{321, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->115161257]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses a similar approach, but factoring the polynomial for ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects takes time:"
}], "ExampleText",
 CellID->166602272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"poly", "\[Equal]", "0"}], ",", "x", ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->189042854],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtvEzEQ3uzm0ZY2CdBHCn2kEmrFoUVFogIhuAEn/gJSVFGVAwKVnvk3
XOiPNPHGTt3P4x17swlJ5UjJ7tjj8bxsj798Hlxffv0+uP52Puh/uhr8vPx2
/qv/8cfVsCmrJUntb5Ikr3vJ8F0M3/Kv/NwMv0nyYfibqqYj9V5Xz1djjiTT
o8SY02yrA/1yCiMfQ9vDiSRJ+x55SWgr7tQYJZky4M6U5+SzoZ4ocXn40xiS
LWhvqPZGrsZt+2gW2bOunijRPWLVMUfKzrXtzblFeZDk3FTeG7ktZ7A8uGR4
j49Lx5qrqcaPBuhP7uvGmE91pQGtmbvV0OoB0FSMbSlS1SYR103GB65xVNTp
WX2kbQd4ySUDcyRz8G0IjKfUXebMkrcNdpZ0lQxbOh3VggxArxq0XinU6myo
zDTbm6StJseKcO8UxSvOJQl1QD57lSNHxyEJreat2zD9xXLqeIx/rZ07ZWw7
FWYuSJ/S+0S94rzg9gQyuoX+wH0hPB9wh0Ad+BMGJT6dWAJ/jnB+wOoAM8L3
DFkX/tGfTk4sTeyLyXMCdSBtKpS4w/if12nynJAVYkrw+dV5eUaR0TUrPV3f
oEyMMuZnFmwN7rq8hB7Q5C5ZKGGX8Ryvwx7LsWX6O3gFH5FRwrsBtwY7pBRX
RSM1y4hZwuoiXFNt52ifSk1nbaaeXVKah4Z1s7cxVkF/9DwdT6swikj3vK22
Y3+oNHwCvSvi7k3Nrkf0DRfldo12+uZDjUyUvzOjv+UciesYPdIWd3cYt/Z0
bY/y14rHB8RqW4Tcz/DmfQb0C6CPmdlPArXFvYvjP6jEqmPl21NmNs5aXEeh
1vS9rZHamlbIHEJfn0B/CnQeyxZkooN3l5GF9IGgUKnfhD8zrQnjd2rlI9+O
kpfC80s+u2S5gTcKSXs77jFlaw6z7U0FnBxCxt3bnhdKphAzP4kRQZsVgtZy
2OgXp4ioRUQtPGsiwnYfEbYOY0tYbkTErUiHxUTcuP/fyp45EYGjdFhMBA7r
RbSiXP0Ykbn5Qub8ohiRutu57y9S55cLEbmjfDl75K4cIrBoSB6NmCwKcner
/aIgdSPUa/4QOr16LoSN1OVVpxW7C6D1CKvGqXDkIdDvCEnr0NYFmrth1Jwz
S1+8d8wo+/AkLTeTWauZuzbWcNQNOiKJfkiim9MHSWw6bCwXb/c9zXmuBlRE
9KkdsctFwC5dfG7scpnxhV+Gkqe2ZQVG0a7oMO6rIqKhVaGhXWHseQUR9UdD
+Tn90NBp7orlcy6irCEx+R8oa7gfsLKrLvOkGugzXX9lqr9t6RvRWUqHeUBn
5ym3THqN8RWFrkW09y7H5GjvPsuh0d7pZAV1ZhX1o9T8VhzR45mjx11Pq3wQ
yOqzSq9+jRvL+NeNXeGZiDgzjzPbp3xZnLnnsKBcdBFDmzXuvBfI3wfaDxmc
FQ4das0+aQ1iqLPEo/cYWUj3hYnt/iH8lyXV4dG7gsajz0ba1P4BtBNCVQ==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{426, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->642914049]
}, Open  ]],

Cell[TextData[{
 "Compute approximations of the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->192465088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->419364905],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1.004477583420293`"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "0.4956672798453987`"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1.0043758709713377`"}]}]], "Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->35811866]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->311370645],

Cell["Find real and complex roots of polynomials:", "ExampleText",
 CellID->497769600],

Cell[BoxData[
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "3"}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134866751],

Cell["\<\
Isolate the real roots; multiple roots are indicated in the second part of \
the output:\
\>", "ExampleText",
 CellID->318596924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", "poly", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171332220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["11", "8"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["11", "8"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["11", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["11", "8"], ",", 
       FractionBox["3", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{494, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261159828]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CountRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountRoots"]], "InlineFormula"],
 " to count the real roots; multiple roots are counted with multiplicities:"
}], "ExampleText",
 CellID->241073705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{"poly", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->163152148],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->578746303]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find the real roots; multiple roots are given once:"
}], "ExampleText",
 CellID->746217437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->211046693],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["3", 
    RowBox[{"1", "/", "4"}]]}]}]], "Output",
 ImageSize->{267, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->197996091]
}, Open  ]],

Cell["\<\
Isolate the complex roots; multiple roots are indicated in the second part of \
the output:\
\>", "ExampleText",
 CellID->160943033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"poly", ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->230462823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["11", "8"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["11", "8"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["11", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["11", "8"], ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        FractionBox[
         RowBox[{"9", " ", "\[ImaginaryI]"}], "2"]}], ",", "3"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"3", "+", 
        FractionBox[
         RowBox[{"9", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{500, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->56661253]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find the complex roots; multiple roots are given once:"
}], "ExampleText",
 CellID->2028233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2987085],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["3", 
    RowBox[{"1", "/", "4"}]]}]}]], "Output",
 ImageSize->{429, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->129284691]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to find the complex roots with multiplicities:"
}], "ExampleText",
 CellID->3678236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->158217996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SuperscriptBox["3", 
       RowBox[{"1", "/", "4"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SuperscriptBox["3", 
       RowBox[{"1", "/", "4"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["3", 
       RowBox[{"1", "/", "4"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "4"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{327, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->511762026]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7441],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Roots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountRoots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountRoots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IsolatingInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IsolatingInterval"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25134]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25020],

Cell[TextData[ButtonBox["Root Isolation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RootIsolation"]], "Tutorials",
 CellID->11798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->174264937],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntervalArithmetic"]], "MoreAbout",
 CellID->970014080],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->460210462],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->166579777]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RootIntervals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 5.3348384}", "context" -> "System`", 
    "keywords" -> {"isolating intervals", "polynomial roots"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RootIntervals[{poly_1, poly_2, ...}] gives a list of isolating intervals \
for the real roots of any of the poly_i, together with a list of which \
polynomials actually have each successive root. RootIntervals[poly] gives \
isolating intervals for real roots of a single polynomial. \
RootIntervals[polys, Complexes] gives bounding rectangles for complex roots.",
     "synonyms" -> {"root intervals"}, "title" -> "RootIntervals", "type" -> 
    "Symbol", "uri" -> "ref/RootIntervals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8241, 246, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53412546]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42641, 1550}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2648, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3271, 87, 1578, 37, 70, "ObjectNameGrid"],
Cell[4852, 126, 1767, 53, 70, "Usage",
 CellID->21478]
}, Open  ]],
Cell[CellGroupData[{
Cell[6656, 184, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7134, 201, 164, 6, 70, "Notes",
 CellID->26814],
Cell[7301, 209, 422, 15, 70, "Notes",
 CellID->13787],
Cell[7726, 226, 221, 5, 70, "Notes",
 CellID->5045],
Cell[7950, 233, 254, 8, 70, "Notes",
 CellID->1376342]
}, Closed]],
Cell[CellGroupData[{
Cell[8241, 246, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53412546],
Cell[CellGroupData[{
Cell[8625, 260, 147, 5, 70, "ExampleSection",
 CellID->11288036],
Cell[8775, 267, 133, 4, 70, "ExampleText",
 CellID->81330507],
Cell[CellGroupData[{
Cell[8933, 275, 279, 9, 28, "Input",
 CellID->18699903],
Cell[9215, 286, 591, 21, 36, "Output",
 CellID->337235435]
}, Open  ]],
Cell[9821, 310, 124, 3, 70, "ExampleDelimiter",
 CellID->20206060],
Cell[9948, 315, 115, 3, 70, "ExampleText",
 CellID->216268437],
Cell[CellGroupData[{
Cell[10088, 322, 262, 9, 70, "Input",
 CellID->180546937],
Cell[10353, 333, 585, 21, 51, "Output",
 CellID->668226492]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10987, 360, 220, 7, 70, "ExampleSection",
 CellID->136228846],
Cell[11210, 369, 81, 1, 70, "ExampleText",
 CellID->66814597],
Cell[CellGroupData[{
Cell[11316, 374, 276, 10, 70, "Input",
 CellID->16268516],
Cell[11595, 386, 908, 33, 51, "Output",
 CellID->17933408]
}, Open  ]],
Cell[12518, 422, 124, 3, 70, "ExampleDelimiter",
 CellID->13383273],
Cell[12645, 427, 91, 1, 70, "ExampleText",
 CellID->514816060],
Cell[CellGroupData[{
Cell[12761, 432, 319, 11, 70, "Input",
 CellID->586343835],
Cell[13083, 445, 1336, 47, 73, "Output",
 CellID->764679204]
}, Open  ]],
Cell[14434, 495, 125, 3, 70, "ExampleDelimiter",
 CellID->526804269],
Cell[14562, 500, 84, 1, 70, "ExampleText",
 CellID->70894114],
Cell[CellGroupData[{
Cell[14671, 505, 189, 6, 70, "Input",
 CellID->700035452],
Cell[14863, 513, 928, 33, 51, "Output",
 CellID->247560949]
}, Open  ]],
Cell[15806, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->459030898],
Cell[15934, 554, 93, 1, 70, "ExampleText",
 CellID->47134193],
Cell[CellGroupData[{
Cell[16052, 559, 297, 11, 70, "Input",
 CellID->50831802],
Cell[16352, 572, 2421, 82, 103, "Output",
 CellID->352592583]
}, Open  ]],
Cell[18788, 657, 125, 3, 70, "ExampleDelimiter",
 CellID->225534891],
Cell[18916, 662, 133, 4, 70, "ExampleText",
 CellID->293275947],
Cell[CellGroupData[{
Cell[19074, 670, 485, 17, 70, "Input",
 CellID->166436042],
Cell[19562, 689, 984, 35, 51, "Output",
 CellID->139318829]
}, Open  ]],
Cell[CellGroupData[{
Cell[20583, 729, 297, 11, 70, "Input",
 CellID->48142870],
Cell[20883, 742, 2075, 70, 81, "Output",
 CellID->245300666]
}, Open  ]],
Cell[22973, 815, 124, 3, 70, "ExampleDelimiter",
 CellID->51900208],
Cell[23100, 820, 102, 2, 70, "ExampleText",
 CellID->2128223],
Cell[CellGroupData[{
Cell[23227, 826, 230, 8, 70, "Input",
 CellID->547152278],
Cell[23460, 836, 559, 20, 36, "Output",
 CellID->620060838]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24068, 862, 227, 7, 70, "ExampleSection",
 CellID->447759991],
Cell[24298, 871, 103, 2, 70, "ExampleText",
 CellID->239148615],
Cell[24404, 875, 393, 14, 70, "Input",
 CellID->88768758],
Cell[24800, 891, 68, 1, 70, "ExampleText",
 CellID->340547239],
Cell[CellGroupData[{
Cell[24893, 896, 191, 6, 70, "Input",
 CellID->144342663],
Cell[25087, 904, 424, 16, 36, "Output",
 CellID->347009908]
}, Open  ]],
Cell[25526, 923, 66, 1, 70, "ExampleText",
 CellID->1476335],
Cell[CellGroupData[{
Cell[25617, 928, 427, 14, 70, "Input",
 CellID->181640032],
Cell[26047, 944, 476, 16, 36, "Output",
 CellID->115161257]
}, Open  ]],
Cell[26538, 963, 368, 12, 70, "ExampleText",
 CellID->166602272],
Cell[CellGroupData[{
Cell[26931, 979, 207, 7, 70, "Input",
 CellID->189042854],
Cell[27141, 988, 1737, 33, 70, "Output",
 Evaluatable->False,
 CellID->642914049]
}, Open  ]],
Cell[28893, 1024, 213, 8, 70, "ExampleText",
 CellID->192465088],
Cell[CellGroupData[{
Cell[29131, 1036, 149, 5, 70, "Input",
 CellID->419364905],
Cell[29283, 1043, 373, 11, 36, "Output",
 CellID->35811866]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29705, 1060, 237, 7, 70, "ExampleSection",
 CellID->311370645],
Cell[29945, 1069, 86, 1, 70, "ExampleText",
 CellID->497769600],
Cell[30034, 1072, 316, 12, 70, "Input",
 CellID->134866751],
Cell[30353, 1086, 139, 4, 70, "ExampleText",
 CellID->318596924],
Cell[CellGroupData[{
Cell[30517, 1094, 112, 3, 70, "Input",
 CellID->171332220],
Cell[30632, 1099, 1020, 37, 51, "Output",
 CellID->261159828]
}, Open  ]],
Cell[31667, 1139, 263, 8, 70, "ExampleText",
 CellID->241073705],
Cell[CellGroupData[{
Cell[31955, 1151, 226, 7, 70, "Input",
 CellID->163152148],
Cell[32184, 1160, 158, 5, 36, "Output",
 CellID->578746303]
}, Open  ]],
Cell[32357, 1168, 237, 8, 70, "ExampleText",
 CellID->746217437],
Cell[CellGroupData[{
Cell[32619, 1180, 176, 6, 70, "Input",
 CellID->211046693],
Cell[32798, 1188, 491, 18, 38, "Output",
 CellID->197996091]
}, Open  ]],
Cell[33304, 1209, 142, 4, 70, "ExampleText",
 CellID->160943033],
Cell[CellGroupData[{
Cell[33471, 1217, 143, 4, 70, "Input",
 CellID->230462823],
Cell[33617, 1223, 1464, 52, 73, "Output",
 CellID->56661253]
}, Open  ]],
Cell[35096, 1278, 238, 8, 70, "ExampleText",
 CellID->2028233],
Cell[CellGroupData[{
Cell[35359, 1290, 157, 5, 70, "Input",
 CellID->2987085],
Cell[35519, 1297, 769, 27, 38, "Output",
 CellID->129284691]
}, Open  ]],
Cell[36303, 1327, 225, 8, 70, "ExampleText",
 CellID->3678236],
Cell[CellGroupData[{
Cell[36553, 1339, 158, 5, 70, "Input",
 CellID->158217996],
Cell[36714, 1346, 1149, 41, 65, "Output",
 CellID->511762026]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37924, 1394, 310, 9, 70, "SeeAlsoSection",
 CellID->7441],
Cell[38237, 1405, 1674, 62, 70, "SeeAlso",
 CellID->25134]
}, Open  ]],
Cell[CellGroupData[{
Cell[39948, 1472, 314, 9, 70, "TutorialsSection",
 CellID->25020],
Cell[40265, 1483, 138, 3, 70, "Tutorials",
 CellID->11798]
}, Open  ]],
Cell[CellGroupData[{
Cell[40440, 1491, 319, 9, 70, "MoreAboutSection",
 CellID->174264937],
Cell[40762, 1502, 149, 3, 70, "MoreAbout",
 CellID->970014080],
Cell[40914, 1507, 151, 3, 70, "MoreAbout",
 CellID->460210462],
Cell[41068, 1512, 169, 3, 70, "MoreAbout",
 CellID->166579777]
}, Open  ]],
Cell[41252, 1518, 27, 0, 70, "History"],
Cell[41282, 1520, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

