(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40452,       1522]
NotebookOptionsPosition[     32065,       1223]
NotebookOutlinePosition[     33343,       1259]
CellTagsIndexPosition[     33257,       1254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "Variance" :> 
          Documentation`HelpLookup["paclet:ref/Variance"], 
          "StandardDeviation" :> 
          Documentation`HelpLookup["paclet:ref/StandardDeviation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mean\"\>", 2->"\<\"Norm\"\>", 
       3->"\<\"Variance\"\>", 
       4->"\<\"StandardDeviation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RootMeanSquare", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootMeanSquare",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootMeanSquare"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the root mean square of values in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12100]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", the root mean square is given by ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     FractionBox["1", "n"], 
     RowBox[{
      UnderscriptBox["\[Sum]", "i"], 
      SubsuperscriptBox["x", "i", "2"]}]}]], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->21479],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RootMeanSquare",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootMeanSquare"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RootMeanSquare", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"RootMeanSquare", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->82989766],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->174346191],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of a list:"
}], "ExampleText",
 CellID->104718352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", " ", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30101],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"], "+", 
    SuperscriptBox["d", "2"]}]]}]], "Output",
 ImageSize->{125, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87710524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252483224],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of columns of a matrix:"
}], "ExampleText",
 CellID->234915771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36247193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox["67"], "2"], ",", 
   SqrtBox["43"]}], "}"}]], "Output",
 ImageSize->{96, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196822820]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31219],

Cell["Compute results at machine precision:", "ExampleText",
 CellID->379986608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216003675],

Cell[BoxData["0.63315130838013`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563715160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "6", ",", "5", ",", "15", ",", "10", ",", "1"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["8.07258735887488966520151684064254659251`30."], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430938036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.5773077865468352`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207523167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5775934139322159`", ",", "0.5774832735872641`", ",", 
   "0.5777143810201308`", ",", "0.5774260077750495`", ",", 
   "0.5774435314263293`", ",", "0.5767868318913228`", ",", 
   "0.5774917039439779`", ",", "0.5775215532730417`", ",", 
   "0.577295960029259`", ",", "0.5776109789758739`"}], "}"}]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162927532]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3084],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1979723]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "10"], ",", 
   FractionBox["1", "5"], ",", 
   FractionBox["1", 
    SqrtBox["10"]], ",", 
   FractionBox["1", 
    SqrtBox["5"]], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["17", "2"]], "5"], ",", 
   FractionBox[
    SqrtBox["13"], "5"], ",", 
   FractionBox[
    SqrtBox[
     FractionBox["37", "2"]], "5"], ",", "1", ",", 
   SqrtBox[
    FractionBox["13", "10"]], ",", 
   FractionBox[
    SqrtBox["41"], "5"]}], "}"}]], "Output",
 ImageSize->{403, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->157757166]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22133],

Cell["Root mean square error for a linear fit:", "ExampleText",
 CellID->101267701],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "13.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "14.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "16.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "18.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "22.2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693180148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26480837],

Cell[BoxData[
 RowBox[{"0.8000000000000048`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.0418181818181806`", " ", "x"}]}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75151971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "-", 
   RowBox[{"Map", "[", 
    RowBox[{"f", ",", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->121024545],

Cell[BoxData["0.40456486163868294`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100334910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15452],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " is the square root of ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of the data squared:"
}], "ExampleText",
 CellID->866035301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57098655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.851457541773039`", ",", "7.513798351363632`", ",", "2.2558911424609174`",
    ",", "3.5807838178187157`", ",", "9.376455407865329`", ",", 
   "9.064615509615974`", ",", "7.996441778137666`", ",", "7.092664184140234`",
    ",", "6.083499643430286`", ",", "0.15602327626207613`"}], "}"}]], "Output",\

 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42018443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Mean", "[", 
   RowBox[{"data", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120365439],

Cell[BoxData["6.475124025132707`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->327166588]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73093501],

Cell[BoxData["6.475124025132707`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->201072051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15306691],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " is equivalent to a scaled ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->352228623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583892962],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.18256645176713`", ",", "5.269931478287376`", ",", "9.448745311295374`", 
   ",", "4.229606420937577`", ",", "7.790332017893258`", ",", 
   "0.2925682103213223`", ",", "5.871114268613688`", ",", 
   "8.212184181063716`", ",", "4.638223179026843`", ",", 
   "2.0636938487059497`"}], "}"}]], "Output",
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546445586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", "data", "]"}], "/", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"Length", "[", "data", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210705611],

Cell[BoxData["5.9182455059905505`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128724927]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->155554633],

Cell[BoxData["5.9182455059905505`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->195178881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83903156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of deviations is equivalent to a scaled ",
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19367069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21398448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.954870242174607`", ",", "8.711144002905307`", ",", "5.087473825071154`", 
   ",", "7.51385765204393`", ",", "8.07313994092022`", ",", 
   "3.296220668438614`", ",", "7.383369752568498`", ",", "7.874224756718977`",
    ",", "1.015404388112402`", ",", "9.374256502158593`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6853050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviation", "[", "data", "]"}], 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}], "/", 
    RowBox[{"Length", "[", "data", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436530018],

Cell[BoxData["2.5916593462292723`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272208077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"data", "-", 
   RowBox[{"Mean", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->535897644],

Cell[BoxData["2.5916593462292727`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->249858421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543634770],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of deviations is the square root of a ",
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68140390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212321697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.903249285148752`", ",", "3.0925265263962554`", ",", 
   "2.6915394721162667`", ",", "3.478395410566373`", ",", 
   "5.738230919030254`", ",", "0.956827973275971`", ",", 
   "3.0111987003846874`", ",", "3.2847735109605614`", ",", 
   "7.667352574462141`", ",", "3.4417710657936373`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29049410]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CentralMoment", "[", 
   RowBox[{"data", ",", "2"}], "]"}], "//", "Sqrt"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36438168],

Cell[BoxData["2.131090705684827`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124817602]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"data", "-", 
   RowBox[{"Mean", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->432525148],

Cell[BoxData["2.131090705684827`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->289474562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70099947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " as a scaled ",
 Cell[BoxData[
  ButtonBox["EuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFormula"],
 " from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->394865487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463545505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.641616008277052`", ",", "0.6472196490091564`", ",", 
   "1.1512073366138464`", ",", "9.776871969794737`", ",", 
   "7.3256867414389815`", ",", "1.4300802772815535`", ",", "8.5736035729641`",
    ",", "7.751690723883488`", ",", "5.193558361893724`", ",", 
   "0.3117248509678916`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56281979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mean", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mean", "[", "data", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Length", "[", "data", "]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132468290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.680325949212453`", ",", "4.680325949212453`", ",", "4.680325949212453`", 
   ",", "4.680325949212453`", ",", "4.680325949212453`", ",", 
   "4.680325949212453`", ",", "4.680325949212453`", ",", "4.680325949212453`",
    ",", "4.680325949212453`", ",", "4.680325949212453`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288811713]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", 
  RowBox[{"data", "-", 
   RowBox[{"Mean", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->917053855],

Cell[BoxData["3.4087814590940004`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->231712772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EuclideanDistance", "[", 
   RowBox[{"data", ",", "mean"}], "]"}], "/", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"Length", "[", "data", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42727618],

Cell[BoxData["3.4087814590940004`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->232731603]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13209],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25836]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26573],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RootMeanSquare",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=RootMeanSquare"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->66855718],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->602277922]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RootMeanSquare - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 6.1161084}", "context" -> "System`", 
    "keywords" -> {"mean square residual", "RMS", "root-mean-square"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RootMeanSquare[list] gives the root mean square of values in list.", 
    "synonyms" -> {"root mean square"}, "title" -> "RootMeanSquare", "type" -> 
    "Symbol", "uri" -> "ref/RootMeanSquare"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8257, 270, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->82989766]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33115, 1247}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2208, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2831, 80, 1579, 37, 70, "ObjectNameGrid"],
Cell[4413, 119, 576, 18, 70, "Usage",
 CellID->12100]
}, Open  ]],
Cell[CellGroupData[{
Cell[5026, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5504, 159, 661, 27, 70, "Notes",
 CellID->21479],
Cell[6168, 188, 222, 7, 70, "Notes",
 CellID->28487],
Cell[6393, 197, 1493, 54, 70, "Notes",
 CellID->26555],
Cell[7889, 253, 331, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[8257, 270, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->82989766],
Cell[CellGroupData[{
Cell[8641, 284, 148, 5, 70, "ExampleSection",
 CellID->174346191],
Cell[8792, 291, 200, 7, 70, "ExampleText",
 CellID->104718352],
Cell[CellGroupData[{
Cell[9017, 302, 178, 5, 28, "Input",
 CellID->30101],
Cell[9198, 309, 361, 13, 52, "Output",
 CellID->87710524]
}, Open  ]],
Cell[9574, 325, 125, 3, 70, "ExampleDelimiter",
 CellID->252483224],
Cell[9702, 330, 213, 7, 70, "ExampleText",
 CellID->234915771],
Cell[CellGroupData[{
Cell[9940, 341, 381, 13, 70, "Input",
 CellID->36247193],
Cell[10324, 356, 254, 10, 56, "Output",
 CellID->196822820]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10627, 372, 216, 7, 70, "ExampleSection",
 CellID->31219],
Cell[10846, 381, 80, 1, 70, "ExampleText",
 CellID->379986608],
Cell[CellGroupData[{
Cell[10951, 386, 172, 5, 70, "Input",
 CellID->216003675],
Cell[11126, 393, 174, 5, 36, "Output",
 CellID->563715160]
}, Open  ]],
Cell[11315, 401, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[11443, 406, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[11544, 411, 261, 8, 70, "Input",
 CellID->190699768],
Cell[11808, 421, 202, 5, 36, "Output",
 CellID->430938036]
}, Open  ]],
Cell[12025, 429, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[12153, 434, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[12266, 439, 197, 6, 70, "Input",
 CellID->315224713],
Cell[12466, 447, 176, 5, 36, "Output",
 CellID->207523167]
}, Open  ]],
Cell[CellGroupData[{
Cell[12679, 457, 251, 8, 70, "Input",
 CellID->594479966],
Cell[12933, 467, 482, 12, 54, "Output",
 CellID->162927532]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13464, 485, 238, 7, 70, "ExampleSection",
 CellID->3084],
Cell[13705, 494, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[13941, 506, 570, 19, 70, "Input",
 CellID->19878761],
Cell[14514, 527, 482, 17, 36, "Output",
 CellID->1979723]
}, Open  ]],
Cell[CellGroupData[{
Cell[15033, 549, 111, 3, 70, "Input",
 CellID->235263230],
Cell[15147, 554, 636, 25, 80, "Output",
 CellID->157757166]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15832, 585, 223, 7, 70, "ExampleSection",
 CellID->22133],
Cell[16058, 594, 83, 1, 70, "ExampleText",
 CellID->101267701],
Cell[16144, 597, 799, 26, 70, "Input",
 CellID->693180148],
Cell[CellGroupData[{
Cell[16968, 627, 238, 8, 70, "Input",
 CellID->26480837],
Cell[17209, 637, 259, 7, 36, "Output",
 CellID->75151971]
}, Open  ]],
Cell[CellGroupData[{
Cell[17505, 649, 365, 12, 70, "Input",
 CellID->121024545],
Cell[17873, 663, 177, 5, 36, "Output",
 CellID->100334910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18099, 674, 233, 7, 70, "ExampleSection",
 CellID->15452],
Cell[18335, 683, 349, 12, 70, "ExampleText",
 CellID->866035301],
Cell[CellGroupData[{
Cell[18709, 699, 157, 5, 70, "Input",
 CellID->57098655],
Cell[18869, 706, 474, 12, 54, "Output",
 CellID->42018443]
}, Open  ]],
Cell[CellGroupData[{
Cell[19380, 723, 158, 5, 70, "Input",
 CellID->120365439],
Cell[19541, 730, 175, 5, 36, "Output",
 CellID->327166588]
}, Open  ]],
Cell[CellGroupData[{
Cell[19753, 740, 112, 3, 70, "Input",
 CellID->73093501],
Cell[19868, 745, 175, 5, 36, "Output",
 CellID->201072051]
}, Open  ]],
Cell[20058, 753, 124, 3, 70, "ExampleDelimiter",
 CellID->15306691],
Cell[20185, 758, 333, 12, 70, "ExampleText",
 CellID->352228623],
Cell[CellGroupData[{
Cell[20543, 774, 158, 5, 70, "Input",
 CellID->583892962],
Cell[20704, 781, 474, 12, 54, "Output",
 CellID->546445586]
}, Open  ]],
Cell[CellGroupData[{
Cell[21215, 798, 194, 6, 70, "Input",
 CellID->210705611],
Cell[21412, 806, 176, 5, 36, "Output",
 CellID->128724927]
}, Open  ]],
Cell[CellGroupData[{
Cell[21625, 816, 113, 3, 70, "Input",
 CellID->155554633],
Cell[21741, 821, 176, 5, 36, "Output",
 CellID->195178881]
}, Open  ]],
Cell[21932, 829, 124, 3, 70, "ExampleDelimiter",
 CellID->83903156],
Cell[22059, 834, 372, 12, 70, "ExampleText",
 CellID->19367069],
Cell[CellGroupData[{
Cell[22456, 850, 157, 5, 70, "Input",
 CellID->21398448],
Cell[22616, 857, 465, 11, 54, "Output",
 CellID->6853050]
}, Open  ]],
Cell[CellGroupData[{
Cell[23118, 873, 318, 10, 70, "Input",
 CellID->436530018],
Cell[23439, 885, 176, 5, 36, "Output",
 CellID->272208077]
}, Open  ]],
Cell[CellGroupData[{
Cell[23652, 895, 171, 5, 70, "Input",
 CellID->535897644],
Cell[23826, 902, 176, 5, 36, "Output",
 CellID->249858421]
}, Open  ]],
Cell[24017, 910, 125, 3, 70, "ExampleDelimiter",
 CellID->543634770],
Cell[24145, 915, 362, 12, 70, "ExampleText",
 CellID->68140390],
Cell[CellGroupData[{
Cell[24532, 931, 158, 5, 70, "Input",
 CellID->212321697],
Cell[24693, 938, 477, 12, 54, "Output",
 CellID->29049410]
}, Open  ]],
Cell[CellGroupData[{
Cell[25207, 955, 162, 5, 70, "Input",
 CellID->36438168],
Cell[25372, 962, 175, 5, 36, "Output",
 CellID->124817602]
}, Open  ]],
Cell[CellGroupData[{
Cell[25584, 972, 171, 5, 70, "Input",
 CellID->432525148],
Cell[25758, 979, 175, 5, 36, "Output",
 CellID->289474562]
}, Open  ]],
Cell[25948, 987, 124, 3, 70, "ExampleDelimiter",
 CellID->70099947],
Cell[26075, 992, 471, 17, 70, "ExampleText",
 CellID->394865487],
Cell[CellGroupData[{
Cell[26571, 1013, 158, 5, 70, "Input",
 CellID->463545505],
Cell[26732, 1020, 475, 12, 54, "Output",
 CellID->56281979]
}, Open  ]],
Cell[CellGroupData[{
Cell[27244, 1037, 251, 8, 70, "Input",
 CellID->132468290],
Cell[27498, 1047, 469, 11, 54, "Output",
 CellID->288811713]
}, Open  ]],
Cell[CellGroupData[{
Cell[28004, 1063, 171, 5, 70, "Input",
 CellID->917053855],
Cell[28178, 1070, 176, 5, 36, "Output",
 CellID->231712772]
}, Open  ]],
Cell[CellGroupData[{
Cell[28391, 1080, 233, 7, 70, "Input",
 CellID->42727618],
Cell[28627, 1089, 176, 5, 36, "Output",
 CellID->232731603]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28864, 1101, 311, 9, 70, "SeeAlsoSection",
 CellID->13209],
Cell[29178, 1112, 943, 35, 70, "SeeAlso",
 CellID->25836]
}, Open  ]],
Cell[CellGroupData[{
Cell[30158, 1152, 314, 9, 70, "TutorialsSection",
 CellID->26573],
Cell[30475, 1163, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[30668, 1171, 305, 8, 70, "RelatedLinksSection"],
Cell[30976, 1181, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31383, 1198, 299, 8, 70, "MoreAboutSection"],
Cell[31685, 1208, 154, 3, 70, "MoreAbout",
 CellID->66855718],
Cell[31842, 1213, 151, 3, 70, "MoreAbout",
 CellID->602277922]
}, Open  ]],
Cell[32008, 1219, 27, 0, 70, "History"],
Cell[32038, 1221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

