(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34078,       1276]
NotebookOptionsPosition[     26734,       1017]
NotebookOutlinePosition[     28006,       1053]
CellTagsIndexPosition[     27920,       1048]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberFieldRootsOfUnity" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRootsOfUnity"], 
          "RootReduce" :> Documentation`HelpLookup["paclet:ref/RootReduce"], 
          "Cyclotomic" :> Documentation`HelpLookup["paclet:ref/Cyclotomic"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberFieldRootsOfUnity\"\>", 
       2->"\<\"RootReduce\"\>", 3->"\<\"Cyclotomic\"\>", 
       4->"\<\"MinimalPolynomial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RootOfUnityQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootOfUnityQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootOfUnityQ"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " is a root of unity, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An algebraic number ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is a root of unity if ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["n", "TI"]], "=", "1"}]], "InlineFormula"],
 " for some integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3998]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->670197683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115594938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"Sqrt", "[", "I", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42152485],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529394139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"1", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->284819305],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43888803]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Radical expressions:", "ExampleText",
 CellID->217489883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "+", 
       RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}], "+", 
     RowBox[{"I", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "-", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}]}], ")"}], "/", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335296387],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->901930641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254208548],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1138092353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", "#", "+", 
      RowBox[{"#", "^", "2"}], "+", 
      RowBox[{"#", "^", "3"}], "+", 
      RowBox[{"#", "^", "4"}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1243611591],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54436894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2124599860],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1939248351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"I", " ", 
      RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587724738],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40019440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->710751266],

Cell["Transcendental objects:", "ExampleText",
 CellID->965498331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->744012385],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63887156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157929998],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootOfUnityQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootOfUnityQ"]], "InlineFormula"],
 " threads automatically over lists:"
}], "ExampleText",
 CellID->39688694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}], "/", "2"}], ",", "I"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1327949488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35362629]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Roots of unity are solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "n"], "=", "1"}], TraditionalForm]], "InlineMath"],
 " for some integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1329570083],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "+", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"2", "-", 
         RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}]}], ")"}], "/", "2"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1930901238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"a", "^", "16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2031717249],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491657854]
}, Open  ]],

Cell["\<\
All roots of unity are algebraic integers that lie on the unit circle:\
\>", "ExampleText",
 CellID->629165267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1527295082],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->395427267]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", "a", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->171164641],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->193058670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1517037946],

Cell["\<\
Not all algebraic numbers on the unit circle are roots of unity:\
\>", "ExampleText",
 CellID->17638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", "I"}]}], ")"}], "/", 
   RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31656],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381930149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", "I"}]}], ")"}], "/", 
   RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16705],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->357814731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213967840],

Cell["\<\
The minimal polynomial of a root of unity is a cyclotomic polynomial or one \
of its factor:\
\>", "ExampleText",
 CellID->1019362567],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "I"}], ")"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1593362544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->523198918],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102451451]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MinimalPolynomial", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], ",", "x"}], "]"}], "==", 
  RowBox[{"Cyclotomic", "[", 
   RowBox[{"8", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1949611450],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12192238]
}, Open  ]],

Cell["Roots of cyclotomic polynomials are roots of unity:", "ExampleText",
 CellID->1269861802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cyclotomic", "[", 
     RowBox[{"16", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->322833900],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtO3DAQ9Sa7LFt6Q0urSm0lpJZPAPoCPLVIqPT21D6uUCV4qFpRPqF8
d7Adm2bPjjPjxKG7VZDYZOJ4zswZ27HP6ezq/PuP2dXF2Wz7+HL26/zi7Pf2
u5+X+lE+UGrwRym180zp+0Lf2X/zd63/ldrQv5l+9N5dt9z1rbtO3fUUbN8+
qlyVumd+c49QqA9gPwb7GOxHYH9k2rH/EOxshaJ6zXh9AnYONvp7CfZDsJ8y
/iZg7yT2h/Fx+cpYfAX2JthbRJRm/G7A8xdg4xihqmH8cFVt6gfj4fKqYWt4
+9RhZQFMrLBpH2kTfU8Z7EkU6pjoTaFyGa9HoeLo6wYVR9laIobpuZDNx6Jv
7sMbD8DGdkkcFJs8MmaOzEh4N8i4qvDIOKq7Q0Z2RwnYXqw6xuHjMwxPVPll
psZU5p5jVFz+yB/i4fz1OOgXbVwJkb1QXhh/aryxw8MR25Q/bB8U1Nz13wGM
qu2Mxe9PCKft/MT1NITTdjaGcNBvN3OPX/cwH4yrbf14RJyPbRnmEbFHekTu
a5KwusFv+fNITGpfs1DZIBpyxHGKaOR+J4iGu81u0TC3tkw2Oylgjnh+sV5H
1RwUsfpjL5yvyCy17sejYsY4g/AUcjeo3ChKw3Cz07UZM2bs1e0SDLpFG0NM
rg37Yq3xhLueABPZQM7xlB7CpHZNTTExzxC3MZjc7o2u8lFBjaDqiJHUbV/k
hWPlMCHD+50zd1DQNcvA5ta3XaEfbu04ImvA5YZe3oi8yFYUr5QeUG+v/bV9
IapfN3PdFfbzO9gpgXcbvaDfnrCfj3NeyT3Rv7nvtcDgp9rWr7Wtn2tbra5l
H13DnT+P+TibKtZ2d8HW/K414skKR9Ur13H55iJWeyV73s8wzFqvaBOo/4Oi
Lfoy9wo3vLHaCrdBLldIbs/YK93LrXTblYOdw73S3Q4ntdIt2/P1SjfVY/mV
7prq9kp352iplW7ZXI1Vuv167z7DivKZWueWYKZWuf0KSp7PInBjdW4pLnkO
jT6Nd6HGNlW6U6rOUqXbrpit1Vypxi1DI8+TbGVjFGWuYnsRvlZF6W7BYo3N
rXQkkzX2MivfJYOotCJjtpdA8UZmQv3+leJdKsEnlWxppTvc+o3KcOGtL6K3
SuVbDW4A9f2y+Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{388, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->26902241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"x", "/.", "%"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->315205552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{321, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->186017280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1993328066],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NumberFieldRootsOfUnity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRootsOfUnity"]], "InlineFormula"],
 " to find all roots of unity in a number field:"
}], "ExampleText",
 CellID->1119912062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"I", "+", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1815343726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["5", "12"], ",", 
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "6"], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       FractionBox["5", "12"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{466, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64821343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->939768968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{321, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->822907402]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "Approximate numbers will always return ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->497067422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "4."}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414686999],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154661806]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootApproximant"]], "InlineFormula"],
 " to get an exact number: "
}], "ExampleText",
 CellID->47988357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootApproximant", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "4."}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->110285778],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{114, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9285563]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->527190086],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->249389035]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRootsOfUnity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRootsOfUnity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cyclotomic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cyclotomic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->402017945],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->648668173]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RootOfUnityQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 8.7724264}", "context" -> "System`", 
    "keywords" -> {"cyclotomic root", "number field unit"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RootOfUnityQ[a] yields True if a is a root of unity, and yields False \
otherwise.", "synonyms" -> {"root of unity q"}, "title" -> "RootOfUnityQ", 
    "type" -> "Symbol", "uri" -> "ref/RootOfUnityQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6130, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->670197683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27777, 1041}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2157, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2780, 79, 1577, 37, 70, "ObjectNameGrid"],
Cell[4360, 118, 852, 28, 70, "Usage",
 CellID->5858]
}, Open  ]],
Cell[CellGroupData[{
Cell[5249, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5727, 168, 366, 15, 70, "Notes",
 CellID->3998]
}, Closed]],
Cell[CellGroupData[{
Cell[6130, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->670197683],
Cell[CellGroupData[{
Cell[6515, 202, 148, 5, 70, "ExampleSection",
 CellID->115594938],
Cell[CellGroupData[{
Cell[6688, 211, 138, 4, 28, "Input",
 CellID->42152485],
Cell[6829, 217, 161, 5, 36, "Output",
 CellID->529394139]
}, Open  ]],
Cell[CellGroupData[{
Cell[7027, 227, 131, 4, 28, "Input",
 CellID->284819305],
Cell[7161, 233, 161, 5, 36, "Output",
 CellID->43888803]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7371, 244, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[7595, 253, 63, 1, 70, "ExampleText",
 CellID->217489883],
Cell[CellGroupData[{
Cell[7683, 258, 406, 14, 70, "Input",
 CellID->335296387],
Cell[8092, 274, 161, 5, 36, "Output",
 CellID->901930641]
}, Open  ]],
Cell[8268, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->254208548],
Cell[8396, 287, 179, 7, 70, "ExampleText",
 CellID->1138092353],
Cell[CellGroupData[{
Cell[8600, 298, 321, 10, 70, "Input",
 CellID->1243611591],
Cell[8924, 310, 160, 5, 36, "Output",
 CellID->54436894]
}, Open  ]],
Cell[9099, 318, 126, 3, 70, "ExampleDelimiter",
 CellID->2124599860],
Cell[9228, 323, 201, 7, 70, "ExampleText",
 CellID->1939248351],
Cell[CellGroupData[{
Cell[9454, 334, 360, 12, 70, "Input",
 CellID->587724738],
Cell[9817, 348, 160, 5, 36, "Output",
 CellID->40019440]
}, Open  ]],
Cell[9992, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->710751266],
Cell[10120, 361, 66, 1, 70, "ExampleText",
 CellID->965498331],
Cell[CellGroupData[{
Cell[10211, 366, 109, 3, 70, "Input",
 CellID->744012385],
Cell[10323, 371, 161, 5, 36, "Output",
 CellID->63887156]
}, Open  ]],
Cell[10499, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->157929998],
Cell[10627, 384, 218, 7, 70, "ExampleText",
 CellID->39688694],
Cell[CellGroupData[{
Cell[10870, 395, 274, 10, 70, "Input",
 CellID->1327949488],
Cell[11147, 407, 209, 7, 36, "Output",
 CellID->35362629]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11405, 420, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[11646, 429, 291, 11, 70, "ExampleText",
 CellID->1329570083],
Cell[11940, 442, 424, 15, 70, "Input",
 CellID->1930901238],
Cell[CellGroupData[{
Cell[12389, 461, 129, 4, 70, "Input",
 CellID->2031717249],
Cell[12521, 467, 158, 5, 36, "Output",
 CellID->491657854]
}, Open  ]],
Cell[12694, 475, 121, 3, 70, "ExampleText",
 CellID->629165267],
Cell[CellGroupData[{
Cell[12840, 482, 114, 3, 70, "Input",
 CellID->1527295082],
Cell[12957, 487, 161, 5, 36, "Output",
 CellID->395427267]
}, Open  ]],
Cell[CellGroupData[{
Cell[13155, 497, 99, 3, 70, "Input",
 CellID->171164641],
Cell[13257, 502, 158, 5, 36, "Output",
 CellID->193058670]
}, Open  ]],
Cell[13430, 510, 126, 3, 70, "ExampleDelimiter",
 CellID->1517037946],
Cell[13559, 515, 111, 3, 70, "ExampleText",
 CellID->17638],
Cell[CellGroupData[{
Cell[13695, 522, 220, 8, 70, "Input",
 CellID->31656],
Cell[13918, 532, 158, 5, 36, "Output",
 CellID->381930149]
}, Open  ]],
Cell[CellGroupData[{
Cell[14113, 542, 229, 8, 70, "Input",
 CellID->16705],
Cell[14345, 552, 162, 5, 36, "Output",
 CellID->357814731]
}, Open  ]],
Cell[14522, 560, 125, 3, 70, "ExampleDelimiter",
 CellID->213967840],
Cell[14650, 565, 144, 4, 70, "ExampleText",
 CellID->1019362567],
Cell[14797, 571, 219, 8, 70, "Input",
 CellID->1593362544],
Cell[CellGroupData[{
Cell[15041, 583, 108, 3, 70, "Input",
 CellID->523198918],
Cell[15152, 588, 161, 5, 36, "Output",
 CellID->102451451]
}, Open  ]],
Cell[CellGroupData[{
Cell[15350, 598, 335, 11, 70, "Input",
 CellID->1949611450],
Cell[15688, 611, 160, 5, 36, "Output",
 CellID->12192238]
}, Open  ]],
Cell[15863, 619, 95, 1, 70, "ExampleText",
 CellID->1269861802],
Cell[CellGroupData[{
Cell[15983, 624, 224, 8, 70, "Input",
 CellID->322833900],
Cell[16210, 634, 1386, 27, 70, "Output",
 Evaluatable->False,
 CellID->26902241]
}, Open  ]],
Cell[CellGroupData[{
Cell[17633, 666, 132, 4, 70, "Input",
 CellID->315205552],
Cell[17768, 672, 295, 9, 36, "Output",
 CellID->186017280]
}, Open  ]],
Cell[18078, 684, 126, 3, 70, "ExampleDelimiter",
 CellID->1993328066],
Cell[18207, 689, 263, 8, 70, "ExampleText",
 CellID->1119912062],
Cell[CellGroupData[{
Cell[18495, 701, 175, 5, 70, "Input",
 CellID->1815343726],
Cell[18673, 708, 3205, 104, 201, "Output",
 CellID->64821343]
}, Open  ]],
Cell[CellGroupData[{
Cell[21915, 817, 108, 3, 70, "Input",
 CellID->939768968],
Cell[22026, 822, 295, 9, 36, "Output",
 CellID->822907402]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22370, 837, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[22604, 846, 216, 8, 70, "ExampleText",
 CellID->497067422],
Cell[CellGroupData[{
Cell[22845, 858, 189, 6, 70, "Input",
 CellID->414686999],
Cell[23037, 866, 162, 5, 36, "Output",
 CellID->154661806]
}, Open  ]],
Cell[23214, 874, 224, 8, 70, "ExampleText",
 CellID->47988357],
Cell[CellGroupData[{
Cell[23463, 886, 192, 6, 70, "Input",
 CellID->110285778],
Cell[23658, 894, 282, 10, 39, "Output",
 CellID->9285563]
}, Open  ]],
Cell[CellGroupData[{
Cell[23977, 909, 108, 3, 70, "Input",
 CellID->527190086],
Cell[24088, 914, 161, 5, 36, "Output",
 CellID->249389035]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24310, 926, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24629, 937, 1001, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[25667, 977, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[25988, 988, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[26184, 996, 319, 9, 70, "MoreAboutSection",
 CellID->402017945],
Cell[26506, 1007, 156, 3, 70, "MoreAbout",
 CellID->648668173]
}, Open  ]],
Cell[26677, 1013, 27, 0, 70, "History"],
Cell[26707, 1015, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

