(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42130,       1481]
NotebookOptionsPosition[     35440,       1247]
NotebookOutlinePosition[     36741,       1285]
CellTagsIndexPosition[     36655,       1280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/AlgebraicNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Root" :> Documentation`HelpLookup["paclet:ref/Root"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"], "ToRadicals" :> 
          Documentation`HelpLookup["paclet:ref/ToRadicals"], 
          "RootApproximant" :> 
          Documentation`HelpLookup["paclet:ref/RootApproximant"], 
          "AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
          "ToNumberField" :> 
          Documentation`HelpLookup["paclet:ref/ToNumberField"], 
          "QuadraticIrrationalQ" :> 
          Documentation`HelpLookup["paclet:ref/QuadraticIrrationalQ"], 
          "AlgebraicIntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicIntegerQ"], 
          "AlgebraicUnitQ" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicUnitQ"], 
          "RootOfUnityQ" :> 
          Documentation`HelpLookup["paclet:ref/RootOfUnityQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Root\"\>", 
       2->"\<\"MinimalPolynomial\"\>", 3->"\<\"FullSimplify\"\>", 
       4->"\<\"Solve\"\>", 5->"\<\"ToRadicals\"\>", 
       6->"\<\"RootApproximant\"\>", 7->"\<\"AlgebraicNumber\"\>", 
       8->"\<\"ToNumberField\"\>", 9->"\<\"QuadraticIrrationalQ\"\>", 
       10->"\<\"AlgebraicIntegerQ\"\>", 11->"\<\"AlgebraicUnitQ\"\>", 
       12->"\<\"RootOfUnityQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Algebraic Number Theory\"\>", 
       3->"\<\"Algebraic Transformations\"\>", 
       4->"\<\"Formula Manipulation\"\>", 5->"\<\"Number Recognition\"\>", 
       6->"\<\"Number Theory\"\>", 
       7->"\<\"Polynomial Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RootReduce", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootReduce",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootReduce"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to reduce ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a single ",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " consists only of integers and ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects combined using algebraic operations, then the result from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " will always be a single ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20690],

Cell[TextData[{
 "Simple ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects may in turn automatically evaluate to rational expressions or \
combinations of radicals. "
}], "Notes",
 CellID->17274],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->281986828],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->51682969],

Cell[TextData[{
 "Reduce to a single ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->601947272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150631656],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13202530]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19512],

Cell["Combinations of radical expressions:", "ExampleText",
 CellID->109473477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], "+", 
   RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205092857],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "121"}], "-", 
     RowBox[{"60", " ", "#1"}], "+", 
     RowBox[{"75", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"15", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{320, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->667715345]
}, Open  ]],

Cell[TextData[{
 "Combinations of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->171710468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "+", "#", "+", "17"}], "&"}], ",", "1"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->625949605],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1419857"}], "+", 
     RowBox[{"918731", " ", "#1"}], "+", 
     RowBox[{"111166451", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"1446", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"162316", " ", 
      SuperscriptBox["#1", "6"]}], "+", 
     RowBox[{"139997", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     RowBox[{"85", " ", 
      SuperscriptBox["#1", "10"]}], "+", 
     RowBox[{"22", " ", 
      SuperscriptBox["#1", "11"]}], "+", 
     SuperscriptBox["#1", "15"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{416, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621685436]
}, Open  ]],

Cell[TextData[{
 "Reduce any algebraic combination of radicals, ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->437818124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "3"}], "-", 
         RowBox[{"7", "#"}], "-", "2"}], "&"}], ",", "1"}], "]"}], "+", "1"}],
     "]"}], "/", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"3", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->479223030],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "-", 
     RowBox[{"1776", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"95172", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"3638684", " ", 
      SuperscriptBox["#1", "6"]}], "-", 
     RowBox[{"167587971", " ", 
      SuperscriptBox["#1", "8"]}], "+", 
     RowBox[{"4220553675", " ", 
      SuperscriptBox["#1", "10"]}], "-", 
     RowBox[{"24455916591", " ", 
      SuperscriptBox["#1", "12"]}], "+", 
     RowBox[{"909956170104", " ", 
      SuperscriptBox["#1", "14"]}], "-", 
     RowBox[{"2071582014204", " ", 
      SuperscriptBox["#1", "16"]}], "+", 
     RowBox[{"24011685629584", " ", 
      SuperscriptBox["#1", "18"]}]}], "&"}], ",", "12"}], "]"}]], "Output",
 ImageSize->{472, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->608534347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53029783],

Cell[TextData[{
 "The result is always a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object, a quadratic radical expression or a rational number:"
}], "ExampleText",
 CellID->400136288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "7", "]"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9106600],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"49", "-", 
     RowBox[{"70", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]], "Output",
 ImageSize->{170, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39604277]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}], "+", 
     RowBox[{"Sqrt", "[", "6", "]"}], "+", "3"}], ")"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47417842],

Cell[BoxData[
 RowBox[{"1", "+", 
  SqrtBox["3"]}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52558668]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sqrt", "[", "18", "]"}], "+", 
     RowBox[{"Sqrt", "[", "27", "]"}]}], ")"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210240493],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21028057]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29409],

Cell[TextData[{
 "The numeric test used by ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " cannot prove the equality:"
}], "ExampleText",
 CellID->296839405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}], "+", 
   RowBox[{"Sqrt", "[", "5", "]"}]}], "\[Equal]", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"10", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "15", "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"4", "+", 
       RowBox[{"Sqrt", "[", "15", "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210777602],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"], "+", 
   SqrtBox["5"]}], "\[Equal]", 
  SqrtBox[
   RowBox[{"10", "+", 
    RowBox[{"2", " ", 
     SqrtBox["15"]}], "+", 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"4", "+", 
       SqrtBox["15"]}]]}]}]]}]], "Output",
 ImageSize->{298, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173300649]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " proves that the two algebraic numbers are equal:"
}], "ExampleText",
 CellID->722385738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151074847],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531461966]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " will use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->290533089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->39963694],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->735512528]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16990],

Cell[TextData[{
 "The results given by ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " are canonical:"
}], "ExampleText",
 CellID->528517893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"algs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}], "+", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], ",", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"10", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "15", "]"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"4", "+", 
         RowBox[{"Sqrt", "[", "15", "]"}]}], "]"}]}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"25", "+", 
       RowBox[{"4", 
        RowBox[{"Sqrt", "[", "15", "]"}]}], "+", 
       RowBox[{"2", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"46", "+", 
          RowBox[{"8", 
           RowBox[{"Sqrt", "[", "15", "]"}]}]}], "]"}]}]}], "]"}], "-", 
     RowBox[{"Sqrt", "[", "5", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236140470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"], "+", 
    SqrtBox["5"]}], ",", 
   SqrtBox[
    RowBox[{"10", "+", 
     RowBox[{"2", " ", 
      SqrtBox["15"]}], "+", 
     RowBox[{"4", " ", 
      SqrtBox[
       RowBox[{"4", "+", 
        SqrtBox["15"]}]]}]}]], ",", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["5"]}], "+", 
    SqrtBox[
     RowBox[{"25", "+", 
      RowBox[{"4", " ", 
       SqrtBox["15"]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"46", "+", 
         RowBox[{"8", " ", 
          SqrtBox["15"]}]}]]}]}]]}]}], "}"}]], "Output",
 ImageSize->{558, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239007829]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "/@", "algs"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65358980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"576", "-", 
       RowBox[{"960", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"352", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"40", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", "8"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"576", "-", 
       RowBox[{"960", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"352", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"40", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", "8"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"576", "-", 
       RowBox[{"960", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"352", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"40", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", "8"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{304, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49999670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57957924],

Cell["\<\
In general the degree of the reduced polynomial will be the product of the \
degrees:\
\>", "ExampleText",
 CellID->78176111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "+", "#", "+", "11"}], "&"}], ",", "1"}], 
    "]"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "+", "#", "+", "17"}], "&"}], ",", "1"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713699413],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"21952", "-", 
     RowBox[{"2352", " ", "#1"}], "-", 
     RowBox[{"2693", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"84", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"9", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"84", " ", 
      SuperscriptBox["#1", "6"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     SuperscriptBox["#1", "9"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{448, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165369245]
}, Open  ]],

Cell["In exceptional cases the result can have a lower degree:", "ExampleText",
 CellID->79404532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{"%", "-", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "+", "#", "+", "11"}], "&"}], ",", "1"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->352255210],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"17", "+", "#1", "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{148, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->819760576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202719249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects can be converted to ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->298777640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], "+", "#", "+", "11"}], "&"}], ",", "1"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305329187],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"11", "+", "#1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{372, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37781214]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " converts from ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->703879791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44874583],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"11", "+", "#1", "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{148, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250094997]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24064],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuadraticIrrationalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QuadraticIrrationalQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicIntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicIntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicUnitQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicUnitQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootOfUnityQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootOfUnityQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23751]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10570],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "Tutorials",
 CellID->20150]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->84282223],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->29214831],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->29332108],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->530020543],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->17678981],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->136748696],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->251656941],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->78979916]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RootReduce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 9.3036900}", "context" -> "System`", 
    "keywords" -> {
     "combining radicals", "reducing radicals", "roots", 
      "simplifying radicals"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RootReduce[expr] attempts to reduce expr to a single Root object. ", 
    "synonyms" -> {"root reduce"}, "title" -> "RootReduce", "type" -> 
    "Symbol", "uri" -> "ref/RootReduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11663, 303, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->281986828]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36511, 1273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3982, 86, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4605, 113, 4194, 83, 70, "ObjectNameGrid"],
Cell[8802, 198, 702, 23, 70, "Usage",
 CellID->6292]
}, Open  ]],
Cell[CellGroupData[{
Cell[9541, 226, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10019, 243, 935, 31, 70, "Notes",
 CellID->20690],
Cell[10957, 276, 270, 9, 70, "Notes",
 CellID->17274],
Cell[11230, 287, 396, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[11663, 303, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->281986828],
Cell[CellGroupData[{
Cell[12048, 317, 147, 5, 70, "ExampleSection",
 CellID->51682969],
Cell[12198, 324, 201, 8, 70, "ExampleText",
 CellID->601947272],
Cell[CellGroupData[{
Cell[12424, 336, 193, 6, 28, "Input",
 CellID->150631656],
Cell[12620, 344, 349, 12, 39, "Output",
 CellID->13202530]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13018, 362, 216, 7, 70, "ExampleSection",
 CellID->19512],
Cell[13237, 371, 79, 1, 70, "ExampleText",
 CellID->109473477],
Cell[CellGroupData[{
Cell[13341, 376, 236, 8, 70, "Input",
 CellID->205092857],
Cell[13580, 386, 542, 18, 39, "Output",
 CellID->667715345]
}, Open  ]],
Cell[14137, 407, 199, 8, 70, "ExampleText",
 CellID->171710468],
Cell[CellGroupData[{
Cell[14361, 419, 440, 16, 70, "Input",
 CellID->625949605],
Cell[14804, 437, 769, 24, 58, "Output",
 CellID->621685436]
}, Open  ]],
Cell[15588, 464, 372, 13, 70, "ExampleText",
 CellID->437818124],
Cell[CellGroupData[{
Cell[15985, 481, 581, 20, 70, "Input",
 CellID->479223030],
Cell[16569, 503, 914, 27, 75, "Output",
 CellID->608534347]
}, Open  ]],
Cell[17498, 533, 124, 3, 70, "ExampleDelimiter",
 CellID->53029783],
Cell[17625, 538, 258, 8, 70, "ExampleText",
 CellID->400136288],
Cell[CellGroupData[{
Cell[17908, 550, 272, 9, 70, "Input",
 CellID->9106600],
Cell[18183, 561, 350, 12, 39, "Output",
 CellID->39604277]
}, Open  ]],
Cell[CellGroupData[{
Cell[18570, 578, 412, 13, 70, "Input",
 CellID->47417842],
Cell[18985, 593, 191, 7, 38, "Output",
 CellID->52558668]
}, Open  ]],
Cell[CellGroupData[{
Cell[19213, 605, 361, 12, 70, "Input",
 CellID->210240493],
Cell[19577, 619, 157, 5, 36, "Output",
 CellID->21028057]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19783, 630, 223, 7, 70, "ExampleSection",
 CellID->29409],
Cell[20009, 639, 228, 8, 70, "ExampleText",
 CellID->296839405],
Cell[CellGroupData[{
Cell[20262, 651, 467, 15, 70, "Input",
 CellID->210777602],
Cell[20732, 668, 433, 18, 60, "Output",
 CellID->173300649]
}, Open  ]],
Cell[21180, 689, 230, 7, 70, "ExampleText",
 CellID->722385738],
Cell[CellGroupData[{
Cell[21435, 700, 106, 3, 70, "Input",
 CellID->151074847],
Cell[21544, 705, 161, 5, 36, "Output",
 CellID->531461966]
}, Open  ]],
Cell[21720, 713, 324, 12, 70, "ExampleText",
 CellID->290533089],
Cell[CellGroupData[{
Cell[22069, 729, 108, 3, 70, "Input",
 CellID->39963694],
Cell[22180, 734, 161, 5, 36, "Output",
 CellID->735512528]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22390, 745, 233, 7, 70, "ExampleSection",
 CellID->16990],
Cell[22626, 754, 222, 8, 70, "ExampleText",
 CellID->528517893],
Cell[CellGroupData[{
Cell[22873, 766, 894, 28, 70, "Input",
 CellID->236140470],
Cell[23770, 796, 751, 31, 60, "Output",
 CellID->239007829]
}, Open  ]],
Cell[CellGroupData[{
Cell[24558, 832, 104, 3, 70, "Input",
 CellID->65358980],
Cell[24665, 837, 1263, 41, 77, "Output",
 CellID->49999670]
}, Open  ]],
Cell[25943, 881, 124, 3, 70, "ExampleDelimiter",
 CellID->57957924],
Cell[26070, 886, 135, 4, 70, "ExampleText",
 CellID->78176111],
Cell[CellGroupData[{
Cell[26230, 894, 427, 16, 70, "Input",
 CellID->713699413],
Cell[26660, 912, 658, 21, 39, "Output",
 CellID->165369245]
}, Open  ]],
Cell[27333, 936, 98, 1, 70, "ExampleText",
 CellID->79404532],
Cell[CellGroupData[{
Cell[27456, 941, 278, 10, 70, "Input",
 CellID->352255210],
Cell[27737, 953, 296, 10, 39, "Output",
 CellID->819760576]
}, Open  ]],
Cell[28048, 966, 125, 3, 70, "ExampleDelimiter",
 CellID->202719249],
Cell[28176, 971, 345, 12, 70, "ExampleText",
 CellID->298777640],
Cell[CellGroupData[{
Cell[28546, 987, 252, 9, 70, "Input",
 CellID->305329187],
Cell[28801, 998, 451, 15, 39, "Output",
 CellID->37781214]
}, Open  ]],
Cell[29267, 1016, 343, 12, 70, "ExampleText",
 CellID->703879791],
Cell[CellGroupData[{
Cell[29635, 1032, 105, 3, 70, "Input",
 CellID->44874583],
Cell[29743, 1037, 296, 10, 39, "Output",
 CellID->250094997]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30100, 1054, 311, 9, 70, "SeeAlsoSection",
 CellID->24064],
Cell[30414, 1065, 3017, 107, 70, "SeeAlso",
 CellID->23751]
}, Open  ]],
Cell[CellGroupData[{
Cell[33468, 1177, 314, 9, 70, "TutorialsSection",
 CellID->10570],
Cell[33785, 1188, 144, 3, 70, "Tutorials",
 CellID->20150]
}, Open  ]],
Cell[CellGroupData[{
Cell[33966, 1196, 318, 9, 70, "MoreAboutSection",
 CellID->84282223],
Cell[34287, 1207, 144, 3, 70, "MoreAbout",
 CellID->29214831],
Cell[34434, 1212, 155, 3, 70, "MoreAbout",
 CellID->29332108],
Cell[34592, 1217, 161, 3, 70, "MoreAbout",
 CellID->530020543],
Cell[34756, 1222, 150, 3, 70, "MoreAbout",
 CellID->17678981],
Cell[34909, 1227, 147, 3, 70, "MoreAbout",
 CellID->136748696],
Cell[35059, 1232, 137, 3, 70, "MoreAbout",
 CellID->251656941],
Cell[35199, 1237, 146, 3, 70, "MoreAbout",
 CellID->78979916]
}, Open  ]],
Cell[35360, 1243, 50, 0, 70, "History"],
Cell[35413, 1245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

