(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70386,       2656]
NotebookOptionsPosition[     59383,       2268]
NotebookOutlinePosition[     60672,       2305]
CellTagsIndexPosition[     60586,       2300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "The Representation of Equations and Solutions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfEquationsAndSolutions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Solving Equations\"\>", 
       2->"\<\"The Representation of Equations and Solutions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "NRoots" :> Documentation`HelpLookup["paclet:ref/NRoots"], "NSolve" :> 
          Documentation`HelpLookup["paclet:ref/NSolve"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "ToRules" :> 
          Documentation`HelpLookup["paclet:ref/ToRules"], "ToRadicals" :> 
          Documentation`HelpLookup["paclet:ref/ToRadicals"], "Root" :> 
          Documentation`HelpLookup["paclet:ref/Root"], "RootIntervals" :> 
          Documentation`HelpLookup["paclet:ref/RootIntervals"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "Decompose" :> 
          Documentation`HelpLookup["paclet:ref/Decompose"], 
          "InterpolatingPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingPolynomial"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Solve\"\>", 
       2->"\<\"NRoots\"\>", 3->"\<\"NSolve\"\>", 4->"\<\"FindRoot\"\>", 
       5->"\<\"Reduce\"\>", 6->"\<\"ToRules\"\>", 7->"\<\"ToRadicals\"\>", 
       8->"\<\"Root\"\>", 9->"\<\"RootIntervals\"\>", 10->"\<\"Factor\"\>", 
       11->"\<\"Decompose\"\>", 
       12->"\<\"InterpolatingPolynomial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Roots", "ObjectName",
 CellID->17248],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Roots",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Roots"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["lhs", "TI"], "==", 
         StyleBox["rhs", "TI"]}], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a disjunction of equations which represent the \
roots of a polynomial equation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " in trying to find roots. "
}], "Notes",
 CellID->5950],

Cell[TextData[{
 "You can find numerical values of the roots by applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9878],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " can take the following options: "
}], "Notes",
 CellID->1041],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Cubics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cubics"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to generate explicit solutions for cubics ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "EquatedTo", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell["\<\
expression to which the variable solved for should be equated \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[
    "integer modulus ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Multiplicity", "1", Cell[
    "multiplicity in final list of solutions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Quartics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Quartics"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to generate explicit solutions for quartics ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Using", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "subsidiary equations to be solved ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->15431],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " is generated when ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and related functions cannot produce explicit solutions. Options are often \
given in such cases. "
}], "Notes",
 CellID->2080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " gives several identical equations when roots with multiplicity greater \
than one occur. "
}], "Notes",
 CellID->21459]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44074771],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->399854455],

Cell["Find roots of univariate polynomial equations:", "ExampleText",
 CellID->222378076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"5", "x"}], "+", "4"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202394564],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["17"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["17"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{295, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3548109]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->225978192],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "b"}], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
    RowBox[{"2", " ", "a"}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "b"}], "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
    RowBox[{"2", " ", "a"}]]}]}]], "Output",
 ImageSize->{277, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->566038127]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21788],

Cell["Equation with exact numeric coefficients:", "ExampleText",
 CellID->781401373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}]}], "-", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171135603],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]]}]}]}]], "Output",
 ImageSize->{502, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2751395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29389723],

Cell["Equation with symbolic coefficients:", "ExampleText",
 CellID->106068437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", 
      RowBox[{"a", "^", "2"}], " ", "x"}], "+", 
     RowBox[{"a", "^", "3"}]}], "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1923241],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "-", 
      RowBox[{
       SqrtBox["5"], " ", "a"}]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{
       SqrtBox["5"], " ", "a"}]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", "a"}]}]], "Output",
 ImageSize->{301, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35752640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157429069],

Cell["\<\
General equations of degree five and higher cannot be solved in radicals:\
\>", "ExampleText",
 CellID->243800233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"22", "x"}], "+", "19"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498983590],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"19", "-", 
       RowBox[{"22", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"19", "-", 
       RowBox[{"22", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"19", "-", 
       RowBox[{"22", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"19", "-", 
       RowBox[{"22", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"19", "-", 
       RowBox[{"22", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}]}]], "Output",
 ImageSize->{417, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124871422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71706631],

Cell["\<\
This equation of degree nine is solved in radicals using factorization and \
decomposition:\
\>", "ExampleText",
 CellID->5364765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "9"}], "-", 
     RowBox[{"5", 
      RowBox[{"x", "^", "6"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"x", "^", "3"}]}], "-", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4085370],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"2", "/", "3"}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       SqrtBox["3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "-", 
      SqrtBox["3"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SqrtBox["3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       SqrtBox["3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SqrtBox["3"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]}]], "Output",
 ImageSize->{531, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->924349596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21487124],

Cell["An equation with inexact numeric coeficients:", "ExampleText",
 CellID->150411489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"1.7", 
      RowBox[{"x", "^", "3"}]}], "-", 
     RowBox[{"22.5", "x"}], "-", "9.7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225100785],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "2.281573277071458`"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "0.4258970267386489`"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"0.12270456402633292`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.0098287177355827`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"0.12270456402633292`", "\[InvisibleSpace]", "+", 
    RowBox[{"2.0098287177355827`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", "2.4620611757574413`"}]}]], "Output",
 ImageSize->{429, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16245457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->562999235],

Cell["\<\
Multiple roots are repeated the corresponding number of times:\
\>", "ExampleText",
 CellID->200695699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "a"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "b"}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "c"}], ")"}], "^", "3"}]}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->309412725],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "b"}], "||", 
  RowBox[{"x", "\[Equal]", "b"}], "||", 
  RowBox[{"x", "\[Equal]", "c"}], "||", 
  RowBox[{"x", "\[Equal]", "c"}], "||", 
  RowBox[{"x", "\[Equal]", "c"}]}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337390343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277373987],

Cell["Find roots over the integers modulo 7:", "ExampleText",
 CellID->8693353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "-", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641269130],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "4"}], "||", 
  RowBox[{"x", "\[Equal]", "6"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309578166]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5041],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cubics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21584],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " uses the general formulas for solving cubic equations in radicals:"
}], "ExampleText",
 CellID->220090341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372845523],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox[
       SuperscriptBox["5", 
        RowBox[{"2", "/", "3"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "+", 
           RowBox[{"3", " ", 
            SqrtBox["6"]}]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}]}]], "Output",
 ImageSize->{401, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399467051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16052157],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " does not use the general formulas for solving cubics in radicals:"
}], "ExampleText",
 CellID->787611263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x", ",", 
   RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167874115],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",
 ImageSize->{456, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375291508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498558193],

Cell["\<\
Solving this cubic equation in radicals does not require the general \
formulas:\
\>", "ExampleText",
 CellID->11948901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", "7"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272226972],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["7", 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "7"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["7", 
    RowBox[{"1", "/", "3"}]]}]}]], "Output",
 ImageSize->{260, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141768323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EquatedTo",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20778],

Cell[TextData[{
 "Use ",
 Cell[BoxData["EquatedTo"], "InlineFormula"],
 " to specify the left-hand side of the returned equations:"
}], "ExampleText",
 CellID->129364709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"EquatedTo", "\[Rule]", 
    RowBox[{"z", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348358665],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["z", "3"], "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{
   SuperscriptBox["z", "3"], "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{
   SuperscriptBox["z", "3"], "\[Equal]", "1"}]}]], "Output",
 ImageSize->{298, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126260654]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4137],

Cell["Find roots over the integers modulo 12:", "ExampleText",
 CellID->11388359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "3"}]}], "+", 
     RowBox[{"5", "x"}], "-", "10"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136398154],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"x", "\[Equal]", "7"}], "||", 
  RowBox[{"x", "\[Equal]", "10"}], "||", 
  RowBox[{"x", "\[Equal]", "11"}]}]], "Output",
 ImageSize->{201, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23730605]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Multiplicity",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28216],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Multiplicity", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the multiplicity of each root is multiplied by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->974679477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "^", "3"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "b"}], ")"}]}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Multiplicity", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->492627958],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "a"}], "||", 
  RowBox[{"x", "\[Equal]", "b"}], "||", 
  RowBox[{"x", "\[Equal]", "b"}]}]], "Output",
 ImageSize->{390, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159182938]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Quartics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17047],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " uses the general formulas for solving quartic equations in radicals:"
}], "ExampleText",
 CellID->27644364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Roots", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x"}], "]"}], "//",
   "Last"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382571917],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox["4", "3"]}], "+", 
      FractionBox["52", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "317"}], "+", 
             RowBox[{"9", " ", "\[ImaginaryI]", " ", 
              SqrtBox["5703"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "317"}], "+", 
            RowBox[{"9", " ", "\[ImaginaryI]", " ", 
             SqrtBox["5703"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "-", 
         FractionBox["52", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "317"}], "+", 
               RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                SqrtBox["5703"]}]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "317"}], "+", 
              RowBox[{"9", " ", "\[ImaginaryI]", " ", 
               SqrtBox["5703"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]], "+", 
         FractionBox["18", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             FractionBox["4", "3"]}], "+", 
            FractionBox["52", 
             RowBox[{"3", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "317"}], "+", 
                   RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}]], "+", 
            RowBox[{
             FractionBox["1", "3"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "317"}], "+", 
                  RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                   SqrtBox["5703"]}]}], ")"}]}], ")"}], 
              RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], 
      ")"}]}]}]}]}]], "Output",
 ImageSize->{480, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115635076]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171894524],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " does not use the general formulas for solving quartics:"
}], "ExampleText",
 CellID->17220102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x", ",", 
   RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451444385],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{466, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183907179]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35639222],

Cell["\<\
Solving this quartic equation in radicals does not require the general \
formulas:\
\>", "ExampleText",
 CellID->118324951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"7", 
      RowBox[{"x", "^", "2"}]}], "+", "5"}], "\[Equal]", "0"}], ",", "x", ",",
    
   RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17849633],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       SqrtBox["29"]}], ")"}]}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox[
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "-", 
        SqrtBox["29"]}], ")"}]}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox[
    RowBox[{
     FractionBox["7", "2"], "+", 
     FractionBox[
      SqrtBox["29"], "2"]}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox[
     RowBox[{
      FractionBox["7", "2"], "+", 
      FractionBox[
       SqrtBox["29"], "2"]}]]}]}]}]], "Output",
 ImageSize->{527, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291482575]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Using",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31431],

Cell["Specify equations satisfied by symbolic parameters:", "ExampleText",
 CellID->693718440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"a", " ", "x"}], "+", "2"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Using", "\[Rule]", 
    RowBox[{"Roots", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", "5"}], "\[Equal]", "0"}], ",", "a"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->553981606],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", 
           SqrtBox["3"]}], "-", 
          SqrtBox["5"]}], ")"}]}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}], "-", 
          SqrtBox["5"]}], ")"}]}]}]}], ")"}], "&&", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox["5"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", 
           SqrtBox["3"]}], "+", 
          SqrtBox["5"]}], ")"}]}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}], "+", 
          SqrtBox["5"]}], ")"}]}]}]}], ")"}], "&&", 
    RowBox[{"a", "\[Equal]", 
     SqrtBox["5"]}]}], ")"}]}]], "Output",
 ImageSize->{399, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27037432]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16886],

Cell[TextData[{
 "Solutions returned by ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " satisfy the equation:"
}], "ExampleText",
 CellID->220577594],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"2", "x"}], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->285402124],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{281, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163377691]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRules"]], "InlineFormula"],
 " to convert equations returned by ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " to replacement rules:"
}], "ExampleText",
 CellID->531288593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "\[Equal]", "0"}], "/.", 
  RowBox[{"{", 
   RowBox[{"ToRules", "[", "%", "]"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134233071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322767823]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " to find solutions of univariate equations and returns replacement rules:"
}], "ExampleText",
 CellID->706292441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->647239162],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{317, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->514554279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157283281],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Roots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
 " finds all complex solutions:"
}], "ExampleText",
 CellID->14168195],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "6"}], "+", 
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"10", 
     RowBox[{"x", "^", "2"}]}], "+", "8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->651925608],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"2", " ", "\[ImaginaryI]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{367, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232053325]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find solutions over specified domains:"
}], "ExampleText",
 CellID->288008655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->386495020],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{236, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66964456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->94418230],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->226243607]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find one solution:"
}], "ExampleText",
 CellID->26434858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->464452974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11445440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->389000042],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find solutions of systems of multivariate equations:"
}], "ExampleText",
 CellID->443328584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191102622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["2", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"15", "+", 
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["2", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"15", "-", 
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{585, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35546228]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7780548],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["2", "13"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["2", "13"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"2", " ", "x"}]}], ")"}]}]}]}]], "Output",
 ImageSize->{394, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28912269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134505620],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find solutions of systems of equations and inequalities:"
}], "ExampleText",
 CellID->265735518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<=", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99688369],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "26"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"3", " ", 
       SqrtBox["51"]}]}], ")"}]}], "\[LessEqual]", "x", "\[LessEqual]", 
   RowBox[{
    FractionBox["1", "26"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", 
       SqrtBox["51"]}]}], ")"}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"4", " ", "x"}]}], ")"}]}]}]}]], "Output",
 ImageSize->{339, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483364255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435009869],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NRoots"]], "InlineFormula"],
 " to find numeric approximations of roots of a univariate equation:"
}], "ExampleText",
 CellID->590077805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{"x", "^", "5"}]}], "-", 
     RowBox[{"3", "x"}], "+", "11"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274623960],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1.5065015098455397`"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.35417836391673957`"}], "-", 
    RowBox[{"1.405106873696224`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.35417836391673957`"}], "+", 
    RowBox[{"1.405106873696224`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1.1074291188395093`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.7157441161444917`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1.1074291188395093`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.7157441161444917`", " ", "\[ImaginaryI]"}]}]}]}]], "Output",
 ImageSize->{455, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141703652]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14319],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NRoots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NRoots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRules"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootIntervals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootIntervals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decompose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decompose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31985],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "Tutorials",
 CellID->20260],

Cell[TextData[ButtonBox["The Representation of Equations and Solutions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheRepresentationOfEquationsAndSolutions"]], "Tutorials",
 CellID->22871]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->54272405],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->330655959]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Roots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 10.0849600}", "context" -> "System`", 
    "keywords" -> {
     "roots of polynomials", "symbolic representation of roots"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Roots[lhs == rhs, var] yields a disjunction of equations which represent \
the roots of a polynomial equation. ", "synonyms" -> {}, "title" -> "Roots", 
    "type" -> "Symbol", "uri" -> "ref/Roots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8200, 249, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44074771]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60444, 2293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3084, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3707, 92, 43, 1, 70, "ObjectName",
 CellID->17248],
Cell[3753, 95, 641, 20, 70, "Usage",
 CellID->22636]
}, Open  ]],
Cell[CellGroupData[{
Cell[4431, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4909, 137, 443, 17, 70, "Notes",
 CellID->5950],
Cell[5355, 156, 214, 8, 70, "Notes",
 CellID->9878],
Cell[5572, 166, 193, 7, 70, "Notes",
 CellID->1041],
Cell[5768, 175, 1742, 44, 70, "3ColumnTableMod",
 CellID->15431],
Cell[7513, 221, 396, 13, 70, "Notes",
 CellID->2080],
Cell[7912, 236, 251, 8, 70, "Notes",
 CellID->21459]
}, Closed]],
Cell[CellGroupData[{
Cell[8200, 249, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44074771],
Cell[CellGroupData[{
Cell[8584, 263, 148, 5, 70, "ExampleSection",
 CellID->399854455],
Cell[8735, 270, 89, 1, 70, "ExampleText",
 CellID->222378076],
Cell[CellGroupData[{
Cell[8849, 275, 240, 9, 28, "Input",
 CellID->202394564],
Cell[9092, 286, 555, 21, 51, "Output",
 CellID->3548109]
}, Open  ]],
Cell[CellGroupData[{
Cell[9684, 312, 272, 10, 28, "Input",
 CellID->225978192],
Cell[9959, 324, 646, 24, 62, "Output",
 CellID->566038127]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10654, 354, 216, 7, 70, "ExampleSection",
 CellID->21788],
Cell[10873, 363, 84, 1, 70, "ExampleText",
 CellID->781401373],
Cell[CellGroupData[{
Cell[10982, 368, 267, 10, 70, "Input",
 CellID->171135603],
Cell[11252, 380, 809, 32, 44, "Output",
 CellID->2751395]
}, Open  ]],
Cell[12076, 415, 124, 3, 70, "ExampleDelimiter",
 CellID->29389723],
Cell[12203, 420, 79, 1, 70, "ExampleText",
 CellID->106068437],
Cell[CellGroupData[{
Cell[12307, 425, 300, 11, 70, "Input",
 CellID->1923241],
Cell[12610, 438, 610, 23, 51, "Output",
 CellID->35752640]
}, Open  ]],
Cell[13235, 464, 125, 3, 70, "ExampleDelimiter",
 CellID->157429069],
Cell[13363, 469, 124, 3, 70, "ExampleText",
 CellID->243800233],
Cell[CellGroupData[{
Cell[13512, 476, 242, 9, 70, "Input",
 CellID->498983590],
Cell[13757, 487, 1245, 41, 77, "Output",
 CellID->124871422]
}, Open  ]],
Cell[15017, 531, 124, 3, 70, "ExampleDelimiter",
 CellID->71706631],
Cell[15144, 536, 140, 4, 70, "ExampleText",
 CellID->5364765],
Cell[CellGroupData[{
Cell[15309, 544, 323, 12, 70, "Input",
 CellID->4085370],
Cell[15635, 558, 1798, 68, 67, "Output",
 CellID->924349596]
}, Open  ]],
Cell[17448, 629, 124, 3, 70, "ExampleDelimiter",
 CellID->21487124],
Cell[17575, 634, 88, 1, 70, "ExampleText",
 CellID->150411489],
Cell[CellGroupData[{
Cell[17688, 639, 305, 11, 70, "Input",
 CellID->225100785],
Cell[17996, 652, 693, 17, 54, "Output",
 CellID->16245457]
}, Open  ]],
Cell[18704, 672, 125, 3, 70, "ExampleDelimiter",
 CellID->562999235],
Cell[18832, 677, 113, 3, 70, "ExampleText",
 CellID->200695699],
Cell[CellGroupData[{
Cell[18970, 684, 399, 15, 70, "Input",
 CellID->309412725],
Cell[19372, 701, 406, 12, 36, "Output",
 CellID->337390343]
}, Open  ]],
Cell[19793, 716, 125, 3, 70, "ExampleDelimiter",
 CellID->277373987],
Cell[19921, 721, 79, 1, 70, "ExampleText",
 CellID->8693353],
Cell[CellGroupData[{
Cell[20025, 726, 283, 9, 70, "Input",
 CellID->641269130],
Cell[20311, 737, 241, 8, 36, "Output",
 CellID->309578166]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20601, 751, 217, 7, 70, "ExampleSection",
 CellID->5041],
Cell[CellGroupData[{
Cell[20843, 762, 223, 7, 70, "ExampleSubsection",
 CellID->21584],
Cell[21069, 771, 254, 8, 70, "ExampleText",
 CellID->220090341],
Cell[CellGroupData[{
Cell[21348, 783, 302, 11, 70, "Input",
 CellID->372845523],
Cell[21653, 796, 2803, 101, 174, "Output",
 CellID->399467051]
}, Open  ]],
Cell[24471, 900, 124, 3, 70, "ExampleDelimiter",
 CellID->16052157],
Cell[24598, 905, 474, 17, 70, "ExampleText",
 CellID->787611263],
Cell[CellGroupData[{
Cell[25097, 926, 348, 11, 70, "Input",
 CellID->167874115],
Cell[25448, 939, 1012, 33, 58, "Output",
 CellID->375291508]
}, Open  ]],
Cell[26475, 975, 125, 3, 70, "ExampleDelimiter",
 CellID->498558193],
Cell[26603, 980, 130, 4, 70, "ExampleText",
 CellID->11948901],
Cell[CellGroupData[{
Cell[26758, 988, 255, 8, 70, "Input",
 CellID->272226972],
Cell[27016, 998, 628, 23, 36, "Output",
 CellID->141768323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27693, 1027, 226, 7, 70, "ExampleSubsection",
 CellID->20778],
Cell[27922, 1036, 170, 5, 70, "ExampleText",
 CellID->129364709],
Cell[CellGroupData[{
Cell[28117, 1045, 310, 10, 70, "Input",
 CellID->348358665],
Cell[28430, 1057, 630, 24, 51, "Output",
 CellID->126260654]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29109, 1087, 223, 7, 70, "ExampleSubsection",
 CellID->4137],
Cell[29335, 1096, 81, 1, 70, "ExampleText",
 CellID->11388359],
Cell[CellGroupData[{
Cell[29441, 1101, 343, 11, 70, "Input",
 CellID->136398154],
Cell[29787, 1114, 325, 10, 36, "Output",
 CellID->23730605]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30161, 1130, 229, 7, 70, "ExampleSubsection",
 CellID->28216],
Cell[30393, 1139, 273, 10, 70, "ExampleText",
 CellID->974679477],
Cell[CellGroupData[{
Cell[30691, 1153, 360, 12, 70, "Input",
 CellID->492627958],
Cell[31054, 1167, 488, 14, 36, "Output",
 CellID->159182938]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31591, 1187, 225, 7, 70, "ExampleSubsection",
 CellID->17047],
Cell[31819, 1196, 255, 8, 70, "ExampleText",
 CellID->27644364],
Cell[CellGroupData[{
Cell[32099, 1208, 336, 12, 70, "Input",
 CellID->382571917],
Cell[32438, 1222, 3167, 98, 286, "Output",
 CellID->115635076]
}, Open  ]],
Cell[35620, 1323, 125, 3, 70, "ExampleDelimiter",
 CellID->171894524],
Cell[35748, 1328, 467, 17, 70, "ExampleText",
 CellID->17220102],
Cell[CellGroupData[{
Cell[36240, 1349, 350, 11, 70, "Input",
 CellID->451444385],
Cell[36593, 1362, 1296, 42, 58, "Output",
 CellID->183907179]
}, Open  ]],
Cell[37904, 1407, 124, 3, 70, "ExampleDelimiter",
 CellID->35639222],
Cell[38031, 1412, 133, 4, 70, "ExampleText",
 CellID->118324951],
Cell[CellGroupData[{
Cell[38189, 1420, 318, 11, 70, "Input",
 CellID->17849633],
Cell[38510, 1433, 845, 34, 72, "Output",
 CellID->291482575]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39404, 1473, 222, 7, 70, "ExampleSubsection",
 CellID->31431],
Cell[39629, 1482, 94, 1, 70, "ExampleText",
 CellID->693718440],
Cell[CellGroupData[{
Cell[39748, 1487, 443, 15, 70, "Input",
 CellID->553981606],
Cell[40194, 1504, 1479, 53, 81, "Output",
 CellID->27037432]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41734, 1564, 233, 7, 70, "ExampleSection",
 CellID->16886],
Cell[41970, 1573, 220, 8, 70, "ExampleText",
 CellID->220577594],
Cell[CellGroupData[{
Cell[42215, 1585, 304, 10, 70, "Input",
 CellID->285402124],
Cell[42522, 1597, 555, 21, 51, "Output",
 CellID->163377691]
}, Open  ]],
Cell[43092, 1621, 358, 13, 70, "ExampleText",
 CellID->531288593],
Cell[CellGroupData[{
Cell[43475, 1638, 181, 6, 70, "Input",
 CellID->134233071],
Cell[43659, 1646, 223, 7, 36, "Output",
 CellID->322767823]
}, Open  ]],
Cell[43897, 1656, 368, 12, 70, "ExampleText",
 CellID->706292441],
Cell[CellGroupData[{
Cell[44290, 1672, 155, 5, 70, "Input",
 CellID->647239162],
Cell[44448, 1679, 675, 25, 51, "Output",
 CellID->514554279]
}, Open  ]],
Cell[45138, 1707, 125, 3, 70, "ExampleDelimiter",
 CellID->157283281],
Cell[45266, 1712, 199, 7, 70, "ExampleText",
 CellID->14168195],
Cell[CellGroupData[{
Cell[45490, 1723, 366, 12, 70, "Input",
 CellID->651925608],
Cell[45859, 1737, 563, 19, 38, "Output",
 CellID->232053325]
}, Open  ]],
Cell[46437, 1759, 224, 8, 70, "ExampleText",
 CellID->288008655],
Cell[CellGroupData[{
Cell[46686, 1771, 170, 5, 70, "Input",
 CellID->386495020],
Cell[46859, 1778, 388, 14, 38, "Output",
 CellID->66964456]
}, Open  ]],
Cell[CellGroupData[{
Cell[47284, 1797, 175, 6, 70, "Input",
 CellID->94418230],
Cell[47462, 1805, 260, 9, 36, "Output",
 CellID->226243607]
}, Open  ]],
Cell[47737, 1817, 215, 8, 70, "ExampleText",
 CellID->26434858],
Cell[CellGroupData[{
Cell[47977, 1829, 162, 5, 70, "Input",
 CellID->464452974],
Cell[48142, 1836, 232, 8, 36, "Output",
 CellID->11445440]
}, Open  ]],
Cell[48389, 1847, 125, 3, 70, "ExampleDelimiter",
 CellID->389000042],
Cell[48517, 1852, 360, 13, 70, "ExampleText",
 CellID->443328584],
Cell[CellGroupData[{
Cell[48902, 1869, 412, 15, 70, "Input",
 CellID->191102622],
Cell[49317, 1886, 1163, 39, 51, "Output",
 CellID->35546228]
}, Open  ]],
Cell[CellGroupData[{
Cell[50517, 1930, 411, 15, 70, "Input",
 CellID->7780548],
Cell[50931, 1947, 802, 28, 51, "Output",
 CellID->28912269]
}, Open  ]],
Cell[51748, 1978, 125, 3, 70, "ExampleDelimiter",
 CellID->134505620],
Cell[51876, 1983, 242, 8, 70, "ExampleText",
 CellID->265735518],
Cell[CellGroupData[{
Cell[52143, 1995, 432, 16, 70, "Input",
 CellID->99688369],
Cell[52578, 2013, 680, 25, 51, "Output",
 CellID->483364255]
}, Open  ]],
Cell[53273, 2041, 125, 3, 70, "ExampleDelimiter",
 CellID->435009869],
Cell[53401, 2046, 248, 8, 70, "ExampleText",
 CellID->590077805],
Cell[CellGroupData[{
Cell[53674, 2058, 264, 10, 70, "Input",
 CellID->274623960],
Cell[53941, 2070, 872, 22, 54, "Output",
 CellID->141703652]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54874, 2099, 311, 9, 70, "SeeAlsoSection",
 CellID->14319],
Cell[55188, 2110, 2914, 107, 70, "SeeAlso",
 CellID->4588]
}, Open  ]],
Cell[CellGroupData[{
Cell[58139, 2222, 314, 9, 70, "TutorialsSection",
 CellID->31985],
Cell[58456, 2233, 144, 3, 70, "Tutorials",
 CellID->20260],
Cell[58603, 2238, 199, 4, 70, "Tutorials",
 CellID->22871]
}, Open  ]],
Cell[CellGroupData[{
Cell[58839, 2247, 318, 9, 70, "MoreAboutSection",
 CellID->54272405],
Cell[59160, 2258, 151, 3, 70, "MoreAbout",
 CellID->330655959]
}, Open  ]],
Cell[59326, 2264, 27, 0, 70, "History"],
Cell[59356, 2266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

