(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24456,        751]
NotebookOptionsPosition[     20438,        614]
NotebookOutlinePosition[     21841,        653]
CellTagsIndexPosition[     21756,        648]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Two\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingTwoDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Labeling Two\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text" :> Documentation`HelpLookup["paclet:ref/Text"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Text\"\>", 
       2->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RotateLabel", "ObjectName",
 CellID->17942],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RotateLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RotateLabel"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics and related functions which \
specifies whether labels on vertical frame axes should be rotated to be \
vertical. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RotateLabel", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", vertical frame axes labels read from bottom to top. "
}], "Notes",
 CellID->30550]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->789067463],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->33667075],

Cell["Specify that vertical frame labels should be rotated: ", "ExampleText",
 CellID->72302295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "\"\<y axis\>\""}], "}"}]}], ",", 
   RowBox[{"RotateLabel", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117700679],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{None, 
    FormBox["\"y axis\"", TraditionalForm]},
  RotateLabel->True]], "Output",
 ImageSize->{184, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729025028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124099978],

Cell["Specify that vertical frame labels should not be rotated: ", \
"ExampleText",
 CellID->133903301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "\"\<y axis\>\""}], "}"}]}], ",", 
   RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533032101],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{None, 
    FormBox["\"y axis\"", TraditionalForm]},
  RotateLabel->False]], "Output",
 ImageSize->{184, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124174389]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29482],

Cell[TextData[{
 "Both left and right frame labels are affected by ",
 Cell[BoxData[
  ButtonBox["RotateLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateLabel"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->575103360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"left", ",", "right"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"bottom", ",", "top"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"RotateLabel", "->", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"FrameLabel", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"left", ",", "right"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"bottom", ",", "top"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4568],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114233697]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"left", ",", "right"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"bottom", ",", "top"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"RotateLabel", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9335735],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {8., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$702$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$702$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, 
      "Options" :> {
       FrameLabel -> {{$CellContext`left, $CellContext`right}, \
{$CellContext`bottom, $CellContext`top}}, RotateLabel -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{283., {62., 67.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{287, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->486485800]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->802],

Cell["Vertical frame labels are rotated in graphics, by default:", \
"ExampleText",
 CellID->46196138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"left", ",", "right"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108538682],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{{
     FormBox["left", TraditionalForm], 
     FormBox["right", TraditionalForm]}, {None, None}}]], "Output",
 ImageSize->{184, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204231063]
}, Open  ]],

Cell[TextData[{
 "Vertical frame labels are not rotated in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", by default:"
}], "ExampleText",
 CellID->203145377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"left", ",", "right"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->394440968],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {8., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$1054$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1054$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, 
      "Options" :> {
       FrameLabel -> {{$CellContext`left, $CellContext`right}, {None, None}}},
       "DefaultOptions" :> {}],
     ImageSizeCache->{299., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{303, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350831204]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31969],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5248]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1864],

Cell[TextData[ButtonBox["Labeling Two\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingTwoDimensionalGraphics"]], "Tutorials",
 CellID->31538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->97047940],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->200141463]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RotateLabel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 11.8506302}", "context" -> "System`", 
    "keywords" -> {
     "vertical text in plots", "rotating axes label", "rotating frame label", 
      "label orientation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RotateLabel is an option for graphics and related functions which \
specifies whether labels on vertical frame axes should be rotated to be \
vertical. ", "synonyms" -> {"rotate label"}, "title" -> "RotateLabel", "type" -> 
    "Symbol", "uri" -> "ref/RotateLabel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3929, 130, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->789067463]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21613, 641}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1914, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2537, 76, 49, 1, 70, "ObjectName",
 CellID->17942],
Cell[2589, 79, 528, 15, 70, "Usage",
 CellID->3219]
}, Open  ]],
Cell[CellGroupData[{
Cell[3154, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3632, 116, 260, 9, 70, "Notes",
 CellID->30550]
}, Closed]],
Cell[CellGroupData[{
Cell[3929, 130, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->789067463],
Cell[CellGroupData[{
Cell[4314, 144, 147, 5, 70, "ExampleSection",
 CellID->33667075],
Cell[4464, 151, 96, 1, 70, "ExampleText",
 CellID->72302295],
Cell[CellGroupData[{
Cell[4585, 156, 362, 10, 28, "Input",
 CellID->117700679],
Cell[4950, 168, 292, 10, 174, "Output",
 CellID->729025028]
}, Open  ]],
Cell[5257, 181, 125, 3, 70, "ExampleDelimiter",
 CellID->124099978],
Cell[5385, 186, 103, 2, 70, "ExampleText",
 CellID->133903301],
Cell[CellGroupData[{
Cell[5513, 192, 363, 10, 70, "Input",
 CellID->533032101],
Cell[5879, 204, 293, 10, 161, "Output",
 CellID->124174389]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6221, 220, 216, 7, 70, "ExampleSection",
 CellID->29482],
Cell[6440, 229, 238, 8, 70, "ExampleText",
 CellID->575103360],
Cell[CellGroupData[{
Cell[6703, 241, 1105, 33, 70, "Input",
 CellID->4568],
Cell[7811, 276, 5007, 86, 70, "Output",
 Evaluatable->False,
 CellID->114233697]
}, Open  ]],
Cell[CellGroupData[{
Cell[12855, 367, 463, 14, 70, "Input",
 CellID->9335735],
Cell[13321, 383, 1687, 38, 70, "Output",
 CellID->486485800]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15057, 427, 231, 7, 70, "ExampleSection",
 CellID->802],
Cell[15291, 436, 102, 2, 70, "ExampleText",
 CellID->46196138],
Cell[CellGroupData[{
Cell[15418, 442, 416, 13, 70, "Input",
 CellID->108538682],
Cell[15837, 457, 317, 10, 161, "Output",
 CellID->204231063]
}, Open  ]],
Cell[16169, 470, 240, 8, 70, "ExampleText",
 CellID->203145377],
Cell[CellGroupData[{
Cell[16434, 482, 411, 13, 70, "Input",
 CellID->394440968],
Cell[16848, 497, 1639, 37, 70, "Output",
 CellID->350831204]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18548, 541, 311, 9, 70, "SeeAlsoSection",
 CellID->31969],
Cell[18862, 552, 436, 17, 70, "SeeAlso",
 CellID->5248]
}, Open  ]],
Cell[CellGroupData[{
Cell[19335, 574, 313, 9, 70, "TutorialsSection",
 CellID->1864],
Cell[19651, 585, 182, 3, 70, "Tutorials",
 CellID->31538]
}, Open  ]],
Cell[CellGroupData[{
Cell[19870, 593, 318, 9, 70, "MoreAboutSection",
 CellID->97047940],
Cell[20191, 604, 175, 3, 70, "MoreAbout",
 CellID->200141463]
}, Open  ]],
Cell[20381, 610, 27, 0, 70, "History"],
Cell[20411, 612, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

