(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23474,        835]
NotebookOptionsPosition[     18476,        663]
NotebookOutlinePosition[     19878,        701]
CellTagsIndexPosition[     19793,        696]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingLists"], 
          "Rearranging Nested Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RearrangingNestedLists"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Rearranging Lists\"\>", 
       2->"\<\"Rearranging Nested Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RotateRight" :> 
          Documentation`HelpLookup["paclet:ref/RotateRight"], "Reverse" :> 
          Documentation`HelpLookup["paclet:ref/Reverse"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "BitShiftLeft" :> 
          Documentation`HelpLookup["paclet:ref/BitShiftLeft"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RotateRight\"\>", 
       2->"\<\"Reverse\"\>", 3->"\<\"PadLeft\"\>", 
       4->"\<\"BitShiftLeft\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Parts of Matrices\"\>", 
       2->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RotateLeft", "ObjectName",
 CellID->31568],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RotateLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RotateLeft"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles the elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " positions to the left. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RotateLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RotateLeft"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles one position to the left. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RotateLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RotateLeft"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles elements at successive levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " positions to the left. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28545]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RotateLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateLeft"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " rotates ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " positions to the right. "
}], "Notes",
 CellID->852],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RotateLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateLeft"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->1109]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->578984290],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->297876797],

Cell["Rotate two positions to the left:", "ExampleText",
 CellID->12512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "d", ",", "e", ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342524709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28371],

Cell["Rotate one position to the left:", "ExampleText",
 CellID->11111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "a"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72325203]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27906],

Cell["\<\
Rotate one position left at the first level, and right at the second level:\
\>", "ExampleText",
 CellID->8837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "g", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24941807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3247],

Cell["Rotate an expression with any head:", "ExampleText",
 CellID->31184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"y", ",", "z", ",", "x"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->907280560]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19796],

Cell["Successively rotate a list left:", "ExampleText",
 CellID->2197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"RotateLeft", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "a", ",", "b", ",", "c", ",", "d"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772800795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8316],

Cell["Rotate successive rows of a matrix by their row number:", "ExampleText",
 CellID->22090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapIndexed", "[", 
   RowBox[{"RotateLeft", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}]}], "]"}], "//", "TableForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->31819],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlttOAjEQQHvbBBCVCIm82Y/gGzQ++BEbYgIPRoP8f51pZy9Md+lWjZBg
k+2027nRObT7Uu43r2/lfrsu7dOu/Nhs15/28X0Hr7QUQqzgeV4KGDsY+Wfl
HMi4L2BxCiNNEucTktC0VxLYK+x0mOBwhF1Rz4Oitx36VgaZitGaT0/g/Qqk
ifxhy9iRlpbKyZiqYigPxWoyocqpyNKyqDd+Ce0t+Zm5biL6eoyBKY9IcmrO
hJbk/ndXWda/0RzPa6CnVJ7qR/w02WoiQxgK5htnBvVlbTdjHh8OVm/JxrZs
v8NJdYpwXmJWz4yVZAV00vvY5XBEjkztj3a+33o4PQ0pfWdHPz3BtmBx7tn8
zmsZirAkuXD51HTdQRU9p6Hm+s98VrfMb91lw/hp/vXVyXfslolJCVVZsNic
kOBq7g4J8VxlEPL/pZLyfglfKkJ+AdJsb5s=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{52, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->136398508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27164],

Cell["Rotate a 2D image:", "ExampleText",
 CellID->31782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"RotateLeft", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "1", ",", "0"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", 
        RowBox[{"1", "/", "100"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", 
        RowBox[{"1", "/", "100"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"40", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1221],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt291NAzEQReE1ndASJaQB6qQrhBSEBPtje+2Z68M9Ut7nk5KXeOb18f72
eNm27eP5KZt2pb7sUU9rcEhLmhzCkkaHrKTZwYFoSjockpIuh6Ck0yEn6XaI
SW44pCS3HEKSmw4ZyW2HiGSAQ4EyhpEvGeZIlgx0pEqGOvIooxlZkgmOFMkU
RzxlFiNaMtERSZnLiJNMd8RQIhgBlCjGZEokYyIlmjGJksGYQMlijLWkKsZR
shHPGIpnCMQzhuI7guEngsFJRvhqEX7slQZxTbNC0dKJEMPcVKhYhjDSKcMU
uZbBjCzKBEYGZRIjmjKREUmZzIiiBDBCKEEOzOvIZEqoA/OCOI2S4OA8s2P2
HoZTEh2c5SDOuhZmf+4rioOzZMpZ++UsYnNW4znHCpzzEc5BD+fE6j9fvWUP
fBjFwTnV5RxPt0iyJ72I4qiXZM95HcVRJ8mesSoMpEKSPWFtFAcHciHJnq4l
ioMDOZFkT9YYBnIoyZ6rOQzkQJI9VUcYyK4ke6auMJAdSfZEnWEgfyTZ83Rn
iFwUBweyURyG6EVxGCIXBrJRHIboRXEYIpchclEchshliFwUhyFyGaKWIWoZ
opYhahmiliFqGaKWIWoZopYhahmiliFqGSIW5t94Q9QyRCzMO7shahkiFmaD
zhCxMHu/hqhFgZQCkRgiVikQCQVSCkRiiFi/HctKKJC/jkUlFMieY0kJBbLv
WFBCgRw5lpNQIMeOxSQUyJljJcm5YyEJBXLlWEVy7VhEQoHUOFaQ1Dn0KdWO
T7zjJmc=
   "], {{0, 0}, {201, 201}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->514671284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2063],

Cell["Rotate operands:", "ExampleText",
 CellID->3238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{"a", ".", "b", ".", "c", ".", "d", ".", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19069],

Cell[BoxData[
 RowBox[{"b", ".", "c", ".", "d", ".", "e", ".", "a"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6358]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26037],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitShiftLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitShiftLeft"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25301],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "Tutorials",
 CellID->7670],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "Tutorials",
 CellID->14114]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->49235222],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->252008074],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->123828705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
RotateLeft"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RotateLeft - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 13.3819194}", "context" -> "System`", 
    "keywords" -> {"cycle", "left shift", "lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RotateLeft[expr, n] cycles the elements in expr n positions to the left. \
RotateLeft[expr] cycles one position to the left. RotateLeft[expr, {n_1, n_2, \
...}] cycles elements at successive levels n_i positions to the left. ", 
    "synonyms" -> {"rotate left"}, "title" -> "RotateLeft", "type" -> 
    "Symbol", "uri" -> "ref/RotateLeft"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6103, 199, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->578984290]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19650, 689}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2404, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3027, 84, 48, 1, 70, "ObjectName",
 CellID->31568],
Cell[3078, 87, 1758, 56, 70, "Usage",
 CellID->28545]
}, Open  ]],
Cell[CellGroupData[{
Cell[4873, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5351, 165, 386, 15, 70, "Notes",
 CellID->852],
Cell[5740, 182, 326, 12, 70, "Notes",
 CellID->1109]
}, Closed]],
Cell[CellGroupData[{
Cell[6103, 199, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->578984290],
Cell[CellGroupData[{
Cell[6488, 213, 148, 5, 70, "ExampleSection",
 CellID->297876797],
Cell[6639, 220, 72, 1, 70, "ExampleText",
 CellID->12512],
Cell[CellGroupData[{
Cell[6736, 225, 207, 7, 28, "Input",
 CellID->13777],
Cell[6946, 234, 233, 7, 36, "Output",
 CellID->342524709]
}, Open  ]],
Cell[7194, 244, 121, 3, 70, "ExampleDelimiter",
 CellID->28371],
Cell[7318, 249, 71, 1, 70, "ExampleText",
 CellID->11111],
Cell[CellGroupData[{
Cell[7414, 254, 182, 6, 70, "Input",
 CellID->18182],
Cell[7599, 262, 232, 7, 36, "Output",
 CellID->72325203]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7880, 275, 239, 7, 70, "ExampleSection",
 CellID->27906],
Cell[8122, 284, 121, 3, 70, "ExampleText",
 CellID->8837],
Cell[CellGroupData[{
Cell[8268, 291, 443, 15, 70, "Input",
 CellID->30220],
Cell[8714, 308, 390, 13, 36, "Output",
 CellID->24941807]
}, Open  ]],
Cell[9119, 324, 120, 3, 70, "ExampleDelimiter",
 CellID->3247],
Cell[9242, 329, 74, 1, 70, "ExampleText",
 CellID->31184],
Cell[CellGroupData[{
Cell[9341, 334, 162, 5, 70, "Input",
 CellID->109],
Cell[9506, 341, 218, 7, 36, "Output",
 CellID->907280560]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9773, 354, 223, 7, 70, "ExampleSection",
 CellID->19796],
Cell[9999, 363, 70, 1, 70, "ExampleText",
 CellID->2197],
Cell[CellGroupData[{
Cell[10094, 368, 224, 7, 70, "Input",
 CellID->11447],
Cell[10321, 377, 632, 18, 36, "Output",
 CellID->772800795]
}, Open  ]],
Cell[10968, 398, 120, 3, 70, "ExampleDelimiter",
 CellID->8316],
Cell[11091, 403, 94, 1, 70, "ExampleText",
 CellID->22090],
Cell[CellGroupData[{
Cell[11210, 408, 331, 11, 70, "Input",
 CellID->31819],
Cell[11544, 421, 685, 15, 70, "Output",
 Evaluatable->False,
 CellID->136398508]
}, Open  ]],
Cell[12244, 439, 121, 3, 70, "ExampleDelimiter",
 CellID->27164],
Cell[12368, 444, 57, 1, 70, "ExampleText",
 CellID->31782],
Cell[CellGroupData[{
Cell[12450, 449, 743, 24, 70, "Input",
 CellID->1221],
Cell[13196, 475, 1230, 27, 171, "Output",
 CellID->514671284]
}, Open  ]],
Cell[14441, 505, 120, 3, 70, "ExampleDelimiter",
 CellID->2063],
Cell[14564, 510, 54, 1, 70, "ExampleText",
 CellID->3238],
Cell[CellGroupData[{
Cell[14643, 515, 155, 4, 70, "Input",
 CellID->19069],
Cell[14801, 521, 205, 6, 36, "Output",
 CellID->6358]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15067, 534, 311, 9, 70, "SeeAlsoSection",
 CellID->26037],
Cell[15381, 545, 951, 35, 70, "SeeAlso",
 CellID->26091]
}, Open  ]],
Cell[CellGroupData[{
Cell[16369, 585, 314, 9, 70, "TutorialsSection",
 CellID->25301],
Cell[16686, 596, 143, 3, 70, "Tutorials",
 CellID->7670],
Cell[16832, 601, 157, 3, 70, "Tutorials",
 CellID->14114]
}, Open  ]],
Cell[CellGroupData[{
Cell[17026, 609, 318, 9, 70, "MoreAboutSection",
 CellID->49235222],
Cell[17347, 620, 144, 3, 70, "MoreAbout",
 CellID->252008074],
Cell[17494, 625, 177, 3, 70, "MoreAbout",
 CellID->123828705]
}, Open  ]],
Cell[CellGroupData[{
Cell[17708, 633, 305, 8, 70, "RelatedLinksSection"],
Cell[18016, 643, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[18419, 659, 27, 0, 70, "History"],
Cell[18449, 661, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

