(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20114,        638]
NotebookOptionsPosition[     16785,        528]
NotebookOutlinePosition[     18139,        567]
CellTagsIndexPosition[     18054,        562]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Row" :> Documentation`HelpLookup["paclet:ref/Row"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"], "GridBox" :> 
          Documentation`HelpLookup["paclet:ref/GridBox"], "AdjustmentBox" :> 
          Documentation`HelpLookup["paclet:ref/AdjustmentBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Row\"\>", 2->"\<\"ToBoxes\"\>", 
       3->"\<\"GridBox\"\>", 4->"\<\"AdjustmentBox\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RowBox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RowBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RowBox"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["box", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["box", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct that represents a row of \
boxes or strings in a notebook expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17522]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " is generated by functions like ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->10651],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects are generated automatically to correspond to each operator and its \
operands in input given as \[Backslash]",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["input", "TI"]}]], "InlineFormula"],
 "\[Backslash]",
 Cell[BoxData[")"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->609],

Cell[TextData[{
 "The default arrangement of ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects in \[Backslash]",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["input", "TI"]}]], "InlineFormula"],
 "\[Backslash]",
 Cell[BoxData[")"], "InlineFormula"],
 " is based on operator precedence. Additional \[Backslash]",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]], 
  "InlineFormula"],
 " can be inserted like parentheses to specify different arrangements of ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->13695],

Cell[TextData[{
 "The boxes or strings in a ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " are output in a row with their baselines aligned. "
}], "Notes",
 CellID->8514],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects are output using \[Backslash]",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->22095],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->30487]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282404606],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->248580364],

Cell["Display a row of letters and plus signs:", "ExampleText",
 CellID->12562330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{
    "\"\<a\>\"", ",", "\"\<+\>\"", ",", "\"\<b\>\"", ",", "\"\<+\>\"", ",", 
     "\"\<c\>\""}], "}"}], "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587913410],

Cell[BoxData[
 TagBox[
  RowBox[{"a", "+", "b", "+", "c"}],
  DisplayForm]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->548557728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->230208822],

Cell["Display a row of objects within paired brackets:", "ExampleText",
 CellID->51431713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<{\>\"", ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<1\>\"", ",", "\"\<,\>\"", ",", 
        RowBox[{"UnderoverscriptBox", "[", 
         RowBox[{"\"\<\[Sum]\>\"", ",", "\"\<0\>\"", ",", "\"\<n\>\""}], 
         "]"}], ",", 
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\"\<s\>\"", ",", "\"\<n\>\""}], "]"}]}], "}"}], "]"}], ",", 
     "\"\<}\>\""}], "}"}], "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28763320],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    UnderoverscriptBox["\[Sum]", "0", "n"], 
    SuperscriptBox["s", "n"]}], "}"}],
  DisplayForm]], "Output",
 ImageSize->{65, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->733099678]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6803],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AdjustmentBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AdjustmentBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29350]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6689],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->4431],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->78166671],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->101921812]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RowBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 27.0228936}", "context" -> "System`", 
    "keywords" -> {
     "abut boxes", "Boxes", "concatenate", "\\hbox (TeX)", "horizontal box", 
      "Sequence"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "RowBox[{box_1, box_2, ...}] is a low-level box construct that represents \
a row of boxes or strings in a notebook expression. ", 
    "synonyms" -> {"row box"}, "title" -> "RowBox", "type" -> "Symbol", "uri" -> 
    "ref/RowBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11716, 335, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->282404606]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17910, 555}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2485, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3108, 85, 4190, 83, 70, "ObjectNameGrid"],
Cell[7301, 170, 786, 24, 70, "Usage",
 CellID->17522]
}, Open  ]],
Cell[CellGroupData[{
Cell[8124, 199, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8602, 216, 653, 20, 70, "Notes",
 CellID->10651],
Cell[9258, 238, 420, 14, 70, "Notes",
 CellID->609],
Cell[9681, 254, 747, 25, 70, "Notes",
 CellID->13695],
Cell[10431, 281, 244, 8, 70, "Notes",
 CellID->8514],
Cell[10678, 291, 469, 19, 70, "Notes",
 CellID->22095],
Cell[11150, 312, 529, 18, 70, "Notes",
 CellID->30487]
}, Closed]],
Cell[CellGroupData[{
Cell[11716, 335, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282404606],
Cell[CellGroupData[{
Cell[12101, 349, 148, 5, 70, "ExampleSection",
 CellID->248580364],
Cell[12252, 356, 82, 1, 70, "ExampleText",
 CellID->12562330],
Cell[CellGroupData[{
Cell[12359, 361, 266, 8, 28, "Input",
 CellID->587913410],
Cell[12628, 371, 229, 8, 50, "Output",
 CellID->548557728]
}, Open  ]],
Cell[12872, 382, 125, 3, 70, "ExampleDelimiter",
 CellID->230208822],
Cell[13000, 387, 90, 1, 70, "ExampleText",
 CellID->51431713],
Cell[CellGroupData[{
Cell[13115, 392, 566, 15, 70, "Input",
 CellID->28763320],
Cell[13684, 409, 314, 11, 72, "Output",
 CellID->733099678]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14059, 427, 310, 9, 70, "SeeAlsoSection",
 CellID->6803],
Cell[14372, 438, 937, 35, 70, "SeeAlso",
 CellID->29350]
}, Open  ]],
Cell[CellGroupData[{
Cell[15346, 478, 313, 9, 70, "TutorialsSection",
 CellID->6689],
Cell[15662, 489, 178, 4, 70, "Tutorials",
 CellID->4431],
Cell[15843, 495, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[16052, 503, 299, 8, 70, "MoreAboutSection"],
Cell[16354, 513, 168, 3, 70, "MoreAbout",
 CellID->78166671],
Cell[16525, 518, 165, 3, 70, "MoreAbout",
 CellID->101921812]
}, Open  ]],
Cell[16705, 524, 50, 0, 70, "History"],
Cell[16758, 526, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

