(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73126,       2657]
NotebookOptionsPosition[     60116,       2194]
NotebookOutlinePosition[     61451,       2232]
CellTagsIndexPosition[     61365,       2227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Linear Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLinearSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Solving Linear Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinearSolve" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolve"], "Inverse" :> 
          Documentation`HelpLookup["paclet:ref/Inverse"], "NullSpace" :> 
          Documentation`HelpLookup["paclet:ref/NullSpace"], "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinearSolve\"\>", 
       2->"\<\"Inverse\"\>", 3->"\<\"NullSpace\"\>", 
       4->"\<\"GroebnerBasis\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:guide/MatricesAndLinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RowReduce", "ObjectName",
 CellID->1133],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RowReduce",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RowReduce"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the row\[Hyphen]reduced form of the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RowReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowReduce"]], "InlineFormula"],
 " performs a version of Gaussian elimination, adding multiples of rows \
together so as to produce zero elements when possible. The final matrix is in \
reduced row echelon form. "
}], "Notes",
 CellID->22221],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a non\[Hyphen]degenerate square matrix, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"], "[", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["m", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->663640557,
  ButtonNote->"663640557"]
}], "Notes",
 CellID->5117],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a sufficiently non\[Hyphen]degenerate rectangular matrix with ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " rows and more than ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " columns, then the first ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " columns of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " will form an identity matrix. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->603027498,
  ButtonNote->"603027498"]
}], "Notes",
 CellID->32048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RowReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowReduce"]], "InlineFormula"],
 " works on both numerical and symbolic matrices. "
}], "Notes",
 CellID->31809],

Cell["The following options can be given:", "Notes",
 CellID->14405],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[
    "integer modulus to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "numerical tolerance to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ZeroTest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ZeroTest"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
function to test whether matrix elements should be considered to be zero\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->23813],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " performs row reduction modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->598760464,
  ButtonNote->"598760464"]
}], "Notes",
 CellID->5901],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["ZeroTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZeroTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}], "]"}], "]"}], "]"}]], "InlineFormula"],
 " to determine whether matrix elements are zero. "
}], "Notes",
 CellID->6155],

Cell[TextData[{
 "The possible settings for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option are as for ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20483]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46407799],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->156665172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "b"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"a", "-", "b"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", 
      RowBox[{"3", " ", "b"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523621568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53638600],

Cell["Do row reduction on a square matrix:", "ExampleText",
 CellID->176786234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785713401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169903359]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356545821],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVj1PwzAQdZIaJPoFogNjd0YG5i4w8SOiCqkdEKh06JYxY8eO/QkdM2bM
2LFjxo4ZO5qzfYldY0HaGjFApMR31vm9yzt/PYXT0fNLOB0Pw/7jJHwbjYfv
/YfXCXQFHiFkAO/tDQGbgSXeAWPQ6l/Kv8FyuWTiIXfCj6II/UBENYS52WyS
JOEm9wMAbBltt0Rbr9fm6MVioWNSnk/5gE0uDujtCJjdbjebzRRPUPZKKsl7
Eo/8nziOAZSbfsXjZ1lGHeGDqCDtPr7Qa7vduvwPVT+dR9XaFQ+IJSfUj/Fc
lgphl2fl4fWxzdIrI84++v4/ytCxCS3FmtCqCt+Ntle7JaKq3i/r7Iahafj1
ZkE9bNN3mXfb8LsOsTtW//crqq9cH9o2+2srdz6f14hS57YeBftiURQMK0Vx
5XL9rtE/F3F5nq9WK27q+zQcEXh6n7E6Fe0ZURI7TVPLmQZpIWM97HKnoVYO
0GjvXDbvGeaoQ/JXSitsH3Q5ThM+yoc/FxliXirPxtGYn25ViC0vDqdiKxSJ
zWeRvhp76ItdA++TxPsAlGwndQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->884729749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74932991],

Cell["Do row reduction on a rectangular matrix:", "ExampleText",
 CellID->290441337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "1", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6", ",", "0", ",", "1", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9", ",", "0", ",", "0", ",", "1"}], "}"}]}],
    "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314263722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["8", "3"]}], ",", 
     FractionBox["5", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "0", ",", 
     FractionBox["7", "3"], ",", 
     RowBox[{"-", 
      FractionBox["4", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{424, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151518302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262133498],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      RowBox[{"-", "1"}], "0", 
      RowBox[{"-", 
       FractionBox["8", "3"]}], 
      FractionBox["5", "3"]},
     {"0", "1", "2", "0", 
      FractionBox["7", "3"], 
      RowBox[{"-", 
       FractionBox["4", "3"]}]},
     {"0", "0", "0", "1", 
      RowBox[{"-", "2"}], "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{136, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->95050337]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25748],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is an exact 4\[Times]4 matrix:"
}], "ExampleText",
 CellID->97819097],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "4", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101922892],

Cell["Use exact arithmetic for the Gaussian elimination:", "ExampleText",
 CellID->167284937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RowReduce", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97358153],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmDtvgzAQgA2EPvLYO+ZvdOnYZumPQFGlZKhapRnYGBkZGfkJjIyMjIyM
jIyMGen5hR03SUOp1UgFCfuwTv7su/PJx7OzXb28Otv10pk/bZz31Xr5MX98
28CQZSCEFvDe3yGQG5DIu2ga6OXWxq0VRVFDHmRBY4Hq9Eh/TZQ8z5P0ERoR
sSiKJEnaURsT+QMyGvceveKrzfNcpYdhKK9JG32327muK+gWH6ULoKvRQKeW
930fUFg0W7qZZZmtlQpuBefuU4nFq6rSv2cRVzJdxKBeOpibHo8jdGz5Uyfm
ltuK6RsHZ3lQvv+v1jF7TqDHLro5a5b+MTElM7ajA3fg/iH3VJYxOesCT/Ol
anF78qwyZv2kkbP2z6JB9bD6fTgu+sTfQByIXTIIzhgzqT8/4i/1PHfRCoLg
DC1RE8lacI+r67phHpQzhpqZqVfKsozjGIvy7RGus6yCoTXFdx7ufmtN0/TA
jR2Wzlajiwu23atP1NrM1sQV3hNcE2z8+/vEM5pgRbIzth+xv5EW3pfqlnFp
+aWTKwiUi6Ndzhpq1M+IFv23gIxPp22SQQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->946417249]
}, Open  ]],

Cell["\<\
With machine\[Hyphen]number arithmetic the leading zeros and ones are still \
exact:\
\>", "ExampleText",
 CellID->207871027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RowReduce", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->192985043],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0.`", "0.`", "0.`"},
     {"0", "1", "1.`", "0.`"},
     {"0", "0", "0", "1"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->364619065]
}, Open  ]],

Cell["\<\
With higher\[Hyphen]precision arithmetic the leading zeros and ones are still \
exact:\
\>", "ExampleText",
 CellID->33176561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RowReduce", "[", 
   RowBox[{"N", "[", 
    RowBox[{"m", ",", " ", "20"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12819960],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "1", "1.`20.", "0"},
     {"0", "0", "0", "1"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{216, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->204076585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240193480],

Cell["\<\
Row reduction for a random complex 3\[Times]4 matrix:\
\>", "ExampleText",
 CellID->301797791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RowReduce", "[", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", " ", "+", " ", "I"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121156229],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.13342437616802302`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.0903830764183599`", " ", "\[ImaginaryI]"}]}]},
     {"0", "1", 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.3694446033177689`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.5231643176213209`", " ", "\[ImaginaryI]"}]}]},
     {"0", "0", "1", 
      RowBox[{"0.8739078475847829`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.6396695797985714`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{302, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->251586136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24423],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17179],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 matrix of integers between 0 and 4: "
}], "ExampleText",
 CellID->347904126],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25823385],

Cell[TextData[{
 "Row reduction of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " in ordinary arithmetic:"
}], "ExampleText",
 CellID->326726516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->469342209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176462173]
}, Open  ]],

Cell[TextData[{
 "Row reduction of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " in arithmetic modulo 5:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->598760464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{"m", ",", " ", 
   RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->106447347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279968799]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Tolerance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31632],

Cell[TextData[{
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is an ill-conditioned matrix:"
}], "ExampleText",
 CellID->170569318],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], " ", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "20"}]], ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108806433],

Cell[TextData[{
 "In exact arithmetic, ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is clearly non-degenerate:"
}], "ExampleText",
 CellID->98733497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152750405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->726775851]
}, Open  ]],

Cell["\<\
With machine arithmetic the default is to consider elements that are too \
small as zero:\
\>", "ExampleText",
 CellID->677218086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->229465423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92846159]
}, Open  ]],

Cell["\<\
With zero tolerance even small terms may be taken into account\
\>", "ExampleText",
 CellID->692496789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", " ", 
   RowBox[{"Tolerance", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22912155],

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(RowReduce\\) of badly conditioned matrix \\!\\({\
\\(\\({1.`, 0.`, 1.`}\\)\\), \\(\\({1.`, 1.`*^-20, 0.`}\\)\\), \\(\\({0.`, \
0.`, 1.`}\\)\\)}\\) may contain significant numerical errors. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/luc\\\", \
ButtonNote -> \\\"RowReduce::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->126922236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->185352531]
}, Open  ]],

Cell["\<\
With an augmented matrix, you can see how possible solution components are \
amplified:\
\>", "ExampleText",
 CellID->124794415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RowReduce", "[", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Append", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->626992456],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "1", "0", "100000000000000000000"},
     {"0", "0", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{229, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->174894598]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13099],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a matrix and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is a vector:"
}], "ExampleText",
 CellID->255223240],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"m", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{"b", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->95141443],

Cell[TextData[{
 "Form an augmented matrix ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["m", "TI"], "|", 
    StyleBox["b", "TI"]}], ")"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->189644266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ",", " ", 
      RowBox[{"{", "b", "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->473626197],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "1"},
     {"5", "6", "7", "1"},
     {"7", "8", "9", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->7861776]
}, Open  ]],

Cell["Do row reduction on the augmented matrix:", "ExampleText",
 CellID->600126276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"r", " ", "=", 
   RowBox[{"RowReduce", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134236202],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVjtPwzAQdpOaSvQB9CExdud/gIQEc9eoQmoHBCodumXMmDFjfkLGjh07
duzYsWPHjuZsn+PUGChVjBiIlNxDp/vOd5fzPQTT0dNzMB0Pg/7dJHgdjYdv
/duXCaj8CiFkAO/NNQGeASfeAWNAi1/Kv36apkw85F7IYRii7AurqmDX6/V8
Pucsl31w2DBoF+mF8rparUwvSZIUfVMel3qAJ+c/0Lat2pZwvt/vZ7OZRveV
VgYgo3GALs8eRRFAcdbL0b3lckmdokJ5oEiHqCLj2+3W/Zl1fxTRdS+5RYd0
yzb+ZfRLlWNUVazovO5f/TFXhr3dy+O/lZHPOlCKFaNYI5pX5Tsv9p5oCKtc
+0k3dA2rMhHrhtxziGXKLs/VNOSOQ6yWIbcdYpXZIcVJ4QFtMj0pPDWF/uAf
Wb5VHMdHWOndpWgF83i32zGsIMVJwfPYYYeToibsN5tNlmWcLd4ecJ3hBnPG
Tqm4KUusxWJhuaUhXIzgOCw18ajF2qavqZwe7CXmTmbzduo5daU0lgf5LCeX
3IsHGRMnwLj1OaqlYXzYWBFLrlRlY2mvEot3rW0K9JCKKYe7PKm8A9DS86A=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{88, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->303914893]
}, Open  ]],

Cell[TextData[{
 "The last column is the solution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "=", "b"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->528886872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "=", " ", 
  RowBox[{"r", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->342184077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->171449179]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", "x"}], " ", "\[Equal]", " ", "b"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->161771405],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->357558375]
}, Open  ]],

Cell["\<\
Do it for another right\[Hyphen]hand side:\
\>", "ExampleText",
 CellID->9033969],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b1", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a1", " ", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ",", " ", 
      RowBox[{"{", "b1", "}"}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"r1", " ", "=", " ", 
   RowBox[{"RowReduce", "[", "a1", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->769406178],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "1", "2", "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{84, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->63749400]
}, Open  ]],

Cell[TextData[{
 "There is no solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "=", 
    RowBox[{"b", "\[InvisibleSpace]", "1"}]}], TraditionalForm]], 
  "InlineMath"],
 " since there is a leading one in the last column:"
}], "ExampleText",
 CellID->85136443],

Cell[CellGroupData[{

Cell["\<\
lone[row_] := If[Norm[row] > 0, Position[row, 1][[1,1]]];
Map[lone, r1]\
\>", "Input",
 CellLabel->"In[7]:=",
 CellID->310055597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->288313423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->276284459],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a symbolic matrix:"
}], "ExampleText",
 CellID->22063715],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532466098],

Cell["Find the symbolic inverse:", "ExampleText",
 CellID->273686575],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"RowReduce", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", "m", "]"}], ",", " ", 
       RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231201853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minv", " ", "=", " ", 
  RowBox[{"r", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", " ", 
     RowBox[{
      RowBox[{"-", "3"}], ";;", 
      RowBox[{"-", "1"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->331052343],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{513, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->375769853]
}, Open  ]],

Cell[TextData[{
 "This is the equivalent to the what is given by ",
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->33153986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", " ", "-", " ", 
   RowBox[{"Inverse", "[", "m", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->95623275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->370660789]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a non-degenerate square matrix:"
}], "ExampleText",
 CellID->236628201],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263997777],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"], "[", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["m", "TI"], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->663640557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", "m", "]"}], " ", "\[Equal]", " ", 
  RowBox[{"IdentityMatrix", "[", 
   RowBox[{"Length", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->179005393],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->539614]
}, Open  ]],

Cell[TextData[{
 "Augment ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with the 3\[Times]3 identity matrix:"
}], "ExampleText",
 CellID->264241479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ",", " ", 
      RowBox[{"IdentityMatrix", "[", 
       RowBox[{"Length", "[", "m", "]"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->695004759],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "4", "1", "0", "0"},
     {"2", "0", "3", "0", "1", "0"},
     {"2", "1", "2", "0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{106, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->642581091]
}, Open  ]],

Cell["Do row reduction on the augmented matrix:", "ExampleText",
 CellID->457668564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"RowReduce", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->54836153],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      RowBox[{"-", 
       FractionBox["3", "5"]}], 
      FractionBox["4", "5"], "0"},
     {"0", "1", "0", 
      FractionBox["2", "5"], 
      RowBox[{"-", 
       FractionBox["6", "5"]}], "1"},
     {"0", "0", "1", 
      FractionBox["2", "5"], 
      RowBox[{"-", 
       FractionBox["1", "5"]}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{128, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->565236818]
}, Open  ]],

Cell[TextData[{
 "The last three columns of the result are ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->235995958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", " ", 
     RowBox[{
      RowBox[{"-", "3"}], ";;", 
      RowBox[{"-", "1"}]}]}], "]"}], "]"}], " ", "\[Equal]", " ", 
  RowBox[{"Inverse", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->479732765],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->47298092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302468481],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]5 matrix:"
}], "ExampleText",
 CellID->507964342],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "7", ",", "1", ",", "2", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "5", ",", "1", ",", "4"}], "}"}]}], "}"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6046575],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " has its maximal ",
 Cell[BoxData[
  ButtonBox["MatrixRank",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixRank"]], "InlineFormula"],
 " of 3:"
}], "ExampleText",
 CellID->114789800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6461349],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246813902]
}, Open  ]],

Cell[TextData[{
 "The first 3 columns of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " are the 3\[Times]3 identity matrix:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->603027498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"RowReduce", "[", "m", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->678334922],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      FractionBox["17", "15"], 
      FractionBox["67", "135"]},
     {"0", "1", "0", 
      RowBox[{"-", 
       FractionBox["4", "15"]}], 
      FractionBox["106", "135"]},
     {"0", "0", "1", 
      FractionBox["7", "15"], 
      FractionBox["2", "135"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{119, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->546229070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"1", ";;", "3"}]}], "]"}], "]"}], " ", "\[Equal]", " ", 
  RowBox[{"IdentityMatrix", "[", 
   RowBox[{"Length", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->964477379],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->108422087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732442636],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a degenerate square matrix:"
}], "ExampleText",
 CellID->109314924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56350969],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41565150]
}, Open  ]],

Cell[TextData[{
 "Augment ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with the 3\[Times]3 identity matrix:"
}], "ExampleText",
 CellID->461744441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ",", " ", 
      RowBox[{"IdentityMatrix", "[", 
       RowBox[{"Length", "[", "m", "]"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->497907547],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4", "1", "0", "0", "0"},
     {"5", "6", "7", "8", "0", "1", "0", "0"},
     {"9", "10", "11", "12", "0", "0", "1", "0"},
     {"13", "14", "15", "16", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{164, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->213529789]
}, Open  ]],

Cell["Do row reduction on the augmented matrix:", "ExampleText",
 CellID->107334555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"RowReduce", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->51365618],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "2"}], "0", "0", 
      RowBox[{"-", 
       FractionBox["7", "2"]}], 
      FractionBox["5", "2"]},
     {"0", "1", "2", "3", "0", "0", 
      FractionBox["13", "4"], 
      RowBox[{"-", 
       FractionBox["9", "4"]}]},
     {"0", "0", "0", "0", "1", "0", 
      RowBox[{"-", "3"}], "2"},
     {"0", "0", "0", "0", "0", "1", 
      RowBox[{"-", "2"}], "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{174, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->484976725]
}, Open  ]],

Cell[TextData[{
 "The last 4 columns of any row with the leading one beyond the 4",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column is in the null space:"
}], "ExampleText",
 CellID->391788097],

Cell[CellGroupData[{

Cell["\<\
lone[row_] := If[Norm[row] > 0, Position[row, 1][[1,1]]];
cols = Map[lone, r]\
\>", "Input",
 CellLabel->"In[4]:=",
 CellID->600542790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "5", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->505681312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", " ", "=", " ", 
   RowBox[{"Position", "[", 
    RowBox[{"cols", ",", " ", 
     RowBox[{"c_", "/;", 
      RowBox[{"c", ">", "4"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"v1", ",", " ", "v2"}], "}"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"Extract", "[", 
    RowBox[{"r", ",", " ", "p"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", " ", 
     RowBox[{"5", ";;", "8"}]}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->667346059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->278882088]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"n1", ",", " ", "n2"}], "}"}], "=", " ", 
  RowBox[{"NullSpace", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->95336016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1034934410]
}, Open  ]],

Cell["\<\
Even though the vectors are not the same, they are a basis for the same \
space:\
\>", "ExampleText",
 CellID->358988321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{"v1", " ", "\[Equal]", 
     RowBox[{
      RowBox[{"b1", " ", "n1"}], " ", "+", " ", 
      RowBox[{"b2", " ", "n2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", " ", "b2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->305917824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", "2"}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", "3"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->264375141]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{"v2", " ", "\[Equal]", 
     RowBox[{
      RowBox[{"b1", " ", "n1"}], " ", "+", " ", 
      RowBox[{"b2", " ", "n2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", " ", "b2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->63325923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", "1"}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", "2"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->380293465]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6616],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24243],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "Tutorials",
 CellID->6286]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23592],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5783"], None}]], "RelatedLinks",
 CellID->5382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->99872845],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->20543275],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->187931649]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RowReduce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 32.8980440}", "context" -> "System`", 
    "keywords" -> {
     "echelon form of matrices", "Gaussian elimination", 
      "Gauss-Jordan elimination", "ladder form", "row reduction of matrices"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RowReduce[m] gives the row-reduced form of the matrix m. ", 
    "synonyms" -> {"row reduce"}, "title" -> "RowReduce", "type" -> "Symbol", 
    "uri" -> "ref/RowReduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9130, 313, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46407799]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 61223, 2220}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 81, 46, 1, 70, "ObjectName",
 CellID->1133],
Cell[2904, 84, 569, 18, 70, "Usage",
 CellID->20760]
}, Open  ]],
Cell[CellGroupData[{
Cell[3510, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3988, 124, 347, 9, 70, "Notes",
 CellID->22221],
Cell[4338, 135, 753, 28, 70, "Notes",
 CellID->5117],
Cell[5094, 165, 744, 26, 70, "Notes",
 CellID->32048],
Cell[5841, 193, 217, 7, 70, "Notes",
 CellID->31809],
Cell[6061, 202, 68, 1, 70, "Notes",
 CellID->14405],
Cell[6132, 205, 1329, 37, 70, "3ColumnTableMod",
 CellID->23813],
Cell[7464, 244, 589, 22, 70, "Notes",
 CellID->5901],
Cell[8056, 268, 685, 25, 70, "Notes",
 CellID->6155],
Cell[8744, 295, 349, 13, 70, "Notes",
 CellID->20483]
}, Closed]],
Cell[CellGroupData[{
Cell[9130, 313, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46407799],
Cell[CellGroupData[{
Cell[9514, 327, 148, 5, 70, "ExampleSection",
 CellID->156665172],
Cell[CellGroupData[{
Cell[9687, 336, 270, 9, 28, "Input",
 CellID->14566],
Cell[9960, 347, 451, 16, 36, "Output",
 CellID->523621568]
}, Open  ]],
Cell[10426, 366, 124, 3, 70, "ExampleDelimiter",
 CellID->53638600],
Cell[10553, 371, 79, 1, 70, "ExampleText",
 CellID->176786234],
Cell[CellGroupData[{
Cell[10657, 376, 345, 11, 28, "Input",
 CellID->785713401],
Cell[11005, 389, 412, 14, 36, "Output",
 CellID->169903359]
}, Open  ]],
Cell[CellGroupData[{
Cell[11454, 408, 106, 3, 28, "Input",
 CellID->356545821],
Cell[11563, 413, 800, 17, 78, "Output",
 Evaluatable->False,
 CellID->884729749]
}, Open  ]],
Cell[12378, 433, 124, 3, 70, "ExampleDelimiter",
 CellID->74932991],
Cell[12505, 438, 84, 1, 70, "ExampleText",
 CellID->290441337],
Cell[CellGroupData[{
Cell[12614, 443, 449, 14, 70, "Input",
 CellID->314263722],
Cell[13066, 459, 663, 21, 51, "Output",
 CellID->151518302]
}, Open  ]],
Cell[CellGroupData[{
Cell[13766, 485, 106, 3, 70, "Input",
 CellID->262133498],
Cell[13875, 490, 992, 31, 96, "Output",
 CellID->95050337]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14916, 527, 216, 7, 70, "ExampleSection",
 CellID->25748],
Cell[15135, 536, 145, 5, 70, "ExampleText",
 CellID->97819097],
Cell[15283, 543, 484, 15, 70, "Input",
 CellID->101922892],
Cell[15770, 560, 93, 1, 70, "ExampleText",
 CellID->167284937],
Cell[CellGroupData[{
Cell[15888, 565, 141, 4, 70, "Input",
 CellID->97358153],
Cell[16032, 571, 808, 17, 70, "Output",
 Evaluatable->False,
 CellID->946417249]
}, Open  ]],
Cell[16855, 591, 135, 4, 70, "ExampleText",
 CellID->207871027],
Cell[CellGroupData[{
Cell[17015, 599, 171, 5, 70, "Input",
 CellID->192985043],
Cell[17189, 606, 809, 24, 92, "Output",
 CellID->364619065]
}, Open  ]],
Cell[18013, 633, 136, 4, 70, "ExampleText",
 CellID->33176561],
Cell[CellGroupData[{
Cell[18174, 641, 201, 6, 70, "Input",
 CellID->12819960],
Cell[18378, 649, 805, 24, 92, "Output",
 CellID->204076585]
}, Open  ]],
Cell[19198, 676, 125, 3, 70, "ExampleDelimiter",
 CellID->240193480],
Cell[19326, 681, 104, 3, 70, "ExampleText",
 CellID->301797791],
Cell[CellGroupData[{
Cell[19455, 688, 302, 9, 70, "Input",
 CellID->121156229],
Cell[19760, 699, 1422, 35, 78, "Output",
 CellID->251586136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21231, 740, 218, 7, 70, "ExampleSection",
 CellID->24423],
Cell[CellGroupData[{
Cell[21474, 751, 224, 7, 70, "ExampleSubsection",
 CellID->17179],
Cell[21701, 760, 168, 5, 70, "ExampleText",
 CellID->347904126],
Cell[21872, 767, 367, 12, 70, "Input",
 CellID->25823385],
Cell[22242, 781, 161, 6, 70, "ExampleText",
 CellID->326726516],
Cell[CellGroupData[{
Cell[22428, 791, 105, 3, 70, "Input",
 CellID->469342209],
Cell[22536, 796, 391, 13, 36, "Output",
 CellID->176462173]
}, Open  ]],
Cell[22942, 812, 209, 7, 70, "ExampleText",
 CellID->598760464],
Cell[CellGroupData[{
Cell[23176, 823, 169, 5, 70, "Input",
 CellID->106447347],
Cell[23348, 830, 391, 13, 36, "Output",
 CellID->279968799]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23788, 849, 226, 7, 70, "ExampleSubsection",
 CellID->31632],
Cell[24017, 858, 152, 5, 70, "ExampleText",
 CellID->170569318],
Cell[24172, 865, 438, 14, 70, "Input",
 CellID->108806433],
Cell[24613, 881, 174, 6, 70, "ExampleText",
 CellID->98733497],
Cell[CellGroupData[{
Cell[24812, 891, 105, 3, 70, "Input",
 CellID->152750405],
Cell[24920, 896, 391, 13, 36, "Output",
 CellID->726775851]
}, Open  ]],
Cell[25326, 912, 140, 4, 70, "ExampleText",
 CellID->677218086],
Cell[CellGroupData[{
Cell[25491, 920, 133, 4, 70, "Input",
 CellID->229465423],
Cell[25627, 926, 394, 13, 36, "Output",
 CellID->92846159]
}, Open  ]],
Cell[26036, 942, 113, 3, 70, "ExampleText",
 CellID->692496789],
Cell[CellGroupData[{
Cell[26174, 949, 199, 6, 70, "Input",
 CellID->22912155],
Cell[26376, 957, 530, 9, 70, "Message",
 CellID->126922236],
Cell[26909, 968, 397, 13, 36, "Output",
 CellID->185352531]
}, Open  ]],
Cell[27321, 984, 138, 4, 70, "ExampleText",
 CellID->124794415],
Cell[CellGroupData[{
Cell[27484, 992, 353, 11, 70, "Input",
 CellID->626992456],
Cell[27840, 1005, 793, 23, 78, "Output",
 CellID->174894598]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28694, 1035, 223, 7, 70, "ExampleSection",
 CellID->13099],
Cell[28920, 1044, 207, 8, 70, "ExampleText",
 CellID->255223240],
Cell[29130, 1054, 519, 18, 70, "Input",
 CellID->95141443],
Cell[29652, 1074, 216, 9, 70, "ExampleText",
 CellID->189644266],
Cell[CellGroupData[{
Cell[29893, 1087, 307, 9, 70, "Input",
 CellID->473626197],
Cell[30203, 1098, 770, 23, 78, "Output",
 CellID->7861776]
}, Open  ]],
Cell[30988, 1124, 84, 1, 70, "ExampleText",
 CellID->600126276],
Cell[CellGroupData[{
Cell[31097, 1129, 171, 5, 70, "Input",
 CellID->134236202],
Cell[31271, 1136, 833, 18, 70, "Output",
 Evaluatable->False,
 CellID->303914893]
}, Open  ]],
Cell[32119, 1157, 212, 8, 70, "ExampleText",
 CellID->528886872],
Cell[CellGroupData[{
Cell[32356, 1169, 202, 7, 70, "Input",
 CellID->342184077],
Cell[32561, 1178, 232, 8, 36, "Output",
 CellID->171449179]
}, Open  ]],
Cell[CellGroupData[{
Cell[32830, 1191, 132, 4, 70, "Input",
 CellID->161771405],
Cell[32965, 1197, 161, 5, 36, "Output",
 CellID->357558375]
}, Open  ]],
Cell[33141, 1205, 91, 3, 70, "ExampleText",
 CellID->9033969],
Cell[CellGroupData[{
Cell[33257, 1212, 553, 17, 70, "Input",
 CellID->769406178],
Cell[33813, 1231, 793, 24, 78, "Output",
 CellID->63749400]
}, Open  ]],
Cell[34621, 1258, 292, 10, 70, "ExampleText",
 CellID->85136443],
Cell[CellGroupData[{
Cell[34938, 1272, 139, 5, 70, "Input",
 CellID->310055597],
Cell[35080, 1279, 213, 7, 36, "Output",
 CellID->288313423]
}, Open  ]],
Cell[35308, 1289, 125, 3, 70, "ExampleDelimiter",
 CellID->276284459],
Cell[35436, 1294, 136, 5, 70, "ExampleText",
 CellID->22063715],
Cell[35575, 1301, 368, 12, 70, "Input",
 CellID->532466098],
Cell[35946, 1315, 69, 1, 70, "ExampleText",
 CellID->273686575],
Cell[36018, 1318, 351, 11, 70, "Input",
 CellID->231201853],
Cell[CellGroupData[{
Cell[36394, 1333, 260, 9, 70, "Input",
 CellID->331052343],
Cell[36657, 1344, 2937, 52, 70, "Output",
 Evaluatable->False,
 CellID->375769853]
}, Open  ]],
Cell[39609, 1399, 227, 8, 70, "ExampleText",
 CellID->33153986],
Cell[CellGroupData[{
Cell[39861, 1411, 171, 5, 70, "Input",
 CellID->95623275],
Cell[40035, 1418, 391, 13, 36, "Output",
 CellID->370660789]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40475, 1437, 232, 7, 70, "ExampleSection",
 CellID->3140],
Cell[40710, 1446, 150, 5, 70, "ExampleText",
 CellID->236628201],
Cell[40863, 1453, 368, 12, 70, "Input",
 CellID->263997777],
Cell[41234, 1467, 589, 22, 70, "ExampleText",
 CellID->663640557],
Cell[CellGroupData[{
Cell[41848, 1493, 220, 6, 70, "Input",
 CellID->179005393],
Cell[42071, 1501, 158, 5, 36, "Output",
 CellID->539614]
}, Open  ]],
Cell[42244, 1509, 165, 6, 70, "ExampleText",
 CellID->264241479],
Cell[CellGroupData[{
Cell[42434, 1519, 366, 11, 70, "Input",
 CellID->695004759],
Cell[42803, 1532, 803, 23, 78, "Output",
 CellID->642581091]
}, Open  ]],
Cell[43621, 1558, 84, 1, 70, "ExampleText",
 CellID->457668564],
Cell[CellGroupData[{
Cell[43730, 1563, 175, 5, 70, "Input",
 CellID->54836153],
Cell[43908, 1570, 1022, 32, 104, "Output",
 CellID->565236818]
}, Open  ]],
Cell[44945, 1605, 273, 10, 70, "ExampleText",
 CellID->235995958],
Cell[CellGroupData[{
Cell[45243, 1619, 298, 10, 70, "Input",
 CellID->479732765],
Cell[45544, 1631, 160, 5, 36, "Output",
 CellID->47298092]
}, Open  ]],
Cell[45719, 1639, 125, 3, 70, "ExampleDelimiter",
 CellID->302468481],
Cell[45847, 1644, 139, 5, 70, "ExampleText",
 CellID->507964342],
Cell[45989, 1651, 424, 13, 70, "Input",
 CellID->6046575],
Cell[46416, 1666, 266, 10, 70, "ExampleText",
 CellID->114789800],
Cell[CellGroupData[{
Cell[46707, 1680, 104, 3, 70, "Input",
 CellID->6461349],
Cell[46814, 1685, 158, 5, 36, "Output",
 CellID->246813902]
}, Open  ]],
Cell[46987, 1693, 342, 11, 70, "ExampleText",
 CellID->603027498],
Cell[CellGroupData[{
Cell[47354, 1708, 176, 5, 70, "Input",
 CellID->678334922],
Cell[47533, 1715, 974, 30, 104, "Output",
 CellID->546229070]
}, Open  ]],
Cell[CellGroupData[{
Cell[48544, 1750, 290, 9, 70, "Input",
 CellID->964477379],
Cell[48837, 1761, 161, 5, 36, "Output",
 CellID->108422087]
}, Open  ]],
Cell[49013, 1769, 125, 3, 70, "ExampleDelimiter",
 CellID->732442636],
Cell[49141, 1774, 146, 5, 70, "ExampleText",
 CellID->109314924],
Cell[CellGroupData[{
Cell[49312, 1783, 463, 14, 70, "Input",
 CellID->56350969],
Cell[49778, 1799, 508, 16, 36, "Output",
 CellID->41565150]
}, Open  ]],
Cell[50301, 1818, 165, 6, 70, "ExampleText",
 CellID->461744441],
Cell[CellGroupData[{
Cell[50491, 1828, 366, 11, 70, "Input",
 CellID->497907547],
Cell[50860, 1841, 887, 24, 92, "Output",
 CellID->213529789]
}, Open  ]],
Cell[51762, 1868, 84, 1, 70, "ExampleText",
 CellID->107334555],
Cell[CellGroupData[{
Cell[51871, 1873, 175, 5, 70, "Input",
 CellID->51365618],
Cell[52049, 1880, 1115, 34, 110, "Output",
 CellID->484976725]
}, Open  ]],
Cell[53179, 1917, 237, 7, 70, "ExampleText",
 CellID->391788097],
Cell[CellGroupData[{
Cell[53441, 1928, 145, 5, 70, "Input",
 CellID->600542790],
Cell[53589, 1935, 223, 7, 36, "Output",
 CellID->505681312]
}, Open  ]],
Cell[CellGroupData[{
Cell[53849, 1947, 519, 17, 70, "Input",
 CellID->667346059],
Cell[54371, 1966, 384, 13, 36, "Output",
 CellID->278882088]
}, Open  ]],
Cell[CellGroupData[{
Cell[54792, 1984, 186, 6, 70, "Input",
 CellID->95336016],
Cell[54981, 1992, 385, 13, 36, "Output",
 CellID->1034934410]
}, Open  ]],
Cell[55381, 2008, 131, 4, 70, "ExampleText",
 CellID->358988321],
Cell[CellGroupData[{
Cell[55537, 2016, 346, 11, 70, "Input",
 CellID->305917824],
Cell[55886, 2029, 313, 11, 36, "Output",
 CellID->264375141]
}, Open  ]],
Cell[CellGroupData[{
Cell[56236, 2045, 345, 11, 70, "Input",
 CellID->63325923],
Cell[56584, 2058, 313, 11, 36, "Output",
 CellID->380293465]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56958, 2076, 310, 9, 70, "SeeAlsoSection",
 CellID->6616],
Cell[57271, 2087, 956, 35, 70, "SeeAlso",
 CellID->3534]
}, Open  ]],
Cell[CellGroupData[{
Cell[58264, 2127, 314, 9, 70, "TutorialsSection",
 CellID->24243],
Cell[58581, 2138, 152, 3, 70, "Tutorials",
 CellID->6286]
}, Open  ]],
Cell[CellGroupData[{
Cell[58770, 2146, 321, 9, 70, "RelatedLinksSection",
 CellID->23592],
Cell[59094, 2157, 265, 6, 70, "RelatedLinks",
 CellID->5382]
}, Open  ]],
Cell[CellGroupData[{
Cell[59396, 2168, 318, 9, 70, "MoreAboutSection",
 CellID->99872845],
Cell[59717, 2179, 138, 3, 70, "MoreAbout",
 CellID->20543275],
Cell[59858, 2184, 163, 3, 70, "MoreAbout",
 CellID->187931649]
}, Open  ]],
Cell[60036, 2190, 50, 0, 70, "History"],
Cell[60089, 2192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

