(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8114,        275]
NotebookOptionsPosition[      6320,        219]
NotebookOutlinePosition[      7427,        249]
CellTagsIndexPosition[      7384,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Grid" :> Documentation`HelpLookup["paclet:ref/Grid"], 
         "RowAlignments" :> 
         Documentation`HelpLookup["paclet:ref/RowAlignments"], "RowMinHeight" :> 
         Documentation`HelpLookup["paclet:ref/RowMinHeight"], "RowsEqual" :> 
         Documentation`HelpLookup["paclet:ref/RowsEqual"], "ColumnSpacings" :> 
         Documentation`HelpLookup["paclet:ref/ColumnSpacings"], 
         "TableSpacing" :> 
         Documentation`HelpLookup["paclet:ref/TableSpacing"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Grid\"\>", 
      2->"\<\"RowAlignments\"\>", 3->"\<\"RowMinHeight\"\>", 
      4->"\<\"RowsEqual\"\>", 5->"\<\"ColumnSpacings\"\>", 
      6->"\<\"TableSpacing\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RowSpacings", "ObjectName",
 CellID->16241],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RowSpacings",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RowSpacings"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["GridBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
     " which specifies the spaces in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " heights that should be inserted between successive rows. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->961]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"RowSpacings", "->", "1.0"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8807],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RowSpacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowSpacings"]], "InlineFormula"],
 " effectively specifies the minimum distance between entries in successive \
rows; individual entries will often not fill their rows and will therefore be \
further apart. "
}], "Notes",
 CellID->6757],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RowSpacings", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " uses a column spacing equal to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times the height of an \[OpenCurlyDoubleQuote]x\[CloseCurlyDoubleQuote] \
character in the current font. "
}], "Notes",
 CellID->12943],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RowSpacings", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["12", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["23", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " can be used to specify different spacings between different rows. If there \
are more rows than entries in this list, then the last element of the list is \
used repeatedly for the remaining rows. "
}], "Notes",
 CellID->13776]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27573],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowAlignments"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowMinHeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowMinHeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowsEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowsEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnSpacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnSpacings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1738]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RowSpacings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 34.6949650}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RowSpacings is an option for the low-level function GridBox which \
specifies the spaces in x heights that should be inserted between successive \
rows. ", "synonyms" -> {"row spacings"}, "title" -> "RowSpacings", "type" -> 
    "Symbol", "uri" -> "ref/RowSpacings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1117, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1740, 50, 49, 1, 70, "ObjectName",
 CellID->16241],
Cell[1792, 53, 732, 21, 70, "Usage",
 CellID->961]
}, Open  ]],
Cell[CellGroupData[{
Cell[2561, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3039, 96, 151, 6, 70, "Notes",
 CellID->8807],
Cell[3193, 104, 343, 9, 70, "Notes",
 CellID->6757],
Cell[3539, 115, 340, 10, 70, "Notes",
 CellID->12943],
Cell[3882, 127, 553, 16, 70, "Notes",
 CellID->13776]
}, Closed]],
Cell[CellGroupData[{
Cell[4472, 148, 311, 9, 70, "SeeAlsoSection",
 CellID->27573],
Cell[4786, 159, 1462, 53, 70, "SeeAlso",
 CellID->1738]
}, Open  ]],
Cell[6263, 215, 27, 0, 70, "History"],
Cell[6293, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

