(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21100,        785]
NotebookOptionsPosition[     16460,        622]
NotebookOutlinePosition[     17756,        660]
CellTagsIndexPosition[     17671,        655]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingTransformationRules"], 
          "Some General Notations and Conventions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeGeneralNotationsAndConventions"], 
          "Variables in Pure Functions and Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/VariablesInPureFunctionsAndRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Applying Transformation Rules\"\>", 
       2->"\<\"Some General Notations and Conventions\"\>", 
       3->"\<\"Variables in Pure Functions and Rules\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RuleDelayed" :> 
          Documentation`HelpLookup["paclet:ref/RuleDelayed"], "Replace" :> 
          Documentation`HelpLookup["paclet:ref/Replace"], "ReplaceAll" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceAll"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RuleDelayed\"\>", 
       2->"\<\"Replace\"\>", 3->"\<\"ReplaceAll\"\>", 4->"\<\"Set\"\>", 
       5->"\<\"PolynomialReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Rules" :> Documentation`HelpLookup["paclet:guide/Rules"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Rules\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Rule ",
 StyleBox["(->, \[Rule])", "OperatorCharacter"]
}], "ObjectName",
 CellID->9300],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "->", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "\[Rule]", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]represents a rule that transforms ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The character ",
 Cell[BoxData["->"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 ButtonBox["\[Backslash][Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"],
 ". "
}], "Notes",
 CellID->4241],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " immediately. "
}], "Notes",
 CellID->18737],

Cell[TextData[{
 "You can apply rules using ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8486],

Cell[TextData[{
 "The assignment ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " specifies that the rule ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " should be used whenever it applies. "
}], "Notes",
 CellID->17529],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 " is printed using\[NonBreakingSpace]",
 Cell[BoxData["->"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1753],

Cell[TextData[{
 "Symbols that occur as pattern names in ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " are treated as local to the rule. This is true when the symbols appear on \
the right\[Hyphen]hand side of ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions in ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", and when the symbols appear anywhere in ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 ", even inside other scoping constructs. "
}], "Notes",
 CellID->28898],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 " constructs can be nested in any way. ",
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 " is treated as a scoping construct, so that inner variables are renamed if \
necessary."
}], "Notes",
 CellID->15547]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239485665],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->90289352],

Cell[TextData[{
 "Use a rule that replaces ",
 Cell[BoxData["x"], "InlineFormula"],
 " by 3:"
}], "ExampleText",
 CellID->57007537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}], ",", "a", ",", "b"}], "}"}], "/.", 
  RowBox[{"x", "\[Rule]", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6886774],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "9", ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414953239]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31796],

Cell["Any expression or pattern can appear in a rule:", "ExampleText",
 CellID->279603808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "^", "3"}], ",", "a", ",", "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "\[Rule]", "y"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304800595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   SuperscriptBox["x", "3"], ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->832130757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "^", "3"}], ",", "a", ",", "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"x", "^", "n_"}], "\[Rule]", 
   RowBox[{"f", "[", "n", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32223779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35128896]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12722],

Cell[TextData[{
 Cell[BoxData["->"], "InlineFormula"],
 " evaluates when it is first entered; ",
 Cell[BoxData[":>"], "InlineFormula"],
 " when it is used:"
}], "ExampleText",
 CellID->902509474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"RandomReal", "[", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448050555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5266210776393798`", ",", "0.5266210776393798`", ",", 
   "0.5266210776393798`", ",", "0.5266210776393798`"}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83014521]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], "/.", 
  RowBox[{"x", ":>", 
   RowBox[{"RandomReal", "[", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->668540792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.12356658396723486`", ",", "0.8153830057710043`", ",", 
   "0.7684424516811035`", ",", "0.9308259767561959`"}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25938983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88961758],

Cell[TextData[{
 Cell[BoxData["->"], "InlineFormula"],
 " groups to the right:"
}], "ExampleText",
 CellID->679087702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Rule]", 
   RowBox[{"y", "\[Rule]", "z"}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73645838],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Rule", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Rule", "[", 
      RowBox[{"y", ",", "z"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->38197564]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"y", "\[Rule]", "z"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45958974],

Cell[BoxData[
 RowBox[{"y", "\[Rule]", "z"}]], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7873865]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31952],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RuleDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RuleDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18227]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8958],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "Tutorials",
 CellID->7100],

Cell[TextData[ButtonBox["Some General Notations and Conventions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SomeGeneralNotationsAndConventions"]], "Tutorials",
 CellID->314307143],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VariablesInPureFunctionsAndRules"]], "Tutorials",\

 CellID->135909037]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5024],

Cell[TextData[ButtonBox["Implementation notes: Basic System Features",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#16446"], None}]], "RelatedLinks",
 CellID->27097]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->251880694],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->614232034],

Cell[TextData[ButtonBox["Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Rules"]], "MoreAbout",
 CellID->45446046]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rule (->, \[Rule]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 39.5857152}", "context" -> "System`", 
    "keywords" -> {
     "arrow", "immediate rules", "replacements", "lexical scoping", 
      "local scoping"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs -> rhs or lhs -> rhs represents a rule that transforms lhs to rhs. ",
     "synonyms" -> {"->"}, "title" -> "Rule", "type" -> "Symbol", "uri" -> 
    "ref/Rule"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7146, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->239485665]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17528, 648}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2694, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3317, 88, 106, 4, 70, "ObjectName",
 CellID->9300],
Cell[3426, 94, 701, 24, 70, "Usage",
 CellID->2912]
}, Open  ]],
Cell[CellGroupData[{
Cell[4164, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4642, 140, 353, 13, 70, "Notes",
 CellID->4241],
Cell[4998, 155, 243, 10, 70, "Notes",
 CellID->18737],
Cell[5244, 167, 197, 8, 70, "Notes",
 CellID->8486],
Cell[5444, 177, 346, 13, 70, "Notes",
 CellID->17529],
Cell[5793, 192, 382, 15, 70, "Notes",
 CellID->1753],
Cell[6178, 209, 528, 15, 70, "Notes",
 CellID->28898],
Cell[6709, 226, 400, 13, 70, "Notes",
 CellID->15547]
}, Closed]],
Cell[CellGroupData[{
Cell[7146, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239485665],
Cell[CellGroupData[{
Cell[7531, 258, 147, 5, 70, "ExampleSection",
 CellID->90289352],
Cell[7681, 265, 131, 5, 70, "ExampleText",
 CellID->57007537],
Cell[CellGroupData[{
Cell[7837, 274, 212, 7, 28, "Input",
 CellID->6886774],
Cell[8052, 283, 223, 7, 36, "Output",
 CellID->414953239]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8324, 296, 216, 7, 70, "ExampleSection",
 CellID->31796],
Cell[8543, 305, 90, 1, 70, "ExampleText",
 CellID->279603808],
Cell[CellGroupData[{
Cell[8658, 310, 273, 9, 70, "Input",
 CellID->304800595],
Cell[8934, 321, 259, 8, 39, "Output",
 CellID->832130757]
}, Open  ]],
Cell[CellGroupData[{
Cell[9230, 334, 302, 10, 70, "Input",
 CellID->32223779],
Cell[9535, 346, 291, 9, 36, "Output",
 CellID->35128896]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9875, 361, 233, 7, 70, "ExampleSection",
 CellID->12722],
Cell[10111, 370, 195, 6, 70, "ExampleText",
 CellID->902509474],
Cell[CellGroupData[{
Cell[10331, 380, 222, 7, 70, "Input",
 CellID->448050555],
Cell[10556, 389, 302, 9, 36, "Output",
 CellID->83014521]
}, Open  ]],
Cell[CellGroupData[{
Cell[10895, 403, 217, 7, 70, "Input",
 CellID->668540792],
Cell[11115, 412, 303, 9, 36, "Output",
 CellID->25938983]
}, Open  ]],
Cell[11433, 424, 124, 3, 70, "ExampleDelimiter",
 CellID->88961758],
Cell[11560, 429, 118, 4, 70, "ExampleText",
 CellID->679087702],
Cell[CellGroupData[{
Cell[11703, 437, 158, 5, 70, "Input",
 CellID->73645838],
Cell[11864, 444, 407, 15, 50, "Output",
 CellID->38197564]
}, Open  ]],
Cell[CellGroupData[{
Cell[12308, 464, 151, 5, 70, "Input",
 CellID->45958974],
Cell[12462, 471, 184, 6, 36, "Output",
 CellID->7873865]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12707, 484, 311, 9, 70, "SeeAlsoSection",
 CellID->31952],
Cell[13021, 495, 1200, 44, 70, "SeeAlso",
 CellID->18227]
}, Open  ]],
Cell[CellGroupData[{
Cell[14258, 544, 313, 9, 70, "TutorialsSection",
 CellID->8958],
Cell[14574, 555, 166, 3, 70, "Tutorials",
 CellID->7100],
Cell[14743, 560, 190, 4, 70, "Tutorials",
 CellID->314307143],
Cell[14936, 566, 186, 4, 70, "Tutorials",
 CellID->135909037]
}, Open  ]],
Cell[CellGroupData[{
Cell[15159, 575, 320, 9, 70, "RelatedLinksSection",
 CellID->5024],
Cell[15482, 586, 255, 5, 70, "RelatedLinks",
 CellID->27097]
}, Open  ]],
Cell[CellGroupData[{
Cell[15774, 596, 319, 9, 70, "MoreAboutSection",
 CellID->251880694],
Cell[16096, 607, 145, 3, 70, "MoreAbout",
 CellID->614232034],
Cell[16244, 612, 121, 3, 70, "MoreAbout",
 CellID->45446046]
}, Open  ]],
Cell[16380, 618, 50, 0, 70, "History"],
Cell[16433, 620, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

