(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14015,        499]
NotebookOptionsPosition[     10467,        380]
NotebookOutlinePosition[     11877,        420]
CellTagsIndexPosition[     11792,        415]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Programs" :> 
          Documentation`HelpLookup["paclet:tutorial/ExternalPrograms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"External Programs\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RunThrough" :> 
          Documentation`HelpLookup["paclet:ref/RunThrough"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "Splice" :> 
          Documentation`HelpLookup["paclet:ref/Splice"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RunThrough\"\>", 2->"\<\"Put\"\>", 
       3->"\<\"Splice\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Low-Level System Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelSystemOptimization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"External Operations\"\>", 
       3->"\<\"Low-Level System Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Run", "ObjectName",
 CellID->22949],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Run",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Run"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates the printed form of the expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", separated by spaces, and runs it as an external operating system \
command. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 " prints the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " format. "
}], "Notes",
 CellID->20553],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 " returns an integer which corresponds, when possible, to the exit code for \
the command returned by the operating system. "
}], "Notes",
 CellID->12841],

Cell[TextData[{
 "The command executed by ",
 Cell[BoxData[
  ButtonBox["Run",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Run"]], "InlineFormula"],
 " cannot usually require interactive input. On most computer systems, it \
can, however, generate textual output. "
}], "Notes",
 CellID->27456],

Cell[TextData[{
 "You can enter the input line ",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["command", "TI"]}]], "InlineFormula"],
 " to execute an external command. "
}], "Notes",
 CellID->24330]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->161830441],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->244754694],

Cell[TextData[{
 "Run a standalone ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, putting the result of a command in a temporary file:"
}], "ExampleText",
 CellID->55730382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"commandstring", "=", 
  RowBox[{
   RowBox[{"First", "[", "$CommandLine", "]"}], "<>", 
   "\"\< -noprompt -run \
\\\"Put[Factorial[20],ToFileName[$TemporaryPrefix,ToString[temp1]]];Quit[]\\\"\
\>\""}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110059832],

Cell[BoxData["\<\"MathKernel -noprompt -run \
\\\"Put[Factorial[20],ToFileName[$TemporaryPrefix,ToString[temp1]]];Quit[]\\\"\
\"\>"], "Output",
 ImageSize->{522, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161249130]
}, Open  ]],

Cell["The command exited without an error code: ", "ExampleText",
 CellID->129788922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Run", "[", "commandstring", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63312546],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86688644]
}, Open  ]],

Cell["Show the contents of the file:", "ExampleText",
 CellID->287019007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{"$TemporaryPrefix", ",", 
    RowBox[{"ToString", "[", "temp1", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->860985288],

Cell["2432902008176640000", "Print",
 CellLabel->"During evaluation of In[24]:=",
 CellID->18425397]
}, Open  ]],

Cell["Delete the file:", "ExampleText",
 CellID->573166151],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{"$TemporaryPrefix", ",", 
    RowBox[{"ToString", "[", "temp1", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->127493167]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6872],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RunThrough",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RunThrough"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Splice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Splice"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5608]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13544],

Cell[TextData[ButtonBox["External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExternalPrograms"]], "Tutorials",
 CellID->13382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->411338882],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->92924106],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->130295287],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->279133528]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Run - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 40.5857408}", "context" -> "System`", 
    "keywords" -> {
     "execute external command", "exit code", "fork", 
      "operating system command", "shell command", "shell escape", 
      "subprocess"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Run[expr_1, expr_2, ...] generates the printed form of the expressions \
expr_i, separated by spaces, and runs it as an external operating system \
command. ", "synonyms" -> {"!"}, "title" -> "Run", "type" -> "Symbol", "uri" -> 
    "ref/Run"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5569, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->161830441]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11649, 408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2251, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2874, 81, 41, 1, 70, "ObjectName",
 CellID->22949],
Cell[2918, 84, 898, 28, 70, "Usage",
 CellID->9421]
}, Open  ]],
Cell[CellGroupData[{
Cell[3853, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4331, 134, 416, 17, 70, "Notes",
 CellID->20553],
Cell[4750, 153, 280, 8, 70, "Notes",
 CellID->12841],
Cell[5033, 163, 299, 9, 70, "Notes",
 CellID->27456],
Cell[5335, 174, 197, 7, 70, "Notes",
 CellID->24330]
}, Closed]],
Cell[CellGroupData[{
Cell[5569, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->161830441],
Cell[CellGroupData[{
Cell[5954, 200, 148, 5, 70, "ExampleSection",
 CellID->244754694],
Cell[6105, 207, 189, 6, 70, "ExampleText",
 CellID->55730382],
Cell[CellGroupData[{
Cell[6319, 217, 281, 8, 47, "Input",
 CellID->110059832],
Cell[6603, 227, 274, 7, 54, "Output",
 CellID->161249130]
}, Open  ]],
Cell[6892, 237, 85, 1, 70, "ExampleText",
 CellID->129788922],
Cell[CellGroupData[{
Cell[7002, 242, 110, 3, 70, "Input",
 CellID->63312546],
Cell[7115, 247, 157, 5, 36, "Output",
 CellID->86688644]
}, Open  ]],
Cell[7287, 255, 73, 1, 70, "ExampleText",
 CellID->287019007],
Cell[CellGroupData[{
Cell[7385, 260, 222, 6, 70, "Input",
 CellID->860985288],
Cell[7610, 268, 100, 2, 70, "Print",
 CellID->18425397]
}, Open  ]],
Cell[7725, 273, 59, 1, 70, "ExampleText",
 CellID->573166151],
Cell[7787, 276, 223, 6, 70, "Input",
 CellID->127493167]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8059, 288, 310, 9, 70, "SeeAlsoSection",
 CellID->6872],
Cell[8372, 299, 685, 26, 70, "SeeAlso",
 CellID->5608]
}, Open  ]],
Cell[CellGroupData[{
Cell[9094, 330, 314, 9, 70, "TutorialsSection",
 CellID->13544],
Cell[9411, 341, 144, 3, 70, "Tutorials",
 CellID->13382]
}, Open  ]],
Cell[CellGroupData[{
Cell[9592, 349, 319, 9, 70, "MoreAboutSection",
 CellID->411338882],
Cell[9914, 360, 159, 3, 70, "MoreAbout",
 CellID->92924106],
Cell[10076, 365, 149, 3, 70, "MoreAbout",
 CellID->130295287],
Cell[10228, 370, 167, 3, 70, "MoreAbout",
 CellID->279133528]
}, Open  ]],
Cell[10410, 376, 27, 0, 70, "History"],
Cell[10440, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

