(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12989,        458]
NotebookOptionsPosition[      9899,        357]
NotebookOutlinePosition[     11274,        395]
CellTagsIndexPosition[     11189,        390]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Programs" :> 
          Documentation`HelpLookup["paclet:tutorial/ExternalPrograms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"External Programs\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Run" :> Documentation`HelpLookup["paclet:ref/Run"], "Install" :> 
          Documentation`HelpLookup["paclet:ref/Install"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "Splice" :> 
          Documentation`HelpLookup["paclet:ref/Splice"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Run\"\>", 2->"\<\"Install\"\>", 3->"\<\"Put\"\>",
        4->"\<\"Get\"\>", 5->"\<\"Splice\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/CallingExternalPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Calling External Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RunThrough", "ObjectName",
 CellID->3260],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RunThrough",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RunThrough"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]executes an external command, giving the printed form \
of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as input, and taking the output, reading it as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input, and returning the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15462]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RunThrough",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RunThrough"]], "InlineFormula"],
 " writes the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " on the standard input for ",
 Cell[BoxData[
  StyleBox["command", "TI"]], "InlineFormula"],
 ", then reads its standard output, and feeds it into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->29661],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RunThrough",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RunThrough"]], "InlineFormula"],
 " starts ",
 Cell[BoxData[
  StyleBox["command", "TI"]], "InlineFormula"],
 ", then gives input to ",
 Cell[BoxData[
  StyleBox["command", "TI"]], "InlineFormula"],
 ", then terminates the input. "
}], "Notes",
 CellID->295]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25414539],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->364950811],

Cell[TextData[{
 "Run a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel in text mode, having it put a result in a temporary output file:"
}], "ExampleText",
 CellID->49295278],

Cell[BoxData[
 RowBox[{
  RowBox[{"mathcommand", " ", "=", " ", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"First", "[", "$CommandLine", "]"}], ",", 
     RowBox[{"\"\<MathKernel\>\"", "\[Rule]", "\"\<math\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214960096],

Cell[BoxData[
 RowBox[{
  RowBox[{"outputfile", " ", "=", " ", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<rtout\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->278029350],

Cell[BoxData[
 RowBox[{"RunThrough", "[", 
  RowBox[{
   RowBox[{"mathcommand", "<>", "\"\< -noprompt\>\""}], ",", " ", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"Put", "[", 
     RowBox[{
      RowBox[{"Factorial", "[", "47", "]"}], ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"$TemporaryPrefix", ",", "\"\<rtout\>\""}], "]"}]}], "]"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->732239724],

Cell["The result is now in the file:", "ExampleText",
 CellID->420340459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "outputfile", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16100215],

Cell["258623241511168180642964355153611979969197632389120000000000", "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->276401452]
}, Open  ]],

Cell["Delete the temporary file:", "ExampleText",
 CellID->300682840],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", "outputfile", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->241425403]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18468],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Run",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Run"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Splice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Splice"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28662],

Cell[TextData[ButtonBox["External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExternalPrograms"]], "Tutorials",
 CellID->7987]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->89541472],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->19898505]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RunThrough - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 42.1795316}", "context" -> "System`", 
    "keywords" -> {"external filter", "run external program"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RunThrough[\"command\", expr] executes an external command, giving the \
printed form of expr as input, and taking the output, reading it as \
Mathematica input, and returning the result. ", "synonyms" -> {"run through"},
     "title" -> "RunThrough", "type" -> "Symbol", "uri" -> 
    "ref/RunThrough"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5055, 167, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25414539]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11047, 383}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 77, 47, 1, 70, "ObjectName",
 CellID->3260],
Cell[2748, 80, 807, 24, 70, "Usage",
 CellID->15462]
}, Open  ]],
Cell[CellGroupData[{
Cell[3592, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4070, 126, 581, 21, 70, "Notes",
 CellID->29661],
Cell[4654, 149, 364, 13, 70, "Notes",
 CellID->295]
}, Closed]],
Cell[CellGroupData[{
Cell[5055, 167, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25414539],
Cell[CellGroupData[{
Cell[5439, 181, 148, 5, 70, "ExampleSection",
 CellID->364950811],
Cell[5590, 188, 189, 6, 70, "ExampleText",
 CellID->49295278],
Cell[5782, 196, 305, 9, 70, "Input",
 CellID->214960096],
Cell[6090, 207, 222, 7, 70, "Input",
 CellID->278029350],
Cell[6315, 216, 425, 12, 70, "Input",
 CellID->732239724],
Cell[6743, 230, 73, 1, 70, "ExampleText",
 CellID->420340459],
Cell[CellGroupData[{
Cell[6841, 235, 113, 3, 70, "Input",
 CellID->16100215],
Cell[6957, 240, 141, 2, 70, "Print",
 CellID->276401452]
}, Open  ]],
Cell[7113, 245, 69, 1, 70, "ExampleText",
 CellID->300682840],
Cell[7185, 248, 115, 3, 70, "Input",
 CellID->241425403]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7349, 257, 311, 9, 70, "SeeAlsoSection",
 CellID->18468],
Cell[7663, 268, 1150, 44, 70, "SeeAlso",
 CellID->16957]
}, Open  ]],
Cell[CellGroupData[{
Cell[8850, 317, 314, 9, 70, "TutorialsSection",
 CellID->28662],
Cell[9167, 328, 143, 3, 70, "Tutorials",
 CellID->7987]
}, Open  ]],
Cell[CellGroupData[{
Cell[9347, 336, 318, 9, 70, "MoreAboutSection",
 CellID->89541472],
Cell[9668, 347, 159, 3, 70, "MoreAbout",
 CellID->19898505]
}, Open  ]],
Cell[9842, 353, 27, 0, 70, "History"],
Cell[9872, 355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

