(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61233,       1850]
NotebookOptionsPosition[     53529,       1591]
NotebookOutlinePosition[     55071,       1632]
CellTagsIndexPosition[     54985,       1627]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Magnify" :> Documentation`HelpLookup["paclet:ref/Magnify"], 
          "ScalingMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ScalingMatrix"], 
          "ScalingTransform" :> 
          Documentation`HelpLookup["paclet:ref/ScalingTransform"], 
          "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"], "Rotate" :> 
          Documentation`HelpLookup["paclet:ref/Rotate"], "Translate" :> 
          Documentation`HelpLookup["paclet:ref/Translate"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Magnify\"\>", 2->"\<\"ScalingMatrix\"\>", 
       3->"\<\"ScalingTransform\"\>", 4->"\<\"AffineTransform\"\>", 
       5->"\<\"Rotate\"\>", 6->"\<\"Translate\"\>", 
       7->"\<\"Normal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Graphics Transformations" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTransformations"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Geometric Transforms\"\>", 
       2->"\<\"Graphics Transformations\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Scale", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scale",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scale"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents graphics primitives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " scaled by a factor ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scale",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scale"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]scales with the point ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " kept fixed. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scale",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scale"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["y", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]scales by different factors along different axes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 " scales with the center of the bounding box of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " kept fixed. "
}], "Notes",
 CellID->16983],

Cell[TextData[{
 "You can specify special points such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], ",", 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"]}], "}"}]], "InlineFormula"],
 " within the bounding box for ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " to be kept fixed. "
}], "Notes",
 CellID->11637],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " position can be specified as ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "; the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " position as ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31161],

Cell[TextData[{
 "Explicit coordinates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " are taken to be in the coordinate system of the graphic in which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " appears. "
}], "Notes",
 CellID->21575],

Cell[TextData[{
 "For objects specified with scaled coordinates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " effectively applies its transformation to the corresponding ordinary \
coordinates. "
}], "Notes",
 CellID->3581],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " can modify the regions allocated to ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " objects, but does not directly affect their contents, and does not scale \
fonts or other textual elements. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->284994702],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " if possible replaces all ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " constructs by versions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in which the coordinates have explicitly been transformed. "
}], "Notes",
 CellID->11887]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->297729643],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->730773964],

Cell["Transform a 2D shape: ", "ExampleText",
 CellID->583741177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Scale", "[", 
     RowBox[{
      RowBox[{"Disk", "[", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165574862],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], 
   GeometricTransformationBox[
    DiskBox[{0, 0}], {{{1, 0}, {0, 0.5}}, Center}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337308862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205566430],

Cell["Transform a 3D shape:", "ExampleText",
 CellID->139463826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149997708],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJztlU8opWEUxr9BpigbtmomsiEWFpOGno2l/LfhcqXMbHBtJKmZZGetFCU2
/uwt1bsgG3+mRinlXjKauiUslB2j75zv6Hv1LGf3fXX7uk/vPfc853l/nc8j
me7RgiAI1l4/hUH0XCGIPQ8uddOwWL1yiamere+lxfuI9Jfe1vKyTA4d+YYv
9wenpo/XtVR+mr9AkGutrS/Lmr71uLQy/eccQ/1TRVW/rk0//vrz2+raGY7C
91/T5dxvyO/ypn8I6x5jLPyfW9M7wz72IH3dmT4d9r0D8XFv+sdURWPNxlyz
fjd9Vs67Ae98u9R3QV+8/ks27Ed9v/UzKP07v3/xeaa+3/xuynxc2puP+Lxw
Bd48df6uy5u/9H3pZry8NF/1vR75jvJ1k3Le+fX7pL7pGe3nKfSdNX1b+xff
16afqF/N1/S0zkd8500vlHzV963p3Tp/zdd0Ly/TSxZW25pmlnfj/h/cRPw+
mN6m90fzNf1Z8sW4109K7+e21/+h3ucTz6/mi2FvPpovinLxeUZ89Xjz13zx
w8tL8/X5BeEXhF8QfkH4BeEXhF8QfkH4BeEXhF8QfkH4BeEXhF8QfkH4BeEX
hF8QfvX9jl8QfkH4BeEXhF8QfkH4BeEXhF8/L9MJvyD8gvALwi8IvyD8gvAL
wi8IvyD8Rvkm+zfZv7H6yf5N9m+yf5P9m+zf/7t//wGQ2X2a
    "], {
     {EdgeForm[None], 
      Polygon3DBox[{{1, 2, 42, 41}, {2, 3, 43, 42}, {3, 4, 44, 43}, {4, 5, 45,
        44}, {5, 6, 46, 45}, {6, 7, 47, 46}, {7, 8, 48, 47}, {8, 9, 49, 48}, {
       9, 10, 50, 49}, {10, 11, 51, 50}, {11, 12, 52, 51}, {12, 13, 53, 52}, {
       13, 14, 54, 53}, {14, 15, 55, 54}, {15, 16, 56, 55}, {16, 17, 57, 
       56}, {17, 18, 58, 57}, {18, 19, 59, 58}, {19, 20, 60, 59}, {20, 21, 61,
        60}, {21, 22, 62, 61}, {22, 23, 63, 62}, {23, 24, 64, 63}, {24, 25, 
       65, 64}, {25, 26, 66, 65}, {26, 27, 67, 66}, {27, 28, 68, 67}, {28, 29,
        69, 68}, {29, 30, 70, 69}, {30, 31, 71, 70}, {31, 32, 72, 71}, {32, 
       33, 73, 72}, {33, 34, 74, 73}, {34, 35, 75, 74}, {35, 36, 76, 75}, {36,
        37, 77, 76}, {37, 38, 78, 77}, {38, 39, 79, 78}, {39, 40, 80, 79}, {
       40, 1, 41, 80}}]}, 
     Polygon3DBox[{{120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 
      109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 
      94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81}, {121, 122, 123,
       124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 
      138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 
      152, 153, 154, 155, 156, 157, 158, 159, 160}}]},
    VertexColors->Automatic,
    VertexNormals->CompressedData["
1:eJztlT9IQlEUxl8qBQUutQZF0VLk0BBRcRdH6Y/mUpYRVEtmi4gENbS1BUGD
IE6lzY3BHYqWegYGgZAmFYIgPYegLYt7jgfeifaEe+HxeL93PX7n++7h9a9F
/esOwzDSP5fTaK66MNgKvXmOB5OWiAUym13tF/S+seDtdkffxWzVM27dXBGP
jEz39h3UhFHyDo+6TeKZj5Nk/LUqVhZjroH7PHFzcn8jla6IO3V/JA77XgT8
rkC8TdUtii31P0/E55SOBwG6SsTjSve1gD6eiXeEesaGTo+m4KlMfBf2yyW2
fwbqSyNor98oKj0ywvQsg37J9UOfFWmyfs/AHxlm/kCfNelgfqL/cp75D7ot
mWB5wapLe9+Ur9yB/ZLXD0J94lHU86n6NolnUT/0nSeew34xX+Jh9Af6LhB3
Qr4S8yXuR/8xX+IsL+KdhynfROL8Ep7KxLft54G4D88P5kv8C/IVEaYnhOcz
y/Tf4nnOsX4xX7HK/MF8hatk97M5XwHmP+Yr9lhesPT86vm119fz20rzy1f5
j/eaa655C/Bf32PNNdf8//FvQ8u7DQ==
     "]],
   Scale[
    Cylinder[{{0, 0, -1}, {0, 0, 1}}], {
     Rational[1, 2], 1, 1}, {0, 0, 0}]],
  Boxed->False]], "Output",
 ImageSize->{153, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->400305895,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->143400472],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"Scale", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", ".5"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{{0.5, 0}, {0, 0.5}}, 
     Center}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->220953457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127508246],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", ".5", ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     CuboidBox[{0.25, 0.25, 0.25}, {0.75, 0.75, 0.75}], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0.25, 0.25, 0.25}]}, 
      {RGBColor[0., 1., 0.], Point3DBox[{0.75, 0.75, 0.75}]}}},
    Scale[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, 0.5, {0.5, 0.5, 0.5}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33014360,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26870574],

Cell["The transformations can be nested:", "ExampleText",
 CellID->770124944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Cuboid", "[", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623003240],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[
   GraphicsComplex3DBox[{{0., 0., 
    0.}, {-0.5773502691896258, -0.5773502691896258, 
    0.8660254037844389}, {-0.21132486540518708`, 0.7886751345948129, 
    0.8660254037844386}, {-0.7886751345948129, 0.21132486540518702`, 
    1.7320508075688776`}, {0.7886751345948129, -0.21132486540518708`, 
    0.8660254037844386}, {0.21132486540518702`, -0.7886751345948129, 
    1.7320508075688776`}, {0.5773502691896257, 0.5773502691896257, 
    1.7320508075688772`}, {-1.1102230246251565`*^-16, \
-1.1102230246251565`*^-16, 2.598076211353316}}, 
    Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {1, 
     2, 4, 3}, {5, 7, 8, 6}}],
    VertexColors->Automatic,
    VertexNormals->Automatic],
   Scale[
    Rotate[
     Cuboid[{0, 0, 0}], {{1, 1, 1}, {0, 0, 1}}], {1, 1, 1.5}, {0, 0, 0}]],
  Boxed->False]], "Output",
 ImageSize->{155, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262968596,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmdlSGkEUhltHiLgvqCjboCwSRUVwCwpu0Ww8BGVSpRepJMZ38X1yn4vc
5WWopPv0GcQ/TU0Tk5RFhZKGOf1/5+8+sswc6o2by3fvGzdXFw33/Lrx8fLq
4rN79uFahpw+IcStvH+PCPn8h3xG99tmsykn/o8W4xs5OrJoL+jotRoH5OGn
wlv91y8PzmjupRzVUVBGFXFC0XOODrP2iKJEOK08YpRnazR7yswURw8oegJM
mGcrNHvEzDy771K0xtEEa7cpWoVMLs+WaXafmQxHNylaASbHPus0u8dMgZkC
RXc4WuToCkW3IVOJZ/M0W2Zml/NnKVoCpsJMmmaLzFTvRdc5WlOAYpvfvorW
7BpkPGDWUSpS002kSL1qyEVCo3qlQ+6gUZ3vkNuszrWp1WPIqMrCCqqQ20yl
IfeIUbXIqkPIOQpql9QpWAnucsxIJds81OOkUZXwyW2m4rDLcEcVvdPrhS+C
bvuQ3cy11iQ5hXqvZfUYASJpJtTQtqsy+NplceRA7172jlpRAfBeA2+7LEH2
LgAd60jTK5mpPK84aVQnwSsEK86Ap12WIfZeYu8loBJGaoQpFzzt6DFYeZS9
s1b0OHsvgLeZdoGeAO+Z1mewDT3J3mHwtqOnmZ5ofVfcp+JGagZWPALedllm
2XsY6DUrOgJrCPIOikY6ZaCVOgDedvQC08JRuL6VrciYt2r2+z1qC6jYH6Ti
PivU1GKX+3p8FFYj+s+ppS731SsUVmPhAVS6yxX2CoXVmH8Alelyhb1NZYGK
+tQwYqT8vHqbynVZwzkj5efV29SyTw1LcqAeg1GNHnheY0dtGD+b/Kh147eC
H4VnfTErapWroK8k8j41WwEPM4UeeCbtWlHLQKWsqBxQi1ZUhqtAn3jiqU8V
0uChKdUnoWtTUOP1k+4BFcBjHqgUUPQeuOvz1OEcnikXKPrv665WGzUHVIJ3
rztaG7wPVMUht1ZvQu4wUHiVvEpUCahpoPDKXHfgyj5UhPexQeotUE+Beg48
NLXNu0f1LKiLpN4Fj3GgZoDS3cc9oMaAwl4MVUs8A2oUqCneve6KVngfmHsC
cmu11yXFnOOg3iF1FVYyBBR2we66t+1UCCjsuFGVxCFQg0AN8673Se31jVE1
BLm1+gRyB4EaBOqAqFOgAkA9AYqqJZ4DNQAU9kd17/wMKAeoAd79Mam97jyq
sK+r1arD7/UEFSAoW7tO9/xf/aLrBx1VRP+aEBBej1FphF4T/u7wGH4J+Ruj
6PsJx3yPYA==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51419378],

Cell["Apply transformation to scaled coordinates:", "ExampleText",
 CellID->121132598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
   
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554139376],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[Scaled[{1, 0}]], {{{2, 0}, {0, 2}}, Center}],
  Axes->True]], "Output",
 ImageSize->{184, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565338242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30296635],

Cell[TextData[{
 "Keep the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 " fixed:"
}], "ExampleText",
 CellID->620700476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], "]"}], ",", ".5", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35835793],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[Scaled[{1, 0}]], {{{0.5, 0.}, {0., 0.5}}, {0.5, 0.}}],
  Axes->True]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423577114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148993121],

Cell["Keep the top-left corner of the circle's bounding box fixed:", \
"ExampleText",
 CellID->798810123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], "]"}], ",", ".5", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Top"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229765181],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[Scaled[{1, 0}]], {{{0.5, 0}, {0, 0.5}}, {Left, Top}}],
  Axes->True]], "Output",
 ImageSize->{184, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120180866]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1587],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " to flip text along the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->284994702]
}], "ExampleText",
 CellID->804767636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Scale", "[", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<AaBbCc\>\"", ",", "20", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], "]"}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47088932],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[InsetBox[
    StyleBox["\<\"AaBbCc\"\>",
     StripOnInput->False,
     FontFamily->"Helvetica",
     FontSize->20], {0, 0}], {{{-1, 0}, {0, 1}}, Center}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8435848]
}, Open  ]],

Cell[TextData[{
 "Flip along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->255771213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Scale", "[", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<AaBbCc\>\"", ",", "20", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], "]"}],
     ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->465929168],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[InsetBox[
    StyleBox["\<\"AaBbCc\"\>",
     StripOnInput->False,
     FontFamily->"Helvetica",
     FontSize->20], {0, 0}], {{{1, 0}, {0, -1}}, Center}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->662041058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202150449],

Cell[TextData[{
 "The size of text is affected by ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " only when it is specified using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248168657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<AaBbCc\>\"", ",", "20", ",", 
          RowBox[{"FontSize", "\[Rule]", 
           RowBox[{"Scaled", "[", ".1", "]"}]}], ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        "]"}], ",", "s"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76609132],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GeometricTransformationBox[InsetBox[
      StyleBox["\<\"AaBbCc\"\>",
       StripOnInput->False,
       FontFamily->"Helvetica",
       FontSize->Scaled[0.1]], {0, 0}], {{{-1, 0}, {0, 1}}, Center}],
    PlotRange->1], ",", 
   GraphicsBox[GeometricTransformationBox[InsetBox[
      StyleBox["\<\"AaBbCc\"\>",
       StripOnInput->False,
       FontFamily->"Helvetica",
       FontSize->Scaled[0.1]], {0, 0}], {{{-2, 0}, {0, 2}}, Center}],
    PlotRange->1]}], "}"}]], "Output",
 ImageSize->{330, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70399574]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->296933454],

Cell[TextData[{
 "When possible, ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will transform the coordinates explicitly:"
}], "ExampleText",
 CellID->30475332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "@", 
  RowBox[{"Scale", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406297143],

Cell[BoxData[
 RowBox[{"Cuboid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", 
     RowBox[{"-", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", 
     RowBox[{"1", "+", "y"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "z"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427301005]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->558568534],

Cell["\<\
By default, scaling in 2D is done to keep the center of the bounding box \
fixed: \
\>", "ExampleText",
 CellID->45620381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", ".5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531913460],

Cell[BoxData[
 GraphicsBox[
  {Opacity[0.5], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.5, 0}, {0, 0.5}}, Center}]},
  Axes->True,
  PlotRange->1]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->612301215]
}, Open  ]],

Cell["Explicitly set the origin to be fixed: ", "ExampleText",
 CellID->344165267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", ".5", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734062809],

Cell[BoxData[
 GraphicsBox[
  {Opacity[0.5], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.5, 0.}, {0., 0.5}}, {0., 0.}}]},
  Axes->True,
  PlotRange->1]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19415925]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20846033],

Cell["Projections of a cylinder:", "ExampleText",
 CellID->178982019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Scale", "[", 
      RowBox[{
       RowBox[{"Cylinder", "[", "]"}], ",", "#", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ")"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->642868191],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmN1PXEUUwG+5CxTKxy4sn0v5KCCl7UALFtpSWlotjR/QlhqoLf1YPndZ
2IUFBa3aGOODMfqi0fiViImJb740vhkf/Av0yTfffDG+GN/MRs85c+7M3NlL
Cw8mEphhzvzOmblnzp0zc8fiG4n5lfhGcjbeejkbX00kZ9dbRzNZELn7HMd5
CH8/1jvw/z/wH/09zOVy0PG/Ly9i6f70diZHP07GkP7+0VpuO+uXuiDRrRC0
0ju0CqG1olpF0FpWrWJopVRrP7SWdmiVQCupWqXQSlDrAs3wau8cznA76yC3
aPQsjSxwD+osGD1vXUvs0PPFzBL3HIBi3uj5bn2Ze8qgOEeyjHgwLghqV2QY
eofQS9DpuNdFkr16SBERIAbRH0S8KFbyCMf9+8ssj1YBxZPoBaLviLU8ugqI
41CXETErXsojqoEQUFcQkRCv5BFRILpxbkSsiNfziBogOrEGosMnRabeJ60F
aQvUjT5pHUhjUB+kMcbFHI/Rpoh6IOqgbrV8p4kGIKJQHyLihvKdJEbId+M9
XkSgvTDIOi3fmXTi/IJBl4PssOVHk37zqhc5OJMSkB21fGrSn8W9aGqEoghk
guhl5V+TfrjmRVgMigKQnQC6XRHNIO1/jMRx//o8a1jpt3zdmqdr+ln34gpG
YBM7YvlZExiX+4GIfPVzrhjqdiJvKx9rEt/LQiBagcS6mcgZ5V9N4n4RwlGB
xLqRyEXlW00WAOkC0cdkLZEp8ZqPPA8lUqeBKoAaY1dG9DDaAMk56EGiSvUM
cY8LPQ5udVDjv8NsI6zIU2w9ROTzYpb9PsJkheX7FtIaYPvFqBVaOMfRB78X
WK+MVyXh0ztJqwvdPB/Sdx9c8eIRPXKRLZRaqyYt9PPIpaT5yV0vNvEhnyIZ
dIImKhdbqykt9FlzkJa+TXtxG2JL9HzWKksLx3kO5UDhLv+0NW6IV3zLp9Vr
jYvaJQHarhUFUrvH0q4grT8+XuNZF+9gSb6bwtKuhOIAa1CcKPKYRYaZHLVs
S/qoReN7hJnlEsWFoiF8ZCwfsfgqKMo9nq1DzHDkd1t0NRQVJn1DLGsPBdGV
Js3+bCb6sEVHoQirGIJpzIgN6GXbXRZdAwVmwPP45pKrF8SWHILtB2lgjhvC
nYY0lsR97MC9hDSesDRqocCcNwi1fBfS4sEjNXAMzGW4n1SCRoH15DHS6gwY
x3FfH/PeQRyzB2e7RwsfTifZAuZh3P1q6GWAxWfOcZpIv8PSryP9b5ZShn4X
yOpJH+JhV/rfb66wPvqgHWQx0ocg2YU+ZsIWqGlfD90Wq7sa87cPVnlMOheA
rA31C+NiQ3K8XrFH2NCnJDo5gKyDbMyLzV3aaAI9fJMo5xcmKa52o3cQ9HAf
oexfmBZv7FIPsy7umr2g51oR0rCjVgueHqDu25NWK54ioD7p5SGe3c6rghqD
XvbZAy3jRNNBUa7paYqQ3dL3xDrvDk2Bb26U/DEzNM+R0Kw0IQoeq9mm6KR4
lT36qHHem0rmjaNPy02B+1c1aW7PpwzNU6AZvJtWEa1vG4+n25gwzxqxwH09
QrZ/fX/Vsm2eNmKB2QYzrsyu+nyptacomWhtO7eVQFFEedLTuCUyPg07dxZC
UeLTgDjwaVBeDikN+C3z8XPiZR+vTgGchf20Pr+b9FLf/UBan981XcnEaagP
7kHquGNq1Rp3ICbU6mgCz6GtipgSqTwC73ItitAeb9T+c689t8hPGKYY8+i7
IhtAT15OMR2h5/HoWeVrk755Mc005sMmRevzvEnfHc4yXQ1FTNHL6jRn0vOn
NpmOQoG3qzM0hib02uHdoD6PwLtFHUvNNWhQBObAWkVMiMU8ogl6ahQxqdZA
E3jXjSripkjnEZg1qxVxR/ldEy3QU6UIfS9tMN6cCbWOaC/ie1pJTI56a4f2
8Lw2QBGkiVsXMkzg/RvPf5hvOgzi3tl1JvD+jadPzGNdBjE/6K0L3gfxPIsZ
8qhB6HXBXI3n4y6oexWBmRi/yqB+v5J2QwtP/DizASXF2yneInAdzigpjohn
ejwD4a3orOo5BhL8ChXlWvbI3WrsyhzPC/XxJhrhMU1q4tkEU3iTx5tTOXvC
pKYuLTPVw3Mo4VUxqekRz9+9tLLQndG3jxqLjivf93E8m73a7z00L/mlxCS0
36XX5NcWTXTTc8ivNFraSbEnvwdo6SF6M+TXHy1tpvdWfkvS0saMvB9VKanM
LePjnr9xNTDbRugy+kKf9yaeNujrz3h+x1VBWZjo7OhiAH1D+b+cY6uS6Hcn
kwH09Mgq07hK+K2tguivF1MBdHxog+lCKLCnnOgftlYC6IWBLaYLoBgGWRnR
v7yTCaBTJ7y9Dr9xHCDyz0/XfGSae4aohVZKVQvJ/aqFO0mxamH2LFKtjZz8
2iJbuKOEVAv3cle1NnPya4tsbdE8c9tZ35z+u2/Tzr5/AU2l0ns=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207854733]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22984],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Translate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Translate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Scale",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Scale"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->512318510],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->131721212],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "MoreAbout",
 CellID->101929],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->589146],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->213629734]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scale - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 8.1645718}", "context" -> "System`", 
    "keywords" -> {
     "geometric transforms", "graphics transformations", "magnification", 
      "magnify", "minification", "minify", "scale graphics", "scaling matrix",
       "scaling transform", "shrink", "stretch"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Scale[g, s] represents graphics primitives g scaled by a factor s. \
Scale[g, s, {x, y, ...}] scales with the point {x, y, ...} kept fixed. \
Scale[g, {s_x, s_y, ...}, ...] scales by different factors along different \
axes. ", "synonyms" -> {}, "title" -> "Scale", "type" -> "Symbol", "uri" -> 
    "ref/Scale"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11271, 370, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->297729643]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54841, 1620}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2365, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2988, 78, 1570, 37, 70, "ObjectNameGrid"],
Cell[4561, 117, 2057, 66, 70, "Usage",
 CellID->13542]
}, Open  ]],
Cell[CellGroupData[{
Cell[6655, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7133, 205, 380, 14, 70, "Notes",
 CellID->16983],
Cell[7516, 221, 449, 16, 70, "Notes",
 CellID->11637],
Cell[7968, 239, 947, 39, 70, "Notes",
 CellID->31161],
Cell[8918, 280, 456, 16, 70, "Notes",
 CellID->21575],
Cell[9377, 298, 542, 19, 70, "Notes",
 CellID->3581],
Cell[9922, 319, 598, 19, 70, "Notes",
 CellID->284994702],
Cell[10523, 340, 711, 25, 70, "Notes",
 CellID->11887]
}, Closed]],
Cell[CellGroupData[{
Cell[11271, 370, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->297729643],
Cell[CellGroupData[{
Cell[11656, 384, 148, 5, 70, "ExampleSection",
 CellID->730773964],
Cell[11807, 391, 65, 1, 70, "ExampleText",
 CellID->583741177],
Cell[CellGroupData[{
Cell[11897, 396, 328, 11, 28, "Input",
 CellID->165574862],
Cell[12228, 409, 281, 9, 115, "Output",
 CellID->337308862]
}, Open  ]],
Cell[12524, 421, 125, 3, 70, "ExampleDelimiter",
 CellID->205566430],
Cell[12652, 426, 64, 1, 70, "ExampleText",
 CellID->139463826],
Cell[CellGroupData[{
Cell[12741, 431, 422, 13, 70, "Input",
 CellID->149997708],
Cell[13166, 446, 10103, 173, 237, 2869, 50, "CachedBoxData", "BoxData", \
"Output",
 CellID->400305895]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23318, 625, 220, 7, 70, "ExampleSection",
 CellID->143400472],
Cell[23541, 634, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[23624, 637, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[24269, 661, 439, 15, 70, "Input",
 CellID->150504143],
Cell[24711, 678, 630, 15, 201, "Output",
 CellID->220953457]
}, Open  ]],
Cell[25356, 696, 125, 3, 70, "ExampleDelimiter",
 CellID->127508246],
Cell[25484, 701, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[25567, 704, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[26229, 728, 594, 19, 70, "Input",
 CellID->167437831],
Cell[26826, 749, 4989, 95, 216, 834, 22, "CachedBoxData", "BoxData", "Output",
 
 CellID->33014360]
}, Open  ]],
Cell[31830, 847, 124, 3, 70, "ExampleDelimiter",
 CellID->26870574],
Cell[31957, 852, 77, 1, 70, "ExampleText",
 CellID->770124944],
Cell[CellGroupData[{
Cell[32059, 857, 658, 20, 70, "Input",
 CellID->623003240],
Cell[32720, 879, 2371, 48, 237, 887, 19, "CachedBoxData", "BoxData", "Output",
 
 CellID->262968596]
}, Open  ]],
Cell[35106, 930, 124, 3, 70, "ExampleDelimiter",
 CellID->51419378],
Cell[35233, 935, 86, 1, 70, "ExampleText",
 CellID->121132598],
Cell[CellGroupData[{
Cell[35344, 940, 355, 12, 70, "Input",
 CellID->554139376],
Cell[35702, 954, 274, 9, 237, "Output",
 CellID->565338242]
}, Open  ]],
Cell[35991, 966, 124, 3, 70, "ExampleDelimiter",
 CellID->30296635],
Cell[36118, 971, 198, 8, 70, "ExampleText",
 CellID->620700476],
Cell[CellGroupData[{
Cell[36341, 983, 414, 13, 70, "Input",
 CellID->35835793],
Cell[36758, 998, 283, 9, 168, "Output",
 CellID->423577114]
}, Open  ]],
Cell[37056, 1010, 125, 3, 70, "ExampleDelimiter",
 CellID->148993121],
Cell[37184, 1015, 105, 2, 70, "ExampleText",
 CellID->798810123],
Cell[CellGroupData[{
Cell[37314, 1021, 420, 13, 70, "Input",
 CellID->229765181],
Cell[37737, 1036, 283, 9, 237, "Output",
 CellID->120180866]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38069, 1051, 238, 7, 70, "ExampleSection",
 CellID->1587],
Cell[38310, 1060, 367, 14, 70, "ExampleText",
 CellID->804767636],
Cell[CellGroupData[{
Cell[38702, 1078, 415, 13, 70, "Input",
 CellID->47088932],
Cell[39120, 1093, 403, 11, 121, "Output",
 CellID->8435848]
}, Open  ]],
Cell[39538, 1107, 148, 6, 70, "ExampleText",
 CellID->255771213],
Cell[CellGroupData[{
Cell[39711, 1117, 416, 13, 70, "Input",
 CellID->465929168],
Cell[40130, 1132, 405, 11, 121, "Output",
 CellID->662041058]
}, Open  ]],
Cell[40550, 1146, 125, 3, 70, "ExampleDelimiter",
 CellID->202150449],
Cell[40678, 1151, 362, 13, 70, "ExampleText",
 CellID->248168657],
Cell[CellGroupData[{
Cell[41065, 1168, 851, 27, 70, "Input",
 CellID->76609132],
Cell[41919, 1197, 716, 20, 173, "Output",
 CellID->70399574]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42684, 1223, 237, 7, 70, "ExampleSection",
 CellID->296933454],
Cell[42924, 1232, 235, 8, 70, "ExampleText",
 CellID->30475332],
Cell[CellGroupData[{
Cell[43184, 1244, 405, 13, 70, "Input",
 CellID->406297143],
Cell[43592, 1259, 453, 16, 36, "Output",
 CellID->427301005]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44094, 1281, 230, 7, 70, "ExampleSection",
 CellID->558568534],
Cell[44327, 1290, 132, 4, 70, "ExampleText",
 CellID->45620381],
Cell[CellGroupData[{
Cell[44484, 1298, 398, 12, 70, "Input",
 CellID->531913460],
Cell[44885, 1312, 310, 11, 197, "Output",
 CellID->612301215]
}, Open  ]],
Cell[45210, 1326, 82, 1, 70, "ExampleText",
 CellID->344165267],
Cell[CellGroupData[{
Cell[45317, 1331, 465, 14, 70, "Input",
 CellID->734062809],
Cell[45785, 1347, 313, 11, 197, "Output",
 CellID->19415925]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46147, 1364, 227, 7, 70, "ExampleSection",
 CellID->20846033],
Cell[46377, 1373, 69, 1, 70, "ExampleText",
 CellID->178982019],
Cell[CellGroupData[{
Cell[46471, 1378, 482, 15, 70, "Input",
 CellID->642868191],
Cell[46956, 1395, 2705, 48, 70, "Output",
 Evaluatable->False,
 CellID->207854733]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49722, 1450, 311, 9, 70, "SeeAlsoSection",
 CellID->22984],
Cell[50036, 1461, 1708, 62, 70, "SeeAlso",
 CellID->11997]
}, Open  ]],
Cell[CellGroupData[{
Cell[51781, 1528, 305, 8, 70, "RelatedLinksSection"],
Cell[52089, 1538, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52481, 1555, 319, 9, 70, "MoreAboutSection",
 CellID->512318510],
Cell[52803, 1566, 151, 3, 70, "MoreAbout",
 CellID->131721212],
Cell[52957, 1571, 156, 3, 70, "MoreAbout",
 CellID->101929],
Cell[53116, 1576, 159, 3, 70, "MoreAbout",
 CellID->589146],
Cell[53278, 1581, 179, 3, 70, "MoreAbout",
 CellID->213629734]
}, Open  ]],
Cell[53472, 1587, 27, 0, 70, "History"],
Cell[53502, 1589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

