(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52453,       2125]
NotebookOptionsPosition[     39856,       1660]
NotebookOutlinePosition[     41192,       1698]
CellTagsIndexPosition[     41106,       1693]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Parts of Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "Level" :> 
          Documentation`HelpLookup["paclet:ref/Level"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Apply\"\>", 2->"\<\"Map\"\>", 3->"\<\"Level\"\>",
        4->"\<\"Sow\"\>", 5->"\<\"NestWhile\"\>", 
       6->"\<\"Cases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Functional Programming\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Scan", "ObjectName",
 CellID->15110],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scan"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " applied to each element of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in turn. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scan"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22570]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " discards the results of applying ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to the subexpressions in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". Unlike ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " does not build up a new expression to return. "
}], "Notes",
 CellID->17543],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " to exit from ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["ret", "TI"], "]"}]], "InlineFormula"],
 " causes the final value of ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " to be ",
 Cell[BoxData[
  StyleBox["ret", "TI"]], "InlineFormula"],
 ". If no explicit return values are specified, the final result from ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7720],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit from ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15488,
  ButtonNote->"15488"]
}], "Notes",
 CellID->18879],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " is useful in carrying out an operation on parts of expressions where the \
operation has a \[OpenCurlyDoubleQuote]side effect",
 "\[CloseCurlyDoubleQuote]",
 ", such as making an assignment. "
}], "Notes",
 CellID->26170],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->6389],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->30316],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4740],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->8311],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4314],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->28200],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->4936],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " includes heads of expressions, and their parts.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1342037577]
}], "Notes",
 CellID->21371],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " traverses the parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in a depth-first order, with leaves visited before roots."
}], "Notes",
 CellID->4124],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " only to the values or subarrays that explicitly appear in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32443]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->439214092],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->252796344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1377],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->143091001],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->83391457],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->98983645]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"#", "^", "2"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9534],

Cell[CellGroupData[{

Cell[BoxData["4"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->458942069],

Cell[BoxData["9"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1019142737],

Cell[BoxData["16"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->574930669]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29726],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Level Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1181],

Cell["Scan level 1 (default):", "ExampleText",
 CellID->4015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->16626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->84708378]
}, Open  ]],

Cell["Scan down to level 2:", "ExampleText",
 CellID->9168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->390758853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->18143304]
}, Open  ]]
}, Open  ]],

Cell["Scan only level 2:", "ExampleText",
 CellID->12097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->329339139]
}, Open  ]],

Cell["Scan levels 0 through 2:", "ExampleText",
 CellID->15199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->241496365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->486748663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->40059457]
}, Open  ]]
}, Open  ]],

Cell["Scan down to level 3:", "ExampleText",
 CellID->19199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->12420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "a", "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->234964866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->287335137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->56869903]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199834716],

Cell["Scan all levels, starting at level 1:", "ExampleText",
 CellID->15813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}], ",", "Infinity"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->27415],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->139271777],

Cell[BoxData[
 RowBox[{"{", "a", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->530618291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "a", "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->129060854]
}, Open  ]]
}, Open  ]],

Cell["Scan also level 0:", "ExampleText",
 CellID->1468181890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3580],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->289500884],

Cell[BoxData[
 RowBox[{"{", "a", "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->7017633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "a", "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->8963935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->28704353]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221358435],

Cell["Negative levels:", "ExampleText",
 CellID->8387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13444],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->106582595],

Cell[BoxData[
 RowBox[{"{", "a", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->500258835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "a", "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->498847181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->464632423]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", "a", "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->978063360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "a", "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->62919638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->224018652]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17827],

Cell[BoxData[
 RowBox[{"{", "a", "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->240562648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522473821],

Cell["Positive and negative levels can be mixed:", "ExampleText",
 CellID->7152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "a", "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->318093061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", "a", "}"}], "}"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->207525070]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307878035],

Cell["Different heads at each level:", "ExampleText",
 CellID->19885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"h0", "[", 
    RowBox[{"h1", "[", 
     RowBox[{"h2", "[", 
      RowBox[{"h3", "[", 
       RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h3", "[", 
  RowBox[{"h4", "[", "a", "]"}], "]"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->314262798],

Cell[BoxData[
 RowBox[{"h2", "[", 
  RowBox[{"h3", "[", 
   RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->865162880]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15203],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " can be used on expressions with any head:"
}], "ExampleText",
 CellID->31561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23245],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->237024350],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->405531346],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->614645355]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28274],

Cell[CellGroupData[{

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->480187714],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->302920606],

Cell[BoxData["y"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1331049],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->385645224]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4509],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " works inside ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->15488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Scan", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", "5"}], ",", 
       RowBox[{"Throw", "[", "#", "]"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "6", ",", "8"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25283],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88723650]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3790],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->240017317],

Cell["By default, heads are not scanned:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1342037577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876496194],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->187149206],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1877374]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1926551480],

Cell[CellGroupData[{

Cell[BoxData["List"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->293418488],

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->30195339],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->305053039]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->213113975],

Cell["Make assignments based on data:", "ExampleText",
 CellID->16109],

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", "[", "#", "]"}], "=", "x"}], ")"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "11", ",", "77", ",", "88"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"u", "[", "76", "]"}], ",", 
   RowBox[{"u", "[", "77", "]"}], ",", 
   RowBox[{"u", "[", "78", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3573],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"u", "[", "76", "]"}], ",", "x", ",", 
   RowBox[{"u", "[", "78", "]"}]}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->661586477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->818763334],

Cell["Find all leaves in an expression:", "ExampleText",
 CellID->1608820748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10761],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{308, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76176539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{"Scan", "[", 
    RowBox[{"Sow", ",", "%", ",", 
     RowBox[{"{", 
      RowBox[{"-", "1"}], "}"}]}], "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->665474533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "3", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "3", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "1", ",", "2", ",", "x", ",", 
   FractionBox["1", "3"], ",", 
   RowBox[{"-", "1"}], ",", "x", ",", 
   RowBox[{"-", 
    FractionBox["1", "6"]}], ",", "1", ",", "x", ",", "x", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{353, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84735651]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->191578441],

Cell["Leaves are visited before roots:", "ExampleText",
 CellID->136711517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Scan", "[", 
   RowBox[{"Print", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1353467537],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->33350300],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->32927599],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->326831738],

Cell[BoxData[
 RowBox[{"{", "c", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->41887688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", 
   RowBox[{"{", "c", "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->156221314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->943676]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234291279],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " does the same as ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", but without returning a result:"
}], "ExampleText",
 CellID->19840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26542],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->72207953],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->181508821],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->20110302]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23023232]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31409],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->176723916],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->252443329],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->189494459]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->285180449],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " to collect results:"
}], "ExampleText",
 CellID->2008036451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{"Scan", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", ">", "0"}], ",", 
        RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "\[Pi]"}], "}"}], ",", 
       RowBox[{"-", 
        SqrtBox["3"]}]}], "}"}], ",", "\[Infinity]"}], "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1768022934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "\[Pi]", ",", "3", ",", 
   FractionBox["1", "2"], ",", 
   SqrtBox["3"]}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389104384]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4051],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12482],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->7859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->127311913],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->356677166],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->638425136],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->189540547],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->371672520]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 10.9771438}", "context" -> "System`", 
    "keywords" -> {
     "applying functions", "tree walking", "walking through expressions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Scan[f, expr] evaluates f applied to each element of expr in turn. \
Scan[f, expr, levelspec] applies f to parts of expr specified by levelspec. ",
     "synonyms" -> {}, "title" -> "Scan", "type" -> "Symbol", "uri" -> 
    "ref/Scan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12428, 448, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->439214092]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40962, 1686}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2700, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3323, 88, 42, 1, 70, "ObjectName",
 CellID->15110],
Cell[3368, 91, 1310, 44, 70, "Usage",
 CellID->22570]
}, Open  ]],
Cell[CellGroupData[{
Cell[4715, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5193, 157, 734, 27, 70, "Notes",
 CellID->17543],
Cell[5930, 186, 1003, 38, 70, "Notes",
 CellID->7720],
Cell[6936, 226, 421, 17, 70, "Notes",
 CellID->18879],
Cell[7360, 245, 351, 10, 70, "Notes",
 CellID->26170],
Cell[7714, 257, 194, 7, 70, "Notes",
 CellID->6389],
Cell[7911, 266, 1664, 55, 70, "2ColumnTableMod",
 CellID->30316],
Cell[9578, 323, 331, 14, 70, "Notes",
 CellID->4740],
Cell[9912, 339, 302, 12, 70, "Notes",
 CellID->8311],
Cell[10217, 353, 311, 13, 70, "Notes",
 CellID->4314],
Cell[10531, 368, 189, 6, 70, "Notes",
 CellID->28200],
Cell[10723, 376, 133, 5, 70, "Notes",
 CellID->4936],
Cell[10859, 383, 547, 20, 70, "Notes",
 CellID->21371],
Cell[11409, 405, 305, 10, 70, "Notes",
 CellID->4124],
Cell[11717, 417, 674, 26, 70, "Notes",
 CellID->32443]
}, Closed]],
Cell[CellGroupData[{
Cell[12428, 448, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->439214092],
Cell[CellGroupData[{
Cell[12813, 462, 148, 5, 70, "ExampleSection",
 CellID->252796344],
Cell[CellGroupData[{
Cell[12986, 471, 181, 6, 70, "Input",
 CellID->1377],
Cell[CellGroupData[{
Cell[13192, 481, 91, 2, 70, "Print",
 CellID->143091001],
Cell[13286, 485, 90, 2, 70, "Print",
 CellID->83391457],
Cell[13379, 489, 90, 2, 70, "Print",
 CellID->98983645]
}, Open  ]]
}, Open  ]],
Cell[13496, 495, 120, 3, 70, "ExampleDelimiter",
 CellID->4153],
Cell[CellGroupData[{
Cell[13641, 502, 256, 9, 70, "Input",
 CellID->9534],
Cell[CellGroupData[{
Cell[13922, 515, 91, 2, 70, "Print",
 CellID->458942069],
Cell[14016, 519, 92, 2, 70, "Print",
 CellID->1019142737],
Cell[14111, 523, 92, 2, 70, "Print",
 CellID->574930669]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14264, 532, 216, 7, 70, "ExampleSection",
 CellID->29726],
Cell[CellGroupData[{
Cell[14505, 543, 236, 7, 70, "ExampleSubsection",
 CellID->1181],
Cell[14744, 552, 61, 1, 70, "ExampleText",
 CellID->4015],
Cell[CellGroupData[{
Cell[14830, 557, 255, 10, 70, "Input",
 CellID->16626],
Cell[15088, 569, 184, 6, 70, "Print",
 CellID->84708378]
}, Open  ]],
Cell[15287, 578, 59, 1, 70, "ExampleText",
 CellID->9168],
Cell[CellGroupData[{
Cell[15371, 583, 266, 10, 70, "Input",
 CellID->17906],
Cell[CellGroupData[{
Cell[15662, 597, 160, 5, 70, "Print",
 CellID->390758853],
Cell[15825, 604, 184, 6, 70, "Print",
 CellID->18143304]
}, Open  ]]
}, Open  ]],
Cell[16036, 614, 57, 1, 70, "ExampleText",
 CellID->12097],
Cell[CellGroupData[{
Cell[16118, 619, 287, 10, 70, "Input",
 CellID->28118],
Cell[16408, 631, 160, 5, 70, "Print",
 CellID->329339139]
}, Open  ]],
Cell[16583, 639, 63, 1, 70, "ExampleText",
 CellID->15199],
Cell[CellGroupData[{
Cell[16671, 644, 312, 11, 70, "Input",
 CellID->11785],
Cell[CellGroupData[{
Cell[17008, 659, 160, 5, 70, "Print",
 CellID->241496365],
Cell[17171, 666, 185, 6, 70, "Print",
 CellID->486748663],
Cell[17359, 674, 210, 7, 70, "Print",
 CellID->40059457]
}, Open  ]]
}, Open  ]],
Cell[17596, 685, 60, 1, 70, "ExampleText",
 CellID->19199],
Cell[CellGroupData[{
Cell[17681, 690, 266, 10, 70, "Input",
 CellID->12420],
Cell[CellGroupData[{
Cell[17972, 704, 136, 4, 70, "Print",
 CellID->234964866],
Cell[18111, 710, 160, 5, 70, "Print",
 CellID->287335137],
Cell[18274, 717, 184, 6, 70, "Print",
 CellID->56869903]
}, Open  ]]
}, Open  ]],
Cell[18485, 727, 125, 3, 70, "ExampleDelimiter",
 CellID->199834716],
Cell[18613, 732, 76, 1, 70, "ExampleText",
 CellID->15813],
Cell[CellGroupData[{
Cell[18714, 737, 217, 8, 70, "Input",
 CellID->27415],
Cell[CellGroupData[{
Cell[18956, 749, 91, 2, 70, "Print",
 CellID->139271777],
Cell[19050, 753, 113, 3, 70, "Print",
 CellID->530618291],
Cell[19166, 758, 136, 4, 70, "Print",
 CellID->129060854]
}, Open  ]]
}, Open  ]],
Cell[19329, 766, 62, 1, 70, "ExampleText",
 CellID->1468181890],
Cell[CellGroupData[{
Cell[19416, 771, 263, 9, 70, "Input",
 CellID->3580],
Cell[CellGroupData[{
Cell[19704, 784, 91, 2, 70, "Print",
 CellID->289500884],
Cell[19798, 788, 111, 3, 70, "Print",
 CellID->7017633],
Cell[19912, 793, 134, 4, 70, "Print",
 CellID->8963935],
Cell[20049, 799, 159, 5, 70, "Print",
 CellID->28704353]
}, Open  ]]
}, Open  ]],
Cell[20235, 808, 125, 3, 70, "ExampleDelimiter",
 CellID->221358435],
Cell[20363, 813, 54, 1, 70, "ExampleText",
 CellID->8387],
Cell[CellGroupData[{
Cell[20442, 818, 254, 9, 70, "Input",
 CellID->13444],
Cell[CellGroupData[{
Cell[20721, 831, 91, 2, 70, "Print",
 CellID->106582595],
Cell[20815, 835, 113, 3, 70, "Print",
 CellID->500258835],
Cell[20931, 840, 136, 4, 70, "Print",
 CellID->498847181],
Cell[21070, 846, 160, 5, 70, "Print",
 CellID->464632423]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21279, 857, 254, 9, 70, "Input",
 CellID->14507],
Cell[CellGroupData[{
Cell[21558, 870, 113, 3, 70, "Print",
 CellID->978063360],
Cell[21674, 875, 135, 4, 70, "Print",
 CellID->62919638],
Cell[21812, 881, 160, 5, 70, "Print",
 CellID->224018652]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22021, 892, 279, 10, 70, "Input",
 CellID->17827],
Cell[22303, 904, 113, 3, 70, "Print",
 CellID->240562648]
}, Open  ]],
Cell[22431, 910, 125, 3, 70, "ExampleDelimiter",
 CellID->522473821],
Cell[22559, 915, 80, 1, 70, "ExampleText",
 CellID->7152],
Cell[CellGroupData[{
Cell[22664, 920, 333, 12, 70, "Input",
 CellID->30271],
Cell[CellGroupData[{
Cell[23022, 936, 136, 4, 70, "Print",
 CellID->318093061],
Cell[23161, 942, 160, 5, 70, "Print",
 CellID->207525070]
}, Open  ]]
}, Open  ]],
Cell[23348, 951, 125, 3, 70, "ExampleDelimiter",
 CellID->307878035],
Cell[23476, 956, 69, 1, 70, "ExampleText",
 CellID->19885],
Cell[CellGroupData[{
Cell[23570, 961, 361, 12, 70, "Input",
 CellID->337],
Cell[CellGroupData[{
Cell[23956, 977, 148, 4, 70, "Print",
 CellID->314262798],
Cell[24107, 983, 178, 5, 70, "Print",
 CellID->865162880]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24358, 996, 239, 7, 70, "ExampleSection",
 CellID->15203],
Cell[24600, 1005, 207, 7, 70, "ExampleText",
 CellID->31561],
Cell[CellGroupData[{
Cell[24832, 1016, 157, 5, 70, "Input",
 CellID->23245],
Cell[CellGroupData[{
Cell[25014, 1025, 91, 2, 70, "Print",
 CellID->237024350],
Cell[25108, 1029, 91, 2, 70, "Print",
 CellID->405531346],
Cell[25202, 1033, 91, 2, 70, "Print",
 CellID->614645355]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25342, 1041, 231, 8, 70, "Input",
 CellID->28274],
Cell[CellGroupData[{
Cell[25598, 1053, 91, 2, 70, "Print",
 CellID->480187714],
Cell[25692, 1057, 91, 2, 70, "Print",
 CellID->302920606],
Cell[25786, 1061, 89, 2, 70, "Print",
 CellID->1331049],
Cell[25878, 1065, 91, 2, 70, "Print",
 CellID->385645224]
}, Open  ]]
}, Open  ]],
Cell[25996, 1071, 120, 3, 70, "ExampleDelimiter",
 CellID->4509],
Cell[26119, 1076, 346, 13, 70, "ExampleText",
 CellID->15488],
Cell[CellGroupData[{
Cell[26490, 1093, 370, 13, 70, "Input",
 CellID->25283],
Cell[26863, 1108, 157, 5, 36, "Output",
 CellID->88723650]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27069, 1119, 217, 7, 70, "ExampleSection",
 CellID->3790],
Cell[CellGroupData[{
Cell[27311, 1130, 226, 7, 70, "ExampleSubsection",
 CellID->240017317],
Cell[27540, 1139, 126, 2, 70, "ExampleText",
 CellID->1342037577],
Cell[CellGroupData[{
Cell[27691, 1145, 176, 6, 70, "Input",
 CellID->876496194],
Cell[CellGroupData[{
Cell[27892, 1155, 91, 2, 70, "Print",
 CellID->187149206],
Cell[27986, 1159, 89, 2, 70, "Print",
 CellID->1877374]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28124, 1167, 219, 7, 70, "Input",
 CellID->1926551480],
Cell[CellGroupData[{
Cell[28368, 1178, 94, 2, 70, "Print",
 CellID->293418488],
Cell[28465, 1182, 90, 2, 70, "Print",
 CellID->30195339],
Cell[28558, 1186, 91, 2, 70, "Print",
 CellID->305053039]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28722, 1196, 227, 7, 70, "ExampleSection",
 CellID->213113975],
Cell[28952, 1205, 70, 1, 70, "ExampleText",
 CellID->16109],
Cell[29025, 1208, 295, 11, 70, "Input",
 CellID->1669],
Cell[CellGroupData[{
Cell[29345, 1223, 210, 7, 70, "Input",
 CellID->3573],
Cell[29558, 1232, 274, 9, 36, "Output",
 CellID->661586477]
}, Open  ]],
Cell[29847, 1244, 125, 3, 70, "ExampleDelimiter",
 CellID->818763334],
Cell[29975, 1249, 77, 1, 70, "ExampleText",
 CellID->1608820748],
Cell[CellGroupData[{
Cell[30077, 1254, 229, 9, 70, "Input",
 CellID->10761],
Cell[30309, 1265, 634, 24, 72, "Output",
 CellID->76176539]
}, Open  ]],
Cell[CellGroupData[{
Cell[30980, 1294, 292, 10, 70, "Input",
 CellID->665474533],
Cell[31275, 1306, 532, 17, 51, "Output",
 CellID->84735651]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31856, 1329, 237, 7, 70, "ExampleSection",
 CellID->191578441],
Cell[32096, 1338, 75, 1, 70, "ExampleText",
 CellID->136711517],
Cell[CellGroupData[{
Cell[32196, 1343, 365, 13, 70, "Input",
 CellID->1353467537],
Cell[CellGroupData[{
Cell[32586, 1360, 90, 2, 70, "Print",
 CellID->33350300],
Cell[32679, 1364, 90, 2, 70, "Print",
 CellID->32927599],
Cell[32772, 1368, 91, 2, 70, "Print",
 CellID->326831738],
Cell[32866, 1372, 112, 3, 70, "Print",
 CellID->41887688],
Cell[32981, 1377, 160, 5, 70, "Print",
 CellID->156221314],
Cell[33144, 1384, 208, 7, 70, "Print",
 CellID->943676]
}, Open  ]]
}, Open  ]],
Cell[33379, 1395, 125, 3, 70, "ExampleDelimiter",
 CellID->234291279],
Cell[33507, 1400, 330, 12, 70, "ExampleText",
 CellID->19840],
Cell[CellGroupData[{
Cell[33862, 1416, 181, 6, 70, "Input",
 CellID->26542],
Cell[CellGroupData[{
Cell[34068, 1426, 90, 2, 70, "Print",
 CellID->72207953],
Cell[34161, 1430, 91, 2, 70, "Print",
 CellID->181508821],
Cell[34255, 1434, 90, 2, 70, "Print",
 CellID->20110302]
}, Open  ]],
Cell[34360, 1439, 222, 7, 36, "Output",
 CellID->23023232]
}, Open  ]],
Cell[CellGroupData[{
Cell[34619, 1451, 182, 6, 70, "Input",
 CellID->31409],
Cell[CellGroupData[{
Cell[34826, 1461, 91, 2, 70, "Print",
 CellID->176723916],
Cell[34920, 1465, 91, 2, 70, "Print",
 CellID->252443329],
Cell[35014, 1469, 91, 2, 70, "Print",
 CellID->189494459]
}, Open  ]]
}, Open  ]],
Cell[35132, 1475, 125, 3, 70, "ExampleDelimiter",
 CellID->285180449],
Cell[35260, 1480, 318, 13, 70, "ExampleText",
 CellID->2008036451],
Cell[CellGroupData[{
Cell[35603, 1497, 590, 20, 70, "Input",
 CellID->1768022934],
Cell[36196, 1519, 273, 9, 51, "Output",
 CellID->389104384]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36530, 1535, 310, 9, 70, "SeeAlsoSection",
 CellID->4051],
Cell[36843, 1546, 1394, 53, 70, "SeeAlso",
 CellID->7691]
}, Open  ]],
Cell[CellGroupData[{
Cell[38274, 1604, 314, 9, 70, "TutorialsSection",
 CellID->12482],
Cell[38591, 1615, 192, 4, 70, "Tutorials",
 CellID->7859]
}, Open  ]],
Cell[CellGroupData[{
Cell[38820, 1624, 319, 9, 70, "MoreAboutSection",
 CellID->127311913],
Cell[39142, 1635, 163, 3, 70, "MoreAbout",
 CellID->356677166],
Cell[39308, 1640, 155, 3, 70, "MoreAbout",
 CellID->638425136],
Cell[39466, 1645, 145, 3, 70, "MoreAbout",
 CellID->189540547],
Cell[39614, 1650, 147, 3, 70, "MoreAbout",
 CellID->371672520]
}, Open  ]],
Cell[39776, 1656, 50, 0, 70, "History"],
Cell[39829, 1658, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

