(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15479,        542]
NotebookOptionsPosition[     12184,        434]
NotebookOutlinePosition[     13583,        473]
CellTagsIndexPosition[     13498,        468]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScriptMinSize" :> 
          Documentation`HelpLookup["paclet:ref/ScriptMinSize"], 
          "ScriptBaselineShifts" :> 
          Documentation`HelpLookup["paclet:ref/ScriptBaselineShifts"], 
          "ImageSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeMultipliers"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ScriptMinSize\"\>", 
       2->"\<\"ScriptBaselineShifts\"\>", 
       3->"\<\"ImageSizeMultipliers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accessibility" :> 
          Documentation`HelpLookup["paclet:guide/Accessibility"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Accessibility\"\>", 
       2->"\<\"Mathematical Typesetting\"\>", 
       3->"\<\"Math Typesetting Options & Tweaking\"\>", 
       4->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScriptSizeMultipliers", "ObjectName",
 CellID->30396],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ScriptSizeMultipliers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " which specifies how much smaller to render each successive level of \
subscripts, etc. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ScriptSizeMultipliers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFormula"],
 " is applied to ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " for characters that appear in constructs such as subscripts, superscripts, \
underscripts, overscripts and built\[Hyphen]up fractions. "
}], "Notes",
 CellID->19752],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["ScriptSizeMultipliers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFormula"],
 " is ",
 Cell[BoxData["0.71"], "InlineFormula"],
 ", yielding approximately a factor 2 reduction in character area at each \
level. "
}], "Notes",
 CellID->8453],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ScriptSizeMultipliers", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 " uses multiplier ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", and multiplier ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 " for levels ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " and beyond. "
}], "Notes",
 CellID->20705]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->460075472],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->6626371],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ScriptSizeMultipliers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFormula"],
 " to set the factor by which font size is reduced for superscripts:"
}], "ExampleText",
 CellID->279618131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", "n"}]}], ",", "Large", ",", 
     RowBox[{"ScriptSizeMultipliers", "\[Rule]", "ssm"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ssm", ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".9", ",", "1.0"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->128184475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptSizeMultipliers->0.8,
    FontSize->Large], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptSizeMultipliers->0.9,
    FontSize->Large], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptSizeMultipliers->1.,
    FontSize->Large]}], "}"}]], "Output",
 ImageSize->{158, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63598606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->679758697],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ScriptSizeMultipliers", "->", 
   StyleBox["list", "TI"]}]], "InlineFormula"],
 " uses different factors for different levels:"
}], "ExampleText",
 CellID->148048739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", 
       RowBox[{"n", "^", "p"}]}]}], ",", "Large", ",", 
     RowBox[{"ScriptSizeMultipliers", "\[Rule]", ".8"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", 
       RowBox[{"n", "^", "p"}]}]}], ",", "Large", ",", 
     RowBox[{"ScriptSizeMultipliers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{".8", ",", ".9", ",", ".95"}], "}"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21766505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", 
      SuperscriptBox["n", "p"]]],
    StripOnInput->False,
    ScriptSizeMultipliers->0.8,
    FontSize->Large], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", 
      SuperscriptBox["n", "p"]]],
    StripOnInput->False,
    ScriptSizeMultipliers->{0.8, 0.9, 0.95},
    FontSize->Large]}], "}"}]], "Output",
 ImageSize->{119, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3629833]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25084],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptMinSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptMinSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptBaselineShifts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptBaselineShifts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28577],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->334255889],

Cell[TextData[ButtonBox["Accessibility",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Accessibility"]], "MoreAbout",
 CellID->15707225],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->717590439],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->70923362],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->55567087]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScriptSizeMultipliers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 16.5241608}", "context" -> "System`", 
    "keywords" -> {
     "\\scriptscriptstyle (TeX)", "\\scriptstyle (TeX)", "subscripts"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ScriptSizeMultipliers is an option for Style which specifies how much \
smaller to render each successive level of subscripts, etc. ", 
    "synonyms" -> {"script size multipliers"}, "title" -> 
    "ScriptSizeMultipliers", "type" -> "Symbol", "uri" -> 
    "ref/ScriptSizeMultipliers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6060, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->460075472]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13355, 461}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2497, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3120, 86, 59, 1, 70, "ObjectName",
 CellID->30396],
Cell[3182, 89, 652, 19, 70, "Usage",
 CellID->11008]
}, Open  ]],
Cell[CellGroupData[{
Cell[3871, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4349, 130, 468, 13, 70, "Notes",
 CellID->19752],
Cell[4820, 145, 352, 11, 70, "Notes",
 CellID->8453],
Cell[5175, 158, 848, 33, 70, "Notes",
 CellID->20705]
}, Closed]],
Cell[CellGroupData[{
Cell[6060, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->460075472],
Cell[CellGroupData[{
Cell[6445, 210, 146, 5, 70, "ExampleSection",
 CellID->6626371],
Cell[6594, 217, 278, 8, 70, "ExampleText",
 CellID->279618131],
Cell[CellGroupData[{
Cell[6897, 229, 423, 14, 28, "Input",
 CellID->128184475],
Cell[7323, 245, 647, 25, 60, "Output",
 CellID->63598606]
}, Open  ]],
Cell[7985, 273, 125, 3, 70, "ExampleDelimiter",
 CellID->679758697],
Cell[8113, 278, 208, 6, 70, "ExampleText",
 CellID->148048739],
Cell[CellGroupData[{
Cell[8346, 288, 597, 19, 70, "Input",
 CellID->21766505],
Cell[8946, 309, 561, 21, 61, "Output",
 CellID->3629833]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9568, 337, 311, 9, 70, "SeeAlsoSection",
 CellID->25084],
Cell[9882, 348, 754, 26, 70, "SeeAlso",
 CellID->23868]
}, Open  ]],
Cell[CellGroupData[{
Cell[10673, 379, 314, 9, 70, "TutorialsSection",
 CellID->28577],
Cell[10990, 390, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[11173, 398, 319, 9, 70, "MoreAboutSection",
 CellID->334255889],
Cell[11495, 409, 137, 3, 70, "MoreAbout",
 CellID->15707225],
Cell[11635, 414, 159, 3, 70, "MoreAbout",
 CellID->717590439],
Cell[11797, 419, 179, 3, 70, "MoreAbout",
 CellID->70923362],
Cell[11979, 424, 133, 3, 70, "MoreAbout",
 CellID->55567087]
}, Open  ]],
Cell[12127, 430, 27, 0, 70, "History"],
Cell[12157, 432, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

