(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    123540,       4136]
NotebookOptionsPosition[    104635,       3440]
NotebookOutlinePosition[    105789,       3475]
CellTagsIndexPosition[    105702,       3470]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cos" :> Documentation`HelpLookup["paclet:ref/Cos"], "ArcSec" :> 
          Documentation`HelpLookup["paclet:ref/ArcSec"], "Csc" :> 
          Documentation`HelpLookup["paclet:ref/Csc"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cos\"\>", 2->"\<\"ArcSec\"\>", 
       3->"\<\"Csc\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sec", "ObjectName",
 CellID->26206],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sec",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sec"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the secant of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " is assumed to be in radians. (Multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees.) "
}], "Notes",
 CellID->8342],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sec", "(", "z", ")"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"cos", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->1783],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["1", "TR"], "/", 
   RowBox[{
    ButtonBox["Cos",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cos"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sec"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does decomposition. "
}], "Notes",
 CellID->14201],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57883915],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->88733799],

Cell["The argument is given in radians:", "ExampleText",
 CellID->27007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"Pi", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24348],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82022310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3478],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to specify an argument in degrees:"
}], "ExampleText",
 CellID->4876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"30", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15116],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5486948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31037],

Cell["Evaluate numerically:", "ExampleText",
 CellID->5918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15102],

Cell[BoxData["2.759703601332406`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164859955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13489],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{158, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{158., Automatic}},
 CellLabel->"Out[1]=",
 CellID->158923446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26395],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], "24"], "+", 
   FractionBox[
    RowBox[{"61", " ", 
     SuperscriptBox["x", "6"]}], "720"], "+", 
   FractionBox[
    RowBox[{"277", " ", 
     SuperscriptBox["x", "8"]}], "8064"], "+", 
   FractionBox[
    RowBox[{"50521", " ", 
     SuperscriptBox["x", "10"]}], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 2], 0, 
    Rational[5, 24], 0, 
    Rational[61, 720], 0, 
    Rational[277, 8064], 0, 
    Rational[50521, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{305, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282601564]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30312],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->31098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16376],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.6111085641552315`"}], "+", 
  RowBox[{"0.347676660710496`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44707881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->574606882],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->20853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"12", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25473],

Cell[BoxData["2.\
7597036013324064568834329392377838600731153230110276521116421824202`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84121164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177039722],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->10832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", "1.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14543],

Cell[BoxData["2.75970360133240645688343293923778386007`22.58970343438236"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->494483461]
}, Open  ]],

Cell["\<\
The precision of the output can be much smaller or larger than the precision \
of the input:\
\>", "ExampleText",
 CellID->32662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", "1.5707963267948966192213216916397514421", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21708],

Cell[BoxData["1.00000000000000000014153003126`17.*^20"], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119594859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"2", " ", "1.5707963267948966192213216916397514421"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10696],

Cell[BoxData[
 RowBox[{"-", 
  "1.0000000000000000000000000000000000000001999999999999999999433879875`56.\
39794000867204"}]], "Output",
 ImageSize->{418, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->465217637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28552],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->28113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.759703601332406`", ",", "14.136832902969903`", ",", 
   RowBox[{"-", "4.4013678718536315`"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5757969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {
       FractionBox["\[Pi]", "4"], "u"},
      {"v", 
       FractionBox["\[Pi]", "3"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", 
     RowBox[{"Sec", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sec", "[", "v", "]"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->335045069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21942],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->24314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"Pi", "/", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SqrtBox["5"]}]], "Output",
 ImageSize->{56, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869592014]
}, Open  ]],

Cell[TextData[{
 "More complicated cases require explicit use of ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"Pi", "/", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11271],

Cell[BoxData[
 RowBox[{"Sec", "[", 
  FractionBox["\[Pi]", "30"], "]"}]], "Output",
 ImageSize->{58, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16668474]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31032],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SqrtBox["5"]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SqrtBox["3"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}]}]}]]], "Output",
 ImageSize->{222, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->285580522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7460],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellID->31129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sec", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12185],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"], "-", 
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "4"]}]]], "Output",
 ImageSize->{237, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210631427]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23214],

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->472926995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11170],

Cell["Convert sums of trigonometric functions to products:", "ExampleText",
 CellID->23525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "x", "]"}], "+", 
   RowBox[{"Sec", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24521],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "-", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "+", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "-", 
    FractionBox["x", "2"]}], "]"}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "+", 
    FractionBox["x", "2"]}], "]"}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "-", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "+", 
    FractionBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{457, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61448237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13765],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->30872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sec", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19866],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Cosh", "[", "y", "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sinh", "[", "y", "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]]}]], "Output",
 ImageSize->{273, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157166904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Sec", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13231],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]], "Output",
 ImageSize->{65, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88022926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70607291],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->67006696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sec", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23169288],

Cell[BoxData[
 FormBox[
  RowBox[{"sec", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->200715297]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->475],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->1255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Pi", "/", "3"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27332],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41919336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31102],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->11533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3948],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82127589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9158],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64961714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26740],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " to a power series:"
}], "ExampleText",
 CellID->15589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18069],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "x"]}], "+", 
   FractionBox["1", "2"], "-", 
   FractionBox["x", "12"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"],
    SeriesData[$CellContext`x, 0, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-1, 
    Rational[1, 2], 
    Rational[-1, 12]}, -1, 2, 1],
  Editable->False]], "Output",
 ImageSize->{124, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230865025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30826],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays: "
}], "ExampleText",
 CellID->18647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "\[Pi]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "4"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "\[Rule]", "2"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29573],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241250208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11615],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21769748]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->21966],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "1", "2"},
     {"1", "1", "1"},
     {"1", "1", 
      SqrtBox["2"]},
     {"1", 
      RowBox[{"Sec", "[", "2", "]"}], "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{121, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->64454836]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31576],

Cell["Generate a plot with poles removed:", "ExampleText",
 CellID->5995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2398],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27099377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24086],

Cell["Generate a plot over the complex argument plane:", "ExampleText",
 CellID->8568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Sec", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5025],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170256566]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15809],

Cell["\<\
Basic parity and periodicity properties of the secant function get \
automatically applied:\
\>", "ExampleText",
 CellID->15327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sec", "[", 
   RowBox[{"x", "+", "Pi"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7030],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Sec", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576180309]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31384],

Cell[BoxData[
 RowBox[{"Sec", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->285813766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1326],

Cell[BoxData[
 RowBox[{"Sech", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->711363821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Sec", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11923],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->543861518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26278],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigFactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactorList"]], "InlineFormula"],
 " to factor ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " into ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11161],

Cell[BoxData[
 RowBox[{"Sec", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7397754]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{"Sec", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192306278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10739],

Cell["\<\
Complicated expressions containing trigonometric functions do not \
autosimplify:\
\>", "ExampleText",
 CellID->10610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"z", "-", 
     RowBox[{"\[Pi]", "/", "3"}]}], "]"}], " ", 
   RowBox[{"Sec", "[", 
    RowBox[{
     RowBox[{"\[Pi]", "/", "3"}], "+", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"z", "-", 
     RowBox[{"\[Pi]", "/", "3"}]}], "]"}], " ", 
   RowBox[{"Sec", "[", "z", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Sec", "[", "z", "]"}], " ", 
   RowBox[{"Sec", "[", 
    RowBox[{
     RowBox[{"\[Pi]", "/", "3"}], "+", "z"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28992],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{
     FractionBox["\[Pi]", "6"], "-", "z"}], "]"}], " ", 
   RowBox[{"Csc", "[", 
    RowBox[{
     FractionBox["\[Pi]", "6"], "+", "z"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{
     FractionBox["\[Pi]", "6"], "-", "z"}], "]"}], " ", 
   RowBox[{"Sec", "[", "z", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{
     FractionBox["\[Pi]", "6"], "+", "z"}], "]"}], " ", 
   RowBox[{"Sec", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{390, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49016638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15105],

Cell[BoxData[
 FractionBox["8", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "z"}], "]"}]}]}]]], "Output",
 ImageSize->{98, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187971124]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sec", "[", 
   RowBox[{"Conjugate", "[", "z", "]"}], "]"}], " ", "-", " ", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"Sec", "[", "z", "]"}], "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31630],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Conjugate", "[", 
    RowBox[{"Sec", "[", "z", "]"}], "]"}]}], "+", 
  RowBox[{"Sec", "[", 
   RowBox[{"Conjugate", "[", "z", "]"}], "]"}]}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48688655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21547],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76728306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27356],

Cell["Evaluate under additional assumptions:", "ExampleText",
 CellID->29408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"k", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1563],

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{
   RowBox[{"k", " ", "\[Pi]"}], "-", "x"}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118890139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"k", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13103],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "k"], " ", 
  RowBox[{"Sec", "[", "x", "]"}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60609677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13353],

Cell["Compositions with the inverse functions:", "ExampleText",
 CellID->31752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"ArcSec", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"Sec", "[", 
    RowBox[{"2", 
     RowBox[{"ArcSec", "[", "z", "]"}]}], "]"}], ",", " ", 
   RowBox[{"Sec", "[", 
    RowBox[{"3", 
     RowBox[{"ArcSec", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Sec", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcSec", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Sec", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcSec", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197528055]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", "[", "%", "]"}], "//", "Together"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["z", "2"], 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["z", "2"]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["z", "3"], 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["z", "2"]}]}]]}]}], "}"}]], "Output",
 ImageSize->{161, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230187472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->939],

Cell["Solve a trigonometric equation:", "ExampleText",
 CellID->10319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "2"], "-", 
     RowBox[{"Sec", "[", 
      RowBox[{"z", "+", 
       RowBox[{"Pi", "/", "4"}]}], "]"}]}], "\[Equal]", "1"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{493, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386382086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24261],

Cell["Solve for zeros and poles: ", "ExampleText",
 CellID->20336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sec", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1161],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206129606]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sec", "[", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}]}], "==", "0"}],
    ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32305],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["\[Pi]", "2"]}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{
          FractionBox["\[Pi]", "2"], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{
           RowBox[{"-", 
            FractionBox["\[Pi]", "2"]}], "-", "\[Beta]", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}], "||", 
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{
           FractionBox["\[Pi]", "2"], "-", "\[Beta]", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
     ")"}]}], ")"}]}]], "Output",
 ImageSize->{447, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->365117030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11617],

Cell["Numerically solve a transcendental equation:", "ExampleText",
 CellID->29865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Sec", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}], "+", "z"}], "\[Equal]", "4"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "2.004405210197624`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327909506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6633],

Cell["Integrals:", "ExampleText",
 CellID->19352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sec", "[", "z", "]"}], "^", "a"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5624],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], "2"], ")"}], 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox["a", "2"]}]], " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", 
    FractionBox[
     RowBox[{"1", "+", "a"}], "2"], ",", 
    FractionBox["3", "2"], ",", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"Sec", "[", "z", "]"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]], " ", 
  RowBox[{"Sin", "[", "z", "]"}]}]], "Output",
 ImageSize->{473, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120821704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4139],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " is automatically returned as a special case for many mathematical \
functions: "
}], "ExampleText",
 CellID->8152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", "z"}], "]"}]}], ",", 
   RowBox[{"1", "/", 
    RowBox[{"MathieuC", "[", 
     RowBox[{"1", ",", "0", ",", "z"}], "]"}]}], ",", 
   RowBox[{"JacobiDC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"1", "/", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       FractionBox["1", "2"], "}"}], ",", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["z", "2"], "4"]}]}], "]"}]}], ",", 
   RowBox[{"1", "/", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", 
      FractionBox[
       SuperscriptBox["z", "2"], "4"]}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    SqrtBox["z"], " ", 
    RowBox[{"Sec", "[", "z", "]"}]}], ",", 
   RowBox[{"Sec", "[", "z", "]"}], ",", 
   RowBox[{"Sec", "[", "z", "]"}], ",", 
   RowBox[{"Sec", "[", "z", "]"}], ",", 
   RowBox[{"Sec", "[", "z", "]"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox["\[Pi]"], " ", 
    SqrtBox[
     SuperscriptBox["z", "2"]], " ", 
    RowBox[{"Sec", "[", "z", "]"}]}]}], "}"}]], "Output",
 ImageSize->{465, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12079930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17425],

Cell["Calculate residue symbolically and numerically: ", "ExampleText",
 CellID->28156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Residue", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "k"], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["3", "8"]}], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["5", "16"]}], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["35", "128"]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{265, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266430140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "I"}]], 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Sec", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "-", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "-", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "+", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "+", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24792],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.999999999999998`"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39656490]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14631],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->13673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"10.", "^", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18114],

Cell[BoxData["1.5284255410262808`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27882781]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->19243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"10", "^", "30"}], "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->908],

Cell[BoxData[
 RowBox[{"-", 
  "1.004085428408569440276491617316360947528734306317`29.999999999999996"}]], \
"Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349387653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32261],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " is needed:"
}], "ExampleText",
 CellID->14072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14367],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Sec[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->279811716],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89356303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "1000"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->20284],

Cell[BoxData[
 RowBox[{"-", "1.07749110776980349733081982972427948021`20."}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264388203]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10265],

Cell["\<\
For arguments with imaginary part too large, the result cannot be represented \
by a computer:\
\>", "ExampleText",
 CellID->31038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"10000000000", "I"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32369],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->107303334],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->258864868],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->338695594],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(General :: \\\"ovfl\\\"\\) will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->3011103],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Sech[10000000000]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->274242181],

Cell[BoxData[
 RowBox[{"Underflow", "[", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123147039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26293],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->12267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28825],

Cell[BoxData["1.0151917795098913530583618959`12.954589770191015*^-434"], \
"Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242438842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14848],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->65134705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6850],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->10858],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"sec", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->32494],

Cell[BoxData[
 RowBox[{"sec", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144114239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"sec", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->725],

Cell[BoxData[
 RowBox[{"Sec", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->499473048]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12373],

Cell["Various integrals and products:", "ExampleText",
 CellID->31206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sec", "[", "x", "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"b", " ", "z"}], "]"}], " ", 
     RowBox[{"Sec", "[", 
      RowBox[{"c", " ", "z"}], "]"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], ",", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"b", " ", "z"}]], 
     RowBox[{"Sec", "[", 
      RowBox[{"a", " ", "z"}], "]"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Tan", "[", 
      FractionBox["x", "2"], "]"}], "]"}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["c", "2"]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], " ", "z"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"-", "b"}], "+", "c"}], 
           RowBox[{"2", " ", "c"}]], ",", "1", ",", 
          RowBox[{
           FractionBox["3", "2"], "-", 
           FractionBox["b", 
            RowBox[{"2", " ", "c"}]]}], ",", 
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "c", " ", "z"}]]}]}], 
         "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "b", " ", "z"}]], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"b", "+", "c"}], 
           RowBox[{"2", " ", "c"}]], ",", "1", ",", 
          FractionBox[
           RowBox[{"b", "+", 
            RowBox[{"3", " ", "c"}]}], 
           RowBox[{"2", " ", "c"}]], ",", 
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "c", " ", "z"}]]}]}], 
         "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], "3"]], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], "2"], " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"1", ",", 
          FractionBox[
           RowBox[{"a", "-", 
            RowBox[{"\[ImaginaryI]", " ", "b"}]}], 
           RowBox[{"2", " ", "a"}]], ",", 
          RowBox[{
           FractionBox["3", "2"], "-", 
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "b"}], 
            RowBox[{"2", " ", "a"}]]}], ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "a", " ", "z"}], "]"}]}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "a", " ", "z"}], "]"}]}]}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", 
          RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", "z", " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "a", " ", "z"}]]}]}], 
         "]"}]}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "a", " ", "z"}]]}]}], 
         "]"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", "z"}],
         "]"}], "+", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", "z"}],
         "]"}]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{573, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608053316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Product]", 
   RowBox[{"k", "=", "1"}], 
   RowBox[{"n", "-", "1"}]], " ", 
  RowBox[{"Sec", "[", 
   RowBox[{"z", "+", 
    FractionBox[
     RowBox[{"k", " ", "\[Pi]"}], "n"]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11467],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"-", "n"}]]}], " ", 
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", 
  RowBox[{"Cos", "[", "z", "]"}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"2", " ", "z"}]}], ")"}]}], "]"}]}]], "Output",
 ImageSize->{241, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133767717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9782],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->32594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Sec", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{155, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{155., Automatic}},
 CellLabel->"Out[1]=",
 CellID->92025673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sec", "[", 
   FractionBox["\[Pi]", 
    SuperscriptBox["2", "12"]], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25222],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox[
   RowBox[{"2", "+", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]]], "Output",
 ImageSize->{411, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170144693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25817],

Cell[TextData[{
 "Generate the ",
 Cell[BoxData[
  ButtonBox["Sec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sec"]], "InlineFormula"],
 " function from integrals and sums:"
}], "ExampleText",
 CellID->20509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "k"}], "+", "1"}], ")"}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"k", "+", 
          FractionBox["1", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["\[Pi]", "2"]}], "-", 
      SuperscriptBox["z", "2"]}]]}]}], " ", "//", " ", "Simplify"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->3045],

Cell[BoxData[
 RowBox[{"Sec", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150903869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["2", "\[Pi]"], " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    FractionBox[
     SuperscriptBox["t", 
      FractionBox[
       RowBox[{"2", " ", "z"}], "\[Pi]"]], 
     RowBox[{
      SuperscriptBox["t", "2"], "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Pi]", "+", 
        RowBox[{"2", " ", 
         RowBox[{"Re", "[", "z", "]"}]}]}], ">", "0"}], "&&", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"Re", "[", "z", "]"}]}], "<", "\[Pi]"}]}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25257],

Cell[BoxData[
 RowBox[{"Sec", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->623858073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "1", "]"}], ",", " ", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28598],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271856485]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14240],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Csc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Csc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29305]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18228],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->4019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31959],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Secant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Sec/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Sec"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->191485920],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->789870220]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 20.0086250}", "context" -> "System`", 
    "keywords" -> {"sec", "secant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sec[z] gives the secant of z. ", "synonyms" -> {}, "title" -> "Sec", 
    "type" -> "Symbol", "uri" -> "ref/Sec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6033, 213, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57883915]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 105560, 3463}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2257, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2880, 80, 41, 1, 70, "ObjectName",
 CellID->26206],
Cell[2924, 83, 528, 18, 70, "Usage",
 CellID->14504]
}, Open  ]],
Cell[CellGroupData[{
Cell[3489, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3967, 123, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4090, 129, 367, 13, 70, "Notes",
 CellID->8342],
Cell[4460, 144, 227, 9, 70, "Notes",
 CellID->1783],
Cell[4690, 155, 665, 25, 70, "Notes",
 CellID->14201],
Cell[5358, 182, 233, 8, 70, "Notes",
 CellID->9487],
Cell[5594, 192, 208, 7, 70, "Notes",
 CellID->31226],
Cell[5805, 201, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6033, 213, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57883915],
Cell[CellGroupData[{
Cell[6417, 227, 147, 5, 70, "ExampleSection",
 CellID->88733799],
Cell[6567, 234, 72, 1, 70, "ExampleText",
 CellID->27007],
Cell[CellGroupData[{
Cell[6664, 239, 119, 4, 28, "Input",
 CellID->24348],
Cell[6786, 245, 189, 7, 55, "Output",
 CellID->82022310]
}, Open  ]],
Cell[6990, 255, 120, 3, 70, "ExampleDelimiter",
 CellID->3478],
Cell[7113, 260, 212, 8, 70, "ExampleText",
 CellID->4876],
Cell[CellGroupData[{
Cell[7350, 272, 119, 4, 70, "Input",
 CellID->15116],
Cell[7472, 278, 188, 7, 55, "Output",
 CellID->5486948]
}, Open  ]],
Cell[7675, 288, 121, 3, 70, "ExampleDelimiter",
 CellID->31037],
Cell[7799, 293, 59, 1, 70, "ExampleText",
 CellID->5918],
Cell[CellGroupData[{
Cell[7883, 298, 97, 3, 70, "Input",
 CellID->15102],
Cell[7983, 303, 175, 5, 36, "Output",
 CellID->164859955]
}, Open  ]],
Cell[8173, 311, 120, 3, 70, "ExampleDelimiter",
 CellID->5500],
Cell[CellGroupData[{
Cell[8318, 318, 231, 8, 28, "Input",
 CellID->13489],
Cell[8552, 328, 2465, 45, 112, "Output",
 Evaluatable->False,
 CellID->158923446]
}, Open  ]],
Cell[11032, 376, 121, 3, 70, "ExampleDelimiter",
 CellID->32335],
Cell[CellGroupData[{
Cell[11178, 383, 212, 7, 70, "Input",
 CellID->26395],
Cell[11393, 392, 974, 33, 54, "Output",
 CellID->282601564]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12416, 431, 217, 7, 70, "ExampleSection",
 CellID->30312],
Cell[12636, 440, 70, 1, 70, "ExampleText",
 CellID->31098],
Cell[CellGroupData[{
Cell[12731, 445, 120, 4, 70, "Input",
 CellID->16376],
Cell[12854, 451, 268, 8, 36, "Output",
 CellID->44707881]
}, Open  ]],
Cell[13137, 462, 125, 3, 70, "ExampleDelimiter",
 CellID->574606882],
Cell[13265, 467, 66, 1, 70, "ExampleText",
 CellID->20853],
Cell[CellGroupData[{
Cell[13356, 472, 175, 6, 70, "Input",
 CellID->25473],
Cell[13534, 480, 234, 7, 36, "Output",
 CellID->84121164]
}, Open  ]],
Cell[13783, 490, 125, 3, 70, "ExampleDelimiter",
 CellID->177039722],
Cell[13911, 495, 109, 3, 70, "ExampleText",
 CellID->10832],
Cell[CellGroupData[{
Cell[14045, 502, 119, 3, 70, "Input",
 CellID->14543],
Cell[14167, 507, 218, 6, 36, "Output",
 CellID->494483461]
}, Open  ]],
Cell[14400, 516, 139, 4, 70, "ExampleText",
 CellID->32662],
Cell[CellGroupData[{
Cell[14564, 524, 136, 4, 70, "Input",
 CellID->21708],
Cell[14703, 530, 197, 5, 36, "Output",
 CellID->119594859]
}, Open  ]],
Cell[CellGroupData[{
Cell[14937, 540, 159, 5, 70, "Input",
 CellID->10696],
Cell[15099, 547, 267, 8, 36, "Output",
 CellID->465217637]
}, Open  ]],
Cell[15381, 558, 121, 3, 70, "ExampleDelimiter",
 CellID->28552],
Cell[15505, 563, 209, 7, 70, "ExampleText",
 CellID->28113],
Cell[CellGroupData[{
Cell[15739, 574, 158, 5, 70, "Input",
 CellID->25081],
Cell[15900, 581, 284, 8, 36, "Output",
 CellID->5757969]
}, Open  ]],
Cell[CellGroupData[{
Cell[16221, 594, 597, 18, 70, "Input",
 CellID->16054],
Cell[16821, 614, 383, 14, 43, "Output",
 CellID->335045069]
}, Open  ]],
Cell[17219, 631, 121, 3, 70, "ExampleDelimiter",
 CellID->21942],
Cell[17343, 636, 87, 1, 70, "ExampleText",
 CellID->24314],
Cell[CellGroupData[{
Cell[17455, 641, 117, 4, 70, "Input",
 CellID->128],
Cell[17575, 647, 210, 8, 38, "Output",
 CellID->869592014]
}, Open  ]],
Cell[17800, 658, 238, 8, 70, "ExampleText",
 CellID->10223],
Cell[CellGroupData[{
Cell[18063, 670, 120, 4, 70, "Input",
 CellID->11271],
Cell[18186, 676, 212, 7, 49, "Output",
 CellID->16668474]
}, Open  ]],
Cell[CellGroupData[{
Cell[18435, 688, 106, 3, 70, "Input",
 CellID->31032],
Cell[18544, 693, 525, 21, 77, "Output",
 CellID->285580522]
}, Open  ]],
Cell[19084, 717, 120, 3, 70, "ExampleDelimiter",
 CellID->7460],
Cell[19207, 722, 90, 3, 70, "ExampleText",
 CellID->31129],
Cell[CellGroupData[{
Cell[19322, 729, 151, 5, 70, "Input",
 CellID->12185],
Cell[19476, 736, 478, 16, 54, "Output",
 CellID->210631427]
}, Open  ]],
Cell[CellGroupData[{
Cell[19991, 757, 102, 3, 70, "Input",
 CellID->23214],
Cell[20096, 762, 210, 7, 36, "Output",
 CellID->472926995]
}, Open  ]],
Cell[20321, 772, 121, 3, 70, "ExampleDelimiter",
 CellID->11170],
Cell[20445, 777, 91, 1, 70, "ExampleText",
 CellID->23525],
Cell[CellGroupData[{
Cell[20561, 782, 187, 6, 70, "Input",
 CellID->24521],
Cell[20751, 790, 867, 31, 51, "Output",
 CellID->61448237]
}, Open  ]],
Cell[21633, 824, 121, 3, 70, "ExampleDelimiter",
 CellID->13765],
Cell[21757, 829, 70, 1, 70, "ExampleText",
 CellID->30872],
Cell[CellGroupData[{
Cell[21852, 834, 184, 6, 70, "Input",
 CellID->19866],
Cell[22039, 842, 725, 24, 53, "Output",
 CellID->157166904]
}, Open  ]],
Cell[22779, 869, 121, 3, 70, "ExampleDelimiter",
 CellID->13925],
Cell[CellGroupData[{
Cell[22925, 876, 131, 4, 70, "Input",
 CellID->13231],
Cell[23059, 882, 373, 12, 53, "Output",
 CellID->88022926]
}, Open  ]],
Cell[23447, 897, 124, 3, 70, "ExampleDelimiter",
 CellID->70607291],
Cell[23574, 902, 202, 7, 70, "ExampleText",
 CellID->67006696],
Cell[CellGroupData[{
Cell[23801, 913, 136, 4, 70, "Input",
 CellID->23169288],
Cell[23940, 919, 233, 7, 50, "Output",
 CellID->200715297]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24222, 932, 237, 7, 70, "ExampleSection",
 CellID->475],
Cell[24462, 941, 207, 7, 70, "ExampleText",
 CellID->1255],
Cell[CellGroupData[{
Cell[24694, 952, 206, 7, 70, "Input",
 CellID->27332],
Cell[24903, 961, 239, 8, 36, "Output",
 CellID->41919336]
}, Open  ]],
Cell[25157, 972, 121, 3, 70, "ExampleDelimiter",
 CellID->31102],
Cell[25281, 977, 80, 1, 70, "ExampleText",
 CellID->11533],
Cell[CellGroupData[{
Cell[25386, 982, 101, 3, 70, "Input",
 CellID->3948],
Cell[25490, 987, 375, 13, 36, "Output",
 CellID->82127589]
}, Open  ]],
Cell[CellGroupData[{
Cell[25902, 1005, 108, 3, 70, "Input",
 CellID->9158],
Cell[26013, 1010, 169, 5, 36, "Output",
 CellID->64961714]
}, Open  ]],
Cell[26197, 1018, 121, 3, 70, "ExampleDelimiter",
 CellID->26740],
Cell[26321, 1023, 193, 8, 70, "ExampleText",
 CellID->15589],
Cell[CellGroupData[{
Cell[26539, 1035, 325, 11, 70, "Input",
 CellID->18069],
Cell[26867, 1048, 572, 20, 51, "Output",
 CellID->230865025]
}, Open  ]],
Cell[27454, 1071, 121, 3, 70, "ExampleDelimiter",
 CellID->30826],
Cell[27578, 1076, 223, 7, 70, "ExampleText",
 CellID->18647],
Cell[CellGroupData[{
Cell[27826, 1087, 579, 20, 70, "Input",
 CellID->29573],
Cell[28408, 1109, 479, 17, 36, "Output",
 CellID->241250208]
}, Open  ]],
Cell[CellGroupData[{
Cell[28924, 1131, 95, 3, 70, "Input",
 CellID->11615],
Cell[29022, 1136, 488, 17, 36, "Output",
 CellID->21769748]
}, Open  ]],
Cell[CellGroupData[{
Cell[29547, 1158, 143, 5, 70, "Input",
 CellID->21966],
Cell[29693, 1165, 851, 27, 98, "Output",
 CellID->64454836]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30593, 1198, 223, 7, 70, "ExampleSection",
 CellID->31576],
Cell[30819, 1207, 73, 1, 70, "ExampleText",
 CellID->5995],
Cell[CellGroupData[{
Cell[30917, 1212, 344, 11, 70, "Input",
 CellID->2398],
Cell[31264, 1225, 2363, 43, 70, "Output",
 Evaluatable->False,
 CellID->27099377]
}, Open  ]],
Cell[33642, 1271, 121, 3, 70, "ExampleDelimiter",
 CellID->24086],
Cell[33766, 1276, 86, 1, 70, "ExampleText",
 CellID->8568],
Cell[CellGroupData[{
Cell[33877, 1281, 406, 14, 70, "Input",
 CellID->5025],
Cell[34286, 1297, 20334, 337, 70, "Output",
 Evaluatable->False,
 CellID->170256566]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54669, 1640, 234, 7, 70, "ExampleSection",
 CellID->15809],
Cell[54906, 1649, 138, 4, 70, "ExampleText",
 CellID->15327],
Cell[CellGroupData[{
Cell[55069, 1657, 137, 5, 70, "Input",
 CellID->7030],
Cell[55209, 1664, 205, 7, 36, "Output",
 CellID->576180309]
}, Open  ]],
Cell[CellGroupData[{
Cell[55451, 1676, 113, 4, 70, "Input",
 CellID->31384],
Cell[55567, 1682, 187, 6, 36, "Output",
 CellID->285813766]
}, Open  ]],
Cell[CellGroupData[{
Cell[55791, 1693, 117, 4, 70, "Input",
 CellID->1326],
Cell[55911, 1699, 188, 6, 36, "Output",
 CellID->711363821]
}, Open  ]],
Cell[CellGroupData[{
Cell[56136, 1710, 118, 4, 70, "Input",
 CellID->11923],
Cell[56257, 1716, 187, 6, 36, "Output",
 CellID->543861518]
}, Open  ]],
Cell[56459, 1725, 121, 3, 70, "ExampleDelimiter",
 CellID->26278],
Cell[56583, 1730, 559, 23, 70, "ExampleText",
 CellID->18631],
Cell[CellGroupData[{
Cell[57167, 1757, 118, 4, 70, "Input",
 CellID->11161],
Cell[57288, 1763, 185, 6, 36, "Output",
 CellID->7397754]
}, Open  ]],
Cell[CellGroupData[{
Cell[57510, 1774, 135, 4, 70, "Input",
 CellID->5915],
Cell[57648, 1780, 356, 13, 36, "Output",
 CellID->192306278]
}, Open  ]],
Cell[58019, 1796, 121, 3, 70, "ExampleDelimiter",
 CellID->10739],
Cell[58143, 1801, 128, 4, 70, "ExampleText",
 CellID->10610],
Cell[CellGroupData[{
Cell[58296, 1809, 573, 20, 70, "Input",
 CellID->28992],
Cell[58872, 1831, 657, 23, 49, "Output",
 CellID->49016638]
}, Open  ]],
Cell[CellGroupData[{
Cell[59566, 1859, 100, 3, 70, "Input",
 CellID->15105],
Cell[59669, 1864, 302, 11, 53, "Output",
 CellID->187971124]
}, Open  ]],
Cell[CellGroupData[{
Cell[60008, 1880, 237, 7, 70, "Input",
 CellID->31630],
Cell[60248, 1889, 334, 11, 36, "Output",
 CellID->48688655]
}, Open  ]],
Cell[CellGroupData[{
Cell[60619, 1905, 104, 3, 70, "Input",
 CellID->21547],
Cell[60726, 1910, 157, 5, 36, "Output",
 CellID->76728306]
}, Open  ]],
Cell[60898, 1918, 121, 3, 70, "ExampleDelimiter",
 CellID->27356],
Cell[61022, 1923, 77, 1, 70, "ExampleText",
 CellID->29408],
Cell[CellGroupData[{
Cell[61124, 1928, 161, 6, 70, "Input",
 CellID->1563],
Cell[61288, 1936, 238, 8, 36, "Output",
 CellID->118890139]
}, Open  ]],
Cell[CellGroupData[{
Cell[61563, 1949, 161, 5, 70, "Input",
 CellID->13103],
Cell[61727, 1956, 277, 10, 36, "Output",
 CellID->60609677]
}, Open  ]],
Cell[62019, 1969, 121, 3, 70, "ExampleDelimiter",
 CellID->13353],
Cell[62143, 1974, 79, 1, 70, "ExampleText",
 CellID->31752],
Cell[CellGroupData[{
Cell[62247, 1979, 370, 12, 70, "Input",
 CellID->6867],
Cell[62620, 1993, 398, 13, 36, "Output",
 CellID->197528055]
}, Open  ]],
Cell[CellGroupData[{
Cell[63055, 2011, 137, 4, 70, "Input",
 CellID->24599],
Cell[63195, 2017, 532, 20, 56, "Output",
 CellID->230187472]
}, Open  ]],
Cell[63742, 2040, 119, 3, 70, "ExampleDelimiter",
 CellID->939],
Cell[63864, 2045, 70, 1, 70, "ExampleText",
 CellID->10319],
Cell[CellGroupData[{
Cell[63959, 2050, 330, 12, 70, "Input",
 CellID->24063],
Cell[64292, 2064, 4019, 70, 70, "Output",
 Evaluatable->False,
 CellID->386382086]
}, Open  ]],
Cell[68326, 2137, 121, 3, 70, "ExampleDelimiter",
 CellID->24261],
Cell[68450, 2142, 66, 1, 70, "ExampleText",
 CellID->20336],
Cell[CellGroupData[{
Cell[68541, 2147, 247, 9, 70, "Input",
 CellID->1161],
Cell[68791, 2158, 162, 5, 36, "Output",
 CellID->206129606]
}, Open  ]],
Cell[CellGroupData[{
Cell[68990, 2168, 276, 10, 70, "Input",
 CellID->32305],
Cell[69269, 2180, 1506, 45, 103, "Output",
 CellID->365117030]
}, Open  ]],
Cell[70790, 2228, 121, 3, 70, "ExampleDelimiter",
 CellID->11617],
Cell[70914, 2233, 83, 1, 70, "ExampleText",
 CellID->29865],
Cell[CellGroupData[{
Cell[71022, 2238, 421, 15, 70, "Input",
 CellID->14612],
Cell[71446, 2255, 226, 7, 36, "Output",
 CellID->327909506]
}, Open  ]],
Cell[71687, 2265, 120, 3, 70, "ExampleDelimiter",
 CellID->6633],
Cell[71810, 2270, 49, 1, 70, "ExampleText",
 CellID->19352],
Cell[CellGroupData[{
Cell[71884, 2275, 179, 6, 70, "Input",
 CellID->5624],
Cell[72066, 2283, 770, 27, 52, "Output",
 CellID->120821704]
}, Open  ]],
Cell[72851, 2313, 120, 3, 70, "ExampleDelimiter",
 CellID->4139],
Cell[72974, 2318, 242, 8, 70, "ExampleText",
 CellID->8152],
Cell[CellGroupData[{
Cell[73241, 2330, 1183, 40, 70, "Input",
 CellID->28518],
Cell[74427, 2372, 647, 22, 60, "Output",
 CellID->12079930]
}, Open  ]],
Cell[75089, 2397, 121, 3, 70, "ExampleDelimiter",
 CellID->17425],
Cell[75213, 2402, 87, 1, 70, "ExampleText",
 CellID->28156],
Cell[CellGroupData[{
Cell[75325, 2407, 374, 13, 70, "Input",
 CellID->18103],
Cell[75702, 2422, 475, 16, 51, "Output",
 CellID->266430140]
}, Open  ]],
Cell[CellGroupData[{
Cell[76214, 2443, 736, 25, 70, "Input",
 CellID->24792],
Cell[76953, 2470, 251, 8, 36, "Output",
 CellID->39656490]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77253, 2484, 226, 7, 70, "ExampleSection",
 CellID->14631],
Cell[77482, 2493, 112, 3, 70, "ExampleText",
 CellID->13673],
Cell[CellGroupData[{
Cell[77619, 2500, 121, 4, 70, "Input",
 CellID->18114],
Cell[77743, 2506, 175, 5, 36, "Output",
 CellID->27882781]
}, Open  ]],
Cell[77933, 2514, 79, 1, 70, "ExampleText",
 CellID->19243],
Cell[CellGroupData[{
Cell[78037, 2519, 173, 6, 70, "Input",
 CellID->908],
Cell[78213, 2527, 249, 8, 36, "Output",
 CellID->349387653]
}, Open  ]],
Cell[78477, 2538, 121, 3, 70, "ExampleDelimiter",
 CellID->32261],
Cell[78601, 2543, 230, 8, 70, "ExampleText",
 CellID->14072],
Cell[CellGroupData[{
Cell[78856, 2555, 176, 6, 70, "Input",
 CellID->14367],
Cell[79035, 2563, 527, 11, 70, "Message",
 CellID->279811716],
Cell[79565, 2576, 172, 5, 36, "Output",
 CellID->89356303]
}, Open  ]],
Cell[CellGroupData[{
Cell[79774, 2586, 309, 11, 70, "Input",
 CellID->20284],
Cell[80086, 2599, 219, 6, 36, "Output",
 CellID->264388203]
}, Open  ]],
Cell[80320, 2608, 121, 3, 70, "ExampleDelimiter",
 CellID->10265],
Cell[80444, 2613, 141, 4, 70, "ExampleText",
 CellID->31038],
Cell[CellGroupData[{
Cell[80610, 2621, 178, 6, 70, "Input",
 CellID->32369],
Cell[80791, 2629, 357, 7, 70, "Message",
 CellID->107303334],
Cell[81151, 2638, 357, 7, 70, "Message",
 CellID->258864868],
Cell[81511, 2647, 357, 7, 70, "Message",
 CellID->338695594],
Cell[81871, 2656, 418, 8, 70, "Message",
 CellID->3011103],
Cell[82292, 2666, 432, 8, 70, "Message",
 CellID->274242181],
Cell[82727, 2676, 188, 6, 36, "Output",
 CellID->123147039]
}, Open  ]],
Cell[82930, 2685, 121, 3, 70, "ExampleDelimiter",
 CellID->26293],
Cell[83054, 2690, 109, 3, 70, "ExampleText",
 CellID->12267],
Cell[CellGroupData[{
Cell[83188, 2697, 139, 5, 70, "Input",
 CellID->28825],
Cell[83330, 2704, 215, 6, 36, "Output",
 CellID->242438842]
}, Open  ]],
Cell[CellGroupData[{
Cell[83582, 2715, 106, 3, 70, "Input",
 CellID->14848],
Cell[83691, 2720, 161, 5, 36, "Output",
 CellID->65134705]
}, Open  ]],
Cell[83867, 2728, 120, 3, 70, "ExampleDelimiter",
 CellID->6850],
Cell[83990, 2733, 110, 3, 70, "ExampleText",
 CellID->10858],
Cell[CellGroupData[{
Cell[84125, 2740, 119, 4, 70, "Input",
 CellID->32494],
Cell[84247, 2746, 182, 6, 36, "Output",
 CellID->144114239]
}, Open  ]],
Cell[CellGroupData[{
Cell[84466, 2757, 122, 4, 70, "Input",
 CellID->725],
Cell[84591, 2763, 187, 6, 36, "Output",
 CellID->499473048]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84827, 2775, 224, 7, 70, "ExampleSection",
 CellID->12373],
Cell[85054, 2784, 70, 1, 70, "ExampleText",
 CellID->31206],
Cell[CellGroupData[{
Cell[85149, 2789, 686, 22, 70, "Input",
 CellID->28528],
Cell[85838, 2813, 6336, 183, 237, "Output",
 CellID->608053316]
}, Open  ]],
Cell[92189, 2999, 120, 3, 70, "ExampleDelimiter",
 CellID->9299],
Cell[CellGroupData[{
Cell[92334, 3006, 285, 10, 70, "Input",
 CellID->11467],
Cell[92622, 3018, 577, 21, 51, "Output",
 CellID->133767717]
}, Open  ]],
Cell[93214, 3042, 120, 3, 70, "ExampleDelimiter",
 CellID->9782],
Cell[93337, 3047, 192, 8, 70, "ExampleText",
 CellID->32594],
Cell[CellGroupData[{
Cell[93554, 3059, 467, 15, 70, "Input",
 CellID->20245],
Cell[94024, 3076, 2822, 50, 70, "Output",
 Evaluatable->False,
 CellID->92025673]
}, Open  ]],
Cell[96861, 3129, 120, 3, 70, "ExampleDelimiter",
 CellID->5618],
Cell[CellGroupData[{
Cell[97006, 3136, 185, 6, 70, "Input",
 CellID->25222],
Cell[97194, 3144, 748, 27, 108, "Output",
 CellID->170144693]
}, Open  ]],
Cell[97957, 3174, 121, 3, 70, "ExampleDelimiter",
 CellID->25817],
Cell[98081, 3179, 215, 8, 70, "ExampleText",
 CellID->20509],
Cell[CellGroupData[{
Cell[98321, 3191, 673, 24, 70, "Input",
 CellID->3045],
Cell[98997, 3217, 187, 6, 36, "Output",
 CellID->150903869]
}, Open  ]],
Cell[CellGroupData[{
Cell[99221, 3228, 705, 24, 70, "Input",
 CellID->25257],
Cell[99929, 3254, 187, 6, 36, "Output",
 CellID->623858073]
}, Open  ]],
Cell[100131, 3263, 120, 3, 70, "ExampleDelimiter",
 CellID->6766],
Cell[CellGroupData[{
Cell[100276, 3270, 167, 5, 70, "Input",
 CellID->28598],
Cell[100446, 3277, 162, 5, 36, "Output",
 CellID->271856485]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[100669, 3289, 311, 9, 70, "SeeAlsoSection",
 CellID->14240],
Cell[100983, 3300, 1409, 53, 70, "SeeAlso",
 CellID->29305]
}, Open  ]],
Cell[CellGroupData[{
Cell[102429, 3358, 314, 9, 70, "TutorialsSection",
 CellID->18228],
Cell[102746, 3369, 181, 4, 70, "Tutorials",
 CellID->4019]
}, Open  ]],
Cell[CellGroupData[{
Cell[102964, 3378, 321, 9, 70, "RelatedLinksSection",
 CellID->31959],
Cell[103288, 3389, 177, 4, 70, "RelatedLinks"],
Cell[103468, 3395, 195, 4, 70, "RelatedLinks"],
Cell[103666, 3401, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104084, 3419, 319, 9, 70, "MoreAboutSection",
 CellID->191485920],
Cell[104406, 3430, 157, 3, 70, "MoreAbout",
 CellID->789870220]
}, Open  ]],
Cell[104578, 3436, 27, 0, 70, "History"],
Cell[104608, 3438, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

