(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41836,       1342]
NotebookOptionsPosition[     35308,       1118]
NotebookOutlinePosition[     36851,       1159]
CellTagsIndexPosition[     36765,       1154]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pseudorandom Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/PseudorandomNumbers"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Pseudorandom Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BlockRandom" :> 
          Documentation`HelpLookup["paclet:ref/BlockRandom"], "RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "RandomComplex" :> 
          Documentation`HelpLookup["paclet:ref/RandomComplex"], 
          "RandomChoice" :> 
          Documentation`HelpLookup["paclet:ref/RandomChoice"], "RandomSample" :> 
          Documentation`HelpLookup["paclet:ref/RandomSample"], "RandomPrime" :> 
          Documentation`HelpLookup["paclet:ref/RandomPrime"], "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BlockRandom\"\>", 2->"\<\"RandomInteger\"\>", 
       3->"\<\"RandomReal\"\>", 4->"\<\"RandomComplex\"\>", 
       5->"\<\"RandomChoice\"\>", 6->"\<\"RandomSample\"\>", 
       7->"\<\"RandomPrime\"\>", 8->"\<\"AbsoluteTime\"\>", 
       9->"\<\"Hash\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Random Number Generation" :> 
          Documentation`HelpLookup["paclet:guide/RandomNumberGeneration"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Random Number Generation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SeedRandom", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SeedRandom",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SeedRandom"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]resets the pseudorandom generator, using ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " as a seed. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SeedRandom",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SeedRandom"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]resets the generator, using as a seed the time of day \
and certain attributes of the current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellLabel->"",
 CellID->20244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " to make sure you get the same sequence of pseudorandom numbers on \
different occasions. "
}], "Notes",
 CellID->7598],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " affects ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomPrime"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15005],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"], "[", 
   RowBox[{
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], "->", "\"\<\!\(\*
StyleBox[\"method\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " specifies what method should be used for the pseudorandom generator. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24137],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], "->", "\"\<\!\(\*
StyleBox[\"method\", \"TI\"]\)\>\""}]}], "]"}]], "InlineFormula"],
 " resets the generator, specifying both a seed and the method to use. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1484],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " affects only the current generator; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", " ", 
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "]"}]], "InlineFormula"],
 " affects all generators. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4569],

Cell["Typical possible methods include:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30563],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Congruential\>\"", Cell[
    "linear congruential generator (low-quality randomness)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<ExtendedCA\>\"", Cell[
    "extended cellular automaton generator (default)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Legacy\>\"", Cell[TextData[{
     "default generators from before ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " 6.0"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<MersenneTwister\>\"", Cell[
    "Mersenne twister shift register generator", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<MKL\>\"", Cell[
    "Intel MKL generator (Intel-based systems)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Rule30CA\>\"", Cell[
    "Wolfram Rule 30 generator", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->13671],

Cell["\<\
Different methods may give sequences with different levels of randomness. \
\>", "Notes",
 CellID->19554]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46565636],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->608918267],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " to make random numbers repeatable:"
}], "ExampleText",
 CellID->158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30052],

Cell[BoxData["0.918945520383758`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20002]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13545],

Cell[BoxData["0.918945520383758`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11009]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28290],

Cell["The seed can be a string:", "ExampleText",
 CellID->11340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "\"\<password\>\"", "]"}], ";", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8588],

Cell[BoxData["0.4253200140613671`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26288],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " affects all random generators:"
}], "ExampleText",
 CellID->8885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "4567", "]"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RandomInteger", "[", "10", "]"}], ",", 
    RowBox[{"RandomReal", "[", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "0.3527238634765961`"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3863]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "4567", "]"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RandomReal", "[", "]"}], ",", 
    RowBox[{"RandomInteger", "[", "10", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.33454524146728715`", ",", "8"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5181]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->759621460],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->107507861],

Cell["Switch to the Mersenne twister generator:", "ExampleText",
 CellID->164354472],

Cell[BoxData[
 RowBox[{"SeedRandom", "[", 
  RowBox[{"Method", "\[Rule]", "\"\<MersenneTwister\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207915769],

Cell["Random numbers are now generated using it:", "ExampleText",
 CellID->20260502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"1", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490655889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.19230368384953245`", ",", "0.30694976197195945`", ",", 
   "0.029563801113261734`", ",", "0.3588806428400828`", ",", 
   "0.03406932676944163`"}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->585490342]
}, Open  ]],

Cell["\<\
A specific seed will affect the current, Mersenne twister, generator:\
\>", "ExampleText",
 CellID->588078918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "4321", "]"}], ";", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->98681085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4488966345061003`", ",", "0.19981560556462896`", ",", 
   "0.9074405804438601`", ",", "0.27785104238843394`", ",", 
   "0.3480823534958437`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->188554506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83270609],

Cell["Give a seed to all initialized generators:", "ExampleText",
 CellID->359336346],

Cell[BoxData[
 RowBox[{"SeedRandom", "[", 
  RowBox[{"\"\<Seed all generators\>\"", ",", " ", 
   RowBox[{"Method", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108987002]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->60836973],

Cell["Reproduce a part of a computation that uses randomness:", "ExampleText",
 CellID->243084941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", " ", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"100", ",", " ", "100"}], "}"}]}], "]"}], ",", " ", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200261829],

Cell[BoxData[
 RowBox[{"{", "50.08462180274849`", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56621297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", " ", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"100", ",", " ", "100"}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174899128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1490169779910848`", "\[InvisibleSpace]", "-", 
   RowBox[{"0.11966579974129093`", " ", "\[ImaginaryI]"}]}], "}"}]], "Output",\

 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125092044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{
   RowBox[{"Eigenvalues", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"100", ",", " ", "100"}], "}"}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->590673250],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"50.08462180274849`", ",", 
   RowBox[{"0.1490169779910848`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.11966579974129093`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->89464215]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44473842],

Cell["\<\
Write a function that uses randomness, but returns predictable results:\
\>", "ExampleText",
 CellID->269027597],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "rplot", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", " ", 
     RowBox[{"RandomSeed", "\[Rule]", "1234"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451558077],

Cell[BoxData[
 RowBox[{
  RowBox[{"rplot", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", " ", "xmin_", ",", " ", "xmax_"}], "}"}], ",", " ", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", " ", "=", " ", 
       RowBox[{"OptionValue", "[", "PlotPoints", "]"}]}], ",", " ", 
      RowBox[{"s", " ", "=", " ", 
       RowBox[{"OptionValue", "[", "RandomSeed", "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BlockRandom", "[", 
     RowBox[{
      RowBox[{"SeedRandom", "[", "s", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", " ", "f"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"RandomReal", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"xmin", ",", " ", "xmax"}], "}"}], ",", " ", "n"}], 
            "]"}]}], "}"}]}], "]"}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1032931923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p100", " ", "=", " ", 
  RowBox[{"rplot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"10", "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->188752049],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWd9PXEUUvr13l4UqSFkoFKRirNFWoyZV1CIsC0Jpawtp0jSlqNk0m7RR
KaE0En3xocRq1Ccf6vZHEKvG+Fisr0180Qfjq8/+I9f5defM/e7ZWba0Spbd
e+6c853vnDkz987M8crK+eoHlZUL5ypDh5crS+cvnLs0NH1xWdyKdgRBsCn+
3+sLxHUsrtT/ZhyLX/e7IL4j0RRKSV7E6i8IxeV3SqMVWiL5lSM5CPKgUdO3
I/0j/8JEbAqnqDS+v/1XafQb8fnyi98GlMbllbtCfPftn4MRJWsN0Rw8DnJr
ExFIhS4p5jW+/pRL14P+NA/x0X5Pn/pBXE9N3jB+SW7Gr6uh/U+MX7eeJsvG
f4tGL43VTp28rcMfgGi1/Mfv/1xcvPPr3b8NK5K3x2rj2z+PHV2/fGnToOms
WHRBOhQ8FIec4apovWnrTFZBi/Pr+tgFsQwpeWX5FyG/s/CTjk16m5q8WRq9
JpKscXsNXhf0wBDbQ1c/vSfkpcU7AVlnWZAWZjhkM0xehll9kls8XgllgOVe
n8Uw6Icg+7wSCl89hDIC7ciC93ICtI6kem0WIjviwSAmZbDKs1adoPUUyD3A
rAxefKiklQNUzNoZ8OJDJa0cWwHUXkllsQ+q9hPWRy9gLgHzdo8VeV4CFN7q
VcCe42rFac95UDCXkHubhdfAB2ae99EBTD6L3dnKfWYlzzGcuTqAlUZQWqlZ
tQB2+DzsgF7UOPgUNQVEsCyuFB8sL8pjPZx8zM/seyDDOC6rIEcefBcX5T0Q
L47UKshRqqeTXx6VoseRWoVei1I1idV1RclvHV1XbxY1R9v12Q5MtdXM9C0h
jzewImbaau7EhnmL4K2+BisfNsWxBnLIRE3810AOt8R/DWTeqmiqvTum91jJ
YZeRzbA3f/JuztHqNHJWKzJDL6mNrOfdIHdlKhbfqR8DGUfaI/KrzWY1Tga6
M/+ARYcj2zAyz/j69ukZFCN8QBFhz28LcesR/Qd9hePGw6sTZM5fmNilmPHv
Vd1Gv2drkZCGsetulq+4LDb0xWe/m5Mbc867nCVH1Wstrh1v3d4Qv9ggej6O
HpO7ovkNIhqoyZwTmlHoyhHISfujypU73vlZR0rPx+mRhO9CnSzj55RMTyd8
J/JZEfb7Hi3C4rU+VDKs61QFrKu5dnfSLq7t098zTlg5Uyk4D24J5WHLhqXO
6//GsuDmSvSeEO389XDyaPpYxC0aZD29CFptcbpG1LhwKqsI+i+AXHC8UES4
R3MAvLwUc/V6CHwfABSy0jOAHrfyZhUsAd/Y19J3je4McJtlue0HLVxrzqa4
DYL2TtDGNeVshi/nYydYLbJRIvbHbNTzwHCUjXoeGIymojwLnngM3CdcYLWe
BS1cQfiscN1BjND3Xg8KVE9mb4+8EIrMwgK04l4O7xNz94bSao3rr31xdXQF
WKqRqsejd42J8wTOAKsQTzO4UmwD+1WIdHs8CeerOjjJWhjz9RHEOeixz7yP
ZHAovsFUzyVrWd6K2A+mamgMuM2zNfMM1+MOE8eK3tSs+j6lTevfIjBirS24
tk5WtDW9F4XaFmwfYB8C5gdT0Q9B6wTERdpuNp4ArQnweZBjaJ3gnvSqN3qc
iXEX9GVvNtAX7naSNWUD935hj8aJ0/GdyQ6ukQjlFfCC+9wDLOrTYKVQ5MnA
mdM/luiUKHUG0U9Iqfef+idH7B57wXpN2fYmDOzZBPmzazrPaZHKbsH2jdvp
Zm+XeNSLpP6pz0iGObWp3Kl5Iwr4M0CciZ6EPLF95nh/XXloA5TsmRPOVbpW
6KRP4eZ1FJPqfEx664dM7gU2w9vyPj5W0xVkvOuoDk/dNLNXf3L3+LF1W2rm
pMqeIQoQPEXqa4JVsiIMorJhc8282dE8qD3aU0ORCLhTMudyEdTVfWdGnwV+
fvWe4QKnSDnRPjN96+Tchrhl78gzu4kbwghr5H651Gz1uieLG+pu9qQ72PEv
EXrSSg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->345767928]
}, Open  ]],

Cell["\<\
Using the function again with more points just adds the additional points:\
\>", "ExampleText",
 CellID->437401219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rplot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"10", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotPoints", "\[Rule]", "125"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->594488375],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->17561951]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25393],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlockRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlockRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomComplex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomChoice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomChoice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32137],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "Tutorials",
 CellID->3137]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->626183268],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->4276810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with SeedRandom",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=SeedRandom"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
SeedRandom"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeedRandom - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 22.8993240}", "context" -> "System`", 
    "keywords" -> {
     "initialization", "random number generator", "random seed", 
      "random state", "seeding of random generator", "congruential", 
      "extended CA", "Mersenne twister", "MKL", "rule 30 CA"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SeedRandom[n] resets the pseudorandom generator, using n as a seed. \
SeedRandom[] resets the generator, using as a seed the time of day and \
certain attributes of the current Mathematica session. ", 
    "synonyms" -> {"seed random"}, "title" -> "SeedRandom", "type" -> 
    "Symbol", "uri" -> "ref/SeedRandom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14869, 407, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46565636]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36622, 1147}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2636, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3259, 85, 4194, 83, 70, "ObjectNameGrid"],
Cell[7456, 170, 992, 31, 70, "Usage",
 CellID->20244]
}, Open  ]],
Cell[CellGroupData[{
Cell[8485, 206, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8963, 223, 328, 11, 70, "Notes",
 CellID->7598],
Cell[9294, 236, 1114, 40, 70, "Notes",
 CellID->15005],
Cell[10411, 278, 554, 16, 70, "Notes",
 CellID->24137],
Cell[10968, 296, 601, 18, 70, "Notes",
 CellID->1484],
Cell[11572, 316, 814, 27, 70, "Notes",
 CellID->4569],
Cell[12389, 345, 196, 4, 70, "Notes",
 CellID->30563],
Cell[12588, 351, 2126, 46, 70, "2ColumnTableMod",
 CellID->13671],
Cell[14717, 399, 115, 3, 70, "Notes",
 CellID->19554]
}, Closed]],
Cell[CellGroupData[{
Cell[14869, 407, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46565636],
Cell[CellGroupData[{
Cell[15253, 421, 148, 5, 70, "ExampleSection",
 CellID->608918267],
Cell[15404, 428, 219, 8, 70, "ExampleText",
 CellID->158],
Cell[CellGroupData[{
Cell[15648, 440, 160, 5, 28, "Input",
 CellID->30052],
Cell[15811, 447, 171, 5, 36, "Output",
 CellID->20002]
}, Open  ]],
Cell[CellGroupData[{
Cell[16019, 457, 160, 5, 28, "Input",
 CellID->13545],
Cell[16182, 464, 171, 5, 36, "Output",
 CellID->11009]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16402, 475, 216, 7, 70, "ExampleSection",
 CellID->28290],
Cell[16621, 484, 64, 1, 70, "ExampleText",
 CellID->11340],
Cell[CellGroupData[{
Cell[16710, 489, 171, 5, 70, "Input",
 CellID->8588],
Cell[16884, 496, 172, 5, 36, "Output",
 CellID->25767]
}, Open  ]],
Cell[17071, 504, 121, 3, 70, "ExampleDelimiter",
 CellID->26288],
Cell[17195, 509, 207, 7, 70, "ExampleText",
 CellID->8885],
Cell[CellGroupData[{
Cell[17427, 520, 252, 8, 70, "Input",
 CellID->31675],
Cell[17682, 530, 216, 7, 36, "Output",
 CellID->3863]
}, Open  ]],
Cell[CellGroupData[{
Cell[17935, 542, 252, 8, 70, "Input",
 CellID->26791],
Cell[18190, 552, 217, 7, 36, "Output",
 CellID->5181]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18456, 565, 222, 7, 70, "ExampleSection",
 CellID->759621460],
Cell[CellGroupData[{
Cell[18703, 576, 227, 7, 70, "ExampleSubsection",
 CellID->107507861],
Cell[18933, 585, 84, 1, 70, "ExampleText",
 CellID->164354472],
Cell[19020, 588, 162, 4, 70, "Input",
 CellID->207915769],
Cell[19185, 594, 84, 1, 70, "ExampleText",
 CellID->20260502],
Cell[CellGroupData[{
Cell[19294, 599, 129, 4, 70, "Input",
 CellID->490655889],
Cell[19426, 605, 340, 10, 36, "Output",
 CellID->585490342]
}, Open  ]],
Cell[19781, 618, 120, 3, 70, "ExampleText",
 CellID->588078918],
Cell[CellGroupData[{
Cell[19926, 625, 192, 6, 70, "Input",
 CellID->98681085],
Cell[20121, 633, 337, 10, 36, "Output",
 CellID->188554506]
}, Open  ]],
Cell[20473, 646, 124, 3, 70, "ExampleDelimiter",
 CellID->83270609],
Cell[20600, 651, 85, 1, 70, "ExampleText",
 CellID->359336346],
Cell[20688, 654, 197, 5, 70, "Input",
 CellID->108987002]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20934, 665, 226, 7, 70, "ExampleSection",
 CellID->60836973],
Cell[21163, 674, 98, 1, 70, "ExampleText",
 CellID->243084941],
Cell[CellGroupData[{
Cell[21286, 679, 342, 11, 70, "Input",
 CellID->200261829],
Cell[21631, 692, 196, 6, 36, "Output",
 CellID->56621297]
}, Open  ]],
Cell[CellGroupData[{
Cell[21864, 703, 358, 11, 70, "Input",
 CellID->174899128],
Cell[22225, 716, 300, 9, 36, "Output",
 CellID->125092044]
}, Open  ]],
Cell[CellGroupData[{
Cell[22562, 730, 430, 14, 70, "Input",
 CellID->590673250],
Cell[22995, 746, 342, 10, 36, "Output",
 CellID->89464215]
}, Open  ]],
Cell[23352, 759, 124, 3, 70, "ExampleDelimiter",
 CellID->44473842],
Cell[23479, 764, 122, 3, 70, "ExampleText",
 CellID->269027597],
Cell[23604, 769, 300, 9, 70, "Input",
 CellID->451558077],
Cell[23907, 780, 1142, 32, 70, "Input",
 CellID->1032931923],
Cell[CellGroupData[{
Cell[25074, 816, 281, 9, 70, "Input",
 CellID->188752049],
Cell[25358, 827, 2234, 41, 70, "Output",
 Evaluatable->False,
 CellID->345767928]
}, Open  ]],
Cell[27607, 871, 125, 3, 70, "ExampleText",
 CellID->437401219],
Cell[CellGroupData[{
Cell[27757, 878, 301, 9, 70, "Input",
 CellID->594488375],
Cell[28061, 889, 2440, 44, 70, "Output",
 Evaluatable->False,
 CellID->17561951]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30562, 940, 311, 9, 70, "SeeAlsoSection",
 CellID->25393],
Cell[30876, 951, 2218, 80, 70, "SeeAlso",
 CellID->22191]
}, Open  ]],
Cell[CellGroupData[{
Cell[33131, 1036, 314, 9, 70, "TutorialsSection",
 CellID->32137],
Cell[33448, 1047, 149, 3, 70, "Tutorials",
 CellID->3137]
}, Open  ]],
Cell[CellGroupData[{
Cell[33634, 1055, 319, 9, 70, "MoreAboutSection",
 CellID->626183268],
Cell[33956, 1066, 156, 3, 70, "MoreAbout",
 CellID->4276810]
}, Open  ]],
Cell[CellGroupData[{
Cell[34149, 1074, 305, 8, 70, "RelatedLinksSection"],
Cell[34457, 1084, 365, 12, 70, "RelatedLinks"],
Cell[34825, 1098, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[35228, 1114, 50, 0, 70, "History"],
Cell[35281, 1116, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

