(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42342,       1531]
NotebookOptionsPosition[     33937,       1240]
NotebookOutlinePosition[     35508,       1281]
CellTagsIndexPosition[     35422,       1276]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Selecting Parts of Expressions with Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SelectingPartsOfExpressionsWithFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Selecting Parts of Expressions with Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "Reap" :> 
          Documentation`HelpLookup["paclet:ref/Reap"], "Pick" :> 
          Documentation`HelpLookup["paclet:ref/Pick"], "MatchQ" :> 
          Documentation`HelpLookup["paclet:ref/MatchQ"], "StringMatchQ" :> 
          Documentation`HelpLookup["paclet:ref/StringMatchQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cases\"\>", 2->"\<\"Take\"\>", 
       3->"\<\"Drop\"\>", 4->"\<\"Reap\"\>", 5->"\<\"Pick\"\>", 
       6->"\<\"MatchQ\"\>", 7->"\<\"StringMatchQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Elements of Lists\"\>", 3->"\<\"Functional Programming\"\>", 
       4->"\<\"Handling Arrays of Data\"\>", 5->"\<\"Language Overview\"\>", 
       6->"\<\"List Manipulation\"\>", 
       7->"\<\"Numerical Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Select", "ObjectName",
 CellID->194],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Select",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Select"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["crit", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]picks out all elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      RowBox[{
       StyleBox["crit", "TI"], "[", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Select",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Select"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["crit", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]picks out the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements for which ",
     Cell[BoxData[
      RowBox[{
       StyleBox["crit", "TI"], "[", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " can have any head, not necessarily ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18517],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->165853580]
}], "Notes",
 CellID->28751]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331144201],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->106572648],

Cell["Select elements that are even:", "ExampleText",
 CellID->8382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "7", ",", "6", ",", "2"}], "}"}], 
   ",", "EvenQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "6", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28781]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8808],

Cell["Use a pure function to test each element:", "ExampleText",
 CellID->14609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "7", ",", "6", ",", "2"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"#", ">", "2"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22732],

Cell["Return only the first expression selected:", "ExampleText",
 CellID->26940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "7", ",", "6", ",", "2"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"#", ">", "2"}], "&"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30188],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18960]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4185],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " picks out elements for which applying the criterion explicitly yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->77],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "7", ",", "x"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", ">", "2"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17773]
}, Open  ]],

Cell[TextData[{
 "Applying the criterion to the symbolic object ",
 Cell[BoxData["x"], "InlineFormula"],
 " does not explicitly yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", ">", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28044],

Cell[BoxData[
 RowBox[{"x", ">", "2"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8698]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->296577323],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->87967147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "a", ",", "2", ",", "b", ",", "3"}], "]"}], ",", 
   "IntegerQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22433],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396375592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77950939],

Cell[TextData[{
 "Select works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->165853580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "^", "i"}], "\[Rule]", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->750594546],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", "32", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326260422]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"s", ",", "EvenQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1171109],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "29", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46420336]
}, Open  ]],

Cell["The result may be a list if it is not sparse:", "ExampleText",
 CellID->754035701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"s", ",", "OddQ"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->346187623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "5"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->166657650]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30640096],

Cell["Select numbers up to 100 that equal 1 modulo both 3 and 5:", \
"ExampleText",
 CellID->203213298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "100", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"#", ",", "3"}], "]"}], "==", "1"}], "&&", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"#", ",", "5"}], "]"}], "==", "1"}]}], "&"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->6985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "16", ",", "31", ",", "46", ",", "61", ",", "76", ",", "91"}], 
  "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356058664],

Cell["Select 4-tuples that read the same in reverse:", "ExampleText",
 CellID->2682388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "4"}], "]"}], ",", 
   RowBox[{
    RowBox[{"#", "==", 
     RowBox[{"Reverse", "[", "#", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "b", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459000203],

Cell["\<\
Find the first four 3x3 matrices of 0s and 1s that have determinant 1:\
\>", "ExampleText",
 CellID->29393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", "#", "]"}], "==", "1"}], "&"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31388],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMlOwzAQdeKWsqjQcuJYfgZOfERUIbUHBCr9O/i3YDsNhNHY44ndqMtU
auIls728JPZ7qbar17dqu15Wi+dN9bFaLz8XT+8bM6QLpYovpdTjgzLt2rTc
3/6+zb9pNq0be9TtbK1GoH8F+ndEH9pfZ/YH8031R+XLxWM2MB6UP5gPFw9t
DyQqdr403dnuPEe82HHoJ9YO3nXKDqsCi0/VcZ+5Dp/dPLIO2C+j7o6Nbrtj
MD7xjF+Yw9h0qeiXSDaYnS+Ob5x65nxxfHnHxqHqS8V1cmC4cuJw8M7DWnfV
+LfvbJpY9kmZBGchY7CMONeFo/lnMV9U3aHceNH6VJyCekpl+0Y9NiZWQ6w9
zXnKi0ZrmqKj8EsOn/ZpzHxkLGh7S/iGucV5hWjAClLQguugIdGifFNrNO53
q3B59Hu/xnEN+qLmOehBW2pFHcc1CjOqAg5a3IxzokX5Tt0P5PyWC9fS0RKu
CdeEa8I14dqxc41SYu1Vesej9mx3JnB1CDWksv7Tprr20D/Uurp2XXuqGkrD
gnW0/nPV4bOb1//r4a6qGyXUNqGGzm9xGSIqPC/eaarwugeKosrvX5Vv/Yx6
3aVTU+d99Yg6z6sXxgnVk1+d57L4XNT6cJ2i2e9Tsw/XmVO5t3bNN7dkWh+r
go/nLTp+yDeed6qa7977md6/h69E4HmLHhHyjeedusdw70nhnfBOeJcRQ+Ed
HzPhXTqGwjs+ZkPyrs+uXKth1f9unGNW/7txYtV/t5t0nRg9XxU/Tv/NKA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{443, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->655960369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93488106],

Cell["Select eigenvalues that lie within the unit circle:", "ExampleText",
 CellID->36802547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Eigenvalues", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", "#", "]"}], "<", "1"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.6328479726139699`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.09448925470528648`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6328479726139699`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.09448925470528648`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.4424411359441049`"}], "+", 
    RowBox[{"0.06572953819386534`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.4424411359441049`"}], "-", 
    RowBox[{"0.06572953819386534`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{330, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306801087],

Cell[TextData[{
 "Find built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects whose names are less than 3 characters long:"
}], "ExampleText",
 CellID->291175424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Names", "[", "\"\<*\>\"", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"StringLength", "[", "#", "]"}], "<", "3"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31897],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C\"\>", ",", "\<\"D\"\>", ",", "\<\"Do\"\>", ",", "\<\"Dt\"\>",
    ",", "\<\"E\"\>", ",", "\<\"I\"\>", ",", "\<\"If\"\>", ",", "\<\"Im\"\>", 
   ",", "\<\"In\"\>", ",", "\<\"K\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>", 
   ",", "\<\"On\"\>", ",", "\<\"Or\"\>", ",", "\<\"Pi\"\>", ",", "\<\"Re\"\>",
    ",", "\<\"Tr\"\>", ",", "\<\"Up\"\>", ",", "\<\"$\"\>", 
   ",", "\<\"\[SpanFromAbove]\"\>", ",", "\<\"\[SpanFromBoth]\"\>", 
   ",", "\<\"\[SpanFromLeft]\"\>"}], "}"}]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148254665],

Cell["Select numeric quantities from a product:", "ExampleText",
 CellID->148203375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"7", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "2"]}], ",", "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18528],

Cell[BoxData[
 RowBox[{"7", " ", 
  SuperscriptBox["\[Pi]", "2"]}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256904174],

Cell["\<\
Find an approximation to \[Pi] by finding the proportion of points that lie \
within a disk:\
\>", "ExampleText",
 CellID->426610610],

Cell[BoxData[
 RowBox[{
  RowBox[{"app", "[", "n_", "]"}], " ", ":=", " ", 
  RowBox[{"4", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "2"}], "}"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Dot", "[", 
           RowBox[{"#", ",", "#"}], "]"}], " ", "\[LessEqual]", " ", "1"}], 
         "&"}]}], "]"}], "]"}], "/", "n"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341311571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "=", " ", 
       RowBox[{"10", "^", "k"}]}], ";", 
      RowBox[{"p", "=", 
       RowBox[{"app", "[", "n", "]"}]}], ";", 
      RowBox[{"{", 
       RowBox[{"n", ",", "p", ",", 
        RowBox[{"\[Pi]", "-", "p"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<n\>\"", ",", "\"\<approximation\>\"", ",", "\"\<error\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498872229],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{255, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->342208285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->122985027],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " is similar to ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " except that it uses a function instead of a pattern:"
}], "ExampleText",
 CellID->107253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506119856],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->880102182]
}, Open  ]],

Cell["Select the lists that have sum of elements less than 10:", "ExampleText",
 CellID->175205012],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", "#", "]"}], "<", "10"}], "&"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->864369593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"list", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->268575815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->224135682]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " to get the same result:"
}], "ExampleText",
 CellID->196081136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"list", ",", 
   RowBox[{"x_", "/;", 
    RowBox[{"f", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22059569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->242802803]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7275],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reap"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringMatchQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringMatchQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28054]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15379],

Cell[TextData[ButtonBox["Selecting Parts of Expressions with Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SelectingPartsOfExpressionsWithFunctions"]], "Tutorials",
 CellID->20579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->799914375],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->242473660],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->7022430],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->107058944],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->552033239],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->56626157],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->372959095],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->400783763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Select",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Select"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Select"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Select - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 38.2903430}", "context" -> "System`", 
    "keywords" -> {
     "choose elements", "compress in APL", "criteria", "deleting elements", 
      "discard list elements", "elements", "expressions", "filtering lists", 
      "first occurrence", "lists", "mu operator", "picking elements of lists",
       "predicates", "satisfying criterion"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Select[list, crit] picks out all elements e_i of list for which \
crit[e_i] is True. Select[list, crit, n] picks out the first n elements for \
which crit[e_i] is True. ", "synonyms" -> {"find"}, "title" -> "Select", 
    "type" -> "Symbol", "uri" -> "ref/Select"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6951, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->331144201]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35279, 1269}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3186, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3809, 96, 42, 1, 70, "ObjectName",
 CellID->194],
Cell[3854, 99, 1858, 64, 70, "Usage",
 CellID->3247]
}, Open  ]],
Cell[CellGroupData[{
Cell[5749, 168, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6227, 185, 278, 11, 70, "Notes",
 CellID->18517],
Cell[6508, 198, 406, 15, 70, "Notes",
 CellID->28751]
}, Closed]],
Cell[CellGroupData[{
Cell[6951, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331144201],
Cell[CellGroupData[{
Cell[7336, 232, 148, 5, 70, "ExampleSection",
 CellID->106572648],
Cell[7487, 239, 68, 1, 70, "ExampleText",
 CellID->8382],
Cell[CellGroupData[{
Cell[7580, 244, 218, 7, 28, "Input",
 CellID->13616],
Cell[7801, 253, 219, 7, 36, "Output",
 CellID->28781]
}, Open  ]],
Cell[8035, 263, 120, 3, 70, "ExampleDelimiter",
 CellID->8808],
Cell[8158, 268, 80, 1, 70, "ExampleText",
 CellID->14609],
Cell[CellGroupData[{
Cell[8263, 273, 258, 9, 70, "Input",
 CellID->10299],
Cell[8524, 284, 209, 7, 36, "Output",
 CellID->22146]
}, Open  ]],
Cell[8748, 294, 121, 3, 70, "ExampleDelimiter",
 CellID->22732],
Cell[8872, 299, 81, 1, 70, "ExampleText",
 CellID->26940],
Cell[CellGroupData[{
Cell[8978, 304, 268, 9, 70, "Input",
 CellID->30188],
Cell[9249, 315, 176, 6, 36, "Output",
 CellID->18960]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9474, 327, 215, 7, 70, "ExampleSection",
 CellID->4185],
Cell[9692, 336, 354, 12, 70, "ExampleText",
 CellID->77],
Cell[CellGroupData[{
Cell[10071, 352, 244, 8, 70, "Input",
 CellID->26380],
Cell[10318, 362, 199, 7, 36, "Output",
 CellID->17773]
}, Open  ]],
Cell[10532, 372, 286, 10, 70, "ExampleText",
 CellID->3867],
Cell[CellGroupData[{
Cell[10843, 386, 88, 3, 70, "Input",
 CellID->28044],
Cell[10934, 391, 175, 6, 36, "Output",
 CellID->8698]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11158, 403, 243, 7, 70, "ExampleSection",
 CellID->296577323],
Cell[11404, 412, 320, 12, 70, "ExampleText",
 CellID->87967147],
Cell[CellGroupData[{
Cell[11749, 428, 216, 7, 70, "Input",
 CellID->22433],
Cell[11968, 437, 218, 7, 36, "Output",
 CellID->396375592]
}, Open  ]],
Cell[12201, 447, 124, 3, 70, "ExampleDelimiter",
 CellID->77950939],
Cell[12328, 452, 263, 9, 70, "ExampleText",
 CellID->165853580],
Cell[CellGroupData[{
Cell[12616, 465, 320, 10, 70, "Input",
 CellID->750594546],
Cell[12939, 477, 454, 16, 36, "Output",
 CellID->326260422]
}, Open  ]],
Cell[CellGroupData[{
Cell[13430, 498, 127, 4, 70, "Input",
 CellID->1171109],
Cell[13560, 504, 453, 16, 36, "Output",
 CellID->46420336]
}, Open  ]],
Cell[14028, 523, 88, 1, 70, "ExampleText",
 CellID->754035701],
Cell[CellGroupData[{
Cell[14141, 528, 128, 4, 70, "Input",
 CellID->346187623],
Cell[14272, 534, 213, 7, 36, "Output",
 CellID->166657650]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14534, 547, 226, 7, 70, "ExampleSection",
 CellID->30640096],
Cell[14763, 556, 103, 2, 70, "ExampleText",
 CellID->203213298],
Cell[CellGroupData[{
Cell[14891, 562, 380, 14, 70, "Input",
 CellID->6985],
Cell[15274, 578, 261, 9, 36, "Output",
 CellID->6330]
}, Open  ]],
Cell[15550, 590, 125, 3, 70, "ExampleDelimiter",
 CellID->356058664],
Cell[15678, 595, 87, 1, 70, "ExampleText",
 CellID->2682388],
Cell[CellGroupData[{
Cell[15790, 600, 315, 11, 70, "Input",
 CellID->27255],
Cell[16108, 613, 496, 15, 36, "Output",
 CellID->24919]
}, Open  ]],
Cell[16619, 631, 125, 3, 70, "ExampleDelimiter",
 CellID->459000203],
Cell[16747, 636, 117, 3, 70, "ExampleText",
 CellID->29393],
Cell[CellGroupData[{
Cell[16889, 643, 377, 14, 70, "Input",
 CellID->31388],
Cell[17269, 659, 1005, 21, 70, "Output",
 Evaluatable->False,
 CellID->655960369]
}, Open  ]],
Cell[18289, 683, 124, 3, 70, "ExampleDelimiter",
 CellID->93488106],
Cell[18416, 688, 93, 1, 70, "ExampleText",
 CellID->36802547],
Cell[CellGroupData[{
Cell[18534, 693, 356, 12, 70, "Input",
 CellID->5177],
Cell[18893, 707, 695, 18, 54, "Output",
 CellID->253]
}, Open  ]],
Cell[19603, 728, 125, 3, 70, "ExampleDelimiter",
 CellID->306801087],
Cell[19731, 733, 179, 6, 70, "ExampleText",
 CellID->291175424],
Cell[CellGroupData[{
Cell[19935, 743, 251, 9, 70, "Input",
 CellID->31897],
Cell[20189, 754, 654, 13, 36, "Output",
 CellID->16194]
}, Open  ]],
Cell[20858, 770, 125, 3, 70, "ExampleDelimiter",
 CellID->148254665],
Cell[20986, 775, 84, 1, 70, "ExampleText",
 CellID->148203375],
Cell[CellGroupData[{
Cell[21095, 780, 254, 8, 70, "Input",
 CellID->18528],
Cell[21352, 790, 204, 7, 36, "Output",
 CellID->23383]
}, Open  ]],
Cell[21571, 800, 125, 3, 70, "ExampleDelimiter",
 CellID->256904174],
Cell[21699, 805, 143, 4, 70, "ExampleText",
 CellID->426610610],
Cell[21845, 811, 689, 22, 70, "Input",
 CellID->341311571],
Cell[CellGroupData[{
Cell[22559, 837, 742, 24, 70, "Input",
 CellID->498872229],
Cell[23304, 863, 2228, 40, 70, "Output",
 Evaluatable->False,
 CellID->342208285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25581, 909, 237, 7, 70, "ExampleSection",
 CellID->122985027],
Cell[25821, 918, 356, 12, 70, "ExampleText",
 CellID->107253],
Cell[CellGroupData[{
Cell[26202, 934, 221, 7, 70, "Input",
 CellID->506119856],
Cell[26426, 943, 774, 27, 36, "Output",
 CellID->880102182]
}, Open  ]],
Cell[27215, 973, 99, 1, 70, "ExampleText",
 CellID->175205012],
Cell[27317, 976, 190, 7, 70, "Input",
 CellID->864369593],
Cell[CellGroupData[{
Cell[27532, 987, 128, 4, 70, "Input",
 CellID->268575815],
Cell[27663, 993, 361, 13, 36, "Output",
 CellID->224135682]
}, Open  ]],
Cell[28039, 1009, 204, 8, 70, "ExampleText",
 CellID->196081136],
Cell[CellGroupData[{
Cell[28268, 1021, 182, 6, 70, "Input",
 CellID->22059569],
Cell[28453, 1029, 361, 13, 36, "Output",
 CellID->242802803]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28875, 1049, 310, 9, 70, "SeeAlsoSection",
 CellID->7275],
Cell[29188, 1060, 1642, 62, 70, "SeeAlso",
 CellID->28054]
}, Open  ]],
Cell[CellGroupData[{
Cell[30867, 1127, 314, 9, 70, "TutorialsSection",
 CellID->15379],
Cell[31184, 1138, 199, 4, 70, "Tutorials",
 CellID->20579]
}, Open  ]],
Cell[CellGroupData[{
Cell[31420, 1147, 319, 9, 70, "MoreAboutSection",
 CellID->799914375],
Cell[31742, 1158, 136, 3, 70, "MoreAbout",
 CellID->242473660],
Cell[31881, 1163, 142, 3, 70, "MoreAbout",
 CellID->7022430],
Cell[32026, 1168, 155, 3, 70, "MoreAbout",
 CellID->107058944],
Cell[32184, 1173, 155, 3, 70, "MoreAbout",
 CellID->552033239],
Cell[32342, 1178, 144, 3, 70, "MoreAbout",
 CellID->56626157],
Cell[32489, 1183, 145, 3, 70, "MoreAbout",
 CellID->372959095],
Cell[32637, 1188, 139, 3, 70, "MoreAbout",
 CellID->400783763]
}, Open  ]],
Cell[CellGroupData[{
Cell[32813, 1196, 305, 8, 70, "RelatedLinksSection"],
Cell[33121, 1206, 357, 12, 70, "RelatedLinks"],
Cell[33481, 1220, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[33880, 1236, 27, 0, 70, "History"],
Cell[33910, 1238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

