(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42141,       1089]
NotebookOptionsPosition[     37199,        926]
NotebookOutlinePosition[     38816,        968]
CellTagsIndexPosition[     38731,        963]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectionEvaluate" :> 
          Documentation`HelpLookup["paclet:ref/SelectionEvaluate"], 
          "SelectionCreateCell" :> 
          Documentation`HelpLookup["paclet:ref/SelectionCreateCell"], 
          "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SelectionEvaluate\"\>", 
       2->"\<\"SelectionCreateCell\"\>", 3->"\<\"NotebookRead\"\>", 
       4->"\<\"NotebookWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SelectionEvaluateCreateCell", "ObjectName",
 CellID->14519],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionEvaluateCreateCell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionEvaluateCreateCell"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the current selection in a notebook and creates a \
new cell containing the result obtained by evaluating the contents of the \
selection using the kernel. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionEvaluateCreateCell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionEvaluateCreateCell"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["sel", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current selection after the evaluation to be \
as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["SelectionEvaluateCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluateCreateCell"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3418],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " are as in ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13713],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["After"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelectionEvaluateCreateCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionEvaluateCreateCell"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " sets the current selection to be the cell corresponding to the result from \
the evaluation. "
}], "Notes",
 CellID->17740],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionEvaluateCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluateCreateCell"]], "InlineFormula"],
 " performs the same underlying operation as typing ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " in the front end. It does not, however, have side effects such as \
incrementing ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22940]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->71089375],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->553888332],

Cell["Evaluate an input cell and produce output beneath it:", "ExampleText",
 CellID->715500508],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413117256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->342462635],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtvlEUcx/EaE280hsRXQHwV3qqXKglypYm0KAU0xOgL8IJwUCqEY8ux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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellID->7108619]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluateCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17909343],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9TVNcZx+n0fSf/Qv+V/nirk0ze2Mw04lQ07WQcO32Rmc70RaYmbWw6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   "], {{0, 0}, {458, 89}}, {0, 255}],
  ImageSize->{458 0.75, 89 0.75},
  PlotRange->{{0, 458}, {0, 89}}]], "NotebookImage",
 CellID->12757918]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->363698698],

Cell["Make the selection be a point within an input cell:", "ExampleText",
 CellID->652952756],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767040395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "CellContents"}], "]"}], ";"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->548591501],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhqfpfeNf6E/p6VbTxpu2SQVTQNsYY9OLJk16Yaq2UpviATwA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   "], {{0, 0}, {458, 65}}, {0, 255}],
  ImageSize->{458 0.75, 65 0.75},
  PlotRange->{{0, 458}, {0, 65}}]], "NotebookImage",
 CellID->177949869]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionEvaluateCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluateCreateCell"]], "InlineFormula"],
 " takes the whole cell as input:"
}], "ExampleText",
 CellID->364716244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluateCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->46264990],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9PW9cZx5n2vuq/sH9lP94matU3baU1RAtJN1VRpr2oNGkvqqbdmnVa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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->459701387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297295393],

Cell["Select multiple cells:", "ExampleText",
 CellID->397346606],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<3\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<text\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6509240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245559868],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/HtdCZPkulkJn+Bk78iT9s+TJqZmEftTAOmomknk2me9Ukf
ZGJsQ+NoVFCjNKFAojEoWIliQeTHuiy4IAuyIGALq1P8FXWKowVyeu6e3bNn
7727Lnv3pDH3/ZpPmPM999wb8uQz6wqbTVveeW3LjyORyB/kP/EfRSLOuq7u
j4QQQmxkdW2dEEJIFaPb9Yuj5wghhFQlrnb9v7+EJoSQH0B821UAAAKoy73X
SrsCQBXRrgBgA+0KADbQrgBgA+0KADbQrgBgA+0KADbQrgBgA+0KADbQrgBg
A+0KADbQrgBgA+0KABWLFDIv0a4AUJmIH32VdgWAysgurX//5e6OOpX2thra
FQCCc71qlQVLuwJAcLQrANgQ8nYt8Z6z9+/4ynyOne8UwFMm5O2q+LbiRquS
agVgol1FsHYt8eoXQJjRriJwu27oPICQoF1F8WL0vhNbYk27AjDRrqLsdhVG
kfpu0q4AtJC3q+/7pSX+sO/bruZzLH+/AJ4aZr28uOmFsLWr4m1X39bVV8t5
CICQM6tV/UpsCNsVAKrOrNbnnn2GdgWAqjCrNYTvuwKAJWa10q4AUC3b33xp
185X9CcQNu7eTLsCQHARP/oq7QoAFSvx00e0KwDYQLsCgA20KwDYQLsCgA20
KwDYQLsCgA20KwDYQLsCgA20KwDYQLsCgA20KwBUrMRH8dOuAFAZPsUFAGyQ
Xar+hy8q7W01tCsABOd61cqnZwNAVYSqXc33PXzX3gUAVCZs7Vp64d0HgMqE
vF19rxY7AADlC227en9AgnYFUEWhbVffBe8MAKiW8LSr68Vqib/V8r6sBYCN
Ck+7io28IqVaAQREuwY8CQC+QtWuAPCdoV0BwAZVqvmPGjhJuwJAFfDaFQBs
iBR+Rlbj7s20KwAEF/Gjr9KuAFCxEj8/T7sCgA20KwDYQLsCgA20KwDYQLsC
gA20KwDYQLsCgA20KwDYQLsCQMVKfCA/7QoAleE3YQHABtenuLS31dCuABAc
n0AIADbQrgBgQ8jbtcR7zr4fGvbE59j5NgE8fULeropvMZbflvoYBQtAo11F
4HYNcguAHyraVdCuACygXUXxVvS+E+u7FrzvCsCDdhVlt6vIlWqxFqVgAWgh
b1fzv93cNK+6zgu/F67FzgMILbNeXtz0QtjaVfG2q2/r6qvFnkC1AtDMalW/
EhvCdgWAqjOr9blnn6FdAaAqzGoN4fuuAGCJWa20KwBUy/Y3X9q18xX9CYSN
uzfTrgAQXMSPvkq7AkDFSvz0Ee0KADbQrgBgA+0KADbQrgBgA+0KADaY7fq7
t+vn5/7ZcSr2YX0LIYSQgFn972o0Nv37d/fUvf2RbFeZmZkFQgghAWO260xq
SYj19fU1QgghQfLt+prZrlemFldX11YePpJ5mEl2vSK/Ptbjykr2gNzUh/Xa
zENGRkbG7+m44U47cPjokdd/2vbqz1pf/bk3cl9elWfUjY8ePV5ZeazbdeLy
tfsPVm7fuX/7zr3M1/u59T33+q55QJ/Xmw8KrzIyMjJ+r8ZKOq3z9V+s7d0n
Pm0WTU0++bRZXpVn1I137jq36HYdG5u78e87i+lbi0vLP3n+eTOL6eXF9M3s
eslc35Qxjt3KLW7qtRrz+8Z538P5J2cOq6tq4b6r8CojIyNjWaNTYsuZTbWz
nNvPJXtp2bkr94Sr22pF12lx4ljRdJ2WZ9S9S9dvLaVv63YdGZ2du3Zj5uqS
qi+5UMmN6fz+bP5MbrGYOZw9M1vwkEVzdD3cdVWOhQecq+bh0lcZGRkZnzjm
Fun85mzh6KwXjTPOE2brakVnh/jy8+wPXcmFih47O+SZzC3p2bn01fkbul1j
w6nk1LXLyXnVYHIxnpw3R73w21zw3R8vfMh44cO9V8cL1+qqebj0VUZGRsYy
x8uFa08WzLvkwt2u0nFjnWtXddfE5PzklX/pdpWLkUQqfmlaNdjwaCo2khoe
zY+5xbS5zi4upYZHpvPjiL5rOi7PG6PrHQDvYbWOFZ6MOf/Sgqv6yXLByMjI
WP4YH03JDOe+Djv7KWc/03jqsO40/YTZuhrReUIca3Xi0vZX0dok2o/Kdh1W
z7yUSozP6XYdik4NRpMD0aRqMLkYGEr2Ryey41DBvmuzP7M5MKQPT+T3o0lz
1Df2FzmcXQ9N6HvV4XKuMjIyMpYxZnfkOr+T3c9Gd5p+wsxv3nB6tfkT0XxI
fHYwX61NDeLIPvHJx7JgZ7a+kbtlIhZPnb9wWbXrYHSqt29MRjVYzwVn3Xsh
oUa9r2Mezu0kXAvX2NM31lN4S4/zkITfwxPqsLqqx9JXGRkZGcsYszs92f2C
GOcLnuC0a8sRcXCPOLDH/dp170fi47+IIwdlu+rnDEYn/94VU+06MDR5pnv4
7Lm4ajC5UFHjmXMjZ53Ez3bH5doZu0eMw5lLzn48c1Lf5T+6DpujfqD3qu7e
YvcyMjIyPnE8k9/36TR11dtpM1trRNPBtd31ulMf78qvH/55p2jcP7u1JnNv
/Ex3vK9//Itjvdl2HZw81RU9/XVMNZhcqLhGVwqvXtSjsX/ROxpxj64Hbugq
IyMj4wbH0rmovzrvuzbuf7DzA1Wn//nTBw8yUeM3O3aI/fvkGX1vz/nE4aZT
uXadOtFxseNUzEZUK1b3JCGEfGeZ314rGhpuv/feNzve90bui8aG+W016vDJ
zlj3P8b27D2WbdeBK8e/HGz/KkoIIcSVxFu/FIcaRaNMg08aGsShw6O//bU6
/NXx6NddiQ/rW1S79vUlmz/raWs5TwghxJUDh4+Obf3Vwltb5rbVerOwvTax
rVaeUYdb/9Z78kSMdiWEkOqGdiWEEBuhXQkhxEZc7do/kGxp7vm87TwhhJAg
aWvt7ezIt+tS+u78ws35hWVCCCEBc/36Pd2uhBBCqhvZrv8DPdP6tg==
   "], {{0, 0}, {458, 121}}, {0, 255}],
  ImageSize->{458 0.75, 121 0.75},
  PlotRange->{{0, 458}, {0, 121}}]], "NotebookImage",
 CellID->669761429]
}, Open  ]],

Cell["Evaluate all the evaluatable cells in the selection:", "ExampleText",
 CellID->677476168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluateCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->350321110],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etvFNcZx3FXfV/lX+i/0stbEChvXKQGo2KcVpFF1RdIlfoiKkkbmqoE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   "], {{0, 0}, {458, 174}}, {0, 255}],
  ImageSize->{458 0.75, 174 0.75},
  PlotRange->{{0, 458}, {0, 174}}]], "NotebookImage",
 CellID->238042981]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->196593376],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionEvaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFormula"],
 " evaluates the selected expression in place:"
}], "ExampleText",
 CellID->380868350],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18862177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->829826297],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1Pk1ccx1l2v/gv7B/ZxV5uNVu82ZZMMAN0izFbdrdkF2bqJnMZvoAv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   "], {{0, 0}, {458, 62}}, {0, 255}],
  ImageSize->{458 0.75, 62 0.75},
  PlotRange->{{0, 458}, {0, 62}}]], "NotebookImage",
 CellID->743847037]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluate", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->128118575],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch2l63/gV+kF608Otpo03bZMKpoC2McamF02a9MJUbaU2xQOI
AioFFEQRqIhYDnJYlgWXw4IsyGILqykIHqgQKdDpvDu7s+/77rKA7Nua7vPk
KZnfzH+md79sFm3f3L3/g92vp6WlvSX/8byWlmass7K+QUREJ1xeWUVExCSq
2/VSxS1EREyKtnb9zz9CIyL+D4zbrgIAALZAVuS7VtoVACCJ0K4AAE5AuwIA
OAHtCgDgBLQrAIAT0K4AAE5AuwIAOAHtCgDgBLQrAIAT0K4AAE5AuwIAOAHt
CgDw0nz5dd172wuU7394znxEuwIAJAVZsOZIuwIAJAXaFQDACVKwXdMirLu5
1lGalbibcZ8CgNQh1dpV956tGG2n5vnYowTlSa8CgIJ2jXua4GLiSdoVABS0
a9zTBBcTD9OuAKBItXYVm/zeNfG3ARusXABIQVKtXTf72TXub6kSPEK7AoCC
dhXr/VYrQQnbHlnrAzAApBrjE7Op1q5i898MJPj4upFPvwCQashqVX8l1ryZ
Cu0KAOAcqlr/fL5EuwIAJAtdrSL1vncFAHAIc7UK2hUAIEnkF7oOfFWr/wuE
e/ZXmU9pVwAAJ6BdAQCcgHYFAHAC2hUAwAloVwAAJ6BdAQCcgHYFAHACc7t+
vi8nMP5bTZ37aE4pIiJu0eW/ll3ukQNf5GbtOybbVTo6OoGIiFvU3K6j/ikh
VldXVxARcSv+vbpibte7w5PLyysLiy+kiyHD6wX5c0nHhYXwgNzUw3ptdpFI
JBJf0bjpTjtdWFG08+3yHe+U7Xg3VrkvT+WMuvjixdLCwpJu18GB+8/mF2bn
ns3OPQ39fBZZP7WvH5sH9LzenLeeEolE4isVX6bTanduXzlxUpwvEcXFcTxf
Ik/ljLo499i4otu1r2/84R9zk8FHk1PTb2zbZnYyOD0ZnAmvp8zrGalp7FFk
MaPXKkb3TfNxh6Mvh4bVqVrYb1lPiUQicUPRKLHp0KbamY7sRwwfTRu3Ii/c
y84Q9ddFdeWa1l+XM+ru1INHU8FZ3a49vWPj9x+O3ptS9SUXykgMRvfHojOR
xWRoODwzZnlk0hxtj9tOZbQOGKfm4cSnRCKRuG6MLILRzTFrNNaTphnjhbGs
DFFbIy5fDP+hK7lQ6lhbI2dCV4Jj48F7gYe6Xd3dft/w/QFfQDWYXPT7Auao
F/E2J+Lu91sf6bc+Hnvab12rU/Nw4lMikUjcYBywrmOcMN+SC3u7SqpM60i7
qluDQ4Ghu7/rdpWLHq/fc2dENVh3r9/d4+/ujcbIYsS8Di/u+Lt7RqKxR98a
8ch5U7R9AxA7rNZu66Tb+JdaTvXLckEkEokbj55ev7Q78rPb2Pcb+6HGU8O6
0/QLY1nporZaVJYZ2ig/J8qKxdUK2a7d6s07fm//uG7XTtdwh8vX7vKpBpOL
9k5fm2swHDst+7bNttBme6ceHozuu3zmqC+2rTEcXncO6rtqeCOnRCKRuIEY
3pHr6E54P6zuNP3C6Ke7jF4tOStKzogLpv8TQXGeKDopzh6XBTuauStyZdDt
8bfcHlDt2uEabm7tk6oGa7ptrJtve1XU+1rzcGTHa1vYYlNrX5P1SpPxiDfe
4141rE51THxKJBKJG4jhnabwvkXTvOUFo11Li0RBrjida//seuKYOP6DKCqQ
7arf6XAN/VLvVu3a3jnU0Nh985ZHNZhcKFVsuNVz09Bzs9Ej10Zs7DENh46M
fU9oUt+KH23D5qgfjD3V3bvWXSKRSFw3NkT343SaOo3ttNHMdFFcsPJTju7U
pR+j68Xvj4j8U2OZ6aG7noZGT2tb/6XK5nC7dgzV1buu33CrBpMLpS3atJ52
6Wja74qNJu3R9uCmTolEInGTMbFd+qfxvWv+qfkjh1WdPv/u8HxIFZ8cOiRO
nZQz+m5Ti7ewuC7SrsPVNV01dW4nVK2Y3ElExH/NwJ4MkZc3e/Dgk0Pfxir3
RX5eIDtdDV+rdTf+2pd7ojLcru13qy53XL3iQkREm969H4kz+SJfmhfHvDxx
prD3s0/U8JUq141679GcUtWura2+kgtN5aUtiIho83RhRV/mxxN7d49nZ8Q6
sSfDm50hZ9Rw2c/N16rdtCsiYnKlXRERnZB2RUR0Qlu7trX7SkuaLpa3ICLi
Viwva66tibbrVPBxYGImMDGNiIhb9MGDp7pdERExucp2/Qf9FLWm
   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->33455185]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19225],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionEvaluate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionEvaluate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionCreateCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionCreateCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14846],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->22996]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SelectionEvaluateCreateCell - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 30.9151542}", "context" -> "System`", 
    "keywords" -> {
     "evaluate input cell", "notebook manipulation", "process input cell"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SelectionEvaluateCreateCell[notebook] takes the current selection in a \
notebook and creates a new cell containing the result obtained by evaluating \
the contents of the selection using the kernel. \
SelectionEvaluateCreateCell[notebook, sel] sets the current selection after \
the evaluation to be as specified by sel. ", 
    "synonyms" -> {"selection evaluate create cell"}, "title" -> 
    "SelectionEvaluateCreateCell", "type" -> "Symbol", "uri" -> 
    "ref/SelectionEvaluateCreateCell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5915, 200, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->71089375]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38589, 956}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1644, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2267, 67, 65, 1, 70, "ObjectName",
 CellID->14519],
Cell[2335, 70, 1158, 32, 70, "Usage",
 CellID->22426]
}, Open  ]],
Cell[CellGroupData[{
Cell[3530, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4008, 124, 375, 13, 70, "Notes",
 CellID->3418],
Cell[4386, 139, 281, 11, 70, "Notes",
 CellID->13713],
Cell[4670, 152, 180, 8, 70, "Notes",
 CellID->7801],
Cell[4853, 162, 459, 14, 70, "Notes",
 CellID->17740],
Cell[5315, 178, 563, 17, 70, "Notes",
 CellID->22940]
}, Closed]],
Cell[CellGroupData[{
Cell[5915, 200, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->71089375],
Cell[CellGroupData[{
Cell[6299, 214, 148, 5, 70, "ExampleSection",
 CellID->553888332],
Cell[6450, 221, 96, 1, 70, "ExampleText",
 CellID->715500508],
Cell[6549, 224, 512, 16, 70, "Input",
 CellID->413117256],
Cell[CellGroupData[{
Cell[7086, 244, 168, 5, 70, "Input",
 CellID->342462635],
Cell[7257, 251, 2607, 45, 70, "NotebookImage",
 CellID->7108619]
}, Open  ]],
Cell[CellGroupData[{
Cell[9901, 301, 123, 3, 70, "Input",
 CellID->17909343],
Cell[10027, 306, 3019, 52, 70, "NotebookImage",
 CellID->12757918]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13095, 364, 220, 7, 70, "ExampleSection",
 CellID->363698698],
Cell[13318, 373, 94, 1, 70, "ExampleText",
 CellID->652952756],
Cell[13415, 376, 512, 16, 70, "Input",
 CellID->767040395],
Cell[CellGroupData[{
Cell[13952, 396, 180, 6, 70, "Input",
 CellID->548591501],
Cell[14135, 404, 2479, 43, 70, "NotebookImage",
 CellID->177949869]
}, Open  ]],
Cell[16629, 450, 246, 7, 70, "ExampleText",
 CellID->364716244],
Cell[CellGroupData[{
Cell[16900, 461, 123, 3, 70, "Input",
 CellID->46264990],
Cell[17026, 466, 3020, 52, 70, "NotebookImage",
 CellID->459701387]
}, Open  ]],
Cell[20061, 521, 125, 3, 70, "ExampleDelimiter",
 CellID->297295393],
Cell[20189, 526, 65, 1, 70, "ExampleText",
 CellID->397346606],
Cell[20257, 529, 882, 25, 70, "Input",
 CellID->6509240],
Cell[CellGroupData[{
Cell[21164, 558, 152, 4, 70, "Input",
 CellID->245559868],
Cell[21319, 564, 3189, 54, 70, "NotebookImage",
 CellID->669761429]
}, Open  ]],
Cell[24523, 621, 95, 1, 70, "ExampleText",
 CellID->677476168],
Cell[CellGroupData[{
Cell[24643, 626, 124, 3, 70, "Input",
 CellID->350321110],
Cell[24770, 631, 4186, 71, 70, "NotebookImage",
 CellID->238042981]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29005, 708, 237, 7, 70, "ExampleSection",
 CellID->196593376],
Cell[29245, 717, 239, 7, 70, "ExampleText",
 CellID->380868350],
Cell[29487, 726, 511, 16, 70, "Input",
 CellID->18862177],
Cell[CellGroupData[{
Cell[30023, 746, 156, 4, 70, "Input",
 CellID->829826297],
Cell[30182, 752, 2430, 42, 70, "NotebookImage",
 CellID->743847037]
}, Open  ]],
Cell[CellGroupData[{
Cell[32649, 799, 114, 3, 70, "Input",
 CellID->128118575],
Cell[32766, 804, 2449, 42, 70, "NotebookImage",
 CellID->33455185]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35276, 853, 311, 9, 70, "SeeAlsoSection",
 CellID->19225],
Cell[35590, 864, 997, 35, 70, "SeeAlso",
 CellID->855]
}, Open  ]],
Cell[CellGroupData[{
Cell[36624, 904, 314, 9, 70, "TutorialsSection",
 CellID->14846],
Cell[36941, 915, 186, 4, 70, "Tutorials",
 CellID->22996]
}, Open  ]],
Cell[37142, 922, 27, 0, 70, "History"],
Cell[37172, 924, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

