(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23129,        879]
NotebookOptionsPosition[     17856,        693]
NotebookOutlinePosition[     19198,        731]
CellTagsIndexPosition[     19113,        726]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sequences" :> 
          Documentation`HelpLookup["paclet:tutorial/Sequences"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Sequences\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FlattenAt" :> Documentation`HelpLookup["paclet:ref/FlattenAt"],
           "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], 
          "SlotSequence" :> 
          Documentation`HelpLookup["paclet:ref/SlotSequence"], 
          "PatternSequence" :> 
          Documentation`HelpLookup["paclet:ref/PatternSequence"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "Listable" :> 
          Documentation`HelpLookup["paclet:ref/Listable"], "SequenceHold" :> 
          Documentation`HelpLookup["paclet:ref/SequenceHold"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FlattenAt\"\>", 
       2->"\<\"BlankSequence\"\>", 3->"\<\"SlotSequence\"\>", 
       4->"\<\"PatternSequence\"\>", 5->"\<\"List\"\>", 6->"\<\"Listable\"\>",
        7->"\<\"SequenceHold\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sequence", "ObjectName",
 CellID->16079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sequence"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a sequence of arguments to be spliced \
automatically into any function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6297]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects will automatically be flattened out in all functions except those \
with attribute ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2025],

Cell[TextData[{
 "Assignment and replacement functions have attribute ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26397]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166445161],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->210415891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " is automatically spliced in:"
}], "ExampleText",
 CellID->18348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17687],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136457668]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25538],

Cell["Replace with a sequence that is automatically spliced in:", \
"ExampleText",
 CellID->31506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "u", ",", "u"}], "}"}], "/.", 
  RowBox[{"u", "->", 
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "c", ",", "a", ",", "b", 
   ",", "c"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82697471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8950],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389077591]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"u", ",", "u", ",", "u"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "c", ",", "a", ",", "b", 
   ",", "c"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224084079]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17577],

Cell["\<\
Completely flatten out all lists in the argument to a function:\
\>", "ExampleText",
 CellID->26543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", "a", "}"}]}], "}"}], "]"}], "/.", 
  RowBox[{"List", "->", "Sequence"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10925],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "a"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495308529]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32216],

Cell[TextData[{
 "A sequence of arguments matched by __ is treated as a ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " object: "
}], "ExampleText",
 CellID->1112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x__", "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1471],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385156000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25118],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " represents sequences of arguments by ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->15545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"##", "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3905],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118687587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375950709],

Cell[TextData[{
 "A sequence with one argument acts like ",
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1647386192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", "b", "]"}], ",", "c", ",", 
   RowBox[{"Identity", "[", "d", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->956948707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->800996632]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9227],

Cell[TextData[{
 "Most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions automatically splice in ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->2371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2288],

Cell[BoxData[
 RowBox[{
  RowBox[{"Head", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Head\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Head::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->106101229],

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379279061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30594],

Cell[TextData[{
 "Assignment and replacement functions have the attribute ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "->", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11105],

Cell[BoxData[
 RowBox[{"u", "\[Rule]", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27244513]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31136],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlattenAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlattenAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/List"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Listable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Listable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SequenceHold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SequenceHold"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6282],

Cell[TextData[ButtonBox["Sequences",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Sequences"]], "Tutorials",
 CellID->21468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Sequence",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Sequence"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->32364587]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sequence - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 47.3218242}", "context" -> "System`", 
    "keywords" -> {
     "removing sublists", "runs of arguments", "splicing", "sublists", 
      "unpack", "headless lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sequence[expr_1, expr_2, ...] represents a sequence of arguments to be \
spliced automatically into any function. ", "synonyms" -> {}, "title" -> 
    "Sequence", "type" -> "Symbol", "uri" -> "ref/Sequence"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5166, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->166445161]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18970, 719}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2432, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3055, 85, 46, 1, 70, "ObjectName",
 CellID->16079],
Cell[3104, 88, 740, 23, 70, "Usage",
 CellID->6297]
}, Open  ]],
Cell[CellGroupData[{
Cell[3881, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4359, 133, 534, 18, 70, "Notes",
 CellID->2025],
Cell[4896, 153, 233, 8, 70, "Notes",
 CellID->26397]
}, Closed]],
Cell[CellGroupData[{
Cell[5166, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166445161],
Cell[CellGroupData[{
Cell[5551, 180, 148, 5, 70, "ExampleSection",
 CellID->210415891],
Cell[5702, 187, 202, 7, 70, "ExampleText",
 CellID->18348],
Cell[CellGroupData[{
Cell[5929, 198, 187, 6, 28, "Input",
 CellID->17687],
Cell[6119, 206, 228, 7, 36, "Output",
 CellID->136457668]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6396, 219, 216, 7, 70, "ExampleSection",
 CellID->25538],
Cell[6615, 228, 98, 2, 70, "ExampleText",
 CellID->31506],
Cell[CellGroupData[{
Cell[6738, 234, 240, 8, 70, "Input",
 CellID->9407],
Cell[6981, 244, 280, 9, 36, "Output",
 CellID->82697471]
}, Open  ]],
Cell[7276, 256, 121, 3, 70, "ExampleDelimiter",
 CellID->21902],
Cell[CellGroupData[{
Cell[7422, 263, 156, 5, 70, "Input",
 CellID->8950],
Cell[7581, 270, 226, 7, 36, "Output",
 CellID->389077591]
}, Open  ]],
Cell[CellGroupData[{
Cell[7844, 282, 121, 4, 70, "Input",
 CellID->18523],
Cell[7968, 288, 281, 9, 36, "Output",
 CellID->224084079]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8298, 303, 223, 7, 70, "ExampleSection",
 CellID->17577],
Cell[8524, 312, 110, 3, 70, "ExampleText",
 CellID->26543],
Cell[CellGroupData[{
Cell[8659, 319, 342, 12, 70, "Input",
 CellID->10925],
Cell[9004, 333, 239, 7, 36, "Output",
 CellID->495308529]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9292, 346, 233, 7, 70, "ExampleSection",
 CellID->32216],
Cell[9528, 355, 240, 8, 70, "ExampleText",
 CellID->1112],
Cell[CellGroupData[{
Cell[9793, 367, 205, 7, 70, "Input",
 CellID->1471],
Cell[10001, 376, 226, 7, 36, "Output",
 CellID->385156000]
}, Open  ]],
Cell[10242, 386, 121, 3, 70, "ExampleDelimiter",
 CellID->25118],
Cell[10366, 391, 264, 9, 70, "ExampleText",
 CellID->15545],
Cell[CellGroupData[{
Cell[10655, 404, 144, 5, 70, "Input",
 CellID->3905],
Cell[10802, 411, 226, 7, 36, "Output",
 CellID->118687587]
}, Open  ]],
Cell[11043, 421, 125, 3, 70, "ExampleDelimiter",
 CellID->375950709],
Cell[11171, 426, 223, 8, 70, "ExampleText",
 CellID->1647386192],
Cell[CellGroupData[{
Cell[11419, 438, 207, 6, 70, "Input",
 CellID->956948707],
Cell[11629, 446, 223, 7, 36, "Output",
 CellID->800996632]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11901, 459, 225, 7, 70, "ExampleSection",
 CellID->9227],
Cell[12129, 468, 280, 11, 70, "ExampleText",
 CellID->2371],
Cell[CellGroupData[{
Cell[12434, 483, 154, 5, 70, "Input",
 CellID->2288],
Cell[12591, 490, 391, 8, 70, "Message",
 CellID->106101229],
Cell[12985, 500, 211, 7, 36, "Output",
 CellID->379279061]
}, Open  ]],
Cell[13211, 510, 121, 3, 70, "ExampleDelimiter",
 CellID->30594],
Cell[13335, 515, 242, 8, 70, "ExampleText",
 CellID->3836],
Cell[CellGroupData[{
Cell[13602, 527, 148, 5, 70, "Input",
 CellID->11105],
Cell[13753, 534, 245, 8, 36, "Output",
 CellID->27244513]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14059, 549, 311, 9, 70, "SeeAlsoSection",
 CellID->31136],
Cell[14373, 560, 1708, 62, 70, "SeeAlso",
 CellID->512]
}, Open  ]],
Cell[CellGroupData[{
Cell[16118, 627, 313, 9, 70, "TutorialsSection",
 CellID->6282],
Cell[16434, 638, 129, 3, 70, "Tutorials",
 CellID->21468]
}, Open  ]],
Cell[CellGroupData[{
Cell[16600, 646, 305, 8, 70, "RelatedLinksSection"],
Cell[16908, 656, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17306, 673, 299, 8, 70, "MoreAboutSection"],
Cell[17608, 683, 176, 3, 70, "MoreAbout",
 CellID->32364587]
}, Open  ]],
Cell[17799, 689, 27, 0, 70, "History"],
Cell[17829, 691, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

