(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16883,        625]
NotebookOptionsPosition[     12697,        484]
NotebookOutlinePosition[     14059,        521]
CellTagsIndexPosition[     13974,        516]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HoldAll" :> Documentation`HelpLookup["paclet:ref/HoldAll"], 
          "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HoldAll\"\>", 
       2->"\<\"HoldAllComplete\"\>", 
       3->"\<\"Sequence\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SequenceHold", "ObjectName",
 CellID->20737],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SequenceHold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that ",
     Cell[BoxData[
      ButtonBox["Sequence",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
     " objects appearing in the arguments of a function should not \
automatically be flattened out. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " prevents ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects from being flattened out. "
}], "Notes",
 CellID->8689]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->884812412],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->653132700],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"h", ",", "SequenceHold"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669289317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->474813205],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18252503]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18326825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " does not prevent splicing of sequences:"
}], "ExampleText",
 CellID->78960369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9955774],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219134473]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 " is also necessary:"
}], "ExampleText",
 CellID->34296518],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"h", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "SequenceHold"}], "}"}]}], "]"}], ";"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->627739215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58937452],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2447153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305511884],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " implies ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->54914271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->948346367],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734100474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287445162],

Cell[TextData[{
 "Assignment operators are ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 ", so that sequences can be returned as results:"
}], "ExampleText",
 CellID->412793408],

Cell[BoxData[
 RowBox[{
  RowBox[{"splice", "[", "x_", "]"}], ":=", 
  RowBox[{"Sequence", "[", 
   RowBox[{"x", ",", "x", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533105063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"splice", "[", "b", "]"}], ",", "c"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->495835327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "b", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132572390]
}, Open  ]],

Cell["Rules have the same property:", "ExampleText",
 CellID->160286239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "1", "]"}], ",", 
    RowBox[{"g", "[", "2", "]"}], ",", 
    RowBox[{"h", "[", "3", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "\[RuleDelayed]", 
   RowBox[{"Sequence", "[", 
    RowBox[{"x", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->392096532],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", "2", ",", "2", ",", 
   RowBox[{"h", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->432352089]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3822],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAllComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAllComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9099],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->19426],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->10073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->45490349],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->44841553]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SequenceHold - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 46.4311764}", "context" -> "System`", 
    "keywords" -> {"attribute", "evaluation control", "sequence", "splicing"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SequenceHold is an attribute which specifies that Sequence objects \
appearing in the arguments of a function should not automatically be \
flattened out. ", "synonyms" -> {"sequence hold"}, "title" -> "SequenceHold", 
    "type" -> "Symbol", "uri" -> "ref/SequenceHold"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4483, 143, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->884812412]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13831, 509}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2220, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2843, 81, 50, 1, 70, "ObjectName",
 CellID->20737],
Cell[2896, 84, 667, 19, 70, "Usage",
 CellID->14015]
}, Open  ]],
Cell[CellGroupData[{
Cell[3600, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4078, 125, 368, 13, 70, "Notes",
 CellID->8689]
}, Closed]],
Cell[CellGroupData[{
Cell[4483, 143, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->884812412],
Cell[CellGroupData[{
Cell[4868, 157, 148, 5, 70, "ExampleSection",
 CellID->653132700],
Cell[5019, 164, 162, 5, 70, "Input",
 CellID->669289317],
Cell[CellGroupData[{
Cell[5206, 173, 181, 6, 28, "Input",
 CellID->474813205],
Cell[5390, 181, 269, 9, 36, "Output",
 CellID->18252503]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5708, 196, 236, 7, 70, "ExampleSection",
 CellID->18326825],
Cell[5947, 205, 214, 7, 70, "ExampleText",
 CellID->78960369],
Cell[CellGroupData[{
Cell[6186, 216, 182, 6, 70, "Input",
 CellID->9955774],
Cell[6371, 224, 221, 7, 36, "Output",
 CellID->219134473]
}, Open  ]],
Cell[6607, 234, 203, 7, 70, "ExampleText",
 CellID->34296518],
Cell[6813, 243, 221, 8, 70, "Input",
 CellID->627739215],
Cell[CellGroupData[{
Cell[7059, 255, 180, 6, 70, "Input",
 CellID->58937452],
Cell[7242, 263, 268, 9, 36, "Output",
 CellID->2447153]
}, Open  ]],
Cell[7525, 275, 125, 3, 70, "ExampleDelimiter",
 CellID->305511884],
Cell[7653, 280, 332, 12, 70, "ExampleText",
 CellID->54914271],
Cell[CellGroupData[{
Cell[8010, 296, 192, 6, 70, "Input",
 CellID->948346367],
Cell[8205, 304, 281, 9, 36, "Output",
 CellID->734100474]
}, Open  ]],
Cell[8501, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->287445162],
Cell[8629, 321, 262, 8, 70, "ExampleText",
 CellID->412793408],
Cell[8894, 331, 196, 6, 70, "Input",
 CellID->533105063],
Cell[CellGroupData[{
Cell[9115, 341, 159, 5, 70, "Input",
 CellID->495835327],
Cell[9277, 348, 233, 7, 36, "Output",
 CellID->132572390]
}, Open  ]],
Cell[9525, 358, 72, 1, 70, "ExampleText",
 CellID->160286239],
Cell[CellGroupData[{
Cell[9622, 363, 367, 12, 70, "Input",
 CellID->392096532],
Cell[9992, 377, 282, 9, 36, "Output",
 CellID->432352089]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10335, 393, 310, 9, 70, "SeeAlsoSection",
 CellID->3822],
Cell[10648, 404, 708, 26, 70, "SeeAlso",
 CellID->21363]
}, Open  ]],
Cell[CellGroupData[{
Cell[11393, 435, 313, 9, 70, "TutorialsSection",
 CellID->9099],
Cell[11709, 446, 131, 3, 70, "Tutorials",
 CellID->19426],
Cell[11843, 451, 163, 3, 70, "Tutorials",
 CellID->10073]
}, Open  ]],
Cell[CellGroupData[{
Cell[12043, 459, 299, 8, 70, "MoreAboutSection"],
Cell[12345, 469, 131, 3, 70, "MoreAbout",
 CellID->45490349],
Cell[12479, 474, 146, 3, 70, "MoreAbout",
 CellID->44841553]
}, Open  ]],
Cell[12640, 480, 27, 0, 70, "History"],
Cell[12670, 482, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

