(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39365,       1507]
NotebookOptionsPosition[     30481,       1190]
NotebookOutlinePosition[     31837,       1228]
CellTagsIndexPosition[     31751,       1223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"], "SetPrecision" :> 
          Documentation`HelpLookup["paclet:ref/SetPrecision"], "AccuracyGoal" :> 
          Documentation`HelpLookup["paclet:ref/AccuracyGoal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"N\"\>", 2->"\<\"Accuracy\"\>", 
       3->"\<\"SetPrecision\"\>", 
       4->"\<\"AccuracyGoal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetAccuracy", "ObjectName",
 CellID->30231],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetAccuracy",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetAccuracy"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in which all numbers have been set to have accuracy ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " is used to increase the accuracy of a number, the number is padded with \
zeros. The zeros are taken to be in base 2. In base 10, the additional digits \
are usually not zeros. "
}], "Notes",
 CellID->5994],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " returns an arbitrary\[Hyphen]precision number even if the number of \
significant digits obtained will be less than ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29079],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " contains machine\[Hyphen]precision numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " can give results which differ from one computer system to another. "
}], "Notes",
 CellID->560],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " will first expose any hidden extra digits in the internal binary \
representation of a number, and only after these are exhausted add trailing \
zeros. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->887508004]
}], "Notes",
 CellID->8053],

Cell[TextData[{
 Cell[BoxData["0.004``25"], "InlineFormula"],
 " generates a number with all trailing digits zero and accuracy 25 on any \
computer system. "
}], "Notes",
 CellID->5418],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " does not modify ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " itself. "
}], "Notes",
 CellID->23409]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103362166],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->209655508],

Cell["Set the accuracy of all numbers in an expression to 20:", "ExampleText",
 CellID->22625496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"2", " ", "b"}], "+", 
    RowBox[{"3", " ", "c"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494345586],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"2.`20.30102999566398", " ", "b"}], "+", 
  RowBox[{"3.`20.477121254719666", " ", "c"}]}]], "Output",
 ImageSize->{358, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164382646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47648355],

Cell["\<\
Convert from a machine number to an arbitrary-precision number with accuracy \
32:\
\>", "ExampleText",
 CellID->421486768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{"1234.5678", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341685248],

Cell[BoxData["1234.56780000000003383320290595293045043945`23.091514945509203"]\
, "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300188478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->369580941],

Cell[BoxData["20.000000000000007`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->880831237]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11908],

Cell["Set the accuracy of a complex number:", "ExampleText",
 CellID->151942879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{
   RowBox[{"Pi", "+", "I"}], ",", "24"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17190504],

Cell[BoxData[
 RowBox[{"3.14159265358979323846264338358225590325`24.264889185188263", "+", 
  RowBox[{"1.`24.15051499783199", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219016737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2166399],

Cell["Convert approximate numbers to exact rational numbers:", "ExampleText",
 CellID->425008561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{".1", ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "10"}], ",", "30"}], "]"}], ",", "0."}], "]"}], ",", 
   "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154567095],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   FractionBox["3602879701896397", "36028797018963968"], ",", 
   FractionBox["1014120480182583521197362564301", 
    "10141204801825835211973625643008"], ",", "0"}], "]"}]], "Output",
 ImageSize->{438, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380118818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->358479482],

Cell["\<\
The result has trailing zeros once any hidden digits are exposed:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->887508004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"SetAccuracy", "[", 
       RowBox[{"3.14", ",", "p"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "15", ",", "65", ",", "5"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36450738],

Cell[BoxData[
 TagBox[GridBox[{
    {"15", "3.14000000000000012434497875802`15.496929648073214"},
    {"20", "3.14000000000000012434497875801753252745`20.49692964807322"},
    {"25", "3.14000000000000012434497875801753252745`25.496929648073216"},
    {"30", 
     "3.140000000000000124344978758017532527446746826172`30.496929648073216"},\

    {"35", 
     "3.140000000000000124344978758017532527446746826172`35.49692964807322"},
    {"40", 
     "3.140000000000000124344978758017532527446746826171875`40.\
49692964807322"},
    {"45", 
     "3.140000000000000124344978758017532527446746826171875`45.\
49692964807321"},
    {"50", 
     "3.140000000000000124344978758017532527446746826171875`50.\
49692964807321"},
    {"55", 
     "3.140000000000000124344978758017532527446746826171875`55.\
49692964807321"},
    {"60", 
     "3.140000000000000124344978758017532527446746826171875`60.\
49692964807322"},
    {"65", 
     "3.140000000000000124344978758017532527446746826171875`65.\
49692964807322"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{495, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->878737587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5689857],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " does not affect exact powers:"
}], "ExampleText",
 CellID->130001812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "Pi"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"9", "/", "2"}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131579108],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", "x"}], ")"}], 
  RowBox[{"9", "/", "2"}]]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18945149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{"p", ",", "18"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204178113],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"3.14159265358979323846264338358`18.49714987269413", "+", "x"}], 
   ")"}], 
  RowBox[{"9", "/", "2"}]]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->477230337]
}, Open  ]],

Cell["\<\
This allows you to, for example, change the accuracy of polynomial \
coefficients:\
\>", "ExampleText",
 CellID->339824124],

Cell[BoxData[
 RowBox[{
  RowBox[{"poly", " ", "=", " ", 
   RowBox[{"1.", "+", 
    RowBox[{"2.", " ", "x"}], "+", 
    RowBox[{"3.", " ", 
     RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
    RowBox[{"4.", " ", 
     RowBox[{"x", "^", "3"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204415072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{"poly", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2251635],

Cell[BoxData[
 RowBox[{"1.`20.", "+", 
  RowBox[{"2.`20.30102999566398", " ", "x"}], "+", 
  RowBox[{"3.`20.477121254719666", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"4.`20.602059991327963", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{356, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->245798609]
}, Open  ]],

Cell["Inexact powers are modified:", "ExampleText",
 CellID->714826500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{
   RowBox[{"x", "^", "1.25"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->990699132],

Cell[BoxData[
 SuperscriptBox["x", "1.25`20.09691001300806"]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->238315374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->611486652],

Cell["Special rules may apply to data objects:", "ExampleText",
 CellID->104526397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224545791],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343505253]
}, Open  ]],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " changes the appropriate data only:"
}], "ExampleText",
 CellID->75833920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spifun", "=", 
  RowBox[{"SetAccuracy", "[", 
   RowBox[{"ifun", ",", " ", "20"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163565914],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`20.", ",", "4.`20.602059991327963"}], "}"}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->431950196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "spifun", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->418717252],

Cell["\<\
InterpolatingFunction[{{1.`20., 4.`20.602059991327963}}, 
 {3, 1, 0, {4}, {4}, 0, 0, 0, 0}, 
 {{1.`20., 2.`20.30102999566398, 3.`20.477121254719666, 
   4.`20.602059991327963}}, {{0``20.}, {0``20.}, {1.`20.}, {1.`20.}}, 
 {Automatic}]\
\>", "Output",
 ImageSize->{490, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->280933259]
}, Open  ]],

Cell["\<\
It works as an approximate function, but with arithmetic appropriate for the \
modified data:\
\>", "ExampleText",
 CellID->610494590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ifun", "[", 
    RowBox[{"5", "/", "3"}], "]"}], ",", 
   RowBox[{"spifun", "[", 
    RowBox[{"5", "/", "3"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114149674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["17", "81"]}], ",", 
   RowBox[{
   "-", "0.20987654320987654320987654320021543188`18.65545362554794"}]}], 
  "}"}]], "Output",
 ImageSize->{210, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->72933898]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20009],

Cell["\<\
Find the roundoff error in evaluating an expression with machine numbers:\
\>", "ExampleText",
 CellID->7964734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", "1.00000000001", "]"}], "-", 
      RowBox[{"Sin", "[", "1.0", "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1.00000000001", "-", "1.0"}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174521820],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", "1.00000000001`", "]"}], "-", 
    RowBox[{"Sin", "[", "1.`", "]"}]}], 
   RowBox[{"1.00000000001`", "\[InvisibleSpace]", "-", "1.`"}]], 
  "]"}]], "Output",
 ImageSize->{161, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97455568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"em", "=", 
  RowBox[{"ReleaseHold", "[", "e", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57915616],

Cell[BoxData["0.5403010924593658`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->679173116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eb", "=", 
  RowBox[{"ReleaseHold", "[", 
   RowBox[{"SetAccuracy", "[", 
    RowBox[{"e", ",", "32"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83770256],

Cell[BoxData["0.54030230586393236212877001253001161457`20.255127775538927"], \
"Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->210961066]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eb", "-", "em"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->145020504],

Cell[BoxData["1.2134045666023496`*^-6"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->543579283]
}, Open  ]],

Cell["\<\
This dominates the approximation error since the increment is so small:\
\>", "ExampleText",
 CellID->223682179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eb", "-", 
  RowBox[{"Cos", "[", "1", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->69859798],

Cell[BoxData[
 RowBox[{"-", 
  "4.20735527216659491296498917`9.146500140254668*^-12"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->452863647]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23681],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " just sets the precision of numbers while ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " works adaptively:"
}], "ExampleText",
 CellID->510650057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "10", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159893285],

Cell[BoxData["22026.46579480671651695790064528424436635351`24.34294481903252"]\
, "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84742921]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " works adaptively, the result has the requested accuracy of 20:"
}], "ExampleText",
 CellID->31729705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91626485],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181354387]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->614974970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "10", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->94070248],

Cell[BoxData["22026.46579480671651695790064528424`20.000000000000007"], \
"Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->142242844]
}, Open  ]],

Cell["\<\
The accuracy is less than 20 because of the way the exponential function \
magnifies the result:\
\>", "ExampleText",
 CellID->140663544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->456935483],

Cell[BoxData["15.657055180967486`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1293200]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 " effectively evaluates ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " with argument 10 to accuracy 20:"
}], "ExampleText",
 CellID->263521656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "10``20", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->76406173],

Cell[BoxData["22026.46579480671651695790064528424`20.000000000000007"], \
"Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->55765851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28730151],

Cell[TextData[{
 "For nonzero numbers ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{
     StyleBox["a", "TI"], "+", 
     StyleBox["e", "TI"]}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36559098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xl", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "4", ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}], "*", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", "9"}], "}"}], ",", "4"}], 
     "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29057728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00055458180782743227486510833104671469`20.", ",", 
   "4.326056361110426151872975983337`20.*^-8", ",", 
   "7.91521329519527488502331040443049659`20.*^6", ",", 
   "3.23808567096499212348672050443`20.*^-9"}], "}"}]], "Output",
 ImageSize->{390, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98053193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SetAccuracy", "[", 
     RowBox[{"#", ",", "20"}], "]"}], "&"}], ",", "xl"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->493864621],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00055458180782743227486510833104671469`16.743965619137004", ",", 
   "4.326056361110426151872975983337`12.636092173253743*^-8", ",", 
   "7.91521329519527488502331040443049658961172099`26.89846262250579*^6", ",",
    "3.23808567096499212348672050443`11.510288334823521*^-9"}], 
  "}"}]], "Output",
 ImageSize->{369, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->462831062]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  ButtonBox["RealExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealExponent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->400561056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SetPrecision", "[", 
     RowBox[{"#", ",", 
      RowBox[{"20", "+", 
       RowBox[{"RealExponent", "[", "#", "]"}]}]}], "]"}], "&"}], ",", "xl"}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->33293281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00055458180782743227486510833104671469`16.743965619137", ",", 
   "4.326056361110426151872975983337`12.636092173253743*^-8", ",", 
   "7.91521329519527488502331040443049658961172099`26.89846262250579*^6", ",",
    "3.23808567096499212348672050443`11.510288334823521*^-9"}], 
  "}"}]], "Output",
 ImageSize->{369, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->596009220]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16192],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8858],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "Tutorials",
 CellID->3736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->29569181],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->231670183]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetAccuracy - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 55.3532798}", "context" -> "System`", 
    "keywords" -> {
     "increase accuracy", "modify accuracy", "override precision model", 
      "override accuracy model"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SetAccuracy[expr, a] yields a version of expr in which all numbers have \
been set to have accuracy a. ", "synonyms" -> {"set accuracy"}, "title" -> 
    "SetAccuracy", "type" -> "Symbol", "uri" -> "ref/SetAccuracy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6304, 211, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->103362166]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31608, 1216}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2117, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2740, 79, 49, 1, 70, "ObjectName",
 CellID->30231],
Cell[2792, 82, 731, 23, 70, "Usage",
 CellID->27739]
}, Open  ]],
Cell[CellGroupData[{
Cell[3560, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4038, 127, 360, 10, 70, "Notes",
 CellID->5994],
Cell[4401, 139, 434, 13, 70, "Notes",
 CellID->29079],
Cell[4838, 154, 459, 15, 70, "Notes",
 CellID->560],
Cell[5300, 171, 412, 12, 70, "Notes",
 CellID->8053],
Cell[5715, 185, 185, 5, 70, "Notes",
 CellID->5418],
Cell[5903, 192, 364, 14, 70, "Notes",
 CellID->23409]
}, Closed]],
Cell[CellGroupData[{
Cell[6304, 211, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103362166],
Cell[CellGroupData[{
Cell[6689, 225, 148, 5, 70, "ExampleSection",
 CellID->209655508],
Cell[6840, 232, 97, 1, 70, "ExampleText",
 CellID->22625496],
Cell[CellGroupData[{
Cell[6962, 237, 215, 7, 28, "Input",
 CellID->494345586],
Cell[7180, 246, 276, 8, 36, "Output",
 CellID->164382646]
}, Open  ]],
Cell[7471, 257, 124, 3, 70, "ExampleDelimiter",
 CellID->47648355],
Cell[7598, 262, 133, 4, 70, "ExampleText",
 CellID->421486768],
Cell[CellGroupData[{
Cell[7756, 270, 139, 4, 70, "Input",
 CellID->341685248],
Cell[7898, 276, 222, 6, 36, "Output",
 CellID->300188478]
}, Open  ]],
Cell[CellGroupData[{
Cell[8157, 287, 104, 3, 70, "Input",
 CellID->369580941],
Cell[8264, 292, 176, 5, 36, "Output",
 CellID->880831237]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8489, 303, 216, 7, 70, "ExampleSection",
 CellID->11908],
Cell[8708, 312, 80, 1, 70, "ExampleText",
 CellID->151942879],
Cell[CellGroupData[{
Cell[8813, 317, 155, 5, 70, "Input",
 CellID->17190504],
Cell[8971, 324, 293, 7, 36, "Output",
 CellID->219016737]
}, Open  ]],
Cell[9279, 334, 123, 3, 70, "ExampleDelimiter",
 CellID->2166399],
Cell[9405, 339, 97, 1, 70, "ExampleText",
 CellID->425008561],
Cell[CellGroupData[{
Cell[9527, 344, 295, 10, 70, "Input",
 CellID->154567095],
Cell[9825, 356, 360, 10, 51, "Output",
 CellID->380118818]
}, Open  ]],
Cell[10200, 369, 125, 3, 70, "ExampleDelimiter",
 CellID->358479482],
Cell[10328, 374, 164, 4, 70, "ExampleText",
 CellID->887508004],
Cell[CellGroupData[{
Cell[10517, 382, 360, 12, 70, "Input",
 CellID->36450738],
Cell[10880, 396, 1598, 45, 198, "Output",
 CellID->878737587]
}, Open  ]],
Cell[12493, 444, 123, 3, 70, "ExampleDelimiter",
 CellID->5689857],
Cell[12619, 449, 213, 7, 70, "ExampleText",
 CellID->130001812],
Cell[CellGroupData[{
Cell[12857, 460, 224, 8, 70, "Input",
 CellID->131579108],
Cell[13084, 470, 254, 9, 36, "Output",
 CellID->18945149]
}, Open  ]],
Cell[CellGroupData[{
Cell[13375, 484, 131, 4, 70, "Input",
 CellID->204178113],
Cell[13509, 490, 304, 10, 36, "Output",
 CellID->477230337]
}, Open  ]],
Cell[13828, 503, 133, 4, 70, "ExampleText",
 CellID->339824124],
Cell[13964, 509, 308, 10, 70, "Input",
 CellID->204415072],
Cell[CellGroupData[{
Cell[14297, 523, 132, 4, 70, "Input",
 CellID->2251635],
Cell[14432, 529, 384, 11, 54, "Output",
 CellID->245798609]
}, Open  ]],
Cell[14831, 543, 71, 1, 70, "ExampleText",
 CellID->714826500],
Cell[CellGroupData[{
Cell[14927, 548, 158, 5, 70, "Input",
 CellID->990699132],
Cell[15088, 555, 203, 6, 36, "Output",
 CellID->238315374]
}, Open  ]],
Cell[15306, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->611486652],
Cell[15434, 569, 83, 1, 70, "ExampleText",
 CellID->104526397],
Cell[CellGroupData[{
Cell[15542, 574, 214, 6, 70, "Input",
 CellID->224545791],
Cell[15759, 582, 356, 13, 36, "Output",
 CellID->343505253]
}, Open  ]],
Cell[16130, 598, 388, 13, 70, "ExampleText",
 CellID->75833920],
Cell[CellGroupData[{
Cell[16543, 615, 168, 5, 70, "Input",
 CellID->163565914],
Cell[16714, 622, 386, 14, 36, "Output",
 CellID->431950196]
}, Open  ]],
Cell[CellGroupData[{
Cell[17137, 641, 110, 3, 70, "Input",
 CellID->418717252],
Cell[17250, 646, 402, 11, 114, "Output",
 CellID->280933259]
}, Open  ]],
Cell[17667, 660, 144, 4, 70, "ExampleText",
 CellID->610494590],
Cell[CellGroupData[{
Cell[17836, 668, 231, 8, 70, "Input",
 CellID->114149674],
Cell[18070, 678, 330, 12, 51, "Output",
 CellID->72933898]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18449, 696, 223, 7, 70, "ExampleSection",
 CellID->20009],
Cell[18675, 705, 122, 3, 70, "ExampleText",
 CellID->7964734],
Cell[CellGroupData[{
Cell[18822, 712, 345, 11, 70, "Input",
 CellID->174521820],
Cell[19170, 725, 375, 12, 51, "Output",
 CellID->97455568]
}, Open  ]],
Cell[CellGroupData[{
Cell[19582, 742, 130, 4, 70, "Input",
 CellID->57915616],
Cell[19715, 748, 176, 5, 36, "Output",
 CellID->679173116]
}, Open  ]],
Cell[CellGroupData[{
Cell[19928, 758, 195, 6, 70, "Input",
 CellID->83770256],
Cell[20126, 766, 219, 6, 36, "Output",
 CellID->210961066]
}, Open  ]],
Cell[CellGroupData[{
Cell[20382, 777, 94, 3, 70, "Input",
 CellID->145020504],
Cell[20479, 782, 180, 5, 36, "Output",
 CellID->543579283]
}, Open  ]],
Cell[20674, 790, 122, 3, 70, "ExampleText",
 CellID->223682179],
Cell[CellGroupData[{
Cell[20821, 797, 122, 4, 70, "Input",
 CellID->69859798],
Cell[20946, 803, 229, 7, 36, "Output",
 CellID->452863647]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21224, 816, 233, 7, 70, "ExampleSection",
 CellID->23681],
Cell[21460, 825, 353, 12, 70, "ExampleText",
 CellID->510650057],
Cell[CellGroupData[{
Cell[21838, 841, 212, 7, 70, "Input",
 CellID->159893285],
Cell[22053, 850, 221, 6, 36, "Output",
 CellID->84742921]
}, Open  ]],
Cell[22289, 859, 236, 8, 70, "ExampleText",
 CellID->31729705],
Cell[CellGroupData[{
Cell[22550, 871, 103, 3, 70, "Input",
 CellID->91626485],
Cell[22656, 876, 161, 5, 36, "Output",
 CellID->181354387]
}, Open  ]],
Cell[22832, 884, 193, 8, 70, "ExampleText",
 CellID->614974970],
Cell[CellGroupData[{
Cell[23050, 896, 162, 5, 70, "Input",
 CellID->94070248],
Cell[23215, 903, 214, 6, 36, "Output",
 CellID->142242844]
}, Open  ]],
Cell[23444, 912, 147, 4, 70, "ExampleText",
 CellID->140663544],
Cell[CellGroupData[{
Cell[23616, 920, 104, 3, 70, "Input",
 CellID->456935483],
Cell[23723, 925, 174, 5, 36, "Output",
 CellID->1293200]
}, Open  ]],
Cell[23912, 933, 353, 12, 70, "ExampleText",
 CellID->263521656],
Cell[CellGroupData[{
Cell[24290, 949, 103, 3, 70, "Input",
 CellID->76406173],
Cell[24396, 954, 213, 6, 36, "Output",
 CellID->55765851]
}, Open  ]],
Cell[24624, 963, 124, 3, 70, "ExampleDelimiter",
 CellID->28730151],
Cell[24751, 968, 671, 26, 70, "ExampleText",
 CellID->36559098],
Cell[CellGroupData[{
Cell[25447, 998, 414, 14, 70, "Input",
 CellID->29057728],
Cell[25864, 1014, 401, 11, 58, "Output",
 CellID->98053193]
}, Open  ]],
Cell[CellGroupData[{
Cell[26302, 1030, 209, 7, 70, "Input",
 CellID->493864621],
Cell[26514, 1039, 473, 12, 58, "Output",
 CellID->462831062]
}, Open  ]],
Cell[27002, 1054, 261, 10, 70, "ExampleText",
 CellID->400561056],
Cell[CellGroupData[{
Cell[27288, 1068, 283, 10, 70, "Input",
 CellID->33293281],
Cell[27574, 1080, 470, 12, 58, "Output",
 CellID->596009220]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28105, 1099, 311, 9, 70, "SeeAlsoSection",
 CellID->16192],
Cell[28419, 1110, 942, 35, 70, "SeeAlso",
 CellID->8140]
}, Open  ]],
Cell[CellGroupData[{
Cell[29398, 1150, 313, 9, 70, "TutorialsSection",
 CellID->8858],
Cell[29714, 1161, 170, 3, 70, "Tutorials",
 CellID->3736]
}, Open  ]],
Cell[CellGroupData[{
Cell[29921, 1169, 318, 9, 70, "MoreAboutSection",
 CellID->29569181],
Cell[30242, 1180, 167, 3, 70, "MoreAbout",
 CellID->231670183]
}, Open  ]],
Cell[30424, 1186, 27, 0, 70, "History"],
Cell[30454, 1188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

