(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31902,       1204]
NotebookOptionsPosition[     24494,        951]
NotebookOutlinePosition[     25909,        990]
CellTagsIndexPosition[     25824,        985]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat and Orderless Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FlatAndOrderlessFunctions"], "Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flat and Orderless Functions\"\>", 
       2->"\<\"Attributes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:ref/Attributes"], 
          "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"], "Protect" :> 
          Documentation`HelpLookup["paclet:ref/Protect"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 2->"\<\"ClearAttributes\"\>", 
       3->"\<\"Protect\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetAttributes", "ObjectName",
 CellID->7340],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetAttributes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetAttributes"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["attr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]adds ",
     Cell[BoxData[
      StyleBox["attr", "TI"]], "InlineFormula"],
     " to the list of attributes of the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " modifies ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15114],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAttributes"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " sets several attributes at a time. "
}], "Notes",
 CellID->20847],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAttributes"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["attrs", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " sets attributes of several symbols at a time. "
}], "Notes",
 CellID->5125],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163006054],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->240190322],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "HoldAll"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122255626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38326916],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234947777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->345069801],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"plus", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239033828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plus", "[", 
  RowBox[{"a", ",", 
   RowBox[{"plus", "[", 
    RowBox[{"c", ",", "b"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269469891],

Cell[BoxData[
 RowBox[{"plus", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32947884]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9198436],

Cell["Add an attribute to the list of attributes of a symbol:", "ExampleText",
 CellID->107071202],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Flat"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37003670],

Cell["Add more attributes; the previous ones are retained:", "ExampleText",
 CellID->155016438],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Orderless"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143276658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->527160259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "Orderless"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19176368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386106549],

Cell["Add several attributes:", "ExampleText",
 CellID->112379551],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"HoldAll", ",", "Protected"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316988704],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134526356],

Cell["Add the same attributes to several symbols:", "ExampleText",
 CellID->345026556],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"HoldFirst", ",", "NHoldFirst"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368338055]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->396153603],

Cell[TextData[{
 "Set a single attribute for the symbols ",
 Cell[BoxData["f"], "InlineFormula"],
 " and ",
 Cell[BoxData["g"], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->464779181],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "f", "]"}], "=", "Listable"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "g", "]"}], "=", "Listable"}], ";"}]}], "Input",\

 CellLabel->"In[1]:=",
 CellID->162615976],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " adds to the already existing attributes, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Attributes", "[", "g", "]"}], "=", 
   RowBox[{"{", "..", "}"}]}]], "InlineFormula"],
 " resets the list:"
}], "ExampleText",
 CellID->1032991489],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "HoldAll"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "g", "]"}], "=", "HoldAll"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->673722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112979945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"HoldAll", ",", "Listable"}], "}"}], ",", 
   RowBox[{"{", "HoldAll", "}"}]}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->134784643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191569131],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " is equivalent to this assignment to the attributes:"
}], "ExampleText",
 CellID->21085966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "f", "]"}], "=", 
  RowBox[{"Union", "[", 
   RowBox[{
    RowBox[{"Attributes", "[", "f", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"HoldFirst", ",", "NHoldFirst"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30647318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "NHoldFirst"}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->640087322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->565970934],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " to clear a particular attribute:"
}], "ExampleText",
 CellID->238935581],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "Orderless", ",", "OneIdentity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7697168],

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"f", ",", "OneIdentity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245733668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->260783577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "Orderless"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->204492869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228205649],

Cell[TextData[{
 "Protecting a symbol is equivalent to setting the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->52594906],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->634542146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->491598477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}]}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54069724]
}, Open  ]],

Cell["You can still change the attributes of a protected symbol:", \
"ExampleText",
 CellID->129011084],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"f", ",", "Protected"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Unprotect", "[", "g", "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->133721907],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138682355],

Cell[TextData[{
 "After setting the attribute ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 ", no more changes to the attributes can be made:"
}], "ExampleText",
 CellID->482908561],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Locked", ",", "Protected"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->513627669],

Cell[TextData[{
 "A locked symbol can no longer be unprotected, as the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute cannot be cleared:"
}], "ExampleText",
 CellID->487735713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112795446],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "::", "\<\"locked\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is locked.\"\>"}]], "Message", "MSG",
 CellID->409713807],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80421344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61145867],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->44046302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "SetAttributes", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281343092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149549172]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"syms", "=", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6852680],

Cell[TextData[{
 "This sets attributes of the symbol ",
 Cell[BoxData["syms"], "InlineFormula"],
 " itself:"
}], "ExampleText",
 CellID->662401302],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"syms", ",", "Protected"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112037164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "syms", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->413448229],

Cell[BoxData[
 RowBox[{"{", "Protected", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->34313981]
}, Open  ]],

Cell[TextData[{
 "This sets the attributes of all symbols in the list ",
 Cell[BoxData["syms"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141994131],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "syms", "]"}], ",", "Protected"}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->248856248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g", ",", "h"}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->157521117],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}]}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->391638805]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->579362210],

Cell["The 10 system symbols with the most attributes:", "ExampleText",
 CellID->394708694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Take", "[", 
    RowBox[{
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"Attributes", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ">", 
         RowBox[{"Length", "[", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}]}], "]"}], ",", 
     "10"}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399648092],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Times\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", 
       ",", "Orderless", ",", "Protected"}], "}"}]},
    {"\<\"Plus\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", 
       ",", "Orderless", ",", "Protected"}], "}"}]},
    {"\<\"Min\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "NumericFunction", ",", "OneIdentity", ",", "Orderless", 
       ",", "Protected"}], "}"}]},
    {"\<\"Max\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "NumericFunction", ",", "OneIdentity", ",", "Orderless", 
       ",", "Protected"}], "}"}]},
    {"\<\"LCM\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "OneIdentity", ",", "Orderless", ",", 
       "Protected"}], "}"}]},
    {"\<\"GCD\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "OneIdentity", ",", "Orderless", ",", 
       "Protected"}], "}"}]},
    {"\<\"BitXor\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "OneIdentity", ",", "Orderless", ",", 
       "Protected"}], "}"}]},
    {"\<\"BitOr\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "OneIdentity", ",", "Orderless", ",", 
       "Protected"}], "}"}]},
    {"\<\"BitAnd\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Flat", ",", "Listable", ",", "OneIdentity", ",", "Orderless", ",", 
       "Protected"}], "}"}]},
    {"\<\"ArithmeticGeometricMean\"\>", 
     RowBox[{"{", 
      RowBox[{
      "Listable", ",", "NumericFunction", ",", "Orderless", ",", "Protected", 
       ",", "ReadProtected"}], "}"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, TableDepth -> 2]]]], "Output",
 ImageSize->{635, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->69350152]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19228],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Protect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protect"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25746]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1711],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "Tutorials",
 CellID->18582],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->8077]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->4538269]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetAttributes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 56.6658134}", "context" -> "System`", 
    "keywords" -> {
     "properties", "evaluation control", "associativity", "commutativity", 
      "symbol properties", "set attributes", "evaluation properties", 
      "pattern matching properties"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SetAttributes[s, attr] adds attr to the list of attributes of the symbol \
s. ", "synonyms" -> {"set attributes"}, "title" -> "SetAttributes", "type" -> 
    "Symbol", "uri" -> "ref/SetAttributes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5839, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->163006054]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25681, 978}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2076, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2699, 78, 50, 1, 70, "ObjectName",
 CellID->7340],
Cell[2752, 81, 708, 23, 70, "Usage",
 CellID->32117]
}, Open  ]],
Cell[CellGroupData[{
Cell[3497, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3975, 126, 368, 14, 70, "Notes",
 CellID->15114],
Cell[4346, 142, 561, 20, 70, "Notes",
 CellID->20847],
Cell[4910, 164, 566, 19, 70, "Notes",
 CellID->5125],
Cell[5479, 185, 323, 12, 70, "Notes",
 CellID->8543]
}, Closed]],
Cell[CellGroupData[{
Cell[5839, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163006054],
Cell[CellGroupData[{
Cell[6224, 216, 148, 5, 70, "ExampleSection",
 CellID->240190322],
Cell[6375, 223, 138, 4, 70, "Input",
 CellID->122255626],
Cell[CellGroupData[{
Cell[6538, 231, 119, 4, 28, "Input",
 CellID->38326916],
Cell[6660, 237, 208, 7, 36, "Output",
 CellID->234947777]
}, Open  ]],
Cell[6883, 247, 125, 3, 70, "ExampleDelimiter",
 CellID->345069801],
Cell[7011, 252, 195, 6, 70, "Input",
 CellID->239033828],
Cell[CellGroupData[{
Cell[7231, 262, 180, 6, 70, "Input",
 CellID->269469891],
Cell[7414, 270, 220, 7, 36, "Output",
 CellID->32947884]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7683, 283, 218, 7, 70, "ExampleSection",
 CellID->9198436],
Cell[7904, 292, 98, 1, 70, "ExampleText",
 CellID->107071202],
Cell[8005, 295, 134, 4, 70, "Input",
 CellID->37003670],
Cell[8142, 301, 95, 1, 70, "ExampleText",
 CellID->155016438],
Cell[8240, 304, 140, 4, 70, "Input",
 CellID->143276658],
Cell[CellGroupData[{
Cell[8405, 312, 106, 3, 70, "Input",
 CellID->527160259],
Cell[8514, 317, 214, 7, 36, "Output",
 CellID->19176368]
}, Open  ]],
Cell[8743, 327, 125, 3, 70, "ExampleDelimiter",
 CellID->386106549],
Cell[8871, 332, 66, 1, 70, "ExampleText",
 CellID->112379551],
Cell[8940, 335, 195, 6, 70, "Input",
 CellID->316988704],
Cell[9138, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->134526356],
Cell[9266, 348, 86, 1, 70, "ExampleText",
 CellID->345026556],
Cell[9355, 351, 257, 8, 70, "Input",
 CellID->368338055]
}, Closed]],
Cell[CellGroupData[{
Cell[9649, 364, 237, 7, 70, "ExampleSection",
 CellID->396153603],
Cell[9889, 373, 190, 7, 70, "ExampleText",
 CellID->464779181],
Cell[10082, 382, 255, 9, 70, "Input",
 CellID->162615976],
Cell[10340, 393, 376, 12, 70, "ExampleText",
 CellID->1032991489],
Cell[10719, 407, 251, 8, 70, "Input",
 CellID->673722],
Cell[CellGroupData[{
Cell[10995, 419, 153, 5, 70, "Input",
 CellID->112979945],
Cell[11151, 426, 296, 10, 36, "Output",
 CellID->134784643]
}, Open  ]],
Cell[11462, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->191569131],
Cell[11590, 444, 238, 7, 70, "ExampleText",
 CellID->21085966],
Cell[CellGroupData[{
Cell[11853, 455, 291, 9, 70, "Input",
 CellID->30647318],
Cell[12147, 466, 221, 7, 36, "Output",
 CellID->640087322]
}, Open  ]],
Cell[12383, 476, 125, 3, 70, "ExampleDelimiter",
 CellID->565970934],
Cell[12511, 481, 233, 8, 70, "ExampleText",
 CellID->238935581],
Cell[12747, 491, 213, 7, 70, "Input",
 CellID->7697168],
Cell[12963, 500, 144, 4, 70, "Input",
 CellID->245733668],
Cell[CellGroupData[{
Cell[13132, 508, 106, 3, 70, "Input",
 CellID->260783577],
Cell[13241, 513, 215, 7, 36, "Output",
 CellID->204492869]
}, Open  ]],
Cell[13471, 523, 125, 3, 70, "ExampleDelimiter",
 CellID->228205649],
Cell[13599, 528, 243, 8, 70, "ExampleText",
 CellID->52594906],
Cell[13845, 538, 223, 7, 70, "Input",
 CellID->634542146],
Cell[CellGroupData[{
Cell[14093, 549, 153, 5, 70, "Input",
 CellID->491598477],
Cell[14249, 556, 267, 9, 36, "Output",
 CellID->54069724]
}, Open  ]],
Cell[14531, 568, 103, 2, 70, "ExampleText",
 CellID->129011084],
Cell[14637, 572, 227, 7, 70, "Input",
 CellID->133721907],
Cell[14867, 581, 125, 3, 70, "ExampleDelimiter",
 CellID->138682355],
Cell[14995, 586, 254, 8, 70, "ExampleText",
 CellID->482908561],
Cell[15252, 596, 194, 6, 70, "Input",
 CellID->513627669],
Cell[15449, 604, 266, 8, 70, "ExampleText",
 CellID->487735713],
Cell[CellGroupData[{
Cell[15740, 616, 105, 3, 70, "Input",
 CellID->112795446],
Cell[15848, 621, 164, 4, 70, "Message",
 CellID->409713807],
Cell[16015, 627, 174, 6, 36, "Output",
 CellID->80421344]
}, Open  ]],
Cell[16204, 636, 124, 3, 70, "ExampleDelimiter",
 CellID->61145867],
Cell[16331, 641, 332, 12, 70, "ExampleText",
 CellID->44046302],
Cell[CellGroupData[{
Cell[16688, 657, 118, 3, 70, "Input",
 CellID->281343092],
Cell[16809, 662, 220, 7, 36, "Output",
 CellID->149549172]
}, Open  ]],
Cell[17044, 672, 170, 6, 70, "Input",
 CellID->6852680],
Cell[17217, 680, 147, 5, 70, "ExampleText",
 CellID->662401302],
Cell[17367, 687, 143, 4, 70, "Input",
 CellID->112037164],
Cell[CellGroupData[{
Cell[17535, 695, 109, 3, 70, "Input",
 CellID->413448229],
Cell[17647, 700, 187, 6, 36, "Output",
 CellID->34313981]
}, Open  ]],
Cell[17849, 709, 157, 5, 70, "ExampleText",
 CellID->141994131],
Cell[18009, 716, 181, 6, 70, "Input",
 CellID->248856248],
Cell[CellGroupData[{
Cell[18215, 726, 163, 5, 70, "Input",
 CellID->157521117],
Cell[18381, 733, 310, 10, 36, "Output",
 CellID->391638805]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18740, 749, 228, 7, 70, "ExampleSection",
 CellID->579362210],
Cell[18971, 758, 90, 1, 70, "ExampleText",
 CellID->394708694],
Cell[CellGroupData[{
Cell[19086, 763, 775, 24, 70, "Input",
 CellID->399648092],
Cell[19864, 789, 2352, 69, 182, "Output",
 CellID->69350152]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22277, 865, 311, 9, 70, "SeeAlsoSection",
 CellID->19228],
Cell[22591, 876, 712, 26, 70, "SeeAlso",
 CellID->25746]
}, Open  ]],
Cell[CellGroupData[{
Cell[23340, 907, 313, 9, 70, "TutorialsSection",
 CellID->1711],
Cell[23656, 918, 164, 3, 70, "Tutorials",
 CellID->18582],
Cell[23823, 923, 130, 3, 70, "Tutorials",
 CellID->8077]
}, Open  ]],
Cell[CellGroupData[{
Cell[23990, 931, 299, 8, 70, "MoreAboutSection"],
Cell[24292, 941, 130, 3, 70, "MoreAbout",
 CellID->4538269]
}, Open  ]],
Cell[24437, 947, 27, 0, 70, "History"],
Cell[24467, 949, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

