(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14047,        490]
NotebookOptionsPosition[     10598,        373]
NotebookOutlinePosition[     11860,        409]
CellTagsIndexPosition[     11775,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding and Manipulating Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingAndManipulatingFiles"], 
          "Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finding and Manipulating Files\"\>", 
       2->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ResetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/ResetDirectory"], "Directory" :> 
          Documentation`HelpLookup["paclet:ref/Directory"], "DirectoryName" :> 
          Documentation`HelpLookup["paclet:ref/DirectoryName"], "$Path" :> 
          Documentation`HelpLookup["paclet:ref/$Path"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ResetDirectory\"\>", 2->"\<\"Directory\"\>", 
       3->"\<\"DirectoryName\"\>", 4->"\<\"$Path\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"File Operations\"\>", 
       4->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetDirectory", "ObjectName",
 CellID->28480],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current working directory. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14560]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 " sets the current working directory, then returns its full name. "
}], "Notes",
 CellID->5920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 " prepends the current working directory to the directory stack given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23216]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->723936896],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->63112516],

Cell["Set the current working directory:", "ExampleText",
 CellID->1267179722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "$UserDocumentsDirectory", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->894260355],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\My \
Documents\"\>"], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479223302]
}, Open  ]],

Cell[TextData[{
 "Setting the directory pushes a directory onto the ",
 Cell[BoxData[
  ButtonBox["DirectoryStack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectoryStack"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->874330505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryStack", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2060122359],

Cell[BoxData[
 RowBox[{"{", "\<\"C:\\\\Documents and Settings\\\\roger\\\\My Documents\"\>",
   "}"}]], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17758677]
}, Open  ]],

Cell["Resetting the directory:", "ExampleText",
 CellID->1706520627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResetDirectory", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->422635775],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\My \
Documents\"\>"], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->849230171]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryStack", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1559415280],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->120505278]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14055],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ResetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ResetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Path"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1539],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "Tutorials",
 CellID->12086],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->19082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->365360649],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->100033680],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->5266829],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->116210695],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->186378149]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 0.8690460}", "context" -> "System`", 
    "keywords" -> {"cd", "change directory"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SetDirectory[\"dir\"] sets the current working directory. ", 
    "synonyms" -> {"set directory", "pushd", "set directory"}, "title" -> 
    "SetDirectory", "type" -> "Symbol", "uri" -> "ref/SetDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5137, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->723936896]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11632, 397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2753, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3376, 89, 50, 1, 70, "ObjectName",
 CellID->28480],
Cell[3429, 92, 503, 15, 70, "Usage",
 CellID->14560]
}, Open  ]],
Cell[CellGroupData[{
Cell[3969, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4447, 129, 239, 7, 70, "Notes",
 CellID->5920],
Cell[4689, 138, 411, 13, 70, "Notes",
 CellID->23216]
}, Closed]],
Cell[CellGroupData[{
Cell[5137, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->723936896],
Cell[CellGroupData[{
Cell[5522, 170, 147, 5, 70, "ExampleSection",
 CellID->63112516],
Cell[5672, 177, 78, 1, 70, "ExampleText",
 CellID->1267179722],
Cell[CellGroupData[{
Cell[5775, 182, 130, 3, 28, "Input",
 CellID->894260355],
Cell[5908, 187, 221, 6, 36, "Output",
 CellID->479223302]
}, Open  ]],
Cell[6144, 196, 245, 8, 70, "ExampleText",
 CellID->874330505],
Cell[CellGroupData[{
Cell[6414, 208, 106, 3, 28, "Input",
 CellID->2060122359],
Cell[6523, 213, 243, 7, 36, "Output",
 CellID->17758677]
}, Open  ]],
Cell[6781, 223, 68, 1, 70, "ExampleText",
 CellID->1706520627],
Cell[CellGroupData[{
Cell[6874, 228, 105, 3, 70, "Input",
 CellID->422635775],
Cell[6982, 233, 221, 6, 36, "Output",
 CellID->849230171]
}, Open  ]],
Cell[CellGroupData[{
Cell[7240, 244, 106, 3, 70, "Input",
 CellID->1559415280],
Cell[7349, 249, 175, 6, 36, "Output",
 CellID->120505278]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7585, 262, 311, 9, 70, "SeeAlsoSection",
 CellID->14055],
Cell[7899, 273, 959, 35, 70, "SeeAlso",
 CellID->13340]
}, Open  ]],
Cell[CellGroupData[{
Cell[8895, 313, 313, 9, 70, "TutorialsSection",
 CellID->1539],
Cell[9211, 324, 168, 3, 70, "Tutorials",
 CellID->12086],
Cell[9382, 329, 156, 3, 70, "Tutorials",
 CellID->19082]
}, Open  ]],
Cell[CellGroupData[{
Cell[9575, 337, 319, 9, 70, "MoreAboutSection",
 CellID->365360649],
Cell[9897, 348, 179, 3, 70, "MoreAbout",
 CellID->100033680],
Cell[10079, 353, 147, 3, 70, "MoreAbout",
 CellID->5266829],
Cell[10229, 358, 141, 3, 70, "MoreAbout",
 CellID->116210695],
Cell[10373, 363, 153, 3, 70, "MoreAbout",
 CellID->186378149]
}, Open  ]],
Cell[10541, 369, 27, 0, 70, "History"],
Cell[10571, 371, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

