(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24384,        798]
NotebookOptionsPosition[     19710,        645]
NotebookOutlinePosition[     21254,        686]
CellTagsIndexPosition[     21169,        681]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Options" :> 
          Documentation`HelpLookup["paclet:tutorial/ManipulatingOptions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Options\"\>", 
       2->"\<\"CurrentValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Low-Level System Optimization" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemOptimization"],
           "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Low-Level System Optimization\"\>", 
       3->"\<\"Mathematica System Setup\"\>", 4->"\<\"Options Management\"\>",
        5->"\<\"Package Development\"\>", 6->"\<\"Palettes\"\>", 
       7->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       8->"\<\"Session Customization\"\>", 
       9->"\<\"Toolbars\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetOptions", "ObjectName",
 CellID->30797],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetOptions"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["name", "TI"], 
          StyleBox["1", "TR"]], "->", 
         SubscriptBox[
          StyleBox["value", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["name", "TI"], 
          StyleBox["2", "TR"]], "->", 
         SubscriptBox[
          StyleBox["value", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the specified default options for a symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetOptions"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetOptions"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     "sets options associated with a particular stream. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetOptions"], "[", 
       RowBox[{
        StyleBox["object", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets options associated with an external object such as \
a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->2906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " is equivalent to an assignment which redefines certain elements of the \
list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " of default options. "
}], "Notes",
 CellID->26887],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " symbols. "
}], "Notes",
 CellID->4721],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " returns the new form of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31248],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " on ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " objects. If there is only one stream with a particular name, you can give \
the name as a string as the argument of ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22030],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " can be used on a list of streams, such as the value of ",
 Cell[BoxData[
  ButtonBox["$Output",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Output"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3638],

Cell[TextData[{
 "If you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["NotebookObject",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookObject"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " the kernel will send a request to the front end which will immediately \
make the change specified. "
}], "Notes",
 CellID->13125]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->237255965],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->286543819],

Cell[TextData[{
 "Reset the default precision for ",
 Cell[BoxData[
  ButtonBox["HilbertMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HilbertMatrix"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->279440923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"HilbertMatrix", ",", " ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168438666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}], 
  "}"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->589307646]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["HilbertMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HilbertMatrix"]], "InlineFormula"],
 " uses machine numbers by default:"
}], "ExampleText",
 CellID->35327198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HilbertMatrix", "[", "2", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58507649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.3333333333333333`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44756517]
}, Open  ]],

Cell["A specific option setting overrides the new default:", "ExampleText",
 CellID->50768548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HilbertMatrix", "[", 
  RowBox[{"2", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->388359139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "0.5`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`20.", ",", "0.33333333333333333333333333333333333333`20."}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{352, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->400505380]
}, Open  ]],

Cell["Restore the system default:", "ExampleText",
 CellID->420490595],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"HilbertMatrix", ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "\[Infinity]"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->456268638],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19162427],

Cell["Change the style for plots to use dashed curves:", "ExampleText",
 CellID->178235612],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", 
       RowBox[{".05", ",", ".01"}], "}"}], "]"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174489049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->399306029],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320434912]
}, Open  ]],

Cell["Restore the system default:", "ExampleText",
 CellID->84944995],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Automatic"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->188830583]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19614],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1464],

Cell[TextData[ButtonBox["Manipulating Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingOptions"]], "Tutorials",
 CellID->2793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->36978474],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->543644963],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->340711798],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->45781500],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->508126],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->31539556],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->43885143],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->290253722],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->411283650],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->710927]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 2.7440940}", "context" -> "System`", 
    "keywords" -> {
     "notebooks", "options for streams", "reset medium", 
      "set default options"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SetOptions[s, name_1 -> value_1, name_2 -> value_2, ...] sets the \
specified default options for a symbol s. SetOptions[stream, ...] or \
SetOptions[\"name\", ...] sets options associated with a particular stream. \
SetOptions[object, ...] sets options associated with an external object such \
as a NotebookObject. ", "synonyms" -> {"set options"}, "title" -> 
    "SetOptions", "type" -> "Symbol", "uri" -> "ref/SetOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9376, 302, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->237255965]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21026, 674}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3120, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3743, 96, 48, 1, 70, "ObjectName",
 CellID->30797],
Cell[3794, 99, 2290, 72, 70, "Usage",
 CellID->2906]
}, Open  ]],
Cell[CellGroupData[{
Cell[6121, 176, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6599, 193, 444, 15, 70, "Notes",
 CellID->26887],
Cell[7046, 210, 322, 12, 70, "Notes",
 CellID->4721],
Cell[7371, 224, 371, 14, 70, "Notes",
 CellID->31248],
Cell[7745, 240, 700, 24, 70, "Notes",
 CellID->22030],
Cell[8448, 266, 350, 12, 70, "Notes",
 CellID->3638],
Cell[8801, 280, 538, 17, 70, "Notes",
 CellID->13125]
}, Closed]],
Cell[CellGroupData[{
Cell[9376, 302, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->237255965],
Cell[CellGroupData[{
Cell[9761, 316, 148, 5, 70, "ExampleSection",
 CellID->286543819],
Cell[9912, 323, 225, 8, 70, "ExampleText",
 CellID->279440923],
Cell[CellGroupData[{
Cell[10162, 335, 209, 6, 28, "Input",
 CellID->168438666],
Cell[10374, 343, 243, 8, 36, "Output",
 CellID->589307646]
}, Open  ]],
Cell[10632, 354, 228, 8, 70, "ExampleText",
 CellID->35327198],
Cell[CellGroupData[{
Cell[10885, 366, 108, 3, 28, "Input",
 CellID->58507649],
Cell[10996, 371, 327, 11, 36, "Output",
 CellID->44756517]
}, Open  ]],
Cell[11338, 385, 94, 1, 70, "ExampleText",
 CellID->50768548],
Cell[CellGroupData[{
Cell[11457, 390, 178, 5, 70, "Input",
 CellID->388359139],
Cell[11638, 397, 367, 12, 54, "Output",
 CellID->400505380]
}, Open  ]],
Cell[12020, 412, 70, 1, 70, "ExampleText",
 CellID->420490595],
Cell[12093, 415, 219, 7, 70, "Input",
 CellID->456268638],
Cell[12315, 424, 124, 3, 70, "ExampleDelimiter",
 CellID->19162427],
Cell[12442, 429, 91, 1, 70, "ExampleText",
 CellID->178235612],
Cell[12536, 432, 286, 9, 70, "Input",
 CellID->174489049],
Cell[CellGroupData[{
Cell[12847, 445, 297, 10, 28, "Input",
 CellID->399306029],
Cell[13147, 457, 3080, 55, 140, "Output",
 Evaluatable->False,
 CellID->320434912]
}, Open  ]],
Cell[16242, 515, 69, 1, 70, "ExampleText",
 CellID->84944995],
Cell[16314, 518, 198, 6, 70, "Input",
 CellID->188830583]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16561, 530, 311, 9, 70, "SeeAlsoSection",
 CellID->19614],
Cell[16875, 541, 457, 17, 70, "SeeAlso",
 CellID->20234]
}, Open  ]],
Cell[CellGroupData[{
Cell[17369, 563, 313, 9, 70, "TutorialsSection",
 CellID->1464],
Cell[17685, 574, 149, 3, 70, "Tutorials",
 CellID->2793]
}, Open  ]],
Cell[CellGroupData[{
Cell[17871, 582, 318, 9, 70, "MoreAboutSection",
 CellID->36978474],
Cell[18192, 593, 169, 3, 70, "MoreAbout",
 CellID->543644963],
Cell[18364, 598, 167, 3, 70, "MoreAbout",
 CellID->340711798],
Cell[18534, 603, 157, 3, 70, "MoreAbout",
 CellID->45781500],
Cell[18694, 608, 144, 3, 70, "MoreAbout",
 CellID->508126],
Cell[18841, 613, 148, 3, 70, "MoreAbout",
 CellID->31539556],
Cell[18992, 618, 127, 3, 70, "MoreAbout",
 CellID->43885143],
Cell[19122, 623, 209, 5, 70, "MoreAbout",
 CellID->290253722],
Cell[19334, 630, 153, 3, 70, "MoreAbout",
 CellID->411283650],
Cell[19490, 635, 125, 3, 70, "MoreAbout",
 CellID->710927]
}, Open  ]],
Cell[19630, 641, 50, 0, 70, "History"],
Cell[19683, 643, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

