(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14081,        511]
NotebookOptionsPosition[     10283,        382]
NotebookOutlinePosition[     11616,        420]
CellTagsIndexPosition[     11531,        415]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Searching Files" :> 
          Documentation`HelpLookup["paclet:tutorial/SearchingFiles"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Searching Files\"\>", 
       2->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Skip" :> Documentation`HelpLookup["paclet:ref/Skip"], 
          "StreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/StreamPosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Skip\"\>", 
       2->"\<\"StreamPosition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Files\"\>", 
       2->"\<\"Low-Level File Operations\"\>", 
       3->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetStreamPosition", "ObjectName",
 CellID->9747],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetStreamPosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetStreamPosition"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current point in an open stream. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " given to ",
 Cell[BoxData[
  ButtonBox["SetStreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFormula"],
 " should usually be a value obtained from ",
 Cell[BoxData[
  ButtonBox["StreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StreamPosition"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24828],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetStreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetStreamPosition"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " sets the current point to the beginning of a stream. "
}], "Notes",
 CellID->15174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetStreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetStreamPosition"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "]"}]], "InlineFormula"],
 " sets the current point to the end of a stream. "
}], "Notes",
 CellID->6186]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->259936425],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39264913],

Cell["Open a stream:", "ExampleText",
 CellID->2102684787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<123 456 789\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1322990999],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "35"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2135312118]
}, Open  ]],

Cell["Read the first number from the stream object:", "ExampleText",
 CellID->1373008897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1448744864],

Cell[BoxData["123"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1591542209]
}, Open  ]],

Cell["Modify the current point in the stream:", "ExampleText",
 CellID->95057581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStreamPosition", "[", 
  RowBox[{"str", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482938930],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2141083278]
}, Open  ]],

Cell["Read a number from the stream object:", "ExampleText",
 CellID->832320077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1592955828],

Cell[BoxData["789"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1950664214]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->2052414146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1418257024],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1328089596]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5752],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StreamPosition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4587],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "Tutorials",
 CellID->14418],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->59647788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->365640190],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->853125504],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->157194062],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->435909711]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetStreamPosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 4.4003864}", "context" -> "System`", 
    "keywords" -> {
     "file pointer position", "random access", "random access to files", 
      "seek"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "SetStreamPosition[stream, n] sets the current point in an open stream. ",
     "synonyms" -> {"set stream position"}, "title" -> "SetStreamPosition", 
    "type" -> "Symbol", "uri" -> "ref/SetStreamPosition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5268, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->259936425]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11388, 408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2296, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2919, 82, 54, 1, 70, "ObjectName",
 CellID->9747],
Cell[2976, 85, 561, 17, 70, "Usage",
 CellID->21221]
}, Open  ]],
Cell[CellGroupData[{
Cell[3574, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4052, 124, 453, 16, 70, "Notes",
 CellID->24828],
Cell[4508, 142, 320, 10, 70, "Notes",
 CellID->15174],
Cell[4831, 154, 400, 13, 70, "Notes",
 CellID->6186]
}, Closed]],
Cell[CellGroupData[{
Cell[5268, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->259936425],
Cell[CellGroupData[{
Cell[5653, 186, 147, 5, 70, "ExampleSection",
 CellID->39264913],
Cell[5803, 193, 58, 1, 70, "ExampleText",
 CellID->2102684787],
Cell[CellGroupData[{
Cell[5886, 198, 154, 4, 28, "Input",
 CellID->1322990999],
Cell[6043, 204, 226, 7, 36, "Output",
 CellID->2135312118]
}, Open  ]],
Cell[6284, 214, 89, 1, 70, "ExampleText",
 CellID->1373008897],
Cell[CellGroupData[{
Cell[6398, 219, 131, 4, 28, "Input",
 CellID->1448744864],
Cell[6532, 225, 161, 5, 36, "Output",
 CellID->1591542209]
}, Open  ]],
Cell[6708, 233, 81, 1, 70, "ExampleText",
 CellID->95057581],
Cell[CellGroupData[{
Cell[6814, 238, 138, 4, 70, "Input",
 CellID->482938930],
Cell[6955, 244, 159, 5, 36, "Output",
 CellID->2141083278]
}, Open  ]],
Cell[7129, 252, 80, 1, 70, "ExampleText",
 CellID->832320077],
Cell[CellGroupData[{
Cell[7234, 257, 131, 4, 70, "Input",
 CellID->1592955828],
Cell[7368, 263, 161, 5, 36, "Output",
 CellID->1950664214]
}, Open  ]],
Cell[7544, 271, 61, 1, 70, "ExampleText",
 CellID->2052414146],
Cell[CellGroupData[{
Cell[7630, 276, 104, 3, 70, "Input",
 CellID->1418257024],
Cell[7737, 281, 164, 5, 36, "Output",
 CellID->1328089596]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7962, 293, 310, 9, 70, "SeeAlsoSection",
 CellID->5752],
Cell[8275, 304, 455, 17, 70, "SeeAlso",
 CellID->20798]
}, Open  ]],
Cell[CellGroupData[{
Cell[8767, 326, 313, 9, 70, "TutorialsSection",
 CellID->4587],
Cell[9083, 337, 140, 3, 70, "Tutorials",
 CellID->14418],
Cell[9226, 342, 194, 4, 70, "Tutorials",
 CellID->59647788]
}, Open  ]],
Cell[CellGroupData[{
Cell[9457, 351, 319, 9, 70, "MoreAboutSection",
 CellID->365640190],
Cell[9779, 362, 122, 3, 70, "MoreAbout",
 CellID->853125504],
Cell[9904, 367, 159, 3, 70, "MoreAbout",
 CellID->157194062],
Cell[10066, 372, 145, 3, 70, "MoreAbout",
 CellID->435909711]
}, Open  ]],
Cell[10226, 378, 27, 0, 70, "History"],
Cell[10256, 380, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

