(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16912,        565]
NotebookOptionsPosition[     13875,        461]
NotebookOutlinePosition[     15094,        497]
CellTagsIndexPosition[     15009,        492]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DynamicSetting" :> 
          Documentation`HelpLookup["paclet:ref/DynamicSetting"], "Options" :> 
          Documentation`HelpLookup["paclet:ref/Options"], "Slider" :> 
          Documentation`HelpLookup["paclet:ref/Slider"], "Checkbox" :> 
          Documentation`HelpLookup["paclet:ref/Checkbox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DynamicSetting\"\>", 
       2->"\<\"Options\"\>", 3->"\<\"Slider\"\>", 
       4->"\<\"Checkbox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Control Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Setting", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Setting",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Setting"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces control objects such as sliders or popup menus \
in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by their settings. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a control object, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Setting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setting"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " normally extracts the first argument of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27576],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Setting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setting"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " replaces dynamic objects in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " by their current values. "
}], "Notes",
 CellID->1378],

Cell[TextData[{
 "When applied to the object created by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " gives the value of ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " evaluated with the current settings for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184570522],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->149558911],

Cell["Find the setting for a slider:", "ExampleText",
 CellID->14326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  SliderBox[0.166], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25362],

Cell[BoxData["0.166`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->703]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22600],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " handles any expression, replacing controls by their settings:"
}], "ExampleText",
 CellID->20158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    SliderBox[0.896], ",", 
    SliderBox[0.725], ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "0.896`", ",", "0.725`", ",", "y"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"tmax", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477632872],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`tmax$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`tmax$$], 1, 10}}, Typeset`size$$ = {180., 115.}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`tmax$334$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`tmax$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`tmax$$, $CellContext`tmax$334$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`t], {$CellContext`t, 0, $CellContext`tmax$$}], 
      "Specifications" :> {{$CellContext`tmax$$, 1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{265., {100., 105.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{269, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446546012]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Setting", "[", 
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`tmax$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`tmax$$], 1, 10}}, Typeset`size$$ = {225., 143.}, 
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`tmax$334$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`tmax$$ = 1}, 
       "ControllerVariables" :> {
         Hold[$CellContext`tmax$$, $CellContext`tmax$334$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Plot[
         Sin[$CellContext`t], {$CellContext`t, 0, $CellContext`tmax$$}], 
       "Specifications" :> {{$CellContext`tmax$$, 1, 10}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{271., {114., 119.}}],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24464]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25358],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicSetting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24131]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->44655263],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->393232026]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 11.6974482}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Setting[expr] replaces control objects such as sliders or popup menus in \
expr by their settings. ", "synonyms" -> {}, "title" -> "Setting", "type" -> 
    "Symbol", "uri" -> "ref/Setting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6418, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->184570522]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14866, 485}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1452, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2075, 62, 1572, 37, 70, "ObjectNameGrid"],
Cell[3650, 101, 601, 19, 70, "Usage",
 CellID->13787]
}, Open  ]],
Cell[CellGroupData[{
Cell[4288, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4766, 142, 424, 16, 70, "Notes",
 CellID->27576],
Cell[5193, 160, 338, 12, 70, "Notes",
 CellID->1378],
Cell[5534, 174, 847, 31, 70, "Notes",
 CellID->11088]
}, Closed]],
Cell[CellGroupData[{
Cell[6418, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184570522],
Cell[CellGroupData[{
Cell[6803, 224, 148, 5, 70, "ExampleSection",
 CellID->149558911],
Cell[6954, 231, 69, 1, 70, "ExampleText",
 CellID->14326],
Cell[CellGroupData[{
Cell[7048, 236, 115, 4, 37, "Input",
 CellID->25362],
Cell[7166, 242, 157, 5, 36, "Output",
 CellID->703]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7372, 253, 216, 7, 70, "ExampleSection",
 CellID->22600],
Cell[7591, 262, 233, 7, 70, "ExampleText",
 CellID->20158],
Cell[CellGroupData[{
Cell[7849, 273, 202, 7, 70, "Input",
 CellID->24347],
Cell[8054, 282, 230, 7, 36, "Output",
 CellID->12473]
}, Open  ]],
Cell[8299, 292, 121, 3, 70, "ExampleDelimiter",
 CellID->23028],
Cell[CellGroupData[{
Cell[8445, 299, 348, 11, 70, "Input",
 CellID->477632872],
Cell[8796, 312, 1607, 35, 70, "Output",
 CellID->446546012]
}, Open  ]],
Cell[10418, 350, 1576, 33, 70, "Input",
 CellID->24464]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12043, 389, 311, 9, 70, "SeeAlsoSection",
 CellID->25358],
Cell[12357, 400, 947, 35, 70, "SeeAlso",
 CellID->24131]
}, Open  ]],
Cell[CellGroupData[{
Cell[13341, 440, 318, 9, 70, "MoreAboutSection",
 CellID->44655263],
Cell[13662, 451, 141, 3, 70, "MoreAbout",
 CellID->393232026]
}, Open  ]],
Cell[13818, 457, 27, 0, 70, "History"],
Cell[13848, 459, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

