(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22437,        798]
NotebookOptionsPosition[     17950,        645]
NotebookOutlinePosition[     19380,        685]
CellTagsIndexPosition[     19295,        680]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controlling the Display of Large Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingTheDisplayOfLargeExpressions"], 
          "Short and Shallow Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ShortAndShallowOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Controlling the Display of Large Expressions\"\>", 
       2->"\<\"Short and Shallow Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Shallow" :> Documentation`HelpLookup["paclet:ref/Shallow"], 
          "Format" :> Documentation`HelpLookup["paclet:ref/Format"], 
          "Skeleton" :> Documentation`HelpLookup["paclet:ref/Skeleton"], 
          "StringSkeleton" :> 
          Documentation`HelpLookup["paclet:ref/StringSkeleton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Shallow\"\>", 2->"\<\"Format\"\>", 
       3->"\<\"Skeleton\"\>", 
       4->"\<\"StringSkeleton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Memory Measurement & Optimization\"\>", 
       2->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Short", "ObjectName",
 CellID->23298],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Short",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Short"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a short form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", less than about one line long. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Short",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Short"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " about ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " lines long. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25368]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives a \[OpenCurlyDoubleQuote]skeleton form\[CloseCurlyDoubleQuote] of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", with omitted sequences of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " elements indicated by ",
 Cell[BoxData[
  RowBox[{"\[LeftSkeleton]", 
   StyleBox["k", "TI"], "\[RightSkeleton]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27094],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", the characters used for this output are ",
 Cell[TextData[ButtonBox["\\[LeftSkeleton]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftSkeleton"]], "InlineCharacterName"],
 " and ",
 Cell[TextData[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightSkeleton"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24845],

Cell[TextData[{
 "Omitted sequences of elements are printed as ",
 Cell[BoxData[
  ButtonBox["Skeleton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->24515],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " prints long strings in skeleton form. "
}], "Notes",
 CellID->25216],

Cell["The number of lines specified need not be an integer. ", "Notes",
 CellID->6614],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and other formats as well as ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16545],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->909],

Cell[TextData[{
 "Trying to feed ",
 Cell[BoxData[
  RowBox[{"\[LeftSkeleton]", 
   StyleBox["k", "TI"], "\[RightSkeleton]"}]], "InlineFormula"],
 " as obtained from ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " back as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " will generate an error. "
}], "Notes",
 CellID->31699],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " is used to limit the length of output in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " warning and other messages. "
}], "Notes",
 CellID->23318]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->328401755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->515798629],

Cell["Shorten the display of a large polynomial to about one line:", \
"ExampleText",
 CellID->267154506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", "y"}], ")"}], "^", "12"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383926679],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"\[LeftSkeleton]", "81", "\[RightSkeleton]"}], "+", 
   RowBox[{"132", " ", "x", " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   RowBox[{"12", " ", "x", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   SuperscriptBox["y", "12"]}],
  Short]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->53226217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->981221704],

Cell["Allow about three lines:", "ExampleText",
 CellID->309856423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", "y"}], ")"}], "^", "12"}], "]"}], ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16437613],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"792", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"924", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"792", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   RowBox[{"\[LeftSkeleton]", "69", "\[RightSkeleton]"}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"660", " ", "x", " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"660", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"132", " ", "x", " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   RowBox[{"12", " ", "x", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   SuperscriptBox["y", "12"]}],
  Short[#, 3]& ]], "Output",
 ImageSize->{436, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->449062315]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22336],

Cell[TextData[{
 "Shortened outputs contain ",
 Cell[BoxData[
  ButtonBox["Skeleton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->387276236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23303860],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
    RowBox[{"\[LeftSkeleton]", "75", "\[RightSkeleton]"}], ",", "89", ",", 
    "90", ",", "91", ",", "92", ",", "93", ",", "94", ",", "95", ",", "96", 
    ",", "97", ",", "98", ",", "99", ",", "100"}], "}"}],
  Short]], "Output",
 ImageSize->{370, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->546242004]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skeleton", "[", "75", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171444880],

Cell[BoxData[
 RowBox[{"\[LeftSkeleton]", "75", "\[RightSkeleton]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->429877726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34061312],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " displays with long expressions shortened from the end:"
}], "ExampleText",
 CellID->92603155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33117029],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
    RowBox[{"\[LeftSkeleton]", "75", "\[RightSkeleton]"}], ",", "89", ",", 
    "90", ",", "91", ",", "92", ",", "93", ",", "94", ",", "95", ",", "96", 
    ",", "97", ",", "98", ",", "99", ",", "100"}], "}"}],
  Short]], "Output",
 ImageSize->{370, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->179719024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253926417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Shallow=",
 CellID->559925888]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16312],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shallow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shallow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skeleton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skeleton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSkeleton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSkeleton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->894],

Cell[TextData[ButtonBox["Controlling the Display of Large Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ControllingTheDisplayOfLargeExpressions"]], "Tutorials",
 CellID->7265],

Cell[TextData[ButtonBox["Short and Shallow Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ShortAndShallowOutput"]], "Tutorials",
 CellID->11603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->240079816],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->66655716],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->344612140]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Short - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 20.3226690}", "context" -> "System`", 
    "keywords" -> {
     "compressed form", "concise form", "elided output", "one-line output", 
      "outline", "short output", "skeleton output", "small output", 
      "left and right tree"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Short[expr] prints as a short form of expr, less than about one line \
long. Short[expr, n] prints as a form of expr about n lines long. ", 
    "synonyms" -> {}, "title" -> "Short", "type" -> "Symbol", "uri" -> 
    "ref/Short"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8025, 273, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->328401755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19152, 673}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2500, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3123, 86, 43, 1, 70, "ObjectName",
 CellID->23298],
Cell[3169, 89, 1075, 35, 70, "Usage",
 CellID->25368]
}, Open  ]],
Cell[CellGroupData[{
Cell[4281, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4759, 146, 583, 19, 70, "Notes",
 CellID->27094],
Cell[5345, 167, 530, 16, 70, "Notes",
 CellID->24845],
Cell[5878, 185, 227, 8, 70, "Notes",
 CellID->24515],
Cell[6108, 195, 200, 7, 70, "Notes",
 CellID->25216],
Cell[6311, 204, 86, 1, 70, "Notes",
 CellID->6614],
Cell[6400, 207, 465, 17, 70, "Notes",
 CellID->16545],
Cell[6868, 226, 272, 8, 70, "Notes",
 CellID->909],
Cell[7143, 236, 547, 20, 70, "Notes",
 CellID->31699],
Cell[7693, 258, 295, 10, 70, "Notes",
 CellID->23318]
}, Closed]],
Cell[CellGroupData[{
Cell[8025, 273, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->328401755],
Cell[CellGroupData[{
Cell[8410, 287, 148, 5, 70, "ExampleSection",
 CellID->515798629],
Cell[8561, 294, 105, 2, 70, "ExampleText",
 CellID->267154506],
Cell[CellGroupData[{
Cell[8691, 300, 223, 8, 28, "Input",
 CellID->383926679],
Cell[8917, 310, 822, 26, 36, "Output",
 CellID->53226217]
}, Open  ]],
Cell[9754, 339, 125, 3, 70, "ExampleDelimiter",
 CellID->981221704],
Cell[9882, 344, 67, 1, 70, "ExampleText",
 CellID->309856423],
Cell[CellGroupData[{
Cell[9974, 349, 250, 9, 70, "Input",
 CellID->16437613],
Cell[10227, 360, 1693, 53, 71, "Output",
 CellID->449062315]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11969, 419, 233, 7, 70, "ExampleSection",
 CellID->22336],
Cell[12205, 428, 217, 8, 70, "ExampleText",
 CellID->387276236],
Cell[CellGroupData[{
Cell[12447, 440, 134, 4, 70, "Input",
 CellID->23303860],
Cell[12584, 446, 563, 14, 54, "Output",
 CellID->546242004]
}, Open  ]],
Cell[CellGroupData[{
Cell[13184, 465, 105, 3, 70, "Input",
 CellID->171444880],
Cell[13292, 470, 210, 6, 36, "Output",
 CellID->429877726]
}, Open  ]],
Cell[13517, 479, 124, 3, 70, "ExampleDelimiter",
 CellID->34061312],
Cell[13644, 484, 229, 7, 70, "ExampleText",
 CellID->92603155],
Cell[CellGroupData[{
Cell[13898, 495, 134, 4, 70, "Input",
 CellID->33117029],
Cell[14035, 501, 563, 14, 54, "Output",
 CellID->179719024]
}, Open  ]],
Cell[CellGroupData[{
Cell[14635, 520, 137, 4, 70, "Input",
 CellID->253926417],
Cell[14775, 526, 365, 10, 50, "Output",
 CellID->559925888]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15201, 543, 311, 9, 70, "SeeAlsoSection",
 CellID->16312],
Cell[15515, 554, 947, 35, 70, "SeeAlso",
 CellID->20463]
}, Open  ]],
Cell[CellGroupData[{
Cell[16499, 594, 312, 9, 70, "TutorialsSection",
 CellID->894],
Cell[16814, 605, 196, 4, 70, "Tutorials",
 CellID->7265],
Cell[17013, 611, 156, 3, 70, "Tutorials",
 CellID->11603]
}, Open  ]],
Cell[CellGroupData[{
Cell[17206, 619, 319, 9, 70, "MoreAboutSection",
 CellID->240079816],
Cell[17528, 630, 176, 3, 70, "MoreAbout",
 CellID->66655716],
Cell[17707, 635, 148, 3, 70, "MoreAbout",
 CellID->344612140]
}, Open  ]],
Cell[17870, 641, 50, 0, 70, "History"],
Cell[17923, 643, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

