(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23665,        647]
NotebookOptionsPosition[     19921,        524]
NotebookOutlinePosition[     21628,        573]
CellTagsIndexPosition[     21510,        567]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellLabel" :> Documentation`HelpLookup["paclet:ref/CellLabel"],
           "ShowCellTags" :> 
          Documentation`HelpLookup["paclet:ref/ShowCellTags"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellLabel\"\>", 
       2->"\<\"ShowCellTags\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Managing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ManagingComputationsInNotebooks"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Managing Computations in Notebooks\"\>", 
       3->"\<\"Mathematica Session History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowCellLabel", "ObjectName",
 CellID->8474],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShowCellLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShowCellLabel"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether to display the label for a cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowCellLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowCellLabel"]], "InlineFormula"],
 " is more often set for styles of cells than for individual cells. "
}], "Notes",
 CellID->17287],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellLabelAutoDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellLabelAutoDelete"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the label for a cell is automatically deleted if the cell is modified. "
}], "Notes",
 CellID->4779]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->872446543],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->192092489],

Cell[TextData[{
 "Create one input cell with ",
 Cell[BoxData[
  RowBox[{"ShowCellLabel", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and one with ",
 Cell[BoxData[
  RowBox[{"ShowCellLabel", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->785733020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ExpressionCell", "[", 
       RowBox[{
        RowBox[{"Defer", "[", 
         RowBox[{"1", "+", "1"}], "]"}], ",", "\"\<Input\>\"", ",", 
        RowBox[{"ShowCellLabel", "\[Rule]", "True"}], ",", 
        RowBox[{"CellTags", "\[Rule]", "\"\<expl1\>\""}]}], "]"}], ",", 
      RowBox[{"ExpressionCell", "[", 
       RowBox[{
        RowBox[{"Defer", "[", 
         RowBox[{"2", "+", "2"}], "]"}], ",", "\"\<Input\>\"", ",", 
        RowBox[{"ShowCellLabel", "\[Rule]", "False"}], ",", 
        RowBox[{"CellTags", "\[Rule]", "\"\<expl2\>\""}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124822837],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9vU1Ucx/EZnxv/Bf8VfzzVYIwJmggjMlBDCMYHJiY+MAIqYkRg48cY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   "], {{0, 0}, {458, 86}}, {0, 255}],
  ImageSize->{458 0.75, 86 0.75},
  PlotRange->{{0, 458}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->78651112]
}, Open  ]],

Cell["\<\
Labels are set when the cells are evaluated, but the second input cell's \
label is hidden:\
\>", "ExampleText",
 CellID->193075922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}], ";", 
  RowBox[{"SelectionEvaluate", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288811963],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6fd7Jv9B/pT+e6ujkiXWmEaciaSfD2OkDZzrTB5matDHp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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->487441853]
}, Open  ]],

Cell[TextData[{
 "You can see the label by turning ",
 Cell[BoxData[
  ButtonBox["ShowCellLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowCellLabel"]], "InlineFormula"],
 " on again:"
}], "ExampleText",
 CellID->392042321],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<expl2\>\"", ",", "Next", ",", "CellTags"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{
    RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
    RowBox[{"ShowCellLabel", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->77562081],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6nemTdjqZ6V+Q6V/Rp/3xrNXR5ol1phFTkbSTYezkgTOZ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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->27044429]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8908],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowCellTags",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellTags"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22298]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26873],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->24145]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->63163196],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->194145398],

Cell[TextData[ButtonBox["Managing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManagingComputationsInNotebooks"]], "MoreAbout",
 CellID->841431793],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->52894587]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowCellLabel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 22.8071076}", "context" -> "System`", 
    "keywords" -> {
     "cell labels", "input labels", "output labels", "in out labels", 
      "history labels"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ShowCellLabel is an option for Cell which specifies whether to display \
the label for a cell. ", "synonyms" -> {"show cell label"}, "title" -> 
    "ShowCellLabel", "type" -> "Symbol", "uri" -> "ref/ShowCellLabel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4681, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->872446543]},
 "Notebook Image"->{
  Cell[6421, 212, 2739, 48, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->78651112],
  Cell[9566, 279, 3645, 62, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->487441853],
  Cell[13868, 369, 3795, 65, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->27044429]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21037, 550},
 {"Notebook Image", 21178, 554}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2218, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2841, 81, 50, 1, 70, "ObjectName",
 CellID->8474],
Cell[2894, 84, 603, 18, 70, "Usage",
 CellID->9008]
}, Open  ]],
Cell[CellGroupData[{
Cell[3534, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4012, 124, 243, 7, 70, "Notes",
 CellID->17287],
Cell[4258, 133, 386, 12, 70, "Notes",
 CellID->4779]
}, Closed]],
Cell[CellGroupData[{
Cell[4681, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->872446543],
Cell[CellGroupData[{
Cell[5066, 164, 148, 5, 70, "ExampleSection",
 CellID->192092489],
Cell[5217, 171, 412, 15, 70, "ExampleText",
 CellID->785733020],
Cell[CellGroupData[{
Cell[5654, 190, 764, 20, 70, "Input",
 CellID->124822837],
Cell[6421, 212, 2739, 48, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->78651112]
}, Open  ]],
Cell[9175, 263, 142, 4, 70, "ExampleText",
 CellID->193075922],
Cell[CellGroupData[{
Cell[9342, 271, 221, 6, 70, "Input",
 CellID->288811963],
Cell[9566, 279, 3645, 62, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->487441853]
}, Open  ]],
Cell[13226, 344, 235, 8, 70, "ExampleText",
 CellID->392042321],
Cell[CellGroupData[{
Cell[13486, 356, 379, 11, 70, "Input",
 CellID->77562081],
Cell[13868, 369, 3795, 65, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->27044429]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17724, 441, 310, 9, 70, "SeeAlsoSection",
 CellID->8908],
Cell[18037, 452, 461, 17, 70, "SeeAlso",
 CellID->22298]
}, Open  ]],
Cell[CellGroupData[{
Cell[18535, 474, 314, 9, 70, "TutorialsSection",
 CellID->26873],
Cell[18852, 485, 143, 3, 70, "Tutorials",
 CellID->24145]
}, Open  ]],
Cell[CellGroupData[{
Cell[19032, 493, 318, 9, 70, "MoreAboutSection",
 CellID->63163196],
Cell[19353, 504, 150, 3, 70, "MoreAbout",
 CellID->194145398],
Cell[19506, 509, 177, 3, 70, "MoreAbout",
 CellID->841431793],
Cell[19686, 514, 163, 3, 70, "MoreAbout",
 CellID->52894587]
}, Open  ]],
Cell[19864, 520, 27, 0, 70, "History"],
Cell[19894, 522, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

